<?php

/**
 * TtemplateController
 * Admin controller for team templates
 * @author Precurio Team
 * @version 4.3
 */

require_once ('admin/controllers/BaseController.php');
require_once ('team/models/vo/Template.php');
class Admin_TtemplateController extends Admin_BaseController {
    function generateList($searchText) {
    
        $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TEAM_TEMPLATES,'rowClass'=>'Template'));
        $items = $table->fetchAll($table->select()->where('active=1'));
    
        $arr = array();
        $i = 1;
        foreach($items as $item)
        {
            if(!Precurio_Utils::isNull($searchText))
            {
                if(stripos($item->title,$searchText)===FALSE)
                {
                    if(stripos($item->description,$searchText)===FALSE)
                    {
                        continue;
                    }
                }
            }
    
            $arr[] = array($i++,'title'=>$item->title,'description'=>$item->description,'id'=>$item->id);
        }
        return $arr;
    }
    function getPageTitle() {
        return $this->translate('Team Room Templates');
    }
    
    function getTableName() {
        return PrecurioTableConstants::TEAM_TEMPLATES;
    }
    function generateHeader() {
        return array('',$this->translate('Template'),$this->translate('Description'));
    }
    function getForm($item = null, $viewMode = false)
    {
        
    }
    
}
?>