<?php
require_once ('admin/controllers/PageController.php');
class Admin_SitePageController extends Admin_PageController {

	function generateList($searchText) {
		$site_id = $this->getRequest()->getParam('site_id');
		$site = Site::get($site_id);
		$items = $site->getPages();
		$arr = array();
		$i = 1;
		foreach($items as $item)
		{
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($item->getTitle(),$searchText)===FALSE)
				{
					continue;
				}
			}
			$parent = $item->getParent();
			$parent = empty($parent) ? '' : $parent->getTitle();
			$arr[] = array($i++,'title'=>$item->getTitle(),'date'=>$item->getDateAdded(),'id'=>$item->getContentId());
		}
		$this->view->tableOptions = array("edit_href"=>" href='".$this->getRequest()->getBaseUrl().'/admin/'.$this->getRequest()->getControllerName().'/edit/site_id/'.$site_id.'/'."id/%1\$s' ");
		return $arr;
	}
	public function indexAction()
	{
		$searchText = $this->getRequest()->getParam('search','');
		$site_id = $this->getRequest()->getParam('site_id');

		$this->view->searchText = $searchText;
		$this->view->list =  $this->generateList($searchText);
		$this->view->header = $this->generateHeader();
		$this->view->pageTitle = $this->getPageTitle();
		$this->view->pathToController = $this->getRequest()->getBaseUrl().'/admin/'.$this->getRequest()->getControllerName().'/index/site_id/'.$site_id.'/';
		$this->view->table = $this->getTableName();
		$this->view->cpage = $this->getRequest()->getParam('cpage',$this->getRequest()->getParam('page',1));
		$this->view->errorMessages = implode('<br/>',$this->_helper->flashMessenger->getMessages());
		$this->view->site = Site::get($site_id);
		$this->view->section = "page";
		$this->renderScript('views/admin/site/edit.phtml');
	}
	public function preDispatch()
	{
		$this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_ADMIN);
		$this->view->module = "sitepage";
		$site_id = $this->getRequest()->getParam('site_id');
		$this->view->site = Site::get($site_id);
		$this->view->pathToController = $this->getRequest()->getBaseUrl().'/admin/'.$this->getRequest()->getControllerName().'/index/site_id/'.$this->getRequest()->getParam('site_id').'/';
	}

	function postSubmit($params)
	{
		$page = Page::get($params['content_id'],true);
		if(empty($page))
		{
			$page = Page::createNew($params);
		}
		else
		{
			$page->setFromArray($params);
		}
		$page->save();

		if(empty($params['site_id']))$this->_redirect('/admin/page');

		$site = Site::get($params['site_id']);
		$site->addPage($page->getId());

		//$this->_redirect('/admin/sitepage/edit/site_id/'.$params['site_id'].'/id/'.$params['content_id']);
		$this->_redirect('/admin/sitepage/index/site_id/'.$params['site_id']);
	}
	public function postDelete($ids)
	{
		$this->_redirect('/admin/sitepage/index/site_id/'.$this->getRequest()->getParam('site_id'));
	}
}

?>