<?php
require_once ('admin/controllers/LinkController.php');
class Admin_SiteLinkController  extends Admin_LinkController{
	function generateList($searchText)
	{
		$site_id = $this->getRequest()->getParam('site_id');
		$site = Site::get($site_id);
		$links = $site->getLinks();

		$arr = array();
		$i = 1;
		foreach($links as $link)
		{
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($link->title,$searchText)===FALSE)
				{
					if(stripos($link->url,$searchText)===FALSE)
					{
						continue;
					}
				}

			}

			$arr[] = array($i++,'title'=>$link->title,'url'=>$link->url,'id'=>$link->id);
		}
		$this->view->tableOptions = array("edit_href"=>" href='".$this->getRequest()->getBaseUrl().'/admin/'.$this->getRequest()->getControllerName().'/edit/site_id/'.$site_id.'/'."id/%1\$s' ");
		return $arr;
	}
	public function indexAction()
	{
		$searchText = $this->getRequest()->getParam('search','');
		$this->view->searchText = $searchText;
		$this->view->list =  $this->generateList($searchText);
		$this->view->header = $this->generateHeader();
		$this->view->pageTitle = $this->getPageTitle();
		$this->view->table = $this->getTableName();
		$this->view->cpage = $this->getRequest()->getParam('cpage',$this->getRequest()->getParam('page',1));
		$this->view->errorMessages = implode('<br/>',$this->_helper->flashMessenger->getMessages());

		$this->renderScript('views/admin/site/edit.phtml');
	}
	public function preDispatch()
	{
		$this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_ADMIN);
		$site_id = $this->getRequest()->getParam('site_id');
		$this->view->site = Site::get($site_id);
		$this->view->module = "sitelink";
		$this->view->section = "link";
		$this->view->pathToController = $this->getRequest()->getBaseUrl().'/admin/'.$this->getRequest()->getControllerName().'/index/site_id/'.$this->getRequest()->getParam('site_id').'/';
	}
	function postSubmit($params)
	{
		if(empty($params['site_id']))$this->_redirect('/admin/link');

		$site = Site::get($params['site_id']);
		$site->addLink($params['id']);

		$this->_redirect('/admin/sitelink/index/site_id/'.$params['site_id']);
	}
	public function postDelete($ids)
	{
		$this->_redirect('/admin/sitelink/index/site_id/'.$this->getRequest()->getParam('site_id'));
	}
}

?>