<?php
require_once ('admin/controllers/BaseController.php');
class Admin_NotificationController extends Admin_BaseController {

	function generateHeader() {
		$this->view->updateOnly = true;//removes the add and delete button from view
		return array(' ',$this->translate('Type'),$this->translate('Feed'),$this->translate('Email'),$this->translate('SMS'));
	}
	function generateList($searchText) {

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_REGISTRY));
		$items = $table->fetchAll($table->select()->where('active=1'));

		$arr = array();
		$i = 1;
		foreach($items as $item)
		{
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($item->title.$item->type.$item->appid,$searchText)===FALSE)
				{
					continue;
				}

			}
			if(empty($item->title))$item->title = ucfirst($item->appid).' : '.$item->type;

			$arr[] = array($i++,'title'=>$item->title,'feed'=>$item->feed_enabled ? $this->translate(PrecurioStrings::YES) : $this->translate(PrecurioStrings::NO),'email'=>$item->mail_enabled ? $this->translate(PrecurioStrings::YES) : $this->translate(PrecurioStrings::NO),'sms'=>$item->sms_enabled ? $this->translate(PrecurioStrings::YES) : $this->translate(PrecurioStrings::NO),'id'=>$item->id);
		}
		return $arr;
	}
	public function addAction()
	{
		return $this->redirect('/admin/notification');
		$this->renderScript('forms/admin/notification_form.phtml');
	}
	public function editAction()
	{
		$id =  $this->getRequest()->getParam('id',0);

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_REGISTRY));

		$this->view->item = $table->find($id)->current();
		$this->renderScript('forms/admin/notification_form.phtml');
	}
	public function getForm($item = null,$viewMode = false)
	{
		$form = new Zend_Form();
		$form->setAction($this->getRequest()->getBaseUrl().'/admin/link/submit')
		->setMethod('post')
		->setAttrib('id','form')
		->setAttrib('name','addForm');


		$form->addElement('hidden', 'id', array('value'=>$item['id']));
		$form->addElement('hidden', 'title', array('value'=>$item['title']));
		$form->addElement('hidden', 'feed_format', array('value'=>$item['feed_format']));
		$form->addElement('hidden', 'mail_format', array('value'=>$item['mail_format']));
		$form->addElement('hidden', 'sms_format', array('value'=>$item['sms_format']));
		$form->addElement('hidden', 'mail_subject', array('value'=>$item['mail_subject']));
		$form->addElement('hidden', 'feed_enabled', array('value'=>$item['feed_enabled']));
		$form->addElement('hidden', 'mail_enabled', array('value'=>$item['mail_enabled']));
		$form->addElement('hidden', 'sms_enabled', array('value'=>$item['sms_enabled']));
		$form->addElement('hidden', 'date_created', array('value'=>$item['date_created']));
		return $form;
	}

	function getPageTitle() {
		return $this->translate("Notification Settings");
	}

	function getTableName() {
		return PrecurioTableConstants::ACTIVITY_REGISTRY;
	}
}

?>