<?php
require_once ('admin/controllers/BaseController.php');
require_once ('cms/models/MyContents.php');
require_once ('poll/models/Polls.php');
/**
 * @author brain
 *	Create, edit and delete contents
 *
 */
class Admin_CmsController extends Admin_BaseController {

	function generateHeader() {
		return array('',$this->translate('Title'),$this->translate('User'),$this->translate('Date'));
	}
	public function addAction()
	{
		$this->renderScript('forms/admin/content_form.phtml');
	}
	public function editAction()
	{
		$id =  $this->getRequest()->getParam('id',0);
		$this->view->content = MyContents::getContent($id,false);
		$this->renderScript('forms/admin/content_form.phtml');
	}
	public function deleteAction()
	{
		$ids = $this->getRequest()->getParam("ids");
		foreach($ids as $id)
		{
			$content = MyContents::getContent($id,true);
			$content->do_delete();
		}
		$this->postDelete($ids);
		return $this->_redirect('/'.$this->getRequest()->getModuleName().'/'.$this->getRequest()->getControllerName().'/');
	}
	function generateList($searchText) {
		$items = MyContents::getAll();
		$arr = array();
		$i = 1;
		foreach($items as $item)
		{
			if(!empty($item->is_site))continue;//do not show site content
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($item->getTitle(),$searchText)===FALSE)
				{
					continue;
				}
			}
			$arr[] = array($i++,'title'=>$item->getTitle(),'user'=>$item->getFullName(),'date'=>$item->getDateAdded(),'id'=>$item->getContentId());
		}
		$baseUrl = $this->view->baseUrl();
		//$this->view->tableOptions = array('view_href'=>" href='$baseUrl/cms/view/%1\$s' target='_blank'");
		return $arr;
	}
	function getForm($item = null, $viewMode = false)
	{

	}
	function getPageTitle() {
		return $this->translate(PrecurioStrings::ALLCONTENT);
	}

	function getTableName() {
		return PrecurioTableConstants::CONTENT;
	}
	public function submitAction()
	{
		//first get all parameters
		$params = $this->getRequest()->getParams();
		//		Precurio_Utils::debug($params);
		//		$this->_helper->layout->disableLayout();
		//		$this->_helper->viewRenderer->setNoRender();
		//		return ;

		if(isset($_FILES['file']) && $_FILES['file']['size'] > 0)
		{
			$filePath = Content::addContentImage();//puts images in the right places if there is any
		}

		$user_id = empty($params['user_id']) ? Precurio_Session::getCurrentUserId() : $params['user_id'];//get the current user.

		$content_id = $this->getRequest()->getParam('content_id',0);

		//we didnt get group_ids from $params because that will cause an error
		//if there happens to be no 'group_id'.
		$group_ids = $this->getRequest()->getParam('group_id',array());
		//same goes for category_id
		$category_ids = $this->getRequest()->getParam('category_id',array());

		//clean up $params for database insert
		if(isset($params['group_id']))unset($params['group_id']);
		if(isset($params['file']))unset($params['file']);
		if(isset($params['category_id']))unset($params['category_id']);


		//set other params.
		if(isset($_FILES['file']) && $_FILES['file']['size'] > 0)$params['image_path'] = $filePath;
		$params['active'] = 1;//we are assuming no approvals are necessary
		$date_created = Precurio_Date::now()->getTimestamp();
		$params['date_created'] = empty($params['date_created']) ? $date_created : $params['date_created'];
		if(empty($params['user_id']))$params['user_id'] = $user_id;
		$params['is_public'] = $this->getRequest()->getParam('is_public',0);
		$params['is_featured'] = $this->getRequest()->getParam('is_featured',0);
		$params['disable_comments'] = $this->getRequest()->getParam('disable_comments',0);

		$this->preSubmit($params);

		if($params['is_featured'])
		{
			$t = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT));
			$t->update(array('is_featured'=>0));
		}
		//this is where we determine if it was an edit or add operation
		if($content_id == 0)
		{
			$content_id = Content::createNew($params,false);
			$content = MyContents::getContent($content_id);
			$params['content_id'] = $content_id;
		}
		else
		{
			$content =  MyContents::getContent($content_id,false);
			$content->do_update($params,$user_id);
		}
		$requiresApproval = false;//flag to determine if content requires approval, so we dont create an activity for it.

		//lets remove all existing content to cateogory mapping
		$content->removeCategorys();
		//now add content at category(s)
		foreach($category_ids as $category_id)
		{
			$category = Category::getCategory($category_id);
			$category->addContents(array($content_id));
		}

		$config = Zend_Registry::get('config');
		//if precurio has been configured to require approval for contents
		if($config->content_requires_approval)
		{
			$data['active'] = 0;
			$tasks = new Tasks();
			$task_id = $tasks->addContentTask($user_id,$content_id,Task::TYPE_CONTENT);
			$data['task_id'] = $task_id;
			$requiresApproval = true;
		}

		if(!$requiresApproval)
		{
			$type = $this->getRequest()->getParam('content_id',0) == 0 ? Content::ACTIVITY_NEW : Content::ACTIVITY_EDIT;
			//now create new activity., which also triggers notifications.
			Precurio_Activity::create(Content::APPID,$type,$content_id, $user_id);
		}

		$this->postSubmit($params);
	}
	public function downloadAction()
	{
		$this->_helper->layout->disableLayout();
    	$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getParams();

		$content = MyContents::getContent($params['id']);

		if(empty($content))return;
		if($params['format'] == 'excel')
		{
			$filepath = $content->downloadExcel();

			$filename = basename($filepath);
			$this->getResponse()->setRawHeader( "Content-Type: application/vnd.ms-excel; charset=UTF-8" )
			->setRawHeader( "Content-Disposition: attachment; filename=".$filename )
			->setRawHeader( "Content-Transfer-Encoding: binary" )
			->setRawHeader( "Expires: 0" )
			->setRawHeader( "Cache-Control: must-revalidate, post-check=0, pre-check=0" )
			->setRawHeader( "Pragma: public" )
			->setRawHeader( "Content-Length: " . filesize( $filepath ) )
			->sendResponse();

			readfile( $filepath ); exit();
		}

	}
	function postSubmit($params)
	{
	    switch($params['redirect_after_submit']) //@see application/cms/controllers/IndexController.php::addAction()
	    {
	        case "content_view":
	            $this->_redirect('cms/view/'.$params['content_id']);
	        break;
	        case "content_list":
	            $this->_redirect('cms/list/0');
            break;
            case "admin_list":
                $this->_redirect('admin/cms/');
            break;
            case "admin_edit":
            default:
                $this->_redirect('admin/cms/edit/id/'.$params['content_id']);
            break;
	    }
	}
}

?>