
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `people`
--

-- --------------------------------------------------------

--
-- Table structure for table `activity`
--

CREATE TABLE `activity` (
  `userId` bigint(12) DEFAULT NULL,
  `targetUserId` bigint(12) DEFAULT NULL,
  `targetContentId` bigint(12) DEFAULT NULL,
  `targetContentType` varchar(25) DEFAULT NULL,
  `resultContentId` bigint(12) DEFAULT NULL,
  `resultContentType` varchar(25) DEFAULT NULL,
  `message` varchar(255) DEFAULT NULL,
  `targetMessage` varchar(255) DEFAULT NULL,
  `userMessage` varchar(255) DEFAULT NULL,
  `gid` varchar(25) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `gidx` (`gid`),
  KEY `uid` (`userId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=65 ;

--
-- Dumping data for table `activity`
--


-- --------------------------------------------------------

--
-- Table structure for table `alerts`
--

CREATE TABLE `alerts` (
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  `userId` bigint(12) DEFAULT NULL,
  `targetUserId` bigint(12) DEFAULT NULL,
  `targetContentId` bigint(12) DEFAULT NULL,
  `targetContentType` varchar(25) DEFAULT NULL,
  `message` varchar(255) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `status` enum('new','read') DEFAULT 'new',
  PRIMARY KEY (`id`),
  KEY `uid` (`targetUserId`),
  KEY `targetidx` (`targetContentId`,`targetContentType`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=72 ;

--
-- Dumping data for table `alerts`
--


-- --------------------------------------------------------

--
-- Table structure for table `comments`
--

CREATE TABLE `comments` (
  `contentId` bigint(12) DEFAULT NULL,
  `profileId` bigint(12) DEFAULT NULL,
  `userId` bigint(12) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `comment` text,
  `type` varchar(12) DEFAULT NULL,
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `doc_idx` (`contentId`),
  KEY `pid` (`profileId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=82 ;

--
-- Dumping data for table `comments`
--


-- --------------------------------------------------------

--
-- Table structure for table `content`
--

CREATE TABLE `content` (
  `userId` bigint(12) DEFAULT NULL,
  `createdBy` bigint(12) DEFAULT NULL,
  `parentId` bigint(12) DEFAULT NULL,
  `groupId` bigint(12) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `changeDate` datetime DEFAULT NULL,
  `body` text,
  `headline` text,
  `link` varchar(1024) DEFAULT NULL,
  `type` varchar(12) DEFAULT NULL,
  `privacy` enum('public','friends_only','group_only','owner_only') DEFAULT 'public',
  `status` enum('new','approved','featured','hidden') DEFAULT 'new',
  `flagDate` datetime DEFAULT NULL,
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  `commentCount` bigint(12) DEFAULT '0',
  `yes_votes` int(11) DEFAULT '0',
  `no_votes` int(11) DEFAULT '0',
  `stub` text,
  `editDate` datetime DEFAULT NULL,
  `commentDate` datetime DEFAULT NULL,
  `hidden` int(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `datesort` (`date`),
  KEY `uidx` (`userId`),
  KEY `datex` (`date`),
  KEY `gidx` (`groupId`),
  FULLTEXT KEY `idx_full` (`headline`,`link`,`body`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=123 ;

--
-- Dumping data for table `content`
--


-- --------------------------------------------------------

--
-- Table structure for table `files`
--

CREATE TABLE `files` (
  `file_name` varchar(60) DEFAULT NULL,
  `original_name` varchar(60) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `extension` varchar(6) DEFAULT NULL,
  `mime_type` varchar(32) DEFAULT NULL,
  `userId` bigint(12) DEFAULT NULL,
  `contentId` bigint(12) DEFAULT NULL,
  `groupId` bigint(12) DEFAULT NULL,
  `changeDate` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `didx` (`contentId`),
  KEY `uidx` (`userId`),
  KEY `gid` (`groupId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=30 ;

--
-- Dumping data for table `files`
--


-- --------------------------------------------------------

--
-- Table structure for table `flags`
--

CREATE TABLE `flags` (
  `type` enum('content','user','group','comment','file') DEFAULT NULL,
  `itemId` bigint(12) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `value` text,
  `userId` bigint(12) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `lookup` (`type`,`itemId`,`name`,`userId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=77 ;

--
-- Dumping data for table `flags`
--


-- --------------------------------------------------------

--
-- Table structure for table `groupMember`
--

CREATE TABLE `groupMember` (
  `userId` bigint(12) DEFAULT NULL,
  `groupId` bigint(12) DEFAULT NULL,
  `type` enum('invitee','owner','manager','member') DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  UNIQUE KEY `nodupes` (`userId`,`groupId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `groupMember`
--


-- --------------------------------------------------------

--
-- Table structure for table `groups`
--

CREATE TABLE `groups` (
  `groupname` varchar(255) DEFAULT NULL,
  `description` text,
  `stub` varchar(40) DEFAULT NULL,
  `type` enum('public','private') DEFAULT NULL,
  `userId` bigint(12) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `changeDate` datetime DEFAULT NULL,
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `groups`
--


-- --------------------------------------------------------

--
-- Table structure for table `invites`
--

CREATE TABLE `invites` (
  `userId` bigint(12) DEFAULT NULL,
  `groupId` bigint(12) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `code` varchar(200) DEFAULT NULL,
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `invites`
--


-- --------------------------------------------------------

--
-- Table structure for table `messages`
--

CREATE TABLE `messages` (
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  `userId` bigint(12) NOT NULL,
  `targetUserId` bigint(12) DEFAULT NULL,
  `fromId` bigint(12) NOT NULL,
  `message` text,
  `date` datetime DEFAULT NULL,
  `status` enum('new','read','flagged','spam') DEFAULT 'new',
  PRIMARY KEY (`id`),
  KEY `user_and_friend` (`userId`,`targetUserId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=55 ;

--
-- Dumping data for table `messages`
--


-- --------------------------------------------------------

--
-- Table structure for table `meta`
--

CREATE TABLE `meta` (
  `type` enum('group','content','user','comment','file') NOT NULL,
  `itemId` bigint(12) NOT NULL,
  `name` varchar(100) NOT NULL,
  `value` text NOT NULL,
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `u` (`type`,`itemId`,`name`),
  KEY `lookup` (`type`,`itemId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=50 ;

--
-- Dumping data for table `meta`
--

INSERT INTO `meta` VALUES('user', 5, 'adminUser', '1', 49);

-- --------------------------------------------------------

--
-- Table structure for table `tagRef`
--

CREATE TABLE `tagRef` (
  `tagId` bigint(12) DEFAULT NULL,
  `itemId` bigint(12) DEFAULT NULL,
  `type` enum('content','user','group','comment','file') DEFAULT NULL,
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `lookup` (`type`,`itemId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tagRef`
--


-- --------------------------------------------------------

--
-- Table structure for table `tags`
--

CREATE TABLE `tags` (
  `value` varchar(100) DEFAULT NULL,
  `weight` bigint(12) DEFAULT '0',
  `date` datetime DEFAULT NULL,
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tags`
--


-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `nick` varchar(255) DEFAULT NULL,
  `fullname` varchar(255) DEFAULT NULL,
  `stub` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `id` bigint(12) NOT NULL AUTO_INCREMENT,
  `password` varchar(100) DEFAULT NULL,
  `memberSince` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `homepage` varchar(255) DEFAULT NULL,
  `lastVisit` datetime DEFAULT NULL,
  `verificationKey` varchar(200) DEFAULT NULL,
  `authSecret` varchar(32) DEFAULT NULL,
  `passwordResetCode` varchar(32) DEFAULT NULL,
  `invitedBy` bigint(12) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `zipcode` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES('[[admin_username]]', NULL, '[[admin_username]]', '[[admin_email]]', 5, NULL, '[[regtime]]', NULL, NULL, '[[regtime]]', NULL, '[[admin_pass]]', NULL, NULL, NULL, NULL);
