
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `plg`
--

-- --------------------------------------------------------

--
-- Table structure for table `plogger_albums`
--

CREATE TABLE `plogger_albums` (
  `name` varchar(128) NOT NULL DEFAULT '',
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `thumbnail_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid_idx` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `plogger_albums`
--

INSERT INTO `plogger_albums` VALUES('Plogger Test Album', 1, 'Feel free to delete it', 'plogger-test-album', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `plogger_collections`
--

CREATE TABLE `plogger_collections` (
  `name` varchar(128) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `thumbnail_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `plogger_collections`
--

INSERT INTO `plogger_collections` VALUES('Plogger Test Collection', 'Feel free to delete it', 'plogger-test-collection', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `plogger_comments`
--

CREATE TABLE `plogger_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `author` varchar(64) NOT NULL DEFAULT '',
  `email` varchar(64) NOT NULL DEFAULT '',
  `url` varchar(64) NOT NULL DEFAULT '',
  `date` datetime NOT NULL,
  `comment` longtext NOT NULL,
  `ip` char(64) DEFAULT NULL,
  `approved` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `pid_idx` (`parent_id`),
  KEY `approved_idx` (`approved`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `plogger_comments`
--


-- --------------------------------------------------------

--
-- Table structure for table `plogger_config`
--

CREATE TABLE `plogger_config` (
  `gallery_name` varchar(255) NOT NULL DEFAULT '',
  `gallery_url` varchar(255) NOT NULL DEFAULT '',
  `admin_username` varchar(64) NOT NULL DEFAULT '',
  `admin_email` varchar(50) NOT NULL DEFAULT '',
  `admin_password` varchar(64) NOT NULL DEFAULT '',
  `activation_key` varchar(64) NOT NULL DEFAULT '',
  `date_format` varchar(64) NOT NULL DEFAULT '',
  `compression` int(11) NOT NULL DEFAULT '75',
  `thumb_num` int(11) NOT NULL DEFAULT '0',
  `default_sortby` varchar(20) NOT NULL DEFAULT '',
  `default_sortdir` varchar(5) NOT NULL DEFAULT '',
  `album_sortby` varchar(20) NOT NULL DEFAULT '',
  `album_sortdir` varchar(5) NOT NULL DEFAULT '',
  `collection_sortby` varchar(20) NOT NULL DEFAULT '',
  `collection_sortdir` varchar(5) NOT NULL DEFAULT '',
  `allow_dl` smallint(1) NOT NULL DEFAULT '0',
  `allow_comments` smallint(1) NOT NULL DEFAULT '1',
  `allow_print` smallint(1) NOT NULL DEFAULT '1',
  `truncate` int(11) NOT NULL DEFAULT '0',
  `feed_num_entries` int(15) NOT NULL DEFAULT '15',
  `feed_title` text NOT NULL,
  `feed_content` tinyint(4) NOT NULL DEFAULT '1',
  `use_mod_rewrite` tinyint(4) NOT NULL DEFAULT '0',
  `comments_notify` tinyint(4) NOT NULL DEFAULT '1',
  `comments_moderate` tinyint(4) NOT NULL DEFAULT '0',
  `theme_dir` varchar(128) NOT NULL DEFAULT '',
  `thumb_nav_range` int(11) NOT NULL DEFAULT '0',
  `allow_fullpic` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`thumb_num`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `plogger_config`
--

INSERT INTO `plogger_config` VALUES('[[site_name]]', '[[softurl]]/', '[[admin_username]]', '[[admin_email]]', '[[admin_pass]]', '', 'n.j.Y', 75, 20, '', '', '', '', '', '', 0, 1, 1, 0, 15, 'Plogger Photo Feed', 1, 0, 1, 0, 'default', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `plogger_pictures`
--

CREATE TABLE `plogger_pictures` (
  `path` varchar(255) NOT NULL DEFAULT '',
  `parent_album` int(11) NOT NULL DEFAULT '0',
  `parent_collection` int(11) NOT NULL DEFAULT '0',
  `caption` mediumtext NOT NULL,
  `description` text NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_submitted` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `EXIF_date_taken` varchar(64) NOT NULL DEFAULT '',
  `EXIF_camera` varchar(64) NOT NULL DEFAULT '',
  `EXIF_shutterspeed` varchar(64) NOT NULL DEFAULT '',
  `EXIF_focallength` varchar(64) NOT NULL DEFAULT '',
  `EXIF_flash` varchar(64) NOT NULL DEFAULT '',
  `EXIF_aperture` varchar(64) NOT NULL DEFAULT '',
  `EXIF_iso` varchar(64) NOT NULL DEFAULT '',
  `allow_comments` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `pa_idx` (`parent_album`),
  KEY `pc_idx` (`parent_collection`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `plogger_pictures`
--


-- --------------------------------------------------------

--
-- Table structure for table `plogger_thumbnail_config`
--

CREATE TABLE `plogger_thumbnail_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `update_timestamp` int(10) unsigned DEFAULT NULL,
  `max_size` int(10) unsigned DEFAULT NULL,
  `disabled` tinyint(4) DEFAULT '0',
  `resize_option` tinyint(4) DEFAULT '2',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `plogger_thumbnail_config`
--

INSERT INTO `plogger_thumbnail_config` VALUES(1, 1096396500, 100, 0, 3);
INSERT INTO `plogger_thumbnail_config` VALUES(2, 1096396500, 500, 0, 2);
INSERT INTO `plogger_thumbnail_config` VALUES(3, 1096396500, 400, 0, 2);
INSERT INTO `plogger_thumbnail_config` VALUES(4, 1096396500, 60, 0, 3);
