-- 
-- Database: `pixelpost`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]addons`
-- 

CREATE TABLE `[[dbprefix]]addons` (
  `id` int(11) NOT NULL auto_increment,
  `addon_name` varchar(66) NOT NULL default '',
  `status` char(3) NOT NULL default 'on',
  `type` varchar(15) NOT NULL default 'normal',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]addons`
-- 

INSERT INTO `[[dbprefix]]addons` VALUES (1, 'admin_12CropImage', 'off', 'admin');
INSERT INTO `[[dbprefix]]addons` VALUES (2, 'admin_ping', 'off', 'admin');
INSERT INTO `[[dbprefix]]addons` VALUES (3, 'admin_update_exif', 'off', 'admin');
INSERT INTO `[[dbprefix]]addons` VALUES (4, 'advanced_stat', 'off', 'normal');
INSERT INTO `[[dbprefix]]addons` VALUES (5, 'calendar', 'off', 'normal');
INSERT INTO `[[dbprefix]]addons` VALUES (6, 'copy_folder', 'off', 'normal');
INSERT INTO `[[dbprefix]]addons` VALUES (7, 'current_datetime', 'off', 'normal');
INSERT INTO `[[dbprefix]]addons` VALUES (8, 'paged_archive', 'off', 'normal');
INSERT INTO `[[dbprefix]]addons` VALUES (9, '_akismet/admin_akismet_comment', 'off', 'admin');
INSERT INTO `[[dbprefix]]addons` VALUES (10, '_akismet/front_akismet_comment', 'off', 'front');
INSERT INTO `[[dbprefix]]addons` VALUES (11, '_defensio/admin_defensio', 'off', 'admin');
INSERT INTO `[[dbprefix]]addons` VALUES (12, '_defensio/front_defensio', 'off', 'front');

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]catassoc`
-- 

CREATE TABLE `[[dbprefix]]catassoc` (
  `id` int(11) NOT NULL auto_increment,
  `cat_id` int(11) NOT NULL default '0',
  `image_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cat_id` (`cat_id`),
  KEY `image_id` (`image_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]catassoc`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]categories`
-- 

CREATE TABLE `[[dbprefix]]categories` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `alt_name` varchar(100) NOT NULL default 'DEFAULT',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]categories`
-- 

INSERT INTO `[[dbprefix]]categories` VALUES (1, 'default', 'DEFAULT');

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]comments`
-- 

CREATE TABLE `[[dbprefix]]comments` (
  `id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) NOT NULL default '0',
  `datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `ip` varchar(20) NOT NULL default '',
  `message` text NOT NULL,
  `name` varchar(30) default NULL,
  `url` varchar(70) default NULL,
  `email` varchar(100) default NULL,
  `publish` char(3) NOT NULL default 'yes',
  PRIMARY KEY  (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]comments`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]config`
-- 

CREATE TABLE `[[dbprefix]]config` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `admin` varchar(20) NOT NULL default '',
  `password` varchar(90) NOT NULL default '',
  `email` varchar(90) NOT NULL default '',
  `commentemail` char(3) NOT NULL default '',
  `template` varchar(150) NOT NULL default '',
  `imagepath` varchar(150) NOT NULL default '',
  `thumbnailpath` varchar(150) NOT NULL default '../thumbnails/',
  `siteurl` varchar(100) NOT NULL default '',
  `sitetitle` varchar(100) NOT NULL default '',
  `subtitle` varchar(100) NOT NULL default 'Authentic photoblog flavour',
  `langfile` varchar(100) NOT NULL default '',
  `calendar` varchar(30) NOT NULL default '',
  `crop` char(3) NOT NULL default '',
  `thumbwidth` int(11) NOT NULL default '0',
  `thumbheight` int(11) NOT NULL default '0',
  `thumbnumber` int(11) NOT NULL default '0',
  `compression` int(11) NOT NULL default '0',
  `dateformat` varchar(30) NOT NULL default '',
  `timezone` float NOT NULL default '5.5',
  `catgluestart` varchar(5) NOT NULL default '[',
  `catglueend` varchar(5) NOT NULL default ']',
  `htmlemailnote` char(3) default 'yes',
  `timestamp` varchar(4) NOT NULL default 'yes',
  `visitorbooking` varchar(4) NOT NULL default 'yes',
  `altlangfile` varchar(100) NOT NULL default 'Off',
  `global_comments` enum('A','M','F') NOT NULL default 'A',
  `markdown` enum('F','T') NOT NULL default 'F',
  `exif` enum('F','T') NOT NULL default 'T',
  `token` enum('F','T') NOT NULL default 'F',
  `token_time` char(2) NOT NULL default '5',
  `comment_timebetween` char(3) NOT NULL default '30',
  `feeditems` char(3) NOT NULL default '10',
  `max_uri_comments` char(3) NOT NULL default '5',
  `rsstype` enum('F','FO','T','O','N') NOT NULL default 'T',
  `feed_discovery` enum('RA','R','A','E','N') NOT NULL default 'RA',
  `feed_title` varchar(100) NOT NULL default 'Pixelpost',
  `feed_description` varchar(100) NOT NULL default 'Authentic photoblog flavour',
  `feed_copyright` varchar(100) NOT NULL default 'Copyright 2007 yoursite.com, All Rights Reserved',
  `allow_comment_feed` enum('Y','N') NOT NULL default 'Y',
  `feed_external` varchar(150) NOT NULL default '',
  `feed_external_type` enum('ER','EA') NOT NULL default 'ER',
  `admin_langfile` varchar(100) NOT NULL default 'english',
  `display_order` enum('default','reversed') NOT NULL default 'default',
  `display_sort_by` varchar(150) NOT NULL default 'datetime',
  `thumb_sharpening` char(1) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]config`
-- 

INSERT INTO `[[dbprefix]]config` VALUES (1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', 'no', 'simple', '../images/', '../thumbnails/', '[[softurl]]/', '[[site_name]]', '[[site_desc]]', 'english', 'No Calendar', 'yes', 100, 75, 5, 75, 'Y-m-d H:i:s', 0, '[', ']', 'yes', 'yes', 'yes', 'Off', 'A', 'F', 'T', 'F', '5', '30', '10', '5', 'T', 'RA', '[[site_name]]', '[[site_desc]]', 'Copyright 2009 [[softurl]]/, All Rights Reserved', 'Y', '', 'ER', 'english', 'default', 'datetime', '0');

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]pixelpost`
-- 

CREATE TABLE `[[dbprefix]]pixelpost` (
  `id` int(11) NOT NULL auto_increment,
  `datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `headline` varchar(150) NOT NULL default '',
  `body` text NOT NULL,
  `image` text NOT NULL,
  `category` varchar(150) NOT NULL default '',
  `alt_headline` varchar(150) NOT NULL default '',
  `alt_body` text,
  `comments` enum('A','M','F') NOT NULL default 'A',
  `exif_info` text,
  PRIMARY KEY  (`id`),
  KEY `datetime` (`datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]pixelpost`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]tags`
-- 

CREATE TABLE `[[dbprefix]]tags` (
  `img_id` int(11) NOT NULL default '0',
  `tag` tinytext NOT NULL,
  `alt_tag` tinytext NOT NULL,
  PRIMARY KEY  (`img_id`,`tag`(128),`alt_tag`(128))
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]tags`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]version`
-- 

CREATE TABLE `[[dbprefix]]version` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `upgrade_date` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `version` float NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]version`
-- 

INSERT INTO `[[dbprefix]]version` VALUES (1, '[[regtime]]', 1.4);
INSERT INTO `[[dbprefix]]version` VALUES (2, '[[regtime]]', 1.41);
INSERT INTO `[[dbprefix]]version` VALUES (3, '[[regtime]]', 1.49995);
INSERT INTO `[[dbprefix]]version` VALUES (4, '[[regtime]]', 1.59);
INSERT INTO `[[dbprefix]]version` VALUES (5, '[[regtime]]', 1.6);
INSERT INTO `[[dbprefix]]version` VALUES (6, '[[regtime]]', 1.7);
INSERT INTO `[[dbprefix]]version` VALUES (7, '[[regtime]]', 1.71);
INSERT INTO `[[dbprefix]]version` VALUES (8, '[[regtime]]', 1.72);
INSERT INTO `[[dbprefix]]version` VALUES (9, '[[regtime]]', 1.73);

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]visitors`
-- 

CREATE TABLE `[[dbprefix]]visitors` (
  `id` int(11) NOT NULL auto_increment,
  `datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `host` varchar(100) NOT NULL default '',
  `referer` varchar(255) NOT NULL default '',
  `ua` varchar(255) NOT NULL default '',
  `ip` varchar(255) NOT NULL default '',
  `ruri` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `datetime` (`datetime`),
  KEY `referer` (`referer`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]visitors`
-- 

