

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `pixie`
--

-- --------------------------------------------------------

--
-- Table structure for table `pixie_bad_behavior`
--

CREATE TABLE `pixie_bad_behavior` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` text COLLATE utf8_unicode_ci NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `request_method` text COLLATE utf8_unicode_ci NOT NULL,
  `request_uri` text COLLATE utf8_unicode_ci NOT NULL,
  `server_protocol` text COLLATE utf8_unicode_ci NOT NULL,
  `http_headers` text COLLATE utf8_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8_unicode_ci NOT NULL,
  `request_entity` text COLLATE utf8_unicode_ci NOT NULL,
  `key` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ip` (`ip`(15)),
  KEY `user_agent` (`user_agent`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `pixie_bad_behavior`
--


-- --------------------------------------------------------

--
-- Table structure for table `pixie_core`
--

CREATE TABLE `pixie_core` (
  `page_id` smallint(11) NOT NULL AUTO_INCREMENT,
  `page_type` set('dynamic','static','module','plugin') COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `page_name` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `page_display_name` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `page_description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `page_blocks` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_content` longtext COLLATE utf8_unicode_ci,
  `page_views` int(12) DEFAULT '0',
  `page_parent` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `privs` tinyint(2) NOT NULL DEFAULT '2',
  `publish` set('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  `public` set('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  `in_navigation` set('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  `page_order` int(3) DEFAULT '0',
  `searchable` set('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`page_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci PACK_KEYS=0 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `pixie_core`
--

INSERT INTO `pixie_core` VALUES(1, 'static', '404', 'Error 404', 'Page not found.', '', '<p>The page you are looking for cannot be found.</p>', 11, '', 2, 'yes', 'yes', 'no', 0, 'no', '2008-01-01 05:30:11');
INSERT INTO `pixie_core` VALUES(2, 'plugin', 'comments', 'Comments', 'This plugin enables commenting on dynamic pages.', '', '', 1, '', 2, 'yes', 'yes', 'no', 0, 'no', '2008-01-01 05:30:11');
INSERT INTO `pixie_core` VALUES(3, 'dynamic', 'blog', 'My Blog', '<p>This is my Blog about stuff!</p>', 'demo rss', NULL, 0, '', 1, 'yes', 'yes', 'yes', 0, 'yes', '2008-03-25 16:23:10');
INSERT INTO `pixie_core` VALUES(4, 'static', 'about', 'About Me', '<p>This is a page all about me</p>', 'demo digg', '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Praesent posuere ante sit amet odio. Nam lacus justo, aliquam nec, dictum varius, consectetuer quis, dui. Integer diam sapien, gravida vel, tristique non, dignissim eu, nisi. Morbi quis turpis. Proin ante tortor, ultricies vel, auctor quis, tempor a, sapien. Aenean magna ante, porttitor eget, molestie egestas, scelerisque at, sapien. Praesent malesuada arcu a felis. Integer ut lectus. Sed accumsan neque ac orci. Quisque lobortis, nibh sed facilisis volutpat, massa nunc interdum velit, eget nonummy neque velit quis neque. Donec lacus libero, porta id, hendrerit vitae, porttitor et.</p>', 0, '', 1, 'yes', 'yes', 'yes', 1, 'yes', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `pixie_dynamic_posts`
--

CREATE TABLE `pixie_dynamic_posts` (
  `post_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `posted` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` varchar(235) COLLATE utf8_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `tags` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `public` set('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  `comments` set('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  `author` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `post_views` int(12) DEFAULT NULL,
  `post_slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`post_id`),
  UNIQUE KEY `id` (`post_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `pixie_dynamic_posts`
--

INSERT INTO `pixie_dynamic_posts` VALUES(1, 3, '2008-03-25 16:32:00', 'My First Post', '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Praesent posuere ante sit amet odio. Nam lacus justo, aliquam nec, dictum varius, consectetuer quis, dui. Integer diam sapien, gravida vel, tristique non, dignissim eu, nisi. Morbi quis turpis. Proin ante tortor, ultricies vel, auctor quis, tempor a, sapien. Aenean magna ante, porttitor eget, molestie egestas, scelerisque at, sapien. Praesent malesuada arcu a felis. Integer ut lectus. Sed accumsan neque ac orci. </p>\r\n<p>Quisque lobortis, nibh sed facilisis volutpat, massa nunc interdum velit, eget nonummy neque velit quis neque. Donec lacus libero, porta id, hendrerit vitae, porttitor et, dui.  Suspendisse potenti. Donec consequat imperdiet eros. Morbi blandit quam ac nisi. Nulla sit amet lectus. Aenean at magna. Fusce lobortis aliquet sem. Quisque ultricies ipsum a quam. Sed laoreet. Quisque lacinia sollicitudin felis. Suspendisse potenti. Pellentesque suscipit iaculis lorem. Ut id ante quis augue porta tempor. Phasellus sed urna. Ut ante. Donec sagittis est eget justo. Proin dolor erat, molestie sit amet, hendrerit et, elementum consequat, neque. Donec at libero et felis viverra viverra. Integer cursus magna sit amet nunc. Vivamus id enim.</p>', 'my first post', 'yes', 'yes', 'toggle', '2008-03-25 16:32:50', 0, 'my-first-post');

-- --------------------------------------------------------

--
-- Table structure for table `pixie_dynamic_settings`
--

CREATE TABLE `pixie_dynamic_settings` (
  `settings_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `posts_per_page` int(2) NOT NULL DEFAULT '0',
  `rss` set('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`settings_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci PACK_KEYS=0 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `pixie_dynamic_settings`
--

INSERT INTO `pixie_dynamic_settings` VALUES(1, 3, 10, 'yes');

-- --------------------------------------------------------

--
-- Table structure for table `pixie_files`
--

CREATE TABLE `pixie_files` (
  `file_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `file_name` varchar(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file_extension` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file_type` set('Video','Image','Audio','Other') COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tags` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`file_id`),
  UNIQUE KEY `id` (`file_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci PACK_KEYS=0 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `pixie_files`
--

INSERT INTO `pixie_files` VALUES(1, 'rss_feed_icon.gif', 'gif', 'Image', 'rss feed icon');
INSERT INTO `pixie_files` VALUES(2, 'no_grav.jpg', 'jpg', 'Image', 'gravitar icon');
INSERT INTO `pixie_files` VALUES(3, 'apple_touch_icon.jpg', 'jpg', 'Image', 'icon apple touch');
INSERT INTO `pixie_files` VALUES(4, 'apple_touch_icon_pixie.jpg', 'jpg', 'Image', 'icon apple touch pixie');

-- --------------------------------------------------------

--
-- Table structure for table `pixie_log`
--

CREATE TABLE `pixie_log` (
  `log_id` int(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_ip` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `log_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `log_type` set('referral','system') COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `log_message` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `log_icon` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `log_important` set('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `id` (`log_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `pixie_log`
--

INSERT INTO `pixie_log` VALUES(1, 'Pixie Installer', '[[clientip]]', '[[regtime]]', 'system', 'Pixie was installed... remember to delete the install directory on your server.', 'error', 'yes');

-- --------------------------------------------------------

--
-- Table structure for table `pixie_log_users_online`
--

CREATE TABLE `pixie_log_users_online` (
  `visitor_id` int(11) NOT NULL AUTO_INCREMENT,
  `visitor` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_visit` int(14) NOT NULL DEFAULT '0',
  PRIMARY KEY (`visitor_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `pixie_log_users_online`
--


-- --------------------------------------------------------

--
-- Table structure for table `pixie_module_comments`
--

CREATE TABLE `pixie_module_comments` (
  `comments_id` int(5) NOT NULL AUTO_INCREMENT,
  `post_id` int(5) NOT NULL DEFAULT '0',
  `posted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `name` varchar(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `comment` longtext COLLATE utf8_unicode_ci NOT NULL,
  `admin_user` set('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  PRIMARY KEY (`comments_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `pixie_module_comments`
--


-- --------------------------------------------------------

--
-- Table structure for table `pixie_module_comments_settings`
--

CREATE TABLE `pixie_module_comments_settings` (
  `comments_id` mediumint(1) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`comments_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `pixie_module_comments_settings`
--


-- --------------------------------------------------------

--
-- Table structure for table `pixie_settings`
--

CREATE TABLE `pixie_settings` (
  `settings_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `site_name` varchar(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `site_keywords` longtext COLLATE utf8_unicode_ci NOT NULL,
  `site_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `site_theme` varchar(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `site_copyright` varchar(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `site_author` varchar(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default_page` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `clean_urls` set('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  `version` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `timezone` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dst` set('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  `date_format` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `logs_expire` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rich_text_editor` tinyint(1) NOT NULL DEFAULT '0',
  `system_message` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `last_backup` varchar(120) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bb2_installed` set('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  PRIMARY KEY (`settings_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `pixie_settings`
--

INSERT INTO `pixie_settings` VALUES(1, '[[site_name]]', 'pixie, demo, getpixie, small, simple, site, maker, www.getpixie.co.uk, cms, content, management, system, easy, interface, design, microformats, web, standards, themes, css, xhtml, scott, evans, toggle, php, mysql, pisky', '[[softurl]]/', 'busfullofhippies', '[[admin_realname]]', '[[admin_realname]]', 'blog', 'no', '1.04', 'en-gb', '+0', 'no', '%Oe %B %Y, %H:%M', '30', 1, '[[site_desc]]', '', 'yes');

-- --------------------------------------------------------

--
-- Table structure for table `pixie_users`
--

CREATE TABLE `pixie_users` (
  `user_id` int(4) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `realname` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `street` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `town` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `county` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `post_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `telephone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `website` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `biography` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `occupation` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_1` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_2` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_3` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `privs` tinyint(2) NOT NULL DEFAULT '1',
  `pass` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `nonce` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_hits` int(7) NOT NULL DEFAULT '0',
  `last_access` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `name` (`user_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci PACK_KEYS=1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `pixie_users`
-- 

INSERT INTO `pixie_users` VALUES (1, '[[admin_username]]', '[[admin_realname]]', '', '', '', '', '', '', '[[admin_email]]', '[[softurl]]/', '', '', 'http://www.toggle.uk.com', 'http://www.getpixie.co.uk', 'http://www.iwouldlikeawebsite.com', 3, password(lower('[[admin_pass]]')), '[[nonce]]', 0, '[[regtime]]');
