SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_pivotx2311`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `contenttype` tinytext CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `category` tinytext CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `target_uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`),
  KEY `target_uid` (`target_uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, 'entry', 'default', 1),
(2, 'entry', 'linkdump', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chapters`
--

CREATE TABLE `[[dbprefix]]chapters` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `chaptername` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `sortorder` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]chapters`
--

INSERT INTO `[[dbprefix]]chapters` VALUES
(1, 'Pages', 'Add some pages here, or start a new chapter.', 10);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `contenttype` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `entry_uid` int(11) NOT NULL DEFAULT '0',
  `name` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `email` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `url` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `ip` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `useragent` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `registered` tinyint(4) NOT NULL DEFAULT '0',
  `notify` tinyint(4) NOT NULL DEFAULT '0',
  `discreet` tinyint(4) NOT NULL DEFAULT '0',
  `moderate` tinyint(4) NOT NULL DEFAULT '0',
  `spamscore` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`),
  KEY `entry_uid` (`entry_uid`),
  KEY `date` (`date`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]comments`
--

INSERT INTO `[[dbprefix]]comments` VALUES
(1, 'entry', 1, 'Bob', '', 'http://pivotx.net', '[[clientip]]', '', '[[regtime]]', 'Hi! This is what a comment looks like!', 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entries`
--

CREATE TABLE `[[dbprefix]]entries` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `title` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `uri` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `subtitle` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `introduction` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `body` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `convert_lb` int(11) NOT NULL DEFAULT '0',
  `status` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `edit_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `allow_comments` int(11) NOT NULL DEFAULT '0',
  `keywords` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `via_link` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `via_title` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comment_count` int(11) NOT NULL,
  `comment_names` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `trackback_count` int(11) NOT NULL,
  `trackback_names` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `extrafields` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`uid`),
  FULLTEXT KEY `title` (`title`,`subtitle`,`introduction`,`body`,`keywords`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]entries`
--

INSERT INTO `[[dbprefix]]entries` VALUES
(1, 'Welcome to PivotX - 2.3.11', 'welcome-to-pivotx-2311', '', '<p>If you can read this, you have successfully installed [[tt tag="PivotX"]]. Yay!! To help you further on your way, the following links might be of use to you:</p>\n<ul>\n<li>PivotX.net - <a href="http://pivotx.net">The official PivotX website</a></li>\n<li>The online documentation at <a href="http://book.pivotx.net">PivotX Help</a> should be of help.</li>\n<li>Get help on <a href="http://forum.pivotx.net">the PivotX forum</a></li>\n<li>Browse for <a href="http://themes.pivotx.net">PivotX Themes</a></li>\n<li>Get more <a href="http://extensions.pivotx.net">PivotX Extensions</a></li>\n<li>Follow <a href="http://twitter.com/pivotx">@pivotx on Twitter</a></li>\n</ul>\n<p>And, of course: Have fun with PivotX!</p>', '<h3>More</h3>\n<p>All text that you write in the ''body'' part of the entry will only appear on the entry''s own page. To see how this works, edit this entry in the PivotX administration by going to ''Entries &amp; Pages'' &raquo; ''Entries'' &raquo; ''Edit''.</p>', 0, 'publish', '[[regtime]]', '[[regtime]]', '[[regtime]]', '[[admin_username]]', 1, 'pivot pivotx', '', '', 1, 'Bob', 0, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]extrafields`
--

CREATE TABLE `[[dbprefix]]extrafields` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `contenttype` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `target_uid` int(11) NOT NULL DEFAULT '0',
  `fieldkey` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`uid`),
  KEY `target_uid` (`target_uid`),
  KEY `fieldkey` (`fieldkey`(16)),
  FULLTEXT KEY `value` (`value`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `title` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `uri` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `subtitle` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `introduction` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `body` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `convert_lb` int(11) NOT NULL DEFAULT '0',
  `template` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `status` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `edit_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `chapter` int(11) NOT NULL DEFAULT '0',
  `sortorder` int(11) NOT NULL DEFAULT '0',
  `user` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `allow_comments` int(11) NOT NULL DEFAULT '0',
  `keywords` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `extrafields` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`uid`),
  FULLTEXT KEY `title` (`title`,`subtitle`,`introduction`,`body`,`keywords`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]pages`
--

INSERT INTO `[[dbprefix]]pages` VALUES
(1, 'About PivotX', 'about', '', '<p>Hi! This website runs on <a href="http://pivotx.net">PivotX</a>, the coolest free and open tool to power your blog and website. To change this text, edit ''<tt>About PivotX</tt>'', under ''<tt>Pages</tt>'' in the PivotX backend.</p>', '<p>PivotX is a feature rich weblogging tool that is simple enough for the novice     weblogger to use and complex enough to meet the demands of advanced webmasters.     It can be used to publish a variety of websites from the most basic weblog to very advanced CMS style solutions.</p>\r\n<p>PivotX is - if we do say so ourselves - quite an impressive piece of software. It     is made even better through the use of several external libraries. We thank their     authors for the time taken to develop these very useful tools and for making     them available to others.</p>\r\n<p>Development of PivotX (originally Pivot) started back in 2001 and has continuously     forged ahead thanks to the efforts of a lot     of dedicated and very talented people. The PivotX core team is still very active     but keep in mind that PivotX would not be what it is today without the valuable     contributions made by several other people.</p>', 5, '', 'publish', '[[regtime]]', '[[regtime]]', '[[regtime]]', 1, 10, '[[admin_username]]', 1, '', ''),
(2, 'Links', 'links', '', '<p>Some links to sites with more information:</p>\r\n<ul>\r\n<li>PivotX - <a href="http://pivotx.net">The PivotX website</a></li>\r\n<li>Get help on <a href="http://forum.pivotx.net">the PivotX forum</a></li>\r\n<li>Read <a href="http://book.pivotx.net">the PivotX documentation</a></li>\r\n<li>Browse for <a href="http://themes.pivotx.net">PivotX Themes</a></li>\r\n<li>Get more <a href="http://extensions.pivotx.net">PivotX Extensions</a></li>\r\n<li>Follow <a href="http://twitter.com/pivotx">@pivotx on Twitter</a></li>\r\n</ul>\r\n<p><small>To change these links, edit ''<tt>Links</tt>'', under ''<tt>Pages</tt>'' in the PivotX backend.</small></p>', '', 5, '', 'publish', '[[regtime]]', '[[regtime]]', '[[regtime]]', 1, 10, '[[admin_username]]', 1, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags`
--

CREATE TABLE `[[dbprefix]]tags` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `tag` tinytext CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `contenttype` tinytext CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `target_uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`),
  KEY `target_uid` (`target_uid`),
  KEY `tag` (`tag`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]trackbacks`
--

CREATE TABLE `[[dbprefix]]trackbacks` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `entry_uid` int(11) NOT NULL DEFAULT '0',
  `name` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `title` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `url` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `ip` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `excerpt` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `moderate` tinyint(4) NOT NULL DEFAULT '0',
  `spamscore` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
