
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_pier088`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]administration_tools`
--

CREATE TABLE `[[dbprefix]]administration_tools` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `controller` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `action` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]administration_tools`
--

INSERT INTO `[[dbprefix]]administration_tools` VALUES
(1, 'test_mail_settings', 'administration', 'tool_test_email', 1),
(2, 'mass_mailer', 'administration', 'tool_mass_mailer', 2),
(3, 'system_info', 'administration', 'system_info', 3),
(4, 'browse_log', 'administration', 'browse_log', 4);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]application_logs`
--

CREATE TABLE `[[dbprefix]]application_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `taken_by_id` int(10) unsigned DEFAULT NULL,
  `project_id` int(10) unsigned NOT NULL DEFAULT '0',
  `rel_object_id` int(10) NOT NULL DEFAULT '0',
  `object_name` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `rel_object_manager` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `action` enum('upload','open','close','delete','edit','add') CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_private` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_silent` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `created_on` (`created_on`),
  KEY `project_id` (`project_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]application_logs`
--

INSERT INTO `[[dbprefix]]application_logs` VALUES
(1, 1, 1, 1, 'Welcome', 'Projects', '[[regtime]]', 1, 'add', 0, 0),
(2, 1, 1, 1, 'Welcome', 'ProjectMilestones', '[[regtime]]', 1, 'add', 0, 0),
(3, 1, 1, 1, 'Welcome', 'ProjectTaskLists', '[[regtime]]', 1, 'add', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attached_files`
--

CREATE TABLE `[[dbprefix]]attached_files` (
  `rel_object_manager` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rel_object_id` int(10) unsigned NOT NULL DEFAULT '0',
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`rel_object_manager`,`rel_object_id`,`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rel_object_id` int(10) unsigned NOT NULL DEFAULT '0',
  `rel_object_manager` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `text` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `is_private` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_anonymous` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `author_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `author_email` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `author_homepage` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `updated_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_id` (`rel_object_id`,`rel_object_manager`),
  KEY `created_on` (`created_on`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]companies`
--

CREATE TABLE `[[dbprefix]]companies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_of_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `email` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `homepage` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `address2` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `zipcode` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone_number` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax_number` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `logo_file` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_favorite` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timezone` float(4,2) NOT NULL DEFAULT '0.00',
  `hide_welcome_info` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `updated_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_on` (`created_on`),
  KEY `client_of_id` (`client_of_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]companies`
--

INSERT INTO `[[dbprefix]]companies` VALUES
(1, 0, '[[comp_name]]', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0.00, 0, '[[date_gmt]]', 1, '[[date_gmt]]', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_categories`
--

CREATE TABLE `[[dbprefix]]config_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `category_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `order` (`category_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]config_categories`
--

INSERT INTO `[[dbprefix]]config_categories` VALUES
(1, 'system', 1, 0),
(2, 'general', 0, 1),
(3, 'mailing', 0, 2),
(4, 'features', 0, 3),
(5, 'database', 0, 9),
(6, 'authentication', 0, 8);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_options`
--

CREATE TABLE `[[dbprefix]]config_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `config_handler_class` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `option_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `dev_comment` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `order` (`option_order`),
  KEY `category_id` (`category_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=61 ;

--
-- Dumping data for table `[[dbprefix]]config_options`
--

INSERT INTO `[[dbprefix]]config_options` VALUES
(1, 'system', 'project_logs_per_page', '10', 'IntegerConfigHandler', 1, 0, NULL),
(2, 'system', 'messages_per_page', '5', 'IntegerConfigHandler', 1, 0, NULL),
(3, 'system', 'max_avatar_width', '50', 'IntegerConfigHandler', 1, 0, NULL),
(4, 'system', 'max_avatar_height', '50', 'IntegerConfigHandler', 1, 0, NULL),
(5, 'system', 'logs_per_project', '5', 'IntegerConfigHandler', 1, 0, NULL),
(6, 'system', 'max_logo_width', '50', 'IntegerConfigHandler', 1, 0, NULL),
(7, 'system', 'max_logo_height', '50', 'IntegerConfigHandler', 1, 0, NULL),
(8, 'system', 'files_per_page', '10', 'IntegerConfigHandler', 1, 0, NULL),
(9, 'general', 'calendar_first_day_of_week', '1', 'DayOfWeekConfigHandler', 0, 0, NULL),
(10, 'general', 'site_name', '[[site_name]]', 'StringConfigHandler', 0, 0, NULL),
(11, 'general', 'upgrade_last_check_datetime', '2006-09-02 13:46:47', 'DateTimeConfigHandler', 1, 0, 'Date and time of the last upgrade check'),
(12, 'general', 'upgrade_last_check_new_version', '0', 'BoolConfigHandler', 1, 0, 'True if system checked for the new version and found it. This value is used to highlight upgrade tab in the administration'),
(13, 'general', 'upgrade_check_enabled', '0', 'BoolConfigHandler', 0, 0, 'Upgrade check enabled / disabled'),
(14, 'general', 'file_storage_adapter', 'fs', 'FileStorageConfigHandler', 0, 0, 'What storage adapter should be used? fs or mysql'),
(15, 'general', 'default_project_folders', 'images\r\ndocuments\r\nother\r\n', 'TextConfigHandler', 0, 3, NULL),
(16, 'general', 'theme', 'marine', 'ThemeConfigHandler', 0, 0, NULL),
(17, 'general', 'logout_redirect_page', 'default', 'StringConfigHandler', 0, 0, 'Logout Redirect mod by Alex: Redirect to a set page upon logout'),
(18, 'mailing', 'exchange_compatible', '0', 'BoolConfigHandler', 0, 90, NULL),
(19, 'mailing', 'mail_transport', 'mail()', 'MailTransportConfigHandler', 0, 10, 'Values: ''mail()'' - try to emulate mail() function, ''smtp'' - use SMTP connection'),
(20, 'mailing', 'mail_use_reply_to', '0', 'BoolConfigHandler', 0, 11, 'Enable to use Reply-To header in mails'),
(21, 'mailing', 'mail_from', '', 'StringConfigHandler', 0, 12, 'The From address in every mail sent out'),
(22, 'mailing', 'smtp_server', '', 'StringConfigHandler', 0, 20, ''),
(23, 'mailing', 'smtp_port', '25', 'IntegerConfigHandler', 0, 21, NULL),
(24, 'mailing', 'smtp_authenticate', '0', 'BoolConfigHandler', 0, 22, 'Use SMTP authentication'),
(25, 'mailing', 'smtp_username', '', 'StringConfigHandler', 0, 23, NULL),
(26, 'mailing', 'smtp_password', '', 'PasswordConfigHandler', 0, 24, NULL),
(27, 'mailing', 'smtp_secure_connection', 'no', 'SecureSmtpConnectionConfigHandler', 0, 25, 'Values: no, ssl, tls'),
(28, 'general', 'ldap_host', '', 'StringConfigHandler', 0, 0, NULL),
(29, 'general', 'ldap_domain', '%s', 'StringConfigHandler', 0, 0, 'Note: %s is replaced with user name. Example 1. %s@example.com . Example 2. uid=%s,dc=example,dc=com'),
(30, 'general', 'ldap_secure_connection', 'no', 'SecureLDAPConnectionConfigHandler', 0, 0, 'Values: no, tls'),
(31, 'features', 'per_project_activity_logs', '0', 'BoolConfigHandler', 0, 0, 'Show recent activity logs per project on the owner company dashboard (like BaseCamp) rather than all mashed together'),
(32, 'features', 'logs_show_icons', '1', 'BoolConfigHandler', 0, 0, 'Show log icons'),
(33, 'general', 'categories_per_page', '25', 'IntegerConfigHandler', 0, 0, NULL),
(34, 'features', 'default_private', '1', 'BoolConfigHandler', 0, 0, 'Default setting for private option'),
(35, 'features', 'send_notification_default', '0', 'BoolConfigHandler', 0, 0, 'Default setting for Send notification option'),
(36, 'features', 'enable_efqm', '0', 'BoolConfigHandler', 0, 0, 'Enable EFQM options (www.efqm.org)'),
(37, 'features', 'display_application_logs', '1', 'BoolConfigHandler', 0, 0, 'Display application logs'),
(38, 'features', 'login_show_options', '1', 'BoolConfigHandler', 0, 0, 'Show options on the login page'),
(39, 'general', 'installation_root', '/', 'StringConfigHandler', 0, 0, NULL),
(40, 'general', 'check_email_unique', '0', 'BoolConfigHandler', 0, 0, 'True if emails should be unique when adding/editing a user'),
(41, 'database', 'character_set', 'utf8', 'StringConfigHandler', 0, 0, 'Standard SQL character set (e.g. utf8, latin1)'),
(42, 'database', 'collation', 'utf8_unicode_ci', 'StringConfigHandler', 0, 0, 'Standard SQL collate value (e.g. latin1_bin, utf8_bin, utf8_unicode_ci)'),
(43, 'general', 'session_lifetime', '3600', 'IntegerConfigHandler', 0, 24, ''),
(44, 'general', 'remember_login_lifetime', '1209600', 'IntegerConfigHandler', 0, 24, ''),
(45, 'general', 'default_controller', 'dashboard', 'StringConfigHandler', 0, 25, 'Controller to use after login (future use)'),
(46, 'general', 'default_action', 'index', 'DefaultDashboardActionConfigHandler', 0, 26, 'Action to perform after login (e.g. show dashboard)'),
(47, 'system', 'product_name', 'ProjectPier', 'StringConfigHandler', 1, 0, NULL),
(48, 'system', 'product_version', '0.8.8', 'StringConfigHandler', 1, 0, NULL),
(49, 'general', 'installation_welcome_text', 'Welcome to ProjectPier 0.8.8', 'StringConfigHandler', 0, 11, NULL),
(50, 'general', 'installation_welcome_logo', '<img src="public/assets/themes/marine/images/projectpier-logo.png" style="position: relative; left: 0px; top: 0px;">', 'StringConfigHandler', 0, 10, 'Logo to display above login user/pass'),
(52, 'authentication', 'authdb server', 'localhost', 'StringConfigHandler', 0, 1, NULL),
(53, 'authentication', 'authdb username', 'root', 'StringConfigHandler', 0, 2, NULL),
(54, 'authentication', 'authdb password', '', 'PasswordConfigHandler', 0, 3, NULL),
(55, 'authentication', 'authdb database', '', 'StringConfigHandler', 0, 3, NULL),
(56, 'authentication', 'authdb sql', 'select `user_email` as email from `wp_users` where `user_login` = ''$username'' and user_pass = md5(''$password'') limit 1', 'StringConfigHandler', 0, 4, NULL),
(57, 'general', 'dashboard_logs_count', '50', 'IntegerConfigHandler', 0, 27, NULL),
(58, 'general', 'map url', 'http://maps.google.com?q=$location', 'StringConfigHandler', 0, 3, NULL),
(59, 'general', 'route url', 'http://maps.google.com?saddr=$from&daddr=$to', 'StringConfigHandler', 0, 3, NULL),
(60, 'general', 'parking space reservation url', '', 'StringConfigHandler', 0, 3, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts`
--

CREATE TABLE `[[dbprefix]]contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `email` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `display_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `first_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `middle_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `avatar_file` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `use_gravatar` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_favorite` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timezone` float(4,2) NOT NULL DEFAULT '0.00',
  `office_number` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax_number` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile_number` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `home_number` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `license_plate` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `food_preferences` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `department_details` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `location_details` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `language_preferences` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `updated_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email` (`email`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]contacts`
--

INSERT INTO `[[dbprefix]]contacts` VALUES
(1, 1, 1, '[[admin_email]]', '[[admin_username]]', '', '', '', '', '', 0, 0, 0.00, '', '', '', '', '', '', '', '', '', '[[date_gmt]]', 0, '[[date_gmt]]', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_im_values`
--

CREATE TABLE `[[dbprefix]]contact_im_values` (
  `contact_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `im_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  `im_value` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`contact_id`,`im_type_id`),
  KEY `im_value` (`im_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_repo`
--

CREATE TABLE `[[dbprefix]]file_repo` (
  `id` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `seq` int(10) unsigned NOT NULL DEFAULT '0',
  `content` longblob NOT NULL,
  `order` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`seq`),
  KEY `order` (`order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_repo_attributes`
--

CREATE TABLE `[[dbprefix]]file_repo_attributes` (
  `id` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `attribute` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`,`attribute`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_types`
--

CREATE TABLE `[[dbprefix]]file_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `icon` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_searchable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_image` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `extension` (`extension`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=39 ;

--
-- Dumping data for table `[[dbprefix]]file_types`
--

INSERT INTO `[[dbprefix]]file_types` VALUES
(1, 'xxx', 'unknown.png', 0, 0),
(2, 'zip', 'archive.png', 0, 0),
(3, 'rar', 'archive.png', 0, 0),
(4, 'bz', 'archive.png', 0, 0),
(5, 'bz2', 'archive.png', 0, 0),
(6, 'gz', 'archive.png', 0, 0),
(7, 'ace', 'archive.png', 0, 0),
(8, 'mp3', 'audio.png', 0, 0),
(9, 'wma', 'audio.png', 0, 0),
(10, 'ogg', 'audio.png', 0, 0),
(11, 'doc', 'doc.png', 0, 0),
(12, 'docx', 'doc.png', 0, 0),
(13, 'xml', 'doc.png', 0, 0),
(14, 'xsl', 'doc.png', 0, 0),
(15, 'xls', 'doc.png', 0, 0),
(16, 'xlsx', 'doc.png', 0, 0),
(17, 'gif', 'image.png', 0, 1),
(18, 'jpg', 'image.png', 0, 1),
(19, 'jpeg', 'image.png', 0, 1),
(20, 'png', 'image.png', 0, 1),
(21, 'mov', 'mov.png', 0, 0),
(22, 'pdf', 'pdf.png', 0, 0),
(23, 'psd', 'psd.png', 0, 0),
(24, 'rm', 'rm.png', 0, 0),
(25, 'svg', 'svg.png', 0, 0),
(26, 'swf', 'swf.png', 0, 0),
(27, 'avi', 'video.png', 0, 0),
(28, 'mpeg', 'video.png', 0, 0),
(29, 'mpg', 'video.png', 0, 0),
(30, 'qt', 'mov.png', 0, 0),
(31, 'vob', 'video.png', 0, 0),
(32, 'wmv', 'video.png', 0, 0),
(33, 'rtf', 'doc.png', 0, 0),
(34, 'txt', 'doc.png', 1, 0),
(35, 'php', 'doc.png', 1, 0),
(36, 'mp4', 'video.png', 1, 0),
(37, 'ppt', 'doc.png', 0, 0),
(38, 'pptx', 'doc.png', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]im_types`
--

CREATE TABLE `[[dbprefix]]im_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `icon` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]im_types`
--

INSERT INTO `[[dbprefix]]im_types` VALUES
(1, 'ICQ', 'icq.gif'),
(2, 'AIM', 'aim.gif'),
(3, 'MSN', 'msn.gif'),
(4, 'Yahoo!', 'yahoo.gif'),
(5, 'Skype', 'skype.gif'),
(6, 'Jabber', 'jabber.gif');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_subscriptions`
--

CREATE TABLE `[[dbprefix]]message_subscriptions` (
  `message_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`message_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]page_attachments`
--

CREATE TABLE `[[dbprefix]]page_attachments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rel_object_id` int(10) unsigned DEFAULT NULL,
  `rel_object_manager` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `project_id` int(10) unsigned NOT NULL,
  `page_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `text` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `order` tinyint(3) NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `updated_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permissions`
--

CREATE TABLE `[[dbprefix]]permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `source` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `permission` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

--
-- Dumping data for table `[[dbprefix]]permissions`
--

INSERT INTO `[[dbprefix]]permissions` VALUES
(1, 'files', 'manage'),
(2, 'files', 'upload'),
(3, 'milestones', 'manage'),
(4, 'messages', 'manage'),
(5, 'tasks', 'manage'),
(6, 'tasks', 'assign to other clients'),
(7, 'tasks', 'assign to owner company'),
(8, 'tickets', 'manage'),
(9, 'projects', 'manage'),
(10, 'milestones', 'change status'),
(11, 'times', 'manage'),
(12, 'tasks', 'edit score'),
(13, 'milestones', 'edit goal'),
(14, 'messages', 'access'),
(15, 'tasks', 'access'),
(16, 'files', 'access'),
(17, 'forms', 'access'),
(18, 'wiki', 'access'),
(19, 'wiki', 'manage'),
(20, 'projects', 'access'),
(21, 'contacts', 'access'),
(22, 'contacts', 'manage'),
(23, 'search', 'access'),
(24, 'tags', 'access'),
(25, 'reports', 'access');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugins`
--

CREATE TABLE `[[dbprefix]]plugins` (
  `plugin_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `installed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`plugin_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]plugins`
--

INSERT INTO `[[dbprefix]]plugins` VALUES
(1, 'files', 0),
(2, 'form', 0),
(3, 'links', 0),
(4, 'tags', 0),
(5, 'tickets', 0),
(6, 'time', 0),
(7, 'wiki', 0),
(8, 'reports', 0),
(9, 'wikilinks', 0),
(10, 'i18n', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]projects`
--

CREATE TABLE `[[dbprefix]]projects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `priority` int(3) unsigned NOT NULL DEFAULT '0',
  `description` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `show_description_in_overview` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `logo_file` varchar(44) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `completed_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `completed_by_id` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `updated_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `completed_on` (`completed_on`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]projects`
--

INSERT INTO `[[dbprefix]]projects` VALUES
(1, 'Welcome', 0, 0, 'This is the very first project', 1, NULL, '0000-00-00 00:00:00', NULL, '[[regtime]]', NULL, '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_companies`
--

CREATE TABLE `[[dbprefix]]project_companies` (
  `project_id` int(10) unsigned NOT NULL DEFAULT '0',
  `company_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`project_id`,`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_messages`
--

CREATE TABLE `[[dbprefix]]project_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `milestone_id` int(10) unsigned NOT NULL DEFAULT '0',
  `project_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `text` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `additional_text` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `is_important` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_private` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `comments_enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `anonymous_comments_enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `updated_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `milestone_id` (`milestone_id`),
  KEY `project_id` (`project_id`),
  KEY `created_on` (`created_on`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_milestones`
--

CREATE TABLE `[[dbprefix]]project_milestones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `due_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `goal` int(3) unsigned NOT NULL DEFAULT '0',
  `assigned_to_company_id` int(10) NOT NULL DEFAULT '0',
  `assigned_to_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_private` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `completed_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `completed_by_id` int(10) unsigned DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `updated_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_id` (`project_id`),
  KEY `due_date` (`due_date`),
  KEY `completed_on` (`completed_on`),
  KEY `created_on` (`created_on`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]project_milestones`
--

INSERT INTO `[[dbprefix]]project_milestones` VALUES
(1, 1, 'Finish Welcome', '', '[[regtime]]', 0, 0, 1, 1, '0000-00-00 00:00:00', 0, '[[regtime]]', 1, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_tasks`
--

CREATE TABLE `[[dbprefix]]project_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_list_id` int(10) unsigned DEFAULT NULL,
  `text` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `due_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `assigned_to_company_id` int(10) unsigned DEFAULT NULL,
  `assigned_to_user_id` int(10) unsigned DEFAULT NULL,
  `completed_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `completed_by_id` int(10) unsigned DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `updated_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_by_id` int(10) unsigned DEFAULT NULL,
  `order` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `task_list_id` (`task_list_id`),
  KEY `completed_on` (`completed_on`),
  KEY `created_on` (`created_on`),
  KEY `order` (`order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]project_tasks`
--

INSERT INTO `[[dbprefix]]project_tasks` VALUES
(1, 1, 'Step 1: Activate the plugins\r\nThink about the things you need in your projects, like links, files, tickets, wiki, etc.\r\n', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1, '0000-00-00 00:00:00', 0, '[[regtime]]', 0, '[[regtime]]', 0, 1),
(2, 1, 'Step 2: Update your company info\r\nSet your company details such as phone and fax number, address, email, homepage, etc.\r\n', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1, '0000-00-00 00:00:00', 0, '[[regtime]]', 0, '[[regtime]]', 0, 2),
(3, 1, 'Step 3: Add team members\r\nYou can create user accounts for all members of your team (an unlimited number). Every member will get a username and password which they can use to access the system\r\n', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1, '0000-00-00 00:00:00', 0, '[[regtime]]', 0, '[[regtime]]', 0, 3),
(4, 1, 'Step 4: Add client companies and their members\r\nNow it''s time to define client companies (unlimited). When you''re done you can add their members or leave that for their team leaders. Client members are similar to your company members except that they have limited access to content and functions (you can set what they can do per project and per member)\r\n', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1, '0000-00-00 00:00:00', 0, '[[regtime]]', 0, '[[regtime]]', 0, 4),
(5, 1, 'Step 5: Start a project\r\nDefining a new project is really easy: set a name and description (optional) and click submit. After that you can set permissions for your team members and clients.\r\n', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1, '0000-00-00 00:00:00', 0, '[[regtime]]', 1, '[[regtime]]', 1, 5),
(6, 1, 'Step 6: Mark the Welcome project finished\r\n', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1, '0000-00-00 00:00:00', 0, '[[regtime]]', 0, '[[regtime]]', 0, 6);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_task_lists`
--

CREATE TABLE `[[dbprefix]]project_task_lists` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `milestone_id` int(10) unsigned NOT NULL DEFAULT '0',
  `project_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `priority` int(3) unsigned NOT NULL DEFAULT '0',
  `description` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `due_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `score` int(3) unsigned NOT NULL DEFAULT '0',
  `is_private` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `completed_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `completed_by_id` int(10) unsigned DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `created_by_id` int(10) unsigned NOT NULL DEFAULT '0',
  `updated_on` datetime DEFAULT NULL,
  `updated_by_id` int(10) unsigned NOT NULL DEFAULT '0',
  `order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `milestone_id` (`milestone_id`),
  KEY `project_id` (`project_id`),
  KEY `completed_on` (`completed_on`),
  KEY `created_on` (`created_on`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]project_task_lists`
--

INSERT INTO `[[dbprefix]]project_task_lists` VALUES
(1, 1, 1, 'To-Do List', 1, 'Welcome to your new account. You can get started in a minute following these easy steps.', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 1, '0000-00-00 00:00:00', 0, '[[regtime]]', 0, '[[regtime]]', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_users`
--

CREATE TABLE `[[dbprefix]]project_users` (
  `project_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `note` text,
  `role_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`project_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]project_users`
--

INSERT INTO `[[dbprefix]]project_users` VALUES
(1, 1, NULL, 0, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_user_permissions`
--

CREATE TABLE `[[dbprefix]]project_user_permissions` (
  `user_id` int(10) unsigned NOT NULL,
  `project_id` int(10) unsigned NOT NULL,
  `permission_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`project_id`,`permission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]project_user_permissions`
--

INSERT INTO `[[dbprefix]]project_user_permissions` VALUES
(1, 1, 1),
(1, 1, 2),
(1, 1, 3),
(1, 1, 4),
(1, 1, 5),
(1, 1, 6),
(1, 1, 7),
(1, 1, 8),
(1, 1, 10),
(1, 1, 11),
(1, 1, 12),
(1, 1, 13);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]searchable_objects`
--

CREATE TABLE `[[dbprefix]]searchable_objects` (
  `rel_object_manager` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rel_object_id` int(10) unsigned NOT NULL DEFAULT '0',
  `column_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `content` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `project_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_private` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`rel_object_manager`,`rel_object_id`,`column_name`),
  KEY `project_id` (`project_id`),
  FULLTEXT KEY `content` (`content`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `token` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salt` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `twister` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `updated_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_by_id` int(10) unsigned DEFAULT NULL,
  `last_login` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_visit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_activity` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_admin` tinyint(1) unsigned DEFAULT NULL,
  `auto_assign` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `use_LDAP` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `email` (`email`),
  KEY `last_visit` (`last_visit`),
  KEY `last_login` (`last_login`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', '[[admin_email]]', '[[admin_pass]]', '[[salt]]', '[[twister]]', '[[date_gmt]]', 0, '[[date_gmt]]', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_im_values`
--

CREATE TABLE `[[dbprefix]]user_im_values` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `im_type_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `value` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`im_type_id`),
  KEY `is_default` (`is_default`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
