
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `phproj621`
--

-- --------------------------------------------------------

--
-- Table structure for table `calendar2`
--

CREATE TABLE `calendar2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL DEFAULT '1',
  `summary` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `comments` varchar(255) DEFAULT NULL,
  `start` datetime DEFAULT NULL,
  `last_end` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `owner_id` int(11) NOT NULL,
  `rrule` varchar(255) DEFAULT NULL,
  `recurrence_id` datetime DEFAULT NULL,
  `visibility` int(1) DEFAULT '1',
  `uid` varchar(255) NOT NULL,
  `last_modified` datetime NOT NULL,
  `uri` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `calendar2_excluded_dates`
--

CREATE TABLE `calendar2_excluded_dates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `calendar2_id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `calendar2_user_relation`
--

CREATE TABLE `calendar2_user_relation` (
  `calendar2_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `confirmation_status` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`calendar2_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `configuration`
--

CREATE TABLE `configuration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `key_value` varchar(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `contact`
--

CREATE TABLE `contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_id` int(11) DEFAULT NULL,
  `project_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `company` varchar(255) NOT NULL,
  `firstphone` varchar(255) NOT NULL,
  `secondphone` varchar(255) NOT NULL,
  `mobilephone` varchar(255) NOT NULL,
  `street` varchar(255) NOT NULL,
  `city` varchar(255) NOT NULL,
  `zipcode` varchar(50) NOT NULL,
  `country` varchar(255) NOT NULL,
  `comment` text NOT NULL,
  `private` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `database_manager`
--

CREATE TABLE `database_manager` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `table_name` varchar(50) DEFAULT NULL,
  `table_field` varchar(60) DEFAULT NULL,
  `form_tab` int(11) DEFAULT NULL,
  `form_label` varchar(255) DEFAULT NULL,
  `form_type` varchar(50) DEFAULT NULL,
  `form_position` int(11) DEFAULT NULL,
  `form_columns` int(11) DEFAULT NULL,
  `form_regexp` varchar(255) DEFAULT NULL,
  `form_range` text,
  `default_value` varchar(255) DEFAULT NULL,
  `list_position` int(11) DEFAULT NULL,
  `list_align` varchar(20) DEFAULT NULL,
  `list_use_filter` int(4) DEFAULT NULL,
  `alt_position` int(11) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `is_integer` int(4) DEFAULT NULL,
  `is_required` int(4) DEFAULT NULL,
  `is_unique` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=63 ;

--
-- Dumping data for table `database_manager`
--

INSERT INTO `database_manager` VALUES
(1, 'Project', 'title', 1, 'Title', 'text', 1, 1, NULL, NULL, NULL, 1, 'left', 1, 2, '1', 0, 1, 0),
(2, 'Project', 'notes', 1, 'Notes', 'textarea', 2, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(3, 'Project', 'project_id', 1, 'Parent', 'selectValues', 3, 1, NULL, 'Project#id#title', NULL, 0, NULL, 1, 0, '1', 1, 1, 0),
(4, 'Project', 'start_date', 1, 'Start date', 'date', 4, 1, NULL, NULL, NULL, 3, 'center', 1, 3, '1', 0, 0, 0),
(5, 'Project', 'end_date', 1, 'End date', 'date', 5, 1, NULL, NULL, NULL, 4, 'center', 1, 4, '1', 0, 0, 0),
(6, 'Project', 'priority', 1, 'Priority', 'rating', 6, 1, NULL, '10', '5', 5, 'center', 1, 5, '1', 1, 0, 0),
(7, 'Project', 'current_status', 1, 'Current status', 'selectValues', 7, 1, NULL, '1#Offered|2#Ordered|3#Working|4#Ended|5#Stopped|6#Re-Opened|7#Waiting', '1', 6, 'center', 1, 6, '1', 1, 0, 0),
(8, 'Project', 'complete_percent', 1, 'Complete percent', 'percentage', 8, 1, NULL, NULL, NULL, 7, 'center', 1, 7, '1', 0, 0, 0),
(9, 'Project', 'budget', 1, 'Budget', 'text', 9, 1, NULL, NULL, NULL, 0, NULL, 1, 8, '1', 0, 0, 0),
(10, 'Project', 'hourly_wage_rate', 1, 'Hourly wage rate', 'text', 10, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '0', 0, 0, 0),
(11, 'Project', 'contact_id', 1, 'Contact', 'selectValues', 11, 1, NULL, 'Contact#id#name', NULL, 0, NULL, 1, 9, '1', 1, 0, 0),
(12, 'Contact', 'name', 1, 'Name', 'text', 1, 1, NULL, NULL, NULL, 1, 'left', 1, 0, '1', 0, 1, 0),
(13, 'Contact', 'email', 1, 'E-Mail', 'text', 2, 1, NULL, NULL, NULL, 2, 'left', 1, 0, '1', 0, 0, 0),
(14, 'Contact', 'company', 1, 'Company', 'text', 3, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(15, 'Contact', 'firstphone', 1, 'First phone', 'text', 4, 1, NULL, NULL, NULL, 3, 'left', 1, 0, '1', 0, 0, 0),
(16, 'Contact', 'secondphone', 1, 'Second phone', 'text', 5, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(17, 'Contact', 'mobilephone', 1, 'Mobile phone', 'text', 6, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(18, 'Contact', 'street', 1, 'Street', 'text', 7, 1, NULL, NULL, NULL, 4, 'left', 1, 0, '1', 0, 0, 0),
(19, 'Contact', 'city', 1, 'City', 'text', 8, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(20, 'Contact', 'zipcode', 1, 'Zip code', 'text', 9, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(21, 'Contact', 'country', 1, 'Country', 'text', 10, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(22, 'Contact', 'comment', 1, 'Comment', 'textarea', 11, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(23, 'Contact', 'private', 1, 'Private', 'selectValues', 12, 1, NULL, '0#No|1#Yes', '0', 5, 'center', 1, 0, '1', 1, 0, 0),
(24, 'Filemanager', 'title', 1, 'Title', 'text', 1, 1, NULL, NULL, NULL, 1, 'center', 1, 0, '1', 0, 1, 0),
(25, 'Filemanager', 'comments', 1, 'Comments', 'textarea', 2, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(26, 'Filemanager', 'project_id', 1, 'Project', 'selectValues', 3, 1, NULL, 'Project#id#title', NULL, 0, NULL, 1, 0, '1', 1, 1, 0),
(27, 'Filemanager', 'files', 1, 'Upload', 'upload', 5, 1, NULL, NULL, NULL, 3, 'center', 1, 0, '1', 0, 0, 0),
(28, 'Helpdesk', 'title', 1, 'Title', 'text', 1, 1, NULL, NULL, NULL, 1, 'center', 1, 0, '1', 0, 1, 0),
(29, 'Helpdesk', 'assigned', 1, 'Assigned', 'selectValues', 3, 1, NULL, 'User#id#lastname', NULL, 4, 'center', 1, 0, '1', 1, 0, 0),
(30, 'Helpdesk', 'date', 1, 'Date', 'display', 4, 1, NULL, NULL, NULL, 2, 'center', 1, 0, '1', 0, 1, 0),
(31, 'Helpdesk', 'project_id', 1, 'Project', 'selectValues', 6, 1, NULL, 'Project#id#title', NULL, 0, NULL, 1, 0, '1', 1, 1, 0),
(32, 'Helpdesk', 'priority', 1, 'Priority', 'rating', 7, 1, NULL, '10', '5', 5, 'center', 1, 0, '1', 1, 0, 0),
(33, 'Helpdesk', 'attachments', 1, 'Attachments', 'upload', 8, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(34, 'Helpdesk', 'description', 1, 'Description', 'textarea', 11, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(35, 'Helpdesk', 'status', 1, 'Status', 'selectValues', 12, 1, NULL, '1#Open|2#Assigned|3#Solved|4#Verified|5#Closed', '1', 6, 'center', 1, 0, '1', 1, 1, 0),
(36, 'Helpdesk', 'due_date', 1, 'Due date', 'date', 5, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(37, 'Helpdesk', 'author', 1, 'Author', 'display', 2, 1, NULL, 'User#id#lastname', NULL, 3, 'center', 1, 0, '1', 1, 1, 0),
(38, 'Helpdesk', 'solved_by', 1, 'Solved by', 'display', 9, 1, NULL, 'User#id#lastname', NULL, 0, NULL, 1, 0, '1', 1, 0, 0),
(39, 'Helpdesk', 'solved_date', 1, 'Solved date', 'display', 10, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(40, 'Helpdesk', 'contact_id', 1, 'Contact', 'selectValues', 13, 1, NULL, 'Contact#id#name', NULL, 0, NULL, 1, 0, '1', 1, 0, 0),
(41, 'Minutes', 'title', 1, 'Title', 'text', 1, 1, NULL, NULL, NULL, 3, 'center', 1, 0, '1', 0, 1, 0),
(42, 'Minutes', 'meeting_datetime', 1, 'Start', 'datetime', 2, 1, NULL, NULL, NULL, 1, 'center', 1, 0, '1', 0, 1, 0),
(43, 'Minutes', 'end_time', 1, 'End', 'time', 3, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(44, 'Minutes', 'project_id', 1, 'Project', 'selectValues', 4, 1, NULL, 'Project#id#title', NULL, 0, NULL, 1, 0, '1', 1, 1, 0),
(45, 'Minutes', 'description', 1, 'Description', 'textarea', 5, 1, NULL, NULL, NULL, 4, 'center', 1, 0, '1', 0, 0, 0),
(46, 'Minutes', 'place', 1, 'Place', 'text', 6, 1, NULL, NULL, NULL, 5, 'center', 1, 0, '1', 0, 0, 0),
(47, 'Minutes', 'moderator', 1, 'Moderator', 'text', 7, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(48, 'Minutes', 'participants_invited', 2, 'Invited', 'multipleSelectValues', 8, 1, NULL, 'User#id#username', NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(49, 'Minutes', 'participants_attending', 2, 'Attending', 'multipleSelectValues', 9, 1, NULL, 'User#id#username', NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(50, 'Minutes', 'participants_excused', 2, 'Excused', 'multipleSelectValues', 10, 1, NULL, 'User#id#username', NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(51, 'Minutes', 'item_status', 1, 'Status', 'selectValues', 11, 1, NULL, '1#Planned|2#Empty|3#Filled|4#Final', '1', 6, 'center', 1, 0, '1', 1, 0, 0),
(52, 'Note', 'project_id', 1, 'Project', 'selectValues', 3, 1, NULL, 'Project#id#title', NULL, 0, NULL, 1, 0, '1', 1, 1, 0),
(53, 'Note', 'title', 1, 'Title', 'text', 1, 1, NULL, NULL, NULL, 1, 'left', 1, 2, '1', 0, 1, 0),
(54, 'Note', 'comments', 1, 'Comments', 'textarea', 2, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(55, 'Todo', 'title', 1, 'Title', 'text', 1, 1, NULL, NULL, NULL, 1, 'left', 1, 2, '1', 0, 1, 0),
(56, 'Todo', 'notes', 1, 'Notes', 'textarea', 2, 1, NULL, NULL, NULL, 0, NULL, 1, 0, '1', 0, 0, 0),
(57, 'Todo', 'start_date', 1, 'Start date', 'date', 4, 1, NULL, NULL, NULL, 3, 'center', 1, 3, '1', 0, 0, 0),
(58, 'Todo', 'end_date', 1, 'End date', 'date', 5, 1, NULL, NULL, NULL, 4, 'center', 1, 4, '1', 0, 0, 0),
(59, 'Todo', 'priority', 1, 'Priority', 'rating', 6, 1, NULL, '10', '5', 5, 'center', 1, 5, '1', 1, 0, 0),
(60, 'Todo', 'current_status', 1, 'Current status', 'selectValues', 7, 1, NULL, '1#Waiting|2#Accepted|3#Working|4#Stopped|5#Ended', '1', 7, 'center', 1, 6, '1', 1, 0, 0),
(61, 'Todo', 'project_id', 1, 'Project', 'selectValues', 3, 1, NULL, 'Project#id#title', NULL, 0, NULL, 1, 0, '1', 1, 1, 0),
(62, 'Todo', 'user_id', 1, 'User', 'selectValues', 8, 1, NULL, 'User#id#lastname', NULL, 6, 'left', 1, 7, '1', 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `filemanager`
--

CREATE TABLE `filemanager` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_id` int(11) DEFAULT NULL,
  `title` varchar(100) NOT NULL,
  `comments` text,
  `project_id` int(11) NOT NULL,
  `files` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `titleproject_id` (`title`,`project_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `frontend_message`
--

CREATE TABLE `frontend_message` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `actor_id` int(11) NOT NULL,
  `project_id` int(11) NOT NULL,
  `process` varchar(255) DEFAULT NULL,
  `recipient_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `item_name` varchar(255) NOT NULL,
  `valid_until` datetime NOT NULL,
  `valid_from` datetime NOT NULL,
  `description` text NOT NULL,
  `details` text NOT NULL,
  `delivered` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `helpdesk`
--

CREATE TABLE `helpdesk` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `assigned` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `project_id` int(11) NOT NULL,
  `priority` int(2) DEFAULT NULL,
  `attachments` text,
  `description` text,
  `status` int(2) DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `author` int(11) DEFAULT NULL,
  `solved_by` int(11) DEFAULT NULL,
  `solved_date` date DEFAULT NULL,
  `contact_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `history`
--

CREATE TABLE `history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `field` varchar(255) NOT NULL,
  `old_value` text,
  `new_value` text,
  `action` varchar(50) NOT NULL,
  `datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `item_rights`
--

CREATE TABLE `item_rights` (
  `module_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `access` int(3) NOT NULL,
  PRIMARY KEY (`module_id`,`item_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `item_rights`
--

INSERT INTO `item_rights` VALUES
(1, 1, 1, 255),
(1, 1, 2, 255),
(1, 2, 1, 255),
(1, 2, 2, 1),
(1, 3, 1, 255),
(1, 3, 2, 255);

-- --------------------------------------------------------

--
-- Table structure for table `minutes`
--

CREATE TABLE `minutes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_id` int(11) DEFAULT NULL,
  `project_id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `meeting_datetime` datetime DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `place` varchar(255) DEFAULT NULL,
  `moderator` varchar(255) DEFAULT NULL,
  `participants_invited` text,
  `participants_attending` text,
  `participants_excused` text,
  `item_status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `minutes_item`
--

CREATE TABLE `minutes_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_id` int(11) NOT NULL,
  `project_id` int(11) NOT NULL,
  `minutes_id` int(11) NOT NULL,
  `topic_type` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `comment` text,
  `topic_date` date DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `module`
--

CREATE TABLE `module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `save_type` int(1) NOT NULL DEFAULT '0',
  `version` varchar(20) DEFAULT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- Dumping data for table `module`
--

INSERT INTO `module` VALUES
(1, 'Project', 'Project', 0, '6.2.1', 1),
(2, 'Calendar2', 'Calendar', 1, '6.1.0-beta1', 1),
(3, 'Contact', 'Contact', 1, '6.0.0', 1),
(4, 'Filemanager', 'Filemanager', 0, '6.1.5', 1),
(5, 'Gantt', 'Gantt', 0, '6.0.0', 1),
(6, 'Helpdesk', 'Helpdesk', 0, '6.0.0', 1),
(7, 'Minutes', 'Minute', 0, '6.0.0', 1),
(8, 'Note', 'Note', 0, '6.0.0', 1),
(9, 'Statistic', 'Statistic', 0, '6.0.0', 1),
(10, 'Timecard', 'Timecard', 1, '6.1.4', 1),
(11, 'Todo', 'Todo', 0, '6.0.0', 1);

-- --------------------------------------------------------

--
-- Table structure for table `module_tab_relation`
--

CREATE TABLE `module_tab_relation` (
  `tab_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  PRIMARY KEY (`tab_id`,`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `note`
--

CREATE TABLE `note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `comments` text,
  `owner_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `project`
--

CREATE TABLE `project` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) DEFAULT NULL,
  `path` varchar(50) NOT NULL DEFAULT '/',
  `title` varchar(255) NOT NULL,
  `notes` text,
  `owner_id` int(11) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `current_status` int(2) NOT NULL DEFAULT '3',
  `complete_percent` varchar(4) DEFAULT NULL,
  `hourly_wage_rate` varchar(10) DEFAULT NULL,
  `budget` varchar(10) DEFAULT NULL,
  `contact_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `titleproject_id` (`title`,`project_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `project`
--

INSERT INTO `project` VALUES
(1, NULL, '/', 'PHProjekt', 'Test', 1, '2009-05-12', '2009-07-28', 1, 3, '0', NULL, NULL, NULL),
(2, 1, '/1/', 'Project 1', 'Test', 1, '2009-05-02', '2009-07-02', 2, 3, '0', NULL, NULL, NULL),
(3, 2, '/1/2/', 'Sub Project', 'Test', 1, '2009-05-02', '2009-07-02', 2, 3, '0', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `project_module_permissions`
--

CREATE TABLE `project_module_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `project_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=28 ;

--
-- Dumping data for table `project_module_permissions`
--

INSERT INTO `project_module_permissions` VALUES
(1, 4, 2),
(2, 6, 2),
(3, 7, 2),
(4, 8, 2),
(5, 9, 2),
(6, 11, 2),
(7, 1, 1),
(8, 1, 2),
(9, 4, 2),
(10, 6, 2),
(11, 7, 2),
(12, 8, 2),
(13, 9, 2),
(14, 11, 2),
(15, 1, 3),
(16, 2, 1),
(17, 3, 1),
(18, 4, 1),
(19, 5, 1),
(20, 5, 2),
(21, 5, 3),
(22, 6, 1),
(23, 7, 1),
(24, 8, 1),
(25, 9, 1),
(26, 10, 1),
(27, 11, 1);

-- --------------------------------------------------------

--
-- Table structure for table `project_role_user_permissions`
--

CREATE TABLE `project_role_user_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `project_role_user_permissions`
--

INSERT INTO `project_role_user_permissions` VALUES
(1, 1, 1, 1),
(2, 1, 2, 1),
(3, 2, 1, 1),
(4, 2, 2, 2),
(5, 3, 1, 1),
(6, 3, 2, 4);

-- --------------------------------------------------------

--
-- Table structure for table `role`
--

CREATE TABLE `role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `parent` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `role`
--

INSERT INTO `role` VALUES
(1, 'Admin in All', NULL),
(2, 'can Read TODOs only', NULL),
(3, 'admin in PROJECTs', NULL),
(4, 'read only in All', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `role_module_permissions`
--

CREATE TABLE `role_module_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `access` int(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=36 ;

--
-- Dumping data for table `role_module_permissions`
--

INSERT INTO `role_module_permissions` VALUES
(1, 3, 1, 139),
(2, 2, 1, 0),
(3, 4, 1, 1),
(4, 2, 4, 0),
(5, 4, 4, 1),
(6, 3, 4, 0),
(7, 2, 5, 0),
(8, 4, 5, 1),
(9, 3, 5, 0),
(10, 2, 6, 0),
(11, 4, 6, 1),
(12, 3, 6, 0),
(13, 2, 7, 0),
(14, 4, 7, 1),
(15, 3, 7, 0),
(16, 2, 8, 0),
(17, 4, 8, 1),
(18, 3, 8, 0),
(19, 2, 9, 0),
(20, 4, 9, 1),
(21, 3, 9, 0),
(22, 3, 11, 0),
(23, 2, 11, 1),
(24, 4, 11, 1),
(25, 1, 1, 139),
(26, 1, 2, 139),
(27, 1, 3, 139),
(28, 1, 4, 139),
(29, 1, 5, 139),
(30, 1, 6, 139),
(31, 1, 7, 139),
(32, 1, 8, 139),
(33, 1, 9, 139),
(34, 1, 10, 139),
(35, 1, 11, 139);

-- --------------------------------------------------------

--
-- Table structure for table `search_display`
--

CREATE TABLE `search_display` (
  `module_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `project_id` int(11) NOT NULL,
  `first_display` text,
  `second_display` text,
  PRIMARY KEY (`module_id`,`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `search_words`
--

CREATE TABLE `search_words` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `word` varchar(255) NOT NULL,
  `count` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `search_word_module`
--

CREATE TABLE `search_word_module` (
  `item_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `word_id` int(11) NOT NULL,
  PRIMARY KEY (`item_id`,`module_id`,`word_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `setting`
--

CREATE TABLE `setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `key_value` varchar(255) NOT NULL,
  `value` text,
  `identifier` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `setting`
--

INSERT INTO `setting` VALUES
(1, 1, 0, 'password', '[[admin_pass]]', 'Core'),
(2, 1, 0, 'email', '[[admin_email]]', 'Core'),
(3, 1, 0, 'language', 'en', 'Core'),
(4, 1, 0, 'timeZone', '000', 'Core'),
(5, 2, 0, 'password', '7177e40e772c1cfe71be73d37c524586', 'Core'),
(6, 2, 0, 'email', 'test@test.com', 'Core'),
(7, 2, 0, 'language', 'en', 'Core'),
(8, 2, 0, 'timeZone', '000', 'Core');

-- --------------------------------------------------------

--
-- Table structure for table `tab`
--

CREATE TABLE `tab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `tab`
--

INSERT INTO `tab` VALUES
(1, 'Basic Data'),
(2, 'People');

-- --------------------------------------------------------

--
-- Table structure for table `tags`
--

CREATE TABLE `tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `word` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tags_modules_items`
--

CREATE TABLE `tags_modules_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `timecard`
--

CREATE TABLE `timecard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `owner_id` int(11) DEFAULT NULL,
  `start_datetime` datetime DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `minutes` int(11) DEFAULT NULL,
  `project_id` int(11) DEFAULT NULL,
  `notes` text,
  `module_id` int(11) DEFAULT '1',
  `item_id` int(11) DEFAULT NULL,
  `uri` varchar(255) NOT NULL,
  `uid` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `todo`
--

CREATE TABLE `todo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `notes` text,
  `owner_id` int(11) DEFAULT NULL,
  `project_id` int(11) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `current_status` int(2) NOT NULL DEFAULT '1',
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `uploaded_unused_files`
--

CREATE TABLE `uploaded_unused_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `hash` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user`
--

CREATE TABLE `user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) NOT NULL,
  `firstname` varchar(255) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `status` varchar(1) DEFAULT 'A',
  `admin` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `user`
--

INSERT INTO `user` VALUES
(1, '[[admin_username]]', 'Admin', 'Admin', 'A', 1),
(2, 'test', 'Test', 'Test', 'A', 0);

-- --------------------------------------------------------

--
-- Table structure for table `user_proxy`
--

CREATE TABLE `user_proxy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `proxyed_id` int(11) NOT NULL,
  `proxying_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
