/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


if(!dojo._hasResource["dojox.gfx3d.object"]){dojo._hasResource["dojox.gfx3d.object"]=!0;dojo.provide("dojox.gfx3d.object");dojo.require("dojox.gfx");dojo.require("dojox.gfx3d.lighting");dojo.require("dojox.gfx3d.scheduler");dojo.require("dojox.gfx3d.vector");dojo.require("dojox.gfx3d.gradient");var out=function(a,b){arguments.length>1&&(a=b);for(var c in a);};dojo.declare("dojox.gfx3d.Object",null,{constructor:function(){this.shape=this.fillStyle=this.strokeStyle=this.parent=this.renderer=this.cache=
this.matrix=this.object=null},setObject:function(a){this.object=dojox.gfx.makeParameters(this.object,a);return this},setTransform:function(a){this.matrix=dojox.gfx3d.matrix.clone(a?dojox.gfx3d.matrix.normalize(a):dojox.gfx3d.identity,!0);return this},applyRightTransform:function(a){return a?this.setTransform([this.matrix,a]):this},applyLeftTransform:function(a){return a?this.setTransform([a,this.matrix]):this},applyTransform:function(a){return a?this.setTransform([this.matrix,a]):this},setFill:function(a){this.fillStyle=
a;return this},setStroke:function(a){this.strokeStyle=a;return this},toStdFill:function(a,b){return this.fillStyle&&typeof this.fillStyle.type!="undefined"?a[this.fillStyle.type](b,this.fillStyle.finish,this.fillStyle.color):this.fillStyle},invalidate:function(){this.renderer.addTodo(this)},destroy:function(){if(this.shape){var a=this.shape.getParent();a&&a.remove(this.shape);this.shape=null}},render:function(){throw"Pure virtual function, not implemented";},draw:function(){throw"Pure virtual function, not implemented";
},getZOrder:function(){return 0},getOutline:function(){return null}});dojo.declare("dojox.gfx3d.Scene",dojox.gfx3d.Object,{constructor:function(){this.objects=[];this.todos=[];this.schedule=dojox.gfx3d.scheduler.zOrder;this._draw=dojox.gfx3d.drawer.conservative},setFill:function(a){this.fillStyle=a;dojo.forEach(this.objects,function(b){b.setFill(a)});return this},setStroke:function(a){this.strokeStyle=a;dojo.forEach(this.objects,function(b){b.setStroke(a)});return this},render:function(a,b){var c=
dojox.gfx3d.matrix.multiply(a,this.matrix);if(b)this.todos=this.objects;dojo.forEach(this.todos,function(a){a.render(c,b)})},draw:function(){this.objects=this.schedule(this.objects);this._draw(this.todos,this.objects,this.renderer)},addTodo:function(a){dojo.every(this.todos,function(b){return b!=a})&&(this.todos.push(a),this.invalidate())},invalidate:function(){this.parent.addTodo(this)},getZOrder:function(){var a=0;dojo.forEach(this.objects,function(b){a+=b.getZOrder()});return this.objects.length>
1?a/this.objects.length:0}});dojo.declare("dojox.gfx3d.Edges",dojox.gfx3d.Object,{constructor:function(){this.object=dojo.clone(dojox.gfx3d.defaultEdges)},setObject:function(a,b){this.object=dojox.gfx.makeParameters(this.object,a instanceof Array?{points:a,style:b}:a);return this},getZOrder:function(){var a=0;dojo.forEach(this.cache,function(b){a+=b.z});return this.cache.length>1?a/this.cache.length:0},render:function(a){var b=dojox.gfx3d.matrix.multiply(a,this.matrix);this.cache=dojo.map(this.object.points,
function(a){return dojox.gfx3d.matrix.multiplyPoint(b,a)})},draw:function(){var a=this.cache;this.shape?this.shape.setShape(""):this.shape=this.renderer.createPath();var b=this.shape.setAbsoluteMode("absolute");if(this.object.style=="strip"||this.object.style=="loop")b.moveTo(a[0].x,a[0].y),dojo.forEach(a.slice(1),function(a){b.lineTo(a.x,a.y)}),this.object.style=="loop"&&b.closePath();else for(var c=0;c<this.cache.length;)b.moveTo(a[c].x,a[c].y),c++,b.lineTo(a[c].x,a[c].y),c++;b.setStroke(this.strokeStyle)}});
dojo.declare("dojox.gfx3d.Orbit",dojox.gfx3d.Object,{constructor:function(){this.object=dojo.clone(dojox.gfx3d.defaultOrbit)},render:function(a){var b=dojox.gfx3d.matrix.multiply(a,this.matrix),a=[0,Math.PI/4,Math.PI/3],c=dojox.gfx3d.matrix.multiplyPoint(b,this.object.center),d=dojo.map(a,function(a){return{x:this.center.x+this.radius*Math.cos(a),y:this.center.y+this.radius*Math.sin(a),z:this.center.z}},this.object),d=dojo.map(d,function(a){return dojox.gfx3d.matrix.multiplyPoint(b,a)}),a=dojox.gfx3d.vector.normalize(d),
d=dojo.map(d,function(a){return dojox.gfx3d.vector.substract(a,c)}),e={xx:d[0].x*d[0].y,xy:d[0].y*d[0].y,xz:1,yx:d[1].x*d[1].y,yy:d[1].y*d[1].y,yz:1,zx:d[2].x*d[2].y,zy:d[2].y*d[2].y,zz:1,dx:0,dy:0,dz:0},f=dojo.map(d,function(a){return-Math.pow(a.x,2)}),e=dojox.gfx3d.matrix.multiplyPoint(dojox.gfx3d.matrix.invert(e),f[0],f[1],f[2]),g=Math.atan2(e.x,1-e.y)/2,h=dojo.map(d,function(a){return dojox.gfx.matrix.multiplyPoint(dojox.gfx.matrix.rotate(-g),a.x,a.y)}),d=Math.pow(h[0].x,2),e=Math.pow(h[0].y,
2),f=Math.pow(h[1].x,2),h=Math.pow(h[1].y,2);this.cache={cx:c.x,cy:c.y,rx:Math.sqrt((d*h-e*f)/(h-e)),ry:Math.sqrt((d*h-e*f)/(d-f)),theta:g,normal:a}},draw:function(a){this.shape?this.shape.setShape(this.cache):this.shape=this.renderer.createEllipse(this.cache);this.shape.applyTransform(dojox.gfx.matrix.rotateAt(this.cache.theta,this.cache.cx,this.cache.cy)).setStroke(this.strokeStyle).setFill(this.toStdFill(a,this.cache.normal))}});dojo.declare("dojox.gfx3d.Path3d",dojox.gfx3d.Object,{constructor:function(){this.object=
dojo.clone(dojox.gfx3d.defaultPath3d);this.segments=[];this.absolute=!0;this.last={};this.path=""},_collectArgs:function(a,b){for(var c=0;c<b.length;++c){var d=b[c];typeof d=="boolean"?a.push(d?1:0):typeof d=="number"?a.push(d):d instanceof Array?this._collectArgs(a,d):"x"in d&&"y"in d&&(a.push(d.x),a.push(d.y))}},_validSegments:{m:3,l:3,z:0},_pushSegment:function(a,b){var c=this._validSegments[a.toLowerCase()];typeof c=="number"&&(c?b.length>=c&&(c={action:a,args:b.slice(0,b.length-b.length%c)},
this.segments.push(c)):(c={action:a,args:[]},this.segments.push(c)))},moveTo:function(){var a=[];this._collectArgs(a,arguments);this._pushSegment(this.absolute?"M":"m",a);return this},lineTo:function(){var a=[];this._collectArgs(a,arguments);this._pushSegment(this.absolute?"L":"l",a);return this},closePath:function(){this._pushSegment("Z",[]);return this},render:function(a){var b=dojox.gfx3d.matrix.multiply(a,this.matrix),c="",d=this._validSegments;dojo.forEach(this.segments,function(a){c+=a.action;
for(var f=0;f<a.args.length;f+=d[a.action.toLowerCase()]){var g=dojox.gfx3d.matrix.multiplyPoint(b,a.args[f],a.args[f+1],a.args[f+2]);c+=" "+g.x+" "+g.y}});this.cache=c},_draw:function(){return this.parent.createPath(this.cache)}});dojo.declare("dojox.gfx3d.Triangles",dojox.gfx3d.Object,{constructor:function(){this.object=dojo.clone(dojox.gfx3d.defaultTriangles)},setObject:function(a,b){this.object=a instanceof Array?dojox.gfx.makeParameters(this.object,{points:a,style:b}):dojox.gfx.makeParameters(this.object,
a);return this},render:function(a){var b=dojox.gfx3d.matrix.multiply(a,this.matrix),a=dojo.map(this.object.points,function(a){return dojox.gfx3d.matrix.multiplyPoint(b,a)});this.cache=[];var c=a.slice(0,2),d=a[0];if(this.object.style=="strip")dojo.forEach(a.slice(2),function(a){c.push(a);c.push(c[0]);this.cache.push(c);c=c.slice(1,3)},this);else if(this.object.style=="fan")dojo.forEach(a.slice(2),function(a){c.push(a);c.push(d);this.cache.push(c);c=[d,a]},this);else for(var e=0;e<a.length;)this.cache.push([a[e],
a[e+1],a[e+2],a[e]]),e+=3},draw:function(a){this.cache=dojox.gfx3d.scheduler.bsp(this.cache,function(a){return a});this.shape?this.shape.clear():this.shape=this.renderer.createGroup();dojo.forEach(this.cache,function(b){this.shape.createPolyline(b).setStroke(this.strokeStyle).setFill(this.toStdFill(a,dojox.gfx3d.vector.normalize(b)))},this)},getZOrder:function(){var a=0;dojo.forEach(this.cache,function(b){a+=(b[0].z+b[1].z+b[2].z)/3});return this.cache.length>1?a/this.cache.length:0}});dojo.declare("dojox.gfx3d.Quads",
dojox.gfx3d.Object,{constructor:function(){this.object=dojo.clone(dojox.gfx3d.defaultQuads)},setObject:function(a,b){this.object=dojox.gfx.makeParameters(this.object,a instanceof Array?{points:a,style:b}:a);return this},render:function(a){var b=dojox.gfx3d.matrix.multiply(a,this.matrix),c=dojo.map(this.object.points,function(a){return dojox.gfx3d.matrix.multiplyPoint(b,a)});this.cache=[];if(this.object.style=="strip")for(var d=c.slice(0,2),a=2;a<c.length;)d=d.concat([c[a],c[a+1],d[0]]),this.cache.push(d),
d=d.slice(2,4),a+=2;else for(a=0;a<c.length;)this.cache.push([c[a],c[a+1],c[a+2],c[a+3],c[a]]),a+=4},draw:function(a){this.cache=dojox.gfx3d.scheduler.bsp(this.cache,function(a){return a});this.shape?this.shape.clear():this.shape=this.renderer.createGroup();for(var b=0;b<this.cache.length;b++)this.shape.createPolyline(this.cache[b]).setStroke(this.strokeStyle).setFill(this.toStdFill(a,dojox.gfx3d.vector.normalize(this.cache[b])))},getZOrder:function(){for(var a=0,b=0;b<this.cache.length;b++){var c=
this.cache[b];a+=(c[0].z+c[1].z+c[2].z+c[3].z)/4}return this.cache.length>1?a/this.cache.length:0}});dojo.declare("dojox.gfx3d.Polygon",dojox.gfx3d.Object,{constructor:function(){this.object=dojo.clone(dojox.gfx3d.defaultPolygon)},setObject:function(a){this.object=dojox.gfx.makeParameters(this.object,a instanceof Array?{path:a}:a);return this},render:function(a){var b=dojox.gfx3d.matrix.multiply(a,this.matrix);this.cache=dojo.map(this.object.path,function(a){return dojox.gfx3d.matrix.multiplyPoint(b,
a)});this.cache.push(this.cache[0])},draw:function(a){this.shape?this.shape.setShape({points:this.cache}):this.shape=this.renderer.createPolyline({points:this.cache});this.shape.setStroke(this.strokeStyle).setFill(this.toStdFill(a,dojox.gfx3d.matrix.normalize(this.cache)))},getZOrder:function(){for(var a=0,b=0;b<this.cache.length;b++)a+=this.cache[b].z;return this.cache.length>1?a/this.cache.length:0},getOutline:function(){return this.cache.slice(0,3)}});dojo.declare("dojox.gfx3d.Cube",dojox.gfx3d.Object,
{constructor:function(){this.object=dojo.clone(dojox.gfx3d.defaultCube);this.polygons=[]},setObject:function(a){this.object=dojox.gfx.makeParameters(this.object,a)},render:function(a){var b=this.object.top,c=this.object.bottom,d={x:c.x,y:b.y,z:b.z},e={x:c.x,y:c.y,z:b.z},f={x:b.x,y:c.y,z:b.z},g={x:b.x,y:b.y,z:c.z},h={x:c.x,y:b.y,z:c.z},i={x:b.x,y:c.y,z:c.z},b=[b,d,e,f,g,h,c,i],j=dojox.gfx3d.matrix.multiply(a,this.matrix),a=dojo.map(b,function(a){return dojox.gfx3d.matrix.multiplyPoint(j,a)}),b=a[0],
d=a[1],e=a[2],f=a[3],g=a[4],h=a[5],c=a[6],i=a[7];this.cache=[[b,d,e,f,b],[g,h,c,i,g],[b,f,i,g,b],[f,e,c,i,f],[e,d,h,c,e],[d,b,g,h,d]]},draw:function(a){this.cache=dojox.gfx3d.scheduler.bsp(this.cache,function(a){return a});var b=this.cache.slice(3);this.shape?this.shape.clear():this.shape=this.renderer.createGroup();for(var c=0;c<b.length;c++)this.shape.createPolyline(b[c]).setStroke(this.strokeStyle).setFill(this.toStdFill(a,dojox.gfx3d.vector.normalize(b[c])))},getZOrder:function(){return(this.cache[0][0].z+
this.cache[1][2].z)/2}});dojo.declare("dojox.gfx3d.Cylinder",dojox.gfx3d.Object,{constructor:function(){this.object=dojo.clone(dojox.gfx3d.defaultCylinder)},render:function(a){var b=dojox.gfx3d.matrix.multiply(a,this.matrix),a=[0,Math.PI/4,Math.PI/3],c=dojox.gfx3d.matrix.multiplyPoint(b,this.object.center),a=dojo.map(a,function(a){return{x:this.center.x+this.radius*Math.cos(a),y:this.center.y+this.radius*Math.sin(a),z:this.center.z}},this.object),a=dojo.map(a,function(a){return dojox.gfx3d.vector.substract(dojox.gfx3d.matrix.multiplyPoint(b,
a),c)}),d={xx:a[0].x*a[0].y,xy:a[0].y*a[0].y,xz:1,yx:a[1].x*a[1].y,yy:a[1].y*a[1].y,yz:1,zx:a[2].x*a[2].y,zy:a[2].y*a[2].y,zz:1,dx:0,dy:0,dz:0},e=dojo.map(a,function(a){return-Math.pow(a.x,2)}),d=dojox.gfx3d.matrix.multiplyPoint(dojox.gfx3d.matrix.invert(d),e[0],e[1],e[2]),f=Math.atan2(d.x,1-d.y)/2,a=dojo.map(a,function(a){return dojox.gfx.matrix.multiplyPoint(dojox.gfx.matrix.rotate(-f),a.x,a.y)}),d=Math.pow(a[0].x,2),e=Math.pow(a[0].y,2),g=Math.pow(a[1].x,2),h=Math.pow(a[1].y,2),a=Math.sqrt((d*
h-e*g)/(h-e)),d=Math.sqrt((d*h-e*g)/(d-g));a<d&&(e=a,a=d,d=e,f-=Math.PI/2);e=dojox.gfx3d.matrix.multiplyPoint(b,dojox.gfx3d.vector.sum(this.object.center,{x:0,y:0,z:this.object.height}));g=this.fillStyle.type=="constant"?this.fillStyle.color:dojox.gfx3d.gradient(this.renderer.lighting,this.fillStyle,this.object.center,this.object.radius,Math.PI,2*Math.PI,b);if(isNaN(a)||isNaN(d)||isNaN(f))a=this.object.radius,f=d=0;this.cache={center:c,top:e,rx:a,ry:d,theta:f,gradient:g}},draw:function(){var a=this.cache,
b=dojox.gfx3d.vector,c=dojox.gfx.matrix,d=[a.center,a.top],e=b.substract(a.top,a.center);b.dotProduct(e,this.renderer.lighting.incident)>0&&(d=[a.top,a.center],e=b.substract(a.center,a.top));b=this.renderer.lighting[this.fillStyle.type](e,this.fillStyle.finish,this.fillStyle.color);e=Math.sqrt(Math.pow(a.center.x-a.top.x,2)+Math.pow(a.center.y-a.top.y,2));this.shape?this.shape.clear():this.shape=this.renderer.createGroup();this.shape.createPath("").moveTo(0,-a.rx).lineTo(e,-a.rx).lineTo(e,a.rx).lineTo(0,
a.rx).arcTo(a.ry,a.rx,0,!0,!0,0,-a.rx).setFill(a.gradient).setStroke(this.strokeStyle).setTransform([c.translate(d[0]),c.rotate(Math.atan2(d[1].y-d[0].y,d[1].x-d[0].x))]);a.rx>0&&a.ry>0&&this.shape.createEllipse({cx:d[1].x,cy:d[1].y,rx:a.rx,ry:a.ry}).setFill(b).setStroke(this.strokeStyle).applyTransform(c.rotateAt(a.theta,d[1]))}});dojo.declare("dojox.gfx3d.Viewport",dojox.gfx.Group,{constructor:function(){this.dimension=null;this.objects=[];this.todos=[];this.renderer=this;this.schedule=dojox.gfx3d.scheduler.zOrder;
this.draw=dojox.gfx3d.drawer.conservative;this.deep=!1;this.lights=[];this.lighting=null},setCameraTransform:function(a){this.camera=dojox.gfx3d.matrix.clone(a?dojox.gfx3d.matrix.normalize(a):dojox.gfx3d.identity,!0);this.invalidate();return this},applyCameraRightTransform:function(a){return a?this.setCameraTransform([this.camera,a]):this},applyCameraLeftTransform:function(a){return a?this.setCameraTransform([a,this.camera]):this},applyCameraTransform:function(a){return this.applyCameraRightTransform(a)},
setLights:function(a,b,c){this.lights=a instanceof Array?{sources:a,ambient:b,specular:c}:a;this.lighting=new dojox.gfx3d.lighting.Model({x:0,y:0,z:1},this.lights.sources,this.lights.ambient,this.lights.specular);this.invalidate();return this},addLights:function(a){return this.setLights(this.lights.sources.concat(a))},addTodo:function(a){dojo.every(this.todos,function(b){return b!=a})&&this.todos.push(a)},invalidate:function(){this.deep=!0;this.todos=this.objects},setDimensions:function(a){if(a){var b=
dojo.isString(a.width)?parseInt(a.width):a.width,a=dojo.isString(a.height)?parseInt(a.height):a.height;if(this.rawNode){var c=this.rawNode.style;c.height=a;c.width=b}this.dimension={width:b,height:a}}else this.dimension=null},render:function(){if(this.todos.length){for(var a=dojox.gfx3d.matrix,b=0;b<this.todos.length;b++)this.todos[b].render(dojox.gfx3d.matrix.normalize([a.cameraRotateXg(180),a.cameraTranslate(0,this.dimension.height,0),this.camera]),this.deep);this.objects=this.schedule(this.objects);
this.draw(this.todos,this.objects,this);this.todos=[];this.deep=!1}}});dojox.gfx3d.Viewport.nodeType=dojox.gfx.Group.nodeType;dojox.gfx3d._creators={createEdges:function(a,b){return this.create3DObject(dojox.gfx3d.Edges,a,b)},createTriangles:function(a,b){return this.create3DObject(dojox.gfx3d.Triangles,a,b)},createQuads:function(a,b){return this.create3DObject(dojox.gfx3d.Quads,a,b)},createPolygon:function(a){return this.create3DObject(dojox.gfx3d.Polygon,a)},createOrbit:function(a){return this.create3DObject(dojox.gfx3d.Orbit,
a)},createCube:function(a){return this.create3DObject(dojox.gfx3d.Cube,a)},createCylinder:function(a){return this.create3DObject(dojox.gfx3d.Cylinder,a)},createPath3d:function(a){return this.create3DObject(dojox.gfx3d.Path3d,a)},createScene:function(){return this.create3DObject(dojox.gfx3d.Scene)},create3DObject:function(a,b,c){a=new a;this.adopt(a);b&&a.setObject(b,c);return a},adopt:function(a){a.renderer=this.renderer;a.parent=this;this.objects.push(a);this.addTodo(a);return this},abandon:function(a){for(var b=
0;b<this.objects.length;++b)this.objects[b]==a&&this.objects.splice(b,1);a.parent=null;return this},setScheduler:function(a){this.schedule=a},setDrawer:function(a){this.draw=a}};dojo.extend(dojox.gfx3d.Viewport,dojox.gfx3d._creators);dojo.extend(dojox.gfx3d.Scene,dojox.gfx3d._creators);delete dojox.gfx3d._creators;dojo.extend(dojox.gfx.Surface,{createViewport:function(){var a=this.createObject(dojox.gfx3d.Viewport,null,!0);a.setDimensions(this.getDimensions());return a}})};