

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]access`
-- 

CREATE TABLE `[[dbprefix]]access` (
  `id` int(10) NOT NULL auto_increment,
  `survey_id` int(10) NOT NULL default '0',
  `realm` varchar(64) default NULL,
  `maxlogin` int(10) default '0',
  `resume` char(1) NOT NULL default 'N',
  `navigate` char(1) NOT NULL default 'N',
  PRIMARY KEY  (`id`),
  KEY `[[dbprefix]]survey_id` (`survey_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `[[dbprefix]]access`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]conditions`
-- 

CREATE TABLE `[[dbprefix]]conditions` (
  `id` int(10) NOT NULL auto_increment,
  `survey_id` int(10) NOT NULL default '0',
  `q1_id` int(10) NOT NULL default '0',
  `q2_id` int(10) NOT NULL default '0',
  `cond` int(10) NOT NULL default '0',
  `cond_value` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `[[dbprefix]]conditions`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]designer`
-- 

CREATE TABLE `[[dbprefix]]designer` (
  `username` varchar(64) NOT NULL default '',
  `password` varchar(64) NOT NULL default '',
  `auth` varchar(16) NOT NULL default 'BASIC',
  `realm` varchar(64) NOT NULL default '',
  `fname` varchar(255) default NULL,
  `lname` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `pdesign` char(1) NOT NULL default 'Y',
  `pstatus` char(1) NOT NULL default 'N',
  `pdata` char(1) NOT NULL default 'N',
  `pall` char(1) NOT NULL default 'N',
  `pgroup` char(1) NOT NULL default 'N',
  `puser` char(1) NOT NULL default 'N',
  `disabled` char(1) NOT NULL default 'N',
  `changed` datetime NOT NULL default '0000-00-00 00:00:00',
  `expiration` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`username`,`realm`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]designer`
-- 

INSERT INTO `[[dbprefix]]designer` VALUES ('[[admin_username]]', PASSWORD('[[admin_pass]]'), 'BASIC', 'superuser', '[[admin_fname]]', '[[admin_lname]]', '[[admin_email]]', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', '0000-00-00 00:00:00', '0000-00-00 00:00:00');

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]question`
-- 

CREATE TABLE `[[dbprefix]]question` (
  `id` int(10) NOT NULL auto_increment,
  `survey_id` int(10) NOT NULL default '0',
  `name` varchar(30) NOT NULL default '',
  `type_id` int(10) NOT NULL default '0',
  `result_id` int(10) default NULL,
  `length` int(11) NOT NULL default '0',
  `precise` int(11) NOT NULL default '0',
  `position` int(10) NOT NULL default '0',
  `content` text,
  `required` char(1) NOT NULL default 'N',
  `deleted` char(1) NOT NULL default 'N',
  `public` char(1) NOT NULL default 'Y',
  `ans_uniq` char(1) NOT NULL default 'N',
  PRIMARY KEY  (`id`),
  KEY `[[dbprefix]]result_id` (`result_id`),
  KEY `[[dbprefix]]survey_id` (`survey_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `[[dbprefix]]question`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]question_choice`
-- 

CREATE TABLE `[[dbprefix]]question_choice` (
  `id` int(10) NOT NULL auto_increment,
  `question_id` int(10) NOT NULL default '0',
  `content` text,
  `value` text,
  `feedback` text,
  `credit` double default NULL,
  PRIMARY KEY  (`id`),
  KEY `[[dbprefix]]question_id` (`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `[[dbprefix]]question_choice`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]question_type`
-- 

CREATE TABLE `[[dbprefix]]question_type` (
  `id` int(10) NOT NULL auto_increment,
  `type` varchar(32) NOT NULL default '',
  `has_choices` char(1) NOT NULL default '',
  `response_table` varchar(32) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=101 ;

-- 
-- Dumping data for table `[[dbprefix]]question_type`
-- 

INSERT INTO `[[dbprefix]]question_type` VALUES (1, 'Yes/No', 'N', 'response_bool');
INSERT INTO `[[dbprefix]]question_type` VALUES (2, 'Text Box', 'N', 'response_text');
INSERT INTO `[[dbprefix]]question_type` VALUES (3, 'Essay Box', 'N', 'response_text');
INSERT INTO `[[dbprefix]]question_type` VALUES (4, 'Radio Buttons', 'Y', 'response_single');
INSERT INTO `[[dbprefix]]question_type` VALUES (5, 'Check Boxes', 'Y', 'response_multiple');
INSERT INTO `[[dbprefix]]question_type` VALUES (6, 'Dropdown Box', 'Y', 'response_single');
INSERT INTO `[[dbprefix]]question_type` VALUES (8, 'Rate (scale 1..5)', 'Y', 'response_rank');
INSERT INTO `[[dbprefix]]question_type` VALUES (9, 'Date', 'N', 'response_date');
INSERT INTO `[[dbprefix]]question_type` VALUES (10, 'Numeric', 'N', 'response_text');
INSERT INTO `[[dbprefix]]question_type` VALUES (99, 'Page Break', 'N', '');
INSERT INTO `[[dbprefix]]question_type` VALUES (100, 'Section Text', 'N', '');

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]realm`
-- 

CREATE TABLE `[[dbprefix]]realm` (
  `name` varchar(64) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `changed` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]realm`
-- 

INSERT INTO `[[dbprefix]]realm` VALUES ('superuser', 'ESP System Administrators', '0000-00-00 00:00:00');
INSERT INTO `[[dbprefix]]realm` VALUES ('auto', 'Self added users', '0000-00-00 00:00:00');

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]respondent`
-- 

CREATE TABLE `[[dbprefix]]respondent` (
  `username` varchar(64) NOT NULL default '',
  `password` varchar(64) NOT NULL default '',
  `auth` varchar(16) NOT NULL default 'BASIC',
  `realm` varchar(64) NOT NULL default '',
  `fname` varchar(255) default NULL,
  `lname` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `disabled` char(1) NOT NULL default 'N',
  `changed` datetime NOT NULL default '0000-00-00 00:00:00',
  `expiration` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`username`,`realm`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]respondent`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]response`
-- 

CREATE TABLE `[[dbprefix]]response` (
  `id` int(10) NOT NULL auto_increment,
  `survey_id` int(10) NOT NULL default '0',
  `submitted` datetime NOT NULL default '0000-00-00 00:00:00',
  `complete` char(1) NOT NULL default 'N',
  `username` varchar(64) default NULL,
  `ip` varchar(64) default NULL,
  PRIMARY KEY  (`id`),
  KEY `[[dbprefix]]survey_id` (`survey_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `[[dbprefix]]response`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]response_bool`
-- 

CREATE TABLE `[[dbprefix]]response_bool` (
  `response_id` int(10) NOT NULL default '0',
  `question_id` int(10) NOT NULL default '0',
  `choice_id` char(1) NOT NULL default '',
  PRIMARY KEY  (`response_id`,`question_id`),
  KEY `[[dbprefix]]response_id` (`response_id`),
  KEY `[[dbprefix]]question_id` (`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]response_bool`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]response_date`
-- 

CREATE TABLE `[[dbprefix]]response_date` (
  `response_id` int(10) NOT NULL default '0',
  `question_id` int(10) NOT NULL default '0',
  `response` date default NULL,
  PRIMARY KEY  (`response_id`,`question_id`),
  KEY `[[dbprefix]]response_id` (`response_id`),
  KEY `[[dbprefix]]question_id` (`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]response_date`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]response_multiple`
-- 

CREATE TABLE `[[dbprefix]]response_multiple` (
  `id` int(10) NOT NULL auto_increment,
  `response_id` int(10) NOT NULL default '0',
  `question_id` int(10) NOT NULL default '0',
  `choice_id` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `[[dbprefix]]response_id` (`response_id`),
  KEY `[[dbprefix]]question_id` (`question_id`),
  KEY `[[dbprefix]]choice_id` (`choice_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `[[dbprefix]]response_multiple`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]response_other`
-- 

CREATE TABLE `[[dbprefix]]response_other` (
  `response_id` int(10) NOT NULL default '0',
  `question_id` int(10) NOT NULL default '0',
  `choice_id` int(10) NOT NULL default '0',
  `response` text,
  PRIMARY KEY  (`response_id`,`question_id`,`choice_id`),
  KEY `[[dbprefix]]response_id` (`response_id`),
  KEY `[[dbprefix]]choice_id` (`choice_id`),
  KEY `[[dbprefix]]question_id` (`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]response_other`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]response_rank`
-- 

CREATE TABLE `[[dbprefix]]response_rank` (
  `response_id` int(10) NOT NULL default '0',
  `question_id` int(10) NOT NULL default '0',
  `choice_id` int(10) NOT NULL default '0',
  `rank` int(11) NOT NULL default '0',
  PRIMARY KEY  (`response_id`,`question_id`,`choice_id`),
  KEY `[[dbprefix]]response_id` (`response_id`),
  KEY `[[dbprefix]]question_id` (`question_id`),
  KEY `[[dbprefix]]choice_id` (`choice_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]response_rank`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]response_single`
-- 

CREATE TABLE `[[dbprefix]]response_single` (
  `response_id` int(10) NOT NULL default '0',
  `question_id` int(10) NOT NULL default '0',
  `choice_id` int(10) NOT NULL default '0',
  PRIMARY KEY  (`response_id`,`question_id`),
  KEY `[[dbprefix]]response_id` (`response_id`),
  KEY `[[dbprefix]]question_id` (`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]response_single`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]response_text`
-- 

CREATE TABLE `[[dbprefix]]response_text` (
  `response_id` int(10) NOT NULL default '0',
  `question_id` int(10) NOT NULL default '0',
  `response` text,
  PRIMARY KEY  (`response_id`,`question_id`),
  KEY `[[dbprefix]]response_id` (`response_id`),
  KEY `[[dbprefix]]question_id` (`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]response_text`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]survey`
-- 

CREATE TABLE `[[dbprefix]]survey` (
  `id` int(10) NOT NULL auto_increment,
  `name` varchar(64) NOT NULL default '',
  `owner` varchar(16) NOT NULL default '',
  `realm` varchar(64) NOT NULL default '',
  `public` char(1) NOT NULL default 'Y',
  `status` int(10) NOT NULL default '0',
  `open_date` datetime default NULL,
  `close_date` datetime default NULL,
  `title` varchar(255) NOT NULL default '',
  `email` varchar(64) default NULL,
  `subtitle` text,
  `info` text,
  `theme` varchar(64) default NULL,
  `thanks_page` varchar(255) default NULL,
  `thank_head` varchar(255) default NULL,
  `thank_body` text,
  `changed` datetime NOT NULL default '0000-00-00 00:00:00',
  `auto_num` char(1) NOT NULL default 'Y',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `[[dbprefix]]name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `[[dbprefix]]survey`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]survey_statistics`
-- 

CREATE TABLE `[[dbprefix]]survey_statistics` (
  `survey_id` int(10) NOT NULL default '0',
  `loginfail` int(10) NOT NULL default '0',
  `attempted` int(10) NOT NULL default '0',
  `abandoned` int(10) NOT NULL default '0',
  `suspended` int(10) NOT NULL default '0',
  `completed` int(10) NOT NULL default '0',
  PRIMARY KEY  (`survey_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]survey_statistics`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]version`
-- 

CREATE TABLE `[[dbprefix]]version` (
  `versionid` varchar(16) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]version`
-- 

INSERT INTO `[[dbprefix]]version` VALUES ('2.1.4');
