
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `phpdev320`
--

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_cron`
--

CREATE TABLE `pds_core_cron` (
  `menu_id` varchar(64) NOT NULL,
  `cron_desc` varchar(255) default NULL,
  `cron_type` int(1) default NULL,
  `log_cron` int(1) default NULL,
  `last_execution` int(50) default NULL,
  `year` int(4) default NULL,
  `month` int(2) default NULL,
  `day` int(2) default NULL,
  `hour` int(2) default NULL,
  `minute` int(2) default NULL,
  PRIMARY KEY  (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `pds_core_cron`
--

INSERT INTO `pds_core_cron` VALUES
('0', '', 0, 0, 0, 0, 0, 0, 0, 0),
('2749758364', '', 0, 1, 1284101669, 0, 0, 0, 0, 0),
('2953441878', '', 2, 1, 1284101680, 0, 0, 0, 1, 0),
('971937357', '', 2, 1, 1284101654, 1, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_filter`
--

CREATE TABLE `pds_core_filter` (
  `search_id` int(255) unsigned NOT NULL auto_increment,
  `user_id` int(20) default NULL,
  `menu_id` varchar(64) NOT NULL,
  `filter_search` varchar(255) default NULL,
  `filter_order` varchar(5) default NULL,
  `filter_by` varchar(255) default NULL,
  `exact_match` varchar(2) default NULL,
  PRIMARY KEY  (`search_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_logs`
--

CREATE TABLE `pds_core_logs` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `log_type` int(2) default NULL,
  `log_description` text,
  `log_time` int(10) default NULL,
  `user_id` int(30) default NULL,
  `user_display_name` varchar(255) default NULL,
  `menu_id` varchar(64) NOT NULL,
  `file_name` varchar(255) default NULL,
  `menu_name` varchar(255) default NULL,
  `user_ip` varchar(30) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_menu_access_logs`
--

CREATE TABLE `pds_core_menu_access_logs` (
  `log_id` int(20) NOT NULL auto_increment,
  `menu_id` varchar(64) NOT NULL,
  `user_id` int(10) default NULL,
  `timestamp` int(10) default NULL,
  PRIMARY KEY  (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_menu_items`
--

CREATE TABLE `pds_core_menu_items` (
  `menu_id` varchar(64) NOT NULL,
  `parent_menu_id` varchar(64) default NULL,
  `menu_name` varchar(255) default NULL,
  `menu_link` varchar(255) default NULL,
  `plugin` varchar(255) default NULL,
  `menu_type` int(1) default NULL,
  `extend` varchar(255) default NULL,
  `new_window` int(1) default NULL,
  `rank` int(100) default NULL,
  `hide` int(1) default NULL,
  `template_id` int(32) unsigned default NULL,
  `alias` varchar(255) default NULL,
  `layout` varchar(255) default NULL,
  `params` varchar(1024) default NULL,
  PRIMARY KEY  (`menu_id`),
  KEY `index` (`parent_menu_id`,`menu_link`,`plugin`,`alias`),
  KEY `params` USING BTREE (`params`(255))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `pds_core_menu_items`
--

INSERT INTO `pds_core_menu_items` VALUES
('1016054546', '930839394', 'Edit Cronjob', 'cron-admin/cronjob-admin.php', 'PHPDevShell', 1, '', 0, 2, 4, 844895956, 'edit-cronjob', '', NULL),
('1210756465', '294626826', 'Pending Users', 'user-admin/user-admin-pending.php', 'PHPDevShell', 1, '', 0, 4, 0, 844895956, 'pending-users', '', NULL),
('131201277', '294626826', 'Manage Users', 'user-admin/user-admin-list.php', 'PHPDevShell', 1, '', 0, 1, 0, 844895956, 'manage-users', '', NULL),
('1363712008', '982913650', 'System Settings', 'system-admin/general-settings.php', 'PHPDevShell', 1, '', 0, 1, 0, 844895956, 'system-settings', '', NULL),
('1405303115', '2751748213', 'Edit Role', 'user-admin/user-role-admin.link', 'PHPDevShell', 2, '2313706889', 0, 3, 4, 844895956, 'edit-role', '', NULL),
('1411278578', '2509699192', 'Policy Admin', 'user/control-panel.user-control', 'PHPDevShell', 2, '940041356', 0, 6, 0, 844895956, 'policy-admin', '', NULL),
('1440418834', '294626826', 'New User', 'user-admin/user-admin.php', 'PHPDevShell', 1, '', 0, 2, 0, 844895956, 'new-user', '', NULL),
('1648130103', '3669783681', 'System Logs', 'logs-admin/system-logs.php', 'PHPDevShell', 1, '', 0, 2, 0, 844895956, 'system-logs', '', NULL),
('1669337107', '982913650', 'Theme Admin', 'template-admin/template-admin-list.php', 'PHPDevShell', 1, '', 0, 4, 0, 844895956, 'theme-admin', '', NULL),
('1772410402', '1814972020', 'New Group', 'user-admin/user-group-admin.php', 'PHPDevShell', 1, '', 0, 2, 0, 844895956, 'new-group', '', NULL),
('1784737923', '3669783681', 'File Log Viewer', 'logs-admin/file-log-viewer.php', 'PHPDevShell', 1, '', 0, 5, 0, 844895956, 'file-log-viewer', '', NULL),
('1814972020', '1411278578', 'Group Admin', 'user-admin/user-group-admin-list.php.link', 'PHPDevShell', 2, '3276230420', 0, 4, 2, 844895956, 'group-admin', '', NULL),
('1886139891', '2190226087', 'Email Token', 'registration-token-admin/email-token.php', 'PHPDevShell', 1, '', 0, 4, 4, 844895956, 'email-token', '', NULL),
('1901799184', '0', 'Lost Password', 'user/lost-password.php', 'PHPDevShell', 1, '', 0, 3, 0, 844895956, 'lost-password', '', NULL),
('2021208659', '3669783681', 'Upload Logs', 'logs-admin/fileupload-logs.php', 'PHPDevShell', 1, '', 0, 4, 0, 844895956, 'upload-logs', '', NULL),
('2074704070', '982913650', 'Config Manager', 'system-admin/config-manager.php', 'PHPDevShell', 1, '', 0, 2, 0, 844895956, 'config-manager', '', NULL),
('2143500606', '0', 'Finish Registration', 'user/register-finalize.php', 'PHPDevShell', 1, '', 0, 8, 1, 844895956, 'finish-registration', '', NULL),
('2190226087', '1411278578', 'Token Admin', 'registration-token-admin/registration-token-admin-list.php.link', 'PHPDevShell', 2, '2387241520', 0, 5, 2, 844895956, 'token-admin', '', NULL),
('2200445609', '2190226087', 'Edit Token', 'registration-token-admin/registration-token-admin.link', 'PHPDevShell', 2, '48580716', 0, 3, 4, 844895956, 'edit-token', '', NULL),
('2266433229', '0', 'Readme', 'user/readme.php', 'PHPDevShell', 1, '', 0, 1, 0, 844895956, 'readme', '', NULL),
('2273945344', '1814972020', 'Edit Group', 'user-admin/user-group-admin.link', 'PHPDevShell', 2, '1772410402', 0, 3, 4, 844895956, 'edit-group', '', NULL),
('2313706889', '2751748213', 'New Role', 'user-admin/user-role-admin.php', 'PHPDevShell', 1, '', 0, 2, 0, 844895956, 'new-role', '', NULL),
('2387241520', '2190226087', 'Manage Tokens', 'registration-token-admin/registration-token-admin-list.php', 'PHPDevShell', 1, '', 0, 1, 0, 844895956, 'manage-tokens', '', NULL),
('2390350678', '3669783681', 'Access Logs', 'logs-admin/menu-access-logs.php', 'PHPDevShell', 1, '', 0, 3, 0, 844895956, 'access-logs', '', NULL),
('2509699192', '0', 'System Management', 'user/control-panel.system-admin', 'PHPDevShell', 2, '940041356', 0, 10, 0, 844895956, 'system-management', '', NULL),
('2749758364', '930839394', 'Repair Database', 'cron/repair-database.php', 'PHPDevShell', 8, '', 0, 5, 1, 844895956, 'repair-database', '', NULL),
('2751748213', '1411278578', 'Role Admin', 'user-admin/user-role-admin-list.php.link', 'PHPDevShell', 2, '3642120161', 0, 3, 2, 844895956, 'role-admin', '', NULL),
('294626826', '1411278578', 'User Admin', 'user-admin/user-admin-list.php.link', 'PHPDevShell', 2, '131201277', 0, 2, 2, 844895956, 'user-admin', '', NULL),
('2946674795', '0', 'User Preferences', 'user/edit-preferences.php', 'PHPDevShell', 1, '', 0, 6, 0, 844895956, 'user-preferences', '', NULL),
('2953441878', '930839394', 'Trim Logs', 'cron/trim-logs.php', 'PHPDevShell', 8, '', 0, 4, 1, 844895956, 'trim-logs', '', NULL),
('3204262040', '3968968736', 'Manage Menus', 'menu-admin/menu-item-admin-list.php', 'PHPDevShell', 1, '', 0, 1, 0, 844895956, 'manage-menus', '', NULL),
('32100600', '1411278578', 'Manage Tags', 'tagger-admin/tagger-admin.php', 'PHPDevShell', 1, '', 0, 6, 0, 844895956, 'manage-tags', '', NULL),
('3247623521', '1411278578', 'Access Control', 'menu-admin/menu-item-admin-permissions.php', 'PHPDevShell', 1, '', 0, 1, 0, 844895956, 'access-control', '', NULL),
('3276230420', '1814972020', 'Manage Groups', 'user-admin/user-group-admin-list.php', 'PHPDevShell', 1, '', 0, 1, 0, 844895956, 'manage-groups', '', NULL),
('3440897808', '3968968736', 'Edit Menu', 'menu-admin/menu-item-admin.link', 'PHPDevShell', 2, '967550350', 0, 3, 4, 844895956, 'edit-menu', '', NULL),
('3467402321', '294626826', 'Import Users', 'user-admin/user-admin-import.php', 'PHPDevShell', 1, '', 0, 5, 0, 844895956, 'import-users', '', NULL),
('3642120161', '2751748213', 'Manage Roles', 'user-admin/user-role-admin-list.php', 'PHPDevShell', 1, '', 0, 1, 0, 844895956, 'manage-roles', '', NULL),
('3669783681', '2509699192', 'System Status', 'system-admin/admin.php.link', 'PHPDevShell', 2, '863779375', 0, 1, 2, 844895956, 'system-status', '', NULL),
('3682403894', '0', 'Log In|Out', 'user/login-page.php', 'PHPDevShell', 1, '', 0, 4, 0, 844895956, 'login', '', NULL),
('3727066128', '0', 'Register Account', 'user/register.php', 'PHPDevShell', 1, '', 0, 2, 0, 844895956, 'register-account', '', NULL),
('3776270042', '0', 'Contact Admin', 'user/email-admin.php', 'PHPDevShell', 1, '', 0, 5, 0, 844895956, 'contact-admin', '', NULL),
('3968968736', '2509699192', 'Menu Admin', 'menu-admin/menu-item-admin-list.php.link', 'PHPDevShell', 2, '3204262040', 0, 5, 2, 844895956, 'menu-admin', '', NULL),
('4134883375', '930839394', 'Manage Cronjobs', 'cron-admin/cronjob-admin-list.php', 'PHPDevShell', 1, '', 0, 1, 0, 844895956, 'manage-cronjobs', '', NULL),
('4250544529', '3968968736', 'Access Control', 'menu-admin/menu-item-admin-permissions.link', 'PHPDevShell', 2, '3247623521', 0, 4, 0, 844895956, 'access-control', '', NULL),
('4283172353', '2946674795', 'New Password', 'user/new-password.php', 'PHPDevShell', 1, '', 0, 1, 0, 844895956, 'new-password', '', NULL),
('48580716', '2190226087', 'New Token', 'registration-token-admin/registration-token-admin.php', 'PHPDevShell', 1, '', 0, 2, 0, 844895956, 'new-token', '', NULL),
('585886089', '982913650', 'Plugins Admin', 'plugin-admin/plugin-activation.php', 'PHPDevShell', 1, '', 0, 3, 0, 844895956, 'plugins-admin', '', NULL),
('742061208', '930839394', 'System Cronjob', 'cron-admin/run-cron.php', 'PHPDevShell', 1, '', 0, 3, 1, 844895956, 'system-cronjob', '', NULL),
('863779375', '3669783681', 'System Info', 'system-admin/admin.php', 'PHPDevShell', 1, '', 0, 1, 0, 844895956, 'system-info', '', NULL),
('885145814', '294626826', 'Edit User', 'user-admin/user-admin.link', 'PHPDevShell', 2, '1440418834', 0, 3, 4, 844895956, 'edit-user', '', NULL),
('930839394', '2509699192', 'Cronjob Admin', 'cron-admin/cronjob-admin-list.php.link', 'PHPDevShell', 2, '4134883375', 0, 3, 2, 844895956, 'cronjob-admin', '', NULL),
('940041356', '0', 'Dashboard', 'user/control-panel.php', 'PHPDevShell', 1, '', 0, 7, 1, 844895956, 'cp', '', NULL),
('967550350', '3968968736', 'New Menu', 'menu-admin/menu-item-admin.php', 'PHPDevShell', 1, '', 0, 2, 0, 844895956, 'new-menu', '', NULL),
('971937357', '930839394', 'Optimize Database', 'cron/optimize-database.php', 'PHPDevShell', 8, '', 0, 6, 1, 844895956, 'optimize-database', '', NULL),
('982913650', '2509699192', 'System Admin', 'system-admin/general-settings.php.link', 'PHPDevShell', 2, '1363712008', 0, 2, 2, 844895956, 'system-admin', '', NULL),
('998066830', '982913650', 'Class Registry', 'plugin-admin/class-registry.php', 'PHPDevShell', 1, '', 0, 4, 0, 844895956, 'class-registry', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_menu_structure`
--

CREATE TABLE `pds_core_menu_structure` (
  `id` int(50) unsigned NOT NULL auto_increment,
  `menu_id` varchar(64) NOT NULL,
  `is_parent` int(1) default NULL,
  `type` int(1) default NULL,
  PRIMARY KEY  (`id`),
  KEY `index` (`menu_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=57 ;

--
-- Dumping data for table `pds_core_menu_structure`
--

INSERT INTO `pds_core_menu_structure` VALUES
(1, '2266433229', 0, 2),
(2, '3727066128', 0, 2),
(3, '1901799184', 0, 2),
(4, '3682403894', 0, 2),
(5, '3776270042', 0, 2),
(6, '2946674795', 1, 1),
(7, '4283172353', 0, 4),
(8, '940041356', 0, 2),
(9, '2143500606', 0, 2),
(10, '2509699192', 1, 1),
(11, '3669783681', 1, 3),
(12, '863779375', 0, 4),
(13, '1648130103', 0, 4),
(14, '2390350678', 0, 4),
(15, '2021208659', 0, 4),
(16, '1784737923', 0, 4),
(17, '982913650', 1, 3),
(18, '1363712008', 0, 4),
(19, '2074704070', 0, 4),
(20, '585886089', 0, 4),
(21, '1669337107', 0, 4),
(22, '998066830', 0, 4),
(23, '930839394', 1, 3),
(24, '4134883375', 0, 4),
(25, '1016054546', 0, 4),
(26, '742061208', 0, 4),
(27, '2953441878', 0, 4),
(28, '2749758364', 0, 4),
(29, '971937357', 0, 4),
(30, '3968968736', 1, 3),
(31, '3204262040', 0, 4),
(32, '967550350', 0, 4),
(33, '3440897808', 0, 4),
(34, '4250544529', 0, 4),
(35, '1411278578', 1, 3),
(36, '3247623521', 0, 4),
(37, '294626826', 1, 3),
(38, '131201277', 0, 4),
(39, '1440418834', 0, 4),
(40, '885145814', 0, 4),
(41, '1210756465', 0, 4),
(42, '3467402321', 0, 4),
(43, '2751748213', 1, 3),
(44, '3642120161', 0, 4),
(45, '2313706889', 0, 4),
(46, '1405303115', 0, 4),
(47, '1814972020', 1, 3),
(48, '3276230420', 0, 4),
(49, '1772410402', 0, 4),
(50, '2273945344', 0, 4),
(51, '2190226087', 1, 3),
(52, '2387241520', 0, 4),
(53, '48580716', 0, 4),
(54, '2200445609', 0, 4),
(55, '1886139891', 0, 4),
(56, '32100600', 0, 4);

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_plugin_activation`
--

CREATE TABLE `pds_core_plugin_activation` (
  `plugin_folder` varchar(255) NOT NULL default '0',
  `status` varchar(255) default NULL,
  `version` int(16) NOT NULL,
  `use_logo` int(2) default NULL,
  PRIMARY KEY  (`plugin_folder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `pds_core_plugin_activation`
--

INSERT INTO `pds_core_plugin_activation` VALUES
('BotBlock', 'install', 1000, 0),
('ControlPanel', 'install', 1000, 0),
('CRUD', 'install', 1000, 0),
('FileMan', 'install', 1000, 0),
('Pagination', 'install', 1000, 0),
('PHPDevShell', 'install', 3140, 1),
('PHPMailer', 'install', 1000, 0),
('PHPThumbs', 'install', 1000, 0),
('RedBeanORM', 'install', 1000, 0),
('Smarty', 'install', 1000, 0),
('StandardLogin', 'install', 1000, 0),
('TinyMCE', 'install', 1000, 0),
('userActions', 'install', 1000, 0);

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_plugin_classes`
--

CREATE TABLE `pds_core_plugin_classes` (
  `class_id` int(10) NOT NULL auto_increment,
  `class_name` varchar(155) default NULL,
  `alias` varchar(155) default NULL,
  `plugin_folder` varchar(255) default NULL,
  `enable` int(1) default NULL,
  `rank` int(4) default NULL,
  PRIMARY KEY  (`class_id`),
  KEY `index` (`class_name`,`alias`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=22 ;

--
-- Dumping data for table `pds_core_plugin_classes`
--

INSERT INTO `pds_core_plugin_classes` VALUES
(1, 'mailer', 'PHPDS_mailer', 'PHPMailer', 1, 1),
(2, 'wysiwygEditor', 'PHPDS_wysiwyg', 'TinyMCE', 1, 1),
(3, 'imaging', 'PHPDS_imaging', 'PHPThumbs', 1, 1),
(4, 'pagination', 'PHPDS_pagination', 'Pagination', 1, 1),
(5, 'views', 'PHPDS_views', 'Smarty', 1, 1),
(6, 'fileManager', 'PHPDS_fileManager', 'FileMan', 1, 1),
(7, 'groupTree', 'PHPDS_groups_tree', 'PHPDevShell', 1, 1),
(8, 'iana', 'PHPDS_iana', 'PHPDevShell', 1, 1),
(9, 'menuArray', 'PHPDS_menu_array', 'PHPDevShell', 1, 1),
(10, 'menuStructure', 'PHPDS_menu_structure', 'PHPDevShell', 1, 1),
(11, 'pluginManager', 'PHPDS_pluginmanager', 'PHPDevShell', 1, 1),
(12, 'timeZone', 'PHPDS_timezone', 'PHPDevShell', 1, 1),
(13, 'userPending', 'PHPDS_user_pending', 'PHPDevShell', 1, 1),
(14, 'controlPanel', 'PHPDS_controlPanel', 'ControlPanel', 1, 1),
(15, 'fileManager', 'PHPDS_fileManager', 'FileMan', 1, 1),
(16, 'imaging', 'PHPDS_imaging', 'PHPThumbs', 1, 1),
(17, 'userActions', 'PHPDS_userAction', 'userActions', 1, 1),
(18, 'StandardLogin', 'PHPDS_login', 'StandardLogin', 1, 1),
(19, 'orm', 'PHPDS_orm', 'RedBeanORM', 1, 1),
(20, 'crud', 'PHPDS_crud', 'CRUD', 1, 1),
(21, 'botBlock', 'PHPDS_botBlock', 'BotBlock', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_registration_queue`
--

CREATE TABLE `pds_core_registration_queue` (
  `user_id` int(20) unsigned NOT NULL default '0',
  `registration_type` int(1) default NULL,
  `token_id` int(20) default NULL,
  PRIMARY KEY  (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_registration_tokens`
--

CREATE TABLE `pds_core_registration_tokens` (
  `token_id` int(10) NOT NULL auto_increment,
  `token_name` varchar(255) default NULL,
  `user_role_id` int(10) default NULL,
  `user_group_id` int(10) default NULL,
  `token_key` varchar(42) default NULL,
  `registration_option` int(1) default NULL,
  `available_tokens` int(25) default NULL,
  PRIMARY KEY  (`token_id`),
  KEY `index` (`token_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_session`
--

CREATE TABLE `pds_core_session` (
  `cookie_id` int(20) unsigned NOT NULL auto_increment,
  `user_id` int(20) unsigned NOT NULL,
  `id_crypt` char(6) NOT NULL,
  `pass_crypt` char(32) NOT NULL,
  `timestamp` int(10) NOT NULL,
  PRIMARY KEY  (`cookie_id`),
  KEY `index` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_settings`
--

CREATE TABLE `pds_core_settings` (
  `setting_description` varchar(100) NOT NULL default '',
  `setting_value` text,
  `note` text,
  PRIMARY KEY  (`setting_description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `pds_core_settings`
--

INSERT INTO `pds_core_settings` VALUES
('PHPDevShell_access_logging', '1', 'Should access be logged?'),
('PHPDevShell_allowed_ext', 'jpg,jpeg,png,gif,zip,tar,doc,xls,pdf', 'Extensions allowed when uploading.'),
('PHPDevShell_allow_registration', '2', 'Should new registrations be allowed.'),
('PHPDevShell_allow_remember', '1', 'Should users be allowed to login with remember.'),
('PHPDevShell_banned_role', '6', 'The banned role. No access allowed.'),
('PHPDevShell_charset', 'UTF-8', 'Site wide charset.'),
('PHPDevShell_charset_format', '.{charset}', ''),
('PHPDevShell_cmod', '0777', 'How does a writable folder '),
('PHPDevShell_crop_thumb_dimension', '0,0,100,50', ''),
('PHPDevShell_crop_thumb_fromcenter', '150', ''),
('PHPDevShell_crypt_key', '[[crypt_key]]', ''),
('PHPDevShell_custom_logo', '', 'Default system logo.'),
('PHPDevShell_date_format', 'F j, Y, g:i a O', 'Date format according to DateTime function of PHP.'),
('PHPDevShell_date_format_short', 'Y-m-d', 'Shorter date format.'),
('PHPDevShell_date_format_show', 'September 17, 2010, 12:59 pm +0000', ''),
('PHPDevShell_date_format_show_short', '2010-09-17', ''),
('PHPDevShell_debug_language', '', ''),
('PHPDevShell_default_template', 'cloud', 'Default theme for all nodes.'),
('PHPDevShell_default_template_id', '844895956', 'Default template id.'),
('PHPDevShell_default_upload_directory', 'write/upload/', 'Writable upload directory.'),
('PHPDevShell_demo_mode', '0', 'Should system be set into demo mode, no transactions will occur.'),
('PHPDevShell_do_create_resize_image', '1', 'Should image resize versions be created.'),
('PHPDevShell_do_create_thumb', '1', 'Should thumbnails be created.'),
('PHPDevShell_do_thumb_reflect', '1', 'Should image reflections be created.'),
('PHPDevShell_email_charset', 'UTF-8', 'Default email charset.'),
('PHPDevShell_email_critical', '1', 'Should critical errors be emailed to admin.'),
('PHPDevShell_email_encoding', '8bit', ''),
('PHPDevShell_email_fromname', 'PHPDevShell', 'From which name should emails come.'),
('PHPDevShell_email_hostname', '', 'Email host name.'),
('PHPDevShell_email_new_registrations', '1', 'Should new registrations be mailed.'),
('PHPDevShell_email_option', 'smtp', ''),
('PHPDevShell_empty_template_id', '1757887940', ''),
('PHPDevShell_footer_notes', 'PHPDevShell.org (c) 2011 GNU/GPL License.', ''),
('PHPDevShell_force_core_changes', '0', 'Should core changes be forced, like deleting root user.'),
('PHPDevShell_from_email', '[[admin_email]]', ''),
('PHPDevShell_front_page_id', '2266433229', 'The page to show when site is access.'),
('PHPDevShell_front_page_id_in', '940041356', 'The page to show when logged in and home or page is accessed.'),
('PHPDevShell_ftp_enable', '1', 'Should ftp be enabled.'),
('PHPDevShell_ftp_host', 'localhost', ''),
('PHPDevShell_ftp_password', '', ''),
('PHPDevShell_ftp_port', '21', ''),
('PHPDevShell_ftp_root', '', ''),
('PHPDevShell_ftp_ssl', '0', ''),
('PHPDevShell_ftp_timeout', '90', ''),
('PHPDevShell_ftp_username', 'usernameFTP', ''),
('PHPDevShell_graphics_engine', 'gd', ''),
('PHPDevShell_guest_group', '3', 'The systems guest group.'),
('PHPDevShell_guest_role', '5', 'The systems guest role.'),
('PHPDevShell_image_quality', '80', 'What is the compressions ratio for resized images.'),
('PHPDevShell_language', 'en', 'Default language.'),
('PHPDevShell_languages_available', 'en', 'List of language codes available'),
('PHPDevShell_limit_favorite', '5', 'Control panel favorite menus limit.'),
('PHPDevShell_limit_messages', '5', 'Control panel log limit.'),
('PHPDevShell_locale_format', '{lang}_{region}{charset}', 'Complete locale format.'),
('PHPDevShell_loginandout', '3682403894', 'The page for log in and log out.'),
('PHPDevShell_login_message', '', 'a Default message to welcome users loging in.'),
('PHPDevShell_log_uploads', '1', ''),
('PHPDevShell_massmail_limit', '100', ''),
('PHPDevShell_max_filesize', '200000', ''),
('PHPDevShell_max_filesize_show', '200 Kb', ''),
('PHPDevShell_max_imagesize', '200000', ''),
('PHPDevShell_max_imagesize_show', '200 Kb', ''),
('PHPDevShell_menu_behaviour', 'dynamic', 'How the menu system should behave when navigating'),
('PHPDevShell_meta_description', 'Administrative user interface based on PHPDevShell and other modern technologies.', ''),
('PHPDevShell_meta_keywords', 'administrative, administrator, phpdevshell, interface, ui, user', ''),
('PHPDevShell_move_verified_group', '2', 'When user is approved, he will be moved to this group by default.'),
('PHPDevShell_move_verified_role', '2', 'When user is approved, he will be moved to this role by default.'),
('PHPDevShell_printable_template', 'cloud-printable', ''),
('PHPDevShell_queries_count', '1', 'Should queries be counted and info show.'),
('PHPDevShell_redirect_login', '3682403894', 'When a user logs in, where should he be redirected to?'),
('PHPDevShell_region', 'US', 'Region settings.'),
('PHPDevShell_regions_available', 'US', ''),
('PHPDevShell_registration_group', '3', ''),
('PHPDevShell_registration_message', '', ''),
('PHPDevShell_registration_page', '3727066128', 'Default registration page.'),
('PHPDevShell_registration_role', '4', ''),
('PHPDevShell_reg_email_admin', 'Dear Admin,\r\n\r\nYou have received a new registration at %1$s.\r\nThe user registered with the name %2$s, on this date %3$s, with the username %4$s.\r\n\r\nThank You,\r\n%5$s.%6$s %7$s %8$s\r\n\r\nYou must be logged-in to ban or approve users.', ''),
('PHPDevShell_reg_email_approve', 'Dear %1$s,\r\n\r\nYou completed the registration at %2$s.\r\nYour registration was successful but is still pending for approval from admin staff.\r\n\r\nThank you for registering at %3$s, an Admin will attend to your request soon.', ''),
('PHPDevShell_reg_email_direct', 'Dear %1$s,\r\n\r\nYou completed the registration at %2$s.\r\nYour registration was successful.\r\n\r\nThank you for registering at %3$s.', ''),
('PHPDevShell_reg_email_verify', 'Dear %1$s,\r\n\r\nYou requested registration at %2$s.\r\nYour registration was successful.\r\n\r\nPlease click on the *link\r\n%3$s\r\nto complete the registration process.\r\n\r\nThank you for registering at %4$s.\r\n\r\n*If you cannot click on the link, copy and paste the url in your browsers address bar.', ''),
('PHPDevShell_resize_adaptive_dimension', '250,150', ''),
('PHPDevShell_resize_image_dimension', '500,500', ''),
('PHPDevShell_resize_thumb_dimension', '250,150', ''),
('PHPDevShell_resize_thumb_percent', '50', ''),
('PHPDevShell_root_group', '1', 'Root Group.'),
('PHPDevShell_root_id', '1', 'Root User.'),
('PHPDevShell_root_role', '1', 'Root Role.'),
('PHPDevShell_save', 'save', ''),
('PHPDevShell_scripts_name_version', '[[site_name]]', ''),
('PHPDevShell_sef_url', '0', 'Should SEF urls be enabled, not rename to .htaccess in root.'),
('PHPDevShell_sendmail_path', '/usr/sbin/sendmail', ''),
('PHPDevShell_setting_admin_email', '[[admin_email]]', ''),
('PHPDevShell_setting_support_email', 'default:System Support Query,default:General Query', 'Allows you to have multiple option for a email query.'),
('PHPDevShell_skin', 'flick', 'Default skin to use for styling.'),
('PHPDevShell_smtp_helo', '', ''),
('PHPDevShell_smtp_host', 'smtp.gmail.com', ''),
('PHPDevShell_smtp_password', '', ''),
('PHPDevShell_smtp_port', '465', ''),
('PHPDevShell_smtp_secure', 'ssl', ''),
('PHPDevShell_smtp_timeout', '10', ''),
('PHPDevShell_smtp_username', 'admin@phpdevshell.org', ''),
('PHPDevShell_spam_assassin', '1', 'Should system attempt to protect public forms from spam bots?'),
('PHPDevShell_split_results', '30', 'When viewing paged results, how many results should be shown.'),
('PHPDevShell_system_down', '0', 'Is system currently down for development.'),
('PHPDevShell_system_down_message', '%s is currently down for maintenance. Some important features are being updated. Please return soon.', ''),
('PHPDevShell_system_logging', '1', 'Should logs be written to database.'),
('PHPDevShell_system_timezone', 'UTC', 'Timezone.'),
('PHPDevShell_test_email', 'test_email', ''),
('PHPDevShell_test_ftp', 'on', ''),
('PHPDevShell_thumbnail_type', 'adaptive', ''),
('PHPDevShell_thumb_reflect_settings', '40,40,80,true,#a4a4a4', ''),
('PHPDevShell_trim_logs', '1000000', ''),
('PHPDevShell_url_append', '.html', 'The url extension in the end.'),
('PHPDevShell_verify_registration', '1', 'Does users need to be verified after registration.');

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_tags`
--

CREATE TABLE `pds_core_tags` (
  `tagID` int(10) unsigned NOT NULL auto_increment,
  `tagObject` varchar(45) default NULL,
  `tagName` varchar(45) default NULL,
  `tagTarget` varchar(45) default NULL,
  `tagValue` text,
  PRIMARY KEY  (`tagID`),
  UNIQUE KEY `UNIQUE` (`tagObject`,`tagName`,`tagTarget`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_templates`
--

CREATE TABLE `pds_core_templates` (
  `template_id` int(32) unsigned NOT NULL,
  `template_folder` varchar(255) default NULL,
  PRIMARY KEY  (`template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `pds_core_templates`
--

INSERT INTO `pds_core_templates` VALUES
(844895956, 'cloud'),
(1757887940, 'empty'),
(3566024413, 'emptyCloud');

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_upload_logs`
--

CREATE TABLE `pds_core_upload_logs` (
  `file_id` int(20) unsigned NOT NULL auto_increment,
  `sub_id` int(20) default NULL,
  `menu_id` varchar(64) NOT NULL,
  `alias` varchar(255) default NULL,
  `original_filename` varchar(255) default NULL,
  `new_filename` varchar(255) default NULL,
  `relative_path` text,
  `thumbnail` text,
  `resized` text,
  `extention` varchar(5) default NULL,
  `mime_type` varchar(255) default NULL,
  `file_desc` varchar(255) default NULL,
  `group_id` int(20) default NULL,
  `user_id` int(20) default NULL,
  `date_stored` int(10) unsigned default NULL,
  `file_size` int(14) default NULL,
  `file_explained` text,
  PRIMARY KEY  (`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_users`
--

CREATE TABLE `pds_core_users` (
  `user_id` int(20) unsigned NOT NULL auto_increment,
  `user_display_name` varchar(255) default NULL,
  `user_name` varchar(255) default NULL,
  `user_password` varchar(100) default NULL,
  `user_email` varchar(100) default NULL,
  `user_group` int(10) default NULL,
  `user_role` int(10) default NULL,
  `date_registered` int(10) default NULL,
  `language` varchar(10) default NULL,
  `timezone` varchar(255) default NULL,
  `region` varchar(10) default NULL,
  PRIMARY KEY  (`user_id`),
  UNIQUE KEY `index_user` (`user_name`,`user_email`),
  KEY `index_general` (`user_display_name`,`user_group`,`user_role`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `pds_core_users`
--

INSERT INTO `pds_core_users` VALUES
(1, 'Root User', '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', 1, 1, [[timestamp]], 'en', 'UTC', 'US');

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_user_extra_groups`
--

CREATE TABLE `pds_core_user_extra_groups` (
  `user_id` int(20) NOT NULL default '0',
  `user_group_id` int(20) NOT NULL default '0',
  PRIMARY KEY  (`user_id`,`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_user_extra_roles`
--

CREATE TABLE `pds_core_user_extra_roles` (
  `user_id` int(20) NOT NULL default '0',
  `user_role_id` int(20) NOT NULL default '0',
  PRIMARY KEY  (`user_id`,`user_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_user_groups`
--

CREATE TABLE `pds_core_user_groups` (
  `user_group_id` int(10) unsigned NOT NULL auto_increment,
  `user_group_name` varchar(255) default NULL,
  `user_group_note` tinytext,
  `parent_group_id` int(10) default NULL,
  `alias` varchar(255) default NULL,
  PRIMARY KEY  (`user_group_id`),
  KEY `index` (`alias`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `pds_core_user_groups`
--

INSERT INTO `pds_core_user_groups` VALUES
(1, 'Super', NULL, 0, ''),
(2, 'Registered', NULL, 0, ''),
(3, 'Guest', NULL, 0, ''),
(4, 'Limited Admin', NULL, 0, ''),
(5, 'Demo', '', 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_user_roles`
--

CREATE TABLE `pds_core_user_roles` (
  `user_role_id` int(10) unsigned NOT NULL auto_increment,
  `user_role_name` varchar(255) default NULL,
  `user_role_note` tinytext,
  PRIMARY KEY  (`user_role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `pds_core_user_roles`
--

INSERT INTO `pds_core_user_roles` VALUES
(1, 'Super', ''),
(2, 'Registered', NULL),
(4, 'Awaiting Confirmation', ''),
(5, 'Guest', ''),
(6, 'Disabled', ''),
(7, 'Limited Admin', ''),
(8, 'Branch Admin', ''),
(9, 'Demo', '');

-- --------------------------------------------------------

--
-- Table structure for table `pds_core_user_role_permissions`
--

CREATE TABLE `pds_core_user_role_permissions` (
  `user_role_id` int(10) NOT NULL default '0',
  `menu_id` varchar(64) NOT NULL,
  PRIMARY KEY  (`user_role_id`,`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `pds_core_user_role_permissions`
--

INSERT INTO `pds_core_user_role_permissions` VALUES
(1, '1016054546'),
(1, '1210756465'),
(1, '131201277'),
(1, '1363712008'),
(1, '1405303115'),
(1, '1411278578'),
(1, '1440418834'),
(1, '1648130103'),
(1, '1669337107'),
(1, '1772410402'),
(1, '1784737923'),
(1, '1814972020'),
(1, '1886139891'),
(1, '2021208659'),
(1, '2074704070'),
(1, '2190226087'),
(1, '2200445609'),
(1, '2266433229'),
(1, '2273945344'),
(1, '2313706889'),
(1, '2387241520'),
(1, '2390350678'),
(1, '2509699192'),
(1, '2749758364'),
(1, '2751748213'),
(1, '294626826'),
(1, '2946674795'),
(1, '2953441878'),
(1, '3204262040'),
(1, '32100600'),
(1, '3247623521'),
(1, '3276230420'),
(1, '3440897808'),
(1, '3467402321'),
(1, '3642120161'),
(1, '3669783681'),
(1, '3682403894'),
(1, '3776270042'),
(1, '3968968736'),
(1, '4134883375'),
(1, '4250544529'),
(1, '4283172353'),
(1, '48580716'),
(1, '585886089'),
(1, '742061208'),
(1, '863779375'),
(1, '885145814'),
(1, '930839394'),
(1, '940041356'),
(1, '967550350'),
(1, '971937357'),
(1, '982913650'),
(1, '998066830'),
(2, '2266433229'),
(2, '2946674795'),
(2, '3682403894'),
(2, '3776270042'),
(2, '4283172353'),
(2, '940041356'),
(4, '2143500606'),
(4, '2266433229'),
(4, '2946674795'),
(4, '3682403894'),
(4, '3776270042'),
(4, '4283172353'),
(4, '940041356'),
(5, '1901799184'),
(5, '2143500606'),
(5, '2266433229'),
(5, '2749758364'),
(5, '2953441878'),
(5, '3682403894'),
(5, '3727066128'),
(5, '3776270042'),
(5, '4283172353'),
(5, '742061208'),
(5, '940041356'),
(5, '971937357'),
(6, '3682403894'),
(6, '940041356'),
(7, '1210756465'),
(7, '131201277'),
(7, '1363712008'),
(7, '1411278578'),
(7, '1440418834'),
(7, '1648130103'),
(7, '1772410402'),
(7, '1784737923'),
(7, '1814972020'),
(7, '1886139891'),
(7, '2021208659'),
(7, '2074704070'),
(7, '2190226087'),
(7, '2200445609'),
(7, '2266433229'),
(7, '2273945344'),
(7, '2387241520'),
(7, '2390350678'),
(7, '2509699192'),
(7, '294626826'),
(7, '2946674795'),
(7, '3276230420'),
(7, '3467402321'),
(7, '3669783681'),
(7, '3682403894'),
(7, '3776270042'),
(7, '4283172353'),
(7, '48580716'),
(7, '863779375'),
(7, '885145814'),
(7, '940041356'),
(7, '982913650'),
(8, '1210756465'),
(8, '131201277'),
(8, '1411278578'),
(8, '1440418834'),
(8, '1772410402'),
(8, '1814972020'),
(8, '1886139891'),
(8, '2190226087'),
(8, '2200445609'),
(8, '2266433229'),
(8, '2273945344'),
(8, '2387241520'),
(8, '2509699192'),
(8, '294626826'),
(8, '2946674795'),
(8, '3276230420'),
(8, '3467402321'),
(8, '3682403894'),
(8, '3776270042'),
(8, '4283172353'),
(8, '48580716'),
(8, '885145814'),
(8, '940041356'),
(9, '1016054546'),
(9, '1210756465'),
(9, '131201277'),
(9, '1363712008'),
(9, '1405303115'),
(9, '1411278578'),
(9, '1440418834'),
(9, '1648130103'),
(9, '1669337107'),
(9, '1772410402'),
(9, '1784737923'),
(9, '1814972020'),
(9, '1886139891'),
(9, '1901799184'),
(9, '2021208659'),
(9, '2074704070'),
(9, '2190226087'),
(9, '2200445609'),
(9, '2266433229'),
(9, '2273945344'),
(9, '2313706889'),
(9, '2387241520'),
(9, '2390350678'),
(9, '2509699192'),
(9, '2749758364'),
(9, '2751748213'),
(9, '294626826'),
(9, '2946674795'),
(9, '2953441878'),
(9, '3204262040'),
(9, '32100600'),
(9, '3247623521'),
(9, '3276230420'),
(9, '3440897808'),
(9, '3467402321'),
(9, '3642120161'),
(9, '3669783681'),
(9, '3682403894'),
(9, '3727066128'),
(9, '3776270042'),
(9, '3968968736'),
(9, '4134883375'),
(9, '4250544529'),
(9, '4283172353'),
(9, '48580716'),
(9, '585886089'),
(9, '742061208'),
(9, '863779375'),
(9, '885145814'),
(9, '930839394'),
(9, '940041356'),
(9, '967550350'),
(9, '971937357'),
(9, '982913650'),
(9, '998066830');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
