<?php
/**
 * This ajax will be displayed whenever an unhandled error or exception occurs in PHPDevShell
 */
// If the error occured during an AJAX request, we'll send back a lightweight ouput
if (PU_isAJAX()) {
	if (!empty($message)) {
		print "$message - file $filepath line $lineno";
	} else {
		print 'Unknown error';
	}
} else {
// for a regular request, we present a nicely formatted html page; if provided, an extended description of the error is displayed
	$skin = $this->configuration['skin'];
?>
<!DOCTYPE HTML>
<html lang="en">
	<head>
		<title>Serious Error Encountered</title>
		<meta charset=UTF-8>
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="keywords" content="critical, error">
		<meta name="description" content="We encountered an error">
		<link rel="stylesheet" href="<?php echo $aurl ?>/themes/cloud/css/reset.css" type="text/css" media="screen, projection" />
		<link rel="stylesheet" href="<?php echo $aurl ?>/themes/cloud/jquery/css/ui-lightness/jquery-ui.css?v314a" type="text/css" media="screen, projection" />
		<link rel="stylesheet" href="<?php echo $aurl ?>/themes/cloud/css/combined.css?v=314a" type="text/css" media="screen, projection" />
		<script type="text/javascript" src="<?php echo $aurl ?>/themes/cloud/js/combined-min.js?v=314a"></script>
		<script type="text/javascript" src="<?php echo $aurl ?>/themes/cloud/js/showhide/jquery.showhide.js"></script>
		<style>
			#backtrace td, #backtrace th{
				border: none;
			}
			.bt-line-number {
				color: #F93;
			}
		</style>
	</head>
	<!-- PHPDevShell Main Body -->
	<body class="ui-widget">
		<?php
			if (is_a($e, 'PHPDS_exception') && ($e->hasCauses())) {
				list($msg, $causes, $extra_html) = $e->getCauses();
				?>

				<article class="ui-widget-content ui-corner-all" style="margin:2em; padding:2em;">
				<p class="ui-state-error ui-corner-all"><?php  print $msg?></p>
				<p>Possible causes are:</p>
				<?php
					foreach($causes as $cause) {
						list($title, $text) = $cause;
						echo "<p><strong>$title</strong>$text</p>";
					}
					if ($extra_html) echo $extra_html;
				?>
				</article>
				<?php
			}
		?>
		<?php if (!empty($message)) {

				$config = $this->configuration;
			?>
		<article class="ui-widget-content ui-corner-all" style="margin:2em; padding:2em;">
			<h1 class="ui-state-error ui-corner-all">Uncaught Exception while running</h1>
			<p>This page will try to provide as much information as possible so you can track down (and hopefully fix) the problem.</p>

			<h2>The error</h2>

			<p>The message of the error is as follow:</p>
			<blockquote>
			<p class="ui-state-error ui-corner-all"><?php echo $message; ?></p>
			<p><?php echo $extendedMessage; ?></p>
			</blockquote>

			<p>The error occurred in file <strong><?php echo $filepath?></strong> at line <strong><?php echo $lineno?></strong></p>
			<blockquote>
			<p><?php echo $filefragment?></p>
			</blockquote>


			<h2>The configuration</h2>
			<h3>Configuration files actually used:</h3>
			<?php echo $conf['used']; ?>
			<h3>Configuration files which would have been used if they were present:</h3>
			<?php echo $conf['missing']; ?>
			<h3>Main database info</h3>
			<?php
				$db_settings = PU_GetDBSettings($config);
				echo "<p>Database <i>{$db_settings['database']}</i> with prefix <i>{$db_settings['prefix']}</i> on host <i>{$db_settings['host']}</i> with user <i>{$db_settings['username']}</i>.</p>";
			?>
			<h3>Other useful configuration settings</h3>
			<?php
				echo '<p>Sef URL is <i>'.($config['sef_url'] ? 'on' : 'off').'</i> ; default template is '.($config['default_template'] ? '<i>'.$config['default_template'].'</i>' : '<b>not set</b>').'.</p>';
				echo '<p>Guest role  is '.(empty($config['guest_role'])  ? '<b>not set</b>' : '<i>'.$config['guest_role'].'</i>').' ; guest group is '.(empty($config['guest_group'])  ? '<b>not set</b>' : '<i>'.$config['guest_group'].'</i>').'.</p>';
				list($plugin, $menu_link) = $this->navigation->menuPath();
				echo empty($plugin) ? '<p>No plugin currently selected</p>' : '<p>Current plugin is <strong>'.$plugin.'</strong> (path is '.$menu_link.')</p>';
			?>

			<h2>The Backtrace:</h2>
			<p>All relative file pathes are relative to the server root (namely <tt><?php echo $_SERVER['DOCUMENT_ROOT']; ?>/ )</tt></p>
			<p>Click on the Book icon to access online documentation.</p>
			<table id="backtrace">
				<thead>
					<tr>
						<th>File path (relative)</th>
						<th>Line</th>
						<th>Call (with arguments)</th>
					</tr>
				</thead>
				<tbody>
					<?php echo $bt; ?>
				</tbody>
			</table>

			<h2>PHP info</h2>
			<div style="overflow: hidden;">
			<?php phpinfo(INFO_GENERAL); ?>
			</div>
			<h2>Variable Info</h2>
			<div style="overflow: hidden;">
			<?php phpinfo(INFO_VARIABLES); ?>
			</div>

		</article>
		<?php } else { ?>
		<article class="ui-widget-content ui-corner-all" style="margin:2em; padding:2em;">
			<h1 class="ui-state-error ui-corner-all">An error has occured...</h1>
			<p>An error has occurred while trying to provide you with the requested resource.</p>
			<p>The site administrator have been informed and will fix the problem as soon as possible.</p>
			<p>Sorry for the inconvenience, please come back later...</p>
		</article>
		<?php }?>
	</body>
</html>
<?php } ?>