<?php


/**
 * 
 * 

CREATE TABLE IF NOT EXISTS `TEST_legacyQuery_1` (
  `col1` int(11) NOT NULL,
  `col2` text NOT NULL,
  `col3` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `TEST_legacyQuery_1` (`col1`, `col2`, `col3`) VALUES
(1, 'one', 0),
(2, 'two', 1);
 

CREATE TABLE IF NOT EXISTS `TEST_legacyQuery_2` (
  `col1` int(11) NOT NULL,
  `col2` text NOT NULL,
  `col3` tinyint(1) NOT NULL,
  `col4` int(11) NOT NULL,
  PRIMARY KEY (`col1`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


INSERT INTO `TEST_legacyQuery_2` (`col1`, `col2`, `col3`, `col4`) VALUES
(1, 'one', 0, 0),
(2, 'two', 1, 15),
(20, 'twenty', 0, 0);

 * 
 * 
 */

	require_once 'mock_connector.php';
	
	class TEST_legacyQuery  extends PHPDS_query
	{
		//protected $connector = ''; // we use the default connector (mysql legacy)
		protected $sql = 'SELECT * FROM test_legacyquery_1';
		// allow easy access from the test scripts to the fields (make them public)
		public $singleRow;
		public $singleValue;
		public $typecast;
	}


	/**
	 * @outputBuffering disabled
	 */
	class TEST_queryTest extends PHPUnit_Framework_TestCase
	{
		protected $query;
		protected $stub;

		protected function setUp()
		{
			$PHPDS = TEST_main::instance();
			$this->query = $PHPDS->_factory('TEST_legacyQuery');
			
		}

		public function testConnector()
		{
			$data = array(
				array('col1' => 1, 'col2' => 'one', 'col3' => 0),
				array('col1' => 2, 'col2' => 'two', 'col3' => 1),
			);
			$stub = $this->query->connector();
			$stub->connect();
			$stub->query('SELECT * FROM TEST_legacyQuery_1');

			$this->assertEquals($data[0], $stub->fetchAssoc());
			$this->assertEquals($data[1], $stub->fetchAssoc());
		}

		public function testQuery()
		{
			/*$data_in = array(
				array('col1' => 1, 'col2' => 'one', 'col3' => false, 'col4' => 'abc'),
				array('col1' => 2, 'col2' => 'two', 'col3' => true, 'col4' => '15'),
				array('col1' => 20, 'col2' => 'twenty', 'col3' => null, 'col4' => null),
			);*/
			$data_expected = array(
				1 => array('col1' => 1, 'col2' => 'one', 'col3' => false, 'col4' => 0),
				2 => array('col1' => 2, 'col2' => 'two', 'col3' => true, 'col4' => 15),
				20 => array('col1' => 20, 'col2' => 'twenty', 'col3' => false, 'col4' => 0),
			);
			$this->query->sql('SELECT * FROM TEST_legacyQuery_2');
			$this->query->invoke();

			$this->query->typecast = array('col3' => 'boolean', 'col4' => 'int');

			$result = $this->query->invoke();
			$this->assertEquals($data_expected, $result, 'Testing as_array');
			$this->assertEquals(3, $this->query->count());
			$this->assertEquals(3, $this->query->total());

			$this->query->singleRow = true;
			$result = $this->query->invoke();
			$this->assertEquals($data_expected[1], $result, 'Testing single_row');
			$this->assertEquals(-1, $this->query->count());
			$this->assertEquals(3, $this->query->total());

			$this->query->singleValue = true;
			$result = $this->query->invoke();
			$this->assertEquals($data_expected[1]['col1'], $result, 'Testing single_value');
			$this->assertEquals(-1, $this->query->count());
			$this->assertEquals(3, $this->query->total());

		}
		

		/**
		 * @group database
		 */
		public function testExtendedBuild()
		{
			$this->markTestIncomplete(
							'This test has not been implemented yet because they need a DB connection.'
			);
		}



	}


