<?php


/**
 * Test class for PHPDS_controller.
 * Generated by PHPUnit on 2011-08-09 at 01:06:29.
 */
class PHPDS_controllerTest extends PHPUnit_Framework_TestCase
{

	/**
	 * @var PHPDS_controller
	 */
	protected $object;

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 */
	protected function setUp()
	{
		$PHPDS = TEST_main::instance();
		$this->object = $PHPDS->_factory('PHPDS_controller');

		$_POST = array('post' => 10);
		$_GET = array('get' => 20);

		$this->object->construct();
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 */
	protected function tearDown()
	{

	}

	public function testConstruct_DoesInitialize()
	{
		$_REQUEST = null;
		$_POST = null;
		$_GET = null;

		$this->object->construct();

		$this->assertAttributeType(PHPUnit_Framework_Constraint_IsType::TYPE_ARRAY, '_POST', $this->object);
		$this->assertAttributeType(PHPUnit_Framework_Constraint_IsType::TYPE_ARRAY, '_GET', $this->object);
	}

	public function testConstruct_DoesClear()
	{
		$_REQUEST = array('_SESSION' => true, 'test' => true);
		$_POST = array('post' => 10);
		$_GET = array('get' => 20);

		$this->object->construct();

		$this->assertTrue(empty($_REQUEST['_SESSION']));
		$this->assertTrue(empty($_POST['_SESSION']));
		$this->assertTrue(empty($_GET['_SESSION']));
	}

	public function testConstruct_DoesImport()
	{
		$_REQUEST = array('_SESSION' => true, 'test' => true);
		$_POST = array('post' => 10);
		$_GET = array('get' => 20);

		$this->object->construct();

		$this->assertAttributeType(PHPUnit_Framework_Constraint_IsType::TYPE_ARRAY, '_POST', $this->object);
		$this->assertAttributeType(PHPUnit_Framework_Constraint_IsType::TYPE_ARRAY, '_GET', $this->object);

		$this->assertAttributeEquals(array('post' => 10), '_POST', $this->object);
		$this->assertAttributeEquals(array('get' => 20), '_GET', $this->object);
	}

	public function testPOST()
	{
		$this->assertEquals(array('post' => 10), $this->object->POST());
		$this->assertEquals(10, $this->object->POST('post'));
		$this->assertNull($this->object->POST('nopost'));
		$this->assertEquals('wrong', $this->object->POST('nopost', 'wrong'));
		$this->assertEquals(array('right' => true, 'post' => 10), $this->object->POST(null, array('right' => true)));
	}

	public function testGET()
	{
		$this->assertEquals(array('get' => 20), $this->object->GET());
		$this->assertEquals(20, $this->object->GET('get'));
		$this->assertNull($this->object->GET('noget'));
		$this->assertEquals('wrong', $this->object->GET('noget', 'wrong'));
		$this->assertEquals(array('right' => true, 'get' => 20), $this->object->GET(null, array('right' => true)));
	}

	/**
	 * @todo Implement testRun().
	 */
	public function testRun()
	{
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
						'This test has not been implemented yet.'
		);
	}

	/**
	 * @todo Implement testRunAJAX().
	 */
	public function testRunAJAX()
	{
		// Remove the following lines when you implement this test.
		$this->markTestIncomplete(
						'This test has not been implemented yet.'
		);
	}

	public function testHandleResult_PlainRequest()
	{
		$PHPDS = PHPDSlib::instance();

		$_SERVER["HTTP_X_REQUESTED_WITH"] = null;
		$_SERVER["HTTP_X_REQUESTED_TYPE"] = null;

		// set up the template with fake data and call the method under test
		$template = $PHPDS->PHPDS_template();
		$core = $PHPDS->PHPDS_core();
		$this->assertType('PHPDS_template', $template);
		$this->assertType('PHPDS_core', $core);
		$core->themeFile = 'testTemplate';
		$core->data = 'testController';

		// test a controller result of false: error
		$result = $this->object->handleResult(false);
		$this->assertFalse($result);
		$this->assertEquals('testTemplate', $core->themeFile);
		$this->assertEquals('testController', $core->data);

		// test a controller result of null: standard handling
		$result = $this->object->handleResult(null);
		$this->assertTrue($result);
		$this->assertEquals('testTemplate', $core->themeFile);
		$this->assertEquals('testController', $core->data);

		// test a controller result of true: don't do anything
		$result = $this->object->handleResult(true);
		$this->assertTrue($result);
		$this->assertEquals('', $core->themeFile);
		$this->assertEquals('', $core->data);

		// test a controller result of bare string: bare output
		$result = $this->object->handleResult('bare string');
		$this->assertTrue($result);
		$this->assertEquals('', $core->themeFile);
		$this->assertEquals('bare string', $core->data);

		// test an invalid controller result
        $this->setExpectedException('PHPDS_exception');
		$result = $this->object->handleResult(array('test' => true));
	}

	public function testHandleResult_AjaxRequest()
	{
		$PHPDS = PHPDSlib::instance();

		$_SERVER["HTTP_X_REQUESTED_WITH"] = 'XMLHttpRequest';
		$_SERVER["HTTP_X_REQUESTED_TYPE"] = null;

		$this->assertTrue(PU_isAJAX());
		$this->assertFalse(PU_isJSON('test'));

		// set up the template with fake data and call the method under test
		$template = $PHPDS->PHPDS_template();
		$core = $PHPDS->PHPDS_core();
		$this->assertType('PHPDS_template', $template);
		$this->assertType('PHPDS_core', $core);
		$core->themeFile = 'testTemplate';
		$core->data = 'testController';

		// test a controller result of false: error
		$result = $this->object->handleResult(false);
		$this->assertFalse($result);
		$this->assertEquals('testTemplate', $core->themeFile);
		$this->assertEquals('testController', $core->data);

		// test a controller result of null: standard handling
		$result = $this->object->handleResult(null);
		$this->assertTrue($result);
		$this->assertEquals('testTemplate', $core->themeFile);
		$this->assertEquals('testController', $core->data);

		// test a controller result of true: don't do anything
		$result = $this->object->handleResult(true);
		$this->assertTrue($result);
		$this->assertEquals('', $core->themeFile);
		$this->assertEquals('', $core->data);

		// test a controller result of bare string: bare output
		$result = $this->object->handleResult('bare string');
		$this->assertTrue($result);
		$this->assertEquals('', $core->themeFile);
		$this->assertEquals('bare string', $core->data);

		// test an invalid controller result
        $this->setExpectedException('PHPDS_exception');
		$result = $this->object->handleResult(array('test' => true));
	}

	public function testHandleResult_JsonRequest()
	{
		$PHPDS = PHPDSlib::instance();

		$_SERVER["HTTP_X_REQUESTED_WITH"] = 'XMLHttpRequest';
		$_SERVER["HTTP_X_REQUESTED_TYPE"] = 'json';

		$data = array('test' => true);

		$this->assertTrue(PU_isAJAX());
		$this->assertEquals('{"test":true}', PU_isJSON($data));

		// set up the template with fake data and call the method under test
		$template = $PHPDS->PHPDS_template();
		$core = $PHPDS->PHPDS_core();
		$this->assertType('PHPDS_template', $template);
		$this->assertType('PHPDS_core', $core);
		$core->themeFile = 'testTemplate';
		$core->data = 'testController';

		// TODO: decide what is the correct behavior
		// test a controller result of false: error
		/*$result = $this->object->handleResult(false);
		$this->assertFalse($result);
		$this->assertEquals('testTemplate', $core->themeFile);
		$this->assertEquals('testController', $template->controller);*/

		// test a controller result of null: standard handling
		$result = $this->object->handleResult(null);
		$this->assertTrue($result);
		$this->assertEquals('', $core->themeFile);
		$this->assertEquals('null', $core->data);

		// test a controller result of true: don't do anything
		$result = $this->object->handleResult(true);
		$this->assertTrue($result);
		$this->assertEquals('', $core->themeFile);
		$this->assertEquals('true', $core->data);


		// test a controller result of some data
		$result = $this->object->handleResult($data);
		$this->assertTrue($result);
		$this->assertEquals('', $core->themeFile);
		$this->assertEquals('{"test":true}', $core->data);

		// TODO: should this throw an exception?
		// test an invalid controller result
        /*$this->setExpectedException('PHPDS_exception');
		$result = $this->object->handleResult(array('test' => true));*/
	}


}

?>
