# PHP File Download
A class to help with creating downloads for files in PHP.


## Tip
If you can use direct downloads, you should just use them.
This class is for providing downloads of files out of PHP, for example if you want to provide a download to a temporarily created file.


# Usage

The examples assume, that you have included the namespace:
```php
use Apfelbox\FileDownload\FileDownload;
```


## Create a download for a file on your file system
```php
$fileDownload = FileDownloader::createFromFilePath("/path/to/file.pdf");
$fileDownload->sendDownload("download.pdf");
```


## Create a download for a file via file pointer
```php
$file = /* your file, somewhere opened with fopen() or tmpfile(), etc.. */;
$fileDownload = new FileDownloader($file);
$fileDownload->sendDownload("download.pdf");
```


## Create a download for a file via content
```php
$content = "This is the content of the file:";
$fileDownload = FileDownloader::createFromString($content);
$fileDownload->sendDownload("download.txt");
```


For example, you can create downloads for PDF files, generated by Zend (or any other library):

```php
$pdf = new Zend_Pdf();
$page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);
$pdf->pages[] = $page;

/* draw content in the pdf ... */

$fileDownload = FileDownloader::createFromString($pdf->render());
$fileDownload->sendDownload("download.pdf");
```