

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `phpcol2103`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignments`
--

CREATE TABLE `[[dbprefix]]assignments` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `task` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `assigned_to` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `comments` text,
  `assigned` varchar(16) DEFAULT NULL,
  `subtask` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bookmarks`
--

CREATE TABLE `[[dbprefix]]bookmarks` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `category` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `description` text,
  `shared` char(1) NOT NULL DEFAULT '',
  `home` char(1) NOT NULL DEFAULT '',
  `comments` char(1) NOT NULL DEFAULT '',
  `users` varchar(255) DEFAULT NULL,
  `created` varchar(16) DEFAULT NULL,
  `modified` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bookmarks_categories`
--

CREATE TABLE `[[dbprefix]]bookmarks_categories` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]calendar`
--

CREATE TABLE `[[dbprefix]]calendar` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(155) DEFAULT NULL,
  `description` text,
  `shortname` varchar(155) DEFAULT NULL,
  `date_start` varchar(10) DEFAULT NULL,
  `date_end` varchar(10) DEFAULT NULL,
  `time_start` varchar(155) DEFAULT NULL,
  `time_end` varchar(155) DEFAULT NULL,
  `reminder` char(1) NOT NULL DEFAULT '',
  `recurring` char(1) NOT NULL DEFAULT '',
  `recur_day` char(1) NOT NULL DEFAULT '',
  `broadcast` char(1) NOT NULL DEFAULT '',
  `location` varchar(155) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]files`
--

CREATE TABLE `[[dbprefix]]files` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `task` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `date` varchar(16) DEFAULT NULL,
  `size` varchar(155) DEFAULT NULL,
  `extension` varchar(155) DEFAULT NULL,
  `comments` varchar(255) DEFAULT NULL,
  `comments_approval` varchar(255) DEFAULT NULL,
  `approver` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `date_approval` varchar(16) DEFAULT NULL,
  `upload` varchar(16) DEFAULT NULL,
  `published` char(1) NOT NULL DEFAULT '',
  `status` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vc_status` varchar(255) NOT NULL DEFAULT '0',
  `vc_version` varchar(255) NOT NULL DEFAULT '0.0',
  `vc_parent` int(10) unsigned NOT NULL DEFAULT '0',
  `phase` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]invoices`
--

CREATE TABLE `[[dbprefix]]invoices` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `header_note` text,
  `footer_note` text,
  `date_sent` varchar(10) DEFAULT NULL,
  `due_date` varchar(10) DEFAULT NULL,
  `total_ex_tax` float(10,2) NOT NULL DEFAULT '0.00',
  `tax_rate` float(10,2) NOT NULL DEFAULT '0.00',
  `tax_amount` float(10,2) NOT NULL DEFAULT '0.00',
  `total_inc_tax` float(10,2) NOT NULL DEFAULT '0.00',
  `status` char(1) NOT NULL DEFAULT '',
  `active` char(1) NOT NULL DEFAULT '',
  `created` varchar(16) DEFAULT NULL,
  `modified` varchar(16) DEFAULT NULL,
  `published` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]invoices_items`
--

CREATE TABLE `[[dbprefix]]invoices_items` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `invoice` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `position` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `mod_type` char(1) NOT NULL DEFAULT '',
  `mod_value` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title` varchar(155) DEFAULT NULL,
  `description` text,
  `worked_hours` float(10,2) NOT NULL DEFAULT '0.00',
  `amount_ex_tax` float(10,2) NOT NULL DEFAULT '0.00',
  `rate_type` varchar(10) DEFAULT NULL,
  `rate_value` float(10,2) NOT NULL DEFAULT '0.00',
  `status` char(1) NOT NULL DEFAULT '',
  `active` char(1) NOT NULL DEFAULT '',
  `completed` char(1) NOT NULL DEFAULT '',
  `created` varchar(16) DEFAULT NULL,
  `modified` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]logs`
--

CREATE TABLE `[[dbprefix]]logs` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `login` varchar(155) DEFAULT NULL,
  `password` varchar(155) DEFAULT NULL,
  `ip` varchar(155) DEFAULT NULL,
  `session` varchar(155) DEFAULT NULL,
  `compt` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `last_visite` varchar(16) DEFAULT NULL,
  `connected` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members`
--

CREATE TABLE `[[dbprefix]]members` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `organization` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `login` varchar(155) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `name` varchar(155) DEFAULT NULL,
  `title` varchar(155) DEFAULT NULL,
  `email_work` varchar(155) DEFAULT NULL,
  `email_home` varchar(155) DEFAULT NULL,
  `phone_work` varchar(155) DEFAULT NULL,
  `phone_home` varchar(155) DEFAULT NULL,
  `mobile` varchar(155) DEFAULT NULL,
  `fax` varchar(155) DEFAULT NULL,
  `comments` text,
  `profil` char(1) NOT NULL DEFAULT '',
  `created` varchar(16) DEFAULT NULL,
  `logout_time` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `last_page` varchar(255) DEFAULT NULL,
  `timezone` char(3) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]members`
--

INSERT INTO `[[dbprefix]]members` VALUES
(1, 1, '[[admin_username]]', '[[admin_pass]]', '[[admin_realname]]', NULL, '[[admin_email]]', NULL, NULL, NULL, NULL, NULL, NULL, '0', '[[regtime_]]', 0, NULL, ''),
(2, 1, 'demo', 'devFxxVFZsuos', 'Demo user', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '4', '[[regtime_]]', 0, NULL, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsdeskcomments`
--

CREATE TABLE `[[dbprefix]]newsdeskcomments` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `comment` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsdeskposts`
--

CREATE TABLE `[[dbprefix]]newsdeskposts` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pdate` varchar(16) DEFAULT NULL,
  `title` varchar(155) DEFAULT NULL,
  `author` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `related` varchar(155) DEFAULT NULL,
  `content` text,
  `links` text,
  `rss` char(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notes`
--

CREATE TABLE `[[dbprefix]]notes` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic` varchar(255) DEFAULT NULL,
  `subject` varchar(155) DEFAULT NULL,
  `description` text,
  `date` varchar(10) DEFAULT NULL,
  `published` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `member` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `taskAssignment` char(1) NOT NULL DEFAULT '0',
  `removeProjectTeam` char(1) NOT NULL DEFAULT '0',
  `addProjectTeam` char(1) NOT NULL DEFAULT '0',
  `newTopic` char(1) NOT NULL DEFAULT '0',
  `newPost` char(1) NOT NULL DEFAULT '0',
  `statusTaskChange` char(1) NOT NULL DEFAULT '0',
  `priorityTaskChange` char(1) NOT NULL DEFAULT '0',
  `duedateTaskChange` char(1) NOT NULL DEFAULT '0',
  `clientAddTask` char(1) NOT NULL DEFAULT '0',
  `uploadFile` char(1) NOT NULL DEFAULT '0',
  `dailyAlert` char(1) NOT NULL DEFAULT '0',
  `weeklyAlert` char(1) NOT NULL DEFAULT '0',
  `pastdueAlert` char(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]notifications`
--

INSERT INTO `[[dbprefix]]notifications` VALUES
(1, 1, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1'),
(2, 2, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]organizations`
--

CREATE TABLE `[[dbprefix]]organizations` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `address1` varchar(255) DEFAULT NULL,
  `address2` varchar(255) DEFAULT NULL,
  `zip_code` varchar(155) DEFAULT NULL,
  `city` varchar(155) DEFAULT NULL,
  `country` varchar(155) DEFAULT NULL,
  `phone` varchar(155) DEFAULT NULL,
  `fax` varchar(155) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `email` varchar(155) DEFAULT NULL,
  `comments` text,
  `created` varchar(16) DEFAULT NULL,
  `extension_logo` char(3) NOT NULL DEFAULT '',
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `hourly_rate` float(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]organizations`
--

INSERT INTO `[[dbprefix]]organizations` VALUES
(1, '[[comp_name]]', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 0, 0.00);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phases`
--

CREATE TABLE `[[dbprefix]]phases` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `order_num` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` varchar(10) DEFAULT NULL,
  `name` varchar(155) DEFAULT NULL,
  `date_start` varchar(10) DEFAULT NULL,
  `date_end` varchar(10) DEFAULT NULL,
  `comments` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]posts`
--

CREATE TABLE `[[dbprefix]]posts` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `topic` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `member` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `created` varchar(16) DEFAULT NULL,
  `message` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]projects`
--

CREATE TABLE `[[dbprefix]]projects` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `organization` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `priority` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(155) DEFAULT NULL,
  `description` text,
  `url_dev` varchar(255) DEFAULT NULL,
  `url_prod` varchar(255) DEFAULT NULL,
  `created` varchar(16) DEFAULT NULL,
  `modified` varchar(16) DEFAULT NULL,
  `published` char(1) NOT NULL DEFAULT '',
  `upload_max` varchar(155) DEFAULT NULL,
  `phase_set` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `invoicing` char(1) NOT NULL DEFAULT '',
  `hourly_rate` float(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports`
--

CREATE TABLE `[[dbprefix]]reports` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(155) DEFAULT NULL,
  `projects` varchar(255) DEFAULT NULL,
  `members` varchar(255) DEFAULT NULL,
  `priorities` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `date_due_start` varchar(10) DEFAULT NULL,
  `date_due_end` varchar(10) DEFAULT NULL,
  `created` varchar(16) DEFAULT NULL,
  `date_complete_start` varchar(10) DEFAULT NULL,
  `date_complete_end` varchar(10) DEFAULT NULL,
  `clients` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]services`
--

CREATE TABLE `[[dbprefix]]services` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(155) DEFAULT NULL,
  `name_print` varchar(155) DEFAULT NULL,
  `hourly_rate` float(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sorting`
--

CREATE TABLE `[[dbprefix]]sorting` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `member` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `home_projects` varchar(155) DEFAULT NULL,
  `home_tasks` varchar(155) DEFAULT NULL,
  `home_discussions` varchar(155) DEFAULT NULL,
  `home_reports` varchar(155) DEFAULT NULL,
  `projects` varchar(155) DEFAULT NULL,
  `organizations` varchar(155) DEFAULT NULL,
  `project_tasks` varchar(155) DEFAULT NULL,
  `discussions` varchar(155) DEFAULT NULL,
  `project_discussions` varchar(155) DEFAULT NULL,
  `users` varchar(155) DEFAULT NULL,
  `team` varchar(155) DEFAULT NULL,
  `tasks` varchar(155) DEFAULT NULL,
  `report_tasks` varchar(155) DEFAULT NULL,
  `assignment` varchar(155) DEFAULT NULL,
  `reports` varchar(155) DEFAULT NULL,
  `files` varchar(155) DEFAULT NULL,
  `organization_projects` varchar(155) DEFAULT NULL,
  `notes` varchar(155) DEFAULT NULL,
  `calendar` varchar(155) DEFAULT NULL,
  `phases` varchar(155) DEFAULT NULL,
  `support_requests` varchar(155) DEFAULT NULL,
  `subtasks` varchar(155) DEFAULT NULL,
  `bookmarks` varchar(155) DEFAULT NULL,
  `invoices` varchar(155) DEFAULT NULL,
  `newsdesk` varchar(155) DEFAULT NULL,
  `home_subtasks` varchar(155) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]sorting`
--

INSERT INTO `[[dbprefix]]sorting` VALUES
(1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]subtasks`
--

CREATE TABLE `[[dbprefix]]subtasks` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `task` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `priority` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `assigned_to` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(155) DEFAULT NULL,
  `description` text,
  `start_date` varchar(10) DEFAULT NULL,
  `due_date` varchar(10) DEFAULT NULL,
  `estimated_time` varchar(10) DEFAULT NULL,
  `actual_time` varchar(10) DEFAULT NULL,
  `comments` text,
  `completion` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `created` varchar(16) DEFAULT NULL,
  `modified` varchar(16) DEFAULT NULL,
  `assigned` varchar(16) DEFAULT NULL,
  `published` char(1) NOT NULL DEFAULT '',
  `complete_date` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]support_posts`
--

CREATE TABLE `[[dbprefix]]support_posts` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `request_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `message` text,
  `date` varchar(16) DEFAULT NULL,
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]support_requests`
--

CREATE TABLE `[[dbprefix]]support_requests` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `status` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `member` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `priority` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `message` text,
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `date_open` varchar(16) DEFAULT NULL,
  `date_close` varchar(16) DEFAULT NULL,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tasks`
--

CREATE TABLE `[[dbprefix]]tasks` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `priority` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `assigned_to` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(155) DEFAULT NULL,
  `description` text,
  `start_date` varchar(10) DEFAULT NULL,
  `due_date` varchar(10) DEFAULT NULL,
  `estimated_time` varchar(10) DEFAULT NULL,
  `actual_time` varchar(10) DEFAULT NULL,
  `comments` text,
  `completion` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `created` varchar(16) DEFAULT NULL,
  `modified` varchar(16) DEFAULT NULL,
  `assigned` varchar(16) DEFAULT NULL,
  `published` char(1) NOT NULL DEFAULT '',
  `parent_phase` int(10) unsigned NOT NULL DEFAULT '0',
  `complete_date` varchar(10) DEFAULT NULL,
  `invoicing` char(1) NOT NULL DEFAULT '',
  `worked_hours` float(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]teams`
--

CREATE TABLE `[[dbprefix]]teams` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `member` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `published` char(1) NOT NULL DEFAULT '',
  `authorized` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]topics`
--

CREATE TABLE `[[dbprefix]]topics` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `owner` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(155) DEFAULT NULL,
  `status` char(1) NOT NULL DEFAULT '',
  `last_post` varchar(16) DEFAULT NULL,
  `posts` smallint(5) unsigned NOT NULL DEFAULT '0',
  `published` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]updates`
--

CREATE TABLE `[[dbprefix]]updates` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(1) NOT NULL DEFAULT '',
  `item` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `member` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `comments` text,
  `created` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
