
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_phpadr901`
--

-- --------------------------------------------------------

--
-- Table structure for table `addressbook`
--

CREATE TABLE `addressbook` (
  `domain_id` int(9) unsigned NOT NULL DEFAULT '0',
  `id` int(9) unsigned NOT NULL,
  `firstname` varchar(255) NOT NULL,
  `middlename` varchar(255) NOT NULL,
  `lastname` varchar(255) NOT NULL,
  `nickname` varchar(255) NOT NULL,
  `company` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `address` text NOT NULL,
  `addr_long` text,
  `addr_lat` text,
  `addr_status` text,
  `home` text NOT NULL,
  `mobile` text NOT NULL,
  `work` text NOT NULL,
  `fax` text NOT NULL,
  `email` text NOT NULL,
  `email2` text NOT NULL,
  `email3` text NOT NULL,
  `im` text NOT NULL,
  `im2` text NOT NULL,
  `im3` text NOT NULL,
  `homepage` text NOT NULL,
  `bday` tinyint(2) NOT NULL,
  `bmonth` varchar(50) NOT NULL,
  `byear` varchar(4) NOT NULL,
  `aday` tinyint(2) NOT NULL,
  `amonth` varchar(50) NOT NULL,
  `ayear` varchar(4) NOT NULL,
  `address2` text NOT NULL,
  `phone2` text NOT NULL,
  `notes` text NOT NULL,
  `photo` mediumtext,
  `x_vcard` mediumtext,
  `x_activesync` mediumtext,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `deprecated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `password` varchar(256) DEFAULT NULL,
  `login` date DEFAULT NULL,
  `role` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`id`,`deprecated`,`domain_id`),
  KEY `deprecated_domain_id_idx` (`deprecated`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `address_in_groups`
--

CREATE TABLE `address_in_groups` (
  `domain_id` int(9) unsigned NOT NULL DEFAULT '0',
  `id` int(9) unsigned NOT NULL DEFAULT '0',
  `group_id` int(9) unsigned NOT NULL DEFAULT '0',
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `deprecated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`group_id`,`id`,`deprecated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `group_list`
--

CREATE TABLE `group_list` (
  `domain_id` int(9) unsigned NOT NULL DEFAULT '0',
  `group_id` int(9) unsigned NOT NULL AUTO_INCREMENT,
  `group_parent_id` int(9) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `deprecated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `group_name` varchar(255) NOT NULL DEFAULT '',
  `group_header` mediumtext NOT NULL,
  `group_footer` mediumtext NOT NULL,
  PRIMARY KEY (`group_id`,`deprecated`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `month_lookup`
--

CREATE TABLE `month_lookup` (
  `bmonth` varchar(50) NOT NULL DEFAULT '',
  `bmonth_short` char(3) NOT NULL DEFAULT '',
  `bmonth_num` int(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bmonth_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `month_lookup`
--

INSERT INTO `month_lookup` VALUES
('', '', 0),
('January', 'Jan', 1),
('February', 'Feb', 2),
('March', 'Mar', 3),
('April', 'Apr', 4),
('May', 'May', 5),
('June', 'Jun', 6),
('July', 'Jul', 7),
('August', 'Aug', 8),
('September', 'Sep', 9),
('October', 'Oct', 10),
('November', 'Nov', 11),
('December', 'Dec', 12);

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` int(9) unsigned NOT NULL DEFAULT '0',
  `username` char(128) NOT NULL,
  `md5_pass` char(128) NOT NULL,
  `password_hint` varchar(255) NOT NULL DEFAULT '',
  `sso_facebook_uid` varchar(255) DEFAULT NULL,
  `sso_google_uid` varchar(255) DEFAULT NULL,
  `sso_live_uid` varchar(255) DEFAULT NULL,
  `sso_yahoo_uid` varchar(255) DEFAULT NULL,
  `lastname` varchar(50) NOT NULL DEFAULT '',
  `firstname` varchar(50) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `phone` varchar(50) NOT NULL DEFAULT '',
  `address1` varchar(100) NOT NULL DEFAULT '',
  `address2` varchar(100) NOT NULL DEFAULT '',
  `city` varchar(80) NOT NULL DEFAULT '',
  `state` varchar(20) NOT NULL DEFAULT '',
  `zip` varchar(20) NOT NULL DEFAULT '',
  `country` varchar(50) NOT NULL DEFAULT '',
  `master_code` char(128) NOT NULL,
  `confirmation_code` char(128) DEFAULT NULL,
  `pass_reset_code` char(128) DEFAULT NULL,
  `status` char(128) NOT NULL DEFAULT 'NEW' COMMENT 'New, Ready, Blocked',
  `trials` int(11) NOT NULL DEFAULT '0',
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `deprecated` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
