#!/usr/bin/perl
# encoding: utf-8
#
# author: Kyle Yetter
#
package IMH::CPanel::FindUser;


use strict;
use warnings;
use Switch;

require Exporter;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw( identify_user is_cpanel_user who_owns  ) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw( identify_user is_cpanel_user who_owns );

our $VERSION = '0.01';

our $domain_rx = qr((?:(?:[a-z0-9](?:[a-z0-9\-]*[a-z0-9])?)\.)*(?:[a-z0-9](?:[a-z0-9\-]*[a-z0-9])?)(?:\.(?:m(?:[acdeghkmnpqrstvwxyz]|u(?:seum)?|o(?:bi)?|i?l)|a(?:[cdfgilmnoqtuwxz]|e(?:ro)?|r(?:pa)?|s(?:ia)?)|c(?:[cdfghiklmnruvxyz]|o(?:op|m)?|at?)|t(?:[cdfghjkmnoptvwz]|r(?:avel)?|e?l)|n(?:[cfgilopruz]|a(?:me)?|et?)|b(?:[abdefghjmnorstvwyz]|iz?)|g(?:[abdefghilmnpqrstuwy]|ov)|i(?:[delmoqrst]|n(?:fo|t)?)|p(?:[aefghklmnstwy]|ro?)|s[abcdeghijklmnortuvyz]|j(?:[emp]|o(?:bs)?)|e(?:[cegrst]|d?u)|k[eghimnprwyz]|l[abcikrstuvy]|v[aceginu]|d[ejkmoz]|f[ijkmor]|h[kmnrtu]|o(?:rg|m)|u[agksyz]|r[eosuw]|z[amw]|w[fs]|y[et]|qa))+)i;
our $ip_rx = qr(^(?:(?:2(?:[0-4]\d|5[0-5])|1\d{2}|\d{1,2})\.){3}(?:2(?:[0-4][0-9]|5[0-5])|1\d{2}|\d{1,2})$);


sub who_owns($) {
  my $domain = quotemeta( shift );
  my $user   = undef;

  open( USERDOMAINS, "/etc/userdomains" ) or die "could not open /etc/userdomains: $!";

  SEARCH:
    while( <USERDOMAINS> ) {
      if ( /^$domain: (\S+)/i ) {
        $user = $1;
        last SEARCH;
      }
    }

  close( USERDOMAINS );

  return $user;
}

sub is_cpanel_user {
  my ( $user ) = @_;
  if ( $user =~ /^\w+$/ ) {
    getpwnam( $user ) and -f "/var/cpanel/users/$user" and return( 1 );
  }
  return 0;
}

sub identify_user {
  my ( $detail ) = @_;

  if ( is_cpanel_user( $detail ) ) {
    return $detail;
  }

  if ( $detail =~ /$domain_rx/ ) {
    return who_owns( $detail );
  }

  if ( -e $detail ) {
    my ( $user ) = getpwuid( ( stat( $detail ) )[ 4 ] );
    return $user;
  }

  return undef;
}



1;
__END__
=head1 NAME

IMH::CPanel::FindUser - Tools to identify cPanel users from a variety of information

=head1 SYNOPSIS

=head1 AUTHOR

Kyle Yetter, E<lt>kyley@inmotionhosting.com<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2011 by Kyle Yetter.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.10.1 or,
at your option, any later version of Perl 5 you may have available.


=cut
