
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `pagekit1018`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_comment`
--

CREATE TABLE `[[dbprefix]]blog_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL,
  `post_id` int(10) unsigned NOT NULL,
  `user_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `author` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]BLOG_COMMENT_AUTHOR` (`author`),
  KEY `[[dbprefix]]BLOG_COMMENT_CREATED` (`created`),
  KEY `[[dbprefix]]BLOG_COMMENT_STATUS` (`status`),
  KEY `[[dbprefix]]BLOG_COMMENT_POST_ID` (`post_id`),
  KEY `[[dbprefix]]BLOG_COMMENT_POST_ID_STATUS` (`post_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_post`
--

CREATE TABLE `[[dbprefix]]blog_post` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  `date` datetime DEFAULT NULL,
  `modified` datetime NOT NULL,
  `content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `excerpt` longtext COLLATE utf8_unicode_ci NOT NULL,
  `comment_status` tinyint(1) NOT NULL DEFAULT '0',
  `comment_count` int(11) NOT NULL DEFAULT '0',
  `data` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json_array)',
  `roles` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:simple_array)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]BLOG_POST_SLUG` (`slug`),
  KEY `[[dbprefix]]BLOG_POST_TITLE` (`title`),
  KEY `[[dbprefix]]BLOG_POST_USER_ID` (`user_id`),
  KEY `[[dbprefix]]BLOG_POST_DATE` (`date`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]blog_post`
--

INSERT INTO `[[dbprefix]]blog_post` VALUES
(1, 1, 'hello-pagekit', 'Hello Pagekit', 2, '[[regtime]]', '[[regtime]]', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod\ntempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,\nquis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo\nconsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse\ncillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non\nproident, sunt in culpa qui officia deserunt mollit anim id est laborum.', '', 1, 0, '{"title":null,"markdown":true}', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_auth`
--

CREATE TABLE `[[dbprefix]]system_auth` (
  `id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `access` datetime DEFAULT NULL,
  `status` smallint(6) NOT NULL,
  `data` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json_array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_config`
--

CREATE TABLE `[[dbprefix]]system_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]SYSTEM_CONFIG_NAME` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]system_config`
--

INSERT INTO `[[dbprefix]]system_config` VALUES
(1, 'system/dashboard', '{"55dda578e93b5":{"type":"location","column":1,"idx":0,"units":"metric","id":"55dda578e93b5","uid":2911298,"city":"Hamburg","country":"DE","coords":{"lon":10,"lat":53.549999}},"55dda581d5781":{"type":"feed","column":2,"idx":0,"count":5,"content":"1","id":"55dda581d5781","title":"Pagekit News","url":"http:\\/\\/pagekit.com\\/blog\\/feed"},"55dda6e3dd661":{"type":"user","column":0,"idx":100,"show":"registered","display":"thumbnail","total":"1","count":12,"id":"55dda6e3dd661"}}'),
(2, 'system/site', '{"menus":{"main":{"id":"main","label":"Main"}},"title":"[[site_name]]","frontpage":1,"view":{"logo":"storage\\/pagekit-logo.svg"}}'),
(3, 'system', '{"admin":{"locale":"en_US"},"site":{"locale":"en_US","theme":"theme-one"},"version":"1.0.18","packages":{"blog":"1.0.7","theme-one":"1.0.1"},"extensions":["blog"]}'),
(6, 'theme-one', '{"logo_contrast":"storage\\/pagekit-logo-contrast.svg","_menus":{"main":"main","offcanvas":"main"},"_positions":{"hero":[1],"footer":[2]},"_widgets":{"1":{"title_hide":true,"title_size":"uk-panel-title","alignment":true,"html_class":"","panel":""},"2":{"title_hide":true,"title_size":"uk-panel-title","alignment":"true","html_class":"","panel":""}},"_nodes":{"1":{"title_hide":true,"title_large":false,"alignment":true,"html_class":"","sidebar_first":false,"hero_image":"storage\\/home-hero.jpg","hero_viewport":true,"hero_contrast":true,"navbar_transparent":true}}}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_node`
--

CREATE TABLE `[[dbprefix]]system_node` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '0',
  `status` smallint(6) NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `path` varchar(1023) COLLATE utf8_unicode_ci NOT NULL,
  `link` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `menu` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `roles` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:simple_array)',
  `data` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json_array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]system_node`
--

INSERT INTO `[[dbprefix]]system_node` VALUES
(1, 0, 1, 1, 'Home', 'home', '/home', '@page/1', 'page', 'main', NULL, '{"defaults":{"id":1}}'),
(2, 0, 2, 1, 'Blog', 'blog', '/blog', '@blog', 'blog', 'main', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_page`
--

CREATE TABLE `[[dbprefix]]system_page` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `data` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json_array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]system_page`
--

INSERT INTO `[[dbprefix]]system_page` VALUES
(1, 'Home', '<div class="uk-width-medium-3-4 uk-container-center">\n    \n<h3 class="uk-h1 uk-margin-large-bottom">Uniting fresh design and clean code<br class="uk-hidden-small"> to create beautiful websites.</h3>\n\n<p class="uk-width-medium-4-6 uk-container-center">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.</p>\n\n</div>', '{"title":true}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_role`
--

CREATE TABLE `[[dbprefix]]system_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '0',
  `permissions` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:simple_array)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]SYSTEM_ROLE_NAME` (`name`),
  KEY `[[dbprefix]]SYSTEM_ROLE_NAME_PRIORITY` (`name`,`priority`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]system_role`
--

INSERT INTO `[[dbprefix]]system_role` VALUES
(1, 'Anonymous', 0, NULL),
(2, 'Authenticated', 1, 'blog: post comments'),
(3, 'Administrator', 2, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_session`
--

CREATE TABLE `[[dbprefix]]system_session` (
  `id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `time` datetime NOT NULL,
  `data` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]system_session`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_user`
--

CREATE TABLE `[[dbprefix]]system_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `status` smallint(6) NOT NULL DEFAULT '0',
  `registered` datetime NOT NULL,
  `login` datetime DEFAULT NULL,
  `activation` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `roles` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:simple_array)',
  `data` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json_array)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]SYSTEM_USER_USERNAME` (`username`),
  UNIQUE KEY `[[dbprefix]]SYSTEM_USER_EMAIL` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]system_user`
--

INSERT INTO `[[dbprefix]]system_user` VALUES
(1, '[[admin_realname]]', '[[admin_username]]', '[[admin_email]]', '[[admin_pass]]', '', 1, '[[regtime]]', NULL, NULL, '2,3', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_widget`
--

CREATE TABLE `[[dbprefix]]system_widget` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  `nodes` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:simple_array)',
  `roles` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:simple_array)',
  `data` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json_array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]system_widget`
--

INSERT INTO `[[dbprefix]]system_widget` VALUES
(1, 'Hello, I''m Pagekit', 'system/text', 1, '1', NULL, '{"content":"<h1 class=\\"uk-heading-large uk-margin-large-bottom\\">Hello, I''m Pagekit,<br class=\\"uk-hidden-small\\"> your new favorite CMS.<\\/h1>\\n\\n<a class=\\"uk-button uk-button-large\\" href=\\"http:\\/\\/www.pagekit.com\\">Get started<\\/a>"}'),
(2, 'Powered by Pagekit', 'system/text', 1, NULL, NULL, '{"content":"<ul class=\\"uk-grid uk-grid-medium uk-flex uk-flex-center\\">\\n    <li><a href=\\"https:\\/\\/github.com\\/pagekit\\" class=\\"uk-icon-hover uk-icon-small uk-icon-github\\"><\\/a><\\/li>\\n    <li><a href=\\"https:\\/\\/twitter.com\\/pagekit\\" class=\\"uk-icon-hover uk-icon-small uk-icon-twitter\\"><\\/a><\\/li>\\n    <li><a href=\\"https:\\/\\/gitter.im\\/pagekit\\/pagekit\\" class=\\"uk-icon-hover uk-icon-small uk-icon-comment-o\\"><\\/a><\\/li>\\n    <li><a href=\\"https:\\/\\/plus.google.com\\/communities\\/104125443335488004107\\" class=\\"uk-icon-hover uk-icon-small uk-icon-google-plus\\"><\\/a><\\/li>\\n<\\/ul>\\n\\n<p>Powered by <a href=\\"https:\\/\\/pagekit.com\\">Pagekit<\\/a><\\/p>"}');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
