SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

DROP TABLE IF EXISTS `entry`;
CREATE TABLE `entry` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `prefix` int(10) NOT NULL,
  `content` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `time` int(10) NOT NULL,
  `from` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `userid` int(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `follow`;
CREATE TABLE `follow` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `blogurl` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `lastupdate` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `followlog`;
CREATE TABLE `followlog` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `entryid` int(10) NOT NULL,
  `message` text COLLATE utf8_unicode_ci NOT NULL,
  `time` int(10) NOT NULL,
  `followid` int(10) NOT NULL,
  `from` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `picture` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `picture`;
CREATE TABLE `picture` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `entryid` int(10) NOT NULL,
  `time` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `prefix`;
CREATE TABLE IF NOT EXISTS `prefix` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `prefix` (`id`, `title`, `class`) VALUES
(1, '说', 'says'),
(3, '想', 'thinks'),
(4, '是', 'is'),
(5, '觉得', 'feels'),
(6, '想知道', 'wonders'),
(7, '曾经', 'was'),
(8, '有', 'has'),
(9, '问', 'asks'),
(10, '希望', 'hopes'),
(11, '将会', 'will'),
(12, '需要', 'needs'),
(13, '要', 'wants'),
(14, '讨厌', 'hates'),
(15, '推荐', 'shares'),
(16, '喜欢', 'likes'),
(17, '爱', 'loves'),
(18, '分享', 'shares');


DROP TABLE IF EXISTS `reply`;
CREATE TABLE `reply` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `entryid` int(10) NOT NULL,
  `geo` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `message` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `time` int(10) NOT NULL,
  `userid` int(10) NOT NULL,
  `nickname` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `entryid` (`entryid`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `rssfeeds`;
CREATE TABLE `rssfeeds` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `url` text COLLATE utf8_unicode_ci NOT NULL,
  `from` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(10) NOT NULL,
  `field` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `rsslog`;
CREATE TABLE `rsslog` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `rssid` int(10) NOT NULL,
  `hash` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `rpchash` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `administrator` int(1) NOT NULL,
  `about` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `avatar` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `meta_keywords` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `lastfm` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sync` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `flickr` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `skin` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;