<?php
/* PageCookery Framework
*
* Author: Explon
*
* Copyright (C) 2007 Explon <explon@gmail.com>
*/

class Format
{
	static function Safe($request, $istext = false)
	{	
		// If we are on PHP >= 6.0.0 we do not need some code
		if (version_compare(PHP_VERSION, '6.0.0-dev', '<'))
		{			
			$request = addslashes($request);
		}
		
		if ($istext === true)
		{
			$request = strip_tags(str_replace(array('<', '>'), array('&lt;', '&gt;'), $request));
		}
		
		return $request;
	}

	static function Date($timestamp, $format = 'Y-m-d H:i:s', $timezone = '8')
	{
		return gmdate($format, $timestamp + $timezone * 3600);
	}
	
	static function Time($timestamp, $limitday = 0)
	{
		$timer = time() - $timestamp;
		
		if ($limitday > 0)
		{
			if ($timer > 3600 * 24 * $limitday)
			{
				return self::Date($timestamp);
			}
		}
		
		$year = 3600 * 24 * 365;
		$month = 3600 * 24 * 30;
		$day = 3600 * 24;
		
		if ($timer > $year)
		{
			$string_year = $timer / $year;
			
			$timer = $timer - intval($string_year) * $year;
			
			if ($timer == 0)
			{
				$string = intval($string_year) . ' 年前';
			}
			else
			{
				$string = intval($string_year) . ' 年, ';
			}
		}
		
		if (intval($timer) > $month)
		{			
			$string_month = $timer / $month;
			
			$timer = $timer - intval($string_month) * $month;
			
			if ($timer == 0)
			{
				$string .= intval($string_month) . ' 月前';
			}
			else
			{
				$string .= intval($string_month) . ' 月, ';
			}
		}
		
		if (intval($timer) > $day)
		{
			$string_day = $timer / $day;
			
			$timer = $timer - intval($string_day) * $day;
			
			if ($timer == 0)
			{
				$string .= intval($string_day) . ' 天前';
			}
			else
			{
				$string .= intval($string_day) . ' 天, ';
			}
		}
		
		if (intval($timer) > 3600)
		{				
			$string_hour = $timer / 3600;
			
			$timer = $timer - intval($string_hour) * 3600;
			
			if ($timer < 60)
			{
				$string .= intval($string_hour) . ' 小时前';
			}
			else
			{
				$string .= intval($string_hour) . ' 小时, ';
			}
		}
		
		if (!$string AND $timer < 60)
		{
			$string = $timer . ' 秒钟前';
		}
		else if ($timer > 60)
		{
			$string_minute = $timer / 60;
			$string .= intval($string_minute) . ' 分钟前';
		}
		
		
		return $string;
	}
	
	static function DaysInMonth($month = 0, $year = '')
	{
		if ($month < 1 OR $month > 12)
		{
			return 0;
		}
	
		if ( ! is_numeric($year) OR strlen($year) != 4)
		{
			$year = date('Y');
		}
	
		if ($month == 2)
		{
			if ($year % 400 == 0 OR ($year % 4 == 0 AND $year % 100 != 0))
			{
				return 29;
			}
		}

		$days_in_month	= array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
		
		return $days_in_month[$month - 1];
	}
	
	static function ParseBBCode($text)
	{	
		$p[] = '#\[img\]([\w]+?://[\w\#$%&~/.\-;:=,' . "'" . '?@\[\]+]*?)\[/img\]#is';
		// matches a [url]xxxx://www.livid.cn[/url] code..
		$p[] = "#\[url\]([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\[/url\]#is";
		// [url]www.livid.cn[/url] code.. (no xxxx:// prefix).
		$p[] = "#\[url\]((www|ftp)\.[\w\#$%&~/.\-;:=,?@\[\]+]*?)\[/url\]#is";
		// [url=xxxx://www.phpbb.com]phpBB[/url] code..
		$p[] = "#\[url=([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\]([^?\n\r\t].*?)\[/url\]#is";
		// [url=www.phpbb.com]phpBB[/url] code.. (no xxxx:// prefix).
		$p[] = "#\[url=((www|ftp)\.[\w\#$%&~/.\-;:=,?@\[\]+]*?)\]([^?\n\r\t].*?)\[/url\]#is";
		// [email]user@domain.tld[/email] code..
		$p[] = "#\[url=([\w\#$%&~/.\-;:=,?@\[\]+]*?)\]([^?\n\r\t].*?)\[/url\]#is";
		$p[] = "#\[email\]([a-z0-9&\-_.]+?@[\w\-]+\.([\w\-\.]+\.)?[\w]+)\[/email\]#si";
		$p[] = '/\[url\]([^?].*?)\[\/url\]/i';
		$p[] = "#\[color=(.*?)\](.*?)\[/color\]#is";
		$p[] = "#\[size=(.*?)\](.*?)\[/size\]#is";
		$p[] = "#\[flash\]([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\[/flash\]#is";
		$p[] = "#\[font=(.*?)\](.*?)\[/font\]#is";
		
		$r[] = '<img src="$1" alt="" style="vertical-align:middle;" />';
		$r[] = '<a href="$1" rel="nofollow external" target="_blank">$1</a>';
		$r[] = '<a href="http://$1" rel="nofollow external" target="_blank">http://$1</a>';
		$r[] = '<a href="$1" rel="nofollow external" target="_blank">$2</a>';
		$r[] = '<a href="http://$1" rel="nofollow external" target="_blank">$2</a>';
		$r[] = '<a href="$1">$2</a>';
		$r[] = '<a href="mailto:$1">$1</a>';
		$r[] = '<a href="$1" target="_blank">$1</a>';
		$r[] = '<span style="color: $1">$2</span>';
		$r[] = '<font size="$1">$2</font>';
		$r[] = '<embed src="$1" width="640" height="500" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" wmode="transparent"></embed>';
		$r[] = '<font face="$1">$2</font>';
		
		if (function_exists('hook_format_parse_bbcode'))
		{
			$extra_array = hook_format_parse_bbcode();
			
			foreach ($extra_array AS $regex => $replace)
			{
				$p[] = $regex;
				$r[] = $replace;
			}
		}
		
		
		$text = preg_replace($p, $r, $text);
	
	
		preg_match('/\[b\]/i', $text, $_m_b_open);
		preg_match('/\[\/b\]/i', $text, $_m_b_close);
		
		preg_match('/\[i\]/i', $text, $_m_i_open);
		preg_match('/\[\/i\]/i', $text, $_m_i_close);
		
		preg_match('/\[u\]/i', $text, $_m_u_open);
		preg_match('/\[\/u\]/i', $text, $_m_u_close);
		
		preg_match('/\[s\]/i', $text, $_m_s_open);
		preg_match('/\[\/s\]/i', $text, $_m_s_close);
	
		preg_match('/\[quote\]/i', $text, $_m_quote_open);
		preg_match('/\[\/quote\]/i', $text, $_m_quote_close);
		
		if (count($_m_b_open) == count($_m_b_close)) {
			$text = str_ireplace("[b]\n", '[b]', $text);
			$text = str_ireplace("\n[/b]", '[/b]', $text);
			$text = str_ireplace('[b]', '<strong>', $text);
			$text = str_ireplace('[/b]', '</strong>', $text);
		}
		
		if (count($_m_i_open) == count($_m_i_close)) {
			$text = str_ireplace("[i]\n", '[i]', $text);
			$text = str_ireplace("\n[/i]", '[/i]', $text);
			$text = str_ireplace('[i]', '<em>', $text);
			$text = str_ireplace('[/i]', '</em>', $text);
		}
		
		if (count($_m_u_open) == count($_m_u_close)) {
			$text = str_ireplace("[u]\n", '[u]', $text);
			$text = str_ireplace("\n[/u]", '[/u]', $text);
			$text = str_ireplace('[u]', '<u>', $text);
			$text = str_ireplace('[/u]', '</u>', $text);
		}
		
		if (count($_m_s_open) == count($_m_s_close)) {
			$text = str_ireplace("[s]\n", '[s]', $text);
			$text = str_ireplace("\n[/s]", '[/s]', $text);
			$text = str_ireplace('[s]', '<s>', $text);
			$text = str_ireplace('[/s]', '</s>', $text);
		}
		
		if (count($_m_quote_open) == count($_m_quote_close)) {
			$text = str_ireplace("[quote]\n", '[quote]', $text);
			$text = str_ireplace("\n[/quote]", '[/quote]', $text);
			$text = str_ireplace('[quote]', '<div class="quote">', $text);
			$text = str_ireplace('[/quote]', '</div>', $text);
		}
		
		//$text = str_ireplace('script', '<span>script</span>', $text);
		
		return self::ParseLinks($text);
	}
	
	static function ParseLinks($str, $popup = TRUE)
	{
		if (preg_match_all("/([a-zA-Z0-9_\.\-\+]+)@([a-zA-Z0-9\-]+)\.([a-zA-Z0-9\-\.]*)/i", $str, $matches))
		{
			for ($i = 0; $i < count($matches['0']); $i++)
			{
				$period = '';
				
				if (preg_match("|\.$|", $matches['3'][$i]))
				{
					$period = '.';
					$matches['3'][$i] = substr($matches['3'][$i], 0, -1);
				}
	
				$str = str_replace($matches['0'][$i], $matches['1'][$i] . '@' . $matches['2'][$i] . '.' . $matches['3'][$i] . $period, $str);
			}
		}
		
		return $str;
	}
	
	static function StripBBCode($text)
	{
		$p[] = '#\[img\]([\w]+?://[\w\#$%&~/.\-;:=,' . "'" . '?@\[\]+]*?)\[/img\]#is';
		// matches a [url]xxxx://www.livid.cn[/url] code..
		$p[] = "#\[url\]([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\[/url\]#is";
		// [url]www.livid.cn[/url] code.. (no xxxx:// prefix).
		$p[] = "#\[url\]((www|ftp)\.[\w\#$%&~/.\-;:=,?@\[\]+]*?)\[/url\]#is";
		// [url=xxxx://www.phpbb.com]phpBB[/url] code..
		$p[] = "#\[url=([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\]([^?\n\r\t].*?)\[/url\]#is";
		// [url=www.phpbb.com]phpBB[/url] code.. (no xxxx:// prefix).
		$p[] = "#\[url=((www|ftp)\.[\w\#$%&~/.\-;:=,?@\[\]+]*?)\]([^?\n\r\t].*?)\[/url\]#is";
		// [email]user@domain.tld[/email] code..
		$p[] = "#\[email\]([a-z0-9&\-_.]+?@[\w\-]+\.([\w\-\.]+\.)?[\w]+)\[/email\]#si";
		$p[] = '/\[url\]([^?].*?)\[\/url\]/i';
		$p[] = "#\[color=(.*?)\](.*?)\[/color\]#is";
		$p[] = "#\[size=(.*?)\](.*?)\[/size\]#is";
		$p[] = "#\[flash\]([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*?)\[/flash\]#is";
		$p[] = "#\[font=(.*?)\](.*?)\[/font\]#is";
	
		preg_match('/\[b\]/i', $text, $_m_b_open);
		preg_match('/\[\/b\]/i', $text, $_m_b_close);
		
		preg_match('/\[i\]/i', $text, $_m_i_open);
		preg_match('/\[\/i\]/i', $text, $_m_i_close);
		
		preg_match('/\[u\]/i', $text, $_m_u_open);
		preg_match('/\[\/u\]/i', $text, $_m_u_close);
		
		preg_match('/\[s\]/i', $text, $_m_s_open);
		preg_match('/\[\/s\]/i', $text, $_m_s_close);
	
		preg_match('/\[quote\]/i', $text, $_m_quote_open);
		preg_match('/\[\/quote\]/i', $text, $_m_quote_close);
		
		if (count($_m_b_open) == count($_m_b_close)) {
			$text = str_ireplace("[b]\n", '[b]', $text);
			$text = str_ireplace("\n[/b]", '[/b]', $text);
			$text = str_ireplace('[b]', '', $text);
			$text = str_ireplace('[/b]', '', $text);
		}
		
		if (count($_m_i_open) == count($_m_i_close)) {
			$text = str_ireplace("[i]\n", '[i]', $text);
			$text = str_ireplace("\n[/i]", '[/i]', $text);
			$text = str_ireplace('[i]', '', $text);
			$text = str_ireplace('[/i]', '', $text);
		}
		
		if (count($_m_u_open) == count($_m_u_close)) {
			$text = str_ireplace("[u]\n", '[u]', $text);
			$text = str_ireplace("\n[/u]", '[/u]', $text);
			$text = str_ireplace('[u]', '', $text);
			$text = str_ireplace('[/u]', '', $text);
		}
		
		if (count($_m_s_open) == count($_m_s_close)) {
			$text = str_ireplace("[s]\n", '[s]', $text);
			$text = str_ireplace("\n[/s]", '[/s]', $text);
			$text = str_ireplace('[s]', '', $text);
			$text = str_ireplace('[/s]', '', $text);
		}
		
		if (count($_m_quote_open) == count($_m_quote_close)) {
			$text = str_ireplace("[quote]\n", '[quote]', $text);
			$text = str_ireplace("\n[/quote]", '[/quote]', $text);
			$text = str_ireplace('[quote]', '', $text);
			$text = str_ireplace('[/quote]', '', $text);
		}
		
		if (function_exists('hook_format_parse_bbcode'))
		{
			$extra_array = hook_format_parse_bbcode();
			
			foreach ($extra_array AS $regex => $replace)
			{
				$p[] = $regex;
			}
		}
		
		$text = preg_replace($p, '', $text);
		
		return $text;
	}
}
