<?php
/* PageCookery Framework
*
* Author: Explon
*
* Copyright (C) 2009 Explon <explon@gmail.com>
*/

class Pages
{
	static $current_page = 1;
	
	static function GetQueryLimit($current, $limit)
	{		
		if ($current)
		{
			if ($current < 2)
			{
				$start = 0;
			}
			else if ($limit == 1)
			{
				$start = $current - 1;
			}
			else
			{
				$start = $limit * ($current - 1);
			}
		}
		else
		{
			$start = 0;
		}

		return $start . " , " . $limit;
	}
	
	
	static function DrawPages($total, $limit, $location, $get, $rewrite = false)
	{
		if ($total <= $limit)
		{
			return false;
		}
		
		foreach ($get AS $page_get_key => $page_get_value)
		{
			// Extract Values
		}
		
		$current = $page_get_value;
		
		if ($current)
		{
			if ($current < 2)
			{
				$start = 0;
				$end = $limit;
			}
			else if ($limit == 1)
			{
				$start = $current - 1;
				$end = 1;
			}
			else
			{
				$start = $limit * ($current - 1);
				$end = $limit;
			}
		}
		else
		{
			$start = 0;
			$end = $limit;
		}

		$end = $end + 1;
		
		if ($current > 1)
		{
			self::$current_page = $current;
		}
		
		return self::OutputPage(self::$current_page, $start, $end, $total, $location, serialize($get), $limit, $rewrite);
	}
	
	static function OutputPage($current, $start, $end, $total, $location, $get = array(), $limit, $rewrite)
	{
		$get = unserialize(stripslashes(urldecode($get)));
		
		foreach ($get AS $page_get_key => $page_get_value)
		{
			// Extract Values
		}
		
		$current = intval($current);
		$start = intval($start);
		$end = intval($end);
		$location = urldecode($location);
		$limit = intval($limit);
		
		if (strstr($location, '?'))
		{
			$output_connect_tag = '&amp;';
		}
		else
		{
			$output_connect_tag = '?';
		}
		
		$residual = 2;
		
		$count = $total / $limit;
		
		$content_residual = $total - $current * $limit;
		
		if ($count > intval($count))
		{
			$count = intval($count) + 1;
		}
		else
		{
			$residual++;
		}
		
		$output .= '<div class="pages"><em>共 ' . $total . ' 条</em>';

		if ($start > 0 AND $current > 4 AND $count > 5)
		{
			$pp = $current - 1;
			
			if ($rewrite)
			{
				$output .= '<a href="' . $location . '/1/" title="首页">1 ...</a><a href="' . $location . '/' . $pp . '/" title="上一页">«</a>';
			}
			else
			{
				$output .= '<a href="' . $location . $output_connect_tag . $page_get_key . '=1" title="首页">1 ...</a><a href="' . $location . $output_connect_tag . $page_get_key . '=' . $pp . '" title="上一页">«</a>';
			}
			
		}
		else if ($current == 4 AND $count > 4)
		{
			if ($rewrite)
			{
				$output .= '<a href="' . $location . '/1/">1</a>';
			}
			else
			{
				$output .= '<a href="' . $location . $output_connect_tag . $page_get_key . '=1">1</a>';
			}
		}
		
		$start_previous = $current - 2;
		$start_residual = $current + 2;
		
		if ($start_previous == -2)
		{
			$start_residual = $current + 5;
		}		
		else if ($start_previous < 0)
		{
			$start_residual = $current + 4;
		}
		else if ($start_previous == 0)
		{
			$start_residual = $current + 3;
		}
		
		if ($count < 5)
		{
			$start_previous = 1;
		}
		else if ($start_previous < 1)
		{
			$start_previous = 1;
		}
		
		if ($start_residual > $count)
		{
			$start_residual = $count;
		}
		
		for ($i = $start_previous; $i <= $start_residual; $i++)
		{	
			if ($i == $current)
			{
				$output .= '<strong>' . $i . '</strong>';
			}
			else
			{
				if (!$current AND $i == 1)
				{
					$output .= '<strong>1</strong>';
				}
				else
				{   
					if ($rewrite)
					{
						$output .= '<a href="' . $location . '/' . $i . '/">' . $i . '</a>';
					}
					else
					{
						$output .= '<a href="' . $location . $output_connect_tag . $page_get_key . '=' . $i . '">' . $i . '</a>';
					}
				}
			}
		}

		if ($content_residual > $limit AND $current < $count - $residual AND $count > 5 AND $count - $current > 3)
		{
			if ($current)
			{
				$pp = $current + 1;
			}
			else
			{
				$pp = 2;
			}
			
			if ($rewrite)
			{	
				$output .= '<a href="' . $location . '/' . $pp . '/" title="下一页">»</a><a href="' . $location . '/' . $count . '/" title="尾页">... ' . $count . '</a>';
			}
			else
			{
				$output .= '<a href="' . $location . $output_connect_tag . $page_get_key . '=' . $pp . '" title="下一页">»</a><a href="' . $location . $output_connect_tag . $page_get_key . '=' . $count . '" title="尾页">... ' . $count . '</a>';
			}
		}
		else if ($count - $current == 3 AND $count > 5)
		{
			if ($rewrite)
			{	
				$output .= '<a href="' . $location . '/' . $count . '/">' . $count . '</a>';
			}
			else
			{
				$output .= '<a href="' . $location . $output_connect_tag . $page_get_key . '=' . $count . '">' . $count . '</a>';
			}
		}
		
		if (substr($location, 0, 2) == './')
		{
			$location = substr($location, 2);
		}
		
		if ($rewrite)
    	{
    		$output .= '<kbd><input type="text" name="custompage" size="3" onkeydown="if (event.keyCode == 13) { if (this.value > ' . $count . ' || this.value < 1) { alert(\'请输入 1 - ' . $count . ' 范围内的页码.\'); this.value = \'\'; } else { window.location = \'' . BASE_URL . $location . '/\' + this.value + \'/\'; return false; } }" title="快速翻页" /></kbd></div>';
    	}
    	else
    	{
    		$output .= '<kbd><input type="text" name="custompage" size="3" onkeydown="if (event.keyCode == 13) { if (this.value > ' . $count . ' || this.value < 1) { alert(\'请输入 1 - ' . $count . ' 范围内的页码.\'); this.value = \'\'; } else { window.location = \'' . BASE_URL . $location . $output_connect_tag . $page_get_key . '=\' + this.value; return false; } }" title="快速翻页" /></kbd></div>';
    	}
		
		return $output;
	}
}
