<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* ManagedDevice File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright © Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Microsoft\Graph\Model;

/**
* ManagedDevice class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright © Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class ManagedDevice extends Entity
{
    /**
    * Gets the activationLockBypassCode
    * Code that allows the Activation Lock on a device to be bypassed.
    *
    * @return string The activationLockBypassCode
    */
    public function getActivationLockBypassCode()
    {
        if (array_key_exists("activationLockBypassCode", $this->_propDict)) {
            return $this->_propDict["activationLockBypassCode"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the activationLockBypassCode
    * Code that allows the Activation Lock on a device to be bypassed.
    *
    * @param string $val The activationLockBypassCode
    *
    * @return ManagedDevice
    */
    public function setActivationLockBypassCode($val)
    {
        $this->_propDict["activationLockBypassCode"] = $val;
        return $this;
    }
    
    /**
    * Gets the androidSecurityPatchLevel
    * Android security patch level
    *
    * @return string The androidSecurityPatchLevel
    */
    public function getAndroidSecurityPatchLevel()
    {
        if (array_key_exists("androidSecurityPatchLevel", $this->_propDict)) {
            return $this->_propDict["androidSecurityPatchLevel"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the androidSecurityPatchLevel
    * Android security patch level
    *
    * @param string $val The androidSecurityPatchLevel
    *
    * @return ManagedDevice
    */
    public function setAndroidSecurityPatchLevel($val)
    {
        $this->_propDict["androidSecurityPatchLevel"] = $val;
        return $this;
    }
    
    /**
    * Gets the azureADDeviceId
    * The unique identifier for the Azure Active Directory device. Read only.
    *
    * @return string The azureADDeviceId
    */
    public function getAzureADDeviceId()
    {
        if (array_key_exists("azureADDeviceId", $this->_propDict)) {
            return $this->_propDict["azureADDeviceId"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the azureADDeviceId
    * The unique identifier for the Azure Active Directory device. Read only.
    *
    * @param string $val The azureADDeviceId
    *
    * @return ManagedDevice
    */
    public function setAzureADDeviceId($val)
    {
        $this->_propDict["azureADDeviceId"] = $val;
        return $this;
    }
    
    /**
    * Gets the azureADRegistered
    * Whether the device is Azure Active Directory registered.
    *
    * @return bool The azureADRegistered
    */
    public function getAzureADRegistered()
    {
        if (array_key_exists("azureADRegistered", $this->_propDict)) {
            return $this->_propDict["azureADRegistered"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the azureADRegistered
    * Whether the device is Azure Active Directory registered.
    *
    * @param bool $val The azureADRegistered
    *
    * @return ManagedDevice
    */
    public function setAzureADRegistered($val)
    {
        $this->_propDict["azureADRegistered"] = boolval($val);
        return $this;
    }
    
    /**
    * Gets the complianceGracePeriodExpirationDateTime
    * The DateTime when device compliance grace period expires
    *
    * @return \DateTime The complianceGracePeriodExpirationDateTime
    */
    public function getComplianceGracePeriodExpirationDateTime()
    {
        if (array_key_exists("complianceGracePeriodExpirationDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["complianceGracePeriodExpirationDateTime"], "\DateTime")) {
                return $this->_propDict["complianceGracePeriodExpirationDateTime"];
            } else {
                $this->_propDict["complianceGracePeriodExpirationDateTime"] = new \DateTime($this->_propDict["complianceGracePeriodExpirationDateTime"]);
                return $this->_propDict["complianceGracePeriodExpirationDateTime"];
            }
        }
        return null;
    }
    
    /**
    * Sets the complianceGracePeriodExpirationDateTime
    * The DateTime when device compliance grace period expires
    *
    * @param \DateTime $val The complianceGracePeriodExpirationDateTime
    *
    * @return ManagedDevice
    */
    public function setComplianceGracePeriodExpirationDateTime($val)
    {
        $this->_propDict["complianceGracePeriodExpirationDateTime"] = $val;
        return $this;
    }
    
    /**
    * Gets the complianceState
    * Compliance state of the device. Possible values are: unknown, compliant, noncompliant, conflict, error, inGracePeriod, configManager.
    *
    * @return ComplianceState The complianceState
    */
    public function getComplianceState()
    {
        if (array_key_exists("complianceState", $this->_propDict)) {
            if (is_a($this->_propDict["complianceState"], "Microsoft\Graph\Model\ComplianceState")) {
                return $this->_propDict["complianceState"];
            } else {
                $this->_propDict["complianceState"] = new ComplianceState($this->_propDict["complianceState"]);
                return $this->_propDict["complianceState"];
            }
        }
        return null;
    }
    
    /**
    * Sets the complianceState
    * Compliance state of the device. Possible values are: unknown, compliant, noncompliant, conflict, error, inGracePeriod, configManager.
    *
    * @param ComplianceState $val The complianceState
    *
    * @return ManagedDevice
    */
    public function setComplianceState($val)
    {
        $this->_propDict["complianceState"] = $val;
        return $this;
    }
    
    /**
    * Gets the configurationManagerClientEnabledFeatures
    * ConfigrMgr client enabled features
    *
    * @return ConfigurationManagerClientEnabledFeatures The configurationManagerClientEnabledFeatures
    */
    public function getConfigurationManagerClientEnabledFeatures()
    {
        if (array_key_exists("configurationManagerClientEnabledFeatures", $this->_propDict)) {
            if (is_a($this->_propDict["configurationManagerClientEnabledFeatures"], "Microsoft\Graph\Model\ConfigurationManagerClientEnabledFeatures")) {
                return $this->_propDict["configurationManagerClientEnabledFeatures"];
            } else {
                $this->_propDict["configurationManagerClientEnabledFeatures"] = new ConfigurationManagerClientEnabledFeatures($this->_propDict["configurationManagerClientEnabledFeatures"]);
                return $this->_propDict["configurationManagerClientEnabledFeatures"];
            }
        }
        return null;
    }
    
    /**
    * Sets the configurationManagerClientEnabledFeatures
    * ConfigrMgr client enabled features
    *
    * @param ConfigurationManagerClientEnabledFeatures $val The configurationManagerClientEnabledFeatures
    *
    * @return ManagedDevice
    */
    public function setConfigurationManagerClientEnabledFeatures($val)
    {
        $this->_propDict["configurationManagerClientEnabledFeatures"] = $val;
        return $this;
    }
    

     /** 
     * Gets the deviceActionResults
    * List of ComplexType deviceActionResult objects.
     *
     * @return array The deviceActionResults
     */
    public function getDeviceActionResults()
    {
        if (array_key_exists("deviceActionResults", $this->_propDict)) {
           return $this->_propDict["deviceActionResults"];
        } else {
            return null;
        }
    }
    
    /** 
    * Sets the deviceActionResults
    * List of ComplexType deviceActionResult objects.
    *
    * @param DeviceActionResult $val The deviceActionResults
    *
    * @return ManagedDevice
    */
    public function setDeviceActionResults($val)
    {
		$this->_propDict["deviceActionResults"] = $val;
        return $this;
    }
    
    /**
    * Gets the deviceCategoryDisplayName
    * Device category display name
    *
    * @return string The deviceCategoryDisplayName
    */
    public function getDeviceCategoryDisplayName()
    {
        if (array_key_exists("deviceCategoryDisplayName", $this->_propDict)) {
            return $this->_propDict["deviceCategoryDisplayName"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the deviceCategoryDisplayName
    * Device category display name
    *
    * @param string $val The deviceCategoryDisplayName
    *
    * @return ManagedDevice
    */
    public function setDeviceCategoryDisplayName($val)
    {
        $this->_propDict["deviceCategoryDisplayName"] = $val;
        return $this;
    }
    
    /**
    * Gets the deviceEnrollmentType
    * Enrollment type of the device. Possible values are: unknown, userEnrollment, deviceEnrollmentManager, appleBulkWithUser, appleBulkWithoutUser, windowsAzureADJoin, windowsBulkUserless, windowsAutoEnrollment, windowsBulkAzureDomainJoin, windowsCoManagement.
    *
    * @return DeviceEnrollmentType The deviceEnrollmentType
    */
    public function getDeviceEnrollmentType()
    {
        if (array_key_exists("deviceEnrollmentType", $this->_propDict)) {
            if (is_a($this->_propDict["deviceEnrollmentType"], "Microsoft\Graph\Model\DeviceEnrollmentType")) {
                return $this->_propDict["deviceEnrollmentType"];
            } else {
                $this->_propDict["deviceEnrollmentType"] = new DeviceEnrollmentType($this->_propDict["deviceEnrollmentType"]);
                return $this->_propDict["deviceEnrollmentType"];
            }
        }
        return null;
    }
    
    /**
    * Sets the deviceEnrollmentType
    * Enrollment type of the device. Possible values are: unknown, userEnrollment, deviceEnrollmentManager, appleBulkWithUser, appleBulkWithoutUser, windowsAzureADJoin, windowsBulkUserless, windowsAutoEnrollment, windowsBulkAzureDomainJoin, windowsCoManagement.
    *
    * @param DeviceEnrollmentType $val The deviceEnrollmentType
    *
    * @return ManagedDevice
    */
    public function setDeviceEnrollmentType($val)
    {
        $this->_propDict["deviceEnrollmentType"] = $val;
        return $this;
    }
    
    /**
    * Gets the deviceHealthAttestationState
    * The device health attestation state.
    *
    * @return DeviceHealthAttestationState The deviceHealthAttestationState
    */
    public function getDeviceHealthAttestationState()
    {
        if (array_key_exists("deviceHealthAttestationState", $this->_propDict)) {
            if (is_a($this->_propDict["deviceHealthAttestationState"], "Microsoft\Graph\Model\DeviceHealthAttestationState")) {
                return $this->_propDict["deviceHealthAttestationState"];
            } else {
                $this->_propDict["deviceHealthAttestationState"] = new DeviceHealthAttestationState($this->_propDict["deviceHealthAttestationState"]);
                return $this->_propDict["deviceHealthAttestationState"];
            }
        }
        return null;
    }
    
    /**
    * Sets the deviceHealthAttestationState
    * The device health attestation state.
    *
    * @param DeviceHealthAttestationState $val The deviceHealthAttestationState
    *
    * @return ManagedDevice
    */
    public function setDeviceHealthAttestationState($val)
    {
        $this->_propDict["deviceHealthAttestationState"] = $val;
        return $this;
    }
    
    /**
    * Gets the deviceName
    * Name of the device
    *
    * @return string The deviceName
    */
    public function getDeviceName()
    {
        if (array_key_exists("deviceName", $this->_propDict)) {
            return $this->_propDict["deviceName"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the deviceName
    * Name of the device
    *
    * @param string $val The deviceName
    *
    * @return ManagedDevice
    */
    public function setDeviceName($val)
    {
        $this->_propDict["deviceName"] = $val;
        return $this;
    }
    
    /**
    * Gets the deviceRegistrationState
    * Device registration state. Possible values are: notRegistered, registered, revoked, keyConflict, approvalPending, certificateReset, notRegisteredPendingEnrollment, unknown.
    *
    * @return DeviceRegistrationState The deviceRegistrationState
    */
    public function getDeviceRegistrationState()
    {
        if (array_key_exists("deviceRegistrationState", $this->_propDict)) {
            if (is_a($this->_propDict["deviceRegistrationState"], "Microsoft\Graph\Model\DeviceRegistrationState")) {
                return $this->_propDict["deviceRegistrationState"];
            } else {
                $this->_propDict["deviceRegistrationState"] = new DeviceRegistrationState($this->_propDict["deviceRegistrationState"]);
                return $this->_propDict["deviceRegistrationState"];
            }
        }
        return null;
    }
    
    /**
    * Sets the deviceRegistrationState
    * Device registration state. Possible values are: notRegistered, registered, revoked, keyConflict, approvalPending, certificateReset, notRegisteredPendingEnrollment, unknown.
    *
    * @param DeviceRegistrationState $val The deviceRegistrationState
    *
    * @return ManagedDevice
    */
    public function setDeviceRegistrationState($val)
    {
        $this->_propDict["deviceRegistrationState"] = $val;
        return $this;
    }
    
    /**
    * Gets the easActivated
    * Whether the device is Exchange ActiveSync activated.
    *
    * @return bool The easActivated
    */
    public function getEasActivated()
    {
        if (array_key_exists("easActivated", $this->_propDict)) {
            return $this->_propDict["easActivated"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the easActivated
    * Whether the device is Exchange ActiveSync activated.
    *
    * @param bool $val The easActivated
    *
    * @return ManagedDevice
    */
    public function setEasActivated($val)
    {
        $this->_propDict["easActivated"] = boolval($val);
        return $this;
    }
    
    /**
    * Gets the easActivationDateTime
    * Exchange ActivationSync activation time of the device.
    *
    * @return \DateTime The easActivationDateTime
    */
    public function getEasActivationDateTime()
    {
        if (array_key_exists("easActivationDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["easActivationDateTime"], "\DateTime")) {
                return $this->_propDict["easActivationDateTime"];
            } else {
                $this->_propDict["easActivationDateTime"] = new \DateTime($this->_propDict["easActivationDateTime"]);
                return $this->_propDict["easActivationDateTime"];
            }
        }
        return null;
    }
    
    /**
    * Sets the easActivationDateTime
    * Exchange ActivationSync activation time of the device.
    *
    * @param \DateTime $val The easActivationDateTime
    *
    * @return ManagedDevice
    */
    public function setEasActivationDateTime($val)
    {
        $this->_propDict["easActivationDateTime"] = $val;
        return $this;
    }
    
    /**
    * Gets the easDeviceId
    * Exchange ActiveSync Id of the device.
    *
    * @return string The easDeviceId
    */
    public function getEasDeviceId()
    {
        if (array_key_exists("easDeviceId", $this->_propDict)) {
            return $this->_propDict["easDeviceId"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the easDeviceId
    * Exchange ActiveSync Id of the device.
    *
    * @param string $val The easDeviceId
    *
    * @return ManagedDevice
    */
    public function setEasDeviceId($val)
    {
        $this->_propDict["easDeviceId"] = $val;
        return $this;
    }
    
    /**
    * Gets the emailAddress
    * Email(s) for the user associated with the device
    *
    * @return string The emailAddress
    */
    public function getEmailAddress()
    {
        if (array_key_exists("emailAddress", $this->_propDict)) {
            return $this->_propDict["emailAddress"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the emailAddress
    * Email(s) for the user associated with the device
    *
    * @param string $val The emailAddress
    *
    * @return ManagedDevice
    */
    public function setEmailAddress($val)
    {
        $this->_propDict["emailAddress"] = $val;
        return $this;
    }
    
    /**
    * Gets the enrolledDateTime
    * Enrollment time of the device.
    *
    * @return \DateTime The enrolledDateTime
    */
    public function getEnrolledDateTime()
    {
        if (array_key_exists("enrolledDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["enrolledDateTime"], "\DateTime")) {
                return $this->_propDict["enrolledDateTime"];
            } else {
                $this->_propDict["enrolledDateTime"] = new \DateTime($this->_propDict["enrolledDateTime"]);
                return $this->_propDict["enrolledDateTime"];
            }
        }
        return null;
    }
    
    /**
    * Sets the enrolledDateTime
    * Enrollment time of the device.
    *
    * @param \DateTime $val The enrolledDateTime
    *
    * @return ManagedDevice
    */
    public function setEnrolledDateTime($val)
    {
        $this->_propDict["enrolledDateTime"] = $val;
        return $this;
    }
    
    /**
    * Gets the exchangeAccessState
    * The Access State of the device in Exchange. Possible values are: none, unknown, allowed, blocked, quarantined.
    *
    * @return DeviceManagementExchangeAccessState The exchangeAccessState
    */
    public function getExchangeAccessState()
    {
        if (array_key_exists("exchangeAccessState", $this->_propDict)) {
            if (is_a($this->_propDict["exchangeAccessState"], "Microsoft\Graph\Model\DeviceManagementExchangeAccessState")) {
                return $this->_propDict["exchangeAccessState"];
            } else {
                $this->_propDict["exchangeAccessState"] = new DeviceManagementExchangeAccessState($this->_propDict["exchangeAccessState"]);
                return $this->_propDict["exchangeAccessState"];
            }
        }
        return null;
    }
    
    /**
    * Sets the exchangeAccessState
    * The Access State of the device in Exchange. Possible values are: none, unknown, allowed, blocked, quarantined.
    *
    * @param DeviceManagementExchangeAccessState $val The exchangeAccessState
    *
    * @return ManagedDevice
    */
    public function setExchangeAccessState($val)
    {
        $this->_propDict["exchangeAccessState"] = $val;
        return $this;
    }
    
    /**
    * Gets the exchangeAccessStateReason
    * The reason for the device's access state in Exchange. Possible values are: none, unknown, exchangeGlobalRule, exchangeIndividualRule, exchangeDeviceRule, exchangeUpgrade, exchangeMailboxPolicy, other, compliant, notCompliant, notEnrolled, unknownLocation, mfaRequired, azureADBlockDueToAccessPolicy, compromisedPassword, deviceNotKnownWithManagedApp.
    *
    * @return DeviceManagementExchangeAccessStateReason The exchangeAccessStateReason
    */
    public function getExchangeAccessStateReason()
    {
        if (array_key_exists("exchangeAccessStateReason", $this->_propDict)) {
            if (is_a($this->_propDict["exchangeAccessStateReason"], "Microsoft\Graph\Model\DeviceManagementExchangeAccessStateReason")) {
                return $this->_propDict["exchangeAccessStateReason"];
            } else {
                $this->_propDict["exchangeAccessStateReason"] = new DeviceManagementExchangeAccessStateReason($this->_propDict["exchangeAccessStateReason"]);
                return $this->_propDict["exchangeAccessStateReason"];
            }
        }
        return null;
    }
    
    /**
    * Sets the exchangeAccessStateReason
    * The reason for the device's access state in Exchange. Possible values are: none, unknown, exchangeGlobalRule, exchangeIndividualRule, exchangeDeviceRule, exchangeUpgrade, exchangeMailboxPolicy, other, compliant, notCompliant, notEnrolled, unknownLocation, mfaRequired, azureADBlockDueToAccessPolicy, compromisedPassword, deviceNotKnownWithManagedApp.
    *
    * @param DeviceManagementExchangeAccessStateReason $val The exchangeAccessStateReason
    *
    * @return ManagedDevice
    */
    public function setExchangeAccessStateReason($val)
    {
        $this->_propDict["exchangeAccessStateReason"] = $val;
        return $this;
    }
    
    /**
    * Gets the exchangeLastSuccessfulSyncDateTime
    * Last time the device contacted Exchange.
    *
    * @return \DateTime The exchangeLastSuccessfulSyncDateTime
    */
    public function getExchangeLastSuccessfulSyncDateTime()
    {
        if (array_key_exists("exchangeLastSuccessfulSyncDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["exchangeLastSuccessfulSyncDateTime"], "\DateTime")) {
                return $this->_propDict["exchangeLastSuccessfulSyncDateTime"];
            } else {
                $this->_propDict["exchangeLastSuccessfulSyncDateTime"] = new \DateTime($this->_propDict["exchangeLastSuccessfulSyncDateTime"]);
                return $this->_propDict["exchangeLastSuccessfulSyncDateTime"];
            }
        }
        return null;
    }
    
    /**
    * Sets the exchangeLastSuccessfulSyncDateTime
    * Last time the device contacted Exchange.
    *
    * @param \DateTime $val The exchangeLastSuccessfulSyncDateTime
    *
    * @return ManagedDevice
    */
    public function setExchangeLastSuccessfulSyncDateTime($val)
    {
        $this->_propDict["exchangeLastSuccessfulSyncDateTime"] = $val;
        return $this;
    }
    
    /**
    * Gets the freeStorageSpaceInBytes
    * Free Storage in Bytes
    *
    * @return int The freeStorageSpaceInBytes
    */
    public function getFreeStorageSpaceInBytes()
    {
        if (array_key_exists("freeStorageSpaceInBytes", $this->_propDict)) {
            return $this->_propDict["freeStorageSpaceInBytes"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the freeStorageSpaceInBytes
    * Free Storage in Bytes
    *
    * @param int $val The freeStorageSpaceInBytes
    *
    * @return ManagedDevice
    */
    public function setFreeStorageSpaceInBytes($val)
    {
        $this->_propDict["freeStorageSpaceInBytes"] = intval($val);
        return $this;
    }
    
    /**
    * Gets the imei
    * IMEI
    *
    * @return string The imei
    */
    public function getImei()
    {
        if (array_key_exists("imei", $this->_propDict)) {
            return $this->_propDict["imei"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the imei
    * IMEI
    *
    * @param string $val The imei
    *
    * @return ManagedDevice
    */
    public function setImei($val)
    {
        $this->_propDict["imei"] = $val;
        return $this;
    }
    
    /**
    * Gets the isEncrypted
    * Device encryption status
    *
    * @return bool The isEncrypted
    */
    public function getIsEncrypted()
    {
        if (array_key_exists("isEncrypted", $this->_propDict)) {
            return $this->_propDict["isEncrypted"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the isEncrypted
    * Device encryption status
    *
    * @param bool $val The isEncrypted
    *
    * @return ManagedDevice
    */
    public function setIsEncrypted($val)
    {
        $this->_propDict["isEncrypted"] = boolval($val);
        return $this;
    }
    
    /**
    * Gets the isSupervised
    * Device supervised status
    *
    * @return bool The isSupervised
    */
    public function getIsSupervised()
    {
        if (array_key_exists("isSupervised", $this->_propDict)) {
            return $this->_propDict["isSupervised"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the isSupervised
    * Device supervised status
    *
    * @param bool $val The isSupervised
    *
    * @return ManagedDevice
    */
    public function setIsSupervised($val)
    {
        $this->_propDict["isSupervised"] = boolval($val);
        return $this;
    }
    
    /**
    * Gets the jailBroken
    * whether the device is jail broken or rooted.
    *
    * @return string The jailBroken
    */
    public function getJailBroken()
    {
        if (array_key_exists("jailBroken", $this->_propDict)) {
            return $this->_propDict["jailBroken"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the jailBroken
    * whether the device is jail broken or rooted.
    *
    * @param string $val The jailBroken
    *
    * @return ManagedDevice
    */
    public function setJailBroken($val)
    {
        $this->_propDict["jailBroken"] = $val;
        return $this;
    }
    
    /**
    * Gets the lastSyncDateTime
    * The date and time that the device last completed a successful sync with Intune.
    *
    * @return \DateTime The lastSyncDateTime
    */
    public function getLastSyncDateTime()
    {
        if (array_key_exists("lastSyncDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastSyncDateTime"], "\DateTime")) {
                return $this->_propDict["lastSyncDateTime"];
            } else {
                $this->_propDict["lastSyncDateTime"] = new \DateTime($this->_propDict["lastSyncDateTime"]);
                return $this->_propDict["lastSyncDateTime"];
            }
        }
        return null;
    }
    
    /**
    * Sets the lastSyncDateTime
    * The date and time that the device last completed a successful sync with Intune.
    *
    * @param \DateTime $val The lastSyncDateTime
    *
    * @return ManagedDevice
    */
    public function setLastSyncDateTime($val)
    {
        $this->_propDict["lastSyncDateTime"] = $val;
        return $this;
    }
    
    /**
    * Gets the managedDeviceName
    * Automatically generated name to identify a device. Can be overwritten to a user friendly name.
    *
    * @return string The managedDeviceName
    */
    public function getManagedDeviceName()
    {
        if (array_key_exists("managedDeviceName", $this->_propDict)) {
            return $this->_propDict["managedDeviceName"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the managedDeviceName
    * Automatically generated name to identify a device. Can be overwritten to a user friendly name.
    *
    * @param string $val The managedDeviceName
    *
    * @return ManagedDevice
    */
    public function setManagedDeviceName($val)
    {
        $this->_propDict["managedDeviceName"] = $val;
        return $this;
    }
    
    /**
    * Gets the managedDeviceOwnerType
    * Ownership of the device. Can be 'company' or 'personal'. Possible values are: unknown, company, personal.
    *
    * @return ManagedDeviceOwnerType The managedDeviceOwnerType
    */
    public function getManagedDeviceOwnerType()
    {
        if (array_key_exists("managedDeviceOwnerType", $this->_propDict)) {
            if (is_a($this->_propDict["managedDeviceOwnerType"], "Microsoft\Graph\Model\ManagedDeviceOwnerType")) {
                return $this->_propDict["managedDeviceOwnerType"];
            } else {
                $this->_propDict["managedDeviceOwnerType"] = new ManagedDeviceOwnerType($this->_propDict["managedDeviceOwnerType"]);
                return $this->_propDict["managedDeviceOwnerType"];
            }
        }
        return null;
    }
    
    /**
    * Sets the managedDeviceOwnerType
    * Ownership of the device. Can be 'company' or 'personal'. Possible values are: unknown, company, personal.
    *
    * @param ManagedDeviceOwnerType $val The managedDeviceOwnerType
    *
    * @return ManagedDevice
    */
    public function setManagedDeviceOwnerType($val)
    {
        $this->_propDict["managedDeviceOwnerType"] = $val;
        return $this;
    }
    
    /**
    * Gets the managementAgent
    * Management channel of the device. Intune, EAS, etc. Possible values are: eas, mdm, easMdm, intuneClient, easIntuneClient, configurationManagerClient, configurationManagerClientMdm, configurationManagerClientMdmEas, unknown, jamf, googleCloudDevicePolicyController.
    *
    * @return ManagementAgentType The managementAgent
    */
    public function getManagementAgent()
    {
        if (array_key_exists("managementAgent", $this->_propDict)) {
            if (is_a($this->_propDict["managementAgent"], "Microsoft\Graph\Model\ManagementAgentType")) {
                return $this->_propDict["managementAgent"];
            } else {
                $this->_propDict["managementAgent"] = new ManagementAgentType($this->_propDict["managementAgent"]);
                return $this->_propDict["managementAgent"];
            }
        }
        return null;
    }
    
    /**
    * Sets the managementAgent
    * Management channel of the device. Intune, EAS, etc. Possible values are: eas, mdm, easMdm, intuneClient, easIntuneClient, configurationManagerClient, configurationManagerClientMdm, configurationManagerClientMdmEas, unknown, jamf, googleCloudDevicePolicyController.
    *
    * @param ManagementAgentType $val The managementAgent
    *
    * @return ManagedDevice
    */
    public function setManagementAgent($val)
    {
        $this->_propDict["managementAgent"] = $val;
        return $this;
    }
    
    /**
    * Gets the manufacturer
    * Manufacturer of the device
    *
    * @return string The manufacturer
    */
    public function getManufacturer()
    {
        if (array_key_exists("manufacturer", $this->_propDict)) {
            return $this->_propDict["manufacturer"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the manufacturer
    * Manufacturer of the device
    *
    * @param string $val The manufacturer
    *
    * @return ManagedDevice
    */
    public function setManufacturer($val)
    {
        $this->_propDict["manufacturer"] = $val;
        return $this;
    }
    
    /**
    * Gets the meid
    * MEID
    *
    * @return string The meid
    */
    public function getMeid()
    {
        if (array_key_exists("meid", $this->_propDict)) {
            return $this->_propDict["meid"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the meid
    * MEID
    *
    * @param string $val The meid
    *
    * @return ManagedDevice
    */
    public function setMeid($val)
    {
        $this->_propDict["meid"] = $val;
        return $this;
    }
    
    /**
    * Gets the model
    * Model of the device
    *
    * @return string The model
    */
    public function getModel()
    {
        if (array_key_exists("model", $this->_propDict)) {
            return $this->_propDict["model"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the model
    * Model of the device
    *
    * @param string $val The model
    *
    * @return ManagedDevice
    */
    public function setModel($val)
    {
        $this->_propDict["model"] = $val;
        return $this;
    }
    
    /**
    * Gets the operatingSystem
    * Operating system of the device. Windows, iOS, etc.
    *
    * @return string The operatingSystem
    */
    public function getOperatingSystem()
    {
        if (array_key_exists("operatingSystem", $this->_propDict)) {
            return $this->_propDict["operatingSystem"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the operatingSystem
    * Operating system of the device. Windows, iOS, etc.
    *
    * @param string $val The operatingSystem
    *
    * @return ManagedDevice
    */
    public function setOperatingSystem($val)
    {
        $this->_propDict["operatingSystem"] = $val;
        return $this;
    }
    
    /**
    * Gets the osVersion
    * Operating system version of the device.
    *
    * @return string The osVersion
    */
    public function getOsVersion()
    {
        if (array_key_exists("osVersion", $this->_propDict)) {
            return $this->_propDict["osVersion"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the osVersion
    * Operating system version of the device.
    *
    * @param string $val The osVersion
    *
    * @return ManagedDevice
    */
    public function setOsVersion($val)
    {
        $this->_propDict["osVersion"] = $val;
        return $this;
    }
    
    /**
    * Gets the partnerReportedThreatState
    * Indicates the threat state of a device when a Mobile Threat Defense partner is in use by the account and device. Read Only. Possible values are: unknown, activated, deactivated, secured, lowSeverity, mediumSeverity, highSeverity, unresponsive, compromised, misconfigured.
    *
    * @return ManagedDevicePartnerReportedHealthState The partnerReportedThreatState
    */
    public function getPartnerReportedThreatState()
    {
        if (array_key_exists("partnerReportedThreatState", $this->_propDict)) {
            if (is_a($this->_propDict["partnerReportedThreatState"], "Microsoft\Graph\Model\ManagedDevicePartnerReportedHealthState")) {
                return $this->_propDict["partnerReportedThreatState"];
            } else {
                $this->_propDict["partnerReportedThreatState"] = new ManagedDevicePartnerReportedHealthState($this->_propDict["partnerReportedThreatState"]);
                return $this->_propDict["partnerReportedThreatState"];
            }
        }
        return null;
    }
    
    /**
    * Sets the partnerReportedThreatState
    * Indicates the threat state of a device when a Mobile Threat Defense partner is in use by the account and device. Read Only. Possible values are: unknown, activated, deactivated, secured, lowSeverity, mediumSeverity, highSeverity, unresponsive, compromised, misconfigured.
    *
    * @param ManagedDevicePartnerReportedHealthState $val The partnerReportedThreatState
    *
    * @return ManagedDevice
    */
    public function setPartnerReportedThreatState($val)
    {
        $this->_propDict["partnerReportedThreatState"] = $val;
        return $this;
    }
    
    /**
    * Gets the phoneNumber
    * Phone number of the device
    *
    * @return string The phoneNumber
    */
    public function getPhoneNumber()
    {
        if (array_key_exists("phoneNumber", $this->_propDict)) {
            return $this->_propDict["phoneNumber"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the phoneNumber
    * Phone number of the device
    *
    * @param string $val The phoneNumber
    *
    * @return ManagedDevice
    */
    public function setPhoneNumber($val)
    {
        $this->_propDict["phoneNumber"] = $val;
        return $this;
    }
    
    /**
    * Gets the remoteAssistanceSessionErrorDetails
    * An error string that identifies issues when creating Remote Assistance session objects.
    *
    * @return string The remoteAssistanceSessionErrorDetails
    */
    public function getRemoteAssistanceSessionErrorDetails()
    {
        if (array_key_exists("remoteAssistanceSessionErrorDetails", $this->_propDict)) {
            return $this->_propDict["remoteAssistanceSessionErrorDetails"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the remoteAssistanceSessionErrorDetails
    * An error string that identifies issues when creating Remote Assistance session objects.
    *
    * @param string $val The remoteAssistanceSessionErrorDetails
    *
    * @return ManagedDevice
    */
    public function setRemoteAssistanceSessionErrorDetails($val)
    {
        $this->_propDict["remoteAssistanceSessionErrorDetails"] = $val;
        return $this;
    }
    
    /**
    * Gets the remoteAssistanceSessionUrl
    * Url that allows a Remote Assistance session to be established with the device.
    *
    * @return string The remoteAssistanceSessionUrl
    */
    public function getRemoteAssistanceSessionUrl()
    {
        if (array_key_exists("remoteAssistanceSessionUrl", $this->_propDict)) {
            return $this->_propDict["remoteAssistanceSessionUrl"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the remoteAssistanceSessionUrl
    * Url that allows a Remote Assistance session to be established with the device.
    *
    * @param string $val The remoteAssistanceSessionUrl
    *
    * @return ManagedDevice
    */
    public function setRemoteAssistanceSessionUrl($val)
    {
        $this->_propDict["remoteAssistanceSessionUrl"] = $val;
        return $this;
    }
    
    /**
    * Gets the serialNumber
    * SerialNumber
    *
    * @return string The serialNumber
    */
    public function getSerialNumber()
    {
        if (array_key_exists("serialNumber", $this->_propDict)) {
            return $this->_propDict["serialNumber"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the serialNumber
    * SerialNumber
    *
    * @param string $val The serialNumber
    *
    * @return ManagedDevice
    */
    public function setSerialNumber($val)
    {
        $this->_propDict["serialNumber"] = $val;
        return $this;
    }
    
    /**
    * Gets the subscriberCarrier
    * Subscriber Carrier
    *
    * @return string The subscriberCarrier
    */
    public function getSubscriberCarrier()
    {
        if (array_key_exists("subscriberCarrier", $this->_propDict)) {
            return $this->_propDict["subscriberCarrier"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the subscriberCarrier
    * Subscriber Carrier
    *
    * @param string $val The subscriberCarrier
    *
    * @return ManagedDevice
    */
    public function setSubscriberCarrier($val)
    {
        $this->_propDict["subscriberCarrier"] = $val;
        return $this;
    }
    
    /**
    * Gets the totalStorageSpaceInBytes
    * Total Storage in Bytes
    *
    * @return int The totalStorageSpaceInBytes
    */
    public function getTotalStorageSpaceInBytes()
    {
        if (array_key_exists("totalStorageSpaceInBytes", $this->_propDict)) {
            return $this->_propDict["totalStorageSpaceInBytes"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the totalStorageSpaceInBytes
    * Total Storage in Bytes
    *
    * @param int $val The totalStorageSpaceInBytes
    *
    * @return ManagedDevice
    */
    public function setTotalStorageSpaceInBytes($val)
    {
        $this->_propDict["totalStorageSpaceInBytes"] = intval($val);
        return $this;
    }
    
    /**
    * Gets the userDisplayName
    * User display name
    *
    * @return string The userDisplayName
    */
    public function getUserDisplayName()
    {
        if (array_key_exists("userDisplayName", $this->_propDict)) {
            return $this->_propDict["userDisplayName"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the userDisplayName
    * User display name
    *
    * @param string $val The userDisplayName
    *
    * @return ManagedDevice
    */
    public function setUserDisplayName($val)
    {
        $this->_propDict["userDisplayName"] = $val;
        return $this;
    }
    
    /**
    * Gets the userId
    * Unique Identifier for the user associated with the device
    *
    * @return string The userId
    */
    public function getUserId()
    {
        if (array_key_exists("userId", $this->_propDict)) {
            return $this->_propDict["userId"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the userId
    * Unique Identifier for the user associated with the device
    *
    * @param string $val The userId
    *
    * @return ManagedDevice
    */
    public function setUserId($val)
    {
        $this->_propDict["userId"] = $val;
        return $this;
    }
    
    /**
    * Gets the userPrincipalName
    * Device user principal name
    *
    * @return string The userPrincipalName
    */
    public function getUserPrincipalName()
    {
        if (array_key_exists("userPrincipalName", $this->_propDict)) {
            return $this->_propDict["userPrincipalName"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the userPrincipalName
    * Device user principal name
    *
    * @param string $val The userPrincipalName
    *
    * @return ManagedDevice
    */
    public function setUserPrincipalName($val)
    {
        $this->_propDict["userPrincipalName"] = $val;
        return $this;
    }
    
    /**
    * Gets the wiFiMacAddress
    * Wi-Fi MAC
    *
    * @return string The wiFiMacAddress
    */
    public function getWiFiMacAddress()
    {
        if (array_key_exists("wiFiMacAddress", $this->_propDict)) {
            return $this->_propDict["wiFiMacAddress"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the wiFiMacAddress
    * Wi-Fi MAC
    *
    * @param string $val The wiFiMacAddress
    *
    * @return ManagedDevice
    */
    public function setWiFiMacAddress($val)
    {
        $this->_propDict["wiFiMacAddress"] = $val;
        return $this;
    }
    

     /** 
     * Gets the deviceCompliancePolicyStates
    * Device compliance policy states for this device.
     *
     * @return array The deviceCompliancePolicyStates
     */
    public function getDeviceCompliancePolicyStates()
    {
        if (array_key_exists("deviceCompliancePolicyStates", $this->_propDict)) {
           return $this->_propDict["deviceCompliancePolicyStates"];
        } else {
            return null;
        }
    }
    
    /** 
    * Sets the deviceCompliancePolicyStates
    * Device compliance policy states for this device.
    *
    * @param DeviceCompliancePolicyState $val The deviceCompliancePolicyStates
    *
    * @return ManagedDevice
    */
    public function setDeviceCompliancePolicyStates($val)
    {
		$this->_propDict["deviceCompliancePolicyStates"] = $val;
        return $this;
    }
    

     /** 
     * Gets the deviceConfigurationStates
    * Device configuration states for this device.
     *
     * @return array The deviceConfigurationStates
     */
    public function getDeviceConfigurationStates()
    {
        if (array_key_exists("deviceConfigurationStates", $this->_propDict)) {
           return $this->_propDict["deviceConfigurationStates"];
        } else {
            return null;
        }
    }
    
    /** 
    * Sets the deviceConfigurationStates
    * Device configuration states for this device.
    *
    * @param DeviceConfigurationState $val The deviceConfigurationStates
    *
    * @return ManagedDevice
    */
    public function setDeviceConfigurationStates($val)
    {
		$this->_propDict["deviceConfigurationStates"] = $val;
        return $this;
    }
    
    /**
    * Gets the deviceCategory
    * Device category
    *
    * @return DeviceCategory The deviceCategory
    */
    public function getDeviceCategory()
    {
        if (array_key_exists("deviceCategory", $this->_propDict)) {
            if (is_a($this->_propDict["deviceCategory"], "Microsoft\Graph\Model\DeviceCategory")) {
                return $this->_propDict["deviceCategory"];
            } else {
                $this->_propDict["deviceCategory"] = new DeviceCategory($this->_propDict["deviceCategory"]);
                return $this->_propDict["deviceCategory"];
            }
        }
        return null;
    }
    
    /**
    * Sets the deviceCategory
    * Device category
    *
    * @param DeviceCategory $val The deviceCategory
    *
    * @return ManagedDevice
    */
    public function setDeviceCategory($val)
    {
        $this->_propDict["deviceCategory"] = $val;
        return $this;
    }
    
}