<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsMalwareInformation File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright © Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

/**
* WindowsMalwareInformation class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright © Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsMalwareInformation extends Entity
{
    /**
    * Gets the additionalInformationUrl
    * Information URL to learn more about the malware
    *
    * @return string The additionalInformationUrl
    */
    public function getAdditionalInformationUrl()
    {
        if (array_key_exists("additionalInformationUrl", $this->_propDict)) {
            return $this->_propDict["additionalInformationUrl"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the additionalInformationUrl
    * Information URL to learn more about the malware
    *
    * @param string $val The additionalInformationUrl
    *
    * @return WindowsMalwareInformation
    */
    public function setAdditionalInformationUrl($val)
    {
        $this->_propDict["additionalInformationUrl"] = $val;
        return $this;
    }
    
    /**
    * Gets the category
    * Category of the malware
    *
    * @return WindowsMalwareCategory The category
    */
    public function getCategory()
    {
        if (array_key_exists("category", $this->_propDict)) {
            if (is_a($this->_propDict["category"], "Beta\Microsoft\Graph\Model\WindowsMalwareCategory")) {
                return $this->_propDict["category"];
            } else {
                $this->_propDict["category"] = new WindowsMalwareCategory($this->_propDict["category"]);
                return $this->_propDict["category"];
            }
        }
        return null;
    }
    
    /**
    * Sets the category
    * Category of the malware
    *
    * @param WindowsMalwareCategory $val The category
    *
    * @return WindowsMalwareInformation
    */
    public function setCategory($val)
    {
        $this->_propDict["category"] = $val;
        return $this;
    }
    
    /**
    * Gets the displayName
    * Malware name
    *
    * @return string The displayName
    */
    public function getDisplayName()
    {
        if (array_key_exists("displayName", $this->_propDict)) {
            return $this->_propDict["displayName"];
        } else {
            return null;
        }
    }
    
    /**
    * Sets the displayName
    * Malware name
    *
    * @param string $val The displayName
    *
    * @return WindowsMalwareInformation
    */
    public function setDisplayName($val)
    {
        $this->_propDict["displayName"] = $val;
        return $this;
    }
    
    /**
    * Gets the lastDetectionDateTime
    * The last time the malware is detected
    *
    * @return \DateTime The lastDetectionDateTime
    */
    public function getLastDetectionDateTime()
    {
        if (array_key_exists("lastDetectionDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastDetectionDateTime"], "\DateTime")) {
                return $this->_propDict["lastDetectionDateTime"];
            } else {
                $this->_propDict["lastDetectionDateTime"] = new \DateTime($this->_propDict["lastDetectionDateTime"]);
                return $this->_propDict["lastDetectionDateTime"];
            }
        }
        return null;
    }
    
    /**
    * Sets the lastDetectionDateTime
    * The last time the malware is detected
    *
    * @param \DateTime $val The lastDetectionDateTime
    *
    * @return WindowsMalwareInformation
    */
    public function setLastDetectionDateTime($val)
    {
        $this->_propDict["lastDetectionDateTime"] = $val;
        return $this;
    }
    
    /**
    * Gets the severity
    * Severity of the malware
    *
    * @return WindowsMalwareSeverity The severity
    */
    public function getSeverity()
    {
        if (array_key_exists("severity", $this->_propDict)) {
            if (is_a($this->_propDict["severity"], "Beta\Microsoft\Graph\Model\WindowsMalwareSeverity")) {
                return $this->_propDict["severity"];
            } else {
                $this->_propDict["severity"] = new WindowsMalwareSeverity($this->_propDict["severity"]);
                return $this->_propDict["severity"];
            }
        }
        return null;
    }
    
    /**
    * Sets the severity
    * Severity of the malware
    *
    * @param WindowsMalwareSeverity $val The severity
    *
    * @return WindowsMalwareInformation
    */
    public function setSeverity($val)
    {
        $this->_propDict["severity"] = $val;
        return $this;
    }
    

     /** 
     * Gets the deviceMalwareStates
    * List of devices affected by current malware with the malware state on each device 
     *
     * @return array The deviceMalwareStates
     */
    public function getDeviceMalwareStates()
    {
        if (array_key_exists("deviceMalwareStates", $this->_propDict)) {
           return $this->_propDict["deviceMalwareStates"];
        } else {
            return null;
        }
    }
    
    /** 
    * Sets the deviceMalwareStates
    * List of devices affected by current malware with the malware state on each device 
    *
    * @param MalwareStateForWindowsDevice $val The deviceMalwareStates
    *
    * @return WindowsMalwareInformation
    */
    public function setDeviceMalwareStates($val)
    {
		$this->_propDict["deviceMalwareStates"] = $val;
        return $this;
    }
    
}