

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `oscmax254`
--

-- --------------------------------------------------------

--
-- Table structure for table `address_book`
--

CREATE TABLE `address_book` (
  `address_book_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `entry_gender` char(1) NOT NULL,
  `entry_company` varchar(32) DEFAULT NULL,
  `entry_company_tax_id` varchar(32) DEFAULT NULL,
  `entry_firstname` varchar(32) NOT NULL,
  `entry_lastname` varchar(32) NOT NULL,
  `entry_street_address` varchar(64) NOT NULL,
  `entry_suburb` varchar(32) DEFAULT NULL,
  `entry_postcode` varchar(10) NOT NULL,
  `entry_city` varchar(32) NOT NULL,
  `entry_state` varchar(32) DEFAULT NULL,
  `entry_country_id` int(11) NOT NULL DEFAULT '0',
  `entry_zone_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`address_book_id`),
  KEY `idx_address_book_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `address_format`
--

CREATE TABLE `address_format` (
  `address_format_id` int(11) NOT NULL AUTO_INCREMENT,
  `address_format` varchar(128) NOT NULL,
  `address_summary` varchar(48) NOT NULL,
  PRIMARY KEY (`address_format_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `address_format`
--

INSERT INTO `address_format` VALUES
(1, '$firstname $lastname$cr$streets$cr$city,$postcode$cr$statecomma$country', '$city / $country'),
(2, '$firstname $lastname$cr$streets$cr$city,$state    $postcode$cr$country', '$city,$state / $country'),
(3, '$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country', '$state / $country'),
(4, '$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country', '$postcode / $country'),
(5, '$firstname $lastname$cr$streets$cr$postcode $city$cr$country', '$city / $country'),
(6, '$firstname $lastname$cr$streets$cr$city$cr$state$cr$postcode$cr$country', '$city / $country');

-- --------------------------------------------------------

--
-- Table structure for table `admin`
--

CREATE TABLE `admin` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_groups_id` int(11) DEFAULT NULL,
  `admin_username` varchar(32) NOT NULL,
  `admin_firstname` varchar(32) NOT NULL,
  `admin_lastname` varchar(32) DEFAULT NULL,
  `admin_email_address` varchar(96) NOT NULL,
  `admin_password` varchar(40) NOT NULL,
  `admin_created` datetime DEFAULT NULL,
  `admin_modified` datetime NOT NULL,
  `admin_logdate` datetime DEFAULT NULL,
  `admin_lognum` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`admin_id`),
  UNIQUE KEY `admin_username` (`admin_username`),
  UNIQUE KEY `admin_email_address` (`admin_email_address`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `admin`
--

INSERT INTO `admin` VALUES
(1, 1, '[[admin_username]]', '[[admin_fname]]', '[[admin_lname]]', '[[admin_email]]', '[[admin_pass]]', '[[regtime]]', '0000-00-00 00:00:00', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `admin_files`
--

CREATE TABLE `admin_files` (
  `admin_files_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_files_name` varchar(64) NOT NULL,
  `admin_display_name` varchar(64) NOT NULL,
  `admin_files_is_boxes` tinyint(5) NOT NULL DEFAULT '0',
  `admin_files_to_boxes` int(11) NOT NULL DEFAULT '0',
  `admin_groups_id` set('1','2') NOT NULL DEFAULT '1',
  `admin_sort_order` int(3) NOT NULL,
  PRIMARY KEY (`admin_files_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=224 ;

--
-- Dumping data for table `admin_files`
--

INSERT INTO `admin_files` VALUES
(1, 'administrator.php', 'BOX_HEADING_ADMINISTRATOR', 1, 0, '1', 1),
(2, 'configuration.php', 'BOX_HEADING_CONFIGURATION', 1, 0, '1', 2),
(3, 'catalog.php', 'BOX_HEADING_CATALOG', 1, 0, '1,2', 3),
(4, 'modules.php', 'BOX_HEADING_MODULES', 1, 0, '1', 4),
(5, 'customers.php', 'BOX_HEADING_CUSTOMERS', 1, 0, '1,2', 5),
(6, 'taxes.php', 'BOX_HEADING_LOCATION_AND_TAXES', 1, 0, '1', 6),
(7, 'localization.php', 'BOX_HEADING_LOCALIZATION', 1, 0, '1,2', 7),
(8, 'reports.php', 'BOX_HEADING_REPORTS', 1, 0, '1,2', 8),
(9, 'tools.php', 'BOX_HEADING_TOOLS', 1, 0, '1,2', 9),
(10, 'admin_members.php', 'BOX_ADMINISTRATOR_MEMBERS', 0, 1, '1', 1),
(11, 'admin_files.php', 'BOX_ADMINISTRATOR_BOXES', 0, 1, '1', 3),
(13, 'categories.php', 'BOX_CATALOG_CATEGORIES_PRODUCTS', 0, 3, '1,2', 1),
(14, 'products_attributes.php', 'BOX_CATALOG_CATEGORIES_PRODUCTS_ATTRIBUTES', 0, 3, '1,2', 2),
(15, 'manufacturers.php', 'BOX_CATALOG_MANUFACTURERS', 0, 3, '1,2', 4),
(16, 'reviews.php', 'BOX_CATALOG_REVIEWS', 0, 3, '1,2', 5),
(17, 'specials.php', 'BOX_CATALOG_SPECIALS', 0, 3, '1,2', 6),
(18, 'products_expected.php', 'BOX_CATALOG_PRODUCTS_EXPECTED', 0, 3, '1,2', 12),
(20, 'customers.php', 'BOX_CUSTOMERS_CUSTOMERS', 0, 5, '1,2', 1),
(21, 'orders.php', 'BOX_CUSTOMERS_ORDERS', 0, 5, '1,2', 6),
(22, 'countries.php', 'BOX_TAXES_COUNTRIES', 0, 6, '1', 1),
(23, 'zones.php', 'BOX_TAXES_ZONES', 0, 6, '1', 2),
(24, 'geo_zones.php', 'BOX_TAXES_GEO_ZONES', 0, 6, '1', 3),
(25, 'tax_classes.php', 'BOX_TAXES_TAX_CLASSES', 0, 6, '1', 4),
(26, 'tax_rates.php', 'BOX_TAXES_TAX_RATES', 0, 6, '1', 5),
(27, 'currencies.php', 'BOX_LOCALIZATION_CURRENCIES', 0, 7, '1,2', 1),
(28, 'languages.php', 'BOX_LOCALIZATION_LANGUAGES', 0, 7, '1', 2),
(29, 'orders_status.php', 'BOX_LOCALIZATION_ORDERS_STATUS', 0, 7, '1,2', 3),
(30, 'stats_products_viewed.php', 'BOX_REPORTS_PRODUCTS_VIEWED', 0, 8, '1,2', 1),
(31, 'stats_products_purchased.php', 'BOX_REPORTS_PRODUCTS_PURCHASED', 0, 8, '1,2', 2),
(32, 'stats_customers.php', 'BOX_REPORTS_ORDERS_TOTAL', 0, 8, '1,2', 3),
(33, 'backup.php', 'BOX_TOOLS_BACKUP', 0, 9, '1,2', 1),
(34, 'banner_manager.php', 'BOX_TOOLS_BANNER_MANAGER', 0, 9, '1,2', 3),
(35, 'cache.php', 'BOX_TOOLS_CACHE', 0, 1, '1', 9),
(38, 'mail.php', 'BOX_TOOLS_MAIL', 0, 9, '1,2', 5),
(39, 'newsletters.php', 'BOX_TOOLS_NEWSLETTER_MANAGER', 0, 9, '1,2', 6),
(40, 'server_info.php', 'BOX_TOOLS_SERVER_INFO', 0, 9, '1', 11),
(41, 'whos_online.php', 'BOX_TOOLS_WHOS_ONLINE', 0, 9, '1,2', 12),
(42, 'banner_statistics.php', 'FILE_BANNER_STATISTICS', 0, 9, '1,2', 99),
(43, 'affiliate.php', 'BOX_HEADING_AFFILIATES', 1, 0, '1,2', 10),
(44, 'affiliate_affiliates.php', 'BOX_AFFILIATE', 0, 43, '1,2', 2),
(45, 'affiliate_clicks.php', 'BOX_AFFILIATE_CLICKS', 0, 43, '1,2', 4),
(46, 'affiliate_banners.php', 'BOX_AFFILIATE_BANNERS', 0, 43, '1,2', 6),
(47, 'affiliate_contact.php', 'BOX_AFFILIATE_CONTACT', 0, 43, '1,2', 9),
(48, 'affiliate_invoice.php', 'FILE_AFFILIATE', 0, 43, '1,2', 99),
(49, 'affiliate_payment.php', 'BOX_AFFILIATE_PAYMENT', 0, 43, '1,2', 3),
(50, 'affiliate_popup_image.php', 'FILE_AFFILIATE', 0, 43, '1,2', 99),
(51, 'affiliate_sales.php', 'BOX_AFFILIATE_SALES', 0, 43, '1,2', 4),
(52, 'affiliate_statistics.php', 'FILE_AFFILIATE', 0, 43, '1,2', 99),
(53, 'affiliate_summary.php', 'BOX_AFFILIATE_SUMMARY', 0, 43, '1,2', 1),
(54, 'gv_admin.php', 'BOX_HEADING_VOUCHERS', 1, 0, '1,2', 11),
(55, 'coupon_admin.php', 'BOX_COUPON_ADMIN', 0, 54, '1,2', 1),
(56, 'gv_queue.php', 'BOX_GV_ADMIN_QUEUE', 0, 54, '1,2', 2),
(57, 'gv_mail.php', 'BOX_GV_ADMIN_MAIL', 0, 54, '1,2', 3),
(58, 'gv_sent.php', 'BOX_GV_ADMIN_SENT', 0, 54, '1,2', 4),
(62, 'coupon_restrict.php', 'FILE_COUPON_RESTRICT', 0, 54, '1,2', 99),
(65, 'easypopulate.php', 'BOX_CATALOG_EASYPOPULATE', 0, 3, '1,2', 9),
(70, 'edit_orders.php', 'FILE_ORDER', 0, 5, '1,2', 99),
(71, 'validproducts.php', 'FILE_VALID_PRODUCTS', 0, 54, '1,2', 99),
(72, 'validcategories.php', 'FILE_VALID_CATEGORIES', 0, 54, '1,2', 99),
(73, 'listcategories.php', 'FILE_LIST_CATEGORIES', 0, 54, '1,2', 99),
(74, 'listproducts.php', 'FILE_LIST_PRODUCTS', 0, 54, '1,2', 99),
(75, 'new_attributes.php', 'BOX_CATALOG_ATTRIBUTE_MANAGER', 0, 3, '1,2', 11),
(78, 'paypal_ipn.php', 'FILE_PAYPAL', 0, 5, '1,2', 99),
(80, 'paypal_ipn_order.php', 'FILE_PAYPAL', 0, 5, '1,2', 99),
(81, 'articles.php', 'BOX_HEADING_ARTICLES', 1, 0, '1,2', 12),
(82, 'article_reviews.php', 'BOX_ARTICLES_REVIEWS', 0, 81, '1,2', 3),
(83, 'articles.php', 'BOX_TOPICS_ARTICLES', 0, 81, '1,2', 2),
(85, 'articles_xsell.php', 'BOX_ARTICLES_XSELL', 0, 81, '1,2', 4),
(86, 'authors.php', 'BOX_ARTICLES_AUTHORS', 0, 81, '1,2', 1),
(87, 'recover_cart_sales.php', 'BOX_TOOLS_RECOVER_CART', 0, 9, '1,2', 2),
(88, 'stats_recover_cart_sales.php', 'BOX_REPORTS_RECOVER_CART_SALES', 0, 8, '1,2', 7),
(89, 'stats_monthly_sales.php', 'BOX_REPORTS_MONTHLY_SALES', 0, 8, '1,2', 6),
(90, 'batch_print.php', 'BOX_TOOLS_BATCH_CENTER', 0, 9, '1,2', 4),
(91, 'stock.php', 'FILE_STOCK', 0, 3, '1,2', 99),
(92, 'stats_low_stock_attrib.php', 'BOX_REPORTS_STATS_LOW_STOCK_ATTRIB', 0, 8, '1,2', 9),
(98, 'customers_groups.php', 'BOX_CUSTOMERS_GROUPS', 0, 5, '1,2', 2),
(102, 'xsell.php', 'BOX_CATALOG_XSELL_PRODUCTS', 0, 3, '1,2', 8),
(103, 'create_account.php', 'BOX_MANUAL_ORDER_CREATE_ACCOUNT', 0, 5, '1,2', 3),
(104, 'create_account_process.php', 'FILE_CREATE_ACCOUNT', 0, 5, '1,2', 99),
(105, 'create_account_success.php', 'FILE_CREATE_ACCOUNT', 0, 5, '1,2', 99),
(106, 'create_order.php', 'BOX_MANUAL_ORDER_CREATE_ORDER', 0, 5, '1,2', 5),
(107, 'create_order_process.php', 'FILE_ORDER', 0, 5, '1,2', 99),
(108, 'easypopulate_functions.php', 'FILE_EASYPOPULATE', 0, 3, '1,2', 99),
(109, 'new_attributes_change.php', 'FILE_ATTRIBUTE', 0, 3, '1,2', 99),
(110, 'new_attributes_config.php', 'FILE_NEW_ATTRIBUTES_CONFIG', 0, 3, '1,2', 99),
(111, 'new_attributes_functions.php', 'FILE_ATTRIBUTE', 0, 3, '1,2', 99),
(112, 'new_attributes_include.php', 'FILE_ATTRIBUTE', 0, 3, '1,2', 99),
(113, 'new_attributes_select.php', 'FILE_ATTRIBUTE', 0, 3, '1,2', 99),
(114, 'ship_fedex.php', 'FILE_FEDEX', 0, 8, '1,2', 99),
(115, 'fedex_popup.php', 'FILE_FEDEX', 0, 8, '1,2', 99),
(116, 'shipping_manifest.php', 'BOX_SHIPPING_MANIFEST', 0, 8, '1,2', 8),
(117, 'track_fedex.php', 'FILE_FEDEX', 0, 8, '1,2', 99),
(118, 'paypal_info.php', 'BOX_PAYPAL_INFO', 0, 1, '1', 15),
(119, 'affiliate_info.php', 'BOX_HEADING_AFFILIATES', 0, 1, '1', 11),
(124, 'affiliate_news.php', 'BOX_AFFILIATE_NEWS', 0, 43, '1,2', 7),
(125, 'affiliate_newsletters.php', 'BOX_AFFILIATE_NEWSLETTER_MANAGER', 0, 43, '1,2', 8),
(126, 'affiliate_validcats.php', 'FILE_AFFILIATE', 0, 43, '1,2', 99),
(127, 'affiliate_validproducts.php', 'FILE_AFFILIATE', 0, 43, '1,2', 99),
(128, 'edit_orders_add_product.php', 'FILE_ORDER', 0, 5, '1,2', 99),
(129, 'edit_orders_ajax.php', 'FILE_ORDER', 0, 5, '1,2', 99),
(130, 'attributeManager.php', 'FILE_ATTRIBUTE', 0, 3, '1,2', 99),
(131, 'phone_order.php', 'BOX_PHONE_ORDER', 0, 5, '1,2', 4),
(132, 'stats_admin_logging.php', 'BOX_REPORTS_ADMIN_LOGGING', 0, 8, '1,2', 11),
(133, 'stats_cust_logging.php', 'BOX_REPORTS_CUST_LOGGING', 0, 8, '1,2', 12),
(134, 'customer_export.php', 'BOX_CUSTOMERS_EXPORT', 0, 5, '1,2', 7),
(135, 'packaging.php', 'BOX_TOOLS_PACKAGING', 0, 9, '1,2', 7),
(136, 'ups_boxes_used.php', 'BOX_TOOLS_UPS_BOXES_USED', 0, 9, '1,2', 8),
(137, 'stats_credits.php', 'BOX_REPORTS_CREDITS', 0, 8, '1,2', 10),
(138, 'treeview.php', 'FILE_TREE_VIEW', 0, 54, '1,2', 99),
(139, 'qtprodoctor.php', 'BOX_TOOLS_QTPRODOCTOR', 0, 9, '1,2', 9),
(140, 'googlesitemap.php', 'BOX_CONFIGURATION_GOOGLE_SITEMAP', 0, 2, '1', 42),
(141, 'common_reports.php', 'FILE_COMMON_REPORTS', 0, 8, '1,2', 99),
(142, 'stats_http_error.php', 'BOX_REPORTS_HTTP_ERROR', 0, 8, '1,2', 13),
(143, 'stats_register_customer_no_purchase.php', 'BOX_REPORTS_STATS_REGISTER_CUSTOMER_NO_PURCHASE', 0, 8, '1,2', 4),
(144, 'quick_links.php', 'BOX_TOOLS_QUICK_LINKS', 0, 1, '1', 12),
(145, 'feedmachine.php', 'BOX_CATALOG_FEEDMACHINE', 0, 3, '1,2', 10),
(146, 'feedmachine_admin.php', 'FILE_FEEDMACHINE', 0, 3, '1,2', 99),
(147, 'feedmachine_auto.php', 'FILE_FEEDMACHINE', 0, 3, '1,2', 99),
(148, 'feedmachine_config.php', 'FILE_FEEDMACHINE', 0, 3, '1,2', 99),
(149, 'feedmachine_loader.php', 'FILE_FEEDMACHINE', 0, 3, '1,2', 99),
(150, 'feedmachine_loadingbay.php', 'FILE_FEEDMACHINE', 0, 3, '1,2', 99),
(151, 'discount_categories.php', 'BOX_CATALOG_CATEGORIES_DISCOUNT_CATEGORIES', 0, 3, '1,2', 3),
(152, 'discount_categories_groups_pp.php', 'FILE_DISCOUNT_CATEGORIES', 0, 3, '1,2', 99),
(153, 'premade_comments.php', 'BOX_PREMADE', 0, 7, '1,2', 4),
(154, 'page_modules_configuration.php', 'BOX_CONFIGURATION_PAGE_MODULES', 0, 2, '1', 21),
(155, 'stats_wishlist.php', 'BOX_REPORTS_WISHLIST', 0, 8, '1,2', 5),
(156, 'slideshow.php', 'BOX_TOOLS_SLIDESHOW', 0, 2, '1', 31),
(157, 'extra_fields.php', 'BOX_CATALOG_PRODUCTS_EXTRA_FIELDS', 0, 3, '1,2', 13),
(158, 'extra_values.php', 'BOX_CATALOG_PRODUCTS_EXTRA_VALUES', 0, 3, '1,2', 14),
(159, 'information_form.php', 'FILE_INFORMATION', 0, 2, '1', 99),
(160, 'information_list.php', 'FILE_INFORMATION', 0, 2, '1', 99),
(161, 'information_manager.php', 'FILE_INFORMATION', 0, 2, '1', 99),
(162, 'images_regen.php', 'BOX_TOOLS_REGEN', 0, 9, '1,2', 10),
(163, 'gc_dashboard.php', 'FILE_GC_DASHBOARD', 0, 4, '1', 99),
(164, 'specialsbycategory.php', 'BOX_CATALOG_SPECIALS_BY_CAT', 0, 3, '1,2', 7),
(165, 'configuration.php?gID=14', 'BOX_CONFIGURATION_GZIP', 0, 1, '1', 4),
(166, 'admin_members.php?gID=groups', 'BOX_ADMIN_GROUPS', 0, 1, '1', 2),
(167, 'configuration.php?gID=10', 'BOX_CONFIGURATION_LOGGING_CACHE', 0, 1, '1', 6),
(168, 'configuration.php?gID=11', 'BOX_CONFIGURATION_CACHE', 0, 1, '1', 7),
(169, 'configuration.php?gID=55', 'BOX_CONFIGURATION_PAGE_CACHE', 0, 1, '1', 8),
(170, 'configuration.php?gID=15', 'BOX_CONFIGURATION_SESSIONS', 0, 1, '1', 9),
(171, 'configuration.php?gID=16', 'BOX_CONFIGURATION_MAINTENANCE', 0, 1, '1', 10),
(172, 'merchant_info.php', 'BOX_MERCHANT_INFO', 0, 1, '1', 13),
(175, 'modules.php?set=payment', 'BOX_MODULES_PAYMENT', 0, 4, '1', 1),
(176, 'modules.php?set=shipping', 'BOX_MODULES_SHIPPING', 0, 4, '1', 2),
(177, 'modules.php?set=ordertotal', 'BOX_MODULES_ORDER_TOTAL', 0, 4, '1', 3),
(178, 'configuration.php?gID=1', 'BOX_CONFIGURATION_MYSTORE', 0, 2, '1', 1),
(179, 'configuration.php?gID=2', 'BOX_CONFIGURATION_MIN_VALUES', 0, 2, '1', 2),
(180, 'configuration.php?gID=3', 'BOX_CONFIGURATION_MAX_VALUES', 0, 2, '1', 3),
(181, 'configuration.php?gID=4', 'BOX_CONFIGURATION_IMAGES', 0, 2, '1', 5),
(182, 'configuration.php?gID=45', 'BOX_CONFIGURATION_MOPICS', 0, 2, '1', 7),
(183, 'configuration.php?gID=5', 'BOX_CONFIGURATION_CUSTOMER_DETAILS', 0, 2, '1', 8),
(184, 'configuration.php?gID=7', 'BOX_CONFIGURATION_SHIPPING', 0, 2, '1', 9),
(185, 'configuration.php?gID=8', 'BOX_CONFIGURATION_PRODUCT_LISTING', 0, 2, '1', 10),
(186, 'configuration.php?gID=50', 'BOX_CONFIGURATION_PRODUCT_INFO', 0, 2, '1', 12),
(187, 'configuration.php?gID=88', 'BOX_CONFIGURATION_PRODUCT_PRICE_BREAKS', 0, 2, '1', 13),
(188, 'configuration.php?gID=9', 'BOX_CONFIGURATION_STOCK', 0, 2, '1', 14),
(189, 'configuration.php?gID=13', 'BOX_CONFIGURATION_DOWNLOAD', 0, 2, '1', 15),
(190, 'configuration.php?gID=30', 'BOX_CONFIGURATION_PRINT', 0, 2, '1', 16),
(191, 'configuration.php?gID=12', 'BOX_CONFIGURATION_EMAIL', 0, 2, '1', 17),
(192, 'configuration.php?gID=206', 'BOX_CONFIGURATION_MC', 0, 2, '1', 17),
(193, 'configuration.php?gID=25', 'BOX_CONFIGURATION_WYSIWYG', 0, 2, '1', 18),
(194, 'configuration.php?gID=201', 'BOX_CONFIGURATION_TEMPLATE_SETUP', 0, 2, '1', 19),
(195, 'infobox_configuration.php', 'BOX_HEADING_BOXES', 0, 2, '1', 20),
(196, 'information_manager.php?gID=1', 'BOX_CONFIGURATION_INFO_PAGES', 0, 2, '1', 21),
(197, 'information_manager.php?gID=2', 'BOX_CONFIGURATION_WELCOME', 0, 2, '1', 22),
(198, 'configuration.php?gID=99', 'BOX_CONFIGURATION_OFS', 0, 2, '1', 23),
(199, 'configuration.php?gID=7575', 'BOX_CONFIGURATION_OPC', 0, 2, '1', 24),
(200, 'configuration.php?gID=204', 'BOX_CONFIGURATION_SLIDESHOW', 0, 2, '1', 25),
(201, 'configuration.php?gID=205', 'BOX_CONFIGURATION_CORNER_BANNERS', 0, 2, '1', 26),
(202, 'configuration.php?gID=207', 'BOX_CONFIGURATION_CONTACT', 0, 2, '1', 26),
(203, 'configuration.php?gID=87', 'BOX_CONFIGURATION_RECAPTCHA', 0, 2, '1', 27),
(204, 'configuration.php?gID=203', 'BOX_CONFIGURATION_NOTIFICATIONS', 0, 2, '1', 28),
(205, 'configuration.php?gID=65', 'BOX_CONFIGURATION_WISHLIST', 0, 2, '1', 28),
(206, 'configuration.php?gID=35', 'BOX_CONFIGURATION_AFFILIATE', 0, 2, '1', 29),
(207, 'configuration.php?gID=80', 'BOX_TOOLS_RECOVER_CART', 0, 2, '1', 30),
(208, 'configuration.php?gID=456', 'BOX_ARTICLES_CONFIG', 0, 2, '1', 32),
(209, 'configuration.php?gID=60', 'BOX_CONFIGURATION_SEO_URLS', 0, 2, '1', 33),
(210, 'configuration.php?gID=86', 'BOX_CONFIGURATION_SEO_POPOUT', 0, 2, '1', 34),
(211, 'configuration.php?gID=70', 'BOX_CONFIGURATION_EDITOR', 0, 2, '1', 35),
(212, 'configuration.php?gID=85', 'BOX_CONFIGURATION_GOOGLE_ANALYTICS', 0, 2, '1', 36),
(213, 'configuration.php?gID=89', 'BOX_CONFIGURATION_GOOGLE_MAPS', 0, 2, '1', 37),
(214, 'upgrade.php', 'BOX_ADMINISTRATOR_UPGRADE', 0, 1, '1', 20),
(215, 'stats_keywords.php', 'BOX_REPORTS_KEYWORDS', 0, 8, '1', 10),
(216, 'configuration.php?gID=46', 'BOX_CONFIGURATION_SLIMBOX', 0, 2, '1', 7),
(217, 'configuration.php?gID=47', 'BOX_CONFIGURATION_CLOUDZOOM', 0, 2, '1', 7),
(218, 'paypal_wpp_capture.php', 'FILE_PAYPAL', 0, 5, '1,2', 99),
(219, 'paypal_wpp_charge.php', 'FILE_PAYPAL', 0, 5, '1,2', 99),
(220, 'paypal_wpp_include.php', 'FILE_PAYPAL', 0, 5, '1,2', 99),
(221, 'paypal_wpp_refund.php', 'FILE_PAYPAL', 0, 5, '1,2', 99),
(222, 'configuration.php?gID=208', 'BOX_CONFIGURATION_ADDTHIS', 0, 2, '1', 26),
(223, 'customers_extra_fields.php', 'BOX_CUSTOMERS_EXTRA_FIELDS_MANAGER', 0, 5, '1', 0);

-- --------------------------------------------------------

--
-- Table structure for table `admin_groups`
--

CREATE TABLE `admin_groups` (
  `admin_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_groups_name` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`admin_groups_id`),
  UNIQUE KEY `admin_groups_name` (`admin_groups_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `admin_groups`
--

INSERT INTO `admin_groups` VALUES
(2, 'Customer Service'),
(1, 'Top Administrator');

-- --------------------------------------------------------

--
-- Table structure for table `admin_log`
--

CREATE TABLE `admin_log` (
  `login_number` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(32) DEFAULT NULL,
  `ip_address` varchar(32) DEFAULT NULL,
  `type` varchar(32) DEFAULT NULL,
  `login_time` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`login_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_affiliate`
--

CREATE TABLE `affiliate_affiliate` (
  `affiliate_id` int(11) NOT NULL AUTO_INCREMENT,
  `affiliate_gender` char(1) NOT NULL,
  `affiliate_firstname` varchar(32) NOT NULL,
  `affiliate_lastname` varchar(32) NOT NULL,
  `affiliate_dob` datetime NOT NULL,
  `affiliate_email_address` varchar(96) NOT NULL,
  `affiliate_telephone` varchar(32) NOT NULL,
  `affiliate_fax` varchar(32) NOT NULL,
  `affiliate_password` varchar(40) NOT NULL,
  `affiliate_homepage` varchar(96) NOT NULL,
  `affiliate_street_address` varchar(64) NOT NULL,
  `affiliate_suburb` varchar(64) NOT NULL,
  `affiliate_city` varchar(32) NOT NULL,
  `affiliate_postcode` varchar(10) NOT NULL,
  `affiliate_state` varchar(32) NOT NULL,
  `affiliate_country_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_zone_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_agb` tinyint(4) NOT NULL DEFAULT '0',
  `affiliate_company` varchar(60) NOT NULL,
  `affiliate_company_taxid` varchar(64) NOT NULL,
  `affiliate_commission_percent` decimal(4,2) NOT NULL DEFAULT '0.00',
  `affiliate_payment_check` varchar(100) NOT NULL,
  `affiliate_payment_paypal` varchar(64) NOT NULL,
  `affiliate_payment_bank_name` varchar(64) NOT NULL,
  `affiliate_payment_bank_branch_number` varchar(64) NOT NULL,
  `affiliate_payment_bank_swift_code` varchar(64) NOT NULL,
  `affiliate_payment_bank_account_name` varchar(64) NOT NULL,
  `affiliate_payment_bank_account_number` varchar(64) NOT NULL,
  `affiliate_date_of_last_logon` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `affiliate_number_of_logons` int(11) NOT NULL DEFAULT '0',
  `affiliate_date_account_created` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `affiliate_date_account_last_modified` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `affiliate_lft` int(11) NOT NULL,
  `affiliate_rgt` int(11) NOT NULL,
  `affiliate_root` int(11) NOT NULL,
  `affiliate_newsletter` char(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`affiliate_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_banners`
--

CREATE TABLE `affiliate_banners` (
  `affiliate_banners_id` int(11) NOT NULL AUTO_INCREMENT,
  `affiliate_banners_title` varchar(64) NOT NULL,
  `affiliate_products_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_category_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_banners_image` varchar(64) NOT NULL,
  `affiliate_banners_group` varchar(10) NOT NULL,
  `affiliate_banners_html_text` text,
  `affiliate_expires_impressions` int(7) DEFAULT '0',
  `affiliate_expires_date` datetime DEFAULT NULL,
  `affiliate_date_scheduled` datetime DEFAULT NULL,
  `affiliate_date_added` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `affiliate_date_status_change` datetime DEFAULT NULL,
  `affiliate_status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`affiliate_banners_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_banners_history`
--

CREATE TABLE `affiliate_banners_history` (
  `affiliate_banners_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `affiliate_banners_products_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_banners_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_banners_affiliate_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_banners_shown` int(11) NOT NULL DEFAULT '0',
  `affiliate_banners_clicks` tinyint(4) NOT NULL DEFAULT '0',
  `affiliate_banners_history_date` date NOT NULL DEFAULT '0001-01-01',
  PRIMARY KEY (`affiliate_banners_history_id`,`affiliate_banners_products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_clickthroughs`
--

CREATE TABLE `affiliate_clickthroughs` (
  `affiliate_clickthrough_id` int(11) NOT NULL AUTO_INCREMENT,
  `affiliate_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_clientdate` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `affiliate_clientbrowser` varchar(200) DEFAULT 'Could Not Find This Data',
  `affiliate_clientip` varchar(50) DEFAULT 'Could Not Find This Data',
  `affiliate_clientreferer` varchar(200) DEFAULT 'none detected (maybe a direct link)',
  `affiliate_products_id` int(11) DEFAULT '0',
  `affiliate_banner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`affiliate_clickthrough_id`),
  KEY `refid` (`affiliate_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_news`
--

CREATE TABLE `affiliate_news` (
  `news_id` int(11) NOT NULL AUTO_INCREMENT,
  `date_added` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `news_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`news_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_newsletters`
--

CREATE TABLE `affiliate_newsletters` (
  `affiliate_newsletters_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `module` varchar(255) NOT NULL,
  `date_added` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `date_sent` datetime DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  `locked` int(1) DEFAULT '0',
  PRIMARY KEY (`affiliate_newsletters_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_news_contents`
--

CREATE TABLE `affiliate_news_contents` (
  `affiliate_news_contents_id` int(11) NOT NULL AUTO_INCREMENT,
  `affiliate_news_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_news_languages_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_news_headlines` varchar(255) NOT NULL,
  `affiliate_news_contents` text NOT NULL,
  PRIMARY KEY (`affiliate_news_contents_id`),
  KEY `affiliate_news_id` (`affiliate_news_id`),
  KEY `affiliate_news_languages_id` (`affiliate_news_languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_payment`
--

CREATE TABLE `affiliate_payment` (
  `affiliate_payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `affiliate_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_payment` decimal(15,2) NOT NULL DEFAULT '0.00',
  `affiliate_payment_tax` decimal(15,2) NOT NULL DEFAULT '0.00',
  `affiliate_payment_total` decimal(15,2) NOT NULL DEFAULT '0.00',
  `affiliate_payment_date` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `affiliate_payment_last_modified` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `affiliate_payment_status` int(5) NOT NULL DEFAULT '0',
  `affiliate_firstname` varchar(32) NOT NULL,
  `affiliate_lastname` varchar(32) NOT NULL,
  `affiliate_street_address` varchar(64) NOT NULL,
  `affiliate_suburb` varchar(64) NOT NULL,
  `affiliate_city` varchar(32) NOT NULL,
  `affiliate_postcode` varchar(10) NOT NULL,
  `affiliate_country` varchar(32) NOT NULL DEFAULT '0',
  `affiliate_company` varchar(60) NOT NULL,
  `affiliate_state` varchar(32) NOT NULL DEFAULT '0',
  `affiliate_address_format_id` int(5) NOT NULL DEFAULT '0',
  `affiliate_last_modified` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  PRIMARY KEY (`affiliate_payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_payment_status`
--

CREATE TABLE `affiliate_payment_status` (
  `affiliate_payment_status_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_language_id` int(11) NOT NULL DEFAULT '1',
  `affiliate_payment_status_name` varchar(32) NOT NULL,
  PRIMARY KEY (`affiliate_payment_status_id`,`affiliate_language_id`),
  KEY `idx_affiliate_payment_status_name` (`affiliate_payment_status_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `affiliate_payment_status`
--

INSERT INTO `affiliate_payment_status` VALUES
(1, 2, 'Ausgezahlt'),
(0, 2, 'Offen'),
(1, 3, 'Pagado'),
(1, 1, 'Paid'),
(0, 3, 'Pendiente'),
(0, 1, 'Pending');

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_payment_status_history`
--

CREATE TABLE `affiliate_payment_status_history` (
  `affiliate_status_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `affiliate_payment_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_new_value` int(5) NOT NULL DEFAULT '0',
  `affiliate_old_value` int(5) DEFAULT NULL,
  `affiliate_date_added` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `affiliate_notified` int(1) DEFAULT '0',
  PRIMARY KEY (`affiliate_status_history_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_sales`
--

CREATE TABLE `affiliate_sales` (
  `affiliate_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_date` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `affiliate_browser` varchar(100) NOT NULL,
  `affiliate_ipaddress` varchar(20) NOT NULL,
  `affiliate_orders_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_value` decimal(15,2) NOT NULL DEFAULT '0.00',
  `affiliate_payment` decimal(15,2) NOT NULL DEFAULT '0.00',
  `affiliate_clickthroughs_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_billing_status` int(5) NOT NULL DEFAULT '0',
  `affiliate_payment_date` datetime NOT NULL,
  `affiliate_payment_id` int(11) NOT NULL DEFAULT '0',
  `affiliate_percent` decimal(4,2) NOT NULL DEFAULT '0.00',
  `affiliate_salesman` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`affiliate_orders_id`,`affiliate_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `articles`
--

CREATE TABLE `articles` (
  `articles_id` int(11) NOT NULL AUTO_INCREMENT,
  `articles_date_added` datetime NOT NULL,
  `articles_last_modified` datetime DEFAULT NULL,
  `articles_date_available` datetime DEFAULT NULL,
  `articles_status` tinyint(1) NOT NULL DEFAULT '0',
  `articles_index_status` tinyint(1) NOT NULL DEFAULT '0',
  `authors_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`articles_id`),
  KEY `idx_articles_date_added` (`articles_date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `articles_description`
--

CREATE TABLE `articles_description` (
  `articles_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `articles_name` varchar(64) NOT NULL,
  `articles_description` text,
  `articles_url` varchar(255) DEFAULT NULL,
  `articles_viewed` int(5) DEFAULT '0',
  `articles_head_title_tag` varchar(80) DEFAULT NULL,
  `articles_head_desc_tag` text,
  `articles_head_keywords_tag` text,
  PRIMARY KEY (`articles_id`,`language_id`),
  KEY `articles_name` (`articles_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `articles_to_topics`
--

CREATE TABLE `articles_to_topics` (
  `articles_id` int(11) NOT NULL DEFAULT '0',
  `topics_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`articles_id`,`topics_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `articles_xsell`
--

CREATE TABLE `articles_xsell` (
  `ID` int(10) NOT NULL AUTO_INCREMENT,
  `articles_id` int(10) unsigned NOT NULL DEFAULT '1',
  `xsell_id` int(10) unsigned NOT NULL DEFAULT '1',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `article_reviews`
--

CREATE TABLE `article_reviews` (
  `reviews_id` int(11) NOT NULL AUTO_INCREMENT,
  `articles_id` int(11) NOT NULL DEFAULT '0',
  `customers_id` int(11) DEFAULT NULL,
  `customers_name` varchar(64) NOT NULL,
  `reviews_rating` int(1) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reviews_read` int(5) NOT NULL DEFAULT '0',
  `approved` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`reviews_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `article_reviews_description`
--

CREATE TABLE `article_reviews_description` (
  `reviews_id` int(11) NOT NULL DEFAULT '0',
  `languages_id` int(11) NOT NULL DEFAULT '0',
  `reviews_text` text NOT NULL,
  PRIMARY KEY (`reviews_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `authors`
--

CREATE TABLE `authors` (
  `authors_id` int(11) NOT NULL AUTO_INCREMENT,
  `authors_name` varchar(32) NOT NULL,
  `authors_image` varchar(64) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`authors_id`),
  KEY `IDX_AUTHORS_NAME` (`authors_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `authors_info`
--

CREATE TABLE `authors_info` (
  `authors_id` int(11) NOT NULL DEFAULT '0',
  `languages_id` int(11) NOT NULL DEFAULT '0',
  `authors_description` text,
  `authors_url` varchar(255) NOT NULL,
  `url_clicked` int(5) NOT NULL DEFAULT '0',
  `date_last_click` datetime DEFAULT NULL,
  PRIMARY KEY (`authors_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `banners`
--

CREATE TABLE `banners` (
  `banners_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_title` varchar(64) NOT NULL,
  `banners_url` varchar(255) NOT NULL,
  `banners_image` varchar(64) NOT NULL,
  `banners_group` varchar(10) NOT NULL,
  `banners_html_text` text,
  `expires_impressions` int(7) DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `date_scheduled` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`banners_id`),
  KEY `idx_banners_group` (`banners_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `banners_history`
--

CREATE TABLE `banners_history` (
  `banners_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_id` int(11) NOT NULL,
  `banners_shown` int(5) NOT NULL DEFAULT '0',
  `banners_clicked` int(5) NOT NULL DEFAULT '0',
  `banners_history_date` datetime NOT NULL,
  PRIMARY KEY (`banners_history_id`),
  KEY `idx_banners_history_banners_id` (`banners_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `cache`
--

CREATE TABLE `cache` (
  `cache_id` varchar(32) NOT NULL,
  `cache_language_id` tinyint(1) NOT NULL DEFAULT '0',
  `cache_name` varchar(255) NOT NULL,
  `cache_data` mediumtext NOT NULL,
  `cache_global` tinyint(1) NOT NULL DEFAULT '1',
  `cache_gzip` tinyint(1) NOT NULL DEFAULT '1',
  `cache_method` varchar(20) NOT NULL DEFAULT 'RETURN',
  `cache_date` datetime NOT NULL,
  `cache_expires` datetime NOT NULL,
  PRIMARY KEY (`cache_id`,`cache_language_id`),
  KEY `cache_id` (`cache_id`),
  KEY `cache_language_id` (`cache_language_id`),
  KEY `cache_global` (`cache_global`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `categories_image` varchar(64) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) DEFAULT NULL,
  `categories_featured_until` date DEFAULT NULL,
  `categories_featured` tinyint(1) DEFAULT '0',
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `categories_hide_from_groups` varchar(255) NOT NULL DEFAULT '@',
  PRIMARY KEY (`categories_id`),
  KEY `idx_categories_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `categories_description`
--

CREATE TABLE `categories_description` (
  `categories_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `categories_name` varchar(32) NOT NULL,
  `categories_heading_title` varchar(64) DEFAULT NULL,
  `categories_description` text,
  PRIMARY KEY (`categories_id`,`language_id`),
  KEY `idx_categories_name` (`categories_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `configuration`
--

CREATE TABLE `configuration` (
  `configuration_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(255) NOT NULL,
  `configuration_key` varchar(255) NOT NULL,
  `configuration_value` varchar(512) NOT NULL,
  `configuration_description` varchar(255) NOT NULL,
  `configuration_group_id` int(11) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `use_function` varchar(255) DEFAULT NULL,
  `set_function` text,
  PRIMARY KEY (`configuration_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3527 ;

--
-- Dumping data for table `configuration`
--

INSERT INTO `configuration` VALUES
(1, 'CT_STORE_NAME', 'STORE_NAME', '[[store_name]]', 'CD_STORE_NAME', 1, 1, NULL, '[[regtime]]', NULL, NULL),
(2, 'CT_STORE_OWNER', 'STORE_OWNER', '[[admin_fname]] [[admin_lname]]', 'CD_STORE_OWNER', 1, 3, NULL, '[[regtime]]', NULL, NULL),
(3, 'CT_STORE_OWNER_EMAIL_ADDRESS', 'STORE_OWNER_EMAIL_ADDRESS', '[[admin_email]]', 'CD_STORE_OWNER_EMAIL_ADDRESS', 1, 4, NULL, '[[regtime]]', NULL, NULL),
(4, 'CT_EMAIL_FROM', 'EMAIL_FROM', 'admin@yourshop.com', 'CD_EMAIL_FROM', 1, 5, NULL, '[[regtime]]', NULL, NULL),
(5, 'CT_STORE_COUNTRY', 'STORE_COUNTRY', '223', 'CD_STORE_COUNTRY', 1, 6, NULL, '[[regtime]]', 'tep_get_country_name', 'tep_cfg_pull_down_country_list('),
(6, 'CT_STORE_ZONE', 'STORE_ZONE', '4', 'CD_STORE_ZONE', 1, 7, NULL, '[[regtime]]', 'tep_cfg_get_zone_name', 'tep_cfg_pull_down_zone_list('),
(7, 'CT_EXPECTED_PRODUCTS_SORT', 'EXPECTED_PRODUCTS_SORT', 'desc', 'CD_EXPECTED_PRODUCTS_SORT', 1, 8, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''asc'', ''desc''), '),
(8, 'CT_EXPECTED_PRODUCTS_FIELD', 'EXPECTED_PRODUCTS_FIELD', 'date_expected', 'CD_EXPECTED_PRODUCTS_FIELD', 1, 9, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''products_name'', ''date_expected''), '),
(9, 'CT_USE_DEFAULT_LANGUAGE_CURRENCY', 'USE_DEFAULT_LANGUAGE_CURRENCY', 'false', 'CD_USE_DEFAULT_LANGUAGE_CURRENCY', 1, 10, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',  ''false''), '),
(10, 'CT_SEND_EXTRA_ORDER_EMAILS_TO', 'SEND_EXTRA_ORDER_EMAILS_TO', '', 'CD_SEND_EXTRA_ORDER_EMAILS_TO', 1, 12, NULL, '[[regtime]]', NULL, NULL),
(12, 'CT_DISPLAY_CART', 'DISPLAY_CART', 'true', 'CD_DISPLAY_CART', 1, 14, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',  ''false''), '),
(13, 'CT_ALLOW_GUEST_TO_TELL_A_FRIEND', 'ALLOW_GUEST_TO_TELL_A_FRIEND', 'false', 'CD_ALLOW_GUEST_TO_TELL_A_FRIEND', 1, 15, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',  ''false''), '),
(14, 'CT_ADVANCED_SEARCH_DEFAULT_OPERATOR', 'ADVANCED_SEARCH_DEFAULT_OPERATOR', 'and', 'CD_ADVANCED_SEARCH_DEFAULT_OPERATOR', 1, 17, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''and'',  ''or''), '),
(15, 'CT_STORE_NAME_ADDRESS', 'STORE_NAME_ADDRESS', 'Store Name\nAddress\nCountry\nPhone', 'CD_STORE_NAME_ADDRESS', 1, 18, NULL, '[[regtime]]', NULL, 'tep_cfg_textarea('),
(16, 'CT_SHOW_COUNTS', 'SHOW_COUNTS', 'false', 'CD_SHOW_COUNTS', 1, 19, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',  ''false''), '),
(17, 'CT_TAX_DECIMAL_PLACES', 'TAX_DECIMAL_PLACES', '2', 'CD_TAX_DECIMAL_PLACES', 1, 20, NULL, '[[regtime]]', NULL, NULL),
(18, 'CT_DISPLAY_PRICE_WITH_TAX', 'DISPLAY_PRICE_WITH_TAX', 'false', 'CD_DISPLAY_PRICE_WITH_TAX', 1, 21, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',  ''false''), '),
(19, 'CT_ENTRY_FIRST_NAME_MIN_LENGTH', 'ENTRY_FIRST_NAME_MIN_LENGTH', '2', 'CD_ENTRY_FIRST_NAME_MIN_LENGTH', 2, 1, NULL, '[[regtime]]', NULL, NULL),
(20, 'CT_ENTRY_LAST_NAME_MIN_LENGTH', 'ENTRY_LAST_NAME_MIN_LENGTH', '2', 'CD_ENTRY_LAST_NAME_MIN_LENGTH', 2, 2, NULL, '[[regtime]]', NULL, NULL),
(21, 'CT_ENTRY_DOB_MIN_LENGTH', 'ENTRY_DOB_MIN_LENGTH', '10', 'CD_ENTRY_DOB_MIN_LENGTH', 2, 3, NULL, '[[regtime]]', NULL, NULL),
(22, 'CT_ENTRY_EMAIL_ADDRESS_MIN_LENGTH', 'ENTRY_EMAIL_ADDRESS_MIN_LENGTH', '6', 'CD_ENTRY_EMAIL_ADDRESS_MIN_LENGTH', 2, 4, NULL, '[[regtime]]', NULL, NULL),
(23, 'CT_ENTRY_STREET_ADDRESS_MIN_LENGTH', 'ENTRY_STREET_ADDRESS_MIN_LENGTH', '5', 'CD_ENTRY_STREET_ADDRESS_MIN_LENGTH', 2, 5, NULL, '[[regtime]]', NULL, NULL),
(24, 'CT_ENTRY_COMPANY_MIN_LENGTH', 'ENTRY_COMPANY_MIN_LENGTH', '2', 'CD_ENTRY_COMPANY_MIN_LENGTH', 2, 6, NULL, '[[regtime]]', NULL, NULL),
(25, 'CT_ENTRY_POSTCODE_MIN_LENGTH', 'ENTRY_POSTCODE_MIN_LENGTH', '4', 'CD_ENTRY_POSTCODE_MIN_LENGTH', 2, 7, NULL, '[[regtime]]', NULL, NULL),
(26, 'CT_ENTRY_CITY_MIN_LENGTH', 'ENTRY_CITY_MIN_LENGTH', '3', 'CD_ENTRY_CITY_MIN_LENGTH', 2, 8, NULL, '[[regtime]]', NULL, NULL),
(27, 'CT_ENTRY_STATE_MIN_LENGTH', 'ENTRY_STATE_MIN_LENGTH', '2', 'CD_ENTRY_STATE_MIN_LENGTH', 2, 9, NULL, '[[regtime]]', NULL, NULL),
(28, 'CT_ENTRY_TELEPHONE_MIN_LENGTH', 'ENTRY_TELEPHONE_MIN_LENGTH', '3', 'CD_ENTRY_TELEPHONE_MIN_LENGTH', 2, 10, NULL, '[[regtime]]', NULL, NULL),
(29, 'CT_ENTRY_PASSWORD_MIN_LENGTH', 'ENTRY_PASSWORD_MIN_LENGTH', '5', 'CD_ENTRY_PASSWORD_MIN_LENGTH', 2, 11, NULL, '[[regtime]]', NULL, NULL),
(30, 'CT_CC_OWNER_MIN_LENGTH', 'CC_OWNER_MIN_LENGTH', '3', 'CD_CC_OWNER_MIN_LENGTH', 2, 12, NULL, '[[regtime]]', NULL, NULL),
(31, 'CT_CC_NUMBER_MIN_LENGTH', 'CC_NUMBER_MIN_LENGTH', '10', 'CD_CC_NUMBER_MIN_LENGTH', 2, 13, NULL, '[[regtime]]', NULL, NULL),
(32, 'CT_REVIEW_TEXT_MIN_LENGTH', 'REVIEW_TEXT_MIN_LENGTH', '50', 'CD_REVIEW_TEXT_MIN_LENGTH', 2, 14, NULL, '[[regtime]]', NULL, NULL),
(33, 'CT_MIN_DISPLAY_BESTSELLERS', 'MIN_DISPLAY_BESTSELLERS', '1', 'CD_MIN_DISPLAY_BESTSELLERS', 2, 15, NULL, '[[regtime]]', NULL, NULL),
(34, 'CT_MIN_DISPLAY_ALSO_PURCHASED', 'MIN_DISPLAY_ALSO_PURCHASED', '1', 'CD_MIN_DISPLAY_ALSO_PURCHASED', 2, 16, NULL, '[[regtime]]', NULL, NULL),
(35, 'CT_MAX_ADDRESS_BOOK_ENTRIES', 'MAX_ADDRESS_BOOK_ENTRIES', '5', 'CD_MAX_ADDRESS_BOOK_ENTRIES', 3, 1, NULL, '[[regtime]]', NULL, NULL),
(36, 'CT_MAX_CATALOG_DISPLAY_SEARCH_RESULTS', 'MAX_CATALOG_DISPLAY_SEARCH_RESULTS', '20', 'CD_MAX_CATALOG_DISPLAY_SEARCH_RESULTS', 3, 2, NULL, '[[regtime]]', NULL, NULL),
(37, 'CT_MAX_DISPLAY_PAGE_LINKS', 'MAX_DISPLAY_PAGE_LINKS', '5', 'CD_MAX_DISPLAY_PAGE_LINKS', 3, 3, NULL, '[[regtime]]', NULL, NULL),
(38, 'CT_MAX_DISPLAY_SPECIAL_PRODUCTS', 'MAX_DISPLAY_SPECIAL_PRODUCTS', '9', 'CD_MAX_DISPLAY_SPECIAL_PRODUCTS', 3, 4, NULL, '[[regtime]]', NULL, NULL),
(39, 'CT_MAX_DISPLAY_NEW_PRODUCTS', 'MAX_DISPLAY_NEW_PRODUCTS', '9', 'CD_MAX_DISPLAY_NEW_PRODUCTS', 3, 5, NULL, '[[regtime]]', NULL, NULL),
(40, 'CT_MAX_DISPLAY_UPCOMING_PRODUCTS', 'MAX_DISPLAY_UPCOMING_PRODUCTS', '10', 'CD_MAX_DISPLAY_UPCOMING_PRODUCTS', 3, 6, NULL, '[[regtime]]', NULL, NULL),
(41, 'CT_MAX_DISPLAY_MANUFACTURERS_IN_A_LIST', 'MAX_DISPLAY_MANUFACTURERS_IN_A_LIST', '0', 'CD_MAX_DISPLAY_MANUFACTURERS_IN_A_LIST', 3, 7, NULL, '[[regtime]]', NULL, NULL),
(42, 'CT_MAX_MANUFACTURERS_LIST', 'MAX_MANUFACTURERS_LIST', '1', 'CD_MAX_MANUFACTURERS_LIST', 3, 7, NULL, '[[regtime]]', NULL, NULL),
(43, 'CT_MAX_DISPLAY_MANUFACTURER_NAME_LEN', 'MAX_DISPLAY_MANUFACTURER_NAME_LEN', '15', 'CD_MAX_DISPLAY_MANUFACTURER_NAME_LEN', 3, 8, NULL, '[[regtime]]', NULL, NULL),
(44, 'CT_MAX_DISPLAY_NEW_REVIEWS', 'MAX_DISPLAY_NEW_REVIEWS', '6', 'CD_MAX_DISPLAY_NEW_REVIEWS', 3, 9, NULL, '[[regtime]]', NULL, NULL),
(45, 'CT_MAX_RANDOM_SELECT_REVIEWS', 'MAX_RANDOM_SELECT_REVIEWS', '10', 'CD_MAX_RANDOM_SELECT_REVIEWS', 3, 10, NULL, '[[regtime]]', NULL, NULL),
(46, 'CT_MAX_RANDOM_SELECT_NEW', 'MAX_RANDOM_SELECT_NEW', '10', 'CD_MAX_RANDOM_SELECT_NEW', 3, 11, NULL, '[[regtime]]', NULL, NULL),
(47, 'CT_MAX_RANDOM_SELECT_SPECIALS', 'MAX_RANDOM_SELECT_SPECIALS', '10', 'CD_MAX_RANDOM_SELECT_SPECIALS', 3, 12, NULL, '[[regtime]]', NULL, NULL),
(48, 'CT_MAX_DISPLAY_CATEGORIES_PER_ROW', 'MAX_DISPLAY_CATEGORIES_PER_ROW', '3', 'CD_MAX_DISPLAY_CATEGORIES_PER_ROW', 3, 13, NULL, '[[regtime]]', NULL, NULL),
(49, 'CT_MAX_DISPLAY_PRODUCTS_NEW', 'MAX_DISPLAY_PRODUCTS_NEW', '10', 'CD_MAX_DISPLAY_PRODUCTS_NEW', 3, 14, NULL, '[[regtime]]', NULL, NULL),
(50, 'CT_MAX_DISPLAY_BESTSELLERS', 'MAX_DISPLAY_BESTSELLERS', '10', 'CD_MAX_DISPLAY_BESTSELLERS', 3, 15, NULL, '[[regtime]]', NULL, NULL),
(51, 'CT_MAX_DISPLAY_ALSO_PURCHASED', 'MAX_DISPLAY_ALSO_PURCHASED', '6', 'CD_MAX_DISPLAY_ALSO_PURCHASED', 3, 16, NULL, '[[regtime]]', NULL, NULL),
(52, 'CT_MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX', 'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX', '6', 'CD_MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX', 3, 17, NULL, '[[regtime]]', NULL, NULL),
(53, 'CT_MAX_DISPLAY_ORDER_HISTORY', 'MAX_DISPLAY_ORDER_HISTORY', '10', 'CD_MAX_DISPLAY_ORDER_HISTORY', 3, 18, NULL, '[[regtime]]', NULL, NULL),
(54, 'CT_MAX_QTY_IN_CART', 'MAX_QTY_IN_CART', '99', 'CD_MAX_QTY_IN_CART', 3, 19, NULL, '[[regtime]]', NULL, NULL),
(55, 'CT_SMALL_IMAGE_WIDTH', 'SMALL_IMAGE_WIDTH', '120', 'CD_SMALL_IMAGE_WIDTH', 4, 5, NULL, '[[regtime]]', NULL, NULL),
(56, 'CT_SMALL_IMAGE_HEIGHT', 'SMALL_IMAGE_HEIGHT', '', 'CD_SMALL_IMAGE_HEIGHT', 4, 6, NULL, '[[regtime]]', NULL, NULL),
(57, 'CT_HEADING_IMAGE_WIDTH', 'HEADING_IMAGE_WIDTH', '100', 'CD_HEADING_IMAGE_WIDTH', 4, 8, NULL, '[[regtime]]', NULL, NULL),
(58, 'CT_HEADING_IMAGE_HEIGHT', 'HEADING_IMAGE_HEIGHT', '', 'CD_HEADING_IMAGE_HEIGHT', 4, 9, NULL, '[[regtime]]', NULL, NULL),
(59, 'CT_SUBCATEGORY_IMAGE_WIDTH', 'SUBCATEGORY_IMAGE_WIDTH', '100', 'CD_SUBCATEGORY_IMAGE_WIDTH', 4, 10, NULL, '[[regtime]]', NULL, NULL),
(60, 'CT_SUBCATEGORY_IMAGE_HEIGHT', 'SUBCATEGORY_IMAGE_HEIGHT', '', 'CD_SUBCATEGORY_IMAGE_HEIGHT', 4, 11, NULL, '[[regtime]]', NULL, NULL),
(61, 'CT_CONFIG_CALCULATE_IMAGE_SIZE', 'CONFIG_CALCULATE_IMAGE_SIZE', 'true', 'CD_CONFIG_CALCULATE_IMAGE_SIZE', 4, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(62, 'CT_CATEGORY_IMAGE_REQUIRED', 'CATEGORY_IMAGE_REQUIRED', 'true', 'CD_CATEGORY_IMAGE_REQUIRED', 4, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(63, 'CT_ACCOUNT_GENDER', 'ACCOUNT_GENDER', 'false', 'CD_ACCOUNT_GENDER', 5, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(64, 'CT_ACCOUNT_DOB', 'ACCOUNT_DOB', 'false', 'CD_ACCOUNT_DOB', 5, 2, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(65, 'CT_ACCOUNT_COMPANY', 'ACCOUNT_COMPANY', 'false', 'CD_ACCOUNT_COMPANY', 5, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(66, 'CT_ACCOUNT_SUBURB', 'ACCOUNT_SUBURB', 'false', 'CD_ACCOUNT_SUBURB', 5, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(67, 'CT_ACCOUNT_STATE', 'ACCOUNT_STATE', 'true', 'CD_ACCOUNT_STATE', 5, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(68, 'CT_MODULE_PAYMENT_INSTALLED', 'MODULE_PAYMENT_INSTALLED', '', 'CD_MODULE_PAYMENT_INSTALLED', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(69, 'CT_MODULE_ORDER_TOTAL_INSTALLED', 'MODULE_ORDER_TOTAL_INSTALLED', 'ot_subtotal.php;ot_shipping.php;ot_tax.php;ot_loyalty_discount.php;ot_loworderfee.php;ot_coupon.php;ot_gv.php;ot_total.php', 'CD_MODULE_ORDER_TOTAL_INSTALLED', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(70, 'CT_MODULE_SHIPPING_INSTALLED', 'MODULE_SHIPPING_INSTALLED', '', 'CD_MODULE_SHIPPING_INSTALLED', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(77, 'CT_GOOGLE_MAPS_KEY', 'GOOGLE_MAPS_KEY', 'YOURKEY', 'CD_GOOGLE_MAPS_KEY', 89, 25, NULL, '[[regtime]]', NULL, 'tep_cfg_textarea('),
(85, 'CT_DEFAULT_CURRENCY', 'DEFAULT_CURRENCY', 'USD', 'CD_DEFAULT_CURRENCY', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(86, 'CT_DEFAULT_LANGUAGE', 'DEFAULT_LANGUAGE', 'en', 'CD_DEFAULT_LANGUAGE', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(87, 'CT_DEFAULT_ORDERS_STATUS_ID', 'DEFAULT_ORDERS_STATUS_ID', '1', 'CD_DEFAULT_ORDERS_STATUS_ID', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(88, 'CT_MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'true', 'CD_MODULE_ORDER_TOTAL_SHIPPING_STATUS', 6, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(89, 'CT_MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '7', 'CD_MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(90, 'CT_MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'false', 'CD_MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 6, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(91, 'CT_MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', '50', 'CD_MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', 6, 4, NULL, '[[regtime]]', 'currencies->format', NULL),
(92, 'CT_MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'national', 'CD_MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 6, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''national'', ''international'', ''both''),'),
(93, 'CT_MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'true', 'CD_MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 6, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(94, 'CT_MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '1', 'CD_MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(95, 'CT_MODULE_ORDER_TOTAL_TAX_STATUS', 'MODULE_ORDER_TOTAL_TAX_STATUS', 'true', 'CD_MODULE_ORDER_TOTAL_TAX_STATUS', 6, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(96, 'CT_MODULE_ORDER_TOTAL_TAX_SORT_ORDER', 'MODULE_ORDER_TOTAL_TAX_SORT_ORDER', '11', 'CD_MODULE_ORDER_TOTAL_TAX_SORT_ORDER', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(97, 'CT_MODULE_ORDER_TOTAL_TOTAL_STATUS', 'MODULE_ORDER_TOTAL_TOTAL_STATUS', 'true', 'CD_MODULE_ORDER_TOTAL_TOTAL_STATUS', 6, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(98, 'CT_MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', 'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '15', 'CD_MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(99, 'CT_SHIPPING_ORIGIN_COUNTRY', 'SHIPPING_ORIGIN_COUNTRY', '223', 'CD_SHIPPING_ORIGIN_COUNTRY', 7, 1, NULL, '[[regtime]]', 'tep_get_country_name', 'tep_cfg_pull_down_country_list('),
(100, 'CT_SHIPPING_ORIGIN_ZIP', 'SHIPPING_ORIGIN_ZIP', 'NONE', 'CD_SHIPPING_ORIGIN_ZIP', 7, 2, NULL, '[[regtime]]', NULL, NULL),
(101, 'CT_SHIPPING_MAX_WEIGHT', 'SHIPPING_MAX_WEIGHT', '50', 'CD_SHIPPING_MAX_WEIGHT', 7, 3, NULL, '[[regtime]]', NULL, NULL),
(102, 'CT_SHIPPING_BOX_WEIGHT', 'SHIPPING_BOX_WEIGHT', '1', 'CD_SHIPPING_BOX_WEIGHT', 7, 4, NULL, '[[regtime]]', NULL, NULL),
(103, 'CT_SHIPPING_BOX_PADDING', 'SHIPPING_BOX_PADDING', '10', 'CD_SHIPPING_BOX_PADDING', 7, 5, NULL, '[[regtime]]', NULL, NULL),
(104, 'CT_PRODUCT_LIST_IMAGE', 'PRODUCT_LIST_IMAGE', '2', 'CD_PRODUCT_LIST_IMAGE', 8, 2, NULL, '[[regtime]]', NULL, NULL),
(105, 'CT_PRODUCT_LIST_MANUFACTURER', 'PRODUCT_LIST_MANUFACTURER', '0', 'CD_PRODUCT_LIST_MANUFACTURER', 8, 3, NULL, '[[regtime]]', NULL, NULL),
(106, 'CT_PRODUCT_LIST_MODEL', 'PRODUCT_LIST_MODEL', '0', 'CD_PRODUCT_LIST_MODEL', 8, 4, NULL, '[[regtime]]', NULL, NULL),
(107, 'CT_PRODUCT_LIST_NAME', 'PRODUCT_LIST_NAME', '3', 'CD_PRODUCT_LIST_NAME', 8, 5, NULL, '[[regtime]]', NULL, NULL),
(108, 'CT_PRODUCT_LIST_PRICE', 'PRODUCT_LIST_PRICE', '4', 'CD_PRODUCT_LIST_PRICE', 8, 6, NULL, '[[regtime]]', NULL, NULL),
(109, 'CT_PRODUCT_LIST_QUANTITY', 'PRODUCT_LIST_QUANTITY', '0', 'CD_PRODUCT_LIST_QUANTITY', 8, 7, NULL, '[[regtime]]', NULL, NULL),
(110, 'CT_PRODUCT_LIST_WEIGHT', 'PRODUCT_LIST_WEIGHT', '0', 'CD_PRODUCT_LIST_WEIGHT', 8, 8, NULL, '[[regtime]]', NULL, NULL),
(111, 'CT_PRODUCT_LIST_BUY_NOW', 'PRODUCT_LIST_BUY_NOW', '5', 'CD_PRODUCT_LIST_BUY_NOW', 8, 9, NULL, '[[regtime]]', NULL, NULL),
(112, 'CT_PRODUCT_LIST_FILTER', 'PRODUCT_LIST_FILTER', '1', 'CD_PRODUCT_LIST_FILTER', 8, 10, NULL, '[[regtime]]', NULL, NULL),
(113, 'CT_PREV_NEXT_BAR_LOCATION', 'PREV_NEXT_BAR_LOCATION', '3', 'CD_PREV_NEXT_BAR_LOCATION', 8, 11, NULL, '[[regtime]]', NULL, NULL),
(114, 'CT_STOCK_CHECK', 'STOCK_CHECK', 'true', 'CD_STOCK_CHECK', 9, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(115, 'CT_STOCK_LIMITED', 'STOCK_LIMITED', 'true', 'CD_STOCK_LIMITED', 9, 2, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(116, 'CT_STOCK_ALLOW_CHECKOUT', 'STOCK_ALLOW_CHECKOUT', 'true', 'CD_STOCK_ALLOW_CHECKOUT', 9, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(117, 'CT_STOCK_MARK_PRODUCT_OUT_OF_STOCK', 'STOCK_MARK_PRODUCT_OUT_OF_STOCK', '***', 'CD_STOCK_MARK_PRODUCT_OUT_OF_STOCK', 9, 4, NULL, '[[regtime]]', NULL, NULL),
(118, 'CT_STOCK_REORDER_LEVEL', 'STOCK_REORDER_LEVEL', '5', 'CD_STOCK_REORDER_LEVEL', 9, 5, NULL, '[[regtime]]', NULL, NULL),
(119, 'CT_STORE_PAGE_PARSE_TIME', 'STORE_PAGE_PARSE_TIME', 'false', 'CD_STORE_PAGE_PARSE_TIME', 10, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(120, 'CT_STORE_PAGE_PARSE_TIME_LOG', 'STORE_PAGE_PARSE_TIME_LOG', '/var/log/www/tep/page_parse_time.log', 'CD_STORE_PAGE_PARSE_TIME_LOG', 10, 2, NULL, '[[regtime]]', NULL, NULL),
(121, 'CT_STORE_PARSE_DATE_TIME_FORMAT', 'STORE_PARSE_DATE_TIME_FORMAT', '%d/%m/%Y %H:%M:%S', 'CD_STORE_PARSE_DATE_TIME_FORMAT', 10, 3, NULL, '[[regtime]]', NULL, NULL),
(122, 'CT_DISPLAY_PAGE_PARSE_TIME', 'DISPLAY_PAGE_PARSE_TIME', 'false', 'CD_DISPLAY_PAGE_PARSE_TIME', 10, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(123, 'CT_STORE_DB_TRANSACTIONS', 'STORE_DB_TRANSACTIONS', 'false', 'CD_STORE_DB_TRANSACTIONS', 10, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(124, 'CT_USE_CACHE', 'USE_CACHE', 'false', 'CD_USE_CACHE', 11, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(125, 'CT_DIR_FS_CACHE', 'DIR_FS_CACHE', 'cache/', 'CD_DIR_FS_CACHE', 11, 2, NULL, '[[regtime]]', NULL, NULL),
(126, 'CT_EMAIL_TRANSPORT', 'EMAIL_TRANSPORT', 'sendmail', 'CD_EMAIL_TRANSPORT', 12, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''sendmail'', ''smtp''),'),
(127, 'CT_EMAIL_LINEFEED', 'EMAIL_LINEFEED', 'LF', 'CD_EMAIL_LINEFEED', 12, 2, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''LF'', ''CRLF''),'),
(128, 'CT_EMAIL_USE_HTML', 'EMAIL_USE_HTML', 'false', 'CD_EMAIL_USE_HTML', 12, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(129, 'CT_ENTRY_EMAIL_ADDRESS_CHECK', 'ENTRY_EMAIL_ADDRESS_CHECK', 'false', 'CD_ENTRY_EMAIL_ADDRESS_CHECK', 12, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(130, 'CT_SEND_EMAILS', 'SEND_EMAILS', 'true', 'CD_SEND_EMAILS', 12, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(131, 'CT_DOWNLOAD_ENABLED', 'DOWNLOAD_ENABLED', 'true', 'CD_DOWNLOAD_ENABLED', 13, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(132, 'CT_DOWNLOAD_BY_REDIRECT', 'DOWNLOAD_BY_REDIRECT', 'true', 'CD_DOWNLOAD_BY_REDIRECT', 13, 2, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(133, 'CT_DOWNLOAD_MAX_DAYS', 'DOWNLOAD_MAX_DAYS', '7', 'CD_DOWNLOAD_MAX_DAYS', 13, 3, NULL, '[[regtime]]', NULL, ''),
(134, 'CT_DOWNLOAD_MAX_COUNT', 'DOWNLOAD_MAX_COUNT', '5', 'CD_DOWNLOAD_MAX_COUNT', 13, 4, NULL, '[[regtime]]', NULL, ''),
(135, 'CT_GZIP_COMPRESSION', 'GZIP_COMPRESSION', 'false', 'CD_GZIP_COMPRESSION', 14, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(136, 'CT_GZIP_LEVEL', 'GZIP_LEVEL', '5', 'CD_GZIP_LEVEL', 14, 2, NULL, '[[regtime]]', NULL, NULL),
(137, 'CT_SESSION_WRITE_DIRECTORY', 'SESSION_WRITE_DIRECTORY', '/tmp', 'CD_SESSION_WRITE_DIRECTORY', 15, 1, NULL, '[[regtime]]', NULL, NULL),
(138, 'CT_SESSION_FORCE_COOKIE_USE', 'SESSION_FORCE_COOKIE_USE', 'False', 'CD_SESSION_FORCE_COOKIE_USE', 15, 2, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''True'', ''False''),'),
(139, 'CT_SESSION_CHECK_SSL_SESSION_ID', 'SESSION_CHECK_SSL_SESSION_ID', 'False', 'CD_SESSION_CHECK_SSL_SESSION_ID', 15, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''True'', ''False''),'),
(140, 'CT_SESSION_CHECK_USER_AGENT', 'SESSION_CHECK_USER_AGENT', 'False', 'CD_SESSION_CHECK_USER_AGENT', 15, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''True'', ''False''),'),
(141, 'CT_SESSION_CHECK_IP_ADDRESS', 'SESSION_CHECK_IP_ADDRESS', 'False', 'CD_SESSION_CHECK_IP_ADDRESS', 15, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''True'', ''False''),'),
(142, 'CT_SESSION_BLOCK_SPIDERS', 'SESSION_BLOCK_SPIDERS', 'True', 'CD_SESSION_BLOCK_SPIDERS', 15, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''True'', ''False''),'),
(143, 'CT_SESSION_RECREATE', 'SESSION_RECREATE', 'True', 'CD_SESSION_RECREATE', 15, 7, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''True'', ''False''),'),
(144, 'CT_HTML_AREA_WYSIWYG_DISABLE', 'HTML_AREA_WYSIWYG_DISABLE', 'Enable', 'CD_HTML_AREA_WYSIWYG_DISABLE', 25, 0, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''Enable'', ''Disable''),'),
(148, 'CT_HTML_AREA_WYSIWYG_DISABLE_EMAIL', 'HTML_AREA_WYSIWYG_DISABLE_EMAIL', 'Enable', 'CD_HTML_AREA_WYSIWYG_DISABLE_EMAIL', 25, 20, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''Enable'', ''Disable''),'),
(152, 'CT_HTML_AREA_WYSIWYG_DISABLE_NEWSLETTER', 'HTML_AREA_WYSIWYG_DISABLE_NEWSLETTER', 'Enable', 'CD_HTML_AREA_WYSIWYG_DISABLE_NEWSLETTER', 25, 30, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''Enable'', ''Disable''),'),
(156, 'CT_HTML_AREA_WYSIWYG_DISABLE_DEFINE', 'HTML_AREA_WYSIWYG_DISABLE_DEFINE', 'Enable', 'CD_HTML_AREA_WYSIWYG_DISABLE_DEFINE', 25, 40, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''Enable'', ''Disable''),'),
(178, 'CT_MODULE_ORDER_TOTAL_COUPON_STATUS', 'MODULE_ORDER_TOTAL_COUPON_STATUS', 'true', 'CD_MODULE_ORDER_TOTAL_COUPON_STATUS', 6, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(179, 'CT_MODULE_ORDER_TOTAL_COUPON_SORT_ORDER', 'MODULE_ORDER_TOTAL_COUPON_SORT_ORDER', '9', 'CD_MODULE_ORDER_TOTAL_COUPON_SORT_ORDER', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(180, 'CT_MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING', 'MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING', 'true', 'CD_MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING', 6, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(181, 'CT_MODULE_ORDER_TOTAL_COUPON_INC_TAX', 'MODULE_ORDER_TOTAL_COUPON_INC_TAX', 'false', 'CD_MODULE_ORDER_TOTAL_COUPON_INC_TAX', 6, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(182, 'CT_MODULE_ORDER_TOTAL_COUPON_CALC_TAX', 'MODULE_ORDER_TOTAL_COUPON_CALC_TAX', 'None', 'CD_MODULE_ORDER_TOTAL_COUPON_CALC_TAX', 6, 7, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''None'', ''Standard'', ''Credit Note''),'),
(183, 'CT_MODULE_ORDER_TOTAL_COUPON_TAX_CLASS', 'MODULE_ORDER_TOTAL_COUPON_TAX_CLASS', '0', 'CD_MODULE_ORDER_TOTAL_COUPON_TAX_CLASS', 6, 0, NULL, '[[regtime]]', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes('),
(184, 'CT_MODULE_ORDER_TOTAL_GV_STATUS', 'MODULE_ORDER_TOTAL_GV_STATUS', 'true', 'CD_MODULE_ORDER_TOTAL_GV_STATUS', 6, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(185, 'CT_MODULE_ORDER_TOTAL_GV_SORT_ORDER', 'MODULE_ORDER_TOTAL_GV_SORT_ORDER', '13', 'CD_MODULE_ORDER_TOTAL_GV_SORT_ORDER', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(186, 'CT_MODULE_ORDER_TOTAL_GV_QUEUE', 'MODULE_ORDER_TOTAL_GV_QUEUE', 'true', 'CD_MODULE_ORDER_TOTAL_GV_QUEUE', 6, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(187, 'CT_MODULE_ORDER_TOTAL_GV_INC_SHIPPING', 'MODULE_ORDER_TOTAL_GV_INC_SHIPPING', 'true', 'CD_MODULE_ORDER_TOTAL_GV_INC_SHIPPING', 6, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(188, 'CT_MODULE_ORDER_TOTAL_GV_INC_TAX', 'MODULE_ORDER_TOTAL_GV_INC_TAX', 'false', 'CD_MODULE_ORDER_TOTAL_GV_INC_TAX', 6, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(189, 'CT_MODULE_ORDER_TOTAL_GV_CALC_TAX', 'MODULE_ORDER_TOTAL_GV_CALC_TAX', 'None', 'CD_MODULE_ORDER_TOTAL_GV_CALC_TAX', 6, 7, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''None'', ''Standard'', ''Credit Note''),'),
(190, 'CT_MODULE_ORDER_TOTAL_GV_TAX_CLASS', 'MODULE_ORDER_TOTAL_GV_TAX_CLASS', '0', 'CD_MODULE_ORDER_TOTAL_GV_TAX_CLASS', 6, 0, NULL, '[[regtime]]', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes('),
(191, 'CT_MODULE_ORDER_TOTAL_GV_CREDIT_TAX', 'MODULE_ORDER_TOTAL_GV_CREDIT_TAX', 'false', 'CD_MODULE_ORDER_TOTAL_GV_CREDIT_TAX', 6, 8, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(192, 'CT_ALLOW_CATEGORY_DESCRIPTIONS', 'ALLOW_CATEGORY_DESCRIPTIONS', 'true', 'CD_ALLOW_CATEGORY_DESCRIPTIONS', 8, 11, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(193, 'CT_MAX_DISPLAY_SEARCH_RESULTS', 'MAX_DISPLAY_SEARCH_RESULTS', '20', 'CD_MAX_DISPLAY_SEARCH_RESULTS', 3, 2, NULL, '[[regtime]]', NULL, NULL),
(358, 'CT_DOWNLOADS_ORDERS_STATUS_UPDATED_VALUE', 'DOWNLOADS_ORDERS_STATUS_UPDATED_VALUE', '100000', 'CD_DOWNLOADS_ORDERS_STATUS_UPDATED_VALUE', 13, 90, NULL, '[[regtime]]', NULL, NULL),
(360, 'CT_DOWNLOADS_CONTROLLER_ORDERS_STATUS', 'DOWNLOADS_CONTROLLER_ORDERS_STATUS', '2', 'CD_DOWNLOADS_CONTROLLER_ORDERS_STATUS', 13, 92, NULL, '[[regtime]]', NULL, NULL),
(378, 'CT_DOWN_FOR_MAINTENANCE', 'DOWN_FOR_MAINTENANCE', 'false', 'CD_DOWN_FOR_MAINTENANCE', 16, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(379, 'CT_DOWN_FOR_MAINTENANCE_FILENAME', 'DOWN_FOR_MAINTENANCE_FILENAME', 'down_for_maintenance.php', 'CD_DOWN_FOR_MAINTENANCE_FILENAME', 16, 2, NULL, '[[regtime]]', NULL, ''),
(380, 'CT_DOWN_FOR_MAINTENANCE_HEADER_OFF', 'DOWN_FOR_MAINTENANCE_HEADER_OFF', 'true', 'CD_DOWN_FOR_MAINTENANCE_HEADER_OFF', 16, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(381, 'CT_DOWN_FOR_MAINTENANCE_COLUMN_LEFT_OFF', 'DOWN_FOR_MAINTENANCE_COLUMN_LEFT_OFF', 'true', 'CD_DOWN_FOR_MAINTENANCE_COLUMN_LEFT_OFF', 16, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(382, 'CT_DOWN_FOR_MAINTENANCE_COLUMN_RIGHT_OFF', 'DOWN_FOR_MAINTENANCE_COLUMN_RIGHT_OFF', 'true', 'CD_DOWN_FOR_MAINTENANCE_COLUMN_RIGHT_OFF', 16, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(383, 'CT_DOWN_FOR_MAINTENANCE_FOOTER_OFF', 'DOWN_FOR_MAINTENANCE_FOOTER_OFF', 'true', 'CD_DOWN_FOR_MAINTENANCE_FOOTER_OFF', 16, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(384, 'CT_DOWN_FOR_MAINTENANCE_PRICES_OFF', 'DOWN_FOR_MAINTENANCE_PRICES_OFF', 'false', 'CD_DOWN_FOR_MAINTENANCE_PRICES_OFF', 16, 7, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(385, 'CT_EXCLUDE_ADMIN_IP_FOR_MAINTENANCE', 'EXCLUDE_ADMIN_IP_FOR_MAINTENANCE', '', 'CD_EXCLUDE_ADMIN_IP_FOR_MAINTENANCE', 16, 8, NULL, '[[regtime]]', NULL, NULL),
(386, 'CT_WARN_BEFORE_DOWN_FOR_MAINTENANCE', 'WARN_BEFORE_DOWN_FOR_MAINTENANCE', 'false', 'CD_WARN_BEFORE_DOWN_FOR_MAINTENANCE', 16, 9, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(387, 'CT_PERIOD_BEFORE_DOWN_FOR_MAINTENANCE', 'PERIOD_BEFORE_DOWN_FOR_MAINTENANCE', '16/05/2003 between the hours of 2-3 PM', 'CD_PERIOD_BEFORE_DOWN_FOR_MAINTENANCE', 16, 10, NULL, '[[regtime]]', NULL, NULL),
(388, 'CT_DISPLAY_MAINTENANCE_TIME', 'DISPLAY_MAINTENANCE_TIME', 'true', 'CD_DISPLAY_MAINTENANCE_TIME', 16, 11, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(389, 'CT_DISPLAY_MAINTENANCE_PERIOD', 'DISPLAY_MAINTENANCE_PERIOD', 'true', 'CD_DISPLAY_MAINTENANCE_PERIOD', 16, 12, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(390, 'CT_TEXT_MAINTENANCE_PERIOD_TIME', 'TEXT_MAINTENANCE_PERIOD_TIME', '2h00', 'CD_TEXT_MAINTENANCE_PERIOD_TIME', 16, 13, NULL, '[[regtime]]', NULL, NULL),
(391, 'CT_TEXT_DATE_TIME', 'TEXT_DATE_TIME', '2008-05-03 14:23:52', 'CD_TEXT_DATE_TIME', 16, 14, NULL, '[[regtime]]', NULL, NULL),
(392, 'CT_DOWN_FOR_MAINTENANCE_INFO_ID', 'DOWN_FOR_MAINTENANCE_INFO_ID', '12', 'CD_DOWN_FOR_MAINTENANCE_INFO_ID', 16, 15, NULL, '[[regtime]]', NULL, NULL),
(455, 'CT_NEW_SIGNUP_GIFT_VOUCHER_AMOUNT', 'NEW_SIGNUP_GIFT_VOUCHER_AMOUNT', '0', 'CD_NEW_SIGNUP_GIFT_VOUCHER_AMOUNT', 1, 24, NULL, '[[regtime]]', NULL, NULL),
(456, 'CT_NEW_SIGNUP_DISCOUNT_COUPON', 'NEW_SIGNUP_DISCOUNT_COUPON', '', 'CD_NEW_SIGNUP_DISCOUNT_COUPON', 1, 25, NULL, '[[regtime]]', NULL, NULL),
(457, 'CT_DIR_WS_TEMPLATES_DEFAULT', 'DIR_WS_TEMPLATES_DEFAULT', 'fallback', 'CD_DIR_WS_TEMPLATES_DEFAULT', 201, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_pull_down_templates('),
(458, 'CT_TEMPLATE_SWITCHING_ALLOWED', 'TEMPLATE_SWITCHING_ALLOWED', 'false', 'CD_TEMPLATE_SWITCHING_ALLOWED', 201, 2, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(459, 'CT_TEMPLATE_SWITCHING_MENU', 'TEMPLATE_SWITCHING_MENU', 'false', 'CD_TEMPLATE_SWITCHING_MENU', 201, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(497, 'CT_IMAGEZOOMER', 'IMAGEZOOMER', 'true', 'CD_IMAGEZOOMER', 47, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(498, 'CT_DYNAMIC_MOPICS_PRODUCTS_DIR', 'DYNAMIC_MOPICS_PRODUCTS_DIR', 'products/', 'CD_DYNAMIC_MOPICS_PRODUCTS_DIR', 45, 0, NULL, '[[regtime]]', NULL, NULL),
(499, 'CT_DYNAMIC_MOPICS_BIGIMAGES_DIR', 'DYNAMIC_MOPICS_BIGIMAGES_DIR', 'images_big/', 'CD_DYNAMIC_MOPICS_BIGIMAGES_DIR', 45, 0, NULL, '[[regtime]]', NULL, NULL),
(500, 'CT_DYNAMIC_MOPICS_THUMBS_DIR', 'DYNAMIC_MOPICS_THUMBS_DIR', 'thumbs/', 'CD_DYNAMIC_MOPICS_THUMBS_DIR', 45, 0, NULL, '[[regtime]]', NULL, NULL),
(502, 'CT_DYNAMIC_MOPICS_PATTERN', 'DYNAMIC_MOPICS_PATTERN', 'imagebase_{1}', 'CD_DYNAMIC_MOPICS_PATTERN', 45, 1, NULL, '[[regtime]]', NULL, NULL),
(503, 'CT_DYNAMIC_MOPICS_THUMB_IMAGE_TYPES', 'DYNAMIC_MOPICS_THUMB_IMAGE_TYPES', 'jpg,gif,jpeg,tiff,png,bmp', 'CD_DYNAMIC_MOPICS_THUMB_IMAGE_TYPES', 45, 0, NULL, '[[regtime]]', NULL, NULL),
(504, 'CT_DYNAMIC_MOPICS_BIG_IMAGE_TYPES', 'DYNAMIC_MOPICS_BIG_IMAGE_TYPES', 'jpg,gif,jpeg,tiff,png,bmp', 'CD_DYNAMIC_MOPICS_BIG_IMAGE_TYPES', 45, 0, NULL, '[[regtime]]', NULL, NULL),
(505, 'CT_DISPLAY_NEW_ARTICLES', 'DISPLAY_NEW_ARTICLES', 'false', 'CD_DISPLAY_NEW_ARTICLES', 456, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(506, 'CT_NEW_ARTICLES_DAYS_DISPLAY', 'NEW_ARTICLES_DAYS_DISPLAY', '30', 'CD_NEW_ARTICLES_DAYS_DISPLAY', 456, 2, NULL, '[[regtime]]', NULL, NULL),
(507, 'CT_MAX_NEW_ARTICLES_PER_PAGE', 'MAX_NEW_ARTICLES_PER_PAGE', '10', 'CD_MAX_NEW_ARTICLES_PER_PAGE', 456, 3, NULL, '[[regtime]]', NULL, NULL),
(508, 'CT_DISPLAY_ALL_ARTICLES', 'DISPLAY_ALL_ARTICLES', 'true', 'CD_DISPLAY_ALL_ARTICLES', 456, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(509, 'CT_MAX_ARTICLES_PER_PAGE', 'MAX_ARTICLES_PER_PAGE', '10', 'CD_MAX_ARTICLES_PER_PAGE', 456, 5, NULL, '[[regtime]]', NULL, NULL),
(510, 'CT_MAX_DISPLAY_UPCOMING_ARTICLES', 'MAX_DISPLAY_UPCOMING_ARTICLES', '5', 'CD_MAX_DISPLAY_UPCOMING_ARTICLES', 456, 6, NULL, '[[regtime]]', NULL, NULL),
(511, 'CT_ENABLE_ARTICLE_REVIEWS', 'ENABLE_ARTICLE_REVIEWS', 'true', 'CD_ENABLE_ARTICLE_REVIEWS', 456, 7, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(512, 'CT_ENABLE_TELL_A_FRIEND_ARTICLE', 'ENABLE_TELL_A_FRIEND_ARTICLE', 'true', 'CD_ENABLE_TELL_A_FRIEND_ARTICLE', 456, 8, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(513, 'CT_MIN_DISPLAY_ARTICLES_XSELL', 'MIN_DISPLAY_ARTICLES_XSELL', '1', 'CD_MIN_DISPLAY_ARTICLES_XSELL', 456, 9, NULL, '[[regtime]]', NULL, NULL),
(514, 'CT_MAX_DISPLAY_ARTICLES_XSELL', 'MAX_DISPLAY_ARTICLES_XSELL', '6', 'CD_MAX_DISPLAY_ARTICLES_XSELL', 456, 10, NULL, '[[regtime]]', NULL, NULL),
(515, 'CT_SHOW_ARTICLE_COUNTS', 'SHOW_ARTICLE_COUNTS', 'true', 'CD_SHOW_ARTICLE_COUNTS', 456, 11, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(516, 'CT_MAX_DISPLAY_AUTHOR_NAME_LEN', 'MAX_DISPLAY_AUTHOR_NAME_LEN', '20', 'CD_MAX_DISPLAY_AUTHOR_NAME_LEN', 456, 12, NULL, '[[regtime]]', NULL, NULL),
(517, 'CT_MAX_DISPLAY_AUTHORS_IN_A_LIST', 'MAX_DISPLAY_AUTHORS_IN_A_LIST', '1', 'CD_MAX_DISPLAY_AUTHORS_IN_A_LIST', 456, 13, NULL, '[[regtime]]', NULL, NULL),
(518, 'CT_MAX_AUTHORS_LIST', 'MAX_AUTHORS_LIST', '1', 'CD_MAX_AUTHORS_LIST', 456, 14, NULL, '[[regtime]]', NULL, NULL),
(519, 'CT_DISPLAY_AUTHOR_ARTICLE_LISTING', 'DISPLAY_AUTHOR_ARTICLE_LISTING', 'true', 'CD_DISPLAY_AUTHOR_ARTICLE_LISTING', 456, 15, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(520, 'CT_DISPLAY_TOPIC_ARTICLE_LISTING', 'DISPLAY_TOPIC_ARTICLE_LISTING', 'true', 'CD_DISPLAY_TOPIC_ARTICLE_LISTING', 456, 16, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(521, 'CT_DISPLAY_ABSTRACT_ARTICLE_LISTING', 'DISPLAY_ABSTRACT_ARTICLE_LISTING', 'true', 'CD_DISPLAY_ABSTRACT_ARTICLE_LISTING', 456, 17, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(522, 'CT_DISPLAY_DATE_ADDED_ARTICLE_LISTING', 'DISPLAY_DATE_ADDED_ARTICLE_LISTING', 'true', 'CD_DISPLAY_DATE_ADDED_ARTICLE_LISTING', 456, 18, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(523, 'CT_MAX_ARTICLE_ABSTRACT_LENGTH', 'MAX_ARTICLE_ABSTRACT_LENGTH', '300', 'CD_MAX_ARTICLE_ABSTRACT_LENGTH', 456, 19, NULL, '[[regtime]]', NULL, NULL),
(524, 'CT_ARTICLE_LIST_FILTER', 'ARTICLE_LIST_FILTER', 'true', 'CD_ARTICLE_LIST_FILTER', 456, 20, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(525, 'CT_ARTICLE_PREV_NEXT_BAR_LOCATION', 'ARTICLE_PREV_NEXT_BAR_LOCATION', 'bottom', 'CD_ARTICLE_PREV_NEXT_BAR_LOCATION', 456, 21, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''top'',''bottom'',''both''),'),
(526, 'CT_ARTICLE_WYSIWYG_ENABLE', 'ARTICLE_WYSIWYG_ENABLE', 'Enable', 'CD_ARTICLE_WYSIWYG_ENABLE', 456, 22, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''Enable'',''Disable''),'),
(589, 'CT_PRODINFO_ATTRIBUTE_PLUGIN', 'PRODINFO_ATTRIBUTE_PLUGIN', 'multiple_dropdowns', 'CD_PRODINFO_ATTRIBUTE_PLUGIN', 50, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_pull_down_class_files(''pad_'','),
(590, 'CT_PRODINFO_ATTRIBUTE_SHOW_OUT_OF_STOCK', 'PRODINFO_ATTRIBUTE_SHOW_OUT_OF_STOCK', 'True', 'CD_PRODINFO_ATTRIBUTE_SHOW_OUT_OF_STOCK', 50, 10, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(591, 'CT_PRODINFO_ATTRIBUTE_MARK_OUT_OF_STOCK', 'PRODINFO_ATTRIBUTE_MARK_OUT_OF_STOCK', 'Right', 'CD_PRODINFO_ATTRIBUTE_MARK_OUT_OF_STOCK', 50, 20, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''None'',''Right'',''Left''),'),
(592, 'CT_PRODINFO_ATTRIBUTE_OUT_OF_STOCK_MSGLINE', 'PRODINFO_ATTRIBUTE_OUT_OF_STOCK_MSGLINE', 'False', 'CD_PRODINFO_ATTRIBUTE_OUT_OF_STOCK_MSGLINE', 50, 30, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(593, 'CT_PRODINFO_ATTRIBUTE_NO_ADD_OUT_OF_STOCK', 'PRODINFO_ATTRIBUTE_NO_ADD_OUT_OF_STOCK', 'True', 'CD_PRODINFO_ATTRIBUTE_NO_ADD_OUT_OF_STOCK', 9, 8, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(594, 'CT_PRODINFO_ATTRIBUTE_DISPLAY_STOCK_LIST', 'PRODINFO_ATTRIBUTE_DISPLAY_STOCK_LIST', 'true', 'CD_PRODINFO_ATTRIBUTE_DISPLAY_STOCK_LIST', 9, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(595, 'CT_PRODUCT_IMAGE_WIDTH', 'PRODUCT_IMAGE_WIDTH', '300', 'CD_PRODUCT_IMAGE_WIDTH', 4, 20, NULL, '[[regtime]]', NULL, NULL),
(596, 'CT_PRODUCT_IMAGE_HEIGHT', 'PRODUCT_IMAGE_HEIGHT', '', 'CD_PRODUCT_IMAGE_HEIGHT', 4, 21, NULL, '[[regtime]]', NULL, NULL),
(597, 'CT_POPUP_IMAGE_WIDTH', 'POPUP_IMAGE_WIDTH', '800', 'CD_POPUP_IMAGE_WIDTH', 4, 24, NULL, '[[regtime]]', NULL, NULL),
(598, 'CT_POPUP_IMAGE_HEIGHT', 'POPUP_IMAGE_HEIGHT', '600', 'CD_POPUP_IMAGE_HEIGHT', 4, 25, NULL, '[[regtime]]', NULL, NULL),
(599, 'CT_CATEGORY_IMAGES_DIR', 'CATEGORY_IMAGES_DIR', 'categories/', 'CD_CATEGORY_IMAGES_DIR', 45, 0, NULL, '[[regtime]]', NULL, NULL),
(600, 'CT_POPUP_IMAGE_RESIZE', 'POPUP_IMAGE_RESIZE', 'true', 'CD_POPUP_IMAGE_RESIZE', 4, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(601, 'CT_SMALL_IMAGE_COMPRESSION', 'SMALL_IMAGE_COMPRESSION', '75', 'CD_SMALL_IMAGE_COMPRESSION', 4, 7, NULL, '[[regtime]]', NULL, NULL),
(602, 'CT_SUBCATEGORY_IMAGE_COMPRESSION', 'SUBCATEGORY_IMAGE_COMPRESSION', '75', 'CD_SUBCATEGORY_IMAGE_COMPRESSION', 4, 12, NULL, '[[regtime]]', NULL, NULL),
(603, 'CT_PRODUCT_IMAGE_COMPRESSION', 'PRODUCT_IMAGE_COMPRESSION', '80', 'CD_PRODUCT_IMAGE_COMPRESSION', 4, 22, NULL, '[[regtime]]', NULL, NULL),
(604, 'CT_POPUP_IMAGE_COMPRESSION', 'POPUP_IMAGE_COMPRESSION', '85', 'CD_POPUP_IMAGE_COMPRESSION', 4, 26, NULL, '[[regtime]]', NULL, NULL),
(631, 'CT_MODULE_LOYALTY_DISCOUNT_STATUS', 'MODULE_LOYALTY_DISCOUNT_STATUS', 'false', 'CD_MODULE_LOYALTY_DISCOUNT_STATUS', 6, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(632, 'CT_MODULE_LOYALTY_DISCOUNT_SORT_ORDER', 'MODULE_LOYALTY_DISCOUNT_SORT_ORDER', '5', 'CD_MODULE_LOYALTY_DISCOUNT_SORT_ORDER', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(633, 'CT_MODULE_LOYALTY_DISCOUNT_INC_SHIPPING', 'MODULE_LOYALTY_DISCOUNT_INC_SHIPPING', 'true', 'CD_MODULE_LOYALTY_DISCOUNT_INC_SHIPPING', 6, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(634, 'CT_MODULE_LOYALTY_DISCOUNT_INC_TAX', 'MODULE_LOYALTY_DISCOUNT_INC_TAX', 'true', 'CD_MODULE_LOYALTY_DISCOUNT_INC_TAX', 6, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(635, 'CT_MODULE_LOYALTY_DISCOUNT_CALC_TAX', 'MODULE_LOYALTY_DISCOUNT_CALC_TAX', 'false', 'CD_MODULE_LOYALTY_DISCOUNT_CALC_TAX', 6, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(636, 'CT_MODULE_LOYALTY_DISCOUNT_CUMORDER_PERIOD', 'MODULE_LOYALTY_DISCOUNT_CUMORDER_PERIOD', 'year', 'CD_MODULE_LOYALTY_DISCOUNT_CUMORDER_PERIOD', 6, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''alltime'',''year'',''quarter'',''month''),'),
(637, 'CT_MODULE_LOYALTY_DISCOUNT_TABLE', 'MODULE_LOYALTY_DISCOUNT_TABLE', '1000:5,1500:7.5,2000:10,3000:12.5,5000:15', 'CD_MODULE_LOYALTY_DISCOUNT_TABLE', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(638, 'CT_MODULE_LOYALTY_DISCOUNT_ORDER_STATUS', 'MODULE_LOYALTY_DISCOUNT_ORDER_STATUS', '3', 'CD_MODULE_LOYALTY_DISCOUNT_ORDER_STATUS', 6, 8, NULL, '[[regtime]]', NULL, NULL),
(639, 'CT_MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS', 'MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS', 'true', 'CD_MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS', 6, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(640, 'CT_MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER', 'MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER', '3', 'CD_MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(641, 'CT_MODULE_ORDER_TOTAL_LOWORDERFEE_LOW_ORDER_FEE', 'MODULE_ORDER_TOTAL_LOWORDERFEE_LOW_ORDER_FEE', 'false', 'CD_MODULE_ORDER_TOTAL_LOWORDERFEE_LOW_ORDER_FEE', 6, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(642, 'CT_MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER', 'MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER', '50', 'CD_MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER', 6, 4, NULL, '[[regtime]]', 'currencies->format', NULL),
(643, 'CT_MODULE_ORDER_TOTAL_LOWORDERFEE_FEE', 'MODULE_ORDER_TOTAL_LOWORDERFEE_FEE', '5', 'CD_MODULE_ORDER_TOTAL_LOWORDERFEE_FEE', 6, 5, NULL, '[[regtime]]', 'currencies->format', NULL),
(644, 'CT_MODULE_ORDER_TOTAL_LOWORDERFEE_DESTINATION', 'MODULE_ORDER_TOTAL_LOWORDERFEE_DESTINATION', 'both', 'CD_MODULE_ORDER_TOTAL_LOWORDERFEE_DESTINATION', 6, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''national'',''international'',''both''),'),
(645, 'CT_MODULE_ORDER_TOTAL_LOWORDERFEE_TAX_CLASS', 'MODULE_ORDER_TOTAL_LOWORDERFEE_TAX_CLASS', '0', 'CD_MODULE_ORDER_TOTAL_LOWORDERFEE_TAX_CLASS', 6, 7, NULL, '[[regtime]]', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes('),
(646, 'CT_INDEX_TAB', 'INDEX_TAB', '6', 'CD_INDEX_TAB', 6, 100, NULL, '[[regtime]]', NULL, NULL),
(650, 'CT_PRODUCT_LIST_TYPE', 'PRODUCT_LIST_TYPE', '1', 'CD_PRODUCT_LIST_TYPE', 8, 11, NULL, '[[regtime]]', NULL, NULL),
(700, 'CT_PRODUCT_LIST_NUM_COLUMNS', 'PRODUCT_LIST_NUM_COLUMNS', '3', 'CD_PRODUCT_LIST_NUM_COLUMNS', 8, 14, NULL, '[[regtime]]', NULL, NULL),
(701, 'CT_MIN_DISPLAY_XSELL', 'MIN_DISPLAY_XSELL', '1', 'CD_MIN_DISPLAY_XSELL', 8, 20, NULL, '[[regtime]]', NULL, NULL),
(729, 'CT_PRODUCT_LIST_ENABLE', 'PRODUCT_LIST_ENABLE', 'true', 'CD_PRODUCT_LIST_ENABLE', 30, 0, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(730, 'CT_PRODUCT_LIST_CUSTOMER_DISCOUNT', 'PRODUCT_LIST_CUSTOMER_DISCOUNT', 'show', 'CD_PRODUCT_LIST_CUSTOMER_DISCOUNT', 30, 0, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(731, 'CT_PRODUCT_LIST_PAGEBREAK_NUMBERS_PERPAGE', 'PRODUCT_LIST_PAGEBREAK_NUMBERS_PERPAGE', '10', 'CD_PRODUCT_LIST_PAGEBREAK_NUMBERS_PERPAGE', 30, 2, NULL, '[[regtime]]', NULL, NULL),
(732, 'CT_PRODUCT_LIST_CATALOG_PERPAGE', 'PRODUCT_LIST_CATALOG_PERPAGE', '10', 'CD_PRODUCT_LIST_CATALOG_PERPAGE', 30, 3, NULL, '[[regtime]]', NULL, NULL),
(733, 'CT_PRODUCT_LIST_DESCRIPTION_LENGTH', 'PRODUCT_LIST_DESCRIPTION_LENGTH', '400', 'CD_PRODUCT_LIST_DESCRIPTION_LENGTH', 30, 4, NULL, '[[regtime]]', NULL, NULL),
(734, 'CT_PRODUCT_LIST_CATALOG_IMAGE', 'PRODUCT_LIST_CATALOG_IMAGE', 'show', 'CD_PRODUCT_LIST_CATALOG_IMAGE', 30, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(735, 'CT_PRODUCT_LIST_CATALOG_IMAGE_FULL', 'PRODUCT_LIST_CATALOG_IMAGE_FULL', 'hide', 'CD_PRODUCT_LIST_CATALOG_IMAGE_FULL', 30, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(736, 'CT_PRODUCT_LIST_CATALOG_OPTIONS', 'PRODUCT_LIST_CATALOG_OPTIONS', 'hide', 'CD_PRODUCT_LIST_CATALOG_OPTIONS', 30, 7, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(737, 'CT_PRODUCT_LIST_CATALOG_NAME', 'PRODUCT_LIST_CATALOG_NAME', 'show', 'CD_PRODUCT_LIST_CATALOG_NAME', 30, 8, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(738, 'CT_PRODUCT_LIST_CATALOG_MANUFACTURERS', 'PRODUCT_LIST_CATALOG_MANUFACTURERS', 'hide', 'CD_PRODUCT_LIST_CATALOG_MANUFACTURERS', 30, 9, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(739, 'CT_PRODUCT_LIST_CATALOG_DESCRIPTION', 'PRODUCT_LIST_CATALOG_DESCRIPTION', 'hide', 'CD_PRODUCT_LIST_CATALOG_DESCRIPTION', 30, 10, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(740, 'CT_PRODUCT_LIST_CATALOG_CATEGORIES', 'PRODUCT_LIST_CATALOG_CATEGORIES', 'show', 'CD_PRODUCT_LIST_CATALOG_CATEGORIES', 30, 11, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(741, 'CT_PRODUCT_LIST_CATALOG_MODEL', 'PRODUCT_LIST_CATALOG_MODEL', 'show', 'CD_PRODUCT_LIST_CATALOG_MODEL', 30, 12, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(742, 'CT_PRODUCT_LIST_CATALOG_UPC', 'PRODUCT_LIST_CATALOG_UPC', 'hide', 'CD_PRODUCT_LIST_CATALOG_UPC', 30, 13, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(743, 'CT_PRODUCT_LIST_CATALOG_QUANTITY', 'PRODUCT_LIST_CATALOG_QUANTITY', 'hide', 'CD_PRODUCT_LIST_CATALOG_QUANTITY', 30, 14, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(744, 'CT_PRODUCT_LIST_CATALOG_WEIGHT', 'PRODUCT_LIST_CATALOG_WEIGHT', 'hide', 'CD_PRODUCT_LIST_CATALOG_WEIGHT', 30, 15, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(745, 'CT_PRODUCT_LIST_CATALOG_PRICE', 'PRODUCT_LIST_CATALOG_PRICE', 'show', 'CD_PRODUCT_LIST_CATALOG_PRICE', 30, 16, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(746, 'CT_PRODUCT_LIST_CATALOG_DATE', 'PRODUCT_LIST_CATALOG_DATE', 'hide', 'CD_PRODUCT_LIST_CATALOG_DATE', 30, 17, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(747, 'CT_PRODUCT_LIST_CATALOG_DATE_SHOW', 'PRODUCT_LIST_CATALOG_DATE_SHOW', 'hide', 'CD_PRODUCT_LIST_CATALOG_DATE_SHOW', 30, 18, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(748, 'CT_PRODUCT_LIST_CATALOG_CURRENCY', 'PRODUCT_LIST_CATALOG_CURRENCY', 'hide', 'CD_PRODUCT_LIST_CATALOG_CURRENCY', 30, 19, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''show'',''hide''),'),
(774, 'CT_ENABLE_PAGE_CACHE', 'ENABLE_PAGE_CACHE', 'false', 'CD_ENABLE_PAGE_CACHE', 55, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(775, 'CT_PAGE_CACHE_LIFETIME', 'PAGE_CACHE_LIFETIME', '5', 'CD_PAGE_CACHE_LIFETIME', 55, 2, NULL, '[[regtime]]', NULL, NULL),
(776, 'CT_PAGE_CACHE_DEBUG_MODE', 'PAGE_CACHE_DEBUG_MODE', 'false', 'CD_PAGE_CACHE_DEBUG_MODE', 55, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(777, 'CT_PAGE_CACHE_DISABLE_PARAMETERS', 'PAGE_CACHE_DISABLE_PARAMETERS', 'false', 'CD_PAGE_CACHE_DISABLE_PARAMETERS', 55, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(778, 'CT_PAGE_CACHE_DELETE_FILES', 'PAGE_CACHE_DELETE_FILES', 'true', 'CD_PAGE_CACHE_DELETE_FILES', 55, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(779, 'CT_PAGE_CACHE_UPDATE_CONFIG_FILES', 'PAGE_CACHE_UPDATE_CONFIG_FILES', 'none', 'CD_PAGE_CACHE_UPDATE_CONFIG_FILES', 55, 6, NULL, '[[regtime]]', NULL, NULL),
(1073, 'CT_MOVE_TAX_TO_TOTAL_AMOUNT', 'MOVE_TAX_TO_TOTAL_AMOUNT', 'True', 'CD_MOVE_TAX_TO_TOTAL_AMOUNT', 6, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''True'', ''False''), '),
(1150, 'CT_SLIMBOX_LOOP', 'SLIMBOX_LOOP', 'false', 'CD_SLIMBOX_LOOP', 46, 30, NULL, '[[regtime]]', NULL, NULL),
(1151, 'CT_SLIMBOX_OPACITY', 'SLIMBOX_OPACITY', '0.8', 'CD_SLIMBOX_OPACITY', 46, 31, NULL, '[[regtime]]', NULL, NULL),
(1152, 'CT_SLIMBOX_FADE', 'SLIMBOX_FADE', '400', 'CD_SLIMBOX_FADE', 46, 32, NULL, '[[regtime]]', NULL, NULL),
(1153, 'CT_SLIMBOX_RESIZE', 'SLIMBOX_RESIZE', '400', 'CD_SLIMBOX_RESIZE', 46, 33, NULL, '[[regtime]]', NULL, NULL),
(1154, 'CT_SLIMBOX_EASING', 'SLIMBOX_EASING', '"swing"', 'CD_SLIMBOX_EASING', 46, 34, NULL, '[[regtime]]', NULL, NULL),
(1155, 'CT_SLIMBOX_WIDTH', 'SLIMBOX_WIDTH', '100', 'CD_SLIMBOX_WIDTH', 46, 35, NULL, '[[regtime]]', NULL, NULL),
(1156, 'CT_SLIMBOX_HEIGHT', 'SLIMBOX_HEIGHT', '100', 'CD_SLIMBOX_HEIGHT', 46, 36, NULL, '[[regtime]]', NULL, NULL),
(1157, 'CT_SLIMBOX_IMAGE', 'SLIMBOX_IMAGE', '400', 'CD_SLIMBOX_IMAGE', 46, 37, NULL, '[[regtime]]', NULL, NULL),
(1158, 'CT_SLIMBOX_CAPTION', 'SLIMBOX_CAPTION', '400', 'CD_SLIMBOX_CAPTION', 46, 38, NULL, '[[regtime]]', NULL, NULL),
(1159, 'CT_SLIMBOX_COUNTER', 'SLIMBOX_COUNTER', '"Image {x} of {y}"', 'CD_SLIMBOX_COUNTER', 46, 39, NULL, '[[regtime]]', NULL, NULL),
(1204, 'CT_AFFILIATE_EMAIL_ADDRESS', 'AFFILIATE_EMAIL_ADDRESS', '<affiliate@localhost.com>', 'CD_AFFILIATE_EMAIL_ADDRESS', 35, 1, NULL, '[[regtime]]', NULL, NULL),
(1205, 'CT_AFFILIATE_PERCENT', 'AFFILIATE_PERCENT', '10.0000', 'CD_AFFILIATE_PERCENT', 35, 2, NULL, '[[regtime]]', NULL, NULL),
(1206, 'CT_AFFILIATE_THRESHOLD', 'AFFILIATE_THRESHOLD', '50.00', 'CD_AFFILIATE_THRESHOLD', 35, 3, NULL, '[[regtime]]', NULL, NULL),
(1207, 'CT_AFFILIATE_COOKIE_LIFETIME', 'AFFILIATE_COOKIE_LIFETIME', '7200', 'CD_AFFILIATE_COOKIE_LIFETIME', 35, 4, NULL, '[[regtime]]', NULL, NULL),
(1208, 'CT_AFFILIATE_BILLING_TIME', 'AFFILIATE_BILLING_TIME', '30', 'CD_AFFILIATE_BILLING_TIME', 35, 5, NULL, '[[regtime]]', NULL, NULL),
(1209, 'CT_AFFILIATE_PAYMENT_ORDER_MIN_STATUS', 'AFFILIATE_PAYMENT_ORDER_MIN_STATUS', '3', 'CD_AFFILIATE_PAYMENT_ORDER_MIN_STATUS', 35, 6, NULL, '[[regtime]]', NULL, NULL),
(1210, 'CT_AFFILIATE_USE_CHECK', 'AFFILIATE_USE_CHECK', 'true', 'CD_AFFILIATE_USE_CHECK', 35, 7, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(1211, 'CT_AFFILIATE_USE_PAYPAL', 'AFFILIATE_USE_PAYPAL', 'true', 'CD_AFFILIATE_USE_PAYPAL', 35, 8, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(1212, 'CT_AFFILIATE_USE_BANK', 'AFFILIATE_USE_BANK', 'true', 'CD_AFFILIATE_USE_BANK', 35, 9, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(1213, 'CT_AFFILATE_INDIVIDUAL_PERCENTAGE', 'AFFILATE_INDIVIDUAL_PERCENTAGE', 'true', 'CD_AFFILATE_INDIVIDUAL_PERCENTAGE', 35, 10, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(1214, 'CT_AFFILATE_USE_TIER', 'AFFILATE_USE_TIER', 'false', 'CD_AFFILATE_USE_TIER', 35, 11, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO `configuration` VALUES
(1215, 'CT_AFFILIATE_TIER_LEVELS', 'AFFILIATE_TIER_LEVELS', '0', 'CD_AFFILIATE_TIER_LEVELS', 35, 12, NULL, '[[regtime]]', NULL, NULL),
(1216, 'CT_AFFILIATE_TIER_PERCENTAGE', 'AFFILIATE_TIER_PERCENTAGE', '8.00;5.00;1.00', 'CD_AFFILIATE_TIER_PERCENTAGE', 35, 13, NULL, '[[regtime]]', NULL, NULL),
(1217, 'CT_MAX_DISPLAY_AFFILIATE_NEWS', 'MAX_DISPLAY_AFFILIATE_NEWS', '3', 'CD_MAX_DISPLAY_AFFILIATE_NEWS', 35, 14, NULL, '[[regtime]]', NULL, NULL),
(1218, 'CT_AFFILIATE_NOTIFY_AFTER_BILLING', 'AFFILIATE_NOTIFY_AFTER_BILLING', 'true', 'CD_AFFILIATE_NOTIFY_AFTER_BILLING', 35, 15, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(1219, 'CT_AFFILIATE_DELETE_ORDERS', 'AFFILIATE_DELETE_ORDERS', 'true', 'CD_AFFILIATE_DELETE_ORDERS', 35, 16, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(1220, 'CT_AFFILIATE_TAX_ID', 'AFFILIATE_TAX_ID', '1', 'CD_AFFILIATE_TAX_ID', 35, 17, NULL, '[[regtime]]', NULL, NULL),
(1221, 'CT_AFFILIATE_DELETE_CLICKTHROUGHS', 'AFFILIATE_DELETE_CLICKTHROUGHS', 'false', 'CD_AFFILIATE_DELETE_CLICKTHROUGHS', 35, 18, NULL, '[[regtime]]', NULL, NULL),
(1222, 'CT_AFFILIATE_DELETE_AFFILIATE_BANNER_HISTORY', 'AFFILIATE_DELETE_AFFILIATE_BANNER_HISTORY', 'false', 'CD_AFFILIATE_DELETE_AFFILIATE_BANNER_HISTORY', 35, 19, NULL, '[[regtime]]', NULL, NULL),
(1223, 'CT_AFFILIATE_KIND_OF_BANNERS', 'AFFILIATE_KIND_OF_BANNERS', '2', 'CD_AFFILIATE_KIND_OF_BANNERS', 35, 20, NULL, '[[regtime]]', NULL, NULL),
(1224, 'CT_AFFILIATE_SHOW_BANNERS_DEBUG', 'AFFILIATE_SHOW_BANNERS_DEBUG', 'false', 'CD_AFFILIATE_SHOW_BANNERS_DEBUG', 35, 21, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(1225, 'CT_AFFILIATE_SHOW_BANNERS_DEFAULT_PIC', 'AFFILIATE_SHOW_BANNERS_DEFAULT_PIC', 'DIR_WS_IMAGES', 'CD_AFFILIATE_SHOW_BANNERS_DEFAULT_PIC', 35, 21, NULL, '[[regtime]]', NULL, NULL),
(1291, 'CT_MAX_DISPLAY_WISHLIST_PRODUCTS', 'MAX_DISPLAY_WISHLIST_PRODUCTS', '12', 'CD_MAX_DISPLAY_WISHLIST_PRODUCTS', 65, 0, NULL, '[[regtime]]', NULL, NULL),
(1292, 'CT_MAX_DISPLAY_WISHLIST_BOX', 'MAX_DISPLAY_WISHLIST_BOX', '4', 'CD_MAX_DISPLAY_WISHLIST_BOX', 65, 0, NULL, '[[regtime]]', NULL, NULL),
(1293, 'CT_DISPLAY_WISHLIST_EMAILS', 'DISPLAY_WISHLIST_EMAILS', '3', 'CD_DISPLAY_WISHLIST_EMAILS', 65, 0, NULL, '[[regtime]]', NULL, NULL),
(1294, 'CT_WISHLIST_REDIRECT', 'WISHLIST_REDIRECT', 'No', 'CD_WISHLIST_REDIRECT', 65, 0, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''Yes'',''No''),'),
(1304, 'CT_ORDER_EDITOR_PAYMENT_DROPDOWN', 'ORDER_EDITOR_PAYMENT_DROPDOWN', 'true', 'CD_ORDER_EDITOR_PAYMENT_DROPDOWN', 70, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(1305, 'CT_ORDER_EDITOR_USE_SPPC', 'ORDER_EDITOR_USE_SPPC', 'true', 'CD_ORDER_EDITOR_USE_SPPC', 70, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(1306, 'CT_ORDER_EDITOR_USE_AJAX', 'ORDER_EDITOR_USE_AJAX', 'true', 'CD_ORDER_EDITOR_USE_AJAX', 70, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(1307, 'CT_ORDER_EDITOR_CREDIT_CARD', 'ORDER_EDITOR_CREDIT_CARD', 'Credit Card', 'CD_ORDER_EDITOR_CREDIT_CARD', 70, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_pull_down_payment_methods('),
(1308, 'CT_ORDER_EDITOR_DEFAULT_PAYMENT_METHOD', 'ORDER_EDITOR_DEFAULT_PAYMENT_METHOD', 'Please Select...', 'CD_ORDER_EDITOR_CREDIT_CARD', 70, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_pull_down_payment_methods('),
(1449, 'CT_PURCHASE_WITHOUT_ACCOUNT', 'PURCHASE_WITHOUT_ACCOUNT', 'no', 'CD_PURCHASE_WITHOUT_ACCOUNT', 5, 10, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''yes'',''no''),'),
(1450, 'CT_PURCHASE_WITHOUT_ACCOUNT_SEPARATE_SHIPPING', 'PURCHASE_WITHOUT_ACCOUNT_SEPARATE_SHIPPING', 'yes', 'CD_PURCHASE_WITHOUT_ACCOUNT_SEPARATE_SHIPPING', 5, 11, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''yes'',''no''),'),
(1487, 'CT_SHIPPING_DIMENSIONS_SUPPORT', 'SHIPPING_DIMENSIONS_SUPPORT', 'No', 'CD_SHIPPING_DIMENSIONS_SUPPORT', 7, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''No'', ''Ready-to-ship only'', ''With product dimensions''), '),
(1488, 'CT_SHIPPING_UNIT_WEIGHT', 'SHIPPING_UNIT_WEIGHT', 'LBS', 'CD_SHIPPING_UNIT_WEIGHT', 7, 7, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''LBS'', ''KGS''), '),
(1489, 'CT_SHIPPING_UNIT_LENGTH', 'SHIPPING_UNIT_LENGTH', 'IN', 'CD_SHIPPING_UNIT_LENGTH', 7, 8, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''IN'', ''CM''), '),
(1490, 'CT_SHIPPING_STORE_BOXES_USED', 'SHIPPING_STORE_BOXES_USED', 'false', 'CD_SHIPPING_STORE_BOXES_USED', 7, 9, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''), '),
(1491, 'CT_RCS_BASE_DAYS', 'RCS_BASE_DAYS', '30', 'CD_RCS_BASE_DAYS', 80, 10, NULL, '[[regtime]]', '', ''),
(1492, 'CT_RCS_SKIP_DAYS', 'RCS_SKIP_DAYS', '5', 'CD_RCS_SKIP_DAYS', 80, 11, NULL, '[[regtime]]', '', ''),
(1493, 'CT_RCS_REPORT_DAYS', 'RCS_REPORT_DAYS', '90', 'CD_RCS_REPORT_DAYS', 80, 15, NULL, '[[regtime]]', '', ''),
(1494, 'CT_RCS_INCLUDE_TAX_IN_PRICES', 'RCS_INCLUDE_TAX_IN_PRICES', 'false', 'CD_RCS_INCLUDE_TAX_IN_PRICES', 80, 16, NULL, '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1495, 'CT_RCS_USE_FIXED_TAX_IN_PRICES', 'RCS_USE_FIXED_TAX_IN_PRICES', 'false', 'CD_RCS_USE_FIXED_TAX_IN_PRICES', 80, 17, NULL, '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1496, 'CT_RCS_FIXED_TAX_RATE', 'RCS_FIXED_TAX_RATE', '10.00', 'CD_RCS_FIXED_TAX_RATE', 80, 18, NULL, '[[regtime]]', '', ''),
(1497, 'CT_RCS_EMAIL_TTL', 'RCS_EMAIL_TTL', '90', 'CD_RCS_EMAIL_TTL', 80, 20, NULL, '[[regtime]]', '', ''),
(1498, 'CT_RCS_EMAIL_FRIENDLY', 'RCS_EMAIL_FRIENDLY', 'true', 'CD_RCS_EMAIL_FRIENDLY', 80, 30, NULL, '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1499, 'CT_RCS_EMAIL_COPIES_TO', 'RCS_EMAIL_COPIES_TO', '', 'CD_RCS_EMAIL_COPIES_TO', 80, 35, NULL, '[[regtime]]', '', ''),
(1500, 'CT_RCS_SHOW_ATTRIBUTES', 'RCS_SHOW_ATTRIBUTES', 'false', 'CD_RCS_SHOW_ATTRIBUTES', 80, 40, NULL, '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1501, 'CT_RCS_CHECK_SESSIONS', 'RCS_CHECK_SESSIONS', 'false', 'CD_RCS_CHECK_SESSIONS', 80, 40, NULL, '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1502, 'CT_RCS_CURCUST_COLOR', 'RCS_CURCUST_COLOR', '0000FF', 'CD_RCS_CURCUST_COLOR', 80, 50, NULL, '[[regtime]]', '', ''),
(1503, 'CT_RCS_UNCONTACTED_COLOR', 'RCS_UNCONTACTED_COLOR', '9FFF9F', 'CD_RCS_UNCONTACTED_COLOR', 80, 60, NULL, '[[regtime]]', '', ''),
(1504, 'CT_RCS_CONTACTED_COLOR', 'RCS_CONTACTED_COLOR', 'FF9F9F', 'CD_RCS_CONTACTED_COLOR', 80, 70, NULL, '[[regtime]]', '', ''),
(1505, 'CT_RCS_MATCHED_ORDER_COLOR', 'RCS_MATCHED_ORDER_COLOR', '9FFFFF', 'CD_RCS_MATCHED_ORDER_COLOR', 80, 72, NULL, '[[regtime]]', '', ''),
(1506, 'CT_RCS_SKIP_MATCHED_CARTS', 'RCS_SKIP_MATCHED_CARTS', 'true', 'CD_RCS_SKIP_MATCHED_CARTS', 80, 80, NULL, '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1507, 'CT_RCS_AUTO_CHECK', 'RCS_AUTO_CHECK', 'true', 'CD_RCS_AUTO_CHECK', 80, 82, NULL, '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1508, 'CT_RCS_CARTS_MATCH_ALL_DATES', 'RCS_CARTS_MATCH_ALL_DATES', 'true', 'CD_RCS_CARTS_MATCH_ALL_DATES', 80, 84, NULL, '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1509, 'CT_RCS_PENDING_SALE_STATUS', 'RCS_PENDING_SALE_STATUS', '1', 'CD_RCS_PENDING_SALE_STATUS', 80, 85, NULL, '[[regtime]]', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses('),
(1510, 'CT_RCS_REPORT_EVEN_STYLE', 'RCS_REPORT_EVEN_STYLE', 'dataTableRow', 'CD_RCS_REPORT_EVEN_STYLE', 80, 90, NULL, '[[regtime]]', '', ''),
(1511, 'CT_RCS_REPORT_ODD_STYLE', 'RCS_REPORT_ODD_STYLE', '', 'CD_RCS_REPORT_ODD_STYLE', 80, 92, NULL, '[[regtime]]', '', ''),
(1999, 'CT_SHOW_SITEMAP', 'SHOW_SITEMAP', 'true', 'CD_SHOW_SITEMAP', 86, 5, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2100, 'CT_GOOGLE_ANALYTICS_STATUS', 'GOOGLE_ANALYTICS_STATUS', 'false', 'CD_GOOGLE_ANALYTICS_STATUS', 85, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2101, 'CT_GOOGLE_UA_CODE', 'GOOGLE_UA_CODE', 'UA-XXXXXXX-X', 'CD_GOOGLE_UA_CODE', 85, 2, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_textarea('),
(2102, 'CT_GOOGLE_SUBDOMAIN', 'GOOGLE_SUBDOMAIN', 'none', 'CD_GOOGLE_SUBDOMAIN', 85, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_textarea('),
(2103, 'CT_PRODUCT_IMAGE_REPLACE', 'PRODUCT_IMAGE_REPLACE', 'true', 'CD_PRODUCT_IMAGE_REPLACE', 4, 2, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2500, 'CT_USE_PRODUCT_DESCRIPTION_TABS', 'USE_PRODUCT_DESCRIPTION_TABS', 'True', 'CD_USE_PRODUCT_DESCRIPTION_TABS', 8, 20, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''True'', ''False''),'),
(2501, 'CT_FWR_SUCKERTREE_MENU_ON', 'FWR_SUCKERTREE_MENU_ON', 'false', 'CD_FWR_SUCKERTREE_MENU_ON', 86, 1, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2502, 'CT_FWR_MENU_ORDER_BY', 'FWR_MENU_ORDER_BY', 'c.categories_id', 'CD_FWR_MENU_ORDER_BY', 86, 2, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''c.categories_id'', ''c.sort_order''),'),
(2503, 'CT_FWR_MENU_CACHE_PATH', 'FWR_MENU_CACHE_PATH', 'DIR_FS_CACHE', 'CD_FWR_MENU_CACHE_PATH', 86, 3, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''DIR_FS_CACHE'', ''false''),'),
(2504, 'CT_FWR_MENU_RESET', 'FWR_MENU_RESET', 'false', 'CD_FWR_MENU_RESET', 86, 4, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2505, 'CT_RECAPTCHA_ON', 'RECAPTCHA_ON', 'false', 'CD_RECAPTCHA_ON', 87, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2506, 'CT_RECAPTCHA_PUBLIC_KEY', 'RECAPTCHA_PUBLIC_KEY', '', 'CD_RECAPTCHA_PUBLIC_KEY', 87, 3, NULL, '[[regtime]]', NULL, NULL),
(2507, 'CT_RECAPTCHA_PRIVATE_KEY', 'RECAPTCHA_PRIVATE_KEY', '', 'CD_RECAPTCHA_PRIVATE_KEY', 87, 4, NULL, '[[regtime]]', NULL, NULL),
(2508, 'CT_STOCK_IMAGE_SWITCH', 'STOCK_IMAGE_SWITCH', 'true', 'CD_STOCK_IMAGE_SWITCH', 9, 7, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2509, 'CT_PRICE_BREAK_NOF_LEVELS', 'PRICE_BREAK_NOF_LEVELS', '10', 'CD_PRICE_BREAK_NOF_LEVELS', 88, 1, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2510, 'CT_NOF_PRICE_BREAKS_FOR_DROPDOWN', 'NOF_PRICE_BREAKS_FOR_DROPDOWN', '5', 'CD_NOF_PRICE_BREAKS_FOR_DROPDOWN', 88, 2, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2511, 'CT_CUSTOMER_COMMENTS_NOTIFY', 'CUSTOMER_COMMENTS_NOTIFY', 'false', 'CD_CUSTOMER_COMMENTS_NOTIFY', 5, 50, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2512, 'CT_CUSTOMER_COMMENTS_NEW_STATUS', 'CUSTOMER_COMMENTS_NEW_STATUS', '4', 'CD_CUSTOMER_COMMENTS_NEW_STATUS', 5, 51, '[[regtime]]', '[[regtime]]', 'tep_get_orders_status_name', 'tep_cfg_pull_down_status_change_cancel_list('),
(2513, 'CT_CUSTOMER_COMMENTS_NEW_STATUS_DL', 'CUSTOMER_COMMENTS_NEW_STATUS_DL', '5', 'CD_CUSTOMER_COMMENTS_NEW_STATUS_DL', 5, 52, '[[regtime]]', '[[regtime]]', 'tep_get_orders_status_name', 'tep_cfg_pull_down_status_change_cancel_list('),
(2514, 'CT_STORE_WIDTH', 'STORE_WIDTH', '980', 'CD_STORE_WIDTH', 201, 3, NULL, '[[regtime]]', NULL, NULL),
(2515, 'CT_STORE_ALIGN', 'STORE_ALIGN', 'center', 'CD_STORE_ALIGN', 201, 5, NULL, '[[regtime]]', NULL, NULL),
(2516, 'CT_CHECKOUT_SHIPPING_DATE', 'CHECKOUT_SHIPPING_DATE', 'false', 'CD_CHECKOUT_SHIPPING_DATE', 5, 53, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2517, 'CT_ACCOUNT_EMAIL_CONFIRMATION', 'ACCOUNT_EMAIL_CONFIRMATION', 'false', 'CD_ACCOUNT_EMAIL_CONFIRMATION', 5, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2518, 'CT_BOX_WIDTH_LEFT', 'BOX_WIDTH_LEFT', '150', 'CD_BOX_WIDTH_LEFT', 201, 6, NULL, '[[regtime]]', NULL, NULL),
(2519, 'CT_BOX_WIDTH_RIGHT', 'BOX_WIDTH_RIGHT', '150', 'CD_BOX_WIDTH_RIGHT', 201, 7, NULL, '[[regtime]]', NULL, NULL),
(2520, 'CT_LEFT_COLUMN_SHOW', 'LEFT_COLUMN_SHOW', 'true', 'CD_LEFT_COLUMN_SHOW', 201, 8, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2521, 'CT_RIGHT_COLUMN_SHOW', 'RIGHT_COLUMN_SHOW', 'true', 'CD_RIGHT_COLUMN_SHOW', 201, 9, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2522, 'CT_BREADCRUMB_SHOW_PRODUCT_MODEL', 'BREADCRUMB_SHOW_PRODUCT_MODEL', 'False', 'CD_BREADCRUMB_SHOW_PRODUCT_MODEL', 8, 20, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''True'', ''False''),'),
(2523, 'CT_MANUFACTURERS_IMAGES_DIR', 'MANUFACTURERS_IMAGES_DIR', 'manufacturers/', 'CD_MANUFACTURERS_IMAGES_DIR', 45, 0, NULL, '[[regtime]]', NULL, NULL),
(2524, 'CT_NO_OF_DYNAMIC_MOPICS', 'NO_OF_DYNAMIC_MOPICS', '5', 'CD_NO_OF_DYNAMIC_MOPICS', 45, 50, NULL, '[[regtime]]', NULL, NULL),
(2525, 'CT_STOCK_SET_INACTIVE', 'STOCK_SET_INACTIVE', 'false', 'CD_STOCK_SET_INACTIVE', 9, 9, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2550, 'CT_RECAPTCHA_EMAIL_URL', 'RECAPTCHA_EMAIL_URL', '', 'CD_RECAPTCHA_EMAIL_URL', 87, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_textarea('),
(2551, 'CT_RECAPTCHA_EMAIL_FROM', 'RECAPTCHA_EMAIL_FROM', 'CLICK', 'CD_RECAPTCHA_EMAIL_FROM', 87, 6, NULL, '[[regtime]]', NULL, NULL),
(2552, 'CT_RECAPTCHA_CREATE_ACCOUNT', 'RECAPTCHA_CREATE_ACCOUNT', 'true', 'CD_RECAPTCHA_CREATE_ACCOUNT', 87, 7, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2553, 'CT_RECAPTCHA_CONTACT_US', 'RECAPTCHA_CONTACT_US', 'true', 'CD_RECAPTCHA_CONTACT_US', 87, 8, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2554, 'CT_RECAPTCHA_STYLE', 'RECAPTCHA_STYLE', 'white', 'CD_RECAPTCHA_STYLE', 87, 2, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''white'', ''red'', ''blackglass'',''clean'',''custom''),'),
(2555, 'CT_RECAPTCHA_PRODUCT_REVIEWS_WRITE', 'RECAPTCHA_PRODUCT_REVIEWS_WRITE', 'true', 'CD_RECAPTCHA_PRODUCT_REVIEWS_WRITE', 87, 9, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2556, 'CT_RECAPTCHA_WISHLIST', 'RECAPTCHA_WISHLIST', 'true', 'CD_RECAPTCHA_WISHLIST', 87, 10, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2601, 'CT_SEO_URLS_ENABLED', 'SEO_URLS_ENABLED', 'false', 'CD_SEO_URLS_ENABLED', 60, 902, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''), '),
(2602, 'CT_SEO_URLS_ADD_CPATH_TO_PRODUCT_URLS', 'SEO_URLS_ADD_CPATH_TO_PRODUCT_URLS', 'false', 'CD_SEO_URLS_ADD_CPATH_TO_PRODUCT_URLS', 60, 902, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''), '),
(2603, 'CT_SEO_URLS_ADD_CAT_PARENT', 'SEO_URLS_ADD_CAT_PARENT', 'true', 'CD_SEO_URLS_ADD_CAT_PARENT', 60, 902, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''), '),
(2604, 'CT_SEO_URLS_FILTER_SHORT_WORDS', 'SEO_URLS_FILTER_SHORT_WORDS', '1', 'CD_SEO_URLS_FILTER_SHORT_WORDS', 60, 902, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''1'', ''2'', ''3''), '),
(2605, 'CT_SEO_URLS_USE_W3C_VALID', 'SEO_URLS_USE_W3C_VALID', 'true', 'CD_SEO_URLS_USE_W3C_VALID', 60, 902, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''), '),
(2606, 'CT_SEO_URLS_TYPE', 'SEO_URLS_TYPE', 'rewrite', 'CD_SEO_URLS_TYPE', 60, 902, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''rewrite'', ''standard''), '),
(2607, 'CT_SEO_URLS_CHAR_CONVERT_SET', 'SEO_URLS_CHAR_CONVERT_SET', '', 'CD_SEO_URLS_CHAR_CONVERT_SET', 60, 902, '[[regtime]]', '[[regtime]]', '', ''),
(2608, 'CT_SEO_URLS_REMOVE_ALL_SPEC_CHARS', 'SEO_URLS_REMOVE_ALL_SPEC_CHARS', 'true', 'CD_SEO_URLS_REMOVE_ALL_SPEC_CHARS', 60, 902, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''), '),
(2609, 'CT_SEO_URLS_CACHE_DAYS', 'SEO_URLS_CACHE_DAYS', '7', 'CD_SEO_URLS_CACHE_DAYS', 60, 902, '[[regtime]]', '[[regtime]]', '', ''),
(2610, 'CT_SEO_URLS_CACHE_RESET', 'SEO_URLS_CACHE_RESET', 'false', 'CD_SEO_URLS_CACHE_RESET', 60, 902, '[[regtime]]', '[[regtime]]', 'tep_reset_cache_data_seo_urls', 'tep_cfg_select_option(array(''reset'', ''false''), '),
(2611, 'CT_SEO_URLS_OUPUT_PERFORMANCE', 'SEO_URLS_OUPUT_PERFORMANCE', 'false', 'CD_SEO_URLS_OUPUT_PERFORMANCE', 60, 902, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''), '),
(2612, 'CT_SEO_URLS_CACHE_SYSTEM', 'SEO_URLS_CACHE_SYSTEM', 'FileSystem', 'CD_SEO_URLS_CACHE_SYSTEM', 60, 902, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''FileSystem'', ''Database'', ''Memcached''), '),
(2613, 'CT_MAT', 'MAT', 'false', 'CD_MAT', 203, 0, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''), '),
(2614, 'CT_MATC', 'MATC', 'false', 'CD_MATC', 203, 1, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''), '),
(2615, 'CT_JAVASCRIPT_CHECK', 'JAVASCRIPT_CHECK', 'false', 'CD_JAVASCRIPT_CHECK', 203, 2, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''), '),
(2616, 'CT_IE6_CHECK', 'IE6_CHECK', 'false', 'CD_IE6_CHECK', 203, 3, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''), '),
(2617, 'CT_SLIDESHOW_WIDTH', 'SLIDESHOW_WIDTH', '640', 'CD_SLIDESHOW_WIDTH', 204, 1, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2618, 'CT_SLIDESHOW_HEIGHT', 'SLIDESHOW_HEIGHT', '250', 'CD_SLIDESHOW_HEIGHT', 204, 2, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2619, 'CT_SLIDESHOW_TRANSITION', 'SLIDESHOW_TRANSITION', 'fade', 'CD_SLIDESHOW_TRANSITION', 204, 3, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''fade'',''horizontal-slider'',''vertical-slider''),'),
(2620, 'CT_SLIDESHOW_TRANSITION_SPEED', 'SLIDESHOW_TRANSITION_SPEED', '500', 'CD_SLIDESHOW_TRANSITION_SPEED', 204, 4, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2621, 'CT_SLIDESHOW_INTERVAL', 'SLIDESHOW_INTERVAL', '4000', 'CD_SLIDESHOW_INTERVAL', 204, 5, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2622, 'CT_SLIDESHOW_DISPLAY_TITLE', 'SLIDESHOW_DISPLAY_TITLE', 'true', 'CD_SLIDESHOW_DISPLAY_TITLE', 204, 6, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2623, 'CT_SLIDESHOW_TITLE_POSITION', 'SLIDESHOW_TITLE_POSITION', 'bottom', 'CD_SLIDESHOW_TITLE_POSITION', 204, 7, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''top'',''bottom''),'),
(2624, 'CT_SLIDESHOW_TITLE_COLOR', 'SLIDESHOW_TITLE_COLOR', '#000000', 'CD_SLIDESHOW_TITLE_COLOR', 204, 8, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2625, 'CT_SLIDESHOW_TITLE_OPACITY', 'SLIDESHOW_TITLE_OPACITY', '0.5', 'CD_SLIDESHOW_TITLE_OPACITY', 204, 9, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2626, 'CT_SLIDESHOW_TITLE_HEIGHT', 'SLIDESHOW_TITLE_HEIGHT', '25', 'CD_SLIDESHOW_TITLE_HEIGHT', 204, 10, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2627, 'CT_SLIDESHOW_MINATURE', 'SLIDESHOW_MINATURE', 'false', 'CD_SLIDESHOW_MINATURE', 204, 11, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2628, 'CT_SLIDESHOW_THUMB_AUTOHIDE', 'SLIDESHOW_THUMB_AUTOHIDE', 'false', 'CD_SLIDESHOW_THUMB_AUTOHIDE', 204, 12, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2629, 'CT_SLIDESHOW_THUMB_WIDTH', 'SLIDESHOW_THUMB_WIDTH', '20', 'CD_SLIDESHOW_THUMB_WIDTH', 204, 13, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2630, 'CT_SLIDESHOW_THUMB_HEIGHT', 'SLIDESHOW_THUMB_HEIGHT', '20', 'CD_SLIDESHOW_THUMB_HEIGHT', 204, 14, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2631, 'CT_SLIDESHOW_THUMB_POS', 'SLIDESHOW_THUMB_POS', 'top-right', 'CD_SLIDESHOW_THUMB_POS', 204, 15, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''top-left'',''top-right'',''bottom-left'',''bottom-right''),'),
(2632, 'CT_SLIDESHOW_THUMB_ORIENTATION', 'SLIDESHOW_THUMB_ORIENTATION', 'horizontal', 'CD_SLIDESHOW_THUMB_ORIENTATION', 204, 16, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''horizontal'',''vertical''),'),
(2633, 'CT_SLIDESHOW_THUMB_BORDER_COLOR', 'SLIDESHOW_THUMB_BORDER_COLOR', '#dddddd', 'CD_SLIDESHOW_THUMB_BORDER_COLOR', 204, 17, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2634, 'CT_SLIDESHOW_THUMB_BACKGROUND_COLOR', 'SLIDESHOW_THUMB_BACKGROUND_COLOR', '#333333', 'CD_SLIDESHOW_THUMB_BACKGROUND_COLOR', 204, 18, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2635, 'CT_SLIDESHOW_THUMB_FONT_COLOR', 'SLIDESHOW_THUMB_FONT_COLOR', '#ffffff', 'CD_SLIDESHOW_THUMB_FONT_COLOR', 204, 19, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2636, 'CT_SLIDESHOW_NUMBER', 'SLIDESHOW_NUMBER', 'true', 'CD_SLIDESHOW_NUMBER', 204, 20, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2637, 'CT_SLIDESHOW_THUMB_FONT_SIZE', 'SLIDESHOW_THUMB_FONT_SIZE', '10', 'CD_SLIDESHOW_THUMB_FONT_SIZE', 204, 21, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2638, 'CT_SLIDESHOW_THUMB_ACTIVE_BORDER_COLOR', 'SLIDESHOW_THUMB_ACTIVE_BORDER_COLOR', '#333333', 'CD_SLIDESHOW_THUMB_ACTIVE_BORDER_COLOR', 204, 22, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2639, 'CT_SLIDESHOW_THUMB_ACTIVE_BACKGROUND_COLOR', 'SLIDESHOW_THUMB_ACTIVE_BACKGROUND_COLOR', '#dddddd', 'CD_SLIDESHOW_THUMB_ACTIVE_BACKGROUND_COLOR', 204, 23, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2640, 'CT_SLIDESHOW_THUMB_ACTIVE_FONT_COLOR', 'SLIDESHOW_THUMB_ACTIVE_FONT_COLOR', '#000000', 'CD_SLIDESHOW_THUMB_ACTIVE_FONT_COLOR', 204, 24, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2641, 'CT_SLIDESHOW_COMPRESSION', 'SLIDESHOW_COMPRESSION', '85', 'CD_SLIDESHOW_COMPRESSION', 204, 25, NULL, '[[regtime]]', NULL, NULL),
(2642, 'CT_AJAX_SEARCH_SUGGEST', 'AJAX_SEARCH_SUGGEST', 'false', 'CD_AJAX_SEARCH_SUGGEST', 201, 25, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2643, 'CT_ENGLISH_SWITCH', 'ENGLISH_SWITCH', 'US', 'CD_ENGLISH_SWITCH', 1, 11, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''US'', ''AUS'', ''UK''), '),
(2644, 'CT_CB_LAST_FEW', 'CB_LAST_FEW', 'true', 'CD_CB_LAST_FEW', 205, 1, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2645, 'CT_CB_LAST_FEW_NO', 'CB_LAST_FEW_NO', '5', 'CD_CB_LAST_FEW_NO', 205, 2, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2646, 'CT_CB_TOP_RATED', 'CB_TOP_RATED', 'true', 'CD_CB_TOP_RATED', 205, 3, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2647, 'CT_CB_TOP_RATED_NO', 'CB_TOP_RATED_NO', '4', 'CD_CB_TOP_RATED_NO', 205, 4, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2648, 'CT_CB_FEATURED', 'CB_FEATURED', 'true', 'CD_CB_FEATURED', 205, 5, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2649, 'CT_CB_SPECIALS', 'CB_SPECIALS', 'true', 'CD_CB_SPECIALS', 205, 6, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2650, 'CT_CB_SPECIALS_NO', 'CB_SPECIALS_NO', '20', 'CD_CB_SPECIALS_NO', 205, 7, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2651, 'CT_CB_CALL_FOR_PRICE', 'CB_CALL_FOR_PRICE', 'true', 'CD_CB_CALL_FOR_PRICE', 205, 8, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2652, 'CT_CB_OUT_OF_STOCK', 'CB_OUT_OF_STOCK', 'true', 'CD_CB_OUT_OF_STOCK', 205, 9, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2653, 'CT_PRODUCT_CORNER_BANNER', 'PRODUCT_CORNER_BANNER', '1', 'CD_PRODUCT_CORNER_BANNER', 8, 1, NULL, '[[regtime]]', NULL, NULL),
(2654, 'CT_USE_XSELL_HORIZ_SCROLLER', 'USE_XSELL_HORIZ_SCROLLER', 'false', 'CD_USE_XSELL_HORIZ_SCROLLER', 201, 26, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2655, 'CT_SHOW_ASK_A_QUESTION', 'SHOW_ASK_A_QUESTION', 'False', 'CD_SHOW_ASK_A_QUESTION', 8, 21, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''True'', ''False''),'),
(2656, 'CT_DISPLAY_QUERIES', 'DISPLAY_QUERIES', 'false', 'CD_DISPLAY_QUERIES', 10, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2657, 'CT_DEFAULT_PRODUCT_TAX_CLASS', 'DEFAULT_PRODUCT_TAX_CLASS', '1', 'CD_DEFAULT_PRODUCT_TAX_CLASS', 1, 24, '[[regtime]]', '[[regtime]]', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes('),
(2658, 'CT_USE_AP_HORIZ_SCROLLER', 'USE_AP_HORIZ_SCROLLER', 'false', 'CD_USE_AP_HORIZ_SCROLLER', 201, 27, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(2659, 'CT_SHOW_MORE_INFO', 'SHOW_MORE_INFO', 'True', 'CD_SHOW_MORE_INFO', 8, 10, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''True'', ''False''),'),
(2660, 'CT_SCROLLER_WIDTH', 'SCROLLER_WIDTH', '603', 'CD_SCROLLER_WIDTH', 201, 28, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2661, 'CT_SCROLLER_HEIGHT', 'SCROLLER_HEIGHT', '200', 'CD_SCROLLER_HEIGHT', 201, 29, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2662, 'CT_PRODUCT_SHORT_DESCRIPTION', 'PRODUCT_SHORT_DESCRIPTION', 'false', 'CD_PRODUCT_SHORT_DESCRIPTION', 8, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(2663, 'CT_DEFINE_MAINPAGE_TEXT_INFO_NO', 'DEFINE_MAINPAGE_TEXT_INFO_NO', '13', 'CD_DEFINE_MAINPAGE_TEXT_INFO_NO', 201, 31, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2664, 'CT_BASKET_CART', 'BASKET_CART', 'cart', 'CD_BASKET_CART', 201, 30, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''cart'', ''basket''),'),
(2665, 'CT_PRODUCT_REVIEWS_ENABLE', 'PRODUCT_REVIEWS_ENABLE', 'True', 'CD_PRODUCT_REVIEWS_ENABLE', 8, 22, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''True'', ''False''),'),
(2666, 'CT_DEFINE_AFFILIATE_INFO_INFO_NO', 'DEFINE_AFFILIATE_INFO_INFO_NO', '15', 'CD_DEFINE_AFFILIATE_INFO_INFO_NO', 201, 32, '[[regtime]]', '[[regtime]]', NULL, NULL),
(2667, 'CT_ATTRIBUTE_PRICE_DISPLAY', 'ATTRIBUTE_PRICE_DISPLAY', 'separate', 'CD_ATTRIBUTE_PRICE_DISPLAY', 8, 23, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''separate'', ''combined''),'),
(2668, 'CT_PRODUCT_LIST_BESTSELLER', 'PRODUCT_LIST_BESTSELLER', '1', 'CD_PRODUCT_LIST_BESTSELLER', 8, 12, NULL, '[[regtime]]', NULL, NULL),
(2670, 'CT_PRICE_BREAK_PERCENT_BEHAVIOUR', 'PRICE_BREAK_PERCENT_BEHAVIOUR', 'Off Price', 'CD_PRICE_BREAK_PERCENT_BEHAVIOUR', 88, 4, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''Off Price'', ''To Pay''),'),
(2671, 'CT_PRICE_BREAK_PRICE_CHANGE_BEHAVIOUR', 'PRICE_BREAK_PRICE_CHANGE_BEHAVIOUR', 'Update Percent', 'CD_PRICE_BREAK_PRICE_CHANGE_BEHAVIOUR', 88, 5, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''Update Percent'', ''Update Prices''),'),
(2999, 'CT_PRICE_BREAK_PRICE', 'PRICE_BREAK_PRICE', 'off', 'CD_PRICE_BREAK_PRICE', 88, 3, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''high'',''low'',''off''),'),
(3004, 'CT_OPEN_FEATURED_LIMIT_PRODUCTS_FEATURES', 'OPEN_FEATURED_LIMIT_PRODUCTS_FEATURES', 'true', 'CD_OPEN_FEATURED_LIMIT_PRODUCTS_FEATURES', 99, 5, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(3005, 'CT_OPEN_FEATURED_LIMIT_CATEGORIES_FEATURES', 'OPEN_FEATURED_LIMIT_CATEGORIES_FEATURES', 'true', 'CD_OPEN_FEATURED_LIMIT_CATEGORIES_FEATURES', 99, 6, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(3006, 'CT_SUSPEND_FEATURED_SETS_EXPIRING', 'SUSPEND_FEATURED_SETS_EXPIRING', 'false', 'CD_SUSPEND_FEATURED_SETS_EXPIRING', 99, 7, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(3007, 'CT_FEATURED_SET_SHOW_BUY_NOW_BUTTONS', 'FEATURED_SET_SHOW_BUY_NOW_BUTTONS', 'true', 'CD_FEATURED_SET_SHOW_BUY_NOW_BUTTONS', 99, 8, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(3008, 'CT_OPEN_FEATURED_LIMIT_DESCRIPTION_BY', 'OPEN_FEATURED_LIMIT_DESCRIPTION_BY', 'words', 'CD_OPEN_FEATURED_LIMIT_DESCRIPTION_BY', 99, 9, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''words'', ''chars''),'),
(3009, 'CT_FEATURED_PRODUCTS_DISPLAY', 'FEATURED_PRODUCTS_DISPLAY', 'true', 'CD_FEATURED_PRODUCTS_DISPLAY', 99, 11, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(3010, 'CT_FEATURED_PRODUCTS_POSITION', 'FEATURED_PRODUCTS_POSITION', '1', 'CD_FEATURED_PRODUCTS_POSITION', 99, 12, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''1'', ''2'', ''3'', ''4''),'),
(3011, 'CT_MAX_DISPLAY_FEATURED_PRODUCTS', 'MAX_DISPLAY_FEATURED_PRODUCTS', '6', 'CD_MAX_DISPLAY_FEATURED_PRODUCTS', 99, 13, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3012, 'CT_FEATURED_PRODUCTS_COLUMNS', 'FEATURED_PRODUCTS_COLUMNS', '3', 'CD_FEATURED_PRODUCTS_COLUMNS', 99, 14, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3013, 'CT_MAX_FEATURED_WORD_DESCRIPTION', 'MAX_FEATURED_WORD_DESCRIPTION', '24', 'CD_MAX_FEATURED_WORD_DESCRIPTION', 99, 15, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3014, 'CT_DAYS_UNTIL_FEATURED_PRODUCTS', 'DAYS_UNTIL_FEATURED_PRODUCTS', '30', 'CD_DAYS_UNTIL_FEATURED_PRODUCTS', 99, 16, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3015, 'CT_FEATURED_SET', 'FEATURED_SET', '4', 'CD_FEATURED_SET', 99, 17, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_featured(array(''1'', ''2'', ''3'', ''4''),'),
(3016, 'CT_FEATURED_SET_STYLE', 'FEATURED_SET_STYLE', '6', 'CD_FEATURED_SET_STYLE', 99, 18, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_featured(array(''1'', ''2'', ''3'', ''4'', ''5'', ''6''),'),
(3017, 'CT_FEATURED_PRODUCTS_GROUPING', 'FEATURED_PRODUCTS_GROUPING', 'gbox', 'CD_FEATURED_PRODUCTS_GROUPING', 99, 19, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_featured(array(''gbox'', ''sbox''),'),
(3019, 'CT_FEATURED_PRODUCTS_SORT_ORDER', 'FEATURED_PRODUCTS_SORT_ORDER', 'rand()', 'CD_FEATURED_PRODUCTS_SORT_ORDER', 99, 21, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''p.products_id'', ''pd.products_name'', ''p.products_price'', ''rand()''),'),
(3020, 'CT_FEATURED_PRODUCTS_DIRECTION', 'FEATURED_PRODUCTS_DIRECTION', 'DESC', 'CD_FEATURED_PRODUCTS_DIRECTION', 99, 22, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''ASC'', ''DESC''),'),
(3021, 'CT_FEATURED_CELLPADDING', 'FEATURED_CELLPADDING', '0', 'CD_FEATURED_CELLPADDING', 99, 23, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3022, 'CT_FEATURED_VLINE_IMAGE_HEIGHT', 'FEATURED_VLINE_IMAGE_HEIGHT', '150', 'CD_FEATURED_VLINE_IMAGE_HEIGHT', 99, 24, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3023, 'CT_FEATURED_LINE_THICKNESS', 'FEATURED_LINE_THICKNESS', '2', 'CD_FEATURED_LINE_THICKNESS', 99, 25, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3024, 'CT_FEATURED_LINE_COLOR', 'FEATURED_LINE_COLOR', 'DDDDDD', 'CD_FEATURED_LINE_COLOR', 99, 26, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_color('),
(3025, 'CT_FEATURED_MANUFACTURERS_DISPLAY', 'FEATURED_MANUFACTURERS_DISPLAY', 'true', 'CD_FEATURED_MANUFACTURERS_DISPLAY', 99, 31, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(3026, 'CT_FEATURED_MANUFACTURERS_POSITION', 'FEATURED_MANUFACTURERS_POSITION', '2', 'CD_FEATURED_MANUFACTURERS_POSITION', 99, 32, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''1'', ''2'', ''3'', ''4''),'),
(3027, 'CT_MAX_DISPLAY_FEATURED_MANUFACTURERS', 'MAX_DISPLAY_FEATURED_MANUFACTURERS', '6', 'CD_MAX_DISPLAY_FEATURED_MANUFACTURERS', 99, 33, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3028, 'CT_FEATURED_MANUFACTURERS_COLUMNS', 'FEATURED_MANUFACTURERS_COLUMNS', '3', 'CD_FEATURED_MANUFACTURERS_COLUMNS', 99, 34, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3029, 'CT_DAYS_UNTIL_FEATURED_MANUFACTURERS', 'DAYS_UNTIL_FEATURED_MANUFACTURERS', '30', 'CD_DAYS_UNTIL_FEATURED_MANUFACTURERS', 99, 35, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3030, 'CT_FEATURED_MANUFACTURERS_SET_STYLE', 'FEATURED_MANUFACTURERS_SET_STYLE', '6', 'CD_FEATURED_MANUFACTURERS_SET_STYLE', 99, 36, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_featured(array(''1'', ''2'', ''3'', ''4'', ''5'', ''6''),'),
(3031, 'CT_FEATURED_MANUFACTURERS_SORT_ORDER', 'FEATURED_MANUFACTURERS_SORT_ORDER', 'rand()', 'CD_FEATURED_MANUFACTURERS_SORT_ORDER', 99, 37, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''m.manufacturers_id'', ''m.manufacturers_name'', ''rand()''),'),
(3032, 'CT_FEATURED_MANUFACTURERS_DIRECTION', 'FEATURED_MANUFACTURERS_DIRECTION', 'DESC', 'CD_FEATURED_MANUFACTURERS_DIRECTION', 99, 38, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''ASC'', ''DESC''),'),
(3033, 'CT_FEATURED_MANUFACTURERS_CELLPADDING', 'FEATURED_MANUFACTURERS_CELLPADDING', '0', 'CD_FEATURED_MANUFACTURERS_CELLPADDING', 99, 39, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3034, 'CT_FEATURED_MANUFACTURERS_VLINE_IMAGE_HEIGHT', 'FEATURED_MANUFACTURERS_VLINE_IMAGE_HEIGHT', '150', 'CD_FEATURED_MANUFACTURERS_VLINE_IMAGE_HEIGHT', 99, 40, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3035, 'CT_FEATURED_MANUFACTURERS_LINE_THICKNESS', 'FEATURED_MANUFACTURERS_LINE_THICKNESS', '2', 'CD_FEATURED_MANUFACTURERS_LINE_THICKNESS', 99, 41, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3036, 'CT_FEATURED_MANUFACTURERS_LINE_COLOR', 'FEATURED_MANUFACTURERS_LINE_COLOR', 'DDDDDD', 'CD_FEATURED_MANUFACTURERS_LINE_COLOR', 99, 42, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_color('),
(3037, 'CT_FEATURED_MANUFACTURER_DISPLAY', 'FEATURED_MANUFACTURER_DISPLAY', 'true', 'CD_FEATURED_MANUFACTURER_DISPLAY', 99, 51, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(3038, 'CT_FEATURED_MANUFACTURER_POSITION', 'FEATURED_MANUFACTURER_POSITION', '3', 'CD_FEATURED_MANUFACTURER_POSITION', 99, 52, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''1'', ''2'', ''3'', ''4''),'),
(3039, 'CT_MAX_DISPLAY_FEATURED_MANUFACTURER', 'MAX_DISPLAY_FEATURED_MANUFACTURER', '3', 'CD_MAX_DISPLAY_FEATURED_MANUFACTURER', 99, 53, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3040, 'CT_FEATURED_MANUFACTURER_COLUMNS', 'FEATURED_MANUFACTURER_COLUMNS', '3', 'CD_FEATURED_MANUFACTURER_COLUMNS', 99, 54, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3041, 'CT_MAX_FEATURED_MANUFACTURER_WORD_DESCRIPTION', 'MAX_FEATURED_MANUFACTURER_WORD_DESCRIPTION', '24', 'CD_MAX_FEATURED_MANUFACTURER_WORD_DESCRIPTION', 99, 55, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3042, 'CT_DAYS_UNTIL_FEATURED_MANUFACTURER', 'DAYS_UNTIL_FEATURED_MANUFACTURER', '30', 'CD_DAYS_UNTIL_FEATURED_MANUFACTURER', 99, 56, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3043, 'CT_FEATURED_MANUFACTURER_SET', 'FEATURED_MANUFACTURER_SET', '4', 'CD_FEATURED_MANUFACTURER_SET', 99, 57, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_featured(array(''1'', ''2'', ''3'', ''4''),'),
(3044, 'CT_FEATURED_MANUFACTURER_SET_STYLE', 'FEATURED_MANUFACTURER_SET_STYLE', '4', 'CD_FEATURED_MANUFACTURER_SET_STYLE', 99, 58, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_featured(array(''1'', ''2'', ''3'', ''4'', ''5'', ''6''),'),
(3045, 'CT_FEATURED_MANUFACTURER_GROUPING', 'FEATURED_MANUFACTURER_GROUPING', 'gbox', 'CD_FEATURED_MANUFACTURER_GROUPING', 99, 59, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_featured(array(''gbox'', ''sbox''),'),
(3047, 'CT_FEATURED_MANUFACTURER_SORT_ORDER', 'FEATURED_MANUFACTURER_SORT_ORDER', 'rand()', 'CD_FEATURED_MANUFACTURER_SORT_ORDER', 99, 61, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''m.manufacturers_id'', ''m.manufacturers_name'', ''p.products_id'', ''pd.products_name'', ''p.products_price'', ''rand()''),'),
(3048, 'CT_FEATURED_MANUFACTURER_DIRECTION', 'FEATURED_MANUFACTURER_DIRECTION', 'DESC', 'CD_FEATURED_MANUFACTURER_DIRECTION', 99, 62, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''ASC'', ''DESC''),'),
(3049, 'CT_MANUFACTURER_CELLPADDING', 'MANUFACTURER_CELLPADDING', '0', 'CD_MANUFACTURER_CELLPADDING', 99, 63, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3050, 'CT_MANUFACTURER_VLINE_IMAGE_HEIGHT', 'MANUFACTURER_VLINE_IMAGE_HEIGHT', '150', 'CD_MANUFACTURER_VLINE_IMAGE_HEIGHT', 99, 64, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3051, 'CT_MANUFACTURER_LINE_THICKNESS', 'MANUFACTURER_LINE_THICKNESS', '2', 'CD_MANUFACTURER_LINE_THICKNESS', 99, 65, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3052, 'CT_MANUFACTURER_LINE_COLOR', 'MANUFACTURER_LINE_COLOR', 'DDDDDD', 'CD_MANUFACTURER_LINE_COLOR', 99, 66, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_color('),
(3053, 'CT_FEATURED_CATEGORIES_DISPLAY', 'FEATURED_CATEGORIES_DISPLAY', 'true', 'CD_FEATURED_CATEGORIES_DISPLAY', 99, 71, '[[regtime]]', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(3054, 'CT_FEATURED_CATEGORIES_POSITION', 'FEATURED_CATEGORIES_POSITION', '4', 'CD_FEATURED_CATEGORIES_POSITION', 99, 72, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''1'', ''2'', ''3'', ''4''),'),
(3055, 'CT_MAX_DISPLAY_FEATURED_CATEGORIES', 'MAX_DISPLAY_FEATURED_CATEGORIES', '6', 'CD_MAX_DISPLAY_FEATURED_CATEGORIES', 99, 73, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3056, 'CT_FEATURED_CATEGORIES_COLUMNS', 'FEATURED_CATEGORIES_COLUMNS', '3', 'CD_FEATURED_CATEGORIES_COLUMNS', 99, 74, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3057, 'CT_MAX_FEATURED_CATEGORIES_WORD_DESCRIPTION', 'MAX_FEATURED_CATEGORIES_WORD_DESCRIPTION', '24', 'CD_MAX_FEATURED_CATEGORIES_WORD_DESCRIPTION', 99, 75, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3058, 'CT_DAYS_UNTIL_FEATURED_CATEGORIES', 'DAYS_UNTIL_FEATURED_CATEGORIES', '30', 'CD_DAYS_UNTIL_FEATURED_CATEGORIES', 99, 76, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3059, 'CT_FEATURED_CATEGORIES_SET', 'FEATURED_CATEGORIES_SET', '4', 'CD_FEATURED_CATEGORIES_SET', 99, 77, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_featured(array(''1'', ''2'', ''3'', ''4''),'),
(3060, 'CT_FEATURED_CATEGORIES_SET_STYLE', 'FEATURED_CATEGORIES_SET_STYLE', '6', 'CD_FEATURED_CATEGORIES_SET_STYLE', 99, 78, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_featured(array(''1'', ''2'', ''3'', ''4'', ''5'', ''6''),'),
(3061, 'CT_FEATURED_CATEGORIES_GROUPING', 'FEATURED_CATEGORIES_GROUPING', 'gbox', 'CD_FEATURED_CATEGORIES_GROUPING', 99, 79, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_featured(array(''gbox'', ''sbox''),'),
(3063, 'CT_FEATURED_CATEGORIES_SORT_ORDER', 'FEATURED_CATEGORIES_SORT_ORDER', 'rand()', 'CD_FEATURED_CATEGORIES_SORT_ORDER', 99, 81, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''c.categories_id'', ''cd.categories_name'', ''m.manufacturers_id'', ''p.products_id'', ''pd.products_name'', ''p.products_price'', ''rand()''),'),
(3064, 'CT_FEATURED_CATEGORIES_DIRECTION', 'FEATURED_CATEGORIES_DIRECTION', 'DESC', 'CD_FEATURED_CATEGORIES_DIRECTION', 99, 82, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''ASC'', ''DESC''),'),
(3065, 'CT_CATEGORIES_CELLPADDING', 'CATEGORIES_CELLPADDING', '0', 'CD_CATEGORIES_CELLPADDING', 99, 83, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3066, 'CT_CATEGORIES_VLINE_IMAGE_HEIGHT', 'CATEGORIES_VLINE_IMAGE_HEIGHT', '150', 'CD_CATEGORIES_VLINE_IMAGE_HEIGHT', 99, 84, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3067, 'CT_CATEGORIES_LINE_THICKNESS', 'CATEGORIES_LINE_THICKNESS', '2', 'CD_CATEGORIES_LINE_THICKNESS', 99, 85, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3068, 'CT_CATEGORIES_LINE_COLOR', 'CATEGORIES_LINE_COLOR', 'DDDDDD', 'CD_CATEGORIES_LINE_COLOR', 99, 86, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_color('),
(3069, 'CT_ONEPAGE_CHECKOUT_ENABLED', 'ONEPAGE_CHECKOUT_ENABLED', 'True', 'CD_ONEPAGE_CHECKOUT_ENABLED', 7575, 1, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''False'',''True''),'),
(3070, 'CT_ONEPAGE_DEFAULT_COUNTRY', 'ONEPAGE_DEFAULT_COUNTRY', '223', 'CD_ONEPAGE_DEFAULT_COUNTRY', 7575, 2, NULL, '[[regtime]]', 'tep_get_country_name', 'tep_cfg_pull_down_country_list('),
(3071, 'CT_ONEPAGE_ACCOUNT_CREATE', 'ONEPAGE_ACCOUNT_CREATE', 'create', 'CD_ONEPAGE_ACCOUNT_CREATE', 7575, 3, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''required'', ''optional'', ''create''),'),
(3072, 'CT_ONEPAGE_SHOW_CUSTOM_COLUMN', 'ONEPAGE_SHOW_CUSTOM_COLUMN', 'true', 'CD_ONEPAGE_SHOW_CUSTOM_COLUMN', 7575, 4, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(3073, 'CT_ONEPAGE_LOGIN_REQUIRED', 'ONEPAGE_LOGIN_REQUIRED', 'false', 'CD_ONEPAGE_LOGIN_REQUIRED', 7575, 5, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(3074, 'CT_ONEPAGE_SHOW_OSC_COLUMNS', 'ONEPAGE_SHOW_OSC_COLUMNS', 'true', 'CD_ONEPAGE_SHOW_OSC_COLUMNS', 7575, 6, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',''false''),'),
(3075, 'CT_ONEPAGE_BOX_ONE_HEADING', 'ONEPAGE_BOX_ONE_HEADING', '100% Private Secure SSL Transaction', 'CD_ONEPAGE_BOX_ONE_HEADING', 7575, 15, NULL, '[[regtime]]', NULL, NULL),
(3076, 'CT_ONEPAGE_BOX_ONE_CONTENT', 'ONEPAGE_BOX_ONE_CONTENT', 'Your shopping cart transaction is taking place on an encrypted SSL webpage; meaning it is secure and safe. We respect all of your private information and none of it will be shared with anyone in anyway.', 'CD_ONEPAGE_BOX_ONE_CONTENT', 7575, 16, NULL, '[[regtime]]', NULL, 'tep_cfg_textarea('),
(3077, 'CT_ONEPAGE_BOX_TWO_HEADING', 'ONEPAGE_BOX_TWO_HEADING', 'Ordering Information', 'CD_ONEPAGE_BOX_TWO_HEADING', 7575, 17, NULL, '[[regtime]]', NULL, NULL),
(3078, 'CT_ONEPAGE_BOX_TWO_CONTENT', 'ONEPAGE_BOX_TWO_CONTENT', '<b>Processing Time</b><br>We will process your order as quickly as possible. Typical processing time for orders shipped ground is 1  2 days. For expedited shipping (2 day or overnight) we make every effort to ship the order the same day if ordered before 2pm.<br><br><b>Order Tracking</b><br>After your order is placed you can login anytime 24/7 to view the status of your order. When your order is shipped you will receive a shipment notification with a tracking number.', 'CD_ONEPAGE_BOX_TWO_CONTENT', 7575, 18, NULL, '[[regtime]]', NULL, 'tep_cfg_textarea('),
(3079, 'CT_ONEPAGE_DEBUG_EMAIL_ADDRESS', 'ONEPAGE_DEBUG_EMAIL_ADDRESS', '[[admin_email]]', 'CD_ONEPAGE_DEBUG_EMAIL_ADDRESS', 7575, 19, NULL, '[[regtime]]', NULL, NULL),
(3080, 'CT_ONEPAGE_CHECKOUT_SHOW_ADDRESS_INPUT_FIELDS', 'ONEPAGE_CHECKOUT_SHOW_ADDRESS_INPUT_FIELDS', 'False', 'CD_ONEPAGE_CHECKOUT_SHOW_ADDRESS_INPUT_FIELDS', 7575, 20, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''False'',''True''),'),
(3081, 'CT_ONEPAGE_CHECKOUT_LOADER_POPUP', 'ONEPAGE_CHECKOUT_LOADER_POPUP', 'True', 'CD_ONEPAGE_CHECKOUT_LOADER_POPUP', 7575, 21, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''False'',''True''),'),
(3082, 'CT_ONEPAGE_AUTO_SHOW_BILLING_SHIPPING', 'ONEPAGE_AUTO_SHOW_BILLING_SHIPPING', 'True', 'CD_ONEPAGE_AUTO_SHOW_BILLING_SHIPPING', 7575, 33, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''False'',''True''),'),
(3083, 'CT_ONEPAGE_AUTO_SHOW_DEFAULT_COUNTRY', 'ONEPAGE_AUTO_SHOW_DEFAULT_COUNTRY', '223', 'CD_ONEPAGE_AUTO_SHOW_DEFAULT_COUNTRY', 7575, 34, NULL, '[[regtime]]', 'tep_get_country_name', 'tep_cfg_pull_down_country_list('),
(3084, 'CT_ONEPAGE_AUTO_SHOW_DEFAULT_STATE', 'ONEPAGE_AUTO_SHOW_DEFAULT_STATE', '12', 'CD_ONEPAGE_AUTO_SHOW_DEFAULT_STATE', 7575, 35, NULL, '[[regtime]]', 'tep_cfg_get_zone_name', 'tep_cfg_pull_down_zone_list_one_page('),
(3085, 'CT_ONEPAGE_AUTO_SHOW_DEFAULT_ZIP', 'ONEPAGE_AUTO_SHOW_DEFAULT_ZIP', '93401', 'CD_ONEPAGE_AUTO_SHOW_DEFAULT_ZIP', 7575, 36, NULL, '[[regtime]]', NULL, NULL),
(3086, 'CT_ONEPAGE_TELEPHONE', 'ONEPAGE_TELEPHONE', 'False', 'CD_ONEPAGE_TELEPHONE', 7575, 37, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''False'',''True''),'),
(3087, 'CT_ONEPAGE_ZIP_BELOW', 'ONEPAGE_ZIP_BELOW', 'False', 'CD_ONEPAGE_ZIP_BELOW', 7575, 38, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''False'',''True''),'),
(3088, 'CT_ONEPAGE_CHECKOUT_HIDE_SHIPPING', 'ONEPAGE_CHECKOUT_HIDE_SHIPPING', 'true', 'CD_ONEPAGE_CHECKOUT_HIDE_SHIPPING', 7575, 100, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(3089, 'CT_ONEPAGE_ADDR_LAYOUT', 'ONEPAGE_ADDR_LAYOUT', 'vertical', 'CD_ONEPAGE_ADDR_LAYOUT', 7575, 1000, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''vertical'', ''horizontal''), '),
(3125, 'CT_STORE_LOGO', 'STORE_LOGO', 'logo.png', 'CD_STORE_LOGO', 1, 2, NULL, '[[regtime]]', NULL, NULL),
(3250, 'CT_MAILCHIMP_ENABLE', 'MAILCHIMP_ENABLE', 'false', 'CD_MAILCHIMP_ENABLE', 206, 1, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''false'',''true''),'),
(3251, 'CT_MAILCHIMP_API', 'MAILCHIMP_API', '', 'CD_MAILCHIMP_API', 206, 2, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3252, 'CT_MAILCHIMP_ID', 'MAILCHIMP_ID', '', 'CD_MAILCHIMP_ID', 206, 5, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3253, 'CT_MAILCHIMP_URL', 'MAILCHIMP_URL', '', 'CD_MAILCHIMP_URL', 206, 3, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3254, 'CT_MAILCHIMP_U', 'MAILCHIMP_U', '', 'CD_MAILCHIMP_U', 206, 4, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3255, 'CT_MAILCHIMP_OPT_IN', 'MAILCHIMP_OPT_IN', 'true', 'CD_MAILCHIMP_OPT_IN', 206, 6, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''false'',''true''),'),
(3256, 'CT_MAILCHIMP_DELETE', 'MAILCHIMP_DELETE', 'false', 'CD_MAILCHIMP_DELETE', 206, 7, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''false'',''true''),'),
(3257, 'CT_MAILCHIMP_SEND_GOODBYE', 'MAILCHIMP_SEND_GOODBYE', 'true', 'CD_MAILCHIMP_SEND_GOODBYE', 206, 8, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''false'',''true''),'),
(3258, 'CT_MAILCHIMP_SEND_NOTIFY', 'MAILCHIMP_SEND_NOTIFY', 'true', 'CD_MAILCHIMP_SEND_NOTIFY', 206, 9, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''false'',''true''),'),
(3259, 'CT_MAILCHIMP_LAST_SYNC', 'MAILCHIMP_LAST_SYNC', '', 'CD_MAILCHIMP_LAST_SYNC', 206, 10, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3300, 'CT_SHOW_STORE_OPENING_HOURS', 'SHOW_STORE_OPENING_HOURS', 'true', 'CD_SHOW_STORE_OPENING_HOURS', 207, 1, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''false'',''true''),'),
(3301, 'CT_STORE_OPENING_HOURS_TEXT', 'STORE_OPENING_HOURS_TEXT', 'Our store is open from 9.30am to 5pm from Monday to Friday', 'CD_STORE_OPENING_HOURS_TEXT', 207, 2, NULL, '[[regtime]]', NULL, 'tep_cfg_textarea('),
(3302, 'CT_SHOW_EMAIL_ADDRESS', 'SHOW_EMAIL_ADDRESS', 'true', 'CD_SHOW_EMAIL_ADDRESS', 207, 3, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''false'',''true''),'),
(3303, 'CT_SHOW_MAILING_ADDRESS', 'SHOW_MAILING_ADDRESS', 'true', 'CD_SHOW_MAILING_ADDRESS', 207, 4, '[[regtime]]', '[[regtime]]', NULL, 'tep_cfg_select_option(array(''false'',''true''),'),
(3305, 'CT_SHOW_TAX_RATE_NEAR_PRICE', 'SHOW_TAX_RATE_NEAR_PRICE', 'false', 'CD_SHOW_TAX_RATE_NEAR_PRICE', 1, 22, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',  ''false''), '),
(3306, 'CT_SHOW_SHIPPING_NEAR_PRICE', 'SHOW_SHIPPING_NEAR_PRICE', 'false', 'CD_SHOW_SHIPPING_NEAR_PRICE', 1, 23, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',  ''false''), '),
(3307, 'CT_PRODUCT_LIST_DATE_ADDED', 'PRODUCT_LIST_DATE_ADDED', 'true', 'CD_PRODUCT_LIST_DATE_ADDED', 8, 24, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',  ''false''), ');
INSERT INTO `configuration` VALUES
(3308, 'CT_CATEGORY_DROPDOWN_SWITCH', 'DISABLE_CATEGORY_DROPDOWN_SWITCH', 'false', 'CD_CATEGORY_DROPDOWN_SWITCH', 1, 26, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',  ''false''), '),
(3309, 'CT_FORCE_CATALOG_LANGUAGE', 'FORCE_CATALOG_LANGUAGE', 'false', 'CD_FORCE_CATALOG_LANGUAGE', 1, 10, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',  ''false''), '),
(3310, 'CT_FORCE_ADMIN_LANGUAGE', 'FORCE_ADMIN_LANGUAGE', 'false', 'CD_FORCE_ADMIN_LANGUAGE', 1, 10, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'',  ''false''), '),
(3311, 'CT_CODE_SUFFIX_SEPERATOR', 'CODE_SUFFIX_SEPERATOR', '-', 'CD_CODE_SUFFIX_SEPERATOR', 1, 27, NULL, '[[regtime]]', NULL, NULL),
(3312, 'CT_SEND_ALL_EMAIL_COPY_TO', 'SEND_ALL_EMAIL_COPY_TO', '', 'CD_SEND_ALL_EMAIL_COPY_TO', 1, 13, NULL, '[[regtime]]', NULL, NULL),
(3500, 'CT_CLOUDZOOM_WIDTH', 'CLOUDZOOM_WIDTH', 'auto', 'CD_CLOUDZOOM_WIDTH', 47, 2, NULL, '[[regtime]]', NULL, NULL),
(3501, 'CT_CLOUDZOOM_HEIGHT', 'CLOUDZOOM_HEIGHT', 'auto', 'CD_CLOUDZOOM_HEIGHT', 47, 3, NULL, '[[regtime]]', NULL, NULL),
(3502, 'CT_CLOUDZOOM_POSITION', 'CLOUDZOOM_POSITION', 'right', 'CD_CLOUDZOOM_POSITION', 47, 4, NULL, '[[regtime]]', NULL, NULL),
(3503, 'CT_CLOUDZOOM_ADJUSTX', 'CLOUDZOOM_ADJUSTX', '10', 'CD_CLOUDZOOM_ADJUSTX', 47, 5, NULL, '[[regtime]]', NULL, NULL),
(3504, 'CT_CLOUDZOOM_ADJUSTY', 'CLOUDZOOM_ADJUSTY', '-4', 'CD_CLOUDZOOM_ADJUSTY', 47, 6, NULL, '[[regtime]]', NULL, NULL),
(3505, 'CT_CLOUDZOOM_TINT', 'CLOUDZOOM_TINT', 'false', 'CD_CLOUDZOOM_TINT', 47, 7, NULL, '[[regtime]]', NULL, NULL),
(3506, 'CT_CLOUDZOOM_TINTOPACITY', 'CLOUDZOOM_TINTOPACITY', '0.5', 'CD_CLOUDZOOM_TINTOPACITY', 47, 8, NULL, '[[regtime]]', NULL, NULL),
(3507, 'CT_CLOUDZOOM_LENSOPACITY', 'CLOUDZOOM_LENSOPACITY', '0.5', 'CD_CLOUDZOOM_LENSOPACITY', 47, 9, NULL, '[[regtime]]', NULL, NULL),
(3508, 'CT_CLOUDZOOM_SOFTFOCUS', 'CLOUDZOOM_SOFTFOCUS', 'false', 'CD_CLOUDZOOM_SOFTFOCUS', 47, 10, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(3509, 'CT_CLOUDZOOM_SMOOTHMOVE', 'CLOUDZOOM_SMOOTHMOVE', '3', 'CD_CLOUDZOOM_SMOOTHMOVE', 47, 11, NULL, '[[regtime]]', NULL, NULL),
(3510, 'CT_CLOUDZOOM_SHOWTITLE', 'CLOUDZOOM_SHOWTITLE', 'true', 'CD_CLOUDZOOM_SHOWTITLE', 47, 12, NULL, '[[regtime]]', NULL, 'tep_cfg_select_option(array(''true'', ''false''),'),
(3511, 'CT_CLOUDZOOM_TITLEOPACITY', 'CLOUDZOOM_TITLEOPACITY', '0.5', 'CD_CLOUDZOOM_TITLEOPACITY', 47, 13, NULL, '[[regtime]]', NULL, NULL),
(3512, 'CT_ADD_THIS_ENABLED', 'ADD_THIS_ENABLED', 'true', 'CD_ADD_THIS_ENABLED', 208, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'',''false''),'),
(3513, 'CT_ADD_THIS_CODE', 'ADD_THIS_CODE', '', 'CD_ADD_THIS_CODE', 208, 2, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_textarea('),
(3514, 'CT_ADD_THIS_JAVASCRIPT', 'ADD_THIS_JAVASCRIPT', '', 'CD_ADD_THIS_JAVASCRIPT', 208, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_textarea('),
(3515, 'CT_ADD_THIS_ADDRESS_BAR', 'ADD_THIS_ADDRESS_BAR', '', 'CD_ADD_THIS_ADDRESS_BAR', 208, 4, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_textarea('),
(3516, 'CT_ADD_THIS_ARTICLES', 'ADD_THIS_ARTICLES', 'true', 'CD_ADD_THIS_ARTICLES', 208, 5, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'',''false''),'),
(3525, 'CT_INDIVIDUAL_SHIP_HOME_COUNTRY', 'INDIVIDUAL_SHIP_HOME_COUNTRY', '223', 'CD_INDIVIDUAL_SHIP_HOME_COUNTRY', 7, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL),
(3526, 'CT_INDIVIDUAL_SHIP_INCREASE', 'INDIVIDUAL_SHIP_INCREASE', '3', 'CD_INDIVIDUAL_SHIP_INCREASE', 7, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `configuration_group`
--

CREATE TABLE `configuration_group` (
  `configuration_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_group_title` varchar(64) NOT NULL,
  `configuration_group_description` varchar(255) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `visible` int(1) DEFAULT '1',
  PRIMARY KEY (`configuration_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7576 ;

--
-- Dumping data for table `configuration_group`
--

INSERT INTO `configuration_group` VALUES
(1, 'BOX_CONFIGURATION_MYSTORE', 'General information about my store', 1, 1),
(2, 'BOX_CONFIGURATION_MIN_VALUES', 'The minimum values for functions / data', 2, 1),
(3, 'BOX_CONFIGURATION_MAX_VALUES', 'The maximum values for functions / data', 3, 1),
(4, 'BOX_CONFIGURATION_IMAGES', 'Image parameters', 4, 1),
(5, 'BOX_CONFIGURATION_CUSTOMER_DETAILS', 'Customer account configuration', 5, 1),
(6, 'Module Options', 'Hidden from configuration', 6, 0),
(7, 'BOX_CONFIGURATION_SHIPPING', 'Shipping options available at my store', 7, 1),
(8, 'BOX_CONFIGURATION_PRODUCT_LISTING', 'Product Listing configuration options', 8, 1),
(9, 'BOX_CONFIGURATION_STOCK', 'Stock configuration options', 9, 1),
(10, 'BOX_CONFIGURATION_LOGGING', 'Logging configuration options', 10, 1),
(11, 'BOX_CONFIGURATION_CACHE', 'Caching configuration options', 11, 1),
(12, 'BOX_CONFIGURATION_EMAIL', 'General setting for E-Mail transport and HTML E-Mails', 12, 1),
(13, 'BOX_CONFIGURATION_DOWNLOAD', 'Downloadable products options', 13, 1),
(14, 'BOX_CONFIGURATION_GZIP', 'GZip compression options', 14, 1),
(15, 'BOX_CONFIGURATION_SESSIONS', 'Session options', 15, 1),
(16, 'BOX_CONFIGURATION_MAINTENANCE', 'Site Maintenance Options', 16, 1),
(25, 'BOX_CONFIGURATION_WYSIWYG', 'CK Editor Options', 15, 1),
(30, 'BOX_CONFIGURATION_PRINT', 'Options for Printable Catalog', 30, 1),
(35, 'BOX_CONFIGURATION_AFFILIATE', 'Options for the Affiliate Program', 50, 1),
(45, 'BOX_CONFIGURATION_MOPICS', 'The options which configure Dynamic MoPics.', 45, 1),
(46, 'BOX_CONFIGURATION_SLIMBOX', 'The options which configure Slimbox.', 46, 1),
(47, 'BOX_CONFIGURATION_CLOUDZOOM', 'The options which configure CloudZoom.', 47, 1),
(50, 'BOX_CONFIGURATION_PRODUCT_INFO', 'Product Information page configuration options', 8, 1),
(55, 'BOX_CONFIGURATION_PAGE_CACHE', 'Settings for the page cache contribution', 20, 1),
(60, 'BOX_CONFIGURATION_SEO_URLS', 'Options for ULTIMATE Seo Urls 5 by FWR Media', 902, 1),
(65, 'BOX_CONFIGURATION_WISHLIST', 'Settings for your Wish List', 25, 1),
(70, 'BOX_CONFIGURATION_EDITOR', 'Configuration options for Order Editor', 903, 1),
(80, 'BOX_TOOLS_RECOVER_CART', 'Recover Cart Sales (RCS) Configuration Values', 55, 1),
(85, 'BOX_CONFIGURATION_GOOGLE_ANALYTICS', 'Google Analytics Settings', 99, 1),
(86, 'BOX_CONFIGURATION_SEO_POPOUT', 'SEO Pop Out Multilayer Menu', 904, 1),
(87, 'BOX_CONFIGURATION_RECAPTCHA', 'reCaptcha Settings', 905, 1),
(88, 'BOX_CONFIGURATION_PRODUCT_PRICE_BREAKS', 'Configuration options for price breaks', 88, 1),
(89, 'BOX_CONFIGURATION_GOOGLE_MAPS', 'Google Maps Settings', 89, 1),
(99, 'BOX_CONFIGURATION_OFS', 'Configure featured sets', 99, 1),
(201, 'BOX_CONFIGURATION_TEMPLATE_SETUP', 'Template Settings', 201, 1),
(203, 'BOX_CONFIGURATION_NOTIFICATIONS', 'Notifications', 203, 1),
(204, 'BOX_CONFIGURATION_SLIDESHOW_SETTINGS', 'SlideShow Settings', 204, 1),
(205, 'BOX_CONFIGURATION_CORNER_BANNERS', 'Corner Banners', 205, 1),
(206, 'BOX_CONFIGURATION_MC', 'MailChimp Newsletters', 206, 1),
(207, 'BOX_CONFIGURATION_CONTACT', 'Contact Us Form', 207, 1),
(208, 'BOX_CONFIGURATION_ADDTHIS', 'AddThis', 208, 1),
(456, 'BOX_CONFIGURATION_ARTICLES', 'Settings for Articles', 456, 1),
(7575, 'BOX_CONFIGURATION_OPC', 'Settings for one page checkout', 16, 1);

-- --------------------------------------------------------

--
-- Table structure for table `counter`
--

CREATE TABLE `counter` (
  `startdate` char(8) DEFAULT NULL,
  `counter` int(12) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `counter_history`
--

CREATE TABLE `counter_history` (
  `month` char(8) DEFAULT NULL,
  `counter` int(12) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `countries`
--

CREATE TABLE `countries` (
  `countries_id` int(11) NOT NULL AUTO_INCREMENT,
  `countries_name` varchar(64) NOT NULL,
  `countries_iso_code_2` char(2) NOT NULL,
  `countries_iso_code_3` char(3) NOT NULL,
  `address_format_id` int(11) NOT NULL,
  `active` tinyint(3) unsigned DEFAULT '1',
  PRIMARY KEY (`countries_id`),
  KEY `IDX_COUNTRIES_NAME` (`countries_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=240 ;

--
-- Dumping data for table `countries`
--

INSERT INTO `countries` VALUES
(1, 'Afghanistan', 'AF', 'AFG', 1, 1),
(2, 'Albania', 'AL', 'ALB', 1, 1),
(3, 'Algeria', 'DZ', 'DZA', 1, 1),
(4, 'American Samoa', 'AS', 'ASM', 1, 1),
(5, 'Andorra', 'AD', 'AND', 1, 1),
(6, 'Angola', 'AO', 'AGO', 1, 1),
(7, 'Anguilla', 'AI', 'AIA', 1, 1),
(8, 'Antarctica', 'AQ', 'ATA', 1, 1),
(9, 'Antigua and Barbuda', 'AG', 'ATG', 1, 1),
(10, 'Argentina', 'AR', 'ARG', 1, 1),
(11, 'Armenia', 'AM', 'ARM', 1, 1),
(12, 'Aruba', 'AW', 'ABW', 1, 1),
(13, 'Australia', 'AU', 'AUS', 1, 1),
(14, 'Austria', 'AT', 'AUT', 5, 1),
(15, 'Azerbaijan', 'AZ', 'AZE', 1, 1),
(16, 'Bahamas', 'BS', 'BHS', 1, 1),
(17, 'Bahrain', 'BH', 'BHR', 1, 1),
(18, 'Bangladesh', 'BD', 'BGD', 1, 1),
(19, 'Barbados', 'BB', 'BRB', 1, 1),
(20, 'Belarus', 'BY', 'BLR', 1, 1),
(21, 'Belgium', 'BE', 'BEL', 1, 1),
(22, 'Belize', 'BZ', 'BLZ', 1, 1),
(23, 'Benin', 'BJ', 'BEN', 1, 1),
(24, 'Bermuda', 'BM', 'BMU', 1, 1),
(25, 'Bhutan', 'BT', 'BTN', 1, 1),
(26, 'Bolivia', 'BO', 'BOL', 1, 1),
(27, 'Bosnia and Herzegowina', 'BA', 'BIH', 1, 1),
(28, 'Botswana', 'BW', 'BWA', 1, 1),
(29, 'Bouvet Island', 'BV', 'BVT', 1, 1),
(30, 'Brazil', 'BR', 'BRA', 1, 1),
(31, 'British Indian Ocean Territory', 'IO', 'IOT', 1, 1),
(32, 'Brunei Darussalam', 'BN', 'BRN', 1, 1),
(33, 'Bulgaria', 'BG', 'BGR', 1, 1),
(34, 'Burkina Faso', 'BF', 'BFA', 1, 1),
(35, 'Burundi', 'BI', 'BDI', 1, 1),
(36, 'Cambodia', 'KH', 'KHM', 1, 1),
(37, 'Cameroon', 'CM', 'CMR', 1, 1),
(38, 'Canada', 'CA', 'CAN', 1, 1),
(39, 'Cape Verde', 'CV', 'CPV', 1, 1),
(40, 'Cayman Islands', 'KY', 'CYM', 1, 1),
(41, 'Central African Republic', 'CF', 'CAF', 1, 1),
(42, 'Chad', 'TD', 'TCD', 1, 1),
(43, 'Chile', 'CL', 'CHL', 1, 1),
(44, 'China', 'CN', 'CHN', 1, 1),
(45, 'Christmas Island', 'CX', 'CXR', 1, 1),
(46, 'Cocos (Keeling) Islands', 'CC', 'CCK', 1, 1),
(47, 'Colombia', 'CO', 'COL', 1, 1),
(48, 'Comoros', 'KM', 'COM', 1, 1),
(49, 'Congo', 'CG', 'COG', 1, 1),
(50, 'Cook Islands', 'CK', 'COK', 1, 1),
(51, 'Costa Rica', 'CR', 'CRI', 1, 1),
(52, 'Cote D''Ivoire', 'CI', 'CIV', 1, 1),
(53, 'Croatia', 'HR', 'HRV', 1, 1),
(54, 'Cuba', 'CU', 'CUB', 1, 1),
(55, 'Cyprus', 'CY', 'CYP', 1, 1),
(56, 'Czech Republic', 'CZ', 'CZE', 1, 1),
(57, 'Denmark', 'DK', 'DNK', 1, 1),
(58, 'Djibouti', 'DJ', 'DJI', 1, 1),
(59, 'Dominica', 'DM', 'DMA', 1, 1),
(60, 'Dominican Republic', 'DO', 'DOM', 1, 1),
(61, 'East Timor', 'TP', 'TMP', 1, 1),
(62, 'Ecuador', 'EC', 'ECU', 1, 1),
(63, 'Egypt', 'EG', 'EGY', 1, 1),
(64, 'El Salvador', 'SV', 'SLV', 1, 1),
(65, 'Equatorial Guinea', 'GQ', 'GNQ', 1, 1),
(66, 'Eritrea', 'ER', 'ERI', 1, 1),
(67, 'Estonia', 'EE', 'EST', 1, 1),
(68, 'Ethiopia', 'ET', 'ETH', 1, 1),
(69, 'Falkland Islands (Malvinas)', 'FK', 'FLK', 1, 1),
(70, 'Faroe Islands', 'FO', 'FRO', 1, 1),
(71, 'Fiji', 'FJ', 'FJI', 1, 1),
(72, 'Finland', 'FI', 'FIN', 1, 1),
(73, 'France', 'FR', 'FRA', 1, 1),
(74, 'France, Metropolitan', 'FX', 'FXX', 1, 1),
(75, 'French Guiana', 'GF', 'GUF', 1, 1),
(76, 'French Polynesia', 'PF', 'PYF', 1, 1),
(77, 'French Southern Territories', 'TF', 'ATF', 1, 1),
(78, 'Gabon', 'GA', 'GAB', 1, 1),
(79, 'Gambia', 'GM', 'GMB', 1, 1),
(80, 'Georgia', 'GE', 'GEO', 1, 1),
(81, 'Germany', 'DE', 'DEU', 5, 1),
(82, 'Ghana', 'GH', 'GHA', 1, 1),
(83, 'Gibraltar', 'GI', 'GIB', 1, 1),
(84, 'Greece', 'GR', 'GRC', 1, 1),
(85, 'Greenland', 'GL', 'GRL', 1, 1),
(86, 'Grenada', 'GD', 'GRD', 1, 1),
(87, 'Guadeloupe', 'GP', 'GLP', 1, 1),
(88, 'Guam', 'GU', 'GUM', 1, 1),
(89, 'Guatemala', 'GT', 'GTM', 1, 1),
(90, 'Guinea', 'GN', 'GIN', 1, 1),
(91, 'Guinea-bissau', 'GW', 'GNB', 1, 1),
(92, 'Guyana', 'GY', 'GUY', 1, 1),
(93, 'Haiti', 'HT', 'HTI', 1, 1),
(94, 'Heard and Mc Donald Islands', 'HM', 'HMD', 1, 1),
(95, 'Honduras', 'HN', 'HND', 1, 1),
(96, 'Hong Kong', 'HK', 'HKG', 1, 1),
(97, 'Hungary', 'HU', 'HUN', 1, 1),
(98, 'Iceland', 'IS', 'ISL', 1, 1),
(99, 'India', 'IN', 'IND', 1, 1),
(100, 'Indonesia', 'ID', 'IDN', 1, 1),
(101, 'Iran (Islamic Republic of)', 'IR', 'IRN', 1, 1),
(102, 'Iraq', 'IQ', 'IRQ', 1, 1),
(103, 'Ireland', 'IE', 'IRL', 1, 1),
(104, 'Israel', 'IL', 'ISR', 1, 1),
(105, 'Italy', 'IT', 'ITA', 1, 1),
(106, 'Jamaica', 'JM', 'JAM', 1, 1),
(107, 'Japan', 'JP', 'JPN', 1, 1),
(108, 'Jordan', 'JO', 'JOR', 1, 1),
(109, 'Kazakhstan', 'KZ', 'KAZ', 1, 1),
(110, 'Kenya', 'KE', 'KEN', 1, 1),
(111, 'Kiribati', 'KI', 'KIR', 1, 1),
(112, 'Korea, Democratic People''s Republic of', 'KP', 'PRK', 1, 1),
(113, 'Korea, Republic of', 'KR', 'KOR', 1, 1),
(114, 'Kuwait', 'KW', 'KWT', 1, 1),
(115, 'Kyrgyzstan', 'KG', 'KGZ', 1, 1),
(116, 'Lao People''s Democratic Republic', 'LA', 'LAO', 1, 1),
(117, 'Latvia', 'LV', 'LVA', 1, 1),
(118, 'Lebanon', 'LB', 'LBN', 1, 1),
(119, 'Lesotho', 'LS', 'LSO', 1, 1),
(120, 'Liberia', 'LR', 'LBR', 1, 1),
(121, 'Libyan Arab Jamahiriya', 'LY', 'LBY', 1, 1),
(122, 'Liechtenstein', 'LI', 'LIE', 1, 1),
(123, 'Lithuania', 'LT', 'LTU', 1, 1),
(124, 'Luxembourg', 'LU', 'LUX', 1, 1),
(125, 'Macau', 'MO', 'MAC', 1, 1),
(126, 'Macedonia, The Former Yugoslav Republic of', 'MK', 'MKD', 1, 1),
(127, 'Madagascar', 'MG', 'MDG', 1, 1),
(128, 'Malawi', 'MW', 'MWI', 1, 1),
(129, 'Malaysia', 'MY', 'MYS', 1, 1),
(130, 'Maldives', 'MV', 'MDV', 1, 1),
(131, 'Mali', 'ML', 'MLI', 1, 1),
(132, 'Malta', 'MT', 'MLT', 1, 1),
(133, 'Marshall Islands', 'MH', 'MHL', 1, 1),
(134, 'Martinique', 'MQ', 'MTQ', 1, 1),
(135, 'Mauritania', 'MR', 'MRT', 1, 1),
(136, 'Mauritius', 'MU', 'MUS', 1, 1),
(137, 'Mayotte', 'YT', 'MYT', 1, 1),
(138, 'Mexico', 'MX', 'MEX', 1, 1),
(139, 'Micronesia, Federated States of', 'FM', 'FSM', 1, 1),
(140, 'Moldova, Republic of', 'MD', 'MDA', 1, 1),
(141, 'Monaco', 'MC', 'MCO', 1, 1),
(142, 'Mongolia', 'MN', 'MNG', 1, 1),
(143, 'Montserrat', 'MS', 'MSR', 1, 1),
(144, 'Morocco', 'MA', 'MAR', 1, 1),
(145, 'Mozambique', 'MZ', 'MOZ', 1, 1),
(146, 'Myanmar', 'MM', 'MMR', 1, 1),
(147, 'Namibia', 'NA', 'NAM', 1, 1),
(148, 'Nauru', 'NR', 'NRU', 1, 1),
(149, 'Nepal', 'NP', 'NPL', 1, 1),
(150, 'Netherlands', 'NL', 'NLD', 1, 1),
(151, 'Netherlands Antilles', 'AN', 'ANT', 1, 1),
(152, 'New Caledonia', 'NC', 'NCL', 1, 1),
(153, 'New Zealand', 'NZ', 'NZL', 1, 1),
(154, 'Nicaragua', 'NI', 'NIC', 1, 1),
(155, 'Niger', 'NE', 'NER', 1, 1),
(156, 'Nigeria', 'NG', 'NGA', 1, 1),
(157, 'Niue', 'NU', 'NIU', 1, 1),
(158, 'Norfolk Island', 'NF', 'NFK', 1, 1),
(159, 'Northern Mariana Islands', 'MP', 'MNP', 1, 1),
(160, 'Norway', 'NO', 'NOR', 1, 1),
(161, 'Oman', 'OM', 'OMN', 1, 1),
(162, 'Pakistan', 'PK', 'PAK', 1, 1),
(163, 'Palau', 'PW', 'PLW', 1, 1),
(164, 'Panama', 'PA', 'PAN', 1, 1),
(165, 'Papua New Guinea', 'PG', 'PNG', 1, 1),
(166, 'Paraguay', 'PY', 'PRY', 1, 1),
(167, 'Peru', 'PE', 'PER', 1, 1),
(168, 'Philippines', 'PH', 'PHL', 1, 1),
(169, 'Pitcairn', 'PN', 'PCN', 1, 1),
(170, 'Poland', 'PL', 'POL', 1, 1),
(171, 'Portugal', 'PT', 'PRT', 1, 1),
(172, 'Puerto Rico', 'PR', 'PRI', 1, 1),
(173, 'Qatar', 'QA', 'QAT', 1, 1),
(174, 'Reunion', 'RE', 'REU', 1, 1),
(175, 'Romania', 'RO', 'ROM', 1, 1),
(176, 'Russian Federation', 'RU', 'RUS', 1, 1),
(177, 'Rwanda', 'RW', 'RWA', 1, 1),
(178, 'Saint Kitts and Nevis', 'KN', 'KNA', 1, 1),
(179, 'Saint Lucia', 'LC', 'LCA', 1, 1),
(180, 'Saint Vincent and the Grenadines', 'VC', 'VCT', 1, 1),
(181, 'Samoa', 'WS', 'WSM', 1, 1),
(182, 'San Marino', 'SM', 'SMR', 1, 1),
(183, 'Sao Tome and Principe', 'ST', 'STP', 1, 1),
(184, 'Saudi Arabia', 'SA', 'SAU', 1, 1),
(185, 'Senegal', 'SN', 'SEN', 1, 1),
(186, 'Seychelles', 'SC', 'SYC', 1, 1),
(187, 'Sierra Leone', 'SL', 'SLE', 1, 1),
(188, 'Singapore', 'SG', 'SGP', 4, 1),
(189, 'Slovakia (Slovak Republic)', 'SK', 'SVK', 1, 1),
(190, 'Slovenia', 'SI', 'SVN', 1, 1),
(191, 'Solomon Islands', 'SB', 'SLB', 1, 1),
(192, 'Somalia', 'SO', 'SOM', 1, 1),
(193, 'South Africa', 'ZA', 'ZAF', 1, 1),
(194, 'South Georgia and the South Sandwich Islands', 'GS', 'SGS', 1, 1),
(195, 'Spain', 'ES', 'ESP', 3, 1),
(196, 'Sri Lanka', 'LK', 'LKA', 1, 1),
(197, 'St. Helena', 'SH', 'SHN', 1, 1),
(198, 'St. Pierre and Miquelon', 'PM', 'SPM', 1, 1),
(199, 'Sudan', 'SD', 'SDN', 1, 1),
(200, 'Suriname', 'SR', 'SUR', 1, 1),
(201, 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM', 1, 1),
(202, 'Swaziland', 'SZ', 'SWZ', 1, 1),
(203, 'Sweden', 'SE', 'SWE', 1, 1),
(204, 'Switzerland', 'CH', 'CHE', 1, 1),
(205, 'Syrian Arab Republic', 'SY', 'SYR', 1, 1),
(206, 'Taiwan', 'TW', 'TWN', 1, 1),
(207, 'Tajikistan', 'TJ', 'TJK', 1, 1),
(208, 'Tanzania, United Republic of', 'TZ', 'TZA', 1, 1),
(209, 'Thailand', 'TH', 'THA', 1, 1),
(210, 'Togo', 'TG', 'TGO', 1, 1),
(211, 'Tokelau', 'TK', 'TKL', 1, 1),
(212, 'Tonga', 'TO', 'TON', 1, 1),
(213, 'Trinidad and Tobago', 'TT', 'TTO', 1, 1),
(214, 'Tunisia', 'TN', 'TUN', 1, 1),
(215, 'Turkey', 'TR', 'TUR', 1, 1),
(216, 'Turkmenistan', 'TM', 'TKM', 1, 1),
(217, 'Turks and Caicos Islands', 'TC', 'TCA', 1, 1),
(218, 'Tuvalu', 'TV', 'TUV', 1, 1),
(219, 'Uganda', 'UG', 'UGA', 1, 1),
(220, 'Ukraine', 'UA', 'UKR', 1, 1),
(221, 'United Arab Emirates', 'AE', 'ARE', 1, 1),
(222, 'United Kingdom', 'GB', 'GBR', 6, 1),
(223, 'United States', 'US', 'USA', 2, 1),
(224, 'United States Minor Outlying Islands', 'UM', 'UMI', 1, 1),
(225, 'Uruguay', 'UY', 'URY', 1, 1),
(226, 'Uzbekistan', 'UZ', 'UZB', 1, 1),
(227, 'Vanuatu', 'VU', 'VUT', 1, 1),
(228, 'Vatican City State (Holy See)', 'VA', 'VAT', 1, 1),
(229, 'Venezuela', 'VE', 'VEN', 1, 1),
(230, 'Viet Nam', 'VN', 'VNM', 1, 1),
(231, 'Virgin Islands (British)', 'VG', 'VGB', 1, 1),
(232, 'Virgin Islands (U.S.)', 'VI', 'VIR', 1, 1),
(233, 'Wallis and Futuna Islands', 'WF', 'WLF', 1, 1),
(234, 'Western Sahara', 'EH', 'ESH', 1, 1),
(235, 'Yemen', 'YE', 'YEM', 1, 1),
(236, 'Yugoslavia', 'YU', 'YUG', 1, 1),
(237, 'Zaire', 'ZR', 'ZAR', 1, 1),
(238, 'Zambia', 'ZM', 'ZMB', 1, 1),
(239, 'Zimbabwe', 'ZW', 'ZWE', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `coupons`
--

CREATE TABLE `coupons` (
  `coupon_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_type` char(1) NOT NULL DEFAULT 'F',
  `coupon_code` varchar(32) NOT NULL,
  `coupon_amount` decimal(8,4) NOT NULL DEFAULT '0.0000',
  `coupon_minimum_order` decimal(8,4) NOT NULL DEFAULT '0.0000',
  `coupon_start_date` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `coupon_expire_date` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `uses_per_coupon` int(5) NOT NULL DEFAULT '1',
  `uses_per_user` int(5) NOT NULL DEFAULT '0',
  `restrict_to_products` varchar(255) DEFAULT NULL,
  `restrict_to_categories` varchar(255) DEFAULT NULL,
  `coupon_exclude_cg` varchar(32) NOT NULL,
  `restrict_to_customers` text,
  `coupon_active` char(1) NOT NULL DEFAULT 'Y',
  `date_created` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `date_modified` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  PRIMARY KEY (`coupon_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `coupons_description`
--

CREATE TABLE `coupons_description` (
  `coupon_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '0',
  `coupon_name` varchar(32) NOT NULL,
  `coupon_description` text,
  KEY `coupon_id` (`coupon_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `coupon_email_track`
--

CREATE TABLE `coupon_email_track` (
  `unique_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) NOT NULL DEFAULT '0',
  `customer_id_sent` int(11) NOT NULL DEFAULT '0',
  `sent_firstname` varchar(32) DEFAULT NULL,
  `sent_lastname` varchar(32) DEFAULT NULL,
  `emailed_to` varchar(32) DEFAULT NULL,
  `date_sent` datetime NOT NULL,
  PRIMARY KEY (`unique_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `coupon_gv_customer`
--

CREATE TABLE `coupon_gv_customer` (
  `customer_id` int(5) NOT NULL DEFAULT '0',
  `amount` decimal(8,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`customer_id`),
  KEY `customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `coupon_gv_queue`
--

CREATE TABLE `coupon_gv_queue` (
  `unique_id` int(5) NOT NULL AUTO_INCREMENT,
  `customer_id` int(5) NOT NULL DEFAULT '0',
  `order_id` int(5) NOT NULL DEFAULT '0',
  `amount` decimal(8,4) NOT NULL DEFAULT '0.0000',
  `date_created` datetime NOT NULL,
  `ipaddr` varchar(32) NOT NULL,
  `release_flag` char(1) NOT NULL DEFAULT 'N',
  `release_date` datetime NOT NULL,
  PRIMARY KEY (`unique_id`),
  KEY `uid` (`unique_id`,`customer_id`,`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `coupon_redeem_track`
--

CREATE TABLE `coupon_redeem_track` (
  `unique_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) NOT NULL DEFAULT '0',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `redeem_date` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `redeem_ip` varchar(32) NOT NULL,
  `order_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`unique_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `currencies`
--

CREATE TABLE `currencies` (
  `currencies_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL,
  `code` char(3) NOT NULL,
  `symbol_left` varchar(12) DEFAULT NULL,
  `symbol_right` varchar(12) DEFAULT NULL,
  `decimal_point` char(1) DEFAULT NULL,
  `thousands_point` char(1) DEFAULT NULL,
  `decimal_places` char(1) DEFAULT NULL,
  `value` float(13,8) DEFAULT NULL,
  `last_updated` datetime DEFAULT NULL,
  PRIMARY KEY (`currencies_id`),
  KEY `idx_currencies_code` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `currencies`
--

INSERT INTO `currencies` VALUES
(1, 'US Dollar', 'USD', '$', '', '.', ',', '2', 1.00000000, '[[regtime]]'),
(2, 'Euro', 'EUR', '', 'EUR', '.', ',', '2', 1.00000000, '[[regtime]]'),
(3, 'UK Pound', 'GBP', 'Â£', '', '.', ',', '2', 1.00000000, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `customers_id` int(11) NOT NULL AUTO_INCREMENT,
  `purchased_without_account` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `customers_gender` char(1) NOT NULL,
  `customers_firstname` varchar(32) NOT NULL,
  `customers_lastname` varchar(32) NOT NULL,
  `customers_dob` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `customers_email_address` varchar(96) NOT NULL,
  `customers_default_address_id` int(11) DEFAULT NULL,
  `customers_telephone` varchar(32) NOT NULL,
  `customers_fax` varchar(32) DEFAULT NULL,
  `customers_password` varchar(40) NOT NULL,
  `customers_newsletter` char(1) DEFAULT NULL,
  `customers_newsletter_type` varchar(32) NOT NULL DEFAULT 'html',
  `guest_account` tinyint(1) NOT NULL DEFAULT '0',
  `customers_login` varchar(96) DEFAULT NULL,
  `customers_group_name` varchar(27) NOT NULL DEFAULT 'Retail',
  `customers_group_id` int(11) NOT NULL DEFAULT '0',
  `customers_group_ra` enum('0','1') NOT NULL DEFAULT '0',
  `customers_payment_allowed` varchar(255) NOT NULL,
  `customers_shipment_allowed` varchar(255) NOT NULL,
  `customers_paypal_payerid` varchar(20) DEFAULT NULL,
  `customers_paypal_ec` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`customers_id`),
  UNIQUE KEY `idx_customers_login` (`customers_login`),
  KEY `purchased_without_account` (`purchased_without_account`),
  KEY `idx_customers_email_address` (`customers_email_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customers_basket`
--

CREATE TABLE `customers_basket` (
  `customers_basket_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `products_id` tinytext NOT NULL,
  `customers_basket_quantity` int(2) NOT NULL,
  `final_price` decimal(15,4) DEFAULT NULL,
  `customers_basket_date_added` char(8) DEFAULT NULL,
  PRIMARY KEY (`customers_basket_id`),
  KEY `idx_customers_basket_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customers_basket_attributes`
--

CREATE TABLE `customers_basket_attributes` (
  `customers_basket_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `products_id` tinytext NOT NULL,
  `products_options_id` int(11) NOT NULL,
  `products_options_value_id` int(11) NOT NULL,
  `products_options_value_text` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`customers_basket_attributes_id`),
  KEY `idx_customers_basket_att_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customers_groups`
--

CREATE TABLE `customers_groups` (
  `customers_group_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `customers_group_name` varchar(32) NOT NULL,
  `customers_group_show_tax` enum('1','0') NOT NULL DEFAULT '1',
  `customers_group_tax_exempt` enum('0','1') NOT NULL DEFAULT '0',
  `group_payment_allowed` varchar(255) NOT NULL,
  `group_shipment_allowed` varchar(255) NOT NULL,
  PRIMARY KEY (`customers_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `customers_groups`
--

INSERT INTO `customers_groups` VALUES
(0, 'Retail', '1', '0', '', ''),
(1, 'Wholesale', '0', '0', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `customers_info`
--

CREATE TABLE `customers_info` (
  `customers_info_id` int(11) NOT NULL,
  `customers_info_date_of_last_logon` datetime DEFAULT NULL,
  `customers_info_number_of_logons` int(5) DEFAULT NULL,
  `customers_info_date_account_created` datetime DEFAULT NULL,
  `customers_info_date_account_last_modified` datetime DEFAULT NULL,
  `global_product_notifications` int(1) DEFAULT '0',
  PRIMARY KEY (`customers_info_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `customers_notes`
--

CREATE TABLE `customers_notes` (
  `customers_notes_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `customers_notes_message` text NOT NULL,
  `customers_notes_editor` varchar(20) NOT NULL,
  `customers_notes_date` date NOT NULL,
  PRIMARY KEY (`customers_notes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customers_to_extra_fields`
--

CREATE TABLE `customers_to_extra_fields` (
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `fields_id` int(11) NOT NULL DEFAULT '0',
  `value` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `customers_wishlist`
--

CREATE TABLE `customers_wishlist` (
  `products_id` int(11) NOT NULL,
  `customers_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `customers_wishlist_attributes`
--

CREATE TABLE `customers_wishlist_attributes` (
  `customers_wishlist_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `products_id` int(11) NOT NULL,
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `products_options_value_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customers_wishlist_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customer_log`
--

CREATE TABLE `customer_log` (
  `login_number` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(200) DEFAULT NULL,
  `ip_address` varchar(32) DEFAULT NULL,
  `type` varchar(200) DEFAULT NULL,
  `login_time` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`login_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `db_version`
--

CREATE TABLE `db_version` (
  `database_version` varchar(128) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `db_version`
--

INSERT INTO `db_version` VALUES
('v2.5.4');

-- --------------------------------------------------------

--
-- Table structure for table `discount_categories`
--

CREATE TABLE `discount_categories` (
  `discount_categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_categories_name` varchar(255) NOT NULL,
  PRIMARY KEY (`discount_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `extra_fields`
--

CREATE TABLE `extra_fields` (
  `fields_id` int(11) NOT NULL AUTO_INCREMENT,
  `fields_input_type` int(11) NOT NULL DEFAULT '0',
  `fields_input_value` text NOT NULL,
  `fields_status` tinyint(2) NOT NULL DEFAULT '0',
  `fields_required_status` tinyint(2) NOT NULL DEFAULT '0',
  `fields_size` int(5) NOT NULL DEFAULT '0',
  `fields_cef_cg_hide` varchar(255) NOT NULL,
  PRIMARY KEY (`fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `extra_fields_info`
--

CREATE TABLE `extra_fields_info` (
  `fields_id` int(11) NOT NULL DEFAULT '0',
  `languages_id` int(11) NOT NULL DEFAULT '0',
  `fields_name` varchar(32) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `extra_field_labels`
--

CREATE TABLE `extra_field_labels` (
  `epf_id` int(10) unsigned NOT NULL,
  `languages_id` int(11) NOT NULL,
  `epf_label` varchar(64) DEFAULT NULL,
  `epf_active_for_language` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`epf_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `extra_field_values`
--

CREATE TABLE `extra_field_values` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `epf_id` int(10) unsigned NOT NULL,
  `languages_id` int(11) NOT NULL,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `epf_value` varchar(64) DEFAULT NULL,
  `value_depends_on` int(10) unsigned NOT NULL DEFAULT '0',
  `value_image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`value_id`),
  KEY `IDX_EPF` (`epf_id`,`languages_id`),
  KEY `IDX_LINK` (`value_depends_on`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `extra_product_fields`
--

CREATE TABLE `extra_product_fields` (
  `epf_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `epf_order` int(11) NOT NULL DEFAULT '0',
  `epf_status` tinyint(1) NOT NULL DEFAULT '1',
  `epf_uses_value_list` tinyint(1) NOT NULL DEFAULT '0',
  `epf_advanced_search` tinyint(1) NOT NULL DEFAULT '1',
  `epf_show_in_listing` tinyint(1) NOT NULL DEFAULT '0',
  `epf_size` tinyint(3) unsigned NOT NULL DEFAULT '64',
  `epf_use_as_meta_keyword` tinyint(1) NOT NULL DEFAULT '0',
  `epf_use_to_restrict_listings` tinyint(1) NOT NULL DEFAULT '0',
  `epf_show_parent_chain` tinyint(1) NOT NULL DEFAULT '0',
  `epf_quick_search` tinyint(1) NOT NULL DEFAULT '0',
  `epf_multi_select` tinyint(1) NOT NULL DEFAULT '0',
  `epf_checked_entry` tinyint(1) NOT NULL DEFAULT '0',
  `epf_value_display_type` tinyint(1) NOT NULL DEFAULT '0',
  `epf_num_columns` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `epf_has_linked_field` tinyint(1) NOT NULL DEFAULT '0',
  `epf_links_to` int(10) unsigned NOT NULL DEFAULT '0',
  `epf_textarea` tinyint(1) NOT NULL DEFAULT '0',
  `epf_show_in_admin` tinyint(1) NOT NULL DEFAULT '1',
  `epf_all_categories` tinyint(1) NOT NULL DEFAULT '1',
  `epf_category_ids` text,
  PRIMARY KEY (`epf_id`),
  KEY `IDX_ORDER` (`epf_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `extra_value_exclude`
--

CREATE TABLE `extra_value_exclude` (
  `value_id1` int(10) unsigned NOT NULL,
  `value_id2` int(10) unsigned NOT NULL,
  PRIMARY KEY (`value_id1`,`value_id2`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `feedmachine`
--

CREATE TABLE `feedmachine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `config_filename` varchar(64) NOT NULL,
  `filename` varchar(64) NOT NULL,
  `ftp_status` tinyint(1) NOT NULL DEFAULT '0',
  `ftp_server` varchar(128) NOT NULL,
  `ftp_path` varchar(128) NOT NULL,
  `ftp_username` varchar(64) NOT NULL,
  `ftp_password` varchar(128) NOT NULL,
  `ftp_upload_period` int(11) NOT NULL,
  `language_code` char(2) NOT NULL,
  `currency_code` char(3) NOT NULL,
  `countries_iso_2` char(2) NOT NULL,
  `url_parameters` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `config_filename` (`config_filename`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `geo_zones`
--

CREATE TABLE `geo_zones` (
  `geo_zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `geo_zone_name` varchar(32) NOT NULL,
  `geo_zone_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`geo_zone_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `geo_zones`
--

INSERT INTO `geo_zones` VALUES
(1, 'Florida', 'Florida local sales tax zone', NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `google_checkout`
--

CREATE TABLE `google_checkout` (
  `customers_id` int(11) DEFAULT NULL,
  `buyer_id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `google_configuration`
--

CREATE TABLE `google_configuration` (
  `google_configuration_key` varchar(255) DEFAULT NULL,
  `google_configuration_value` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `google_configuration`
--

INSERT INTO `google_configuration` VALUES
('GOOGLE_ANALYTICS_ID', 'NONE'),
('US_PO_BOX', 'True'),
('ENABLE_CARRIER_CALCULATED_SHIPPING', 'True'),
('CARRIER_CALCULATED_SHIPPING', 'fedexGrounddomestic_types_CCS:10|0|0, fedexHome Deliverydomestic_types_CCS:10|0|0, fedexExpress Saverdomestic_types_CCS:10|0|0, fedex2Daydomestic_types_CCS:10|0|0, fedexStandard Overnightdomestic_types_CCS:10|0|0, fedexPriority Overnightdomestic_types_CCS:10|0|0, fedexFirst Overnightdomestic_types_CCS:10|0|0, upsGrounddomestic_types_CCS:10|0|0, ups3 Day Selectdomestic_types_CCS:10|0|0, ups2nd Day Airdomestic_types_CCS:10|0|0, ups2nd Day Air AMdomestic_types_CCS:10|0|0, upsNext Day Air Saverdomestic_types_CCS:10|0|0, upsNext Day Airdomestic_types_CCS:10|0|0, upsNext Day Air Early AMdomestic_types_CCS:10|0|0, uspsMedia Maildomestic_types_CCS:10|0|0, uspsParcel Postdomestic_types_CCS:10|0|0, uspsExpress Maildomestic_types_CCS:10|0|0, uspsPriority Maildomestic_types_CCS:10|0|0'),
('ROUNDING_MODE', 'HALF_EVEN'),
('ROUNDING_RULE', 'PER_LINE'),
('HTACCESS_AUTH_MODE', 'False'),
('VIRTUAL_GOODS', 'False'),
('SANDBOX_MERCHANT_CALLBACK_PROTOCOL', 'https'),
('CART_EXPIRATION_TIME', 'NONE'),
('USE_CART_MESSAGING', 'False'),
('THIRD_PARTY_TRACKING_URL', 'NONE'),
('RESTRICTED_CATEGORIES', ''),
('CONTINUE_SHOPPING_URL', 'gc_return.php');

-- --------------------------------------------------------

--
-- Table structure for table `google_orders`
--

CREATE TABLE `google_orders` (
  `orders_id` int(11) DEFAULT NULL,
  `google_order_number` bigint(20) DEFAULT NULL,
  `order_amount` decimal(15,4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `help_pages`
--

CREATE TABLE `help_pages` (
  `current_page` varchar(255) NOT NULL,
  `help_page` varchar(255) NOT NULL,
  `help_page_title` varchar(255) NOT NULL,
  `language` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `help_pages`
--

INSERT INTO `help_pages` VALUES
('index.php', 'http://wiki.oscdox.com/v2.5/oscmax_docs', 'Help Index', 0),
('currencies.php', 'http://wiki.oscdox.com/v2.5/currencies', 'Currencies', 0),
('countries.php', 'http://wiki.oscdox.com/v2.5/countries', 'Countries', 0),
('admin_members.php', 'http://wiki.oscdox.com/v2.5/member_groups', 'Admin Members', 0),
('admin_files.php', 'http://wiki.oscdox.com/v2.5/files_access', 'File Access', 0),
('categories.php', 'http://wiki.oscdox.com/v2.5/categories_and_products', 'Categories', 0),
('products_attributes.php', 'http://wiki.oscdox.com/v2.5/products_attributes', 'Product Attributes', 0),
('manufacturers.php', 'http://wiki.oscdox.com/v2.5/manufacturers', 'Manufacturers', 0),
('reviews.php', 'http://wiki.oscdox.com/v2.5/reviews', 'Reviews', 0),
('easypopulate.php', 'http://wiki.oscdox.com/v2.5/easypopulate', 'Easy Populate', 0),
('modules.php', 'http://wiki.oscdox.com/v2.5/modules', 'Modules', 0),
('customers.php', 'http://wiki.oscdox.com/v2.5/customer', 'Customers', 0),
('customer_groups.php', 'http://wiki.oscdox.com/v2.5/customers_groups', 'Customer Groups', 0),
('create_order.php', 'http://wiki.oscdox.com/v2.5/create_order', 'Create Order', 0),
('backup.php', 'http://wiki.oscdox.com/v2.5/database_backup', 'Database Backup', 0),
('infobox_configuration.php', 'http://wiki.oscdox.com/v2.5/infoboxes', 'Infobox Configuration', 0),
('configuration.php?gID=1', 'http://wiki.oscdox.com/v2.5/my_store', 'My Store', 0),
('configuration.php?gID=2', 'http://wiki.oscdox.com/v2.5/minimum_values', 'Minimum Values', 0),
('configuration.php?gID=3', 'http://wiki.oscdox.com/v2.5/maximum_values', 'Maximum Values', 0),
('configuration.php?gID=4', 'http://wiki.oscdox.com/v2.5/images', 'Images', 0),
('configuration.php?gID=5', 'http://wiki.oscdox.com/v2.5/customer_details', 'Customer Details', 0),
('configuration.php?gID=7', 'http://wiki.oscdox.com/v2.5/shipping_packing', 'Shipping and Packing', 0),
('configuration.php?gID=8', 'http://wiki.oscdox.com/v2.5/product_listing', 'Product Listing', 0),
('configuration.php?gID=9', 'http://wiki.oscdox.com/v2.5/stock', 'Stock', 0),
('configuration.php?gID=10', 'http://wiki.oscdox.com/v2.5/logging', 'Logging', 0),
('configuration.php?gID=12', 'http://wiki.oscdox.com/v2.5/email_options', 'Email Options', 0),
('configuration.php?gID=13', 'http://wiki.oscdox.com/v2.5/downloads', 'Downloads', 0),
('configuration.php?gID=14', 'http://wiki.oscdox.com/v2.5/gzip_compression', 'GZip Compression', 0),
('configuration.php?gID=15', 'http://wiki.oscdox.com/v2.5/sessions', 'Sessions', 0),
('configuration.php?gID=16', 'http://wiki.oscdox.com/v2.5/site_maintenance', 'Site Maintenance', 0),
('configuration.php?gID=201', 'http://wiki.oscdox.com/v2.5/template_setup', 'Template Setup', 0),
('configuration.php?gID=203', 'http://wiki.oscdox.com/v2.5/notifications', 'Notifications', 0),
('configuration.php?gID=206', 'http://wiki.oscdox.com/v2.5/mailchimp_newsletters', 'Mail Chimp', 0);

-- --------------------------------------------------------

--
-- Table structure for table `http_error`
--

CREATE TABLE `http_error` (
  `error_number` int(11) NOT NULL AUTO_INCREMENT,
  `error_code` varchar(250) DEFAULT NULL,
  `error_url` varchar(250) DEFAULT NULL,
  `error_ip` varchar(250) DEFAULT NULL,
  `error_browser` varchar(250) DEFAULT NULL,
  `error_refer` varchar(250) DEFAULT NULL,
  `error_timestamp` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`error_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `information`
--

CREATE TABLE `information` (
  `information_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `information_group_id` int(11) unsigned NOT NULL DEFAULT '0',
  `information_title` varchar(255) NOT NULL DEFAULT '',
  `information_description` text NOT NULL,
  `information_url` varchar(255) NOT NULL,
  `information_target` varchar(255) NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `sort_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `visible` enum('1','0') NOT NULL DEFAULT '1',
  `show_in_infobox` enum('1','0') NOT NULL DEFAULT '1',
  `language_id` int(11) NOT NULL DEFAULT '0',
  `info_cg_hide` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`information_id`,`language_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `information`
--

INSERT INTO `information` VALUES
(1, 2, 'TEXT_GREETING_PERSONAL', 'Welcome back <span class="greetUser">%s!</span> Would you like to see which <a href="%s"><u>new products</u></a> are available to purchase?', '', '_top', 0, 1, '1', '1', 1, NULL),
(1, 2, 'TEXT_GREETING_PERSONAL', 'Sch&ouml;n das Sie wieder da sind <span class="greetUser">%s!</span> M&ouml;chten Sie die <a href="%s"><u>neue Produkte</u></a> ansehen?', '', '_top', 0, 1, '1', '1', 2, NULL),
(1, 2, 'TEXT_GREETING_PERSONAL', 'Â¡Bienvenido de nuevo <span class="greetUser">%s!</span> Â¿Le gustarÃ­a ver quÃ© <a href="%s"><u>nuevos productos</u></a> hay disponibles?', '', '_top', 0, 1, '1', '1', 3, NULL),
(2, 2, 'TEXT_GREETING_PERSONAL_RELOGON', '<small>If you are not %s, please <a href="%s"><u>log yourself in</u></a> with your account information.</small>', '', '_top', 0, 2, '1', '1', 1, NULL),
(2, 2, 'TEXT_GREETING_PERSONAL_RELOGON', '<small>Wenn Sie nicht %s sind, melden Sie sich bitte <a href="%s"><u>hier</u></a> mit Ihrem Kundenkonto an.</small>', '', '_top', 0, 2, '1', '1', 2, NULL),
(2, 2, 'TEXT_GREETING_PERSONAL_RELOGON', '<small>Si no es %s, por favor <a href="%s"><u>entre aquÃ­</u></a> e introduzca sus datos.</small>', '', '_top', 0, 2, '1', '1', 3, NULL),
(3, 2, 'TEXT_GREETING_GUEST', 'Welcome <span class="greetUser">Guest!</span> Would you like to <a href="%s"><u>log yourself in</u></a>? Or would you prefer to <a href="%s"><u>create an account</u></a>?', '', '_top', 0, 3, '1', '1', 1, NULL),
(3, 2, 'TEXT_GREETING_GUEST', 'Herzlich Willkommen <span class="greetUser">Gast!</span> M&ouml;chten Sie sich <a href="%s"><u>anmelden</u></a>? Oder wollen Sie ein <a href="%s"><u>Kundenkonto</u></a> er&ouml;ffnen?', '', '_top', 0, 3, '1', '1', 2, NULL),
(3, 2, 'TEXT_GREETING_GUEST', 'Â¡Bienvenido <span class="greetUser">Invitado!</span> Â¿Le gustarÃ­a <a href="%s"><u>entrar en su cuenta</u></a> o preferirÃ­a <a href="%s"><u>crear una cuenta nueva</u></a>?', '', '_top', 0, 3, '1', '1', 3, NULL),
(8, 1, 'Shipping &amp; Returns', '<p>\r\n	This Page is for your shipping policies. Edit this in your admin panel under Configuration &gt;&gt; Templates &gt;&gt; Information Pages</p>', '', '_top', 0, 3, '1', '1', 1, NULL),
(8, 1, 'Versandkosten und RÃ¼cksendungen', '<p>\r\n	&nbsp;</p>\r\n<div style="font-family: Arial, Verdana, sans-serif; font-size: 12px; color: rgb(34, 34, 34); background-color: rgb(255, 255, 255); ">\r\n	<p>\r\n		This Page is for your shipping policies. Edit this in your admin panel under Configuration &gt;&gt; Templates &gt;&gt; Information Pages</p>\r\n</div>', '', '_top', 0, 3, '1', '1', 2, NULL),
(8, 1, 'EnvÃ­os/Devoluciones', '<p>\r\n	&nbsp;</p>\r\n<div style="font-family: Arial, Verdana, sans-serif; font-size: 12px; color: rgb(34, 34, 34); background-color: rgb(255, 255, 255); ">\r\n	<p>\r\n		Esta pÃ¡gina es para las polÃ­ticas de envÃ­o. EdÃ­tala en el panel de administraciÃ³n en la secciÃ³n ConfiguraciÃ³n &gt;&gt; Plantillas &gt;&gt; PÃ¡ginas de informaciÃ³n</p>\r\n</div>', '', '_top', 0, 3, '1', '1', 3, NULL),
(9, 1, 'Gift Voucher FAQ', '<p>\r\n	<b>Purchasing Gift Vouchers</b></p>\r\n<p>\r\n	Gift Vouchers are purchased just like any other item in our store. You can pay for them using the store&#39;s standard payment method(s). Once purchased the value of the Gift Voucher will be added to your own personal Gift Voucher Account. If you have funds in your Gift Voucher Account, you will notice that the amount now shows in the Shopping Cart box, and also provides a link to a page where you can send the Gift Voucher to someone via email.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<b>How to Send Gift Vouchers</b></p>\r\n<p>\r\n	To send a Gift Voucher that you have purchased, you need to go to our Send Gift Voucher Page. You can find the link to this page in the Shopping Cart Box in the right hand column of each page. When you send a Gift Voucher, you need to specify the following:<br />\r\n	<br />\r\n	The name of the person you are sending the Gift Voucher to.<br />\r\n	The email address of the person you are sending the Gift Voucher to.<br />\r\n	The amount you want to send. (Note you don&#39;t have to send the full amount that is in your Gift Voucher Account.)&nbsp;<br />\r\n	A short message which will appear in the email.<br />\r\n	<br />\r\n	Please ensure that you have entered all of the information correctly, although you will be given the opportunity to change this as much as you want before the email is actually sent.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<b>Buying with Gift Vouchers</b></p>\r\n<p>\r\n	If you have funds in your Gift Voucher Account, you can use those funds to purchase other items in our store. At the checkout stage, an extra box will appear. Clicking this box will apply those funds in your Gift Voucher Account. Please note, you will still have to select another payment method if there is not enough in your Gift Voucher Account to cover the cost of your purchase. If you have more funds in your Gift Voucher Account than the total cost of your purchase the balance will be left in your Gift Voucher Account for the future.</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<b>Redeeming Gift Vouchers</b></p>\r\n<p>\r\n	If you receive a Gift Voucher by email it will contain details of who sent you the Gift Voucher, along with possibly a short message from them. The Email will also contain the Gift Voucher Number. It is probably a good idea to print out this email for future reference. You can now redeem the Gift Voucher in two ways:</p>\r\n<ol>\r\n	<li>\r\n		By clicking on the link contained within the email for this express purpose. This will take you to the store&#39;s Redeem Voucher page. you will then be requested to create an account, before the Gift Voucher is validated and placed in your Gift Voucher Account ready for you to spend it on whatever you want.<br />\r\n		&nbsp;</li>\r\n	<li>\r\n		During the checkout process, on the same page that you select a payment method there will be a box to enter a Redeem Code. Enter the code here, and click the redeem button. The code will be validated and added to your Gift Voucher account. You can then use the amount to purchase any item from our store</li>\r\n</ol>', '', '_top', 0, 4, '1', '1', 1, NULL),
(9, 1, 'Geschenkgutschein FAQ', '<p><b>Geschenkgutscheine kaufen</b></p><p>Geschenkgutscheine k&ouml;nnen Sie genau so wie jedes andere Produkt in unserem Shop erwerben. Die Bezahlung erfolgt &uuml;ber die angebotenen Zahlungsarten. Danach wird der Gutschein Ihrem pers&ouml;nlichen Gutscheinkonto hinzugef&uuml;gt. In diesem Fall wird der Gutscheinwert in Ihrem Warenkorb angezeigt. Dort finden Sie auch einen Link, &uuml;ber den Sie den Gutschein an jemanden per E-Mail verschenken k&ouml;nnen.</p><p>&nbsp;</p><p><b>Geschenkgutscheine versenden</b></p><p>Einen Geschenkgutschein, den Sie erworben haben,&nbsp; versenden Sie &uuml;ber die Seite &quot;Geschenkgutschein versenden&quot;.&nbsp; Den Link zu dieser Seite finden Sie im Warenkorbfenster in der rechten Spalte auf jeder Seite. Beim Versand eines Geschenkgutscheines m&uuml;ssen Sie Folgendes angeben:<br /><br />Der Name des Empf&auml;ngers<br />Die E-Mail-Adresse des Empf&auml;ngers&#39;<br />Den Wert des Gutscheines (Hinweis: Es mu&szlig; sich nicht um den Gesamtbetrag Ihres Gutscheinkontos handeln.)&nbsp;<br />Eine Nachricht an den Gutscheinempf&auml;nger<br /><br />Bitte versichern Sie sich, dass alle Angaben korrekt sind. Sie k&ouml;nnen die Angaben jedoch vor dem tats&auml;chlichen Versand der E-Mail unbegrenzt &auml;ndern.</p><p>&nbsp;</p><p><b>Mit Geschenkgutscheinen einkaufen</b></p><p>Falls Sie ein Guthaben auf Ihrem Geschenkgutscheinkonto haben, k&ouml;nnen Sie damit in unserem Shop einkaufen. W&auml;hrend des Bestellvorganges erscheint eine zus&auml;tzliche Box. Ein Klick auf diese Box zieht Ihr Guthaben vom Rechnungsbetrag ab. Falls das Guthaben nicht f&uuml;r den gesamten Rechnungsbetrag ausreicht, w&auml;hlen Sie bitte f&uuml;r den Rest eine der angebotenen Zahlungsarten. Falls Ihr Guthaben den Rechnungsbetrag &uuml;bersteigt, verbleibt die Differenz auf Ihrem Guthabenkonto.</p><p>&nbsp;</p><p><b>Geschenkgutscheine</b></p><p>Wenn&nbsp; Sie einen Geschenkgutschein per E-Mail erhalten haben, so enth&auml;lt finden Sie darin neben dem Absender und eventuell einer kurzen Nachricht die Gutscheinnummer. Sie k&ouml;nnen den Gutschein auf zweierlei Arten einl&ouml;sen:</p><ol><li>Klicken Sie auf den Link, der Sie auf eine Seite unseres Shops leitet, wo Sie den Gutschein mit Ihrem Kundenkonto verkn&uuml;pfen k&ouml;nnen. Nachdem der Gutschein von uns freigeschaltet wurde, k&ouml;nnen Sie den Betrag nach Belieben f&uuml;r Eink&auml;ufe in unserem Shop verwenden.<br />&nbsp;</li><li>W&auml;hrend des Bestellvorganges k&ouml;nnen Sie die Gutscheinnummer direkt in ein Formularfeld eingeben. Durch einen Klick auf &quot;Einl&ouml;sen&quot; wird der Betrag Ihrem Gutscheink&ouml;nto hinzugef&uuml;gt und kann f&uuml;r Eink&auml;ufe verwendet werden.</li></ol>', '', '_top', 0, 4, '1', '1', 2, NULL),
(9, 1, 'FAQ cheques regalo', '', '', '_top', 0, 4, '1', '1', 3, NULL),
(10, 1, 'Privacy Notice', '<p>\r\n	Privacy Policy</p>', '', '_top', 0, 5, '1', '1', 1, NULL),
(10, 1, 'PrivatsphÃ¤re und Datenschutz', '', '', '_top', 0, 5, '1', '1', 2, NULL),
(10, 1, 'Privacidad', '', '', '_top', 0, 5, '1', '1', 3, NULL),
(11, 1, 'Conditions of Use', '<p>\r\n	Conditions of Use</p>', '', '_top', 0, 6, '1', '1', 1, NULL),
(11, 1, 'AGB', '<p>Unsere Allgemeinen Gesch&auml;ftsbedingungen</p>', '', '_top', 0, 6, '1', '1', 2, NULL),
(11, 1, 'Condiciones de uso', '<p>\r\n	Condiciones de uso</p>', '', '_top', 0, 6, '1', '1', 3, NULL),
(12, 1, 'Down for maintenance', '<p>The site is currently down for maintenance. Please excuse the dust, and try back later.</p>', '', '_top', 0, 2, '0', '1', 1, NULL),
(12, 1, 'Wartungsarbeiten', '<p>Diese Website ist derzeit wegen Wartungsarbeiten leider nicht erreichbar. Bitte besuchen Sie uns sp&auml;ter noch einmal.</p>', '', '_top', 0, 2, '0', '1', 2, NULL),
(12, 1, 'Cerrado por mantenimiento', '<p>El sitio estÃ¡ actualmente cerrado por mantenimiento. Por favor, intÃ©ntelo de nuevo mÃ¡s tarde.</p>', '', '_top', 0, 2, '0', '1', 3, NULL),
(13, 1, 'Index Page Text', '<p><font face="arial, helvetica, sans-serif">To modify the content of this page, go to your Admin Panel -> Configuration -> Templates -> Information Pages.</font></p><hr /><p><font face="arial, helvetica, sans-serif">This is osCmax v2.5, the power e-commerce shopping cart system.</font></p><p><font face="Arial">The official <strong><em>osCmax </em></strong>Support Site is <a href="http://www.oscmax.com/"><font color="#800080">http://www.oscmax.com</font></a> . There are very active support forums, the wiki, documentation, downloads, and everything else related to <strong><em>osCmax.</em></strong></font></p>', '', '_top', 0, 1, '0', '1', 1, NULL),
(13, 1, 'Index-Seite Text', '<p><font face="arial, helvetica, sans-serif">&Auml;ndern Sie diesen Text im Admin Panel unter -&gt; Einstellungen -&gt; Templates -&gt; Informationsseiten.</font></p><hr /><p><font face="arial, helvetica, sans-serif">Dies ist osCmax v2.5, das m&auml;chtige Onlineshop-System.</font></p><p><font face="Arial">Die offizielle osCmax Support Seite finden Sie unter <a href="http://www.oscmax.com">http://www.oscmax.com</a>. Es existieren dort sehr aktive Support-Foren, ein Wiki, Anleitungen, Downloads und vieles mehr.</font></p>', '', '_top', 0, 1, '0', '1', 2, NULL),
(13, 1, 'Texto pÃ¡gina inicio', '<p><font face="arial, helvetica, sans-serif">Para modificar el contenido de esta pÃ¡gina, vaya al Panel de administraciÃ³n -> ConfiguraciÃ³n -> Plantillas -> PÃ¡ginas de informaciÃ³n.</font></p><hr /><p><font face="arial, helvetica, sans-serif">Esto es osCmax v2.5, completo sistema de compras de comercio electrÃ³nico.</font></p><p><font face="Arial">El sitio web de soporte es <a href="http://www.oscmax.com/"><font color="#800080">http://www.oscmax.com</font></a>. Hay foros de soporte muy activos, wiki, documentaciÃ³n, descargas y todo lo relacionado con <strong><em>osCmax.</em></strong>.</font></p>', '', '_top', 0, 1, '0', '1', 3, NULL),
(14, 1, 'Affiliate Terms and Conditions', '<p style="font-family: Verdana, Arial, sans-serif; font-size: 11px; line-height: 1.5; ">\r\n	<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(255, 0, 0); font-weight: bold; ">By filling out the signup form you acknowledge that you have read the terms and conditions below for the YOURCOMPANYNAMEorWEBSITE AFFILIATE Program, understand, and agree with them.</span></p>\r\n<p style="font-family: Verdana, Arial, sans-serif; font-size: 11px; line-height: 1.5; ">\r\n	<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); "><b>1. Joining the Program</b><br />\r\n	By filling out the signup form you will automatically become an AFFILIATE and are bound by the terms of this agreement. Your participation in the program is solely for this purpose: to legally advertise our website to receive a commission on products purchased by your referral individuals.</span></p>\r\n<p style="font-family: Verdana, Arial, sans-serif; font-size: 11px; line-height: 1.5; ">\r\n	<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); "><b>2. Payment Schedule</b></span></p>\r\n<ol type="a">\r\n	<li>\r\n		<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); ">Eligible payments - all AFFILIATE monies due for orders generated as a result of AFFILIATE links/Web Site will be held for 30 days after the Shipping Date of an order. Orders are typically shipped 1-7 days after a order is placed. This allows us ample time to compensate for returns, exchanges or canceled orders. Payments will be calculated and checks sent out to AFFILIATE during the last week of any given month according to the terms and conditions of this document.</span></li>\r\n	<li>\r\n		<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); ">AFFILIATE Payments - payment to AFFILIATE will not be rendered for amounts less than $10.00 USD unless requested by AFFILIATE. Example: if you have a total of $50.00 in sales you would have $5.00 in your affiliate account, thus your account will carry over ino the next months cycle. When your account total reaches $10.00 or more you will be sent a check provided all orders associated meet the condiditons set forth in (a) above.</span></li>\r\n	<li>\r\n		<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); ">Store Credit (Doggie Dollars) can be issued upon request in lieu of payment by check to AFFILIATE.</span></li>\r\n</ol>\r\n<p style="font-family: Verdana, Arial, sans-serif; font-size: 11px; line-height: 1.5; ">\r\n	&nbsp;</p>\r\n<p style="font-family: Verdana, Arial, sans-serif; font-size: 11px; line-height: 1.5; ">\r\n	<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); "><b>3. Revocation of AFFILIATE Status</b><br />\r\n	Your AFFILIATE application and status in the program may be suspended or terminated for any of the following reasons:</span></p>\r\n<p>\r\n	<li>\r\n		<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); ">Inappropriate advertisements (False claims, misleading hyperlinks)</span></li>\r\n</p>\r\n<p>\r\n	<li>\r\n		<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); ">Spamming (mass email, mass newsgroup posting, etc...)</span></li>\r\n</p>\r\n<p>\r\n	<li>\r\n		<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); ">Advertising on sites containing/promoting illegal activities</span></li>\r\n</p>\r\n<p>\r\n	<li>\r\n		<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); ">Violation of intellectual property rights.</span>\r\n		<p style="font-family: Verdana, Arial, sans-serif; font-size: 11px; line-height: 1.5; ">\r\n			<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); "><b>4. AFFILIATE Links</b><br />\r\n			You may use graphic and text links both on your Web Site and in emails. The site may also be advertised &quot;offline&quot; in classified ads, magazines, and newpapers. You may use the graphics and text provided to you by us, or you may create your own as long as they are approved by us first.</span></p>\r\n		<p style="font-family: Verdana, Arial, sans-serif; font-size: 11px; line-height: 1.5; ">\r\n			<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); "><b>5. AFFILIATE Tracking</b><br />\r\n			When a web surfer clicks through your AFFILIATE link, a cookie is set in their browser that contains your AFFILIATE username. Also, their IP address is tracked in the database along with your AFFILIATE name. When this person decides to buy a product, the script will look for this cookie and/or try to match their IP address to identify the AFFILIATE who will be awarded the commission. Visitors sent through your AFFILIATE link may make a purchase later in time and the commission will still be awarded if the cookie is present in their browser and/or the are using the same IP address as the one logged in the database.</span></p>\r\n		<p style="font-family: Verdana, Arial, sans-serif; font-size: 11px; line-height: 1.5; ">\r\n			<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); "><b>6. Terms of the agreement</b><br />\r\n			These terms will begin upon your signup with the AFFILIATE program and will end when your AFFILIATE account is terminated. The terms of this agreement may be modified by us at any time. If any modification to the terms is unnacceptable to you, your only choice is to terminate your AFFILIATE account. Your continuing participation in the program will constitute your acceptance of any change.</span></p>\r\n		<p style="font-family: Verdana, Arial, sans-serif; font-size: 11px; line-height: 1.5; ">\r\n			<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); "><b>7. Liability</b><br />\r\n			We will not be liable for indirect or accidental damages (loss of revenue, commissions) due to AFFILIATE tracking failures, loss of database files, and any results of &quot;intents of harm&quot; to the program or our website. We do not make any expressed or implied warranties with respect to the AFFILIATE program and/or products sold at this site. We make no claim that the operation of the AFFILIATE program and our website will be error-free and we will not be liable for any interruptions or errors.&nbsp;<br />\r\n			<br />\r\n			Affiliate further agrees and warrants that it will comply with all local, state and federal laws (including, but not limited to, the &quot;CAN-SPAM&quot; Act, effective January 1, 2004) regarding the sending of e-mails.&nbsp;<br />\r\n			<br />\r\n			AFFILIATE shall indemnify and hold YOURCOMPANYNAMEorWEBSITE harmless from any and all legal actions, damages or liabilities incurred from the day-to-day operations of AFFILIATE. Under no circumstances will YOURCOMPANYNAMEorWEBSITE be liable whether in tort, contract or otherwise for indirect, incidental, consequential, special or exemplary damages (including but not limited to damages for any loss of revenue, profits, business interruption, loss of business information or data, loss of goodwill, work stoppage, hardware or software failure, or other pecuniary loss) arising from or relating to any provision of this Agreement or the program. Without limiting the foregoing, YOURCOMPANYNAMEorWEBSITE aggregate liability arising with respect to this Agreement will not exceed the total fees paid or payable to AFFILIATE under this agreement.&nbsp;<br />\r\n			<br />\r\n			YOURCOMPANYNAMEorWEBSITE will own all right, title and interest in and to all information that is created or collected in the operation of the YOURCOMPANYNAMEorWEBSITE Web site and reserves the right to amend or terminate this Agreement at any time, with or without notice to AFFILIATE.&nbsp;<br />\r\n			<br />\r\n			The laws of the State of California shall govern this Agreement. Should there be any legal dispute between the parties, then both parties agree to take the matter before arbitration/mediation in Placer County , CA should YOURCOMPANYNAMEorWEBSITE request arbitration/mediation in lieu of formal legal process. Both parties mutually agree that the sole legal venue for all disputes shall be in the Placer County General District Court, CA.</span></p>\r\n		<p style="font-family: Verdana, Arial, sans-serif; font-size: 11px; line-height: 1.5; ">\r\n			<span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(0, 0, 0); "><span style="font-family: verdana, tahoma, arial; font-size: 10pt; color: rgb(255, 0, 0); font-weight: bold; ">By filling out the signup form you acknowledge that you have read the terms and conditions above for the YOURCOMPANYNAMEorWEBSITE AFFILIATE Program, understand, and agree with them.</span></span></p>\r\n	</li>\r\n</p>', '', '_top', 0, 7, '0', '1', 1, NULL),
(14, 1, 'Affiliate AGB', 'Legen Sie Ihre Affiliate-Bedingungen hier.', '', '_top', 0, 7, '0', '1', 2, NULL),
(14, 1, 'TÃ©rminos y condiciones afiliados ', 'Introduzca aquÃ­ los tÃ©rminos y condiciones de afiliados.', '', '_top', 0, 7, '0', '1', 3, NULL),
(15, 1, 'Affiliate Information', '<p>\r\n	Your Affiliate Information goes in here</p>', '', '_top', 0, 8, '1', '1', 1, NULL),
(15, 1, 'Affiliate-Information', '<p>F&uuml;gen Sie hier Ihre Informationen zum Affiliateprogramm ein.</p>', '', '_top', 0, 8, '1', '1', 2, NULL),
(15, 1, 'InformaciÃ³n afiliado', '<p>\r\n	Su informaciÃ³n de afiliado va aquÃ­</p>', '', '_top', 0, 8, '1', '1', 3, NULL),
(16, 1, 'Affiliate Program FAQ', '<p>\r\n	Your Affiliate FAQ goes in here</p>', '', '_top', 0, 8, '1', '0', 1, NULL),
(16, 1, 'Affiliateprogramm FAQ', '<p>F&uuml;gen Sie hier Ihre FAQ Informationen zum Affiliateprogramm ein.</p>', '', '_top', 0, 8, '1', '0', 2, NULL),
(16, 1, 'FAQ del Programa de afiliados', '<p>\r\n	Su informaciÃ³n FAQ de afiliado va aquÃ­</p>', '', '_top', 0, 8, '1', '0', 3, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `information_group`
--

CREATE TABLE `information_group` (
  `information_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `information_group_title` varchar(64) NOT NULL DEFAULT '',
  `information_group_description` varchar(255) NOT NULL DEFAULT '',
  `sort_order` int(5) DEFAULT NULL,
  `visible` int(1) DEFAULT '1',
  `locked` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`information_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `information_group`
--

INSERT INTO `information_group` VALUES
(1, 'Information pages', 'Information pages', 1, 1, ''),
(2, 'Welcome message', 'Welcome message', 2, 1, 'information_title, sort_order, parent_id, visible, info_cg_hide, show_in_infobox, information_url, information_target');

-- --------------------------------------------------------

--
-- Table structure for table `languages`
--

CREATE TABLE `languages` (
  `languages_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `code` char(2) NOT NULL,
  `image` varchar(64) DEFAULT NULL,
  `directory` varchar(32) DEFAULT NULL,
  `sort_order` int(3) DEFAULT NULL,
  `meta_keywords` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`languages_id`),
  KEY `IDX_LANGUAGES_NAME` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `languages`
--

INSERT INTO `languages` VALUES
(1, 'English', 'en', 'icon.gif', 'english', 1, ''),
(2, 'Deutsch', 'de', 'icon.gif', 'german', 2, ''),
(3, 'EspaÃ±ol', 'es', 'icon.gif', 'espanol', 3, '');

-- --------------------------------------------------------

--
-- Table structure for table `manufacturers`
--

CREATE TABLE `manufacturers` (
  `manufacturers_id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturers_name` varchar(32) NOT NULL,
  `manufacturers_image` varchar(64) DEFAULT NULL,
  `manufacturers_featured_until` date DEFAULT NULL,
  `manufacturers_featured` tinyint(1) DEFAULT '0',
  `manufacturer_featured_until` date DEFAULT NULL,
  `manufacturer_featured` tinyint(1) DEFAULT '0',
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`manufacturers_id`),
  KEY `IDX_MANUFACTURERS_NAME` (`manufacturers_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `manufacturers_info`
--

CREATE TABLE `manufacturers_info` (
  `manufacturers_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `manufacturers_url` varchar(255) NOT NULL,
  `manufacturers_description` text,
  `url_clicked` int(5) NOT NULL DEFAULT '0',
  `date_last_click` datetime DEFAULT NULL,
  PRIMARY KEY (`manufacturers_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `newsletters`
--

CREATE TABLE `newsletters` (
  `newsletters_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `module` varchar(255) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_sent` datetime DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  `locked` int(1) DEFAULT '0',
  PRIMARY KEY (`newsletters_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `orders_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `customers_name` varchar(64) NOT NULL,
  `customers_company` varchar(32) DEFAULT NULL,
  `customers_street_address` varchar(64) NOT NULL,
  `customers_suburb` varchar(32) DEFAULT NULL,
  `customers_city` varchar(32) NOT NULL,
  `customers_postcode` varchar(10) NOT NULL,
  `customers_state` varchar(32) DEFAULT NULL,
  `customers_country` varchar(32) NOT NULL,
  `customers_telephone` varchar(32) NOT NULL,
  `customers_email_address` varchar(96) NOT NULL,
  `customers_address_format_id` int(5) NOT NULL,
  `customers_dummy_account` tinyint(3) unsigned NOT NULL,
  `delivery_name` varchar(64) NOT NULL,
  `delivery_company` varchar(32) DEFAULT NULL,
  `delivery_street_address` varchar(64) NOT NULL,
  `delivery_suburb` varchar(32) DEFAULT NULL,
  `delivery_city` varchar(32) NOT NULL,
  `delivery_postcode` varchar(10) NOT NULL,
  `delivery_state` varchar(32) DEFAULT NULL,
  `delivery_country` varchar(32) NOT NULL,
  `delivery_address_format_id` int(5) NOT NULL,
  `delivery_date` datetime NOT NULL,
  `billing_name` varchar(64) NOT NULL,
  `billing_company` varchar(32) DEFAULT NULL,
  `billing_street_address` varchar(64) NOT NULL,
  `billing_suburb` varchar(32) DEFAULT NULL,
  `billing_city` varchar(32) NOT NULL,
  `billing_postcode` varchar(10) NOT NULL,
  `billing_state` varchar(32) DEFAULT NULL,
  `billing_country` varchar(32) NOT NULL,
  `billing_address_format_id` int(5) NOT NULL,
  `payment_method` varchar(255) NOT NULL,
  `cc_type` varchar(20) DEFAULT NULL,
  `cc_owner` varchar(64) DEFAULT NULL,
  `cc_number` varchar(32) DEFAULT NULL,
  `cc_expires` varchar(4) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_purchased` datetime DEFAULT NULL,
  `orders_status` int(5) NOT NULL,
  `orders_date_finished` datetime DEFAULT NULL,
  `currency` char(3) DEFAULT NULL,
  `currency_value` decimal(14,6) DEFAULT NULL,
  `paypal_ipn_id` int(11) NOT NULL DEFAULT '0',
  `fedex_tracking` varchar(20) NOT NULL,
  `purchased_without_account` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `shipping_tax` decimal(7,4) NOT NULL DEFAULT '0.0000',
  `shipping_module` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`orders_id`),
  KEY `idx_orders_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_premade_comments`
--

CREATE TABLE `orders_premade_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `orders_premade_comments`
--

INSERT INTO `orders_premade_comments` VALUES
(1, 'Thank you for your custom', 'Thank you for your custom.'),
(2, 'Out of stock when ordered', 'Unfortunately, your item was out of stock when the order was placed. It will despatch as soon as we receive it.');

-- --------------------------------------------------------

--
-- Table structure for table `orders_products`
--

CREATE TABLE `orders_products` (
  `orders_products_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `products_id` int(11) NOT NULL,
  `products_model` varchar(24) DEFAULT NULL,
  `products_code` varchar(40) NOT NULL,
  `products_name` varchar(64) NOT NULL,
  `products_price` decimal(15,4) NOT NULL,
  `final_price` decimal(15,4) NOT NULL,
  `products_tax` decimal(7,4) NOT NULL,
  `products_quantity` int(2) NOT NULL,
  `products_stock_attributes` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`orders_products_id`),
  KEY `idx_orders_products_orders_id` (`orders_id`),
  KEY `idx_orders_products_products_id` (`products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_products_attributes`
--

CREATE TABLE `orders_products_attributes` (
  `orders_products_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `products_options` varchar(32) NOT NULL,
  `products_options_values` varchar(32) NOT NULL,
  `code_suffix` varchar(16) NOT NULL,
  `options_values_price` decimal(15,4) NOT NULL,
  `price_prefix` char(1) NOT NULL,
  `weight_prefix` char(1) NOT NULL,
  `options_values_weight` decimal(6,3) NOT NULL DEFAULT '0.000',
  PRIMARY KEY (`orders_products_attributes_id`),
  KEY `idx_orders_products_att_orders_id` (`orders_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_products_download`
--

CREATE TABLE `orders_products_download` (
  `orders_products_download_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `orders_products_id` int(11) NOT NULL DEFAULT '0',
  `orders_products_filename` varchar(255) NOT NULL,
  `download_maxdays` int(2) NOT NULL DEFAULT '0',
  `download_count` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`orders_products_download_id`),
  KEY `idx_orders_products_download_orders_id` (`orders_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_status`
--

CREATE TABLE `orders_status` (
  `orders_status_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `orders_status_name` varchar(32) NOT NULL,
  `public_flag` int(11) DEFAULT '1',
  `downloads_flag` int(11) DEFAULT '0',
  PRIMARY KEY (`orders_status_id`,`language_id`),
  KEY `idx_orders_status_name` (`orders_status_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `orders_status`
--

INSERT INTO `orders_status` VALUES
(1, 1, 'Pending', 1, 0),
(1, 2, 'Offen', 1, 0),
(1, 3, 'Pendiente', 1, 0),
(2, 1, 'Processing', 1, 1),
(2, 2, 'In Bearbeitung', 1, 1),
(2, 3, 'Proceso', 1, 1),
(3, 1, 'Delivered', 1, 1),
(3, 2, 'Versendet', 1, 1),
(3, 3, 'Entregado', 1, 1),
(4, 1, 'Customer Comment', 1, 0),
(4, 2, 'Kunden Kommentar', 1, 0),
(4, 3, 'Comentario del cliente', 1, 0),
(5, 1, 'Customer Comment (DL)', 1, 1),
(5, 2, 'Kunden Kommentar (DL)', 1, 1),
(5, 3, 'Comentario del cliente (DL)', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `orders_status_history`
--

CREATE TABLE `orders_status_history` (
  `orders_status_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_status_id` int(5) NOT NULL,
  `date_added` datetime NOT NULL,
  `customer_notified` int(1) DEFAULT '0',
  `comments` text,
  PRIMARY KEY (`orders_status_history_id`),
  KEY `idx_orders_status_history_orders_id` (`orders_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_status_history_transactions`
--

CREATE TABLE `orders_status_history_transactions` (
  `orders_status_history_id` int(11) NOT NULL,
  `transaction_id` varchar(64) NOT NULL,
  `transaction_type` varchar(32) NOT NULL,
  `payment_type` varchar(32) NOT NULL,
  `payment_status` varchar(32) NOT NULL,
  `transaction_amount` decimal(7,2) NOT NULL,
  `module_code` varchar(32) NOT NULL,
  `transaction_avs` varchar(64) NOT NULL,
  `transaction_cvv2` varchar(64) NOT NULL,
  `transaction_msgs` varchar(255) NOT NULL,
  PRIMARY KEY (`orders_status_history_id`),
  KEY `transaction_id` (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `orders_total`
--

CREATE TABLE `orders_total` (
  `orders_total_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `text` varchar(255) NOT NULL,
  `value` decimal(15,4) NOT NULL,
  `class` varchar(32) NOT NULL,
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY (`orders_total_id`),
  KEY `idx_orders_total_orders_id` (`orders_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `packaging`
--

CREATE TABLE `packaging` (
  `package_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_name` varchar(64) NOT NULL,
  `package_description` varchar(255) NOT NULL,
  `package_length` decimal(6,2) NOT NULL DEFAULT '5.00',
  `package_width` decimal(6,2) NOT NULL DEFAULT '5.00',
  `package_height` decimal(6,2) NOT NULL DEFAULT '5.00',
  `package_empty_weight` decimal(6,2) NOT NULL DEFAULT '0.00',
  `package_max_weight` decimal(6,2) NOT NULL DEFAULT '50.00',
  `package_cost` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paypal_ipn`
--

CREATE TABLE `paypal_ipn` (
  `paypal_ipn_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `txn_type` int(10) unsigned NOT NULL DEFAULT '0',
  `reason_code` int(11) DEFAULT NULL,
  `payment_type` int(11) NOT NULL DEFAULT '0',
  `payment_status` int(11) NOT NULL DEFAULT '0',
  `pending_reason` int(11) DEFAULT NULL,
  `invoice` varchar(64) DEFAULT NULL,
  `mc_currency` int(11) NOT NULL DEFAULT '1',
  `first_name` varchar(32) NOT NULL,
  `last_name` varchar(32) NOT NULL,
  `payer_business_name` varchar(32) DEFAULT NULL,
  `address_name` varchar(32) NOT NULL,
  `address_street` varchar(64) NOT NULL,
  `address_city` varchar(32) NOT NULL,
  `address_state` varchar(32) NOT NULL,
  `address_zip` varchar(64) NOT NULL,
  `address_country` varchar(32) NOT NULL,
  `address_status` varchar(64) NOT NULL,
  `address_owner` varchar(64) NOT NULL DEFAULT '0',
  `payer_email` varchar(96) NOT NULL,
  `ebay_address_id` varchar(96) DEFAULT NULL,
  `payer_id` varchar(32) NOT NULL,
  `payer_status` varchar(32) NOT NULL,
  `payment_date` varchar(32) NOT NULL,
  `business` varchar(32) NOT NULL,
  `receiver_email` varchar(96) NOT NULL,
  `receiver_id` varchar(32) NOT NULL,
  `paypal_address_id` varchar(64) NOT NULL,
  `txn_id` varchar(17) NOT NULL,
  `notify_version` varchar(17) NOT NULL,
  `verify_sign` varchar(64) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`paypal_ipn_id`,`txn_id`),
  KEY `idx_paypal_ipn_paypal_ipn_id` (`paypal_ipn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `pm_configuration`
--

CREATE TABLE `pm_configuration` (
  `pm_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_title` varchar(255) NOT NULL,
  `pm_description` varchar(255) NOT NULL,
  `pm_filename` varchar(255) NOT NULL,
  `pm_active` tinyint(1) NOT NULL DEFAULT '1',
  `pm_page` varchar(255) NOT NULL,
  `pm_cg_hide` varchar(255) NOT NULL,
  `pm_sort_order` int(11) NOT NULL,
  `last_modified` datetime NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`pm_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

--
-- Dumping data for table `pm_configuration`
--

INSERT INTO `pm_configuration` VALUES
(1, 'Specials', 'Special Products Module', 'default_specials.php', 1, 'index', '', 4, '[[regtime]]', '[[regtime]]'),
(2, 'New Products', 'New Products Module', 'new_products.php', 1, 'index', '', 5, '[[regtime]]', '[[regtime]]'),
(3, 'Upcoming Products', 'Upcoming products module', 'upcoming_products.php', 1, 'index', '', 7, '[[regtime]]', '[[regtime]]'),
(4, 'Cross Sell Module', 'Cross Sell Module', 'xsell_products.php', 1, 'product_info', '', 1, '[[regtime]]', '[[regtime]]'),
(5, 'Also Purchased Module', 'Also Purchased Module', 'also_purchased_products.php', 1, 'product_info', '', 2, '[[regtime]]', '[[regtime]]'),
(6, 'Previous Next Module', 'Previous Next Module', 'products_next_previous.php', 1, 'product_info', '', 4, '[[regtime]]', '[[regtime]]'),
(7, 'Counter', '', 'counter.php', 1, 'all', '', 2, '[[regtime]]', '[[regtime]]'),
(8, 'Copyright', '', 'copyright.php', 1, 'all', '', 4, '[[regtime]]', '[[regtime]]'),
(9, 'Articles', '', 'index_articles.php', 1, 'index', '', 8, '[[regtime]]', '[[regtime]]'),
(10, 'Greeting', '', 'index_greeting.php', 1, 'index', '', 2, '[[regtime]]', '[[regtime]]'),
(11, 'Define Mainpage', '', 'index_define_mainpage.php', 1, 'index', '', 3, '[[regtime]]', '[[regtime]]'),
(12, 'Open Feature Sets', '', 'featured_sets.php', 1, 'index', '', 6, '[[regtime]]', '[[regtime]]'),
(13, 'Open Feature Sets', '', 'featured_sets.php', 1, 'product_info', '', 3, '[[regtime]]', '[[regtime]]'),
(14, 'Slideshow', '', 'slideshow.php', 1, 'index', '', 1, '[[regtime]]', '[[regtime]]'),
(15, 'New Products', '', 'new_products.php', 1, 'nested', '', 1, '[[regtime]]', '[[regtime]]'),
(16, 'Banner', '', 'banner_index.php', 1, 'index', '', 9, '[[regtime]]', '[[regtime]]'),
(17, 'Banner', '', 'banner_all.php', 1, 'all', '', 3, '[[regtime]]', '[[regtime]]'),
(18, 'Banner', '', 'banner_product.php', 1, 'product_info', '', 5, '[[regtime]]', '[[regtime]]'),
(19, 'Recently Viewed', '', 'recently_viewed_products.php', 1, 'all', '', 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_quantity` int(4) NOT NULL,
  `products_model` varchar(24) DEFAULT NULL,
  `products_image` varchar(80) DEFAULT NULL,
  `products_msrp` decimal(15,4) NOT NULL,
  `products_price` decimal(15,4) NOT NULL,
  `products_date_added` datetime NOT NULL,
  `products_last_modified` datetime DEFAULT NULL,
  `products_date_available` datetime DEFAULT NULL,
  `products_featured_until` date DEFAULT NULL,
  `products_weight` decimal(10,4) NOT NULL,
  `products_status` tinyint(1) NOT NULL,
  `products_featured` tinyint(1) DEFAULT '0',
  `products_tax_class_id` int(11) NOT NULL,
  `manufacturers_id` int(11) DEFAULT NULL,
  `products_ordered` int(11) NOT NULL DEFAULT '0',
  `products_length` decimal(6,2) NOT NULL DEFAULT '12.00',
  `products_width` decimal(6,2) NOT NULL DEFAULT '12.00',
  `products_height` decimal(6,2) NOT NULL DEFAULT '12.00',
  `products_ready_to_ship` int(1) NOT NULL DEFAULT '0',
  `products_hide_from_groups` varchar(255) NOT NULL DEFAULT '@',
  `products_qty_blocks` int(4) NOT NULL DEFAULT '1',
  `products_min_order_qty` int(4) NOT NULL DEFAULT '1',
  `products_ship_sep` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_id`),
  KEY `idx_products_model` (`products_model`),
  KEY `idx_products_date_added` (`products_date_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `products_attributes`
--

CREATE TABLE `products_attributes` (
  `products_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `options_id` int(11) NOT NULL,
  `options_values_id` int(11) NOT NULL,
  `code_suffix` varchar(16) NOT NULL,
  `suffix_sort_order` int(4) NOT NULL DEFAULT '0',
  `options_values_price` decimal(15,4) NOT NULL,
  `price_prefix` char(1) NOT NULL,
  `weight_prefix` char(1) NOT NULL,
  `options_values_weight` decimal(6,3) NOT NULL DEFAULT '0.000',
  `products_options_sort_order` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_attributes_id`),
  KEY `idx_products_attributes_products_id` (`products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `products_attributes_download`
--

CREATE TABLE `products_attributes_download` (
  `products_attributes_id` int(11) NOT NULL,
  `products_attributes_filename` varchar(255) NOT NULL,
  `products_attributes_maxdays` int(2) DEFAULT '0',
  `products_attributes_maxcount` int(2) DEFAULT '0',
  PRIMARY KEY (`products_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `products_attributes_download`
--

INSERT INTO `products_attributes_download` VALUES
(11, 'Dhtml-coolmenu.zip', 7, 10);

-- --------------------------------------------------------

--
-- Table structure for table `products_description`
--

CREATE TABLE `products_description` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_name` varchar(64) NOT NULL,
  `products_short` text,
  `products_description` text,
  `tab1` text,
  `tab2` text,
  `tab3` text,
  `tab4` text,
  `tab5` text,
  `tab6` text,
  `products_url` varchar(255) DEFAULT NULL,
  `products_viewed` int(5) DEFAULT '0',
  PRIMARY KEY (`products_id`,`language_id`),
  KEY `products_name` (`products_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `products_groups`
--

CREATE TABLE `products_groups` (
  `customers_group_id` int(11) NOT NULL DEFAULT '0',
  `customers_group_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_id` int(11) NOT NULL DEFAULT '0',
  `products_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_qty_blocks` int(4) NOT NULL DEFAULT '1',
  `products_min_order_qty` int(4) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `products_notifications`
--

CREATE TABLE `products_notifications` (
  `products_id` int(11) NOT NULL,
  `customers_id` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`products_id`,`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `products_options`
--

CREATE TABLE `products_options` (
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_options_name` varchar(32) NOT NULL DEFAULT '',
  `products_options_track_stock` tinyint(4) NOT NULL DEFAULT '0',
  `products_options_type` int(5) NOT NULL DEFAULT '0',
  `products_options_length` smallint(2) NOT NULL DEFAULT '32',
  `products_options_comment` varchar(32) DEFAULT NULL,
  `products_options_sort_order` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_options_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `products_options`
--

INSERT INTO `products_options` VALUES
(1, 1, 'Version', 0, 0, 32, NULL, 1),
(1, 2, 'Version', 0, 0, 32, NULL, 1),
(1, 3, 'Version', 0, 0, 32, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `products_options_description`
--

CREATE TABLE `products_options_description` (
  `products_options_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_options_name` varchar(32) NOT NULL DEFAULT '',
  `products_options_description` text NOT NULL,
  PRIMARY KEY (`products_options_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `products_options_types`
--

CREATE TABLE `products_options_types` (
  `products_options_types_id` int(11) NOT NULL DEFAULT '0',
  `products_options_types_name` varchar(32) DEFAULT NULL,
  `language_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_options_types_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `products_options_types`
--

INSERT INTO `products_options_types` VALUES
(0, 'Select', 1),
(0, 'Select', 2),
(0, 'Select', 3),
(0, 'Select', 4),
(3, 'Radio', 1),
(3, 'Radio', 2),
(3, 'Radio', 3),
(3, 'Radio', 4),
(4, 'Checkbox', 1),
(4, 'Checkbox', 2),
(4, 'Checkbox', 3),
(4, 'Checkbox', 4);

-- --------------------------------------------------------

--
-- Table structure for table `products_options_values`
--

CREATE TABLE `products_options_values` (
  `products_options_values_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_options_values_name` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`products_options_values_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `products_options_values`
--

INSERT INTO `products_options_values` VALUES
(1, 1, 'Download: Windows - English'),
(1, 2, 'Download: Windows - Englisch'),
(1, 3, 'Download: Windows - Inglese');

-- --------------------------------------------------------

--
-- Table structure for table `products_options_values_to_products_options`
--

CREATE TABLE `products_options_values_to_products_options` (
  `products_options_values_to_products_options_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_options_id` int(11) NOT NULL,
  `products_options_values_id` int(11) NOT NULL,
  PRIMARY KEY (`products_options_values_to_products_options_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- Dumping data for table `products_options_values_to_products_options`
--

INSERT INTO `products_options_values_to_products_options` VALUES
(14, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `products_price_break`
--

CREATE TABLE `products_price_break` (
  `products_price_break_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `products_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_qty` int(11) NOT NULL DEFAULT '0',
  `customers_group_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_price_break_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `products_shipping`
--

CREATE TABLE `products_shipping` (
  `products_id` int(11) NOT NULL DEFAULT '0',
  `products_ship_methods_id` int(11) DEFAULT NULL,
  `products_ship_zip` varchar(32) DEFAULT NULL,
  `products_ship_price` varchar(10) DEFAULT NULL,
  `products_ship_price_two` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `products_stock`
--

CREATE TABLE `products_stock` (
  `products_stock_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `products_stock_attributes` varchar(255) NOT NULL,
  `products_stock_quantity` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_stock_id`),
  UNIQUE KEY `idx_products_stock_attributes` (`products_id`,`products_stock_attributes`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `products_to_categories`
--

CREATE TABLE `products_to_categories` (
  `products_id` int(11) NOT NULL,
  `categories_id` int(11) NOT NULL,
  PRIMARY KEY (`products_id`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `products_to_discount_categories`
--

CREATE TABLE `products_to_discount_categories` (
  `products_id` int(11) NOT NULL,
  `discount_categories_id` int(11) NOT NULL,
  `customers_group_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_id`,`customers_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `products_xsell`
--

CREATE TABLE `products_xsell` (
  `ID` int(10) NOT NULL AUTO_INCREMENT,
  `products_id` int(10) unsigned NOT NULL DEFAULT '1',
  `xsell_id` int(10) unsigned NOT NULL DEFAULT '1',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `quick_links`
--

CREATE TABLE `quick_links` (
  `quick_links_id` int(11) NOT NULL AUTO_INCREMENT,
  `quick_links_name` varchar(255) NOT NULL,
  `quick_links_link` varchar(255) NOT NULL,
  `quick_links_target` varchar(255) NOT NULL,
  `quick_links_sort_order` int(11) NOT NULL,
  `quick_links_cg` varchar(64) NOT NULL,
  `date_added` datetime NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `quick_links_image` varchar(255) NOT NULL,
  PRIMARY KEY (`quick_links_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- Dumping data for table `quick_links`
--

INSERT INTO `quick_links` VALUES
(1, 'Home', 'index.php', '_top', 1, '1,2', '[[regtime]]', '[[regtime]]', 'dashboard.png'),
(2, 'Google Analytics', 'https://www.google.com/analytics/reporting/', '_blank', 2, '1,2', '[[regtime]]', '[[regtime]]', 'analytics.png'),
(3, 'Google Web Tools', 'https://www.google.com/webmasters/tools/dashboard', '_blank', 3, '1,2', '[[regtime]]', '[[regtime]]', 'webtools.png'),
(4, 'Pingdom', 'https://pp.pingdom.com/index.php/member/default', '_blank', 4, '1,2', '[[regtime]]', '[[regtime]]', 'pingdom.png'),
(5, 'Categories', 'categories.php', '_top', 5, '1,2', '[[regtime]]', '[[regtime]]', 'categories.png'),
(6, 'Cross Sell', 'xsell.php', '_top', 6, '1,2', '[[regtime]]', '[[regtime]]', 'xsell.png'),
(7, 'Backup', 'backup.php', '_top', 7, '1,2', '[[regtime]]', '[[regtime]]', 'backup.png'),
(8, 'Orders', 'orders.php', '_top', 8, '1,2', '[[regtime]]', '[[regtime]]', 'orders.png'),
(9, 'Customers', 'customers.php', '_top', 9, '1,2', '[[regtime]]', '[[regtime]]', 'customers.png'),
(10, 'Newsletters', 'newsletters.php', '_top', 10, '1,2', '[[regtime]]', '[[regtime]]', 'newsletters.png'),
(11, 'Goto Catalog', '../index.php', '_blank', 11, '1,2', '[[regtime]]', '[[regtime]]', 'catalog.png');

-- --------------------------------------------------------

--
-- Table structure for table `reviews`
--

CREATE TABLE `reviews` (
  `reviews_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `customers_id` int(11) DEFAULT NULL,
  `customers_name` varchar(64) NOT NULL,
  `reviews_rating` int(1) DEFAULT NULL,
  `approved` tinyint(3) unsigned DEFAULT '0',
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reviews_read` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`reviews_id`),
  KEY `idx_reviews_products_id` (`products_id`),
  KEY `idx_reviews_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `reviews_description`
--

CREATE TABLE `reviews_description` (
  `reviews_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `reviews_text` text NOT NULL,
  PRIMARY KEY (`reviews_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `scart`
--

CREATE TABLE `scart` (
  `scartid` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `dateadded` varchar(8) NOT NULL,
  `datemodified` varchar(8) NOT NULL,
  PRIMARY KEY (`scartid`),
  UNIQUE KEY `scartid` (`scartid`),
  UNIQUE KEY `customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `searchword_swap`
--

CREATE TABLE `searchword_swap` (
  `sws_id` mediumint(11) NOT NULL AUTO_INCREMENT,
  `sws_word` varchar(100) NOT NULL,
  `sws_replacement` varchar(100) NOT NULL,
  PRIMARY KEY (`sws_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `search_queries`
--

CREATE TABLE `search_queries` (
  `search_id` int(11) NOT NULL AUTO_INCREMENT,
  `search_text` tinytext,
  PRIMARY KEY (`search_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `search_queries_sorted`
--

CREATE TABLE `search_queries_sorted` (
  `search_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `search_text` tinytext NOT NULL,
  `search_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`search_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `sesskey` varchar(32) NOT NULL,
  `expiry` int(10) unsigned NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`sesskey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `shipping_manifest`
--

CREATE TABLE `shipping_manifest` (
  `delivery_id` int(5) NOT NULL AUTO_INCREMENT,
  `orders_id` int(6) NOT NULL DEFAULT '0',
  `delivery_name` varchar(128) NOT NULL,
  `delivery_company` varchar(128) NOT NULL,
  `delivery_address_1` varchar(128) NOT NULL,
  `delivery_address_2` varchar(128) NOT NULL,
  `delivery_city` varchar(64) NOT NULL,
  `delivery_state` char(2) NOT NULL,
  `delivery_postcode` varchar(10) NOT NULL,
  `delivery_phone` varchar(10) NOT NULL,
  `package_weight` char(3) NOT NULL,
  `package_value` varchar(4) NOT NULL,
  `oversized` int(1) NOT NULL DEFAULT '0',
  `pickup_date` date NOT NULL DEFAULT '0001-01-01',
  `shipping_type` varchar(64) NOT NULL,
  `residential` char(1) NOT NULL,
  `cod` int(1) NOT NULL DEFAULT '0',
  `tracking_num` varchar(20) NOT NULL,
  `multiple` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`delivery_id`),
  UNIQUE KEY `tracking_num` (`tracking_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `slideshow`
--

CREATE TABLE `slideshow` (
  `slideshow_id` int(11) NOT NULL AUTO_INCREMENT,
  `slideshow_title` varchar(255) NOT NULL,
  `slideshow_link` varchar(255) NOT NULL,
  `slideshow_target` varchar(255) NOT NULL,
  `slideshow_active` varchar(3) NOT NULL,
  `slideshow_cg_hide` varchar(255) NOT NULL,
  `slideshow_sort_order` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `slideshow_image` varchar(255) NOT NULL,
  PRIMARY KEY (`slideshow_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `slideshow`
--

INSERT INTO `slideshow` VALUES
(1, 'osCmax - eCommerce to the max', 'http://www.oscmax.com/', '_top', 'yes', '', 1, '[[regtime]]', '[[regtime]]', 'example_oscmax1.jpg'),
(2, 'osCmax v2.5 User Manual', 'http://shop.oscmax.com/oscmax-v250-user-manual-p-3.html', '_top', 'yes', '', 2, '[[regtime]]', '[[regtime]]', 'oscmax_2.5_manual.jpg'),
(3, 'AABox - Pro web hosting', 'http://www.aabox.com/', '_top', 'yes', '', 2, '[[regtime]]', '[[regtime]]', 'example_oscmax2.jpg'),
(4, 'ejSolutions', 'http://www.ejsolutions.co.uk/', '_top', 'yes', '', 3, '[[regtime]]', '[[regtime]]', 'example_oscmax3.jpg');

-- --------------------------------------------------------

--
-- Table structure for table `specials`
--

CREATE TABLE `specials` (
  `specials_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `specials_new_products_price` decimal(15,5) NOT NULL,
  `specials_date_added` datetime DEFAULT NULL,
  `specials_last_modified` datetime DEFAULT NULL,
  `expires_date` datetime DEFAULT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `customers_group_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`specials_id`),
  KEY `idx_specials_products_id` (`products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `specials_retail_prices`
--

CREATE TABLE `specials_retail_prices` (
  `products_id` int(11) NOT NULL DEFAULT '0',
  `specials_new_products_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `status` tinyint(4) DEFAULT NULL,
  `customers_group_id` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tax_class`
--

CREATE TABLE `tax_class` (
  `tax_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_class_title` varchar(32) NOT NULL,
  `tax_class_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`tax_class_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `tax_class`
--

INSERT INTO `tax_class` VALUES
(1, 'Taxable Goods', 'The following types of products are included non-food,services,etc', '[[regtime]]', '[[regtime]]'),
(2, 'Taxable Item', 'Any taxable item', '[[regtime]]', '[[regtime]]'),
(3, 'Non Taxable', 'Non Taxable Goods', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `tax_rates`
--

CREATE TABLE `tax_rates` (
  `tax_rates_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_zone_id` int(11) NOT NULL,
  `tax_class_id` int(11) NOT NULL,
  `tax_priority` int(5) DEFAULT '1',
  `tax_rate` decimal(7,4) NOT NULL,
  `tax_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`tax_rates_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `tax_rates`
--

INSERT INTO `tax_rates` VALUES
(1, 1, 1, 1, 7.0000, 'FL TAX 7.0%', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `theme_configuration`
--

CREATE TABLE `theme_configuration` (
  `configuration_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(64) NOT NULL,
  `configuration_key` varchar(64) NOT NULL DEFAULT 'BOX_HEADING_',
  `configuration_value` varchar(255) NOT NULL,
  `configuration_description` varchar(255) NOT NULL,
  `configuration_group_id` int(11) NOT NULL DEFAULT '1',
  `configuration_column` varchar(64) NOT NULL DEFAULT 'left',
  `location` int(5) NOT NULL DEFAULT '0',
  `sort_order` int(5) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '0001-01-01 01:01:01',
  `box_heading` varchar(64) NOT NULL,
  PRIMARY KEY (`configuration_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=31 ;

--
-- Dumping data for table `theme_configuration`
--

INSERT INTO `theme_configuration` VALUES
(1, 'best sellers', 'BOX_HEADING_BEST_SELLERS', 'yes', 'Display Best Sellers box?', 1, 'left', 12, 1, NULL, '[[regtime]]', ''),
(2, 'categories', 'BOX_HEADING_CATEGORIES', 'yes', '', 1, 'left', 1, NULL, NULL, '[[regtime]]', 'Categories'),
(3, 'currencies', 'BOX_HEADING_CATEGORIES_CURRENCIES', 'yes', 'Display Currencies box?', 1, 'right', 8, 3, NULL, '[[regtime]]', ''),
(5, 'information', 'BOX_HEADING_INFORMATION', 'yes', 'Display Information box?', 1, 'left', 7, 5, NULL, '[[regtime]]', ''),
(6, 'languages', 'BOX_HEADING_LANGUAGES', 'yes', 'Display Languages box?', 1, 'right', 7, 6, NULL, '[[regtime]]', ''),
(7, 'manufacturer info', 'BOX_HEADING_MANUFACTURER_INFO', 'yes', 'Display Manufacturer Info box?', 1, 'right', 9, 7, NULL, '[[regtime]]', ''),
(8, 'manufacturers', 'BOX_HEADING_MANUFACTURERS', 'yes', 'Display Manufacturers box?', 1, 'left', 6, 8, NULL, '[[regtime]]', 'Manufactures'),
(9, 'order history', 'BOX_HEADING_ORDER_HISTORY', 'yes', 'Display Order History box?', 1, 'right', 4, 9, NULL, '[[regtime]]', ''),
(10, 'product notifications', 'BOX_HEADING_PRODUCT_NOTIFICATIONS', 'yes', 'Display Product Notifications box?', 1, 'right', 9, 10, NULL, '[[regtime]]', ''),
(11, 'reviews', 'BOX_HEADING_REVIEWS', 'yes', 'Display Reviews box?', 1, 'right', 6, 11, NULL, '[[regtime]]', ''),
(12, 'search', 'BOX_HEADING_SEARCH', 'yes', 'Display Search box?', 1, 'left', 5, 12, NULL, '[[regtime]]', 'Quick Find'),
(13, 'shopping cart', 'BOX_HEADING_SHOPPING_CART', 'yes', 'Display Shopping Cart box?', 1, 'right', 1, 13, NULL, '[[regtime]]', ''),
(14, 'specials', 'BOX_HEADING_SPECIALS', 'yes', 'Display Specials box?', 1, 'right', 5, 14, NULL, '[[regtime]]', 'Specials'),
(15, 'tell a friend', 'BOX_HEADING_TELL_A_FRIEND', 'yes', 'Display Tell a Friend box?', 1, 'right', 4, 15, NULL, '[[regtime]]', ''),
(16, 'what''s new', 'BOX_HEADING_WHATS_NEW', 'yes', 'Display What''s New? box?', 1, 'left', 4, 16, NULL, '[[regtime]]', 'What''s New'),
(22, 'wishlist', 'BOX_HEADING_CUSTOMER_WISHLIST', 'yes', '', 1, 'right', 3, NULL, NULL, '[[regtime]]', 'My Wish List'),
(25, 'loginbox', 'BOX_HEADING_LOGIN_BOX', 'yes', '', 1, 'right', 2, NULL, NULL, '[[regtime]]', 'Sign In'),
(26, 'articles', 'BOX_HEADING_ARTICLES', 'yes', '', 1, 'right', 10, NULL, NULL, '[[regtime]]', 'Articles'),
(28, 'affiliate', 'BOX_HEADING_AFFILIATE', 'no', '', 1, 'left', 3, NULL, NULL, '[[regtime]]', 'Affiliates'),
(29, 'Authors', 'BOX_HEADING_AUTHORS', 'yes', '', 1, 'right', 11, NULL, NULL, '[[regtime]]', 'Authors'),
(30, 'mailchimp_newsletters', 'BOX_HEADING_MAILCHIMP', 'no', 'Do you want to use MailChimp to collect and manage your newsletters?', 1, 'right', 15, NULL, NULL, '[[regtime]]', 'MailChimp Newsletters');

-- --------------------------------------------------------

--
-- Table structure for table `topics`
--

CREATE TABLE `topics` (
  `topics_id` int(11) NOT NULL AUTO_INCREMENT,
  `topics_image` varchar(64) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`topics_id`),
  KEY `idx_topics_parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `topics`
--

INSERT INTO `topics` VALUES
(1, NULL, 0, 0, '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `topics_description`
--

CREATE TABLE `topics_description` (
  `topics_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `topics_name` varchar(32) NOT NULL,
  `topics_heading_title` varchar(64) DEFAULT NULL,
  `topics_description` text,
  PRIMARY KEY (`topics_id`,`language_id`),
  KEY `idx_topics_name` (`topics_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `topics_description`
--

INSERT INTO `topics_description` VALUES
(0, 1, 'Miscellaneous Articles', 'Miscellaneous', 'Articles that do not fall into a specific category.');

-- --------------------------------------------------------

--
-- Table structure for table `ups_boxes_used`
--

CREATE TABLE `ups_boxes_used` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `customers_id` int(11) NOT NULL,
  `boxes` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `usu_cache`
--

CREATE TABLE `usu_cache` (
  `cache_name` varchar(32) NOT NULL,
  `cache_data` mediumtext NOT NULL,
  `cache_date` datetime NOT NULL,
  PRIMARY KEY (`cache_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `whos_online`
--

CREATE TABLE `whos_online` (
  `customer_id` int(11) DEFAULT NULL,
  `full_name` varchar(64) NOT NULL,
  `session_id` varchar(128) NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `country_code` varchar(2) NOT NULL,
  `country_name` varchar(64) NOT NULL,
  `region_name` varchar(64) NOT NULL,
  `city` varchar(64) NOT NULL,
  `latitude` float NOT NULL,
  `longitude` float NOT NULL,
  `time_entry` varchar(14) NOT NULL,
  `time_last_click` varchar(14) NOT NULL,
  `last_page_url` text NOT NULL,
  `http_referer` varchar(255) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  KEY `idx_ip_address` (`ip_address`),
  KEY `idx_country_code` (`country_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `zones`
--

CREATE TABLE `zones` (
  `zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_country_id` int(11) NOT NULL,
  `zone_code` varchar(32) NOT NULL,
  `zone_name` varchar(32) NOT NULL,
  PRIMARY KEY (`zone_id`),
  KEY `idx_zones_country_id` (`zone_country_id`),
  KEY `idx_zones_to_geo_zones_country_id` (`zone_country_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4316 ;

--
-- Dumping data for table `zones`
--

INSERT INTO `zones` VALUES
(1, 1, 'BDS', 'Badakhshan'),
(2, 1, 'BDG', 'Badghis'),
(3, 1, 'BGL', 'Baghlan'),
(4, 1, 'BAL', 'Balkh'),
(5, 1, 'BAM', 'Bamian'),
(6, 1, 'FRA', 'Farah'),
(7, 1, 'FYB', 'Faryab'),
(8, 1, 'GHA', 'Ghazni'),
(9, 1, 'GHO', 'Ghowr'),
(10, 1, 'HEL', 'Helmand'),
(11, 1, 'HER', 'Herat'),
(12, 1, 'JOW', 'Jowzjan'),
(13, 1, 'KAB', 'Kabul'),
(14, 1, 'KAN', 'Kandahar'),
(15, 1, 'KAP', 'Kapisa'),
(16, 1, 'KHO', 'Khost'),
(17, 1, 'KNR', 'Konar'),
(18, 1, 'KDZ', 'Kondoz'),
(19, 1, 'LAG', 'Laghman'),
(20, 1, 'LOW', 'Lowgar'),
(21, 1, 'NAN', 'Nangrahar'),
(22, 1, 'NIM', 'Nimruz'),
(23, 1, 'NUR', 'Nurestan'),
(24, 1, 'ORU', 'Oruzgan'),
(25, 1, 'PIA', 'Paktia'),
(26, 1, 'PKA', 'Paktika'),
(27, 1, 'PAR', 'Parwan'),
(28, 1, 'SAM', 'Samangan'),
(29, 1, 'SAR', 'Sar-e Pol'),
(30, 1, 'TAK', 'Takhar'),
(31, 1, 'WAR', 'Wardak'),
(32, 1, 'ZAB', 'Zabol'),
(33, 2, 'BR', 'Berat'),
(34, 2, 'BU', 'Bulqize'),
(35, 2, 'DL', 'Delvine'),
(36, 2, 'DV', 'Devoll'),
(37, 2, 'DI', 'Diber'),
(38, 2, 'DR', 'Durres'),
(39, 2, 'EL', 'Elbasan'),
(40, 2, 'ER', 'Kolonje'),
(41, 2, 'FR', 'Fier'),
(42, 2, 'GJ', 'Gjirokaster'),
(43, 2, 'GR', 'Gramsh'),
(44, 2, 'HA', 'Has'),
(45, 2, 'KA', 'Kavaje'),
(46, 2, 'KB', 'Kurbin'),
(47, 2, 'KC', 'Kucove'),
(48, 2, 'KO', 'Korce'),
(49, 2, 'KR', 'Kruje'),
(50, 2, 'KU', 'Kukes'),
(51, 2, 'LB', 'Librazhd'),
(52, 2, 'LE', 'Lezhe'),
(53, 2, 'LU', 'Lushnje'),
(54, 2, 'MM', 'Malesi e Madhe'),
(55, 2, 'MK', 'Mallakaster'),
(56, 2, 'MT', 'Mat'),
(57, 2, 'MR', 'Mirdite'),
(58, 2, 'PQ', 'Peqin'),
(59, 2, 'PR', 'Permet'),
(60, 2, 'PG', 'Pogradec'),
(61, 2, 'PU', 'Puke'),
(62, 2, 'SH', 'Shkoder'),
(63, 2, 'SK', 'Skrapar'),
(64, 2, 'SR', 'Sarande'),
(65, 2, 'TE', 'Tepelene'),
(66, 2, 'TP', 'Tropoje'),
(67, 2, 'TR', 'Tirane'),
(68, 2, 'VL', 'Vlore'),
(69, 3, 'ADR', 'Adrar'),
(70, 3, 'ADE', 'Ain Defla'),
(71, 3, 'ATE', 'Ain Temouchent'),
(72, 3, 'ALG', 'Alger'),
(73, 3, 'ANN', 'Annaba'),
(74, 3, 'BAT', 'Batna'),
(75, 3, 'BEC', 'Bechar'),
(76, 3, 'BEJ', 'Bejaia'),
(77, 3, 'BIS', 'Biskra'),
(78, 3, 'BLI', 'Blida'),
(79, 3, 'BBA', 'Bordj Bou Arreridj'),
(80, 3, 'BOA', 'Bouira'),
(81, 3, 'BMD', 'Boumerdes'),
(82, 3, 'CHL', 'Chlef'),
(83, 3, 'CON', 'Constantine'),
(84, 3, 'DJE', 'Djelfa'),
(85, 3, 'EBA', 'El Bayadh'),
(86, 3, 'EOU', 'El Oued'),
(87, 3, 'ETA', 'El Tarf'),
(88, 3, 'GHA', 'Ghardaia'),
(89, 3, 'GUE', 'Guelma'),
(90, 3, 'ILL', 'Illizi'),
(91, 3, 'JIJ', 'Jijel'),
(92, 3, 'KHE', 'Khenchela'),
(93, 3, 'LAG', 'Laghouat'),
(94, 3, 'MUA', 'Muaskar'),
(95, 3, 'MED', 'Medea'),
(96, 3, 'MIL', 'Mila'),
(97, 3, 'MOS', 'Mostaganem'),
(98, 3, 'MSI', 'M''Sila'),
(99, 3, 'NAA', 'Naama'),
(100, 3, 'ORA', 'Oran'),
(101, 3, 'OUA', 'Ouargla'),
(102, 3, 'OEB', 'Oum el-Bouaghi'),
(103, 3, 'REL', 'Relizane'),
(104, 3, 'SAI', 'Saida'),
(105, 3, 'SET', 'Setif'),
(106, 3, 'SBA', 'Sidi Bel Abbes'),
(107, 3, 'SKI', 'Skikda'),
(108, 3, 'SAH', 'Souk Ahras'),
(109, 3, 'TAM', 'Tamanghasset'),
(110, 3, 'TEB', 'Tebessa'),
(111, 3, 'TIA', 'Tiaret'),
(112, 3, 'TIN', 'Tindouf'),
(113, 3, 'TIP', 'Tipaza'),
(114, 3, 'TIS', 'Tissemsilt'),
(115, 3, 'TOU', 'Tizi Ouzou'),
(116, 3, 'TLE', 'Tlemcen'),
(117, 4, 'E', 'Eastern'),
(118, 4, 'M', 'Manu''a'),
(119, 4, 'R', 'Rose Island'),
(120, 4, 'S', 'Swains Island'),
(121, 4, 'W', 'Western'),
(122, 5, 'ALV', 'Andorra la Vella'),
(123, 5, 'CAN', 'Canillo'),
(124, 5, 'ENC', 'Encamp'),
(125, 5, 'ESE', 'Escaldes-Engordany'),
(126, 5, 'LMA', 'La Massana'),
(127, 5, 'ORD', 'Ordino'),
(128, 5, 'SJL', 'Sant JuliÃ  de LÃ²ria'),
(129, 6, 'BGO', 'Bengo'),
(130, 6, 'BGU', 'Benguela'),
(131, 6, 'BIE', 'Bie'),
(132, 6, 'CAB', 'Cabinda'),
(133, 6, 'CCU', 'Cuando-Cubango'),
(134, 6, 'CNO', 'Cuanza Norte'),
(135, 6, 'CUS', 'Cuanza Sul'),
(136, 6, 'CNN', 'Cunene'),
(137, 6, 'HUA', 'Huambo'),
(138, 6, 'HUI', 'Huila'),
(139, 6, 'LUA', 'Luanda'),
(140, 6, 'LNO', 'Lunda Norte'),
(141, 6, 'LSU', 'Lunda Sul'),
(142, 6, 'MAL', 'Malange'),
(143, 6, 'MOX', 'Moxico'),
(144, 6, 'NAM', 'Namibe'),
(145, 6, 'UIG', 'Uige'),
(146, 6, 'ZAI', 'Zaire'),
(147, 7, 'SCR', 'Scrub'),
(148, 7, 'SAN', 'Sandy'),
(149, 7, 'PRI', 'Prickly Pear'),
(150, 7, 'LIT', 'Little Scrub'),
(151, 7, 'DOG', 'Dog'),
(152, 7, 'ANG', 'Anguillita'),
(153, 7, 'ANG', 'Anguila'),
(154, 7, 'SEA', 'Seal'),
(155, 7, 'SOM', 'Sombrero'),
(156, 9, 'ASG', 'Saint George'),
(157, 9, 'ASJ', 'Saint John'),
(158, 9, 'ASM', 'Saint Mary'),
(159, 9, 'ASL', 'Saint Paul'),
(160, 9, 'ASR', 'Saint Peter'),
(161, 9, 'ASH', 'Saint Philip'),
(162, 9, 'BAR', 'Barbuda'),
(163, 9, 'RED', 'Redonda'),
(164, 10, 'AN', 'Antartida e Islas del Atlantico'),
(165, 10, 'BA', 'Buenos Aires'),
(166, 10, 'CA', 'Catamarca'),
(167, 10, 'CH', 'Chaco'),
(168, 10, 'CU', 'Chubut'),
(169, 10, 'CO', 'Cordoba'),
(170, 10, 'CR', 'Corrientes'),
(171, 10, 'CF', 'Capital Federal'),
(172, 10, 'ER', 'Entre Rios'),
(173, 10, 'FO', 'Formosa'),
(174, 10, 'JU', 'Jujuy'),
(175, 10, 'LP', 'La Pampa'),
(176, 10, 'LR', 'La Rioja'),
(177, 10, 'ME', 'Mendoza'),
(178, 10, 'MI', 'Misiones'),
(179, 10, 'NE', 'Neuquen'),
(180, 10, 'RN', 'Rio Negro'),
(181, 10, 'SA', 'Salta'),
(182, 10, 'SJ', 'San Juan'),
(183, 10, 'SL', 'San Luis'),
(184, 10, 'SC', 'Santa Cruz'),
(185, 10, 'SF', 'Santa Fe'),
(186, 10, 'SD', 'Santiago del Estero'),
(187, 10, 'TF', 'Tierra del Fuego'),
(188, 10, 'TU', 'Tucuman'),
(189, 11, 'AGT', 'Aragatsotn'),
(190, 11, 'ARR', 'Ararat'),
(191, 11, 'ARM', 'Armavir'),
(192, 11, 'GEG', 'Geghark''unik'''),
(193, 11, 'KOT', 'Kotayk'''),
(194, 11, 'LOR', 'Lorri'),
(195, 11, 'SHI', 'Shirak'),
(196, 11, 'SYU', 'Syunik'''),
(197, 11, 'TAV', 'Tavush'),
(198, 11, 'VAY', 'Vayots'' Dzor'),
(199, 11, 'YER', 'Yerevan'),
(200, 12, 'ARU', 'Aruba'),
(201, 12, 'ORA', 'Oranjestad'),
(202, 12, 'DRU', 'Druif Beach'),
(203, 12, 'MAN', 'Manchebo Beach'),
(204, 12, 'NOO', 'Noord'),
(205, 12, 'PAL', 'Palm Beach'),
(206, 12, 'ROO', 'Rooi Thomas'),
(207, 12, 'SIN', 'Sint Nicolaas'),
(208, 12, 'SIN', 'Sint Nicolas'),
(209, 12, 'WAY', 'Wayaca'),
(210, 13, 'ACT', 'Australian Capital Territory'),
(211, 13, 'NSW', 'New South Wales'),
(212, 13, 'NT', 'Northern Territory'),
(213, 13, 'QLD', 'Queensland'),
(214, 13, 'SA', 'South Australia'),
(215, 13, 'TAS', 'Tasmania'),
(216, 13, 'VIC', 'Victoria'),
(217, 13, 'WA', 'Western Australia'),
(218, 14, 'BUR', 'Burgenland'),
(219, 14, 'KAR', 'KÃ¤rnten'),
(220, 14, 'NOS', 'NiederÃ¶sterreich'),
(221, 14, 'OOS', 'OberÃ¶sterreich'),
(222, 14, 'SAL', 'Salzburg'),
(223, 14, 'STE', 'Steiermark'),
(224, 14, 'TIR', 'Tirol'),
(225, 14, 'VOR', 'Vorarlberg'),
(226, 14, 'WIE', 'Wien'),
(227, 15, 'AB', 'Ali Bayramli'),
(228, 15, 'ABS', 'Abseron'),
(229, 15, 'AGC', 'AgcabAdi'),
(230, 15, 'AGM', 'Agdam'),
(231, 15, 'AGS', 'Agdas'),
(232, 15, 'AGA', 'Agstafa'),
(233, 15, 'AGU', 'Agsu'),
(234, 15, 'AST', 'Astara'),
(235, 15, 'BA', 'Baki'),
(236, 15, 'BAB', 'BabAk'),
(237, 15, 'BAL', 'BalakAn'),
(238, 15, 'BAR', 'BArdA'),
(239, 15, 'BEY', 'Beylaqan'),
(240, 15, 'BIL', 'Bilasuvar'),
(241, 15, 'CAB', 'Cabrayil'),
(242, 15, 'CAL', 'Calilabab'),
(243, 15, 'CUL', 'Culfa'),
(244, 15, 'DAS', 'Daskasan'),
(245, 15, 'DAV', 'Davaci'),
(246, 15, 'FUZ', 'Fuzuli'),
(247, 15, 'GA', 'Ganca'),
(248, 15, 'GAD', 'Gadabay'),
(249, 15, 'GOR', 'Goranboy'),
(250, 15, 'GOY', 'Goycay'),
(251, 15, 'HAC', 'Haciqabul'),
(252, 15, 'IMI', 'Imisli'),
(253, 15, 'ISM', 'Ismayilli'),
(254, 15, 'KAL', 'Kalbacar'),
(255, 15, 'KUR', 'Kurdamir'),
(256, 15, 'LA', 'Lankaran'),
(257, 15, 'LAC', 'Lacin'),
(258, 15, 'LAN', 'Lankaran'),
(259, 15, 'LER', 'Lerik'),
(260, 15, 'MAS', 'Masalli'),
(261, 15, 'MI', 'Mingacevir'),
(262, 15, 'NA', 'Naftalan'),
(263, 15, 'NEF', 'Neftcala'),
(264, 15, 'OGU', 'Oguz'),
(265, 15, 'ORD', 'Ordubad'),
(266, 15, 'QAB', 'Qabala'),
(267, 15, 'QAX', 'Qax'),
(268, 15, 'QAZ', 'Qazax'),
(269, 15, 'QOB', 'Qobustan'),
(270, 15, 'QBA', 'Quba'),
(271, 15, 'QBI', 'Qubadli'),
(272, 15, 'QUS', 'Qusar'),
(273, 15, 'SA', 'Saki'),
(274, 15, 'SAT', 'Saatli'),
(275, 15, 'SAB', 'Sabirabad'),
(276, 15, 'SAD', 'Sadarak'),
(277, 15, 'SAH', 'Sahbuz'),
(278, 15, 'SAK', 'Saki'),
(279, 15, 'SAL', 'Salyan'),
(280, 15, 'SM', 'Sumqayit'),
(281, 15, 'SMI', 'Samaxi'),
(282, 15, 'SKR', 'Samkir'),
(283, 15, 'SMX', 'Samux'),
(284, 15, 'SAR', 'Sarur'),
(285, 15, 'SIY', 'Siyazan'),
(286, 15, 'SS', 'Susa'),
(287, 15, 'SUS', 'Susa'),
(288, 15, 'TAR', 'Tartar'),
(289, 15, 'TOV', 'Tovuz'),
(290, 15, 'UCA', 'Ucar'),
(291, 15, 'XA', 'Xankandi'),
(292, 15, 'XAC', 'Xacmaz'),
(293, 15, 'XAN', 'Xanlar'),
(294, 15, 'XIZ', 'Xizi'),
(295, 15, 'XCI', 'Xocali'),
(296, 15, 'XVD', 'Xocavand'),
(297, 15, 'YAR', 'Yardimli'),
(298, 15, 'YEV', 'Yevlax'),
(299, 15, 'ZAN', 'Zangilan'),
(300, 15, 'ZAQ', 'Zaqatala'),
(301, 15, 'ZAR', 'Zardab'),
(302, 15, 'NX', 'Naxcivan'),
(303, 16, 'ACK', 'Acklins'),
(304, 16, 'BER', 'Berry Islands'),
(305, 16, 'BIM', 'Bimini'),
(306, 16, 'BLK', 'Black Point'),
(307, 16, 'CAT', 'Cat Island'),
(308, 16, 'CAB', 'Central Abaco'),
(309, 16, 'CAN', 'Central Andros'),
(310, 16, 'CEL', 'Central Eleuthera'),
(311, 16, 'FRE', 'City of Freeport'),
(312, 16, 'CRO', 'Crooked Island'),
(313, 16, 'EGB', 'East Grand Bahama'),
(314, 16, 'EXU', 'Exuma'),
(315, 16, 'GRD', 'Grand Cay'),
(316, 16, 'HAR', 'Harbour Island'),
(317, 16, 'HOP', 'Hope Town'),
(318, 16, 'INA', 'Inagua'),
(319, 16, 'LNG', 'Long Island'),
(320, 16, 'MAN', 'Mangrove Cay'),
(321, 16, 'MAY', 'Mayaguana'),
(322, 16, 'MOO', 'Moore''s Island'),
(323, 16, 'NAB', 'North Abaco'),
(324, 16, 'NAN', 'North Andros'),
(325, 16, 'NEL', 'North Eleuthera'),
(326, 16, 'RAG', 'Ragged Island'),
(327, 16, 'RUM', 'Rum Cay'),
(328, 16, 'SAL', 'San Salvador'),
(329, 16, 'SAB', 'South Abaco'),
(330, 16, 'SAN', 'South Andros'),
(331, 16, 'SEL', 'South Eleuthera'),
(332, 16, 'SWE', 'Spanish Wells'),
(333, 16, 'WGB', 'West Grand Bahama'),
(334, 17, 'CAP', 'Capital'),
(335, 17, 'CEN', 'Central'),
(336, 17, 'MUH', 'Muharraq'),
(337, 17, 'NOR', 'Northern'),
(338, 17, 'SOU', 'Southern'),
(339, 18, 'BAR', 'Barisal'),
(340, 18, 'CHI', 'Chittagong'),
(341, 18, 'DHA', 'Dhaka'),
(342, 18, 'KHU', 'Khulna'),
(343, 18, 'RAJ', 'Rajshahi'),
(344, 18, 'SYL', 'Sylhet'),
(345, 19, 'CC', 'Christ Church'),
(346, 19, 'AND', 'Saint Andrew'),
(347, 19, 'GEO', 'Saint George'),
(348, 19, 'JAM', 'Saint James'),
(349, 19, 'JOH', 'Saint John'),
(350, 19, 'JOS', 'Saint Joseph'),
(351, 19, 'LUC', 'Saint Lucy'),
(352, 19, 'MIC', 'Saint Michael'),
(353, 19, 'PET', 'Saint Peter'),
(354, 19, 'PHI', 'Saint Philip'),
(355, 19, 'THO', 'Saint Thomas'),
(356, 20, 'BR', 'Brestskaya (Brest)'),
(357, 20, 'HO', 'Homyel''skaya (Homyel'')'),
(358, 20, 'HM', 'Horad Minsk'),
(359, 20, 'HR', 'Hrodzyenskaya (Hrodna)'),
(360, 20, 'MA', 'Mahilyowskaya (Mahilyow)'),
(361, 20, 'MI', 'Minskaya'),
(362, 20, 'VI', 'Vitsyebskaya (Vitsyebsk)'),
(363, 21, 'VAN', 'Antwerpen'),
(364, 21, 'WBR', 'Brabant Wallon'),
(365, 21, 'WHT', 'Hainaut'),
(366, 21, 'WLG', 'Liege'),
(367, 21, 'VLI', 'Limburg'),
(368, 21, 'WLX', 'Luxembourg'),
(369, 21, 'WNA', 'Namur'),
(370, 21, 'VOV', 'Oost-Vlaanderen'),
(371, 21, 'VBR', 'Vlaams Brabant'),
(372, 21, 'VWV', 'West-Vlaanderen'),
(373, 22, 'BZ', 'Belize'),
(374, 22, 'CY', 'Cayo'),
(375, 22, 'CR', 'Corozal'),
(376, 22, 'OW', 'Orange Walk'),
(377, 22, 'SC', 'Stann Creek'),
(378, 22, 'TO', 'Toledo'),
(379, 23, 'AL', 'Alibori'),
(380, 23, 'AK', 'Atakora'),
(381, 23, 'AQ', 'Atlantique'),
(382, 23, 'BO', 'Borgou'),
(383, 23, 'CO', 'Collines'),
(384, 23, 'DO', 'Donga'),
(385, 23, 'KO', 'Kouffo'),
(386, 23, 'LI', 'Littoral'),
(387, 23, 'MO', 'Mono'),
(388, 23, 'OU', 'Oueme'),
(389, 23, 'PL', 'Plateau'),
(390, 23, 'ZO', 'Zou'),
(391, 24, 'DS', 'Devonshire'),
(392, 24, 'HC', 'Hamilton City'),
(393, 24, 'HA', 'Hamilton'),
(394, 24, 'PG', 'Paget'),
(395, 24, 'PB', 'Pembroke'),
(396, 24, 'GC', 'Saint George City'),
(397, 24, 'SG', 'Saint George''s'),
(398, 24, 'SA', 'Sandys'),
(399, 24, 'SM', 'Smith''s'),
(400, 24, 'SH', 'Southampton'),
(401, 24, 'WA', 'Warwick'),
(402, 25, 'BUM', 'Bumthang'),
(403, 25, 'CHU', 'Chukha'),
(404, 25, 'DAG', 'Dagana'),
(405, 25, 'GAS', 'Gasa'),
(406, 25, 'HAA', 'Haa'),
(407, 25, 'LHU', 'Lhuntse'),
(408, 25, 'MON', 'Mongar'),
(409, 25, 'PAR', 'Paro'),
(410, 25, 'PEM', 'Pemagatshel'),
(411, 25, 'PUN', 'Punakha'),
(412, 25, 'SJO', 'Samdrup Jongkhar'),
(413, 25, 'SAT', 'Samtse'),
(414, 25, 'SAR', 'Sarpang'),
(415, 25, 'THI', 'Thimphu'),
(416, 25, 'TRG', 'Trashigang'),
(417, 25, 'TRY', 'Trashiyangste'),
(418, 25, 'TRO', 'Trongsa'),
(419, 25, 'TSI', 'Tsirang'),
(420, 25, 'WPH', 'Wangdue Phodrang'),
(421, 25, 'ZHE', 'Zhemgang'),
(422, 26, 'BEN', 'Beni'),
(423, 26, 'CHU', 'Chuquisaca'),
(424, 26, 'COC', 'Cochabamba'),
(425, 26, 'LPZ', 'La Paz'),
(426, 26, 'ORU', 'Oruro'),
(427, 26, 'PAN', 'Pando'),
(428, 26, 'POT', 'Potosi'),
(429, 26, 'SCZ', 'Santa Cruz'),
(430, 26, 'TAR', 'Tarija'),
(431, 27, 'BRO', 'Brcko district'),
(432, 27, 'FUS', 'Unsko-Sanski Kanton'),
(433, 27, 'FPO', 'Posavski Kanton'),
(434, 27, 'FTU', 'Tuzlanski Kanton'),
(435, 27, 'FZE', 'Zenicko-Dobojski Kanton'),
(436, 27, 'FBP', 'Bosanskopodrinjski Kanton'),
(437, 27, 'FSB', 'Srednjebosanski Kanton'),
(438, 27, 'FHN', 'Hercegovacko-neretvanski Kanton'),
(439, 27, 'FZH', 'Zapadnohercegovacka Zupanija'),
(440, 27, 'FSA', 'Kanton Sarajevo'),
(441, 27, 'FZA', 'Zapadnobosanska'),
(442, 27, 'SBL', 'Banja Luka'),
(443, 27, 'SDO', 'Doboj'),
(444, 27, 'SBI', 'Bijeljina'),
(445, 27, 'SVL', 'Vlasenica'),
(446, 27, 'SSR', 'Sarajevo-Romanija or Sokolac'),
(447, 27, 'SFO', 'Foca'),
(448, 27, 'STR', 'Trebinje'),
(449, 28, 'CE', 'Central'),
(450, 28, 'GH', 'Ghanzi'),
(451, 28, 'KD', 'Kgalagadi'),
(452, 28, 'KT', 'Kgatleng'),
(453, 28, 'KW', 'Kweneng'),
(454, 28, 'NG', 'Ngamiland'),
(455, 28, 'NE', 'North East'),
(456, 28, 'NW', 'North West'),
(457, 28, 'SE', 'South East'),
(458, 28, 'SO', 'Southern'),
(459, 30, 'AC', 'Acre'),
(460, 30, 'AL', 'Alagoas'),
(461, 30, 'AP', 'Amapa'),
(462, 30, 'AM', 'Amazonas'),
(463, 30, 'BA', 'Bahia'),
(464, 30, 'CE', 'Ceara'),
(465, 30, 'DF', 'Distrito Federal'),
(466, 30, 'ES', 'Espirito Santo'),
(467, 30, 'GO', 'Goias'),
(468, 30, 'MA', 'Maranhao'),
(469, 30, 'MT', 'Mato Grosso'),
(470, 30, 'MS', 'Mato Grosso do Sul'),
(471, 30, 'MG', 'Minas Gerais'),
(472, 30, 'PA', 'Para'),
(473, 30, 'PB', 'Paraiba'),
(474, 30, 'PR', 'Parana'),
(475, 30, 'PE', 'Pernambuco'),
(476, 30, 'PI', 'Piaui'),
(477, 30, 'RJ', 'Rio de Janeiro'),
(478, 30, 'RN', 'Rio Grande do Norte'),
(479, 30, 'RS', 'Rio Grande do Sul'),
(480, 30, 'RO', 'Rondonia'),
(481, 30, 'RR', 'Roraima'),
(482, 30, 'SC', 'Santa Catarina'),
(483, 30, 'SP', 'Sao Paulo'),
(484, 30, 'SE', 'Sergipe'),
(485, 30, 'TO', 'Tocantins'),
(486, 31, 'PB', 'Peros Banhos'),
(487, 31, 'SI', 'Salomon Islands'),
(488, 31, 'NI', 'Nelsons Island'),
(489, 31, 'TB', 'Three Brothers'),
(490, 31, 'EA', 'Eagle Islands'),
(491, 31, 'DI', 'Danger Island'),
(492, 31, 'EG', 'Egmont Islands'),
(493, 31, 'DG', 'Diego Garcia'),
(494, 32, 'BEL', 'Belait'),
(495, 32, 'BRM', 'Brunei and Muara'),
(496, 32, 'TEM', 'Temburong'),
(497, 32, 'TUT', 'Tutong'),
(498, 33, '', 'Blagoevgrad'),
(499, 33, '', 'Burgas'),
(500, 33, '', 'Dobrich'),
(501, 33, '', 'Gabrovo'),
(502, 33, '', 'Haskovo'),
(503, 33, '', 'Kardjali'),
(504, 33, '', 'Kyustendil'),
(505, 33, '', 'Lovech'),
(506, 33, '', 'Montana'),
(507, 33, '', 'Pazardjik'),
(508, 33, '', 'Pernik'),
(509, 33, '', 'Pleven'),
(510, 33, '', 'Plovdiv'),
(511, 33, '', 'Razgrad'),
(512, 33, '', 'Shumen'),
(513, 33, '', 'Silistra'),
(514, 33, '', 'Sliven'),
(515, 33, '', 'Smolyan'),
(516, 33, '', 'Sofia'),
(517, 33, '', 'Sofia - town'),
(518, 33, '', 'Stara Zagora'),
(519, 33, '', 'Targovishte'),
(520, 33, '', 'Varna'),
(521, 33, '', 'Veliko Tarnovo'),
(522, 33, '', 'Vidin'),
(523, 33, '', 'Vratza'),
(524, 33, '', 'Yambol'),
(525, 34, 'BAL', 'Bale'),
(526, 34, 'BAM', 'Bam'),
(527, 34, 'BAN', 'Banwa'),
(528, 34, 'BAZ', 'Bazega'),
(529, 34, 'BOR', 'Bougouriba'),
(530, 34, 'BLG', 'Boulgou'),
(531, 34, 'BOK', 'Boulkiemde'),
(532, 34, 'COM', 'Comoe'),
(533, 34, 'GAN', 'Ganzourgou'),
(534, 34, 'GNA', 'Gnagna'),
(535, 34, 'GOU', 'Gourma'),
(536, 34, 'HOU', 'Houet'),
(537, 34, 'IOA', 'Ioba'),
(538, 34, 'KAD', 'Kadiogo'),
(539, 34, 'KEN', 'Kenedougou'),
(540, 34, 'KOD', 'Komondjari'),
(541, 34, 'KOP', 'Kompienga'),
(542, 34, 'KOS', 'Kossi'),
(543, 34, 'KOL', 'Koulpelogo'),
(544, 34, 'KOT', 'Kouritenga'),
(545, 34, 'KOW', 'Kourweogo'),
(546, 34, 'LER', 'Leraba'),
(547, 34, 'LOR', 'Loroum'),
(548, 34, 'MOU', 'Mouhoun'),
(549, 34, 'NAH', 'Nahouri'),
(550, 34, 'NAM', 'Namentenga'),
(551, 34, 'NAY', 'Nayala'),
(552, 34, 'NOU', 'Noumbiel'),
(553, 34, 'OUB', 'Oubritenga'),
(554, 34, 'OUD', 'Oudalan'),
(555, 34, 'PAS', 'Passore'),
(556, 34, 'PON', 'Poni'),
(557, 34, 'SAG', 'Sanguie'),
(558, 34, 'SAM', 'Sanmatenga'),
(559, 34, 'SEN', 'Seno'),
(560, 34, 'SIS', 'Sissili'),
(561, 34, 'SOM', 'Soum'),
(562, 34, 'SOR', 'Sourou'),
(563, 34, 'TAP', 'Tapoa'),
(564, 34, 'TUY', 'Tuy'),
(565, 34, 'YAG', 'Yagha'),
(566, 34, 'YAT', 'Yatenga'),
(567, 34, 'ZIR', 'Ziro'),
(568, 34, 'ZOD', 'Zondoma'),
(569, 34, 'ZOW', 'Zoundweogo'),
(570, 35, 'BB', 'Bubanza'),
(571, 35, 'BJ', 'Bujumbura'),
(572, 35, 'BR', 'Bururi'),
(573, 35, 'CA', 'Cankuzo'),
(574, 35, 'CI', 'Cibitoke'),
(575, 35, 'GI', 'Gitega'),
(576, 35, 'KR', 'Karuzi'),
(577, 35, 'KY', 'Kayanza'),
(578, 35, 'KI', 'Kirundo'),
(579, 35, 'MA', 'Makamba'),
(580, 35, 'MU', 'Muramvya'),
(581, 35, 'MY', 'Muyinga'),
(582, 35, 'MW', 'Mwaro'),
(583, 35, 'NG', 'Ngozi'),
(584, 35, 'RT', 'Rutana'),
(585, 35, 'RY', 'Ruyigi'),
(586, 36, 'PP', 'Phnom Penh'),
(587, 36, 'PS', 'Preah Seihanu (Kompong Som or Si'),
(588, 36, 'PA', 'Pailin'),
(589, 36, 'KB', 'Keb'),
(590, 36, 'BM', 'Banteay Meanchey'),
(591, 36, 'BA', 'Battambang'),
(592, 36, 'KM', 'Kampong Cham'),
(593, 36, 'KN', 'Kampong Chhnang'),
(594, 36, 'KU', 'Kampong Speu'),
(595, 36, 'KO', 'Kampong Som'),
(596, 36, 'KT', 'Kampong Thom'),
(597, 36, 'KP', 'Kampot'),
(598, 36, 'KL', 'Kandal'),
(599, 36, 'KK', 'Kaoh Kong'),
(600, 36, 'KR', 'Kratie'),
(601, 36, 'MK', 'Mondul Kiri'),
(602, 36, 'OM', 'Oddar Meancheay'),
(603, 36, 'PU', 'Pursat'),
(604, 36, 'PR', 'Preah Vihear'),
(605, 36, 'PG', 'Prey Veng'),
(606, 36, 'RK', 'Ratanak Kiri'),
(607, 36, 'SI', 'Siemreap'),
(608, 36, 'ST', 'Stung Treng'),
(609, 36, 'SR', 'Svay Rieng'),
(610, 36, 'TK', 'Takeo'),
(611, 37, 'ADA', 'Adamawa (Adamaoua)'),
(612, 37, 'CEN', 'Centre'),
(613, 37, 'EST', 'East (Est)'),
(614, 37, 'EXN', 'ExtrÃªme-Nord'),
(615, 37, 'LIT', 'Littoral'),
(616, 37, 'NOR', 'North (Nord)'),
(617, 37, 'NOT', 'Northwest (Nord-Ouest)'),
(618, 37, 'OUE', 'West (Ouest)'),
(619, 37, 'SUD', 'South (Sud)'),
(620, 37, 'SOU', 'Southwest (Sud-Ouest).'),
(621, 38, 'AB', 'Alberta'),
(622, 38, 'BC', 'British Columbia'),
(623, 38, 'MB', 'Manitoba'),
(624, 38, 'NB', 'New Brunswick'),
(625, 38, 'NL', 'Newfoundland and Labrador'),
(626, 38, 'NT', 'Northwest Territories'),
(627, 38, 'NS', 'Nova Scotia'),
(628, 38, 'NU', 'Nunavut'),
(629, 38, 'ON', 'Ontario'),
(630, 38, 'PE', 'Prince Edward Island'),
(631, 38, 'QC', 'Qu&eacute;bec'),
(632, 38, 'SK', 'Saskatchewan'),
(633, 38, 'YT', 'Yukon Territory'),
(634, 39, 'BV', 'Boa Vista'),
(635, 39, 'BR', 'Brava'),
(636, 39, 'CS', 'Calheta de Sao Miguel'),
(637, 39, 'MA', 'Maio'),
(638, 39, 'MO', 'Mosteiros'),
(639, 39, 'PA', 'Paul'),
(640, 39, 'PN', 'Porto Novo'),
(641, 39, 'PR', 'Praia'),
(642, 39, 'RG', 'Ribeira Grande'),
(643, 39, 'SL', 'Sal'),
(644, 39, 'CA', 'Santa Catarina'),
(645, 39, 'CR', 'Santa Cruz'),
(646, 39, 'SD', 'Sao Domingos'),
(647, 39, 'SF', 'Sao Filipe'),
(648, 39, 'SN', 'Sao Nicolau'),
(649, 39, 'SV', 'Sao Vicente'),
(650, 39, 'TA', 'Tarrafal'),
(651, 40, 'CR', 'Creek'),
(652, 40, 'EA', 'Eastern'),
(653, 40, 'ML', 'Midland'),
(654, 40, 'ST', 'South Town'),
(655, 40, 'SP', 'Spot Bay'),
(656, 40, 'SK', 'Stake Bay'),
(657, 40, 'WD', 'West End'),
(658, 40, 'WN', 'Western'),
(659, 41, 'BBA', 'Bamingui-Bangoran'),
(660, 41, 'BKO', 'Basse-Kotto'),
(661, 41, 'HKO', 'Haute-Kotto'),
(662, 41, 'HMB', 'Haut-Mbomou'),
(663, 41, 'KEM', 'Kemo'),
(664, 41, 'LOB', 'Lobaye'),
(665, 41, 'MKD', 'MambÃ©rÃ©-KadÃ©Ã¯'),
(666, 41, 'MBO', 'Mbomou'),
(667, 41, 'NMM', 'Nana-Mambere'),
(668, 41, 'OMP', 'Ombella-M''Poko'),
(669, 41, 'OUK', 'Ouaka'),
(670, 41, 'OUH', 'Ouham'),
(671, 41, 'OPE', 'Ouham-Pende'),
(672, 41, 'VAK', 'Vakaga'),
(673, 41, 'NGR', 'Nana-Grebizi'),
(674, 41, 'SMB', 'Sangha-Mbaere'),
(675, 41, 'BAN', 'Bangui'),
(676, 42, 'BA', 'Batha'),
(677, 42, 'BI', 'Biltine'),
(678, 42, 'BE', 'Borkou-Ennedi-Tibesti'),
(679, 42, 'CB', 'Chari-Baguirmi'),
(680, 42, 'GU', 'Guera'),
(681, 42, 'KA', 'Kanem'),
(682, 42, 'LA', 'Lac'),
(683, 42, 'LC', 'Logone Occidental'),
(684, 42, 'LR', 'Logone Oriental'),
(685, 42, 'MK', 'Mayo-Kebbi'),
(686, 42, 'MC', 'Moyen-Chari'),
(687, 42, 'OU', 'Ouaddai'),
(688, 42, 'SA', 'Salamat'),
(689, 42, 'TA', 'Tandjile'),
(690, 43, 'AI', 'Aisen del General Carlos Ibanez'),
(691, 43, 'AN', 'Antofagasta'),
(692, 43, 'AR', 'Araucania'),
(693, 43, 'AT', 'Atacama'),
(694, 43, 'BI', 'Bio-Bio'),
(695, 43, 'CO', 'Coquimbo'),
(696, 43, 'LI', 'Libertador General Bernardo O''Hi'),
(697, 43, 'LL', 'Los Lagos'),
(698, 43, 'MA', 'Magallanes y de la Antartica Chi'),
(699, 43, 'ML', 'Maule'),
(700, 43, 'RM', 'Region Metropolitana'),
(701, 43, 'TA', 'Tarapaca'),
(702, 43, 'VS', 'Valparaiso'),
(703, 44, 'AN', 'Anhui'),
(704, 44, 'BE', 'Beijing'),
(705, 44, 'CH', 'Chongqing'),
(706, 44, 'FU', 'Fujian'),
(707, 44, 'GA', 'Gansu'),
(708, 44, 'GU', 'Guangdong'),
(709, 44, 'GX', 'Guangxi'),
(710, 44, 'GZ', 'Guizhou'),
(711, 44, 'HA', 'Hainan'),
(712, 44, 'HB', 'Hebei'),
(713, 44, 'HL', 'Heilongjiang'),
(714, 44, 'HE', 'Henan'),
(715, 44, 'HK', 'Hong Kong'),
(716, 44, 'HU', 'Hubei'),
(717, 44, 'HN', 'Hunan'),
(718, 44, 'IM', 'Inner Mongolia'),
(719, 44, 'JI', 'Jiangsu'),
(720, 44, 'JX', 'Jiangxi'),
(721, 44, 'JL', 'Jilin'),
(722, 44, 'LI', 'Liaoning'),
(723, 44, 'MA', 'Macau'),
(724, 44, 'NI', 'Ningxia'),
(725, 44, 'SH', 'Shaanxi'),
(726, 44, 'SA', 'Shandong'),
(727, 44, 'SG', 'Shanghai'),
(728, 44, 'SX', 'Shanxi'),
(729, 44, 'SI', 'Sichuan'),
(730, 44, 'TI', 'Tianjin'),
(731, 44, 'XI', 'Xinjiang'),
(732, 44, 'YU', 'Yunnan'),
(733, 44, 'ZH', 'Zhejiang'),
(734, 46, 'D', 'Direction Island'),
(735, 46, 'H', 'Home Island'),
(736, 46, 'O', 'Horsburgh Island'),
(737, 46, 'S', 'South Island'),
(738, 46, 'W', 'West Island'),
(739, 47, 'AMZ', 'Amazonas'),
(740, 47, 'ANT', 'Antioquia'),
(741, 47, 'ARA', 'Arauca'),
(742, 47, 'ATL', 'Atlantico'),
(743, 47, 'BDC', 'Bogota D.C.'),
(744, 47, 'BOL', 'Bolivar'),
(745, 47, 'BOY', 'Boyaca'),
(746, 47, 'CAL', 'Caldas'),
(747, 47, 'CAQ', 'Caqueta'),
(748, 47, 'CAS', 'Casanare'),
(749, 47, 'CAU', 'Cauca'),
(750, 47, 'CES', 'Cesar'),
(751, 47, 'CHO', 'Choco'),
(752, 47, 'COR', 'Cordoba'),
(753, 47, 'CAM', 'Cundinamarca'),
(754, 47, 'GNA', 'Guainia'),
(755, 47, 'GJR', 'Guajira'),
(756, 47, 'GVR', 'Guaviare'),
(757, 47, 'HUI', 'Huila'),
(758, 47, 'MAG', 'Magdalena'),
(759, 47, 'MET', 'Meta'),
(760, 47, 'NAR', 'Narino'),
(761, 47, 'NDS', 'Norte de Santander'),
(762, 47, 'PUT', 'Putumayo'),
(763, 47, 'QUI', 'Quindio'),
(764, 47, 'RIS', 'Risaralda'),
(765, 47, 'SAP', 'San Andres y Providencia'),
(766, 47, 'SAN', 'Santander'),
(767, 47, 'SUC', 'Sucre'),
(768, 47, 'TOL', 'Tolima'),
(769, 47, 'VDC', 'Valle del Cauca'),
(770, 47, 'VAU', 'Vaupes'),
(771, 47, 'VIC', 'Vichada'),
(772, 48, 'G', 'Grande Comore'),
(773, 48, 'A', 'Anjouan'),
(774, 48, 'M', 'Moheli'),
(775, 49, 'BO', 'Bouenza'),
(776, 49, 'BR', 'Brazzaville'),
(777, 49, 'CU', 'Cuvette'),
(778, 49, 'CO', 'Cuvette-Ouest'),
(779, 49, 'KO', 'Kouilou'),
(780, 49, 'LE', 'Lekoumou'),
(781, 49, 'LI', 'Likouala'),
(782, 49, 'NI', 'Niari'),
(783, 49, 'PL', 'Plateaux'),
(784, 49, 'PO', 'Pool'),
(785, 49, 'SA', 'Sangha'),
(786, 50, 'PU', 'Pukapuka'),
(787, 50, 'RK', 'Rakahanga'),
(788, 50, 'MK', 'Manihiki'),
(789, 50, 'PE', 'Penrhyn'),
(790, 50, 'NI', 'Nassau Island'),
(791, 50, 'SU', 'Surwarrow'),
(792, 50, 'PA', 'Palmerston'),
(793, 50, 'AI', 'Aitutaki'),
(794, 50, 'MA', 'Manuae'),
(795, 50, 'TA', 'Takutea'),
(796, 50, 'MT', 'Mitiaro'),
(797, 50, 'AT', 'Atiu'),
(798, 50, 'MU', 'Mauke'),
(799, 50, 'RR', 'Rarotonga'),
(800, 50, 'MG', 'Mangaia'),
(801, 51, 'AL', 'Alajuela'),
(802, 51, 'CA', 'Cartago'),
(803, 51, 'GU', 'Guanacaste'),
(804, 51, 'HE', 'Heredia'),
(805, 51, 'LI', 'Limon'),
(806, 51, 'PU', 'Puntarenas'),
(807, 51, 'SJ', 'San Jose'),
(808, 52, 'ABE', 'Abengourou'),
(809, 52, 'ABI', 'Abidjan'),
(810, 52, 'ABO', 'Aboisso'),
(811, 52, 'ADI', 'Adiake'),
(812, 52, 'ADZ', 'Adzope'),
(813, 52, 'AGB', 'Agboville'),
(814, 52, 'AGN', 'Agnibilekrou'),
(815, 52, 'ALE', 'Alepe'),
(816, 52, 'BOC', 'Bocanda'),
(817, 52, 'BAN', 'Bangolo'),
(818, 52, 'BEO', 'Beoumi'),
(819, 52, 'BIA', 'Biankouma'),
(820, 52, 'BDK', 'Bondoukou'),
(821, 52, 'BGN', 'Bongouanou'),
(822, 52, 'BFL', 'Bouafle'),
(823, 52, 'BKE', 'Bouake'),
(824, 52, 'BNA', 'Bouna'),
(825, 52, 'BDL', 'Boundiali'),
(826, 52, 'DKL', 'Dabakala'),
(827, 52, 'DBU', 'Dabou'),
(828, 52, 'DAL', 'Daloa'),
(829, 52, 'DAN', 'Danane'),
(830, 52, 'DAO', 'Daoukro'),
(831, 52, 'DIM', 'Dimbokro'),
(832, 52, 'DIV', 'Divo'),
(833, 52, 'DUE', 'Duekoue'),
(834, 52, 'FER', 'Ferkessedougou'),
(835, 52, 'GAG', 'Gagnoa'),
(836, 52, 'GBA', 'Grand-Bassam'),
(837, 52, 'GLA', 'Grand-Lahou'),
(838, 52, 'GUI', 'Guiglo'),
(839, 52, 'ISS', 'Issia'),
(840, 52, 'JAC', 'Jacqueville'),
(841, 52, 'KAT', 'Katiola'),
(842, 52, 'KOR', 'Korhogo'),
(843, 52, 'LAK', 'Lakota'),
(844, 52, 'MAN', 'Man'),
(845, 52, 'MKN', 'Mankono'),
(846, 52, 'MBA', 'Mbahiakro'),
(847, 52, 'ODI', 'Odienne'),
(848, 52, 'OUM', 'Oume'),
(849, 52, 'SAK', 'Sakassou'),
(850, 52, 'SPE', 'San-Pedro'),
(851, 52, 'SAS', 'Sassandra'),
(852, 52, 'SEG', 'Seguela'),
(853, 52, 'SIN', 'Sinfra'),
(854, 52, 'SOU', 'Soubre'),
(855, 52, 'TAB', 'Tabou'),
(856, 52, 'TAN', 'Tanda'),
(857, 52, 'TIE', 'Tiebissou'),
(858, 52, 'TIN', 'Tingrela'),
(859, 52, 'TIA', 'Tiassale'),
(860, 52, 'TBA', 'Touba'),
(861, 52, 'TLP', 'Toulepleu'),
(862, 52, 'TMD', 'Toumodi'),
(863, 52, 'VAV', 'Vavoua'),
(864, 52, 'YAM', 'Yamoussoukro'),
(865, 52, 'ZUE', 'Zuenoula'),
(866, 53, 'BB', 'Bjelovar-Bilogora'),
(867, 53, 'CZ', 'City of Zagreb'),
(868, 53, 'DN', 'Dubrovnik-Neretva'),
(869, 53, 'IS', 'Istra'),
(870, 53, 'KA', 'Karlovac'),
(871, 53, 'KK', 'Koprivnica-Krizevci'),
(872, 53, 'KZ', 'Krapina-Zagorje'),
(873, 53, 'LS', 'Lika-Senj'),
(874, 53, 'ME', 'Medimurje'),
(875, 53, 'OB', 'Osijek-Baranja'),
(876, 53, 'PS', 'Pozega-Slavonia'),
(877, 53, 'PG', 'Primorje-Gorski Kotar'),
(878, 53, 'SI', 'Sibenik'),
(879, 53, 'SM', 'Sisak-Moslavina'),
(880, 53, 'SB', 'Slavonski Brod-Posavina'),
(881, 53, 'SD', 'Split-Dalmatia'),
(882, 53, 'VA', 'Varazdin'),
(883, 53, 'VP', 'Virovitica-Podravina'),
(884, 53, 'VS', 'Vukovar-Srijem'),
(885, 53, 'ZK', 'Zadar-Knin'),
(886, 53, 'ZA', 'Zagreb'),
(887, 54, 'CA', 'Camaguey'),
(888, 54, 'CD', 'Ciego de Avila'),
(889, 54, 'CI', 'Cienfuegos'),
(890, 54, 'CH', 'Ciudad de La Habana'),
(891, 54, 'GR', 'Granma'),
(892, 54, 'GU', 'Guantanamo'),
(893, 54, 'HO', 'Holguin'),
(894, 54, 'IJ', 'Isla de la Juventud'),
(895, 54, 'LH', 'La Habana'),
(896, 54, 'LT', 'Las Tunas'),
(897, 54, 'MA', 'Matanzas'),
(898, 54, 'PR', 'Pinar del Rio'),
(899, 54, 'SS', 'Sancti Spiritus'),
(900, 54, 'SC', 'Santiago de Cuba'),
(901, 54, 'VC', 'Villa Clara'),
(902, 55, 'F', 'Famagusta'),
(903, 55, 'K', 'Kyrenia'),
(904, 55, 'A', 'Larnaca'),
(905, 55, 'I', 'Limassol'),
(906, 55, 'N', 'Nicosia'),
(907, 55, 'P', 'Paphos'),
(908, 56, 'U', '&Uacute;steck&#253;'),
(909, 56, 'C', 'Jiho&#269;esk&#253;'),
(910, 56, 'B', 'Jihomoravsk&#253;'),
(911, 56, 'K', 'Karlovarsk&#253;'),
(912, 56, 'H', 'Kr&aacute;lov&eacute;hradeck&#25'),
(913, 56, 'L', 'Libereck&#253;'),
(914, 56, 'T', 'Moravskoslezsk&#253;'),
(915, 56, 'M', 'Olomouck&#253;'),
(916, 56, 'E', 'Pardubick&#253;'),
(917, 56, 'P', 'Plze&#328;sk&#253;'),
(918, 56, 'A', 'Hlavn&iacute; m&#283;sto Praha'),
(919, 56, 'S', 'St&#345;edo&#269;esk&#253;'),
(920, 56, 'J', 'Vyso&#269;ina'),
(921, 56, 'Z', 'Zl&iacute;nsk&#253;'),
(922, 57, 'AR', 'Arhus'),
(923, 57, 'BH', 'Bornholm'),
(924, 57, 'CO', 'Copenhagen'),
(925, 57, 'FO', 'Faroe Islands'),
(926, 57, 'FR', 'Frederiksborg'),
(927, 57, 'FY', 'Fyn'),
(928, 57, 'KO', 'Kobenhavn'),
(929, 57, 'NO', 'Nordjylland'),
(930, 57, 'RI', 'Ribe'),
(931, 57, 'RK', 'Ringkobing'),
(932, 57, 'RO', 'Roskilde'),
(933, 57, 'SO', 'Sonderjylland'),
(934, 57, 'ST', 'Storstrom'),
(935, 57, 'VK', 'Vejle'),
(936, 57, 'VJ', 'Vestj&aelig;lland'),
(937, 57, 'VB', 'Viborg'),
(938, 58, 'S', '''Ali Sabih'),
(939, 58, 'K', 'Dikhil'),
(940, 58, 'J', 'Djibouti'),
(941, 58, 'O', 'Obock'),
(942, 58, 'T', 'Tadjoura'),
(943, 59, 'AND', 'Saint Andrew Parish'),
(944, 59, 'DAV', 'Saint David Parish'),
(945, 59, 'GEO', 'Saint George Parish'),
(946, 59, 'JOH', 'Saint John Parish'),
(947, 59, 'JOS', 'Saint Joseph Parish'),
(948, 59, 'LUK', 'Saint Luke Parish'),
(949, 59, 'MAR', 'Saint Mark Parish'),
(950, 59, 'PAT', 'Saint Patrick Parish'),
(951, 59, 'PAU', 'Saint Paul Parish'),
(952, 59, 'PET', 'Saint Peter Parish'),
(953, 60, 'DN', 'Distrito Nacional'),
(954, 60, 'AZ', 'Azua'),
(955, 60, 'BC', 'Baoruco'),
(956, 60, 'BH', 'Barahona'),
(957, 60, 'DJ', 'Dajabon'),
(958, 60, 'DU', 'Duarte'),
(959, 60, 'EL', 'Elias Pina'),
(960, 60, 'SY', 'El Seybo'),
(961, 60, 'ET', 'Espaillat'),
(962, 60, 'HM', 'Hato Mayor'),
(963, 60, 'IN', 'Independencia'),
(964, 60, 'AL', 'La Altagracia'),
(965, 60, 'RO', 'La Romana'),
(966, 60, 'VE', 'La Vega'),
(967, 60, 'MT', 'Maria Trinidad Sanchez'),
(968, 60, 'MN', 'Monsenor Nouel'),
(969, 60, 'MC', 'Monte Cristi'),
(970, 60, 'MP', 'Monte Plata'),
(971, 60, 'PD', 'Pedernales'),
(972, 60, 'PR', 'Peravia (Bani)'),
(973, 60, 'PP', 'Puerto Plata'),
(974, 60, 'SL', 'Salcedo'),
(975, 60, 'SM', 'Samana'),
(976, 60, 'SH', 'Sanchez Ramirez'),
(977, 60, 'SC', 'San Cristobal'),
(978, 60, 'JO', 'San Jose de Ocoa'),
(979, 60, 'SJ', 'San Juan'),
(980, 60, 'PM', 'San Pedro de Macoris'),
(981, 60, 'SA', 'Santiago'),
(982, 60, 'ST', 'Santiago Rodriguez'),
(983, 60, 'SD', 'Santo Domingo'),
(984, 60, 'VA', 'Valverde'),
(985, 61, 'AL', 'Aileu'),
(986, 61, 'AN', 'Ainaro'),
(987, 61, 'BA', 'Baucau'),
(988, 61, 'BO', 'Bobonaro'),
(989, 61, 'CO', 'Cova Lima'),
(990, 61, 'DI', 'Dili'),
(991, 61, 'ER', 'Ermera'),
(992, 61, 'LA', 'Lautem'),
(993, 61, 'LI', 'Liquica'),
(994, 61, 'MT', 'Manatuto'),
(995, 61, 'MF', 'Manufahi'),
(996, 61, 'OE', 'Oecussi'),
(997, 61, 'VI', 'Viqueque'),
(998, 62, 'AZU', 'Azuay'),
(999, 62, 'BOL', 'Bolivar'),
(1000, 62, 'CAN', 'Ca&ntilde;ar'),
(1001, 62, 'CAR', 'Carchi'),
(1002, 62, 'CHI', 'Chimborazo'),
(1003, 62, 'COT', 'Cotopaxi'),
(1004, 62, 'EOR', 'El Oro'),
(1005, 62, 'ESM', 'Esmeraldas'),
(1006, 62, 'GPS', 'Gal&aacute;pagos'),
(1007, 62, 'GUA', 'Guayas'),
(1008, 62, 'IMB', 'Imbabura'),
(1009, 62, 'LOJ', 'Loja'),
(1010, 62, 'LRO', 'Los RÃ­os'),
(1011, 62, 'MAN', 'Manab&iacute;'),
(1012, 62, 'MSA', 'Morona Santiago'),
(1013, 62, 'NAP', 'Napo'),
(1014, 62, 'ORE', 'Orellana'),
(1015, 62, 'PAS', 'Pastaza'),
(1016, 62, 'PIC', 'Pichincha'),
(1017, 62, 'SUC', 'Sucumb&iacute;os'),
(1018, 62, 'TUN', 'Tungurahua'),
(1019, 62, 'ZCH', 'Zamora Chinchipe'),
(1020, 63, 'DHY', 'Ad Daqahliyah'),
(1021, 63, 'BAM', 'Al Bahr al Ahmar'),
(1022, 63, 'BHY', 'Al Buhayrah'),
(1023, 63, 'FYM', 'Al Fayyum'),
(1024, 63, 'GBY', 'Al Gharbiyah'),
(1025, 63, 'IDR', 'Al Iskandariyah'),
(1026, 63, 'IML', 'Al Isma''iliyah'),
(1027, 63, 'JZH', 'Al Jizah'),
(1028, 63, 'MFY', 'Al Minufiyah'),
(1029, 63, 'MNY', 'Al Minya'),
(1030, 63, 'QHR', 'Al Qahirah'),
(1031, 63, 'QLY', 'Al Qalyubiyah'),
(1032, 63, 'WJD', 'Al Wadi al Jadid'),
(1033, 63, 'SHQ', 'Ash Sharqiyah'),
(1034, 63, 'SWY', 'As Suways'),
(1035, 63, 'ASW', 'Aswan'),
(1036, 63, 'ASY', 'Asyut'),
(1037, 63, 'BSW', 'Bani Suwayf'),
(1038, 63, 'BSD', 'Bur Sa''id'),
(1039, 63, 'DMY', 'Dumyat'),
(1040, 63, 'JNS', 'Janub Sina'''),
(1041, 63, 'KSH', 'Kafr ash Shaykh'),
(1042, 63, 'MAT', 'Matruh'),
(1043, 63, 'QIN', 'Qina'),
(1044, 63, 'SHS', 'Shamal Sina'''),
(1045, 63, 'SUH', 'Suhaj'),
(1046, 64, 'AH', 'Ahuachapan'),
(1047, 64, 'CA', 'Cabanas'),
(1048, 64, 'CH', 'Chalatenango'),
(1049, 64, 'CU', 'Cuscatlan'),
(1050, 64, 'LB', 'La Libertad'),
(1051, 64, 'PZ', 'La Paz'),
(1052, 64, 'UN', 'La Union'),
(1053, 64, 'MO', 'Morazan'),
(1054, 64, 'SM', 'San Miguel'),
(1055, 64, 'SS', 'San Salvador'),
(1056, 64, 'SV', 'San Vicente'),
(1057, 64, 'SA', 'Santa Ana'),
(1058, 64, 'SO', 'Sonsonate'),
(1059, 64, 'US', 'Usulutan'),
(1060, 65, 'AN', 'Provincia Annobon'),
(1061, 65, 'BN', 'Provincia Bioko Norte'),
(1062, 65, 'BS', 'Provincia Bioko Sur'),
(1063, 65, 'CS', 'Provincia Centro Sur'),
(1064, 65, 'KN', 'Provincia Kie-Ntem'),
(1065, 65, 'LI', 'Provincia Litoral'),
(1066, 65, 'WN', 'Provincia Wele-Nzas'),
(1067, 66, 'MA', 'Central (Maekel)'),
(1068, 66, 'KE', 'Anseba (Keren)'),
(1069, 66, 'DK', 'Southern Red Sea (Debub-Keih-Bah'),
(1070, 66, 'SK', 'Northern Red Sea (Semien-Keih-Ba'),
(1071, 66, 'DE', 'Southern (Debub)'),
(1072, 66, 'BR', 'Gash-Barka (Barentu)'),
(1073, 67, 'HA', 'Harjumaa (Tallinn)'),
(1074, 67, 'HI', 'Hiiumaa (Kardla)'),
(1075, 67, 'IV', 'Ida-Virumaa (Johvi)'),
(1076, 67, 'JA', 'Jarvamaa (Paide)'),
(1077, 67, 'JO', 'Jogevamaa (Jogeva)'),
(1078, 67, 'LV', 'Laane-Virumaa (Rakvere)'),
(1079, 67, 'LA', 'Laanemaa (Haapsalu)'),
(1080, 67, 'PA', 'Parnumaa (Parnu)'),
(1081, 67, 'PO', 'Polvamaa (Polva)'),
(1082, 67, 'RA', 'Raplamaa (Rapla)'),
(1083, 67, 'SA', 'Saaremaa (Kuessaare)'),
(1084, 67, 'TA', 'Tartumaa (Tartu)'),
(1085, 67, 'VA', 'Valgamaa (Valga)'),
(1086, 67, 'VI', 'Viljandimaa (Viljandi)'),
(1087, 67, 'VO', 'Vorumaa (Voru)'),
(1088, 68, 'AF', 'Afar'),
(1089, 68, 'AH', 'Amhara'),
(1090, 68, 'BG', 'Benishangul-Gumaz'),
(1091, 68, 'GB', 'Gambela'),
(1092, 68, 'HR', 'Hariai'),
(1093, 68, 'OR', 'Oromia'),
(1094, 68, 'SM', 'Somali'),
(1095, 68, 'SN', 'Southern Nations - Nationalities'),
(1096, 68, 'TG', 'Tigray'),
(1097, 68, 'AA', 'Addis Ababa'),
(1098, 68, 'DD', 'Dire Dawa'),
(1099, 70, 'T&Ucirc;R', 'T&ucirc;rshavnar Kommuna'),
(1100, 70, 'KLA', 'Klaksv&iacute;k'),
(1101, 70, 'RUN', 'Runav&iacute;k'),
(1102, 70, 'TV&Oslash;', 'Tv&oslash;royri'),
(1103, 70, 'FUG', 'Fuglafj&oslash;r&eth;ur'),
(1104, 70, 'SUN', 'Sunda Kommuna'),
(1105, 70, 'V&Aacute;G', 'V&aacute;gur'),
(1106, 70, 'NES', 'Nes'),
(1107, 70, 'VES', 'Vestmanna'),
(1108, 70, 'MI&eth;', 'Mi&eth;v&aacute;gur'),
(1109, 70, 'S&Oslash;R', 'S&oslash;rv&aacute;gur'),
(1110, 70, 'G&Oslash;T', 'G&oslash;tu Kommuna'),
(1111, 70, 'SJ&Ucirc;', 'Sj&ucirc;var Kommuna'),
(1112, 70, 'LEI', 'Leirv&iacute;k'),
(1113, 70, 'SAN', 'Sandav&aacute;gur'),
(1114, 70, 'HVA', 'Hvalba'),
(1115, 70, 'EI&eth;', 'Ei&eth;i'),
(1116, 70, 'KV&Iacute;', 'Kv&iacute;v&iacute;k'),
(1117, 70, 'SAN', 'Sandur'),
(1118, 70, 'SKO', 'Skopun'),
(1119, 70, 'HVA', 'Hvannasund'),
(1120, 70, 'SUM', 'Sumba'),
(1121, 70, 'VI&eth;', 'Vi&eth;arei&eth;i'),
(1122, 70, 'POR', 'Porkeri'),
(1123, 70, 'SK&Aacute;', 'Sk&aacute;lav&iacute;k'),
(1124, 70, 'KUN', 'Kunoy'),
(1125, 70, 'H&Uacute;S', 'H&uacute;sav&iacute;k'),
(1126, 70, 'HOV', 'Hov'),
(1127, 70, 'F&Aacute;M', 'F&aacute;mjin'),
(1128, 70, 'FUN', 'Funningur'),
(1129, 70, 'H&Uacute;S', 'H&uacute;sar'),
(1130, 70, 'SK&Uacute;', 'Sk&uacute;voy'),
(1131, 70, 'SV&Iacute;', 'Sv&iacute;noy'),
(1132, 70, 'FUG', 'Fugloy'),
(1133, 71, 'C', 'Central Division'),
(1134, 71, 'N', 'Northern Division'),
(1135, 71, 'E', 'Eastern Division'),
(1136, 71, 'W', 'Western Division'),
(1137, 71, 'R', 'Rotuma'),
(1138, 72, 'AL', 'Ahvenanmaan Laani'),
(1139, 72, 'ES', 'Etela-Suomen Laani'),
(1140, 72, 'IS', 'Ita-Suomen Laani'),
(1141, 72, 'LS', 'Lansi-Suomen Laani'),
(1142, 72, 'LA', 'Lapin Lanani'),
(1143, 72, 'OU', 'Oulun Laani'),
(1144, 73, 'AL', 'Alsace'),
(1145, 73, 'AQ', 'Aquitaine'),
(1146, 73, 'AU', 'Auvergne'),
(1147, 73, 'BR', 'Brittany'),
(1148, 73, 'BU', 'Burgundy'),
(1149, 73, 'CE', 'Center Loire Valley'),
(1150, 73, 'CH', 'Champagne'),
(1151, 73, 'CO', 'Corse'),
(1152, 73, 'FR', 'France Comte'),
(1153, 73, 'LA', 'Languedoc Roussillon'),
(1154, 73, 'LI', 'Limousin'),
(1155, 73, 'LO', 'Lorraine'),
(1156, 73, 'MI', 'Midi Pyrenees'),
(1157, 73, 'NO', 'Nord Pas de Calais'),
(1158, 73, 'NR', 'Normandy'),
(1159, 73, 'PA', 'Paris / Ill de France'),
(1160, 73, 'PI', 'Picardie'),
(1161, 73, 'PO', 'Poitou Charente'),
(1162, 73, 'PR', 'Provence'),
(1163, 73, 'RH', 'Rhone Alps'),
(1164, 73, 'RI', 'Riviera'),
(1165, 73, 'WE', 'Western Loire Valley'),
(1166, 74, 'Et', 'Etranger'),
(1167, 74, '01', 'Ain'),
(1168, 74, '02', 'Aisne'),
(1169, 74, '03', 'Allier'),
(1170, 74, '04', 'Alpes de Haute Provence'),
(1171, 74, '05', 'Hautes-Alpes'),
(1172, 74, '06', 'Alpes Maritimes'),
(1173, 74, '07', 'Ard&egrave;che'),
(1174, 74, '08', 'Ardennes'),
(1175, 74, '09', 'Ari&egrave;ge'),
(1176, 74, '10', 'Aube'),
(1177, 74, '11', 'Aude'),
(1178, 74, '12', 'Aveyron'),
(1179, 74, '13', 'Bouches du Rh&ocirc;ne'),
(1180, 74, '14', 'Calvados'),
(1181, 74, '15', 'Cantal'),
(1182, 74, '16', 'Charente'),
(1183, 74, '17', 'Charente Maritime'),
(1184, 74, '18', 'Cher'),
(1185, 74, '19', 'Corr&egrave;ze'),
(1186, 74, '2A', 'Corse du Sud'),
(1187, 74, '2B', 'Haute Corse'),
(1188, 74, '21', 'C&ocirc;te d''or'),
(1189, 74, '22', 'C&ocirc;tes d''Armor'),
(1190, 74, '23', 'Creuse'),
(1191, 74, '24', 'Dordogne'),
(1192, 74, '25', 'Doubs'),
(1193, 74, '26', 'Dr&ocirc;me'),
(1194, 74, '27', 'Eure'),
(1195, 74, '28', 'Eure et Loir'),
(1196, 74, '29', 'Finist&egrave;re'),
(1197, 74, '30', 'Gard'),
(1198, 74, '31', 'Haute Garonne'),
(1199, 74, '32', 'Gers'),
(1200, 74, '33', 'Gironde'),
(1201, 74, '34', 'H&eacute;rault'),
(1202, 74, '35', 'Ille et Vilaine'),
(1203, 74, '36', 'Indre'),
(1204, 74, '37', 'Indre et Loire'),
(1205, 74, '38', 'Is&eacute;re'),
(1206, 74, '39', 'Jura'),
(1207, 74, '40', 'Landes'),
(1208, 74, '41', 'Loir et Cher'),
(1209, 74, '42', 'Loire'),
(1210, 74, '43', 'Haute Loire'),
(1211, 74, '44', 'Loire Atlantique'),
(1212, 74, '45', 'Loiret'),
(1213, 74, '46', 'Lot'),
(1214, 74, '47', 'Lot et Garonne'),
(1215, 74, '48', 'Loz&egrave;re'),
(1216, 74, '49', 'Maine et Loire'),
(1217, 74, '50', 'Manche'),
(1218, 74, '51', 'Marne'),
(1219, 74, '52', 'Haute Marne'),
(1220, 74, '53', 'Mayenne'),
(1221, 74, '54', 'Meurthe et Moselle'),
(1222, 74, '55', 'Meuse'),
(1223, 74, '56', 'Morbihan'),
(1224, 74, '57', 'Moselle'),
(1225, 74, '58', 'Ni&egrave;vre'),
(1226, 74, '59', 'Nord'),
(1227, 74, '60', 'Oise'),
(1228, 74, '61', 'Orne'),
(1229, 74, '62', 'Pas de Calais'),
(1230, 74, '63', 'Puy de D&ocirc;me'),
(1231, 74, '64', 'Pyr&eacute;n&eacute;es Atlantiqu'),
(1232, 74, '65', 'Hautes Pyr&eacute;n&eacute;es'),
(1233, 74, '66', 'Pyr&eacute;n&eacute;es Orientale'),
(1234, 74, '67', 'Bas Rhin'),
(1235, 74, '68', 'Haut Rhin'),
(1236, 74, '69', 'Rh&ocirc;ne'),
(1237, 74, '70', 'Haute Sa&ocirc;ne'),
(1238, 74, '71', 'Sa&ocirc;ne et Loire'),
(1239, 74, '72', 'Sarthe'),
(1240, 74, '73', 'Savoie'),
(1241, 74, '74', 'Haute Savoie'),
(1242, 74, '75', 'Paris'),
(1243, 74, '76', 'Seine Maritime'),
(1244, 74, '77', 'Seine et Marne'),
(1245, 74, '78', 'Yvelines'),
(1246, 74, '79', 'Deux S&egrave;vres'),
(1247, 74, '80', 'Somme'),
(1248, 74, '81', 'Tarn'),
(1249, 74, '82', 'Tarn et Garonne'),
(1250, 74, '83', 'Var'),
(1251, 74, '84', 'Vaucluse'),
(1252, 74, '85', 'Vend&eacute;e'),
(1253, 74, '86', 'Vienne'),
(1254, 74, '87', 'Haute Vienne'),
(1255, 74, '88', 'Vosges'),
(1256, 74, '89', 'Yonne'),
(1257, 74, '90', 'Territoire de Belfort'),
(1258, 74, '91', 'Essonne'),
(1259, 74, '92', 'Hauts de Seine'),
(1260, 74, '93', 'Seine St-Denis'),
(1261, 74, '94', 'Val de Marne'),
(1262, 74, '95', 'Val d''Oise'),
(1263, 75, 'AWA', 'Awala-Yalimapo'),
(1264, 75, 'MAN', 'Mana'),
(1265, 75, 'SAI', 'Saint-Laurent-Du-Maroni'),
(1266, 75, 'APA', 'Apatou'),
(1267, 75, 'GRA', 'Grand-Santi'),
(1268, 75, 'PAP', 'Papa&iuml;chton'),
(1269, 75, 'SAÃœ', 'SaÃ¼l'),
(1270, 75, 'MAR', 'Maripasoula'),
(1271, 75, 'CAM', 'Camopi'),
(1272, 75, 'SAI', 'Saint-Georges'),
(1273, 75, 'OUA', 'Ouanary'),
(1274, 75, 'R&Eacute;G', 'R&eacute;gina'),
(1275, 75, 'ROU', 'Roura'),
(1276, 75, 'SAI', 'Saint-&Eacute;lie'),
(1277, 75, 'IRA', 'Iracoubo'),
(1278, 75, 'SIN', 'Sinnamary'),
(1279, 75, 'KOU', 'Kourou'),
(1280, 75, 'MAC', 'Macouria'),
(1281, 75, 'MON', 'Montsin&eacute;ry-Tonnegrande'),
(1282, 75, 'MAT', 'Matoury'),
(1283, 75, 'CAY', 'Cayenne'),
(1284, 75, 'REM', 'Remire-Montjoly'),
(1285, 76, 'M', 'Archipel des Marquises'),
(1286, 76, 'T', 'Archipel des Tuamotu'),
(1287, 76, 'I', 'Archipel des Tubuai'),
(1288, 76, 'V', 'Iles du Vent'),
(1289, 76, 'S', 'Iles Sous-le-Vent'),
(1290, 77, 'C', 'Iles Crozet'),
(1291, 77, 'K', 'Iles Kerguelen'),
(1292, 77, 'A', 'Ile Amsterdam'),
(1293, 77, 'P', 'Ile Saint-Paul'),
(1294, 77, 'D', 'Adelie Land'),
(1295, 78, 'ES', 'Estuaire'),
(1296, 78, 'HO', 'Haut-Ogooue'),
(1297, 78, 'MO', 'Moyen-Ogooue'),
(1298, 78, 'NG', 'Ngounie'),
(1299, 78, 'NY', 'Nyanga'),
(1300, 78, 'OI', 'Ogooue-Ivindo'),
(1301, 78, 'OL', 'Ogooue-Lolo'),
(1302, 78, 'OM', 'Ogooue-Maritime'),
(1303, 78, 'WN', 'Woleu-Ntem'),
(1304, 79, 'BJ', 'Banjul'),
(1305, 79, 'BS', 'Basse'),
(1306, 79, 'BR', 'Brikama'),
(1307, 79, 'JA', 'Janjangbure'),
(1308, 79, 'KA', 'Kanifeng'),
(1309, 79, 'KE', 'Kerewan'),
(1310, 79, 'KU', 'Kuntaur'),
(1311, 79, 'MA', 'Mansakonko'),
(1312, 79, 'LR', 'Lower River'),
(1313, 79, 'CR', 'Central River'),
(1314, 79, 'NB', 'North Bank'),
(1315, 79, 'UR', 'Upper River'),
(1316, 79, 'WE', 'Western'),
(1317, 80, 'AB', 'Abkhazia'),
(1318, 80, 'AJ', 'Ajaria'),
(1319, 80, 'TB', 'Tbilisi'),
(1320, 80, 'GU', 'Guria'),
(1321, 80, 'IM', 'Imereti'),
(1322, 80, 'KA', 'Kakheti'),
(1323, 80, 'KK', 'Kvemo Kartli'),
(1324, 80, 'MM', 'Mtskheta-Mtianeti'),
(1325, 80, 'RL', 'Racha Lechkhumi and Kvemo Svanet'),
(1326, 80, 'SZ', 'Samegrelo-Zemo Svaneti'),
(1327, 80, 'SJ', 'Samtskhe-Javakheti'),
(1328, 80, 'SK', 'Shida Kartli'),
(1329, 81, 'BAW', 'Baden-WÃ¼rttemberg'),
(1330, 81, 'BAY', 'Bayern'),
(1331, 81, 'BER', 'Berlin'),
(1332, 81, 'BRG', 'Brandenburg'),
(1333, 81, 'BRE', 'Bremen'),
(1334, 81, 'HAM', 'Hamburg'),
(1335, 81, 'HES', 'Hessen'),
(1336, 81, 'MEC', 'Mecklenburg-Vorpommern'),
(1337, 81, 'NDS', 'Niedersachsen'),
(1338, 81, 'NRW', 'Nordrhein-Westfalen'),
(1339, 81, 'RHE', 'Rheinland-Pfalz'),
(1340, 81, 'SAR', 'Saarland'),
(1341, 81, 'SAS', 'Sachsen'),
(1342, 81, 'SAC', 'Sachsen-Anhalt'),
(1343, 81, 'SCN', 'Schleswig-Holstein'),
(1344, 81, 'THE', 'Th&uuml;ringen'),
(1345, 82, 'AS', 'Ashanti Region'),
(1346, 82, 'BA', 'Brong-Ahafo Region'),
(1347, 82, 'CE', 'Central Region'),
(1348, 82, 'EA', 'Eastern Region'),
(1349, 82, 'GA', 'Greater Accra Region'),
(1350, 82, 'NO', 'Northern Region'),
(1351, 82, 'UE', 'Upper East Region'),
(1352, 82, 'UW', 'Upper West Region'),
(1353, 82, 'VO', 'Volta Region'),
(1354, 82, 'WE', 'Western Region'),
(1355, 83, 'EAS', 'East Side'),
(1356, 83, 'NOR', 'North District'),
(1357, 83, 'REC', 'Reclamation Areas'),
(1358, 83, 'SAN', 'Sandpits Area'),
(1359, 83, 'SOU', 'South District'),
(1360, 83, 'TOW', 'Town Area'),
(1361, 83, 'UPP', 'Upper Town'),
(1362, 83, 'OTH', 'Other'),
(1363, 84, 'AT', 'Attica'),
(1364, 84, 'CN', 'Central Greece'),
(1365, 84, 'CM', 'Central Macedonia'),
(1366, 84, 'CR', 'Crete'),
(1367, 84, 'EM', 'East Macedonia and Thrace'),
(1368, 84, 'EP', 'Epirus'),
(1369, 84, 'II', 'Ionian Islands'),
(1370, 84, 'NA', 'North Aegean'),
(1371, 84, 'PP', 'Peloponnesos'),
(1372, 84, 'SA', 'South Aegean'),
(1373, 84, 'TH', 'Thessaly'),
(1374, 84, 'WG', 'West Greece'),
(1375, 84, 'WM', 'West Macedonia'),
(1376, 85, 'A', 'Avannaa'),
(1377, 85, 'T', 'Tunu'),
(1378, 85, 'K', 'Kitaa'),
(1379, 86, 'A', 'Saint Andrew'),
(1380, 86, 'D', 'Saint David'),
(1381, 86, 'G', 'Saint George'),
(1382, 86, 'J', 'Saint John'),
(1383, 86, 'M', 'Saint Mark'),
(1384, 86, 'P', 'Saint Patrick'),
(1385, 86, 'C', 'Carriacou'),
(1386, 86, 'Q', 'Petit Martinique'),
(1387, 87, 'ARR', 'Arrondissements Of The Guadeloup'),
(1388, 87, 'CAN', 'Cantons Of The Guadeloupe Depart'),
(1389, 87, 'COM', 'Communes Of The Guadeloupe Depar'),
(1390, 88, 'AGA', 'Agana Heights'),
(1391, 88, 'AGA', 'Agat'),
(1392, 88, 'ASA', 'Asan Maina'),
(1393, 88, 'BAR', 'Barrigada'),
(1394, 88, 'CHA', 'Chalan Pago Ordot'),
(1395, 88, 'DED', 'Dededo'),
(1396, 88, 'HAG', 'Hag&aring;t&ntilde;a'),
(1397, 88, 'INA', 'Inarajan'),
(1398, 88, 'MAN', 'Mangilao'),
(1399, 88, 'MER', 'Merizo'),
(1400, 88, 'MON', 'Mongmong Toto Maite'),
(1401, 88, 'PIT', 'Piti'),
(1402, 88, 'SAN', 'Santa Rita'),
(1403, 88, 'SIN', 'Sinajana'),
(1404, 88, 'TAL', 'Talofofo'),
(1405, 88, 'TAM', 'Tamuning'),
(1406, 88, 'UMA', 'Umatac'),
(1407, 88, 'YIG', 'Yigo'),
(1408, 88, 'YON', 'Yona'),
(1409, 89, 'AV', 'Alta Verapaz'),
(1410, 89, 'BV', 'Baja Verapaz'),
(1411, 89, 'CM', 'Chimaltenango'),
(1412, 89, 'CQ', 'Chiquimula'),
(1413, 89, 'PE', 'El Peten'),
(1414, 89, 'PR', 'El Progreso'),
(1415, 89, 'QC', 'El Quiche'),
(1416, 89, 'ES', 'Escuintla'),
(1417, 89, 'GU', 'Guatemala'),
(1418, 89, 'HU', 'Huehuetenango'),
(1419, 89, 'IZ', 'Izabal'),
(1420, 89, 'JA', 'Jalapa'),
(1421, 89, 'JU', 'Jutiapa'),
(1422, 89, 'QZ', 'Quetzaltenango'),
(1423, 89, 'RE', 'Retalhuleu'),
(1424, 89, 'ST', 'Sacatepequez'),
(1425, 89, 'SM', 'San Marcos'),
(1426, 89, 'SR', 'Santa Rosa'),
(1427, 89, 'SO', 'Solola'),
(1428, 89, 'SU', 'Suchitepequez'),
(1429, 89, 'TO', 'Totonicapan'),
(1430, 89, 'ZA', 'Zacapa'),
(1431, 90, 'CNK', 'Conakry'),
(1432, 90, 'BYL', 'Beyla'),
(1433, 90, 'BFA', 'Boffa'),
(1434, 90, 'BOK', 'Boke'),
(1435, 90, 'COY', 'Coyah'),
(1436, 90, 'DBL', 'Dabola'),
(1437, 90, 'DLB', 'Dalaba'),
(1438, 90, 'DGR', 'Dinguiraye'),
(1439, 90, 'DBR', 'Dubreka'),
(1440, 90, 'FRN', 'Faranah'),
(1441, 90, 'FRC', 'Forecariah'),
(1442, 90, 'FRI', 'Fria'),
(1443, 90, 'GAO', 'Gaoual'),
(1444, 90, 'GCD', 'Gueckedou'),
(1445, 90, 'KNK', 'Kankan'),
(1446, 90, 'KRN', 'Kerouane'),
(1447, 90, 'KND', 'Kindia'),
(1448, 90, 'KSD', 'Kissidougou'),
(1449, 90, 'KBA', 'Koubia'),
(1450, 90, 'KDA', 'Koundara'),
(1451, 90, 'KRA', 'Kouroussa'),
(1452, 90, 'LAB', 'Labe'),
(1453, 90, 'LLM', 'Lelouma'),
(1454, 90, 'LOL', 'Lola'),
(1455, 90, 'MCT', 'Macenta'),
(1456, 90, 'MAL', 'Mali'),
(1457, 90, 'MAM', 'Mamou'),
(1458, 90, 'MAN', 'Mandiana'),
(1459, 90, 'NZR', 'Nzerekore'),
(1460, 90, 'PIT', 'Pita'),
(1461, 90, 'SIG', 'Siguiri'),
(1462, 90, 'TLM', 'Telimele'),
(1463, 90, 'TOG', 'Tougue'),
(1464, 90, 'YOM', 'Yomou'),
(1465, 91, 'BF', 'Bafata Region'),
(1466, 91, 'BB', 'Biombo Region'),
(1467, 91, 'BS', 'Bissau Region'),
(1468, 91, 'BL', 'Bolama Region'),
(1469, 91, 'CA', 'Cacheu Region'),
(1470, 91, 'GA', 'Gabu Region'),
(1471, 91, 'OI', 'Oio Region'),
(1472, 91, 'QU', 'Quinara Region'),
(1473, 91, 'TO', 'Tombali Region'),
(1474, 92, 'BW', 'Barima-Waini'),
(1475, 92, 'CM', 'Cuyuni-Mazaruni'),
(1476, 92, 'DM', 'Demerara-Mahaica'),
(1477, 92, 'EC', 'East Berbice-Corentyne'),
(1478, 92, 'EW', 'Essequibo Islands-West Demerara'),
(1479, 92, 'MB', 'Mahaica-Berbice'),
(1480, 92, 'PM', 'Pomeroon-Supenaam'),
(1481, 92, 'PI', 'Potaro-Siparuni'),
(1482, 92, 'UD', 'Upper Demerara-Berbice'),
(1483, 92, 'UT', 'Upper Takutu-Upper Essequibo'),
(1484, 93, 'AR', 'Artibonite'),
(1485, 93, 'CE', 'Centre'),
(1486, 93, 'GA', 'Grand''Anse'),
(1487, 93, 'ND', 'Nord'),
(1488, 93, 'NE', 'Nord-Est'),
(1489, 93, 'NO', 'Nord-Ouest'),
(1490, 93, 'OU', 'Ouest'),
(1491, 93, 'SD', 'Sud'),
(1492, 93, 'SE', 'Sud-Est'),
(1493, 94, 'F', 'Flat Island'),
(1494, 94, 'M', 'McDonald Island'),
(1495, 94, 'S', 'Shag Island'),
(1496, 94, 'H', 'Heard Island'),
(1497, 95, 'AT', 'Atlantida'),
(1498, 95, 'CH', 'Choluteca'),
(1499, 95, 'CL', 'Colon'),
(1500, 95, 'CM', 'Comayagua'),
(1501, 95, 'CP', 'Copan'),
(1502, 95, 'CR', 'Cortes'),
(1503, 95, 'PA', 'El Paraiso'),
(1504, 95, 'FM', 'Francisco Morazan'),
(1505, 95, 'GD', 'Gracias a Dios'),
(1506, 95, 'IN', 'Intibuca'),
(1507, 95, 'IB', 'Islas de la Bahia (Bay Islands)'),
(1508, 95, 'PZ', 'La Paz'),
(1509, 95, 'LE', 'Lempira'),
(1510, 95, 'OC', 'Ocotepeque'),
(1511, 95, 'OL', 'Olancho'),
(1512, 95, 'SB', 'Santa Barbara'),
(1513, 95, 'VA', 'Valle'),
(1514, 95, 'YO', 'Yoro'),
(1515, 96, 'HCW', 'Central and Western Hong Kong Is'),
(1516, 96, 'HEA', 'Eastern Hong Kong Island'),
(1517, 96, 'HSO', 'Southern Hong Kong Island'),
(1518, 96, 'HWC', 'Wan Chai Hong Kong Island'),
(1519, 96, 'KKC', 'Kowloon City Kowloon'),
(1520, 96, 'KKT', 'Kwun Tong Kowloon'),
(1521, 96, 'KSS', 'Sham Shui Po Kowloon'),
(1522, 96, 'KWT', 'Wong Tai Sin Kowloon'),
(1523, 96, 'KYT', 'Yau Tsim Mong Kowloon'),
(1524, 96, 'NIS', 'Islands New Territories'),
(1525, 96, 'NKT', 'Kwai Tsing New Territories'),
(1526, 96, 'NNO', 'North New Territories'),
(1527, 96, 'NSK', 'Sai Kung New Territories'),
(1528, 96, 'NST', 'Sha Tin New Territories'),
(1529, 96, 'NTP', 'Tai Po New Territories'),
(1530, 96, 'NTW', 'Tsuen Wan New Territories'),
(1531, 96, 'NTM', 'Tuen Mun New Territories'),
(1532, 96, 'NYL', 'Yuen Long New Territories'),
(1533, 97, 'BK', 'Bacs-Kiskun'),
(1534, 97, 'BA', 'Baranya'),
(1535, 97, 'BE', 'Bekes'),
(1536, 97, 'BS', 'Bekescsaba'),
(1537, 97, 'BZ', 'Borsod-Abauj-Zemplen'),
(1538, 97, 'BU', 'Budapest'),
(1539, 97, 'CS', 'Csongrad'),
(1540, 97, 'DE', 'Debrecen'),
(1541, 97, 'DU', 'Dunaujvaros'),
(1542, 97, 'EG', 'Eger'),
(1543, 97, 'FE', 'Fejer'),
(1544, 97, 'GY', 'Gyor'),
(1545, 97, 'GM', 'Gyor-Moson-Sopron'),
(1546, 97, 'HB', 'Hajdu-Bihar'),
(1547, 97, 'HE', 'Heves'),
(1548, 97, 'HO', 'Hodmezovasarhely'),
(1549, 97, 'JN', 'Jasz-Nagykun-Szolnok'),
(1550, 97, 'KA', 'Kaposvar'),
(1551, 97, 'KE', 'Kecskemet'),
(1552, 97, 'KO', 'Komarom-Esztergom'),
(1553, 97, 'MI', 'Miskolc'),
(1554, 97, 'NA', 'Nagykanizsa'),
(1555, 97, 'NO', 'Nograd'),
(1556, 97, 'NY', 'Nyiregyhaza'),
(1557, 97, 'PE', 'Pecs'),
(1558, 97, 'PS', 'Pest'),
(1559, 97, 'SO', 'Somogy'),
(1560, 97, 'SP', 'Sopron'),
(1561, 97, 'SS', 'Szabolcs-Szatmar-Bereg'),
(1562, 97, 'SZ', 'Szeged'),
(1563, 97, 'SE', 'Szekesfehervar'),
(1564, 97, 'SL', 'Szolnok'),
(1565, 97, 'SM', 'Szombathely'),
(1566, 97, 'TA', 'Tatabanya'),
(1567, 97, 'TO', 'Tolna'),
(1568, 97, 'VA', 'Vas'),
(1569, 97, 'VE', 'Veszprem'),
(1570, 97, 'ZA', 'Zala'),
(1571, 97, 'ZZ', 'Zalaegerszeg'),
(1572, 98, 'AL', 'Austurland'),
(1573, 98, 'HF', 'Hofuoborgarsvaeoi'),
(1574, 98, 'NE', 'Norourland eystra'),
(1575, 98, 'NV', 'Norourland vestra'),
(1576, 98, 'SL', 'Suourland'),
(1577, 98, 'SN', 'Suournes'),
(1578, 98, 'VF', 'Vestfiroir'),
(1579, 98, 'VL', 'Vesturland'),
(1580, 99, 'AN', 'Andaman and Nicobar Islands'),
(1581, 99, 'AP', 'Andhra Pradesh'),
(1582, 99, 'AR', 'Arunachal Pradesh'),
(1583, 99, 'AS', 'Assam'),
(1584, 99, 'BI', 'Bihar'),
(1585, 99, 'CH', 'Chandigarh'),
(1586, 99, 'DA', 'Dadra and Nagar Haveli'),
(1587, 99, 'DM', 'Daman and Diu'),
(1588, 99, 'DE', 'Delhi'),
(1589, 99, 'GO', 'Goa'),
(1590, 99, 'GU', 'Gujarat'),
(1591, 99, 'HA', 'Haryana'),
(1592, 99, 'HP', 'Himachal Pradesh'),
(1593, 99, 'JA', 'Jammu and Kashmir'),
(1594, 99, 'KA', 'Karnataka'),
(1595, 99, 'KE', 'Kerala'),
(1596, 99, 'LI', 'Lakshadweep Islands'),
(1597, 99, 'MP', 'Madhya Pradesh'),
(1598, 99, 'MA', 'Maharashtra'),
(1599, 99, 'MN', 'Manipur'),
(1600, 99, 'ME', 'Meghalaya'),
(1601, 99, 'MI', 'Mizoram'),
(1602, 99, 'NA', 'Nagaland'),
(1603, 99, 'OR', 'Orissa'),
(1604, 99, 'PO', 'Pondicherry'),
(1605, 99, 'PU', 'Punjab'),
(1606, 99, 'RA', 'Rajasthan'),
(1607, 99, 'SI', 'Sikkim'),
(1608, 99, 'TN', 'Tamil Nadu'),
(1609, 99, 'TR', 'Tripura'),
(1610, 99, 'UP', 'Uttar Pradesh'),
(1611, 99, 'WB', 'West Bengal'),
(1612, 100, 'DA', 'Daista Aceh'),
(1613, 100, 'SU', 'Sumatera Utara'),
(1614, 100, 'SB', 'Sumatera Barat'),
(1615, 100, 'SI', 'Riau'),
(1616, 100, 'JA', 'Jambi'),
(1617, 100, 'SS', 'Sumatera Selatan'),
(1618, 100, 'BE', 'Bengkulu'),
(1619, 100, 'LA', 'Lampung'),
(1620, 100, 'JK', 'Dki Jakarta'),
(1621, 100, 'JB', 'Jawa Barat'),
(1622, 100, 'JT', 'Jawa Tengah'),
(1623, 100, 'DY', 'Daista Yogyakarta'),
(1624, 100, 'JT', 'Jawa Timur'),
(1625, 100, 'KB', 'Kalimantan Barat'),
(1626, 100, 'KT', 'Kalimantan Tengah'),
(1627, 100, 'KI', 'Kalimantan Timur'),
(1628, 100, 'KS', 'Kalimantan Selatan'),
(1629, 100, 'BA', 'Bali'),
(1630, 100, 'NB', 'Nusa Tenggara Barat'),
(1631, 100, 'NT', 'Nusa Tenggara Timur'),
(1632, 100, 'SN', 'Sulawesi Selatan'),
(1633, 100, 'ST', 'Sulawesi Tengah'),
(1634, 100, 'SA', 'Sulawesi Utara'),
(1635, 100, 'SG', 'Sulawesi Tenggara'),
(1636, 100, 'MA', 'Maluku'),
(1637, 100, 'MU', 'Maluku Utara'),
(1638, 100, 'IJ', 'Irian Jaya Timur'),
(1639, 100, 'IT', 'Irian Jaya Tengah'),
(1640, 100, 'IB', 'Irian Jawa Barat'),
(1641, 100, 'BT', 'Banten'),
(1642, 100, 'BB', 'Bangka Belitung'),
(1643, 100, 'GO', 'Gorontalo'),
(1644, 101, 'TEH', 'Tehran'),
(1645, 101, 'QOM', 'Qom'),
(1646, 101, 'MKZ', 'Markazi'),
(1647, 101, 'QAZ', 'Qazvin'),
(1648, 101, 'GIL', 'Gilan'),
(1649, 101, 'ARD', 'Ardabil'),
(1650, 101, 'ZAN', 'Zanjan'),
(1651, 101, 'EAZ', 'East Azarbaijan'),
(1652, 101, 'WEZ', 'West Azarbaijan'),
(1653, 101, 'KRD', 'Kurdistan'),
(1654, 101, 'HMD', 'Hamadan'),
(1655, 101, 'KRM', 'Kermanshah'),
(1656, 101, 'ILM', 'Ilam'),
(1657, 101, 'LRS', 'Lorestan'),
(1658, 101, 'KZT', 'Khuzestan'),
(1659, 101, 'CMB', 'Chahar Mahaal and Bakhtiari'),
(1660, 101, 'KBA', 'Kohkiluyeh and Buyer Ahmad'),
(1661, 101, 'BSH', 'Bushehr'),
(1662, 101, 'FAR', 'Fars'),
(1663, 101, 'HRM', 'Hormozgan'),
(1664, 101, 'SBL', 'Sistan and Baluchistan'),
(1665, 101, 'KRB', 'Kerman'),
(1666, 101, 'YZD', 'Yazd'),
(1667, 101, 'EFH', 'Esfahan'),
(1668, 101, 'SMN', 'Semnan'),
(1669, 101, 'MZD', 'Mazandaran'),
(1670, 101, 'GLS', 'Golestan'),
(1671, 101, 'NKH', 'North Khorasan'),
(1672, 101, 'RKH', 'Razavi Khorasan'),
(1673, 101, 'SKH', 'South Khorasan'),
(1674, 102, 'BD', 'Baghdad');
INSERT INTO `zones` VALUES
(1675, 102, 'SD', 'Salah ad Din'),
(1676, 102, 'DY', 'Diyala'),
(1677, 102, 'WS', 'Wasit'),
(1678, 102, 'MY', 'Maysan'),
(1679, 102, 'BA', 'Al Basrah'),
(1680, 102, 'DQ', 'Dhi Qar'),
(1681, 102, 'MU', 'Al Muthanna'),
(1682, 102, 'QA', 'Al Qadisyah'),
(1683, 102, 'BB', 'Babil'),
(1684, 102, 'KB', 'Al Karbala'),
(1685, 102, 'NJ', 'An Najaf'),
(1686, 102, 'AB', 'Al Anbar'),
(1687, 102, 'NN', 'Ninawa'),
(1688, 102, 'DH', 'Dahuk'),
(1689, 102, 'AL', 'Arbil'),
(1690, 102, 'TM', 'At Ta''mim'),
(1691, 102, 'SL', 'As Sulaymaniyah'),
(1692, 103, 'CA', 'Carlow'),
(1693, 103, 'CV', 'Cavan'),
(1694, 103, 'CL', 'Clare'),
(1695, 103, 'CO', 'Cork'),
(1696, 103, 'DO', 'Donegal'),
(1697, 103, 'DU', 'Dublin'),
(1698, 103, 'GA', 'Galway'),
(1699, 103, 'KE', 'Kerry'),
(1700, 103, 'KI', 'Kildare'),
(1701, 103, 'KL', 'Kilkenny'),
(1702, 103, 'LA', 'Laois'),
(1703, 103, 'LE', 'Leitrim'),
(1704, 103, 'LI', 'Limerick'),
(1705, 103, 'LO', 'Longford'),
(1706, 103, 'LU', 'Louth'),
(1707, 103, 'MA', 'Mayo'),
(1708, 103, 'ME', 'Meath'),
(1709, 103, 'MO', 'Monaghan'),
(1710, 103, 'OF', 'Offaly'),
(1711, 103, 'RO', 'Roscommon'),
(1712, 103, 'SL', 'Sligo'),
(1713, 103, 'TI', 'Tipperary'),
(1714, 103, 'WA', 'Waterford'),
(1715, 103, 'WE', 'Westmeath'),
(1716, 103, 'WX', 'Wexford'),
(1717, 103, 'WI', 'Wicklow'),
(1718, 104, 'BS', 'Be''er Sheva'),
(1719, 104, 'BH', 'Bika''at Hayarden'),
(1720, 104, 'EA', 'Eilat and Arava'),
(1721, 104, 'GA', 'Galil'),
(1722, 104, 'HA', 'Haifa'),
(1723, 104, 'JM', 'Jehuda Mountains'),
(1724, 104, 'JE', 'Jerusalem'),
(1725, 104, 'NE', 'Negev'),
(1726, 104, 'SE', 'Semaria'),
(1727, 104, 'SH', 'Sharon'),
(1728, 104, 'TA', 'Tel Aviv (Gosh Dan)'),
(1729, 105, 'AG', 'Agrigento'),
(1730, 105, 'AL', 'Alessandria'),
(1731, 105, 'AN', 'Ancona'),
(1732, 105, 'AO', 'Aosta'),
(1733, 105, 'AR', 'Arezzo'),
(1734, 105, 'AP', 'Ascoli Piceno'),
(1735, 105, 'AT', 'Asti'),
(1736, 105, 'AV', 'Avellino'),
(1737, 105, 'BA', 'Bari'),
(1738, 105, 'BL', 'Belluno'),
(1739, 105, 'BN', 'Benevento'),
(1740, 105, 'BG', 'Bergamo'),
(1741, 105, 'BI', 'Biella'),
(1742, 105, 'BO', 'Bologna'),
(1743, 105, 'BZ', 'Bolzano'),
(1744, 105, 'BS', 'Brescia'),
(1745, 105, 'BR', 'Brindisi'),
(1746, 105, 'CA', 'Cagliari'),
(1747, 105, 'CL', 'Caltanissetta'),
(1748, 105, 'CB', 'Campobasso'),
(1749, 105, 'CE', 'Caserta'),
(1750, 105, 'CT', 'Catania'),
(1751, 105, 'CZ', 'Catanzaro'),
(1752, 105, 'CH', 'Chieti'),
(1753, 105, 'CO', 'Como'),
(1754, 105, 'CS', 'Cosenza'),
(1755, 105, 'CR', 'Cremona'),
(1756, 105, 'KR', 'Crotone'),
(1757, 105, 'CN', 'Cuneo'),
(1758, 105, 'EN', 'Enna'),
(1759, 105, 'FE', 'Ferrara'),
(1760, 105, 'FI', 'Firenze'),
(1761, 105, 'FG', 'Foggia'),
(1762, 105, 'FO', 'ForlÃ¬'),
(1763, 105, 'FR', 'Frosinone'),
(1764, 105, 'GE', 'Genova'),
(1765, 105, 'GO', 'Gorizia'),
(1766, 105, 'GR', 'Grosseto'),
(1767, 105, 'IM', 'Imperia'),
(1768, 105, 'IS', 'Isernia'),
(1769, 105, 'AQ', 'Aquila'),
(1770, 105, 'SP', 'La Spezia'),
(1771, 105, 'LT', 'Latina'),
(1772, 105, 'LE', 'Lecce'),
(1773, 105, 'LC', 'Lecco'),
(1774, 105, 'LI', 'Livorno'),
(1775, 105, 'LO', 'Lodi'),
(1776, 105, 'LU', 'Lucca'),
(1777, 105, 'MC', 'Macerata'),
(1778, 105, 'MN', 'Mantova'),
(1779, 105, 'MS', 'Massa-Carrara'),
(1780, 105, 'MT', 'Matera'),
(1781, 105, 'ME', 'Messina'),
(1782, 105, 'MI', 'Milano'),
(1783, 105, 'MO', 'Modena'),
(1784, 105, 'NA', 'Napoli'),
(1785, 105, 'NO', 'Novara'),
(1786, 105, 'NU', 'Nuoro'),
(1787, 105, 'OR', 'Oristano'),
(1788, 105, 'PD', 'Padova'),
(1789, 105, 'PA', 'Palermo'),
(1790, 105, 'PR', 'Parma'),
(1791, 105, 'PG', 'Perugia'),
(1792, 105, 'PV', 'Pavia'),
(1793, 105, 'PU', 'Pesaro Urbino'),
(1794, 105, 'PE', 'Pescara'),
(1795, 105, 'PC', 'Piacenza'),
(1796, 105, 'PI', 'Pisa'),
(1797, 105, 'PT', 'Pistoia'),
(1798, 105, 'PN', 'Pordenone'),
(1799, 105, 'PZ', 'Potenza'),
(1800, 105, 'PO', 'Prato'),
(1801, 105, 'RG', 'Ragusa'),
(1802, 105, 'RA', 'Ravenna'),
(1803, 105, 'RC', 'Reggio Calabria'),
(1804, 105, 'RE', 'Reggio Emilia'),
(1805, 105, 'RI', 'Rieti'),
(1806, 105, 'RN', 'Rimini'),
(1807, 105, 'RM', 'Roma'),
(1808, 105, 'RO', 'Rovigo'),
(1809, 105, 'SA', 'Salerno'),
(1810, 105, 'SS', 'Sassari'),
(1811, 105, 'SV', 'Savona'),
(1812, 105, 'SI', 'Siena'),
(1813, 105, 'SR', 'Siracusa'),
(1814, 105, 'SO', 'Sondrio'),
(1815, 105, 'TA', 'Taranto'),
(1816, 105, 'TE', 'Teramo'),
(1817, 105, 'TR', 'Terni'),
(1818, 105, 'TO', 'Torino'),
(1819, 105, 'TP', 'Trapani'),
(1820, 105, 'TN', 'Trento'),
(1821, 105, 'TV', 'Treviso'),
(1822, 105, 'TS', 'Trieste'),
(1823, 105, 'UD', 'Udine'),
(1824, 105, 'VA', 'Varese'),
(1825, 105, 'VE', 'Venezia'),
(1826, 105, 'VB', 'Verbania'),
(1827, 105, 'VC', 'Vercelli'),
(1828, 105, 'VR', 'Verona'),
(1829, 105, 'VV', 'Vibo Valentia'),
(1830, 105, 'VI', 'Vicenza'),
(1831, 105, 'VT', 'Viterbo'),
(1832, 105, 'CI', 'Carbonia-Iglesias'),
(1833, 105, 'VS', 'Medio Campidano'),
(1834, 105, 'OG', 'Ogliastra'),
(1835, 105, 'OT', 'Olbia-Tempio'),
(1836, 105, 'MB', 'Monza e Brianza'),
(1837, 105, 'FM', 'Fermo'),
(1838, 105, 'BT', 'Barletta-Andria-Trani'),
(1839, 106, 'CLA', 'Clarendon Parish'),
(1840, 106, 'HAN', 'Hanover Parish'),
(1841, 106, 'KIN', 'Kingston Parish'),
(1842, 106, 'MAN', 'Manchester Parish'),
(1843, 106, 'POR', 'Portland Parish'),
(1844, 106, 'AND', 'Saint Andrew Parish'),
(1845, 106, 'ANN', 'Saint Ann Parish'),
(1846, 106, 'CAT', 'Saint Catherine Parish'),
(1847, 106, 'ELI', 'Saint Elizabeth Parish'),
(1848, 106, 'JAM', 'Saint James Parish'),
(1849, 106, 'MAR', 'Saint Mary Parish'),
(1850, 106, 'THO', 'Saint Thomas Parish'),
(1851, 106, 'TRL', 'Trelawny Parish'),
(1852, 106, 'WML', 'Westmoreland Parish'),
(1853, 107, 'AI', 'Aichi'),
(1854, 107, 'AK', 'Akita'),
(1855, 107, 'AO', 'Aomori'),
(1856, 107, 'CH', 'Chiba'),
(1857, 107, 'EH', 'Ehime'),
(1858, 107, 'FK', 'Fukui'),
(1859, 107, 'FU', 'Fukuoka'),
(1860, 107, 'FS', 'Fukushima'),
(1861, 107, 'GI', 'Gifu'),
(1862, 107, 'GU', 'Gumma'),
(1863, 107, 'HI', 'Hiroshima'),
(1864, 107, 'HO', 'Hokkaido'),
(1865, 107, 'HY', 'Hyogo'),
(1866, 107, 'IB', 'Ibaraki'),
(1867, 107, 'IS', 'Ishikawa'),
(1868, 107, 'IW', 'Iwate'),
(1869, 107, 'KA', 'Kagawa'),
(1870, 107, 'KG', 'Kagoshima'),
(1871, 107, 'KN', 'Kanagawa'),
(1872, 107, 'KO', 'Kochi'),
(1873, 107, 'KU', 'Kumamoto'),
(1874, 107, 'KY', 'Kyoto'),
(1875, 107, 'MI', 'Mie'),
(1876, 107, 'MY', 'Miyagi'),
(1877, 107, 'MZ', 'Miyazaki'),
(1878, 107, 'NA', 'Nagano'),
(1879, 107, 'NG', 'Nagasaki'),
(1880, 107, 'NR', 'Nara'),
(1881, 107, 'NI', 'Niigata'),
(1882, 107, 'OI', 'Oita'),
(1883, 107, 'OK', 'Okayama'),
(1884, 107, 'ON', 'Okinawa'),
(1885, 107, 'OS', 'Osaka'),
(1886, 107, 'SA', 'Saga'),
(1887, 107, 'SI', 'Saitama'),
(1888, 107, 'SH', 'Shiga'),
(1889, 107, 'SM', 'Shimane'),
(1890, 107, 'SZ', 'Shizuoka'),
(1891, 107, 'TO', 'Tochigi'),
(1892, 107, 'TS', 'Tokushima'),
(1893, 107, 'TK', 'Tokyo'),
(1894, 107, 'TT', 'Tottori'),
(1895, 107, 'TY', 'Toyama'),
(1896, 107, 'WA', 'Wakayama'),
(1897, 107, 'YA', 'Yamagata'),
(1898, 107, 'YM', 'Yamaguchi'),
(1899, 107, 'YN', 'Yamanashi'),
(1900, 108, 'AM', '''Amman'),
(1901, 108, 'AJ', 'Ajlun'),
(1902, 108, 'AA', 'Al ''Aqabah'),
(1903, 108, 'AB', 'Al Balqa'''),
(1904, 108, 'AK', 'Al Karak'),
(1905, 108, 'AL', 'Al Mafraq'),
(1906, 108, 'AT', 'At Tafilah'),
(1907, 108, 'AZ', 'Az Zarqa'''),
(1908, 108, 'IR', 'Irbid'),
(1909, 108, 'JA', 'Jarash'),
(1910, 108, 'MA', 'Ma''an'),
(1911, 108, 'MD', 'Madaba'),
(1912, 109, 'AL', 'Almaty'),
(1913, 109, 'AC', 'Almaty City'),
(1914, 109, 'AM', 'Aqmola'),
(1915, 109, 'AQ', 'Aqtobe'),
(1916, 109, 'AS', 'Astana City'),
(1917, 109, 'AT', 'Atyrau'),
(1918, 109, 'BA', 'Batys Qazaqstan'),
(1919, 109, 'BY', 'Bayqongyr City'),
(1920, 109, 'MA', 'Mangghystau'),
(1921, 109, 'ON', 'Ongtustik Qazaqstan'),
(1922, 109, 'PA', 'Pavlodar'),
(1923, 109, 'QA', 'Qaraghandy'),
(1924, 109, 'QO', 'Qostanay'),
(1925, 109, 'QY', 'Qyzylorda'),
(1926, 109, 'SH', 'Shyghys Qazaqstan'),
(1927, 109, 'SO', 'Soltustik Qazaqstan'),
(1928, 109, 'ZH', 'Zhambyl'),
(1929, 110, 'CE', 'Central'),
(1930, 110, 'CO', 'Coast'),
(1931, 110, 'EA', 'Eastern'),
(1932, 110, 'NA', 'Nairobi Area'),
(1933, 110, 'NE', 'North Eastern'),
(1934, 110, 'NY', 'Nyanza'),
(1935, 110, 'RV', 'Rift Valley'),
(1936, 110, 'WE', 'Western'),
(1937, 111, 'AG', 'Abaiang'),
(1938, 111, 'AM', 'Abemama'),
(1939, 111, 'AK', 'Aranuka'),
(1940, 111, 'AO', 'Arorae'),
(1941, 111, 'BA', 'Banaba'),
(1942, 111, 'BE', 'Beru'),
(1943, 111, 'bT', 'Butaritari'),
(1944, 111, 'KA', 'Kanton'),
(1945, 111, 'KR', 'Kiritimati'),
(1946, 111, 'KU', 'Kuria'),
(1947, 111, 'MI', 'Maiana'),
(1948, 111, 'MN', 'Makin'),
(1949, 111, 'ME', 'Marakei'),
(1950, 111, 'NI', 'Nikunau'),
(1951, 111, 'NO', 'Nonouti'),
(1952, 111, 'ON', 'Onotoa'),
(1953, 111, 'TT', 'Tabiteuea'),
(1954, 111, 'TR', 'Tabuaeran'),
(1955, 111, 'TM', 'Tamana'),
(1956, 111, 'TW', 'Tarawa'),
(1957, 111, 'TE', 'Teraina'),
(1958, 112, 'CHA', 'Chagang-do'),
(1959, 112, 'HAB', 'Hamgyong-bukto'),
(1960, 112, 'HAN', 'Hamgyong-namdo'),
(1961, 112, 'HWB', 'Hwanghae-bukto'),
(1962, 112, 'HWN', 'Hwanghae-namdo'),
(1963, 112, 'KAN', 'Kangwon-do'),
(1964, 112, 'PYB', 'P''yongan-bukto'),
(1965, 112, 'PYN', 'P''yongan-namdo'),
(1966, 112, 'YAN', 'Ryanggang-do (Yanggang-do)'),
(1967, 112, 'NAJ', 'Rason Directly Governed City'),
(1968, 112, 'PYO', 'P''yongyang Special City'),
(1969, 113, 'CO', 'Ch''ungch''ong-bukto'),
(1970, 113, 'CH', 'Ch''ungch''ong-namdo'),
(1971, 113, 'CD', 'Cheju-do'),
(1972, 113, 'CB', 'Cholla-bukto'),
(1973, 113, 'CN', 'Cholla-namdo'),
(1974, 113, 'IG', 'Inch''on-gwangyoksi'),
(1975, 113, 'KA', 'Kangwon-do'),
(1976, 113, 'KG', 'Kwangju-gwangyoksi'),
(1977, 113, 'KD', 'Kyonggi-do'),
(1978, 113, 'KB', 'Kyongsang-bukto'),
(1979, 113, 'KN', 'Kyongsang-namdo'),
(1980, 113, 'PG', 'Pusan-gwangyoksi'),
(1981, 113, 'SO', 'Soul-t''ukpyolsi'),
(1982, 113, 'TA', 'Taegu-gwangyoksi'),
(1983, 113, 'TG', 'Taejon-gwangyoksi'),
(1984, 114, 'AL', 'Al ''Asimah'),
(1985, 114, 'AA', 'Al Ahmadi'),
(1986, 114, 'AF', 'Al Farwaniyah'),
(1987, 114, 'AJ', 'Al Jahra'''),
(1988, 114, 'HA', 'Hawalli'),
(1989, 115, 'GB', 'Bishkek'),
(1990, 115, 'B', 'Batken'),
(1991, 115, 'C', 'Chu'),
(1992, 115, 'J', 'Jalal-Abad'),
(1993, 115, 'N', 'Naryn'),
(1994, 115, 'O', 'Osh'),
(1995, 115, 'T', 'Talas'),
(1996, 115, 'Y', 'Ysyk-Kol'),
(1997, 116, 'VT', 'Vientiane'),
(1998, 116, 'AT', 'Attapu'),
(1999, 116, 'BK', 'Bokeo'),
(2000, 116, 'BL', 'Bolikhamxai'),
(2001, 116, 'CH', 'Champasak'),
(2002, 116, 'HO', 'Houaphan'),
(2003, 116, 'KH', 'Khammouan'),
(2004, 116, 'LM', 'Louang Namtha'),
(2005, 116, 'LP', 'Louangphabang'),
(2006, 116, 'OU', 'Oudomxai'),
(2007, 116, 'PH', 'Phongsali'),
(2008, 116, 'SL', 'Salavan'),
(2009, 116, 'SV', 'Savannakhet'),
(2010, 116, 'VI', 'Vientiane'),
(2011, 116, 'XA', 'Xaignabouli'),
(2012, 116, 'XE', 'Xekong'),
(2013, 116, 'XI', 'Xiangkhoang'),
(2014, 116, 'XN', 'Xaisomboun'),
(2015, 117, 'AIZ', 'Aizkraukles Rajons'),
(2016, 117, 'ALU', 'Aluksnes Rajons'),
(2017, 117, 'BAL', 'Balvu Rajons'),
(2018, 117, 'BAU', 'Bauskas Rajons'),
(2019, 117, 'CES', 'Cesu Rajons'),
(2020, 117, 'DGR', 'Daugavpils Rajons'),
(2021, 117, 'DOB', 'Dobeles Rajons'),
(2022, 117, 'GUL', 'Gulbenes Rajons'),
(2023, 117, 'JEK', 'Jekabpils Rajons'),
(2024, 117, 'JGR', 'Jelgavas Rajons'),
(2025, 117, 'KRA', 'Kraslavas Rajons'),
(2026, 117, 'KUL', 'Kuldigas Rajons'),
(2027, 117, 'LPR', 'Liepajas Rajons'),
(2028, 117, 'LIM', 'Limbazu Rajons'),
(2029, 117, 'LUD', 'Ludzas Rajons'),
(2030, 117, 'MAD', 'Madonas Rajons'),
(2031, 117, 'OGR', 'Ogres Rajons'),
(2032, 117, 'PRE', 'Preilu Rajons'),
(2033, 117, 'RZR', 'Rezeknes Rajons'),
(2034, 117, 'RGR', 'Rigas Rajons'),
(2035, 117, 'SAL', 'Saldus Rajons'),
(2036, 117, 'TAL', 'Talsu Rajons'),
(2037, 117, 'TUK', 'Tukuma Rajons'),
(2038, 117, 'VLK', 'Valkas Rajons'),
(2039, 117, 'VLM', 'Valmieras Rajons'),
(2040, 117, 'VSR', 'Ventspils Rajons'),
(2041, 117, 'DGV', 'Daugavpils'),
(2042, 117, 'JGV', 'Jelgava'),
(2043, 117, 'JUR', 'Jurmala'),
(2044, 117, 'LPK', 'Liepaja'),
(2045, 117, 'RZK', 'Rezekne'),
(2046, 117, 'RGA', 'Riga'),
(2047, 117, 'VSL', 'Ventspils'),
(2048, 118, 'BIN', 'Bint Jbeil'),
(2049, 118, 'HAS', 'Hasbaya'),
(2050, 118, 'MAR', 'Marjeyoun'),
(2051, 118, 'NAB', 'Nabatieh'),
(2052, 118, 'BAA', 'Baalbek'),
(2053, 118, 'HER', 'Hermel'),
(2054, 118, 'RAS', 'Rashaya'),
(2055, 118, 'WES', 'Western Beqaa'),
(2056, 118, 'ZAH', 'Zahle'),
(2057, 118, 'AKK', 'Akkar'),
(2058, 118, 'BAT', 'Batroun'),
(2059, 118, 'BSH', 'Bsharri'),
(2060, 118, 'KOU', 'Koura'),
(2061, 118, 'MIN', 'Miniyeh-Danniyeh'),
(2062, 118, 'TRI', 'Tripoli'),
(2063, 118, 'ZGH', 'Zgharta'),
(2064, 118, 'ALE', 'Aley'),
(2065, 118, 'BAA', 'Baabda'),
(2066, 118, 'BYB', 'Byblos'),
(2067, 118, 'CHO', 'Chouf'),
(2068, 118, 'KES', 'Kesrwan'),
(2069, 118, 'MAT', 'Matn'),
(2070, 118, 'JEZ', 'Jezzine'),
(2071, 118, 'SID', 'Sidon'),
(2072, 118, 'TYR', 'Tyre'),
(2073, 119, 'BE', 'Berea'),
(2074, 119, 'BB', 'Butha-Buthe'),
(2075, 119, 'LE', 'Leribe'),
(2076, 119, 'MF', 'Mafeteng'),
(2077, 119, 'MS', 'Maseru'),
(2078, 119, 'MH', 'Mohale''s Hoek'),
(2079, 119, 'MK', 'Mokhotlong'),
(2080, 119, 'QN', 'Qacha''s Nek'),
(2081, 119, 'QT', 'Quthing'),
(2082, 119, 'TT', 'Thaba-Tseka'),
(2083, 120, 'BI', 'Bomi'),
(2084, 120, 'BG', 'Bong'),
(2085, 120, 'GB', 'Grand Bassa'),
(2086, 120, 'CM', 'Grand Cape Mount'),
(2087, 120, 'GG', 'Grand Gedeh'),
(2088, 120, 'GK', 'Grand Kru'),
(2089, 120, 'LO', 'Lofa'),
(2090, 120, 'MG', 'Margibi'),
(2091, 120, 'ML', 'Maryland.'),
(2092, 120, 'MS', 'Montserrado'),
(2093, 120, 'NB', 'Nimba'),
(2094, 120, 'RC', 'River Cess'),
(2095, 120, 'SN', 'Sinoe'),
(2096, 121, 'AJ', 'Ajdabiya'),
(2097, 121, 'AZ', 'Al ''Aziziyah'),
(2098, 121, 'FA', 'Al Fatih'),
(2099, 121, 'JA', 'Al Jabal al Akhdar'),
(2100, 121, 'JU', 'Al Jufrah'),
(2101, 121, 'KH', 'Al Khums'),
(2102, 121, 'KU', 'Al Kufrah'),
(2103, 121, 'NK', 'An Nuqat al Khams'),
(2104, 121, 'AS', 'Ash Shati'''),
(2105, 121, 'AW', 'Awbari'),
(2106, 121, 'ZA', 'Az Zawiyah'),
(2107, 121, 'BA', 'Banghazi'),
(2108, 121, 'DA', 'Darnah'),
(2109, 121, 'GD', 'Ghadamis'),
(2110, 121, 'GY', 'Gharyan'),
(2111, 121, 'MI', 'Misratah'),
(2112, 121, 'MZ', 'Murzuq'),
(2113, 121, 'SB', 'Sabha'),
(2114, 121, 'SW', 'Sawfajjin'),
(2115, 121, 'SU', 'Surt'),
(2116, 121, 'TL', 'Tarabulus (Tripoli)'),
(2117, 121, 'TH', 'Tarhunah'),
(2118, 121, 'TU', 'Tubruq'),
(2119, 121, 'YA', 'Yafran'),
(2120, 121, 'ZL', 'Zlitan'),
(2121, 122, 'V', 'Vaduz'),
(2122, 122, 'A', 'Schaan'),
(2123, 122, 'B', 'Balzers'),
(2124, 122, 'N', 'Triesen'),
(2125, 122, 'E', 'Eschen'),
(2126, 122, 'M', 'Mauren'),
(2127, 122, 'T', 'Triesenberg'),
(2128, 122, 'R', 'Ruggell'),
(2129, 122, 'G', 'Gamprin'),
(2130, 122, 'L', 'Schellenberg'),
(2131, 122, 'P', 'Planken'),
(2132, 123, 'AL', 'Alytus'),
(2133, 123, 'KA', 'Kaunas'),
(2134, 123, 'KL', 'Klaipeda'),
(2135, 123, 'MA', 'Marijampole'),
(2136, 123, 'PA', 'Panevezys'),
(2137, 123, 'SI', 'Siauliai'),
(2138, 123, 'TA', 'Taurage'),
(2139, 123, 'TE', 'Telsiai'),
(2140, 123, 'UT', 'Utena'),
(2141, 123, 'VI', 'Vilnius'),
(2142, 124, 'DD', 'Diekirch'),
(2143, 124, 'DC', 'Clervaux'),
(2144, 124, 'DR', 'Redange'),
(2145, 124, 'DV', 'Vianden'),
(2146, 124, 'DW', 'Wiltz'),
(2147, 124, 'GG', 'Grevenmacher'),
(2148, 124, 'GE', 'Echternach'),
(2149, 124, 'GR', 'Remich'),
(2150, 124, 'LL', 'Luxembourg'),
(2151, 124, 'LC', 'Capellen'),
(2152, 124, 'LE', 'Esch-sur-Alzette'),
(2153, 124, 'LM', 'Mersch'),
(2154, 125, 'OLF', 'Our Lady Fatima Parish'),
(2155, 125, 'ANT', 'St. Anthony Parish'),
(2156, 125, 'LAZ', 'St. Lazarus Parish'),
(2157, 125, 'CAT', 'Cathedral Parish'),
(2158, 125, 'LAW', 'St. Lawrence Parish'),
(2159, 126, 'AER', 'Aerodrom'),
(2160, 126, 'ARA', 'Ara&#269;inovo'),
(2161, 126, 'BER', 'Berovo'),
(2162, 126, 'BIT', 'Bitola'),
(2163, 126, 'BOG', 'Bogdanci'),
(2164, 126, 'BOG', 'Bogovinje'),
(2165, 126, 'BOS', 'Bosilovo'),
(2166, 126, 'BRV', 'Brvenica'),
(2167, 126, 'BUT', 'Butel'),
(2168, 126, '&#268;AI', '&#268;air'),
(2169, 126, '&#268;A&scaron;', '&#268;a&scaron;ka'),
(2170, 126, 'CEN', 'Centar'),
(2171, 126, 'CEN', 'Centar &#381;upa'),
(2172, 126, '&#268;e&scaron;', '&#268;e&scaron;inovo-Oble&scaron'),
(2173, 126, '&#268;U&#268;', '&#268;u&#269;er-Sandevo'),
(2174, 126, 'DEB', 'Debar'),
(2175, 126, 'DEB', 'Debarca'),
(2176, 126, 'DEL', 'Del&#269;evo'),
(2177, 126, 'DEM', 'Demir Hisar'),
(2178, 126, 'DEM', 'Demir Kapija'),
(2179, 126, 'DOL', 'Dolneni'),
(2180, 126, 'DRU', 'Drugovo'),
(2181, 126, 'GAZ', 'Gazi Baba'),
(2182, 126, 'GEV', 'Gevgelija'),
(2183, 126, 'GJO', 'Gjor&#269;e Petrov'),
(2184, 126, 'GOS', 'Gostivar'),
(2185, 126, 'GRA', 'Gradsko'),
(2186, 126, 'ILI', 'Ilinden'),
(2187, 126, 'JEG', 'Jegunovce'),
(2188, 126, 'KAR', 'Karbinci'),
(2189, 126, 'KAR', 'Karpo&scaron;'),
(2190, 126, 'KAV', 'Kavadarci'),
(2191, 126, 'KI&#268;', 'Ki&#269;evo'),
(2192, 126, 'KIS', 'Kisela Voda'),
(2193, 126, 'KO&#269;', 'Ko&#269;ani'),
(2194, 126, 'KON', 'Kon&#269;e'),
(2195, 126, 'KRA', 'Kratovo'),
(2196, 126, 'KRI', 'Kriva Palanka'),
(2197, 126, 'KRI', 'Krivoga&scaron;tani'),
(2198, 126, 'KRU', 'Kru&scaron;evo'),
(2199, 126, 'KUM', 'Kumanovo'),
(2200, 126, 'LIP', 'Lipkovo'),
(2201, 126, 'LOZ', 'Lozovo'),
(2202, 126, 'MAK', 'Makedonska Kamenica'),
(2203, 126, 'MAK', 'Makedonski Brod'),
(2204, 126, 'MAV', 'Mavrovo and Rostu&scaron;a'),
(2205, 126, 'MOG', 'Mogila'),
(2206, 126, 'NEG', 'Negotino'),
(2207, 126, 'NOV', 'Novaci'),
(2208, 126, 'NOV', 'Novo Selo'),
(2209, 126, 'OHR', 'Ohrid'),
(2210, 126, 'OSL', 'Oslomej'),
(2211, 126, 'PEH', 'Peh&#269;evo'),
(2212, 126, 'PET', 'Petrovec'),
(2213, 126, 'PLA', 'Plasnica'),
(2214, 126, 'PRI', 'Prilep'),
(2215, 126, 'PRO', 'Probi&scaron;tip'),
(2216, 126, 'RAD', 'Radovi&scaron;'),
(2217, 126, 'RAN', 'Rankovce'),
(2218, 126, 'RES', 'Resen'),
(2219, 126, 'ROS', 'Rosoman'),
(2220, 126, 'SAR', 'Saraj'),
(2221, 126, 'SOP', 'Sopi&scaron;te'),
(2222, 126, 'STA', 'Star Dojran'),
(2223, 126, 'STA', 'Staro Nagori&#269;ane'),
(2224, 126, '&Scaron;TI', '&Scaron;tip'),
(2225, 126, 'STR', 'Struga'),
(2226, 126, 'STR', 'Strumica'),
(2227, 126, 'STU', 'Studeni&#269;ani'),
(2228, 126, '&Scaron;UT', '&Scaron;uto Orizari'),
(2229, 126, 'SVE', 'Sveti Nikole'),
(2230, 126, 'TEA', 'Tearce'),
(2231, 126, 'TET', 'Tetovo'),
(2232, 126, 'VAL', 'Valandovo'),
(2233, 126, 'VAS', 'Vasilevo'),
(2234, 126, 'VEL', 'Veles'),
(2235, 126, 'VEV', 'Vev&#269;ani'),
(2236, 126, 'VIN', 'Vinica'),
(2237, 126, 'VRA', 'Vrane&scaron;tica'),
(2238, 126, 'VRA', 'Vrap&#269;i&scaron;te'),
(2239, 126, 'ZAJ', 'Zajas'),
(2240, 126, 'ZEL', 'Zelenikovo'),
(2241, 126, '&#381;EL', '&#381;elino'),
(2242, 126, 'ZRN', 'Zrnovci'),
(2243, 127, 'AN', 'Antananarivo'),
(2244, 127, 'AS', 'Antsiranana'),
(2245, 127, 'FN', 'Fianarantsoa'),
(2246, 127, 'MJ', 'Mahajanga'),
(2247, 127, 'TM', 'Toamasina'),
(2248, 127, 'TL', 'Toliara'),
(2249, 128, 'BLK', 'Balaka'),
(2250, 128, 'BLT', 'Blantyre'),
(2251, 128, 'CKW', 'Chikwawa'),
(2252, 128, 'CRD', 'Chiradzulu'),
(2253, 128, 'CTP', 'Chitipa'),
(2254, 128, 'DDZ', 'Dedza'),
(2255, 128, 'DWA', 'Dowa'),
(2256, 128, 'KRG', 'Karonga'),
(2257, 128, 'KSG', 'Kasungu'),
(2258, 128, 'LKM', 'Likoma'),
(2259, 128, 'LLG', 'Lilongwe'),
(2260, 128, 'MCG', 'Machinga'),
(2261, 128, 'MGC', 'Mangochi'),
(2262, 128, 'MCH', 'Mchinji'),
(2263, 128, 'MLJ', 'Mulanje'),
(2264, 128, 'MWZ', 'Mwanza'),
(2265, 128, 'MZM', 'Mzimba'),
(2266, 128, 'NTU', 'Ntcheu'),
(2267, 128, 'NKB', 'Nkhata Bay'),
(2268, 128, 'NKH', 'Nkhotakota'),
(2269, 128, 'NSJ', 'Nsanje'),
(2270, 128, 'NTI', 'Ntchisi'),
(2271, 128, 'PHL', 'Phalombe'),
(2272, 128, 'RMP', 'Rumphi'),
(2273, 128, 'SLM', 'Salima'),
(2274, 128, 'THY', 'Thyolo'),
(2275, 128, 'ZBA', 'Zomba'),
(2276, 129, 'Johor', 'Johor'),
(2277, 129, 'Kedah', 'Kedah'),
(2278, 129, 'Kelantan', 'Kelantan'),
(2279, 129, 'Labuan', 'Labuan'),
(2280, 129, 'Melaka', 'Melaka'),
(2281, 129, 'Negeri Sembilan', 'Negeri Sembilan'),
(2282, 129, 'Pahang', 'Pahang'),
(2283, 129, 'Perak', 'Perak'),
(2284, 129, 'Perlis', 'Perlis'),
(2285, 129, 'Pulau Pinang', 'Pulau Pinang'),
(2286, 129, 'Sabah', 'Sabah'),
(2287, 129, 'Sarawak', 'Sarawak'),
(2288, 129, 'Selangor', 'Selangor'),
(2289, 129, 'Terengganu', 'Terengganu'),
(2290, 129, 'Kuala Lumpur', 'Kuala Lumpur'),
(2291, 130, 'THU', 'Thiladhunmathi Uthuru'),
(2292, 130, 'THD', 'Thiladhunmathi Dhekunu'),
(2293, 130, 'MLU', 'Miladhunmadulu Uthuru'),
(2294, 130, 'MLD', 'Miladhunmadulu Dhekunu'),
(2295, 130, 'MAU', 'Maalhosmadulu Uthuru'),
(2296, 130, 'MAD', 'Maalhosmadulu Dhekunu'),
(2297, 130, 'FAA', 'Faadhippolhu'),
(2298, 130, 'MAA', 'Male Atoll'),
(2299, 130, 'AAU', 'Ari Atoll Uthuru'),
(2300, 130, 'AAD', 'Ari Atoll Dheknu'),
(2301, 130, 'FEA', 'Felidhe Atoll'),
(2302, 130, 'MUA', 'Mulaku Atoll'),
(2303, 130, 'NAU', 'Nilandhe Atoll Uthuru'),
(2304, 130, 'NAD', 'Nilandhe Atoll Dhekunu'),
(2305, 130, 'KLH', 'Kolhumadulu'),
(2306, 130, 'HDH', 'Hadhdhunmathi'),
(2307, 130, 'HAU', 'Huvadhu Atoll Uthuru'),
(2308, 130, 'HAD', 'Huvadhu Atoll Dhekunu'),
(2309, 130, 'FMU', 'Fua Mulaku'),
(2310, 130, 'ADD', 'Addu'),
(2311, 131, 'GA', 'Gao'),
(2312, 131, 'KY', 'Kayes'),
(2313, 131, 'KD', 'Kidal'),
(2314, 131, 'KL', 'Koulikoro'),
(2315, 131, 'MP', 'Mopti'),
(2316, 131, 'SG', 'Segou'),
(2317, 131, 'SK', 'Sikasso'),
(2318, 131, 'TB', 'Tombouctou'),
(2319, 131, 'CD', 'Bamako Capital District'),
(2320, 132, 'ATT', 'Attard'),
(2321, 132, 'BAL', 'Balzan'),
(2322, 132, 'BGU', 'Birgu'),
(2323, 132, 'BKK', 'Birkirkara'),
(2324, 132, 'BRZ', 'Birzebbuga'),
(2325, 132, 'BOR', 'Bormla'),
(2326, 132, 'DIN', 'Dingli'),
(2327, 132, 'FGU', 'Fgura'),
(2328, 132, 'FLO', 'Floriana'),
(2329, 132, 'GDJ', 'Gudja'),
(2330, 132, 'GZR', 'Gzira'),
(2331, 132, 'GRG', 'Gargur'),
(2332, 132, 'GXQ', 'Gaxaq'),
(2333, 132, 'HMR', 'Hamrun'),
(2334, 132, 'IKL', 'Iklin'),
(2335, 132, 'ISL', 'Isla'),
(2336, 132, 'KLK', 'Kalkara'),
(2337, 132, 'KRK', 'Kirkop'),
(2338, 132, 'LIJ', 'Lija'),
(2339, 132, 'LUQ', 'Luqa'),
(2340, 132, 'MRS', 'Marsa'),
(2341, 132, 'MKL', 'Marsaskala'),
(2342, 132, 'MXL', 'Marsaxlokk'),
(2343, 132, 'MDN', 'Mdina'),
(2344, 132, 'MEL', 'Melliea'),
(2345, 132, 'MGR', 'Mgarr'),
(2346, 132, 'MST', 'Mosta'),
(2347, 132, 'MQA', 'Mqabba'),
(2348, 132, 'MSI', 'Msida'),
(2349, 132, 'MTF', 'Mtarfa'),
(2350, 132, 'NAX', 'Naxxar'),
(2351, 132, 'PAO', 'Paola'),
(2352, 132, 'PEM', 'Pembroke'),
(2353, 132, 'PIE', 'Pieta'),
(2354, 132, 'QOR', 'Qormi'),
(2355, 132, 'QRE', 'Qrendi'),
(2356, 132, 'RAB', 'Rabat'),
(2357, 132, 'SAF', 'Safi'),
(2358, 132, 'SGI', 'San Giljan'),
(2359, 132, 'SLU', 'Santa Lucija'),
(2360, 132, 'SPB', 'San Pawl il-Bahar'),
(2361, 132, 'SGW', 'San Gwann'),
(2362, 132, 'SVE', 'Santa Venera'),
(2363, 132, 'SIG', 'Siggiewi'),
(2364, 132, 'SLM', 'Sliema'),
(2365, 132, 'SWQ', 'Swieqi'),
(2366, 132, 'TXB', 'Ta Xbiex'),
(2367, 132, 'TRX', 'Tarxien'),
(2368, 132, 'VLT', 'Valletta'),
(2369, 132, 'XGJ', 'Xgajra'),
(2370, 132, 'ZBR', 'Zabbar'),
(2371, 132, 'ZBG', 'Zebbug'),
(2372, 132, 'ZJT', 'Zejtun'),
(2373, 132, 'ZRQ', 'Zurrieq'),
(2374, 132, 'FNT', 'Fontana'),
(2375, 132, 'GHJ', 'Ghajnsielem'),
(2376, 132, 'GHR', 'Gharb'),
(2377, 132, 'GHS', 'Ghasri'),
(2378, 132, 'KRC', 'Kercem'),
(2379, 132, 'MUN', 'Munxar'),
(2380, 132, 'NAD', 'Nadur'),
(2381, 132, 'QAL', 'Qala'),
(2382, 132, 'VIC', 'Victoria'),
(2383, 132, 'SLA', 'San Lawrenz'),
(2384, 132, 'SNT', 'Sannat'),
(2385, 132, 'ZAG', 'Xagra'),
(2386, 132, 'XEW', 'Xewkija'),
(2387, 132, 'ZEB', 'Zebbug'),
(2388, 133, 'ALG', 'Ailinginae'),
(2389, 133, 'ALL', 'Ailinglaplap'),
(2390, 133, 'ALK', 'Ailuk'),
(2391, 133, 'ARN', 'Arno'),
(2392, 133, 'AUR', 'Aur'),
(2393, 133, 'BKR', 'Bikar'),
(2394, 133, 'BKN', 'Bikini'),
(2395, 133, 'BKK', 'Bokak'),
(2396, 133, 'EBN', 'Ebon'),
(2397, 133, 'ENT', 'Enewetak'),
(2398, 133, 'EKB', 'Erikub'),
(2399, 133, 'JBT', 'Jabat'),
(2400, 133, 'JLT', 'Jaluit'),
(2401, 133, 'JEM', 'Jemo'),
(2402, 133, 'KIL', 'Kili'),
(2403, 133, 'KWJ', 'Kwajalein'),
(2404, 133, 'LAE', 'Lae'),
(2405, 133, 'LIB', 'Lib'),
(2406, 133, 'LKP', 'Likiep'),
(2407, 133, 'MJR', 'Majuro'),
(2408, 133, 'MLP', 'Maloelap'),
(2409, 133, 'MJT', 'Mejit'),
(2410, 133, 'MIL', 'Mili'),
(2411, 133, 'NMK', 'Namorik'),
(2412, 133, 'NAM', 'Namu'),
(2413, 133, 'RGL', 'Rongelap'),
(2414, 133, 'RGK', 'Rongrik'),
(2415, 133, 'TOK', 'Toke'),
(2416, 133, 'UJA', 'Ujae'),
(2417, 133, 'UJL', 'Ujelang'),
(2418, 133, 'UTK', 'Utirik'),
(2419, 133, 'WTH', 'Wotho'),
(2420, 133, 'WTJ', 'Wotje'),
(2421, 134, 'LAJ', 'L''Ajoupa-Bouillon'),
(2422, 134, 'LES', 'Les Anses-d''Arlet'),
(2423, 134, 'BAS', 'Basse-Pointe'),
(2424, 134, 'BEL', 'Bellefontaine'),
(2425, 134, 'LE', 'Le Carbet'),
(2426, 134, 'CAS', 'Case-Pilote'),
(2427, 134, 'LE', 'Le Diamant'),
(2428, 134, 'DUC', 'Ducos'),
(2429, 134, 'FON', 'Fonds-Saint-Denis'),
(2430, 134, 'FOR', 'Fort-De-France'),
(2431, 134, 'LE', 'Le Fran&ccedil;ois'),
(2432, 134, 'GRA', 'Grand''Rivi&egrave;re'),
(2433, 134, 'GRO', 'Gros-Morne'),
(2434, 134, 'LE', 'Le Lamentin'),
(2435, 134, 'LE', 'Le Lorrain'),
(2436, 134, 'MAC', 'Macouba'),
(2437, 134, 'LE', 'Le Marigot'),
(2438, 134, 'LE', 'Le Marin'),
(2439, 134, 'LE', 'Le Morne-Rouge'),
(2440, 134, 'LE', 'Le Morne-Vert'),
(2441, 134, 'LE', 'Le Pr&ecirc;cheur'),
(2442, 134, 'RIV', 'Rivi&egrave;re-Pilote'),
(2443, 134, 'RIV', 'Rivi&egrave;re-Sal&eacute;e'),
(2444, 134, 'LE', 'Le Robert'),
(2445, 134, 'SAI', 'Sainte-Anne'),
(2446, 134, 'SAI', 'Sainte-Luce'),
(2447, 134, 'SAI', 'Sainte-Marie'),
(2448, 134, 'SAI', 'Saint-Esprit'),
(2449, 134, 'SAI', 'Saint-Joseph'),
(2450, 134, 'SAI', 'Saint-Pierre'),
(2451, 134, 'SCH', 'Sch&oelig;lcher'),
(2452, 134, 'LA', 'La Trinit&eacute;'),
(2453, 134, 'LES', 'Les Trois-&Icirc;lets'),
(2454, 134, 'LE', 'Le Vauclin'),
(2455, 135, 'AD', 'Adrar'),
(2456, 135, 'AS', 'Assaba'),
(2457, 135, 'BR', 'Brakna'),
(2458, 135, 'DN', 'Dakhlet Nouadhibou'),
(2459, 135, 'GO', 'Gorgol'),
(2460, 135, 'GM', 'Guidimaka'),
(2461, 135, 'HC', 'Hodh Ech Chargui'),
(2462, 135, 'HG', 'Hodh El Gharbi'),
(2463, 135, 'IN', 'Inchiri'),
(2464, 135, 'TA', 'Tagant'),
(2465, 135, 'TZ', 'Tiris Zemmour'),
(2466, 135, 'TR', 'Trarza'),
(2467, 135, 'NO', 'Nouakchott'),
(2468, 136, 'BR', 'Beau Bassin-Rose Hill'),
(2469, 136, 'CU', 'Curepipe'),
(2470, 136, 'PU', 'Port Louis'),
(2471, 136, 'QB', 'Quatre Bornes'),
(2472, 136, 'VP', 'Vacoas-Phoenix'),
(2473, 136, 'AG', 'Agalega Islands'),
(2474, 136, 'CC', 'Cargados Carajos Shoals (Saint B'),
(2475, 136, 'RO', 'Rodrigues'),
(2476, 136, 'BL', 'Black River'),
(2477, 136, 'FL', 'Flacq'),
(2478, 136, 'GP', 'Grand Port'),
(2479, 136, 'MO', 'Moka'),
(2480, 136, 'PA', 'Pamplemousses'),
(2481, 136, 'PW', 'Plaines Wilhems'),
(2482, 136, 'PL', 'Port Louis'),
(2483, 136, 'RR', 'Riviere du Rempart'),
(2484, 136, 'SA', 'Savanne'),
(2485, 137, 'DZA', 'Dzaoudzi'),
(2486, 137, 'PAM', 'Pamandzi'),
(2487, 137, 'MAM', 'Mamoudzou'),
(2488, 137, 'DEM', 'Dembeni'),
(2489, 137, 'BAN', 'Bandrele'),
(2490, 137, 'KAN', 'Kani-K&eacute;li'),
(2491, 137, 'BOU', 'Bou&eacute;ni'),
(2492, 137, 'CHI', 'Chirongui'),
(2493, 137, 'SAD', 'Sada'),
(2494, 137, 'OUA', 'Ouangani'),
(2495, 137, 'CHI', 'Chiconi'),
(2496, 137, 'TSI', 'Tsingoni'),
(2497, 137, 'MTS', 'M''Tsangamouji'),
(2498, 137, 'ACO', 'Acoua'),
(2499, 137, 'MTS', 'Mtsamboro'),
(2500, 137, 'BAN', 'Bandraboua'),
(2501, 137, 'KOU', 'Koungou'),
(2502, 138, 'AGU', 'Aguascalientes'),
(2503, 138, 'BCN', 'Baja California Norte'),
(2504, 138, 'BCS', 'Baja California Sur'),
(2505, 138, 'CAM', 'Campeche'),
(2506, 138, 'CHP', 'Chiapas'),
(2507, 138, 'CHH', 'Chihuahua'),
(2508, 138, 'COA', 'Coahuila de Zaragoza'),
(2509, 138, 'COL', 'Colima'),
(2510, 138, 'DIF', 'Distrito Federal'),
(2511, 138, 'DUR', 'Durango'),
(2512, 138, 'GUA', 'Guanajuato'),
(2513, 138, 'GRO', 'Guerrero'),
(2514, 138, 'HID', 'Hidalgo'),
(2515, 138, 'JAL', 'Jalisco'),
(2516, 138, 'MEX', 'Mexico'),
(2517, 138, 'MIC', 'Michoacan de Ocampo'),
(2518, 138, 'MOR', 'Morelos'),
(2519, 138, 'NAY', 'Nayarit'),
(2520, 138, 'NLE', 'Nuevo Leon'),
(2521, 138, 'OAX', 'Oaxaca'),
(2522, 138, 'PUE', 'Puebla'),
(2523, 138, 'QUE', 'Queretaro de Arteaga'),
(2524, 138, 'ROO', 'Quintana Roo'),
(2525, 138, 'SLP', 'San Luis Potosi'),
(2526, 138, 'SIN', 'Sinaloa'),
(2527, 138, 'SON', 'Sonora'),
(2528, 138, 'TAB', 'Tabasco'),
(2529, 138, 'TAM', 'Tamaulipas'),
(2530, 138, 'TLA', 'Tlaxcala'),
(2531, 138, 'VER', 'Veracruz-Llave'),
(2532, 138, 'YUC', 'Yucatan'),
(2533, 138, 'ZAC', 'Zacatecas'),
(2534, 139, 'C', 'Chuuk'),
(2535, 139, 'K', 'Kosrae'),
(2536, 139, 'P', 'Pohnpei'),
(2537, 139, 'Y', 'Yap'),
(2538, 140, 'GA', 'Gagauzia'),
(2539, 140, 'CU', 'Chisinau'),
(2540, 140, 'BA', 'Balti'),
(2541, 140, 'CA', 'Cahul'),
(2542, 140, 'ED', 'Edinet'),
(2543, 140, 'LA', 'Lapusna'),
(2544, 140, 'OR', 'Orhei'),
(2545, 140, 'SO', 'Soroca'),
(2546, 140, 'TI', 'Tighina'),
(2547, 140, 'UN', 'Ungheni'),
(2548, 140, 'SN', 'StÃ¢nga Nistrului'),
(2549, 141, 'FV', 'Fontvieille'),
(2550, 141, 'LC', 'La Condamine'),
(2551, 141, 'MV', 'Monaco-Ville'),
(2552, 141, 'MC', 'Monte-Carlo'),
(2553, 142, '1', 'Ulanbaatar'),
(2554, 142, '035', 'Orhon'),
(2555, 142, '037', 'Darhan uul'),
(2556, 142, '039', 'Hentiy'),
(2557, 142, '041', 'Hovsgol'),
(2558, 142, '043', 'Hovd'),
(2559, 142, '046', 'Uvs'),
(2560, 142, '047', 'Tov'),
(2561, 142, '049', 'Selenge'),
(2562, 142, '051', 'Suhbaatar'),
(2563, 142, '053', 'Omnogovi'),
(2564, 142, '055', 'Ovorhangay'),
(2565, 142, '057', 'Dzavhan'),
(2566, 142, '059', 'DundgovL'),
(2567, 142, '061', 'Dornod'),
(2568, 142, '063', 'Dornogov'),
(2569, 142, '064', 'Govi-Sumber'),
(2570, 142, '065', 'Govi-Altay'),
(2571, 142, '067', 'Bulgan'),
(2572, 142, '069', 'Bayanhongor'),
(2573, 142, '071', 'Bayan-Olgiy'),
(2574, 142, '073', 'Arhangay'),
(2575, 143, 'A', 'Saint Anthony'),
(2576, 143, 'G', 'Saint Georges'),
(2577, 143, 'P', 'Saint Peter'),
(2578, 144, 'AGD', 'Agadir'),
(2579, 144, 'HOC', 'Al Hoceima'),
(2580, 144, 'AZI', 'Azilal'),
(2581, 144, 'BME', 'Beni Mellal'),
(2582, 144, 'BSL', 'Ben Slimane'),
(2583, 144, 'BLM', 'Boulemane'),
(2584, 144, 'CBL', 'Casablanca'),
(2585, 144, 'CHA', 'Chaouen'),
(2586, 144, 'EJA', 'El Jadida'),
(2587, 144, 'EKS', 'El Kelaa des Sraghna'),
(2588, 144, 'ERA', 'Er Rachidia'),
(2589, 144, 'ESS', 'Essaouira'),
(2590, 144, 'FES', 'Fes'),
(2591, 144, 'FIG', 'Figuig'),
(2592, 144, 'GLM', 'Guelmim'),
(2593, 144, 'IFR', 'Ifrane'),
(2594, 144, 'KEN', 'Kenitra'),
(2595, 144, 'KHM', 'Khemisset'),
(2596, 144, 'KHN', 'Khenifra'),
(2597, 144, 'KHO', 'Khouribga'),
(2598, 144, 'LYN', 'Laayoune'),
(2599, 144, 'LAR', 'Larache'),
(2600, 144, 'MRK', 'Marrakech'),
(2601, 144, 'MKN', 'Meknes'),
(2602, 144, 'NAD', 'Nador'),
(2603, 144, 'ORZ', 'Ouarzazate'),
(2604, 144, 'OUJ', 'Oujda'),
(2605, 144, 'RSA', 'Rabat-Sale'),
(2606, 144, 'SAF', 'Safi'),
(2607, 144, 'SET', 'Settat'),
(2608, 144, 'SKA', 'Sidi Kacem'),
(2609, 144, 'TGR', 'Tangier'),
(2610, 144, 'TAN', 'Tan-Tan'),
(2611, 144, 'TAO', 'Taounate'),
(2612, 144, 'TRD', 'Taroudannt'),
(2613, 144, 'TAT', 'Tata'),
(2614, 144, 'TAZ', 'Taza'),
(2615, 144, 'TET', 'Tetouan'),
(2616, 144, 'TIZ', 'Tiznit'),
(2617, 144, 'ADK', 'Ad Dakhla'),
(2618, 144, 'BJD', 'Boujdour'),
(2619, 144, 'ESM', 'Es Smara'),
(2620, 145, 'CD', 'Cabo Delgado'),
(2621, 145, 'GZ', 'Gaza'),
(2622, 145, 'IN', 'Inhambane'),
(2623, 145, 'MN', 'Manica'),
(2624, 145, 'MC', 'Maputo (city)'),
(2625, 145, 'MP', 'Maputo'),
(2626, 145, 'NA', 'Nampula'),
(2627, 145, 'NI', 'Niassa'),
(2628, 145, 'SO', 'Sofala'),
(2629, 145, 'TE', 'Tete'),
(2630, 145, 'ZA', 'Zambezia'),
(2631, 146, 'AY', 'Ayeyarwady'),
(2632, 146, 'BG', 'Bago'),
(2633, 146, 'MG', 'Magway'),
(2634, 146, 'MD', 'Mandalay'),
(2635, 146, 'SG', 'Sagaing'),
(2636, 146, 'TN', 'Tanintharyi'),
(2637, 146, 'YG', 'Yangon'),
(2638, 146, 'CH', 'Chin State'),
(2639, 146, 'KC', 'Kachin State'),
(2640, 146, 'KH', 'Kayah State'),
(2641, 146, 'KN', 'Kayin State'),
(2642, 146, 'MN', 'Mon State'),
(2643, 146, 'RK', 'Rakhine State'),
(2644, 146, 'SH', 'Shan State'),
(2645, 147, 'CA', 'Caprivi'),
(2646, 147, 'ER', 'Erongo'),
(2647, 147, 'HA', 'Hardap'),
(2648, 147, 'KR', 'Karas'),
(2649, 147, 'KV', 'Kavango'),
(2650, 147, 'KH', 'Khomas'),
(2651, 147, 'KU', 'Kunene'),
(2652, 147, 'OW', 'Ohangwena'),
(2653, 147, 'OK', 'Omaheke'),
(2654, 147, 'OT', 'Omusati'),
(2655, 147, 'ON', 'Oshana'),
(2656, 147, 'OO', 'Oshikoto'),
(2657, 147, 'OJ', 'Otjozondjupa'),
(2658, 148, 'AO', 'Aiwo'),
(2659, 148, 'AA', 'Anabar'),
(2660, 148, 'AT', 'Anetan'),
(2661, 148, 'AI', 'Anibare'),
(2662, 148, 'BA', 'Baiti'),
(2663, 148, 'BO', 'Boe'),
(2664, 148, 'BU', 'Buada'),
(2665, 148, 'DE', 'Denigomodu'),
(2666, 148, 'EW', 'Ewa'),
(2667, 148, 'IJ', 'Ijuw'),
(2668, 148, 'ME', 'Meneng'),
(2669, 148, 'NI', 'Nibok'),
(2670, 148, 'UA', 'Uaboe'),
(2671, 148, 'YA', 'Yaren'),
(2672, 149, 'BA', 'Bagmati'),
(2673, 149, 'BH', 'Bheri'),
(2674, 149, 'DH', 'Dhawalagiri'),
(2675, 149, 'GA', 'Gandaki'),
(2676, 149, 'JA', 'Janakpur'),
(2677, 149, 'KA', 'Karnali'),
(2678, 149, 'KO', 'Kosi'),
(2679, 149, 'LU', 'Lumbini'),
(2680, 149, 'MA', 'Mahakali'),
(2681, 149, 'ME', 'Mechi'),
(2682, 149, 'NA', 'Narayani'),
(2683, 149, 'RA', 'Rapti'),
(2684, 149, 'SA', 'Sagarmatha'),
(2685, 149, 'SE', 'Seti'),
(2686, 150, 'DR', 'Drenthe'),
(2687, 150, 'FL', 'Flevoland'),
(2688, 150, 'FR', 'Friesland'),
(2689, 150, 'GE', 'Gelderland'),
(2690, 150, 'GR', 'Groningen'),
(2691, 150, 'LI', 'Limburg'),
(2692, 150, 'NB', 'Noord Brabant'),
(2693, 150, 'NH', 'Noord Holland'),
(2694, 150, 'OV', 'Overijssel'),
(2695, 150, 'UT', 'Utrecht'),
(2696, 150, 'ZE', 'Zeeland'),
(2697, 150, 'ZH', 'Zuid Holland'),
(2698, 151, 'BON', 'Bonaire'),
(2699, 151, 'CUR', 'Cura&ccedil;ao'),
(2700, 151, 'SAB', 'Saba'),
(2701, 151, 'SEU', 'Sint Eustatius'),
(2702, 151, 'SMA', 'Sint Maarten'),
(2703, 152, 'L', 'Iles Loyaute'),
(2704, 152, 'N', 'Nord'),
(2705, 152, 'S', 'Sud'),
(2706, 153, 'AUK', 'Auckland'),
(2707, 153, 'BOP', 'Bay of Plenty'),
(2708, 153, 'CAN', 'Canterbury'),
(2709, 153, 'COR', 'Coromandel'),
(2710, 153, 'GIS', 'Gisborne'),
(2711, 153, 'FIO', 'Fiordland'),
(2712, 153, 'HKB', 'Hawke''s Bay'),
(2713, 153, 'MBH', 'Marlborough'),
(2714, 153, 'MWT', 'Manawatu-Wanganui'),
(2715, 153, 'MCM', 'Mt Cook-Mackenzie'),
(2716, 153, 'NSN', 'Nelson'),
(2717, 153, 'NTL', 'Northland'),
(2718, 153, 'OTA', 'Otago'),
(2719, 153, 'STL', 'Southland'),
(2720, 153, 'TKI', 'Taranaki'),
(2721, 153, 'WGN', 'Wellington'),
(2722, 153, 'WKO', 'Waikato'),
(2723, 153, 'WAI', 'Wairprarapa'),
(2724, 153, 'WTC', 'West Coast'),
(2725, 154, 'AN', 'Atlantico Norte'),
(2726, 154, 'AS', 'Atlantico Sur'),
(2727, 154, 'BO', 'Boaco'),
(2728, 154, 'CA', 'Carazo'),
(2729, 154, 'CI', 'Chinandega'),
(2730, 154, 'CO', 'Chontales'),
(2731, 154, 'ES', 'Esteli'),
(2732, 154, 'GR', 'Granada'),
(2733, 154, 'JI', 'Jinotega'),
(2734, 154, 'LE', 'Leon'),
(2735, 154, 'MD', 'Madriz'),
(2736, 154, 'MN', 'Managua'),
(2737, 154, 'MS', 'Masaya'),
(2738, 154, 'MT', 'Matagalpa'),
(2739, 154, 'NS', 'Nuevo Segovia'),
(2740, 154, 'RS', 'Rio San Juan'),
(2741, 154, 'RI', 'Rivas'),
(2742, 155, 'AG', 'Agadez'),
(2743, 155, 'DF', 'Diffa'),
(2744, 155, 'DS', 'Dosso'),
(2745, 155, 'MA', 'Maradi'),
(2746, 155, 'NM', 'Niamey'),
(2747, 155, 'TH', 'Tahoua'),
(2748, 155, 'TL', 'Tillaberi'),
(2749, 155, 'ZD', 'Zinder'),
(2750, 156, 'AB', 'Abia'),
(2751, 156, 'CT', 'Abuja Federal Capital Territory'),
(2752, 156, 'AD', 'Adamawa'),
(2753, 156, 'AK', 'Akwa Ibom'),
(2754, 156, 'AN', 'Anambra'),
(2755, 156, 'BC', 'Bauchi'),
(2756, 156, 'BY', 'Bayelsa'),
(2757, 156, 'BN', 'Benue'),
(2758, 156, 'BO', 'Borno'),
(2759, 156, 'CR', 'Cross River'),
(2760, 156, 'DE', 'Delta'),
(2761, 156, 'EB', 'Ebonyi'),
(2762, 156, 'ED', 'Edo'),
(2763, 156, 'EK', 'Ekiti'),
(2764, 156, 'EN', 'Enugu'),
(2765, 156, 'GO', 'Gombe'),
(2766, 156, 'IM', 'Imo'),
(2767, 156, 'JI', 'Jigawa'),
(2768, 156, 'KD', 'Kaduna'),
(2769, 156, 'KN', 'Kano'),
(2770, 156, 'KT', 'Katsina'),
(2771, 156, 'KE', 'Kebbi'),
(2772, 156, 'KO', 'Kogi'),
(2773, 156, 'KW', 'Kwara'),
(2774, 156, 'LA', 'Lagos'),
(2775, 156, 'NA', 'Nassarawa'),
(2776, 156, 'NI', 'Niger'),
(2777, 156, 'OG', 'Ogun'),
(2778, 156, 'ONG', 'Ondo'),
(2779, 156, 'OS', 'Osun'),
(2780, 156, 'OY', 'Oyo'),
(2781, 156, 'PL', 'Plateau'),
(2782, 156, 'RI', 'Rivers'),
(2783, 156, 'SO', 'Sokoto'),
(2784, 156, 'TA', 'Taraba'),
(2785, 156, 'YO', 'Yobe'),
(2786, 156, 'ZA', 'Zamfara'),
(2787, 157, 'MAK', 'Makefu'),
(2788, 157, 'TUA', 'Tuapa'),
(2789, 157, 'NAM', 'Namukulu'),
(2790, 157, 'HIK', 'Hikutavake'),
(2791, 157, 'TOI', 'Toi'),
(2792, 157, 'MUT', 'Mutalau'),
(2793, 157, 'LAK', 'Lakepa'),
(2794, 157, 'LIK', 'Liku'),
(2795, 157, 'HAK', 'Hakupu'),
(2796, 157, 'VAI', 'Vaiea'),
(2797, 157, 'AVA', 'Avatele'),
(2798, 157, 'TAM', 'Tamakautoga'),
(2799, 157, 'ALO', 'Alofi South'),
(2800, 157, 'ALO', 'Alofi North'),
(2801, 158, 'NOR', 'Norfolk Island'),
(2802, 159, 'N', 'Northern Islands'),
(2803, 159, 'R', 'Rota'),
(2804, 159, 'S', 'Saipan'),
(2805, 159, 'T', 'Tinian'),
(2806, 160, 'AK', 'Akershus'),
(2807, 160, 'AA', 'Aust-Agder'),
(2808, 160, 'BU', 'Buskerud'),
(2809, 160, 'FM', 'Finnmark'),
(2810, 160, 'HM', 'Hedmark'),
(2811, 160, 'HL', 'Hordaland'),
(2812, 160, 'MR', 'M&oslash;re og Romsdal'),
(2813, 160, 'NL', 'Nordland'),
(2814, 160, 'NT', 'Nord-Tr&oslash;ndelag'),
(2815, 160, 'OP', 'Oppland'),
(2816, 160, 'OL', 'Oslo'),
(2817, 160, 'RL', 'Rogaland'),
(2818, 160, 'SJ', 'Sogn og Fjordane'),
(2819, 160, 'ST', 'S&oslash;r-Tr&oslash;ndelag'),
(2820, 160, 'SV', 'Svalbard'),
(2821, 160, 'TM', 'Telemark'),
(2822, 160, 'TR', 'Troms'),
(2823, 160, 'VA', 'Vest-Agder'),
(2824, 160, 'VF', 'Vestfold'),
(2825, 160, 'OF', '&Oslash;stfold'),
(2826, 161, 'DA', 'Ad Dakhiliyah'),
(2827, 161, 'BA', 'Al Batinah'),
(2828, 161, 'WU', 'Al Wusta'),
(2829, 161, 'SH', 'Ash Sharqiyah'),
(2830, 161, 'ZA', 'Az Zahirah'),
(2831, 161, 'MA', 'Masqat'),
(2832, 161, 'MU', 'Musandam'),
(2833, 161, 'ZU', 'Zufar'),
(2834, 162, 'B', 'Balochistan'),
(2835, 162, 'T', 'Federally Administered Tribal Ar'),
(2836, 162, 'I', 'Islamabad Capital Territory'),
(2837, 162, 'N', 'North-West Frontier'),
(2838, 162, 'P', 'Punjab'),
(2839, 162, 'S', 'Sindh'),
(2840, 163, 'AM', 'Aimeliik'),
(2841, 163, 'AR', 'Airai'),
(2842, 163, 'AN', 'Angaur'),
(2843, 163, 'HA', 'Hatohobei'),
(2844, 163, 'KA', 'Kayangel'),
(2845, 163, 'KO', 'Koror'),
(2846, 163, 'ME', 'Melekeok'),
(2847, 163, 'NA', 'Ngaraard'),
(2848, 163, 'NG', 'Ngarchelong'),
(2849, 163, 'ND', 'Ngardmau'),
(2850, 163, 'NT', 'Ngatpang'),
(2851, 163, 'NC', 'Ngchesar'),
(2852, 163, 'NR', 'Ngeremlengui'),
(2853, 163, 'NW', 'Ngiwal'),
(2854, 163, 'PE', 'Peleliu'),
(2855, 163, 'SO', 'Sonsorol'),
(2856, 164, 'BT', 'Bocas del Toro'),
(2857, 164, 'CH', 'Chiriqui'),
(2858, 164, 'CC', 'Cocle'),
(2859, 164, 'CL', 'Colon'),
(2860, 164, 'DA', 'Darien'),
(2861, 164, 'HE', 'Herrera'),
(2862, 164, 'LS', 'Los Santos'),
(2863, 164, 'PA', 'Panama'),
(2864, 164, 'SB', 'San Blas'),
(2865, 164, 'VG', 'Veraguas'),
(2866, 165, 'BV', 'Bougainville'),
(2867, 165, 'CE', 'Central'),
(2868, 165, 'CH', 'Chimbu'),
(2869, 165, 'EH', 'Eastern Highlands'),
(2870, 165, 'EB', 'East New Britain'),
(2871, 165, 'ES', 'East Sepik'),
(2872, 165, 'EN', 'Enga'),
(2873, 165, 'GU', 'Gulf'),
(2874, 165, 'MD', 'Madang'),
(2875, 165, 'MN', 'Manus'),
(2876, 165, 'MB', 'Milne Bay'),
(2877, 165, 'MR', 'Morobe'),
(2878, 165, 'NC', 'National Capital'),
(2879, 165, 'NI', 'New Ireland'),
(2880, 165, 'NO', 'Northern'),
(2881, 165, 'SA', 'Sandaun'),
(2882, 165, 'SH', 'Southern Highlands'),
(2883, 165, 'WE', 'Western'),
(2884, 165, 'WH', 'Western Highlands'),
(2885, 165, 'WB', 'West New Britain'),
(2886, 166, 'AG', 'Alto Paraguay'),
(2887, 166, 'AN', 'Alto Parana'),
(2888, 166, 'AM', 'Amambay'),
(2889, 166, 'AS', 'Asuncion'),
(2890, 166, 'BO', 'Boqueron'),
(2891, 166, 'CG', 'Caaguazu'),
(2892, 166, 'CZ', 'Caazapa'),
(2893, 166, 'CN', 'Canindeyu'),
(2894, 166, 'CE', 'Central'),
(2895, 166, 'CC', 'Concepcion'),
(2896, 166, 'CD', 'Cordillera'),
(2897, 166, 'GU', 'Guaira'),
(2898, 166, 'IT', 'Itapua'),
(2899, 166, 'MI', 'Misiones'),
(2900, 166, 'NE', 'Neembucu'),
(2901, 166, 'PA', 'Paraguari'),
(2902, 166, 'PH', 'Presidente Hayes'),
(2903, 166, 'SP', 'San Pedro'),
(2904, 167, 'AM', 'Amazonas'),
(2905, 167, 'AN', 'Ancash'),
(2906, 167, 'AP', 'Apurimac'),
(2907, 167, 'AR', 'Arequipa'),
(2908, 167, 'AY', 'Ayacucho'),
(2909, 167, 'CJ', 'Cajamarca'),
(2910, 167, 'CL', 'Callao'),
(2911, 167, 'CU', 'Cusco'),
(2912, 167, 'HV', 'Huancavelica'),
(2913, 167, 'HO', 'Huanuco'),
(2914, 167, 'IC', 'Ica'),
(2915, 167, 'JU', 'Junin'),
(2916, 167, 'LD', 'La Libertad'),
(2917, 167, 'LY', 'Lambayeque'),
(2918, 167, 'LI', 'Lima'),
(2919, 167, 'LO', 'Loreto'),
(2920, 167, 'MD', 'Madre de Dios'),
(2921, 167, 'MO', 'Moquegua'),
(2922, 167, 'PA', 'Pasco'),
(2923, 167, 'PI', 'Piura'),
(2924, 167, 'PU', 'Puno'),
(2925, 167, 'SM', 'San Martin'),
(2926, 167, 'TA', 'Tacna'),
(2927, 167, 'TU', 'Tumbes'),
(2928, 167, 'UC', 'Ucayali'),
(2929, 168, 'ABR', 'Abra'),
(2930, 168, 'ANO', 'Agusan del Norte'),
(2931, 168, 'ASU', 'Agusan del Sur'),
(2932, 168, 'AKL', 'Aklan'),
(2933, 168, 'ALB', 'Albay'),
(2934, 168, 'ANT', 'Antique'),
(2935, 168, 'APY', 'Apayao'),
(2936, 168, 'AUR', 'Aurora'),
(2937, 168, 'BAS', 'Basilan'),
(2938, 168, 'BTA', 'Bataan'),
(2939, 168, 'BTE', 'Batanes'),
(2940, 168, 'BTG', 'Batangas'),
(2941, 168, 'BLR', 'Biliran'),
(2942, 168, 'BEN', 'Benguet'),
(2943, 168, 'BOL', 'Bohol'),
(2944, 168, 'BUK', 'Bukidnon'),
(2945, 168, 'BUL', 'Bulacan'),
(2946, 168, 'CAG', 'Cagayan'),
(2947, 168, 'CNO', 'Camarines Norte'),
(2948, 168, 'CSU', 'Camarines Sur'),
(2949, 168, 'CAM', 'Camiguin'),
(2950, 168, 'CAP', 'Capiz'),
(2951, 168, 'CAT', 'Catanduanes'),
(2952, 168, 'CAV', 'Cavite'),
(2953, 168, 'CEB', 'Cebu'),
(2954, 168, 'CMP', 'Compostela'),
(2955, 168, 'DNO', 'Davao del Norte'),
(2956, 168, 'DSU', 'Davao del Sur'),
(2957, 168, 'DOR', 'Davao Oriental'),
(2958, 168, 'ESA', 'Eastern Samar'),
(2959, 168, 'GUI', 'Guimaras'),
(2960, 168, 'IFU', 'Ifugao'),
(2961, 168, 'INO', 'Ilocos Norte'),
(2962, 168, 'ISU', 'Ilocos Sur'),
(2963, 168, 'ILO', 'Iloilo'),
(2964, 168, 'ISA', 'Isabela'),
(2965, 168, 'KAL', 'Kalinga'),
(2966, 168, 'LAG', 'Laguna'),
(2967, 168, 'LNO', 'Lanao del Norte'),
(2968, 168, 'LSU', 'Lanao del Sur'),
(2969, 168, 'UNI', 'La Union'),
(2970, 168, 'LEY', 'Leyte'),
(2971, 168, 'MAG', 'Maguindanao'),
(2972, 168, 'MRN', 'Marinduque'),
(2973, 168, 'MSB', 'Masbate'),
(2974, 168, 'MIC', 'Mindoro Occidental'),
(2975, 168, 'MIR', 'Mindoro Oriental'),
(2976, 168, 'MSC', 'Misamis Occidental'),
(2977, 168, 'MOR', 'Misamis Oriental'),
(2978, 168, 'MOP', 'Mountain'),
(2979, 168, 'NOC', 'Negros Occidental'),
(2980, 168, 'NOR', 'Negros Oriental'),
(2981, 168, 'NCT', 'North Cotabato'),
(2982, 168, 'NSM', 'Northern Samar'),
(2983, 168, 'NEC', 'Nueva Ecija'),
(2984, 168, 'NVZ', 'Nueva Vizcaya'),
(2985, 168, 'PLW', 'Palawan'),
(2986, 168, 'PMP', 'Pampanga'),
(2987, 168, 'PNG', 'Pangasinan'),
(2988, 168, 'QZN', 'Quezon'),
(2989, 168, 'QRN', 'Quirino'),
(2990, 168, 'RIZ', 'Rizal'),
(2991, 168, 'ROM', 'Romblon'),
(2992, 168, 'SMR', 'Samar'),
(2993, 168, 'SRG', 'Sarangani'),
(2994, 168, 'SQJ', 'Siquijor'),
(2995, 168, 'SRS', 'Sorsogon'),
(2996, 168, 'SCO', 'South Cotabato'),
(2997, 168, 'SLE', 'Southern Leyte'),
(2998, 168, 'SKU', 'Sultan Kudarat'),
(2999, 168, 'SLU', 'Sulu'),
(3000, 168, 'SNO', 'Surigao del Norte'),
(3001, 168, 'SSU', 'Surigao del Sur'),
(3002, 168, 'TAR', 'Tarlac'),
(3003, 168, 'TAW', 'Tawi-Tawi'),
(3004, 168, 'ZBL', 'Zambales'),
(3005, 168, 'ZNO', 'Zamboanga del Norte'),
(3006, 168, 'ZSU', 'Zamboanga del Sur'),
(3007, 168, 'ZSI', 'Zamboanga Sibugay'),
(3008, 169, 'PIT', 'Pitcairn Island'),
(3009, 170, 'DO', 'Dolnoslaskie'),
(3010, 170, 'KP', 'Kujawsko-Pomorskie'),
(3011, 170, 'LO', 'Lodzkie'),
(3012, 170, 'LL', 'Lubelskie'),
(3013, 170, 'LU', 'Lubuskie'),
(3014, 170, 'ML', 'Malopolskie'),
(3015, 170, 'MZ', 'Mazowieckie'),
(3016, 170, 'OP', 'Opolskie'),
(3017, 170, 'PP', 'Podkarpackie'),
(3018, 170, 'PL', 'Podlaskie'),
(3019, 170, 'PM', 'Pomorskie'),
(3020, 170, 'SL', 'Slaskie'),
(3021, 170, 'SW', 'Swietokrzyskie'),
(3022, 170, 'WM', 'Warminsko-Mazurskie'),
(3023, 170, 'WP', 'Wielkopolskie'),
(3024, 170, 'ZA', 'Zachodniopomorskie'),
(3025, 171, 'AC', 'A&ccedil;ores'),
(3026, 171, 'AV', 'Aveiro'),
(3027, 171, 'BE', 'Beja'),
(3028, 171, 'BR', 'Braga'),
(3029, 171, 'BA', 'Bragan&ccedil;a'),
(3030, 171, 'CB', 'Castelo Branco'),
(3031, 171, 'CO', 'Coimbra'),
(3032, 171, 'EV', '&Eacute;vora'),
(3033, 171, 'FA', 'Faro'),
(3034, 171, 'GU', 'Guarda'),
(3035, 171, 'LE', 'Leiria'),
(3036, 171, 'LI', 'Lisboa'),
(3037, 171, 'ME', 'Madeira'),
(3038, 171, 'PO', 'Portalegre'),
(3039, 171, 'PR', 'Porto'),
(3040, 171, 'SA', 'Santar&eacute;m'),
(3041, 171, 'SE', 'Set&uacute;bal'),
(3042, 171, 'VC', 'Viana do Castelo'),
(3043, 171, 'VR', 'Vila Real'),
(3044, 171, 'VI', 'Viseu'),
(3045, 172, 'ADJ', 'Adjuntas'),
(3046, 172, 'AGU', 'Aguada'),
(3047, 172, 'AGU', 'Aguadilla'),
(3048, 172, 'AGU', 'Aguas Buenas'),
(3049, 172, 'AIB', 'Aibonito'),
(3050, 172, 'A-A', 'AÃ±asco'),
(3051, 172, 'ARE', 'Arecibo'),
(3052, 172, 'ARR', 'Arroyo'),
(3053, 172, 'BAR', 'Barceloneta'),
(3054, 172, 'BAR', 'Barranquitas'),
(3055, 172, 'BAY', 'Bayam&oacute;n'),
(3056, 172, 'CAB', 'Cabo Rojo'),
(3057, 172, 'CAG', 'Caguas'),
(3058, 172, 'CAM', 'Camuy'),
(3059, 172, 'CAN', 'Can&oacute;vanas'),
(3060, 172, 'CAR', 'Carolina'),
(3061, 172, 'CAT', 'Cata&ntilde;o'),
(3062, 172, 'CAY', 'Cayey'),
(3063, 172, 'CEI', 'Ceiba'),
(3064, 172, 'CIA', 'Ciales'),
(3065, 172, 'CID', 'Cidra'),
(3066, 172, 'COA', 'Coamo'),
(3067, 172, 'COM', 'Comer&iacute;o'),
(3068, 172, 'COR', 'Corozal'),
(3069, 172, 'CUL', 'Culebra'),
(3070, 172, 'DOR', 'Dorado'),
(3071, 172, 'FAJ', 'Fajardo'),
(3072, 172, 'FLO', 'Florida.'),
(3073, 172, 'GUÂ¡', 'GuÃ¡nica'),
(3074, 172, 'GUA', 'Guayama'),
(3075, 172, 'GUA', 'Guayanilla'),
(3076, 172, 'GUA', 'Guaynabo'),
(3077, 172, 'GUR', 'Gurabo'),
(3078, 172, 'HAT', 'Hatillo'),
(3079, 172, 'HOR', 'Hormigueros'),
(3080, 172, 'HUM', 'Humacao'),
(3081, 172, 'ISA', 'Isabela'),
(3082, 172, 'JAY', 'Jayuya'),
(3083, 172, 'JUA', 'Juana D&iacute;az'),
(3084, 172, 'JUN', 'Juncos'),
(3085, 172, 'LAJ', 'Lajas'),
(3086, 172, 'LAR', 'Lares'),
(3087, 172, 'LAS', 'Las Mar&iacute;as'),
(3088, 172, 'LAS', 'Las Piedras'),
(3089, 172, 'LOÃ•', 'LoÃ­za'),
(3090, 172, 'LUQ', 'Luquillo'),
(3091, 172, 'MAN', 'Manat&iacute;'),
(3092, 172, 'MAR', 'Maricao'),
(3093, 172, 'MAU', 'Maunabo'),
(3094, 172, 'MAY', 'MayagÃ¼ez'),
(3095, 172, 'MOC', 'Moca'),
(3096, 172, 'MOR', 'Morovis'),
(3097, 172, 'NAG', 'Naguabo'),
(3098, 172, 'NAR', 'Naranjito'),
(3099, 172, 'ORO', 'Orocovis'),
(3100, 172, 'PAT', 'Patillas'),
(3101, 172, 'PE-', 'PeÃ±uelas'),
(3102, 172, 'PON', 'Ponce'),
(3103, 172, 'QUE', 'Quebradillas'),
(3104, 172, 'RIN', 'Rinc&oacute;n'),
(3105, 172, 'RÃ•O', 'RÃ­o Grande'),
(3106, 172, 'SAB', 'Sabana Grande'),
(3107, 172, 'SAL', 'Salinas'),
(3108, 172, 'SAN', 'San Germ&aacute;n'),
(3109, 172, 'SAN', 'San Juan'),
(3110, 172, 'SAN', 'San Lorenzo'),
(3111, 172, 'SAN', 'San Sebasti&aacute;n'),
(3112, 172, 'SAN', 'Santa Isabel'),
(3113, 172, 'TOA', 'Toa Alta'),
(3114, 172, 'TOA', 'Toa Baja'),
(3115, 172, 'TRU', 'Trujillo Alto'),
(3116, 172, 'UTU', 'Utuado'),
(3117, 172, 'VEG', 'Vega Alta'),
(3118, 172, 'VEG', 'Vega Baja'),
(3119, 172, 'VIE', 'Vieques'),
(3120, 172, 'VIL', 'Villalba'),
(3121, 172, 'YAB', 'Yabucoa'),
(3122, 172, 'YAU', 'Yauco'),
(3123, 173, 'DW', 'Ad Dawhah'),
(3124, 173, 'GW', 'Al Ghuwayriyah'),
(3125, 173, 'JM', 'Al Jumayliyah'),
(3126, 173, 'KR', 'Al Khawr'),
(3127, 173, 'WK', 'Al Wakrah'),
(3128, 173, 'RN', 'Ar Rayyan'),
(3129, 173, 'JB', 'Jarayan al Batinah'),
(3130, 173, 'MS', 'Madinat ash Shamal'),
(3131, 173, 'UD', 'Umm Sa''id'),
(3132, 173, 'UL', 'Umm Salal'),
(3133, 175, 'AB', 'Alba'),
(3134, 175, 'AR', 'Arad'),
(3135, 175, 'AG', 'Arges'),
(3136, 175, 'BC', 'Bacau'),
(3137, 175, 'BH', 'Bihor'),
(3138, 175, 'BN', 'Bistrita-Nasaud'),
(3139, 175, 'BT', 'Botosani'),
(3140, 175, 'BV', 'Brasov'),
(3141, 175, 'BR', 'Braila'),
(3142, 175, 'B', 'Bucuresti'),
(3143, 175, 'BZ', 'Buzau'),
(3144, 175, 'CS', 'Caras-Severin'),
(3145, 175, 'CL', 'Calarasi'),
(3146, 175, 'CJ', 'Cluj'),
(3147, 175, 'CT', 'Constanta'),
(3148, 175, 'CV', 'Covasna'),
(3149, 175, 'DB', 'Dimbovita'),
(3150, 175, 'DJ', 'Dolj'),
(3151, 175, 'GL', 'Galati'),
(3152, 175, 'GR', 'Giurgiu'),
(3153, 175, 'GJ', 'Gorj'),
(3154, 175, 'HR', 'Harghita'),
(3155, 175, 'HD', 'Hunedoara'),
(3156, 175, 'IL', 'Ialomita'),
(3157, 175, 'IS', 'Iasi'),
(3158, 175, 'IF', 'Ilfov'),
(3159, 175, 'MM', 'Maramures'),
(3160, 175, 'MH', 'Mehedinti'),
(3161, 175, 'MS', 'Mures'),
(3162, 175, 'NT', 'Neamt'),
(3163, 175, 'OT', 'Olt'),
(3164, 175, 'PH', 'Prahova'),
(3165, 175, 'SM', 'Satu-Mare'),
(3166, 175, 'SJ', 'Salaj'),
(3167, 175, 'SB', 'Sibiu'),
(3168, 175, 'SV', 'Suceava'),
(3169, 175, 'TR', 'Teleorman'),
(3170, 175, 'TM', 'Timis'),
(3171, 175, 'TL', 'Tulcea'),
(3172, 175, 'VS', 'Vaslui'),
(3173, 175, 'VL', 'Valcea'),
(3174, 175, 'VN', 'Vrancea'),
(3175, 176, 'AB', 'Abakan'),
(3176, 176, 'AG', 'Aginskoye'),
(3177, 176, 'AN', 'Anadyr'),
(3178, 176, 'AR', 'Arkahangelsk'),
(3179, 176, 'AS', 'Astrakhan'),
(3180, 176, 'BA', 'Barnaul'),
(3181, 176, 'BE', 'Belgorod'),
(3182, 176, 'BI', 'Birobidzhan'),
(3183, 176, 'BL', 'Blagoveshchensk'),
(3184, 176, 'BR', 'Bryansk'),
(3185, 176, 'CH', 'Cheboksary'),
(3186, 176, 'CL', 'Chelyabinsk'),
(3187, 176, 'CR', 'Cherkessk'),
(3188, 176, 'CI', 'Chita'),
(3189, 176, 'DU', 'Dudinka'),
(3190, 176, 'EL', 'Elista'),
(3191, 176, 'GO', 'Gomo-Altaysk'),
(3192, 176, 'GA', 'Gorno-Altaysk'),
(3193, 176, 'GR', 'Groznyy'),
(3194, 176, 'IR', 'Irkutsk'),
(3195, 176, 'IV', 'Ivanovo'),
(3196, 176, 'IZ', 'Izhevsk'),
(3197, 176, 'KA', 'Kalinigrad'),
(3198, 176, 'KL', 'Kaluga'),
(3199, 176, 'KS', 'Kasnodar'),
(3200, 176, 'KZ', 'Kazan'),
(3201, 176, 'KE', 'Kemerovo'),
(3202, 176, 'KH', 'Khabarovsk'),
(3203, 176, 'KM', 'Khanty-Mansiysk'),
(3204, 176, 'KO', 'Kostroma'),
(3205, 176, 'KR', 'Krasnodar'),
(3206, 176, 'KN', 'Krasnoyarsk'),
(3207, 176, 'KU', 'Kudymkar'),
(3208, 176, 'KG', 'Kurgan'),
(3209, 176, 'KK', 'Kursk'),
(3210, 176, 'KY', 'Kyzyl'),
(3211, 176, 'LI', 'Lipetsk'),
(3212, 176, 'MA', 'Magadan'),
(3213, 176, 'MK', 'Makhachkala'),
(3214, 176, 'MY', 'Maykop'),
(3215, 176, 'MO', 'Moscow'),
(3216, 176, 'MU', 'Murmansk'),
(3217, 176, 'NA', 'Nalchik'),
(3218, 176, 'NR', 'Naryan Mar'),
(3219, 176, 'NZ', 'Nazran'),
(3220, 176, 'NI', 'Nizhniy Novgorod'),
(3221, 176, 'NO', 'Novgorod'),
(3222, 176, 'NV', 'Novosibirsk'),
(3223, 176, 'OM', 'Omsk'),
(3224, 176, 'OR', 'Orel'),
(3225, 176, 'OE', 'Orenburg'),
(3226, 176, 'PA', 'Palana'),
(3227, 176, 'PE', 'Penza'),
(3228, 176, 'PR', 'Perm'),
(3229, 176, 'PK', 'Petropavlovsk-Kamchatskiy'),
(3230, 176, 'PT', 'Petrozavodsk'),
(3231, 176, 'PS', 'Pskov'),
(3232, 176, 'RO', 'Rostov-na-Donu'),
(3233, 176, 'RY', 'Ryazan'),
(3234, 176, 'SL', 'Salekhard'),
(3235, 176, 'SA', 'Samara'),
(3236, 176, 'SR', 'Saransk'),
(3237, 176, 'SV', 'Saratov'),
(3238, 176, 'SM', 'Smolensk'),
(3239, 176, 'SP', 'St. Petersburg'),
(3240, 176, 'ST', 'Stavropol'),
(3241, 176, 'SY', 'Syktyvkar'),
(3242, 176, 'TA', 'Tambov'),
(3243, 176, 'TO', 'Tomsk'),
(3244, 176, 'TU', 'Tula'),
(3245, 176, 'TR', 'Tura'),
(3246, 176, 'TV', 'Tver'),
(3247, 176, 'TY', 'Tyumen'),
(3248, 176, 'UF', 'Ufa'),
(3249, 176, 'UL', 'Ul''yanovsk'),
(3250, 176, 'UU', 'Ulan-Ude'),
(3251, 176, 'US', 'Ust''-Ordynskiy'),
(3252, 176, 'VL', 'Vladikavkaz'),
(3253, 176, 'VA', 'Vladimir'),
(3254, 176, 'VV', 'Vladivostok'),
(3255, 176, 'VG', 'Volgograd'),
(3256, 176, 'VD', 'Vologda'),
(3257, 176, 'VO', 'Voronezh'),
(3258, 176, 'VY', 'Vyatka'),
(3259, 176, 'YA', 'Yakutsk'),
(3260, 176, 'YR', 'Yaroslavl'),
(3261, 176, 'YE', 'Yekaterinburg'),
(3262, 176, 'YO', 'Yoshkar-Ola'),
(3263, 177, 'BU', 'Butare'),
(3264, 177, 'BY', 'Byumba'),
(3265, 177, 'CY', 'Cyangugu'),
(3266, 177, 'GK', 'Gikongoro'),
(3267, 177, 'GS', 'Gisenyi'),
(3268, 177, 'GT', 'Gitarama'),
(3269, 177, 'KG', 'Kibungo'),
(3270, 177, 'KY', 'Kibuye'),
(3271, 177, 'KR', 'Kigali Rurale'),
(3272, 177, 'KV', 'Kigali-ville'),
(3273, 177, 'RU', 'Ruhengeri'),
(3274, 177, 'UM', 'Umutara'),
(3275, 178, 'CCN', 'Christ Church Nichola Town'),
(3276, 178, 'SAS', 'Saint Anne Sandy Point'),
(3277, 178, 'SGB', 'Saint George Basseterre'),
(3278, 178, 'SGG', 'Saint George Gingerland'),
(3279, 178, 'SJW', 'Saint James Windward'),
(3280, 178, 'SJC', 'Saint John Capesterre'),
(3281, 178, 'SJF', 'Saint John Figtree'),
(3282, 178, 'SMC', 'Saint Mary Cayon'),
(3283, 178, 'CAP', 'Saint Paul Capesterre'),
(3284, 178, 'CHA', 'Saint Paul Charlestown'),
(3285, 178, 'SPB', 'Saint Peter Basseterre'),
(3286, 178, 'STL', 'Saint Thomas Lowland'),
(3287, 178, 'STM', 'Saint Thomas Middle Island'),
(3288, 178, 'TPP', 'Trinity Palmetto Point'),
(3289, 179, 'AR', 'Anse-la-Raye'),
(3290, 179, 'CA', 'Castries'),
(3291, 179, 'CH', 'Choiseul'),
(3292, 179, 'DA', 'Dauphin'),
(3293, 179, 'DE', 'Dennery'),
(3294, 179, 'GI', 'Gros-Islet'),
(3295, 179, 'LA', 'Laborie'),
(3296, 179, 'MI', 'Micoud'),
(3297, 179, 'PR', 'Praslin'),
(3298, 179, 'SO', 'Soufriere'),
(3299, 179, 'VF', 'Vieux-Fort'),
(3300, 180, 'C', 'Charlotte'),
(3301, 180, 'R', 'Grenadines'),
(3302, 180, 'A', 'Saint Andrew'),
(3303, 180, 'D', 'Saint David'),
(3304, 180, 'G', 'Saint George'),
(3305, 180, 'P', 'Saint Patrick'),
(3306, 181, 'AN', 'A''ana'),
(3307, 181, 'AI', 'Aiga-i-le-Tai'),
(3308, 181, 'AT', 'Atua'),
(3309, 181, 'FA', 'Fa''asaleleaga'),
(3310, 181, 'GE', 'Gaga''emauga'),
(3311, 181, 'GF', 'Gagaifomauga'),
(3312, 181, 'PA', 'Palauli'),
(3313, 181, 'SA', 'Satupa''itea'),
(3314, 181, 'TU', 'Tuamasaga');
INSERT INTO `zones` VALUES
(3315, 181, 'VF', 'Va''a-o-Fonoti'),
(3316, 181, 'VS', 'Vaisigano'),
(3317, 182, 'AC', 'Acquaviva'),
(3318, 182, 'BM', 'Borgo Maggiore'),
(3319, 182, 'CH', 'Chiesanuova'),
(3320, 182, 'DO', 'Domagnano'),
(3321, 182, 'FA', 'Faetano'),
(3322, 182, 'FI', 'Fiorentino'),
(3323, 182, 'MO', 'Montegiardino'),
(3324, 182, 'SM', 'Citta di San Marino'),
(3325, 182, 'SE', 'Serravalle'),
(3326, 183, 'S', 'Sao Tome'),
(3327, 183, 'P', 'Principe'),
(3328, 184, 'BH', 'Al Bahah'),
(3329, 184, 'HS', 'Al Hudud ash Shamaliyah'),
(3330, 184, 'JF', 'Al Jawf'),
(3331, 184, 'MD', 'Al Madinah'),
(3332, 184, 'QS', 'Al Qasim'),
(3333, 184, 'RD', 'Ar Riyad'),
(3334, 184, 'AQ', 'Ash Sharqiyah (Eastern)'),
(3335, 184, 'AS', '''Asir'),
(3336, 184, 'HL', 'Ha''il'),
(3337, 184, 'JZ', 'Jizan'),
(3338, 184, 'ML', 'Makkah'),
(3339, 184, 'NR', 'Najran'),
(3340, 184, 'TB', 'Tabuk'),
(3341, 185, 'DA', 'Dakar'),
(3342, 185, 'DI', 'Diourbel'),
(3343, 185, 'FA', 'Fatick'),
(3344, 185, 'KA', 'Kaolack'),
(3345, 185, 'KO', 'Kolda'),
(3346, 185, 'LO', 'Louga'),
(3347, 185, 'MA', 'Matam'),
(3348, 185, 'SL', 'Saint-Louis'),
(3349, 185, 'TA', 'Tambacounda'),
(3350, 185, 'TH', 'Thies'),
(3351, 185, 'ZI', 'Ziguinchor'),
(3352, 186, 'AP', 'Anse aux Pins'),
(3353, 186, 'AB', 'Anse Boileau'),
(3354, 186, 'AE', 'Anse Etoile'),
(3355, 186, 'AL', 'Anse Louis'),
(3356, 186, 'AR', 'Anse Royale'),
(3357, 186, 'BL', 'Baie Lazare'),
(3358, 186, 'BS', 'Baie Sainte Anne'),
(3359, 186, 'BV', 'Beau Vallon'),
(3360, 186, 'BA', 'Bel Air'),
(3361, 186, 'BO', 'Bel Ombre'),
(3362, 186, 'CA', 'Cascade'),
(3363, 186, 'GL', 'Glacis'),
(3364, 186, 'GM', 'Grand'' Anse (on Mahe)'),
(3365, 186, 'GP', 'Grand'' Anse (on Praslin)'),
(3366, 186, 'DG', 'La Digue'),
(3367, 186, 'RA', 'La Riviere Anglaise'),
(3368, 186, 'MB', 'Mont Buxton'),
(3369, 186, 'MF', 'Mont Fleuri'),
(3370, 186, 'PL', 'Plaisance'),
(3371, 186, 'PR', 'Pointe La Rue'),
(3372, 186, 'PG', 'Port Glaud'),
(3373, 186, 'SL', 'Saint Louis'),
(3374, 186, 'TA', 'Takamaka'),
(3375, 187, 'E', 'Eastern'),
(3376, 187, 'N', 'Northern'),
(3377, 187, 'S', 'Southern'),
(3378, 187, 'W', 'Western'),
(3379, 189, 'BA', 'Banskobystricky'),
(3380, 189, 'BR', 'Bratislavsky'),
(3381, 189, 'KO', 'Kosicky'),
(3382, 189, 'NI', 'Nitriansky'),
(3383, 189, 'PR', 'Presovsky'),
(3384, 189, 'TC', 'Trenciansky'),
(3385, 189, 'TV', 'Trnavsky'),
(3386, 189, 'ZI', 'Zilinsky'),
(3387, 190, '4', 'Ã… tajerska'),
(3388, 190, '2A', 'Gorenjska'),
(3389, 190, '5', 'Prekmurje'),
(3390, 190, '3', 'KoroÅ¡ka'),
(3391, 190, '2B', 'Notranjska'),
(3392, 190, '1', 'Primorska'),
(3393, 190, '2C', 'Dolenjska'),
(3394, 190, '2C', 'Bela Krajina'),
(3395, 191, 'CE', 'Central'),
(3396, 191, 'CH', 'Choiseul'),
(3397, 191, 'GC', 'Guadalcanal'),
(3398, 191, 'HO', 'Honiara'),
(3399, 191, 'IS', 'Isabel'),
(3400, 191, 'MK', 'Makira'),
(3401, 191, 'ML', 'Malaita'),
(3402, 191, 'RB', 'Rennell and Bellona'),
(3403, 191, 'TM', 'Temotu'),
(3404, 191, 'WE', 'Western'),
(3405, 192, 'AW', 'Awdal'),
(3406, 192, 'BK', 'Bakool'),
(3407, 192, 'BN', 'Banaadir'),
(3408, 192, 'BR', 'Bari'),
(3409, 192, 'BY', 'Bay'),
(3410, 192, 'GA', 'Galguduud'),
(3411, 192, 'GE', 'Gedo'),
(3412, 192, 'HI', 'Hiiraan'),
(3413, 192, 'JD', 'Jubbada Dhexe'),
(3414, 192, 'JH', 'Jubbada Hoose'),
(3415, 192, 'MU', 'Mudug'),
(3416, 192, 'NU', 'Nugaal'),
(3417, 192, 'SA', 'Sanaag'),
(3418, 192, 'SD', 'Shabeellaha Dhexe'),
(3419, 192, 'SH', 'Shabeellaha Hoose'),
(3420, 192, 'SL', 'Sool'),
(3421, 192, 'TO', 'Togdheer'),
(3422, 192, 'WG', 'Woqooyi Galbeed'),
(3423, 193, 'EC', 'Eastern Cape'),
(3424, 193, 'FS', 'Free State'),
(3425, 193, 'GT', 'Gauteng'),
(3426, 193, 'KN', 'KwaZulu-Natal'),
(3427, 193, 'LP', 'Limpopo'),
(3428, 193, 'MP', 'Mpumalanga'),
(3429, 193, 'NW', 'North West'),
(3430, 193, 'NC', 'Northern Cape'),
(3431, 193, 'WC', 'Western Cape'),
(3432, 195, 'CA', 'La Coru&ntilde;a'),
(3433, 195, 'AL', '&Aacute;lava'),
(3434, 195, 'AB', 'Albacete'),
(3435, 195, 'AC', 'Alicante'),
(3436, 195, 'AM', 'Almeria'),
(3437, 195, 'AS', 'Asturias'),
(3438, 195, 'AV', '&Aacute;vila'),
(3439, 195, 'BJ', 'Badajoz'),
(3440, 195, 'IB', 'Baleares'),
(3441, 195, 'BA', 'Barcelona'),
(3442, 195, 'BU', 'Burgos'),
(3443, 195, 'CC', 'C&aacute;ceres'),
(3444, 195, 'CZ', 'C&aacute;diz'),
(3445, 195, 'CT', 'Cantabria'),
(3446, 195, 'CL', 'Castell&oacute;n'),
(3447, 195, 'CE', 'Ceuta'),
(3448, 195, 'CR', 'Ciudad Real'),
(3449, 195, 'CD', 'C&oacute;rdoba'),
(3450, 195, 'CU', 'Cuenca'),
(3451, 195, 'GI', 'Gerona'),
(3452, 195, 'GD', 'Granada'),
(3453, 195, 'GJ', 'Guadalajara'),
(3454, 195, 'GP', 'Guip&uacute;zcoa'),
(3455, 195, 'HL', 'Huelva'),
(3456, 195, 'HS', 'Huesca'),
(3457, 195, 'JN', 'Ja&eacute;n'),
(3458, 195, 'RJ', 'La Rioja'),
(3459, 195, 'PM', 'Las Palmas'),
(3460, 195, 'LE', 'Le&oacute;n'),
(3461, 195, 'LL', 'L&eacute;rida'),
(3462, 195, 'LG', 'Lugo'),
(3463, 195, 'MD', 'Madrid'),
(3464, 195, 'MA', 'M&aacute;laga'),
(3465, 195, 'ML', 'Melilla'),
(3466, 195, 'MU', 'Murcia'),
(3467, 195, 'NV', 'Navarra'),
(3468, 195, 'OU', 'Ourense'),
(3469, 195, 'PL', 'Palencia'),
(3470, 195, 'PO', 'Pontevedra'),
(3471, 195, 'SL', 'Salamanca'),
(3472, 195, 'SC', 'Santa Cruz de Tenerife'),
(3473, 195, 'SG', 'Segovia'),
(3474, 195, 'SV', 'Sevilla'),
(3475, 195, 'SO', 'Soria'),
(3476, 195, 'TA', 'Tarragona'),
(3477, 195, 'TE', 'Teruel'),
(3478, 195, 'TO', 'Toledo'),
(3479, 195, 'VC', 'Valencia'),
(3480, 195, 'VD', 'Valladolid'),
(3481, 195, 'VZ', 'Vizcaya'),
(3482, 195, 'ZM', 'Zamora'),
(3483, 195, 'ZR', 'Zaragoza'),
(3484, 196, 'CE', 'Central'),
(3485, 196, 'EA', 'Eastern'),
(3486, 196, 'NC', 'North Central'),
(3487, 196, 'NO', 'Northern'),
(3488, 196, 'NW', 'North Western'),
(3489, 196, 'SA', 'Sabaragamuwa'),
(3490, 196, 'SO', 'Southern'),
(3491, 196, 'UV', 'Uva'),
(3492, 196, 'WE', 'Western'),
(3493, 197, 'A', 'Ascension'),
(3494, 197, 'S', 'Saint Helena'),
(3495, 197, 'T', 'Tristan da Cunha'),
(3496, 198, 'P', 'Saint Pierre'),
(3497, 198, 'M', 'Miquelon'),
(3498, 199, 'ANL', 'A''ali an Nil'),
(3499, 199, 'BAM', 'Al Bahr al Ahmar'),
(3500, 199, 'BRT', 'Al Buhayrat'),
(3501, 199, 'JZR', 'Al Jazirah'),
(3502, 199, 'KRT', 'Al Khartum'),
(3503, 199, 'QDR', 'Al Qadarif'),
(3504, 199, 'WDH', 'Al Wahdah'),
(3505, 199, 'ANB', 'An Nil al Abyad'),
(3506, 199, 'ANZ', 'An Nil al Azraq'),
(3507, 199, 'ASH', 'Ash Shamaliyah'),
(3508, 199, 'BJA', 'Bahr al Jabal'),
(3509, 199, 'GIS', 'Gharb al Istiwa''iyah'),
(3510, 199, 'GBG', 'Gharb Bahr al Ghazal'),
(3511, 199, 'GDA', 'Gharb Darfur'),
(3512, 199, 'GKU', 'Gharb Kurdufan'),
(3513, 199, 'JDA', 'Janub Darfur'),
(3514, 199, 'JKU', 'Janub Kurdufan'),
(3515, 199, 'JQL', 'Junqali'),
(3516, 199, 'KSL', 'Kassala'),
(3517, 199, 'NNL', 'Nahr an Nil'),
(3518, 199, 'SBG', 'Shamal Bahr al Ghazal'),
(3519, 199, 'SDA', 'Shamal Darfur'),
(3520, 199, 'SKU', 'Shamal Kurdufan'),
(3521, 199, 'SIS', 'Sharq al Istiwa''iyah'),
(3522, 199, 'SNR', 'Sinnar'),
(3523, 199, 'WRB', 'Warab'),
(3524, 200, 'BR', 'Brokopondo'),
(3525, 200, 'CM', 'Commewijne'),
(3526, 200, 'CR', 'Coronie'),
(3527, 200, 'MA', 'Marowijne'),
(3528, 200, 'NI', 'Nickerie'),
(3529, 200, 'PA', 'Para'),
(3530, 200, 'PM', 'Paramaribo'),
(3531, 200, 'SA', 'Saramacca'),
(3532, 200, 'SI', 'Sipaliwini'),
(3533, 200, 'WA', 'Wanica'),
(3534, 202, 'H', 'Hhohho'),
(3535, 202, 'L', 'Lubombo'),
(3536, 202, 'M', 'Manzini'),
(3537, 202, 'S', 'Shishelweni'),
(3538, 203, 'K', 'Blekinge'),
(3539, 203, 'W', 'Dalama'),
(3540, 203, 'I', 'Gotland'),
(3541, 203, 'X', 'GÃ¤vleborg'),
(3542, 203, 'N', 'Halland'),
(3543, 203, 'Z', 'JÃ¤mtland'),
(3544, 203, 'F', 'JÃ¶nkÃ¶ping'),
(3545, 203, 'H', 'Kalmar'),
(3546, 203, 'G', 'Kronoberg'),
(3547, 203, 'BD', 'Norrbotten'),
(3548, 203, 'M', 'Sk&aring;ne'),
(3549, 203, 'AB', 'Stockholm'),
(3550, 203, 'D', 'SÃ¶dermanland'),
(3551, 203, 'C', 'Uppsala'),
(3552, 203, 'S', 'VÃ¤rmland'),
(3553, 203, 'AC', 'VÃ¤sterbotten'),
(3554, 203, 'Y', 'VÃ¤sternorrland'),
(3555, 203, 'U', 'VÃ¤stmanland'),
(3556, 203, 'O', 'VÃ¤stra GÃ¶taland'),
(3557, 203, 'T', 'Ã–rebro'),
(3558, 203, 'E', 'Ã–stergÃ¶tland'),
(3559, 204, 'AG', 'Aargau'),
(3560, 204, 'AR', 'Appenzell Ausserrhoden'),
(3561, 204, 'AI', 'Appenzell Innerrhoden'),
(3562, 204, 'BS', 'Basel-Stadt'),
(3563, 204, 'BL', 'Basel-Landschaft'),
(3564, 204, 'BE', 'Bern'),
(3565, 204, 'FR', 'Fribourg'),
(3566, 204, 'GE', 'Gen&egrave;ve'),
(3567, 204, 'GL', 'Glarus'),
(3568, 204, 'GR', 'GraubÃ¼nden'),
(3569, 204, 'JU', 'Jura'),
(3570, 204, 'LU', 'Lucerne'),
(3571, 204, 'NE', 'Neuch&acirc;tel'),
(3572, 204, 'NW', 'Nidwalden'),
(3573, 204, 'OW', 'Obwalden'),
(3574, 204, 'SG', 'St. Gallen'),
(3575, 204, 'SH', 'Schaffhausen'),
(3576, 204, 'SZ', 'Schwyz'),
(3577, 204, 'SO', 'Solothurn'),
(3578, 204, 'TG', 'Thurgau'),
(3579, 204, 'TI', 'Ticino'),
(3580, 204, 'UR', 'Uri'),
(3581, 204, 'VS', 'Valais'),
(3582, 204, 'VD', 'Vaud'),
(3583, 204, 'ZG', 'Zug'),
(3584, 204, 'ZH', 'ZÃ¼rich'),
(3585, 205, 'HA', 'Al Hasakah'),
(3586, 205, 'LA', 'Al Ladhiqiyah'),
(3587, 205, 'QU', 'Al Qunaytirah'),
(3588, 205, 'RQ', 'Ar Raqqah'),
(3589, 205, 'SU', 'As Suwayda'),
(3590, 205, 'DA', 'Dara'),
(3591, 205, 'DZ', 'Dayr az Zawr'),
(3592, 205, 'DI', 'Dimashq'),
(3593, 205, 'HL', 'Halab'),
(3594, 205, 'HM', 'Hamah'),
(3595, 205, 'HI', 'Hims'),
(3596, 205, 'ID', 'Idlib'),
(3597, 205, 'RD', 'Rif Dimashq'),
(3598, 205, 'TA', 'Tartus'),
(3599, 206, 'CH', 'Chang-hua'),
(3600, 206, 'CI', 'Chia-i'),
(3601, 206, 'HS', 'Hsin-chu'),
(3602, 206, 'HL', 'Hua-lien'),
(3603, 206, 'IL', 'I-lan'),
(3604, 206, 'KH', 'Kao-hsiung county'),
(3605, 206, 'KM', 'Kin-men'),
(3606, 206, 'LC', 'Lien-chiang'),
(3607, 206, 'ML', 'Miao-li'),
(3608, 206, 'NT', 'Nan-t''ou'),
(3609, 206, 'PH', 'P''eng-hu'),
(3610, 206, 'PT', 'P''ing-tung'),
(3611, 206, 'TG', 'T''ai-chung'),
(3612, 206, 'TA', 'T''ai-nan'),
(3613, 206, 'TP', 'T''ai-pei county'),
(3614, 206, 'TT', 'T''ai-tung'),
(3615, 206, 'TY', 'T''ao-yuan'),
(3616, 206, 'YL', 'Yun-lin'),
(3617, 206, 'CC', 'Chia-i city'),
(3618, 206, 'CL', 'Chi-lung'),
(3619, 206, 'HC', 'Hsin-chu'),
(3620, 206, 'TH', 'T''ai-chung'),
(3621, 206, 'TN', 'T''ai-nan'),
(3622, 206, 'KC', 'Kao-hsiung city'),
(3623, 206, 'TC', 'T''ai-pei city'),
(3624, 207, 'GB', 'Gorno-Badakhstan'),
(3625, 207, 'KT', 'Khatlon'),
(3626, 207, 'SU', 'Sughd'),
(3627, 208, 'AR', 'Arusha'),
(3628, 208, 'DS', 'Dar es Salaam'),
(3629, 208, 'DO', 'Dodoma'),
(3630, 208, 'IR', 'Iringa'),
(3631, 208, 'KA', 'Kagera'),
(3632, 208, 'KI', 'Kigoma'),
(3633, 208, 'KJ', 'Kilimanjaro'),
(3634, 208, 'LN', 'Lindi'),
(3635, 208, 'MY', 'Manyara'),
(3636, 208, 'MR', 'Mara'),
(3637, 208, 'MB', 'Mbeya'),
(3638, 208, 'MO', 'Morogoro'),
(3639, 208, 'MT', 'Mtwara'),
(3640, 208, 'MW', 'Mwanza'),
(3641, 208, 'PN', 'Pemba North'),
(3642, 208, 'PS', 'Pemba South'),
(3643, 208, 'PW', 'Pwani'),
(3644, 208, 'RK', 'Rukwa'),
(3645, 208, 'RV', 'Ruvuma'),
(3646, 208, 'SH', 'Shinyanga'),
(3647, 208, 'SI', 'Singida'),
(3648, 208, 'TB', 'Tabora'),
(3649, 208, 'TN', 'Tanga'),
(3650, 208, 'ZC', 'Zanzibar Central/South'),
(3651, 208, 'ZN', 'Zanzibar North'),
(3652, 208, 'ZU', 'Zanzibar Urban/West'),
(3653, 209, 'Amnat Charoen', 'Amnat Charoen'),
(3654, 209, 'Ang Thong', 'Ang Thong'),
(3655, 209, 'Ayutthaya', 'Ayutthaya'),
(3656, 209, 'Bangkok', 'Bangkok'),
(3657, 209, 'Buriram', 'Buriram'),
(3658, 209, 'Chachoengsao', 'Chachoengsao'),
(3659, 209, 'Chai Nat', 'Chai Nat'),
(3660, 209, 'Chaiyaphum', 'Chaiyaphum'),
(3661, 209, 'Chanthaburi', 'Chanthaburi'),
(3662, 209, 'Chiang Mai', 'Chiang Mai'),
(3663, 209, 'Chiang Rai', 'Chiang Rai'),
(3664, 209, 'Chon Buri', 'Chon Buri'),
(3665, 209, 'Chumphon', 'Chumphon'),
(3666, 209, 'Kalasin', 'Kalasin'),
(3667, 209, 'Kamphaeng Phet', 'Kamphaeng Phet'),
(3668, 209, 'Kanchanaburi', 'Kanchanaburi'),
(3669, 209, 'Khon Kaen', 'Khon Kaen'),
(3670, 209, 'Krabi', 'Krabi'),
(3671, 209, 'Lampang', 'Lampang'),
(3672, 209, 'Lamphun', 'Lamphun'),
(3673, 209, 'Loei', 'Loei'),
(3674, 209, 'Lop Buri', 'Lop Buri'),
(3675, 209, 'Mae Hong Son', 'Mae Hong Son'),
(3676, 209, 'Maha Sarakham', 'Maha Sarakham'),
(3677, 209, 'Mukdahan', 'Mukdahan'),
(3678, 209, 'Nakhon Nayok', 'Nakhon Nayok'),
(3679, 209, 'Nakhon Pathom', 'Nakhon Pathom'),
(3680, 209, 'Nakhon Phanom', 'Nakhon Phanom'),
(3681, 209, 'Nakhon Ratchasima', 'Nakhon Ratchasima'),
(3682, 209, 'Nakhon Sawan', 'Nakhon Sawan'),
(3683, 209, 'Nakhon Si Thammarat', 'Nakhon Si Thammarat'),
(3684, 209, 'Nan', 'Nan'),
(3685, 209, 'Narathiwat', 'Narathiwat'),
(3686, 209, 'Nong Bua Lamphu', 'Nong Bua Lamphu'),
(3687, 209, 'Nong Khai', 'Nong Khai'),
(3688, 209, 'Nonthaburi', 'Nonthaburi'),
(3689, 209, 'Pathum Thani', 'Pathum Thani'),
(3690, 209, 'Pattani', 'Pattani'),
(3691, 209, 'Phangnga', 'Phangnga'),
(3692, 209, 'Phatthalung', 'Phatthalung'),
(3693, 209, 'Phayao', 'Phayao'),
(3694, 209, 'Phetchabun', 'Phetchabun'),
(3695, 209, 'Phetchaburi', 'Phetchaburi'),
(3696, 209, 'Phichit', 'Phichit'),
(3697, 209, 'Phitsanulok', 'Phitsanulok'),
(3698, 209, 'Phrae', 'Phrae'),
(3699, 209, 'Phuket', 'Phuket'),
(3700, 209, 'Prachin Buri', 'Prachin Buri'),
(3701, 209, 'Prachuap Khiri Khan', 'Prachuap Khiri Khan'),
(3702, 209, 'Ranong', 'Ranong'),
(3703, 209, 'Ratchaburi', 'Ratchaburi'),
(3704, 209, 'Rayong', 'Rayong'),
(3705, 209, 'Roi Et', 'Roi Et'),
(3706, 209, 'Sa Kaeo', 'Sa Kaeo'),
(3707, 209, 'Sakon Nakhon', 'Sakon Nakhon'),
(3708, 209, 'Samut Prakan', 'Samut Prakan'),
(3709, 209, 'Samut Sakhon', 'Samut Sakhon'),
(3710, 209, 'Samut Songkhram', 'Samut Songkhram'),
(3711, 209, 'Sara Buri', 'Sara Buri'),
(3712, 209, 'Satun', 'Satun'),
(3713, 209, 'Sing Buri', 'Sing Buri'),
(3714, 209, 'Sisaket', 'Sisaket'),
(3715, 209, 'Songkhla', 'Songkhla'),
(3716, 209, 'Sukhothai', 'Sukhothai'),
(3717, 209, 'Suphan Buri', 'Suphan Buri'),
(3718, 209, 'Surat Thani', 'Surat Thani'),
(3719, 209, 'Surin', 'Surin'),
(3720, 209, 'Tak', 'Tak'),
(3721, 209, 'Trang', 'Trang'),
(3722, 209, 'Trat', 'Trat'),
(3723, 209, 'Ubon Ratchathani', 'Ubon Ratchathani'),
(3724, 209, 'Udon Thani', 'Udon Thani'),
(3725, 209, 'Uthai Thani', 'Uthai Thani'),
(3726, 209, 'Uttaradit', 'Uttaradit'),
(3727, 209, 'Yala', 'Yala'),
(3728, 209, 'Yasothon', 'Yasothon'),
(3729, 210, 'K', 'Kara'),
(3730, 210, 'P', 'Plateaux'),
(3731, 210, 'S', 'Savanes'),
(3732, 210, 'C', 'Centrale'),
(3733, 210, 'M', 'Maritime'),
(3734, 211, 'A', 'Atafu'),
(3735, 211, 'F', 'Fakaofo'),
(3736, 211, 'N', 'Nukunonu'),
(3737, 212, 'H', 'Ha''apai'),
(3738, 212, 'T', 'Tongatapu'),
(3739, 212, 'V', 'Vava''u'),
(3740, 213, 'CT', 'Couva/Tabaquite/Talparo'),
(3741, 213, 'DM', 'Diego Martin'),
(3742, 213, 'MR', 'Mayaro/Rio Claro'),
(3743, 213, 'PD', 'Penal/Debe'),
(3744, 213, 'PT', 'Princes Town'),
(3745, 213, 'SG', 'Sangre Grande'),
(3746, 213, 'SL', 'San Juan/Laventille'),
(3747, 213, 'SI', 'Siparia'),
(3748, 213, 'TP', 'Tunapuna/Piarco'),
(3749, 213, 'PS', 'Port of Spain'),
(3750, 213, 'SF', 'San Fernando'),
(3751, 213, 'AR', 'Arima'),
(3752, 213, 'PF', 'Point Fortin'),
(3753, 213, 'CH', 'Chaguanas'),
(3754, 213, 'TO', 'Tobago'),
(3755, 214, 'AR', 'Ariana'),
(3756, 214, 'BJ', 'Beja'),
(3757, 214, 'BA', 'Ben Arous'),
(3758, 214, 'BI', 'Bizerte'),
(3759, 214, 'GB', 'Gabes'),
(3760, 214, 'GF', 'Gafsa'),
(3761, 214, 'JE', 'Jendouba'),
(3762, 214, 'KR', 'Kairouan'),
(3763, 214, 'KS', 'Kasserine'),
(3764, 214, 'KB', 'Kebili'),
(3765, 214, 'KF', 'Kef'),
(3766, 214, 'MH', 'Mahdia'),
(3767, 214, 'MN', 'Manouba'),
(3768, 214, 'ME', 'Medenine'),
(3769, 214, 'MO', 'Monastir'),
(3770, 214, 'NA', 'Nabeul'),
(3771, 214, 'SF', 'Sfax'),
(3772, 214, 'SD', 'Sidi'),
(3773, 214, 'SL', 'Siliana'),
(3774, 214, 'SO', 'Sousse'),
(3775, 214, 'TA', 'Tataouine'),
(3776, 214, 'TO', 'Tozeur'),
(3777, 214, 'TU', 'Tunis'),
(3778, 214, 'ZA', 'Zaghouan'),
(3779, 215, 'ADA', 'Adana'),
(3780, 215, 'ADI', 'Adiyaman'),
(3781, 215, 'AFY', 'Afyonkarahisar'),
(3782, 215, 'AGR', 'Agri'),
(3783, 215, 'AKS', 'Aksaray'),
(3784, 215, 'AMA', 'Amasya'),
(3785, 215, 'ANK', 'Ankara'),
(3786, 215, 'ANT', 'Antalya'),
(3787, 215, 'ARD', 'Ardahan'),
(3788, 215, 'ART', 'Artvin'),
(3789, 215, 'AYI', 'Aydin'),
(3790, 215, 'BAL', 'Balikesir'),
(3791, 215, 'BAR', 'Bartin'),
(3792, 215, 'BAT', 'Batman'),
(3793, 215, 'BAY', 'Bayburt'),
(3794, 215, 'BIL', 'Bilecik'),
(3795, 215, 'BIN', 'Bingol'),
(3796, 215, 'BIT', 'Bitlis'),
(3797, 215, 'BOL', 'Bolu'),
(3798, 215, 'BRD', 'Burdur'),
(3799, 215, 'BRS', 'Bursa'),
(3800, 215, 'CKL', 'Canakkale'),
(3801, 215, 'CKR', 'Cankiri'),
(3802, 215, 'COR', 'Corum'),
(3803, 215, 'DEN', 'Denizli'),
(3804, 215, 'DIY', 'Diyarbakir'),
(3805, 215, 'DUZ', 'Duzce'),
(3806, 215, 'EDI', 'Edirne'),
(3807, 215, 'ELA', 'Elazig'),
(3808, 215, 'EZC', 'Erzincan'),
(3809, 215, 'EZR', 'Erzurum'),
(3810, 215, 'ESK', 'Eskisehir'),
(3811, 215, 'GAZ', 'Gaziantep'),
(3812, 215, 'GIR', 'Giresun'),
(3813, 215, 'GMS', 'Gumushane'),
(3814, 215, 'HKR', 'Hakkari'),
(3815, 215, 'HTY', 'Hatay'),
(3816, 215, 'IGD', 'Igdir'),
(3817, 215, 'ISP', 'Isparta'),
(3818, 215, 'IST', 'Istanbul'),
(3819, 215, 'IZM', 'Izmir'),
(3820, 215, 'KAH', 'Kahramanmaras'),
(3821, 215, 'KRB', 'Karabuk'),
(3822, 215, 'KRM', 'Karaman'),
(3823, 215, 'KRS', 'Kars'),
(3824, 215, 'KAS', 'Kastamonu'),
(3825, 215, 'KAY', 'Kayseri'),
(3826, 215, 'KLS', 'Kilis'),
(3827, 215, 'KRK', 'Kirikkale'),
(3828, 215, 'KLR', 'Kirklareli'),
(3829, 215, 'KRH', 'Kirsehir'),
(3830, 215, 'KOC', 'Kocaeli'),
(3831, 215, 'KON', 'Konya'),
(3832, 215, 'KUT', 'Kutahya'),
(3833, 215, 'MAL', 'Malatya'),
(3834, 215, 'MAN', 'Manisa'),
(3835, 215, 'MAR', 'Mardin'),
(3836, 215, 'MER', 'Mersin'),
(3837, 215, 'MUG', 'Mugla'),
(3838, 215, 'MUS', 'Mus'),
(3839, 215, 'NEV', 'Nevsehir'),
(3840, 215, 'NIG', 'Nigde'),
(3841, 215, 'ORD', 'Ordu'),
(3842, 215, 'OSM', 'Osmaniye'),
(3843, 215, 'RIZ', 'Rize'),
(3844, 215, 'SAK', 'Sakarya'),
(3845, 215, 'SAM', 'Samsun'),
(3846, 215, 'SAN', 'Sanliurfa'),
(3847, 215, 'SII', 'Siirt'),
(3848, 215, 'SIN', 'Sinop'),
(3849, 215, 'SIR', 'Sirnak'),
(3850, 215, 'SIV', 'Sivas'),
(3851, 215, 'TEL', 'Tekirdag'),
(3852, 215, 'TOK', 'Tokat'),
(3853, 215, 'TRA', 'Trabzon'),
(3854, 215, 'TUN', 'Tunceli'),
(3855, 215, 'USK', 'Usak'),
(3856, 215, 'VAN', 'Van'),
(3857, 215, 'YAL', 'Yalova'),
(3858, 215, 'YOZ', 'Yozgat'),
(3859, 215, 'ZON', 'Zonguldak'),
(3860, 216, 'A', 'Ahal Welayaty'),
(3861, 216, 'B', 'Balkan Welayaty'),
(3862, 216, 'D', 'Dashhowuz Welayaty'),
(3863, 216, 'L', 'Lebap Welayaty'),
(3864, 216, 'M', 'Mary Welayaty'),
(3865, 217, 'AC', 'Ambergris Cays'),
(3866, 217, 'DC', 'Dellis Cay'),
(3867, 217, 'FC', 'French Cay'),
(3868, 217, 'LW', 'Little Water Cay'),
(3869, 217, 'RC', 'Parrot Cay'),
(3870, 217, 'PN', 'Pine Cay'),
(3871, 217, 'SL', 'Salt Cay'),
(3872, 217, 'GT', 'Grand Turk'),
(3873, 217, 'SC', 'South Caicos'),
(3874, 217, 'EC', 'East Caicos'),
(3875, 217, 'MC', 'Middle Caicos'),
(3876, 217, 'NC', 'North Caicos'),
(3877, 217, 'PR', 'Providenciales'),
(3878, 217, 'WC', 'West Caicos'),
(3879, 218, 'NMG', 'Nanumanga'),
(3880, 218, 'NLK', 'Niulakita'),
(3881, 218, 'NTO', 'Niutao'),
(3882, 218, 'FUN', 'Funafuti'),
(3883, 218, 'NME', 'Nanumea'),
(3884, 218, 'NUI', 'Nui'),
(3885, 218, 'NFT', 'Nukufetau'),
(3886, 218, 'NLL', 'Nukulaelae'),
(3887, 218, 'VAI', 'Vaitupu'),
(3888, 219, 'KAL', 'Kalangala'),
(3889, 219, 'KMP', 'Kampala'),
(3890, 219, 'KAY', 'Kayunga'),
(3891, 219, 'KIB', 'Kiboga'),
(3892, 219, 'LUW', 'Luwero'),
(3893, 219, 'MAS', 'Masaka'),
(3894, 219, 'MPI', 'Mpigi'),
(3895, 219, 'MUB', 'Mubende'),
(3896, 219, 'MUK', 'Mukono'),
(3897, 219, 'NKS', 'Nakasongola'),
(3898, 219, 'RAK', 'Rakai'),
(3899, 219, 'SEM', 'Sembabule'),
(3900, 219, 'WAK', 'Wakiso'),
(3901, 219, 'BUG', 'Bugiri'),
(3902, 219, 'BUS', 'Busia'),
(3903, 219, 'IGA', 'Iganga'),
(3904, 219, 'JIN', 'Jinja'),
(3905, 219, 'KAB', 'Kaberamaido'),
(3906, 219, 'KML', 'Kamuli'),
(3907, 219, 'KPC', 'Kapchorwa'),
(3908, 219, 'KTK', 'Katakwi'),
(3909, 219, 'KUM', 'Kumi'),
(3910, 219, 'MAY', 'Mayuge'),
(3911, 219, 'MBA', 'Mbale'),
(3912, 219, 'PAL', 'Pallisa'),
(3913, 219, 'SIR', 'Sironko'),
(3914, 219, 'SOR', 'Soroti'),
(3915, 219, 'TOR', 'Tororo'),
(3916, 219, 'ADJ', 'Adjumani'),
(3917, 219, 'APC', 'Apac'),
(3918, 219, 'ARU', 'Arua'),
(3919, 219, 'GUL', 'Gulu'),
(3920, 219, 'KIT', 'Kitgum'),
(3921, 219, 'KOT', 'Kotido'),
(3922, 219, 'LIR', 'Lira'),
(3923, 219, 'MRT', 'Moroto'),
(3924, 219, 'MOY', 'Moyo'),
(3925, 219, 'NAK', 'Nakapiripirit'),
(3926, 219, 'NEB', 'Nebbi'),
(3927, 219, 'PAD', 'Pader'),
(3928, 219, 'YUM', 'Yumbe'),
(3929, 219, 'BUN', 'Bundibugyo'),
(3930, 219, 'BSH', 'Bushenyi'),
(3931, 219, 'HOI', 'Hoima'),
(3932, 219, 'KBL', 'Kabale'),
(3933, 219, 'KAR', 'Kabarole'),
(3934, 219, 'KAM', 'Kamwenge'),
(3935, 219, 'KAN', 'Kanungu'),
(3936, 219, 'KAS', 'Kasese'),
(3937, 219, 'KBA', 'Kibaale'),
(3938, 219, 'KIS', 'Kisoro'),
(3939, 219, 'KYE', 'Kyenjojo'),
(3940, 219, 'MSN', 'Masindi'),
(3941, 219, 'MBR', 'Mbarara'),
(3942, 219, 'NTU', 'Ntungamo'),
(3943, 219, 'RUK', 'Rukungiri'),
(3944, 220, 'CK', 'Cherkasy'),
(3945, 220, 'CH', 'Chernihiv'),
(3946, 220, 'CV', 'Chernivtsi'),
(3947, 220, 'CR', 'Crimea'),
(3948, 220, 'DN', 'Dnipropetrovs''k'),
(3949, 220, 'DO', 'Donets''k'),
(3950, 220, 'IV', 'Ivano-Frankivs''k'),
(3951, 220, 'KL', 'Kharkiv Kherson'),
(3952, 220, 'KM', 'Khmel''nyts''kyy'),
(3953, 220, 'KR', 'Kirovohrad'),
(3954, 220, 'KV', 'Kiev'),
(3955, 220, 'KY', 'Kyyiv'),
(3956, 220, 'LU', 'Luhans''k'),
(3957, 220, 'LV', 'L''viv'),
(3958, 220, 'MY', 'Mykolayiv'),
(3959, 220, 'OD', 'Odesa'),
(3960, 220, 'PO', 'Poltava'),
(3961, 220, 'RI', 'Rivne'),
(3962, 220, 'SE', 'Sevastopol'),
(3963, 220, 'SU', 'Sumy'),
(3964, 220, 'TE', 'Ternopil'''),
(3965, 220, 'VI', 'Vinnytsya'),
(3966, 220, 'VO', 'Volyn'''),
(3967, 220, 'ZK', 'Zakarpattya'),
(3968, 220, 'ZA', 'Zaporizhzhya'),
(3969, 220, 'ZH', 'Zhytomyr'),
(3970, 221, 'AZ', 'Abu Zaby'),
(3971, 221, 'AJ', '''Ajman'),
(3972, 221, 'FU', 'Al Fujayrah'),
(3973, 221, 'SH', 'Ash Shariqah'),
(3974, 221, 'DU', 'Dubayy'),
(3975, 221, 'RK', 'R''as al Khaymah'),
(3976, 221, 'UQ', 'Umm al Qaywayn'),
(3977, 222, 'Aberdeen', 'Aberdeen'),
(3978, 222, 'Aberdeenshire', 'Aberdeenshire'),
(3979, 222, 'Anglesey', 'Anglesey'),
(3980, 222, 'Angus', 'Angus'),
(3981, 222, 'Argyll and Bute', 'Argyll and Bute'),
(3982, 222, 'Bedfordshire', 'Bedfordshire'),
(3983, 222, 'Berkshire', 'Berkshire'),
(3984, 222, 'Blaenau Gwent', 'Blaenau Gwent'),
(3985, 222, 'Bridgend', 'Bridgend'),
(3986, 222, 'Bristol', 'Bristol'),
(3987, 222, 'Buckinghamshire', 'Buckinghamshire'),
(3988, 222, 'Caerphilly', 'Caerphilly'),
(3989, 222, 'Cambridgeshire', 'Cambridgeshire'),
(3990, 222, 'Cardiff', 'Cardiff'),
(3991, 222, 'Carmarthenshire', 'Carmarthenshire'),
(3992, 222, 'Ceredigion', 'Ceredigion'),
(3993, 222, 'Channel Islands', 'Channel Islands'),
(3994, 222, 'Cheshire', 'Cheshire'),
(3995, 222, 'Clackmannanshire', 'Clackmannanshire'),
(3996, 222, 'Conwy', 'Conwy'),
(3997, 222, 'Cornwall', 'Cornwall'),
(3998, 222, 'Cumbria', 'Cumbria'),
(3999, 222, 'Denbighshire', 'Denbighshire'),
(4000, 222, 'Derbyshire', 'Derbyshire'),
(4001, 222, 'Devon', 'Devon'),
(4002, 222, 'Dorset', 'Dorset'),
(4003, 222, 'Dumfries and Galloway', 'Dumfries and Galloway'),
(4004, 222, 'Dundee', 'Dundee'),
(4005, 222, 'Durham', 'Durham'),
(4006, 222, 'East Ayrshire', 'East Ayrshire'),
(4007, 222, 'East Dunbartonshire', 'East Dunbartonshire'),
(4008, 222, 'East Lothian', 'East Lothian'),
(4009, 222, 'East Renfrewshire', 'East Renfrewshire'),
(4010, 222, 'East Riding of Yorkshire', 'East Riding of Yorkshire'),
(4011, 222, 'East Sussex', 'East Sussex'),
(4012, 222, 'Edinburgh', 'Edinburgh'),
(4013, 222, 'Essex', 'Essex'),
(4014, 222, 'Falkirk', 'Falkirk'),
(4015, 222, 'Fife', 'Fife'),
(4016, 222, 'Flintshire', 'Flintshire'),
(4017, 222, 'Glasgow', 'Glasgow'),
(4018, 222, 'Gloucestershire', 'Gloucestershire'),
(4019, 222, 'Greater London', 'Greater London'),
(4020, 222, 'Greater Manchester', 'Greater Manchester'),
(4021, 222, 'Gwynedd', 'Gwynedd'),
(4022, 222, 'Hampshire', 'Hampshire'),
(4023, 222, 'Herefordshire', 'Herefordshire'),
(4024, 222, 'Hertfordshire', 'Hertfordshire'),
(4025, 222, 'Highlands', 'Highlands'),
(4026, 222, 'Inverclyde', 'Inverclyde'),
(4027, 222, 'Isle of Man', 'Isle of Man'),
(4028, 222, 'Isle of Wight', 'Isle of Wight'),
(4029, 222, 'Kent', 'Kent'),
(4030, 222, 'Lancashire', 'Lancashire'),
(4031, 222, 'Leicestershire', 'Leicestershire'),
(4032, 222, 'Lincolnshire', 'Lincolnshire'),
(4033, 222, 'Merseyside', 'Merseyside'),
(4034, 222, 'Merthyr Tydfil', 'Merthyr Tydfil'),
(4035, 222, 'Middlesex', 'Middlesex'),
(4036, 222, 'Midlothian', 'Midlothian'),
(4037, 222, 'Monmouthshire', 'Monmouthshire'),
(4038, 222, 'Moray', 'Moray'),
(4039, 222, 'Neath Port Talbot', 'Neath Port Talbot'),
(4040, 222, 'Newport', 'Newport'),
(4041, 222, 'Norfolk', 'Norfolk'),
(4042, 222, 'North Ayrshire', 'North Ayrshire'),
(4043, 222, 'North Lanarkshire', 'North Lanarkshire'),
(4044, 222, 'North Yorkshire', 'North Yorkshire'),
(4045, 222, 'Northamptonshire', 'Northamptonshire'),
(4046, 222, 'Northumberland', 'Northumberland'),
(4047, 222, 'Nottinghamshire', 'Nottinghamshire'),
(4048, 222, 'Orkney Islands', 'Orkney Islands'),
(4049, 222, 'Oxfordshire', 'Oxfordshire'),
(4050, 222, 'Pembrokeshire', 'Pembrokeshire'),
(4051, 222, 'Perth and Kinross', 'Perth and Kinross'),
(4052, 222, 'Powys', 'Powys'),
(4053, 222, 'Renfrewshire', 'Renfrewshire'),
(4054, 222, 'Rhondda Cynon Taff', 'Rhondda Cynon Taff'),
(4055, 222, 'Rutland', 'Rutland'),
(4056, 222, 'Scottish Borders', 'Scottish Borders'),
(4057, 222, 'Shetland Islands', 'Shetland Islands'),
(4058, 222, 'Shropshire', 'Shropshire'),
(4059, 222, 'Somerset', 'Somerset'),
(4060, 222, 'South Ayrshire', 'South Ayrshire'),
(4061, 222, 'South Lanarkshire', 'South Lanarkshire'),
(4062, 222, 'South Yorkshire', 'South Yorkshire'),
(4063, 222, 'Staffordshire', 'Staffordshire'),
(4064, 222, 'Stirling', 'Stirling'),
(4065, 222, 'Suffolk', 'Suffolk'),
(4066, 222, 'Surrey', 'Surrey'),
(4067, 222, 'Swansea', 'Swansea'),
(4068, 222, 'Torfaen', 'Torfaen'),
(4069, 222, 'Tyne and Wear', 'Tyne and Wear'),
(4070, 222, 'Vale of Glamorgan', 'Vale of Glamorgan'),
(4071, 222, 'Warwickshire', 'Warwickshire'),
(4072, 222, 'West Dunbartonshire', 'West Dunbartonshire'),
(4073, 222, 'West Lothian', 'West Lothian'),
(4074, 222, 'West Midlands', 'West Midlands'),
(4075, 222, 'West Sussex', 'West Sussex'),
(4076, 222, 'West Yorkshire', 'West Yorkshire'),
(4077, 222, 'Western Isles', 'Western Isles'),
(4078, 222, 'Wiltshire', 'Wiltshire'),
(4079, 222, 'Worcestershire', 'Worcestershire'),
(4080, 222, 'Wrexham', 'Wrexham'),
(4081, 223, 'AL', 'Alabama'),
(4082, 223, 'AK', 'Alaska'),
(4083, 223, 'AS', 'American Samoa'),
(4084, 223, 'AZ', 'Arizona'),
(4085, 223, 'AR', 'Arkansas'),
(4086, 223, 'AF', 'Armed Forces Africa'),
(4087, 223, 'AA', 'Armed Forces Americas'),
(4088, 223, 'AC', 'Armed Forces Canada'),
(4089, 223, 'AE', 'Armed Forces Europe'),
(4090, 223, 'AM', 'Armed Forces Middle East'),
(4091, 223, 'AP', 'Armed Forces Pacific'),
(4092, 223, 'CA', 'California'),
(4093, 223, 'CO', 'Colorado'),
(4094, 223, 'CT', 'Connecticut'),
(4095, 223, 'DE', 'Delaware'),
(4096, 223, 'DC', 'District of Columbia'),
(4097, 223, 'FM', 'Federated States Of Micronesia'),
(4098, 223, 'FL', 'Florida'),
(4099, 223, 'GA', 'Georgia'),
(4100, 223, 'GU', 'Guam'),
(4101, 223, 'HI', 'Hawaii'),
(4102, 223, 'ID', 'Idaho'),
(4103, 223, 'IL', 'Illinois'),
(4104, 223, 'IN', 'Indiana'),
(4105, 223, 'IA', 'Iowa'),
(4106, 223, 'KS', 'Kansas'),
(4107, 223, 'KY', 'Kentucky'),
(4108, 223, 'LA', 'Louisiana'),
(4109, 223, 'ME', 'Maine'),
(4110, 223, 'MH', 'Marshall Islands'),
(4111, 223, 'MD', 'Maryland'),
(4112, 223, 'MA', 'Massachusetts'),
(4113, 223, 'MI', 'Michigan'),
(4114, 223, 'MN', 'Minnesota'),
(4115, 223, 'MS', 'Mississippi'),
(4116, 223, 'MO', 'Missouri'),
(4117, 223, 'MT', 'Montana'),
(4118, 223, 'NE', 'Nebraska'),
(4119, 223, 'NV', 'Nevada'),
(4120, 223, 'NH', 'New Hampshire'),
(4121, 223, 'NJ', 'New Jersey'),
(4122, 223, 'NM', 'New Mexico'),
(4123, 223, 'NY', 'New York'),
(4124, 223, 'NC', 'North Carolina'),
(4125, 223, 'ND', 'North Dakota'),
(4126, 223, 'MP', 'Northern Mariana Islands'),
(4127, 223, 'OH', 'Ohio'),
(4128, 223, 'OK', 'Oklahoma'),
(4129, 223, 'OR', 'Oregon'),
(4130, 223, 'PW', 'Palau'),
(4131, 223, 'PA', 'Pennsylvania'),
(4132, 223, 'PR', 'Puerto Rico'),
(4133, 223, 'RI', 'Rhode Island'),
(4134, 223, 'SC', 'South Carolina'),
(4135, 223, 'SD', 'South Dakota'),
(4136, 223, 'TN', 'Tennessee'),
(4137, 223, 'TX', 'Texas'),
(4138, 223, 'UT', 'Utah'),
(4139, 223, 'VT', 'Vermont'),
(4140, 223, 'VI', 'Virgin Islands'),
(4141, 223, 'VA', 'Virginia'),
(4142, 223, 'WA', 'Washington'),
(4143, 223, 'WV', 'West Virginia'),
(4144, 223, 'WI', 'Wisconsin'),
(4145, 223, 'WY', 'Wyoming'),
(4146, 224, 'BI', 'Baker Island'),
(4147, 224, 'HI', 'Howland Island'),
(4148, 224, 'JI', 'Jarvis Island'),
(4149, 224, 'JA', 'Johnston Atoll'),
(4150, 224, 'KR', 'Kingman Reef'),
(4151, 224, 'MA', 'Midway Atoll'),
(4152, 224, 'NI', 'Navassa Island'),
(4153, 224, 'PA', 'Palmyra Atoll'),
(4154, 224, 'WI', 'Wake Island'),
(4155, 225, 'AR', 'Artigas'),
(4156, 225, 'CA', 'Canelones'),
(4157, 225, 'CL', 'Cerro Largo'),
(4158, 225, 'CO', 'Colonia'),
(4159, 225, 'DU', 'Durazno'),
(4160, 225, 'FS', 'Flores'),
(4161, 225, 'FA', 'Florida'),
(4162, 225, 'LA', 'Lavalleja'),
(4163, 225, 'MA', 'Maldonado'),
(4164, 225, 'MO', 'Montevideo'),
(4165, 225, 'PA', 'Paysandu'),
(4166, 225, 'RN', 'Rio Negro'),
(4167, 225, 'RV', 'Rivera'),
(4168, 225, 'RO', 'Rocha'),
(4169, 225, 'SL', 'Salto'),
(4170, 225, 'SJ', 'San Jose'),
(4171, 225, 'SO', 'Soriano'),
(4172, 225, 'TA', 'Tacuarembo'),
(4173, 225, 'TT', 'Treinta y Tres'),
(4174, 226, 'AN', 'Andijon'),
(4175, 226, 'BU', 'Buxoro'),
(4176, 226, 'FA', 'Farg''ona'),
(4177, 226, 'JI', 'Jizzax'),
(4178, 226, 'NG', 'Namangan'),
(4179, 226, 'NW', 'Navoiy'),
(4180, 226, 'QA', 'Qashqadaryo'),
(4181, 226, 'QR', 'Qoraqalpog''iston Republikasi'),
(4182, 226, 'SA', 'Samarqand'),
(4183, 226, 'SI', 'Sirdaryo'),
(4184, 226, 'SU', 'Surxondaryo'),
(4185, 226, 'TK', 'Toshkent City'),
(4186, 226, 'TO', 'Toshkent Region'),
(4187, 226, 'XO', 'Xorazm'),
(4188, 227, 'MA', 'Malampa'),
(4189, 227, 'PE', 'Penama'),
(4190, 227, 'SA', 'Sanma'),
(4191, 227, 'SH', 'Shefa'),
(4192, 227, 'TA', 'Tafea'),
(4193, 227, 'TO', 'Torba'),
(4194, 229, 'AM', 'Amazonas'),
(4195, 229, 'AN', 'Anzoategui'),
(4196, 229, 'AP', 'Apure'),
(4197, 229, 'AR', 'Aragua'),
(4198, 229, 'BA', 'Barinas'),
(4199, 229, 'BO', 'Bolivar'),
(4200, 229, 'CA', 'Carabobo'),
(4201, 229, 'CO', 'Cojedes'),
(4202, 229, 'DA', 'Delta Amacuro'),
(4203, 229, 'DF', 'Dependencias Federales'),
(4204, 229, 'DI', 'Distrito Federal'),
(4205, 229, 'FA', 'Falcon'),
(4206, 229, 'GU', 'Guarico'),
(4207, 229, 'LA', 'Lara'),
(4208, 229, 'ME', 'Merida'),
(4209, 229, 'MI', 'Miranda'),
(4210, 229, 'MO', 'Monagas'),
(4211, 229, 'NE', 'Nueva Esparta'),
(4212, 229, 'PO', 'Portuguesa'),
(4213, 229, 'SU', 'Sucre'),
(4214, 229, 'TA', 'Tachira'),
(4215, 229, 'TR', 'Trujillo'),
(4216, 229, 'VA', 'Vargas'),
(4217, 229, 'YA', 'Yaracuy'),
(4218, 229, 'ZU', 'Zulia'),
(4219, 230, 'AG', 'An Giang'),
(4220, 230, 'BG', 'Bac Giang'),
(4221, 230, 'BK', 'Bac Kan'),
(4222, 230, 'BL', 'Bac Lieu'),
(4223, 230, 'BC', 'Bac Ninh'),
(4224, 230, 'BR', 'Ba Ria-Vung Tau'),
(4225, 230, 'BN', 'Ben Tre'),
(4226, 230, 'BH', 'Binh Dinh'),
(4227, 230, 'BU', 'Binh Duong'),
(4228, 230, 'BP', 'Binh Phuoc'),
(4229, 230, 'BT', 'Binh Thuan'),
(4230, 230, 'CM', 'Ca Mau'),
(4231, 230, 'CT', 'Can Tho'),
(4232, 230, 'CB', 'Cao Bang'),
(4233, 230, 'DL', 'Dak Lak'),
(4234, 230, 'DG', 'Dak Nong'),
(4235, 230, 'DN', 'Da Nang'),
(4236, 230, 'DB', 'Dien Bien'),
(4237, 230, 'DI', 'Dong Nai'),
(4238, 230, 'DT', 'Dong Thap'),
(4239, 230, 'GL', 'Gia Lai'),
(4240, 230, 'HG', 'Ha Giang'),
(4241, 230, 'HD', 'Hai Duong'),
(4242, 230, 'HP', 'Hai Phong'),
(4243, 230, 'HM', 'Ha Nam'),
(4244, 230, 'HI', 'Ha Noi'),
(4245, 230, 'HT', 'Ha Tay'),
(4246, 230, 'HH', 'Ha Tinh'),
(4247, 230, 'HB', 'Hoa Binh'),
(4248, 230, 'HC', 'Ho Chin Minh'),
(4249, 230, 'HU', 'Hau Giang'),
(4250, 230, 'HY', 'Hung Yen'),
(4251, 232, 'C', 'Saint Croix'),
(4252, 232, 'J', 'Saint John'),
(4253, 232, 'T', 'Saint Thomas'),
(4254, 233, 'A', 'Alo'),
(4255, 233, 'S', 'Sigave'),
(4256, 233, 'W', 'Wallis'),
(4257, 235, 'AB', 'Abyan'),
(4258, 235, 'AD', 'Adan'),
(4259, 235, 'AM', 'Amran'),
(4260, 235, 'BA', 'Al Bayda'),
(4261, 235, 'DA', 'Ad Dali'),
(4262, 235, 'DH', 'Dhamar'),
(4263, 235, 'HD', 'Hadramawt'),
(4264, 235, 'HJ', 'Hajjah'),
(4265, 235, 'HU', 'Al Hudaydah'),
(4266, 235, 'IB', 'Ibb'),
(4267, 235, 'JA', 'Al Jawf'),
(4268, 235, 'LA', 'Lahij'),
(4269, 235, 'MA', 'Ma''rib'),
(4270, 235, 'MR', 'Al Mahrah'),
(4271, 235, 'MW', 'Al Mahwit'),
(4272, 235, 'SD', 'Sa''dah'),
(4273, 235, 'SN', 'San''a'),
(4274, 235, 'SH', 'Shabwah'),
(4275, 235, 'TA', 'Ta''izz'),
(4276, 236, 'KOS', 'Kosovo'),
(4277, 236, 'MON', 'Montenegro'),
(4278, 236, 'SER', 'Serbia'),
(4279, 236, 'VOJ', 'Vojvodina'),
(4280, 237, 'BC', 'Bas-Congo'),
(4281, 237, 'BN', 'Bandundu'),
(4282, 237, 'EQ', 'Equateur'),
(4283, 237, 'KA', 'Katanga'),
(4284, 237, 'KE', 'Kasai-Oriental'),
(4285, 237, 'KN', 'Kinshasa'),
(4286, 237, 'KW', 'Kasai-Occidental'),
(4287, 237, 'MA', 'Maniema'),
(4288, 237, 'NK', 'Nord-Kivu'),
(4289, 237, 'OR', 'Orientale'),
(4290, 237, 'SK', 'Sud-Kivu'),
(4291, 238, 'CE', 'Central'),
(4292, 238, 'CB', 'Copperbelt'),
(4293, 238, 'EA', 'Eastern'),
(4294, 238, 'LP', 'Luapula'),
(4295, 238, 'LK', 'Lusaka'),
(4296, 238, 'NO', 'Northern'),
(4297, 238, 'NW', 'North-Western'),
(4298, 238, 'SO', 'Southern'),
(4299, 238, 'WE', 'Western'),
(4300, 239, 'BU', 'Bulawayo'),
(4301, 239, 'HA', 'Harare'),
(4302, 239, 'ML', 'Manicaland'),
(4303, 239, 'MC', 'Mashonaland Central'),
(4304, 239, 'ME', 'Mashonaland East'),
(4305, 239, 'MW', 'Mashonaland West'),
(4306, 239, 'MV', 'Masvingo'),
(4307, 239, 'MN', 'Matabeleland North'),
(4308, 239, 'MS', 'Matabeleland South'),
(4309, 239, 'MD', 'Midlands'),
(4310, 222, 'Antrim', 'Antrim'),
(4311, 222, 'Armagh', 'Armagh'),
(4312, 222, 'Down', 'Down'),
(4313, 222, 'Fermanagh', 'Fermanagh'),
(4314, 222, 'Londonderry', 'Londonderry'),
(4315, 222, 'Tyrone', 'Tyrone');

-- --------------------------------------------------------

--
-- Table structure for table `zones_to_geo_zones`
--

CREATE TABLE `zones_to_geo_zones` (
  `association_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_country_id` int(11) NOT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `geo_zone_id` int(11) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`association_id`),
  KEY `idx_zones_to_geo_zones_country_id` (`zone_country_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `zones_to_geo_zones`
--

INSERT INTO `zones_to_geo_zones` VALUES
(1, 223, 18, 1, NULL, '[[regtime]]');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
