<?php if ( ! defined( 'ABS_PATH' ) ) {
	exit( 'ABS_PATH is not loaded. Direct access is not allowed.' );
}

/*
 * Copyright 2020 OsclassPoint.com
 *
 * Osclass maintained & developed by OsclassPoint.com
 * you may not use this file except in compliance with the License.
 * You may download copy of Osclass at
 *
 *     https://osclass-classifieds.com/download
 *
 * Software is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 */


/**
 * LastestSearches DAO
 */
class LatestSearches extends DAO
{
  /**
   *
   * @var type
   */
  private static $instance;

  /**
   * @return \LatestSearches|\type
   */
  public static function newInstance()
  {
    if( !self::$instance instanceof self ) {
      self::$instance = new self;
    }
    return self::$instance;
  }

  /**
   *
   */
  public function __construct()
  {
    parent::__construct();
    $this->setTableName('t_latest_searches');
    $array_fields = array(
      'd_date',
      's_search'
    );
    $this->setFields($array_fields);
  }

  /**
   * Get last searches, given a limit.
   *
   * @access public
   * @since unknown
   *
   * @param int $limit
   *
   * @return array|bool
   */
  public function getSearches($limit = 20)
  {
    $this->dao->select('d_date, s_search, COUNT(s_search) as i_total');
    $this->dao->from($this->getTableName());
    $this->dao->groupBy('s_search');
    $this->dao->orderBy('d_date', 'DESC');
    $this->dao->limit($limit);
    $result = $this->dao->get();

    if( $result == false ) {
      return false;
    }

    return $result->result();
  }

  /**
   * Get last searches, given since time.
   *
   * @access public
   * @since unknown
   *
   * @param int $time
   *
   * @return array|bool
   */
  public function getSearchesByDate($time = null)
  {
    if($time==null) { $time = time() - (7*24*3600); }

    $this->dao->select('d_date, s_search, COUNT(s_search) as i_total');
    $this->dao->from($this->getTableName());
    $this->dao->where('d_date', date('Y-m-d H:i:s', $time));
    $this->dao->groupBy('s_search');
    $this->dao->orderBy('d_date', 'DESC');
    $this->dao->limit($limit);
    $result = $this->dao->get();

    if( $result == false ) {
      return false;
    }

    return $result->result();
  }

  /**
   * Purge all searches by date.
   *
   * @access public
   * @since unknown
   * @param string $date
   * @return bool
   */
  public function purgeDate($date = null)
  {
    if($date == null) {
      return false;
    }

    $this->dao->from( $this->getTableName() );
    $this->dao->where( 'd_date <= ' . $this->dao->escape($date) );
    return $this->dao->delete();
  }

  /**
   * Purge n last searches.
   *
   * @access public
   * @since unknown
   * @param int $number
   * @return bool
   */
  public function purgeNumber($number = null) {
    if( $number == null ) {
      return false;
    }

    $this->dao->select('d_date');
    $this->dao->from($this->getTableName());
    $this->dao->groupBy('s_search');
    $this->dao->orderBy('d_date', 'DESC');
    $this->dao->limit($number, 1);
    $result = $this->dao->get();
    $last   = $result->row();

    if( $result == false ) {
      return false;
    }

    if( $result->numRows() == 0 ) {
      return false;
    }

    return $this->purgeDate( $last['d_date'] );
  }
}

/* file end: ./oc-includes/osclass/model/LatestSearches.php */