
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `eshop270`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]access`
--

CREATE TABLE `[[dbprefix]]access` (
  `id_access` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_role` int(10) unsigned NOT NULL,
  `access` varchar(100) NOT NULL,
  PRIMARY KEY (`id_access`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]access`
--

INSERT INTO `[[dbprefix]]access` VALUES
(1, 10, '*.*'),
(2, 1, 'profile.*'),
(3, 1, 'stats.user'),
(8, 1, 'support.*'),
(4, 5, 'translations.*'),
(5, 5, 'profile.*'),
(6, 5, 'stats.user'),
(7, 5, 'content.*');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]affiliates`
--

CREATE TABLE `[[dbprefix]]affiliates` (
  `id_affiliate` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `id_order` int(10) unsigned NOT NULL,
  `id_order_payment` int(10) unsigned DEFAULT NULL,
  `id_product` int(10) unsigned NOT NULL,
  `percentage` decimal(14,3) NOT NULL DEFAULT '0.000',
  `amount` decimal(14,3) NOT NULL DEFAULT '0.000',
  `currency` char(3) NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_to_pay` datetime DEFAULT NULL,
  `date_paid` datetime DEFAULT NULL,
  `ip_address` bigint(20) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY USING BTREE (`id_affiliate`),
  KEY `[[dbprefix]]affiliates_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]affiliates_IK_id_order` (`id_order`),
  KEY `[[dbprefix]]affiliates_IK_id_product` (`id_product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `id_category` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(145) NOT NULL,
  `order` int(2) unsigned NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id_category_parent` int(10) unsigned NOT NULL DEFAULT '0',
  `parent_deep` int(2) unsigned NOT NULL DEFAULT '0',
  `seoname` varchar(145) NOT NULL,
  `description` text,
  `last_modified` datetime DEFAULT NULL,
  `has_image` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY USING BTREE (`id_category`),
  UNIQUE KEY `[[dbprefix]]categories_UK_seo_name` (`seoname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, 'Home category', 0, '[[regtime]]', 0, 0, 'all', 'root category', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `group_name` varchar(128) NOT NULL,
  `config_key` varchar(128) NOT NULL,
  `config_value` longtext,
  PRIMARY KEY (`config_key`),
  UNIQUE KEY `[[dbprefix]]config_IK_group_name_AND_config_key` (`group_name`,`config_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('appearance', 'theme', 'default'),
('appearance', 'theme_mobile', ''),
('appearance', 'allow_query_theme', '0'),
('appearance', 'custom_css', '0'),
('appearance', 'custom_css_version', '0'),
('i18n', 'charset', 'utf-8'),
('i18n', 'timezone', 'America/New_York'),
('i18n', 'locale', '[[language]]'),
('i18n', 'allow_query_language', '0'),
('payment', 'thanks_page', ''),
('payment', 'sandbox', '0'),
('payment', 'paypal_account', ''),
('payment', 'paymill_private', ''),
('payment', 'paymill_public', ''),
('payment', 'stripe_private', ''),
('payment', 'stripe_public', ''),
('payment', 'stripe_address', '0'),
('payment', 'stripe_alipay', '0'),
('payment', 'stripe_3d_secure', '0'),
('payment', 'alternative', ''),
('payment', 'bitpay_apikey', ''),
('payment', 'authorize_sandbox', '0'),
('payment', 'authorize_login', ''),
('payment', 'authorize_key', ''),
('payment', 'twocheckout_sid', ''),
('payment', 'twocheckout_secretword', ''),
('payment', 'twocheckout_sandbox', '0'),
('payment', 'fraudlabspro', ''),
('payment', 'paysbuy', ''),
('payment', 'paysbuy_sandbox', '0'),
('payment', 'mercadopago_client_id', ''),
('payment', 'mercadopago_client_secret', ''),
('general', 'api_key', '[[api_key]]'),
('general', 'number_format', '%n'),
('general', 'date_format', 'd-m-y'),
('general', 'base_url', '[[softurl]]/'),
('general', 'maintenance', '0'),
('general', 'private_site', '0'),
('general', 'private_site_page', ''),
('general', 'analytics', ''),
('general', 'translate', ''),
('general', 'menu', ''),
('general', 'feed_elements', '20'),
('general', 'site_name', '[[site_name]]'),
('general', 'site_description', ''),
('general', 'products_per_page', '12'),
('general', 'akismet_key', ''),
('general', 'alert_terms', ''),
('general', 'landing_page', ''),
('general', 'blog', '0'),
('general', 'blog_disqus', ''),
('general', 'faq', '0'),
('general', 'faq_disqus', ''),
('general', 'forums', '0'),
('general', 'minify', '0'),
('general', 'sort_by', 'published-asc'),
('general', 'ocacu', '0'),
('general', 'banned_words_replacement', 'xxx'),
('general', 'banned_words', ''),
('general', 'disallowbots', '0'),
('general', 'html_head', ''),
('general', 'html_footer', ''),
('general', 'eu_vat', '0'),
('general', 'vat_number', ''),
('general', 'company_name', ''),
('general', 'vat_excluded_countries', ''),
('general', 'cookie_consent', '0'),
('general', 'captcha', ''),
('general', 'recaptcha_active', ''),
('general', 'recaptcha_secretkey', ''),
('general', 'recaptcha_sitekey', ''),
('general', 'cron', '1'),
('general', 'google_authenticator', '0'),
('image', 'allowed_formats', 'jpeg,jpg,png,'),
('image', 'max_image_size', '5'),
('image', 'height', ''),
('image', 'width', '1200'),
('image', 'height_thumb', '200'),
('image', 'width_thumb', '200'),
('image', 'quality', '90'),
('image', 'watermark', '0'),
('image', 'watermark_path', ''),
('image', 'watermark_position', '0'),
('image', 'aws_s3_active', '0'),
('image', 'aws_access_key', ''),
('image', 'aws_secret_key', ''),
('image', 'aws_s3_bucket', ''),
('image', 'aws_s3_domain', ''),
('product', 'formats', 'txt,doc,docx,pdf,tif,tiff,gif,psd,raw,wav,aif,mp3,rm,ram,wma,ogg,avi,wmv,mov,mp4,mkv,jpeg,jpg,png,zip,7z,7zip,rar,rar5,gzip,'),
('product', 'max_size', '5'),
('product', 'num_images', '5'),
('product', 'products_in_home', '0'),
('product', 'disqus', ''),
('product', 'related', '5'),
('product', 'reviews', '0'),
('product', 'demo_theme', 'yeti'),
('product', 'demo_resize', '1'),
('product', 'download_hours', '72'),
('product', 'download_times', '3'),
('product', 'number_of_orders', '0'),
('product', 'qr_code', '0'),
('product', 'count_visits', '1'),
('email', 'notify_email', '[[admin_email]]'),
('email', 'notify_name', 'no-reply [[site_name]]'),
('email', 'new_sale_notify', '0'),
('email', 'smtp_active', '0'),
('email', 'smtp_host', ''),
('email', 'smtp_port', ''),
('email', 'smtp_auth', '0'),
('email', 'smtp_secure', ''),
('email', 'smtp_user', ''),
('email', 'smtp_pass', ''),
('email', 'elastic_active', '0'),
('email', 'elastic_username', ''),
('email', 'elastic_password', ''),
('email', 'elastic_listname', ''),
('affiliate', 'active', '0'),
('affiliate', 'cookie', '90'),
('affiliate', 'payment_days', '30'),
('affiliate', 'payment_min', '50'),
('affiliate', 'tos', ''),
('social', 'config', '{"debug_mode":"0","providers":{"OpenID":{"enabled":"0"},"Yahoo":{"enabled":"0","keys":{"key":"","secret":""}},\n"AOL":{"enabled":"0"},"Google":{"enabled":"0","keys":{"id":"","secret":""}},"Facebook":{"enabled":"0","keys":{"id":"","secret":""}},\n"Twitter":{"enabled":"0","keys":{"key":"","secret":""}},"Live":{"enabled":"0","keys":{"id":"","secret":""}},"MySpace":{"enabled":"0","keys":{"key":"","secret":""}},\n"LinkedIn":{"enabled":"0","keys":{"key":"","secret":""}},"Foursquare":{"enabled":"0","keys":{"id":"","secret":""}}},"base_url":"","debug_file":""}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content`
--

CREATE TABLE `[[dbprefix]]content` (
  `id_content` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `locale` varchar(8) NOT NULL DEFAULT 'en_US',
  `order` int(2) unsigned NOT NULL DEFAULT '0',
  `title` varchar(145) NOT NULL,
  `seotitle` varchar(145) NOT NULL,
  `description` longtext,
  `from_email` varchar(145) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` enum('page','email','help') NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_content`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `[[dbprefix]]content`
--

INSERT INTO `[[dbprefix]]content` VALUES
(1, 'en_US', 0, 'Change Password [SITE.NAME]', 'auth-remember', 'Hello [USER.NAME],\n\nFollow this link  [URL.QL]\n\nThanks!!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(2, 'en_US', 0, 'Welcome to [SITE.NAME]!', 'auth-register', 'Welcome [USER.NAME],\n\nWe are really happy that you have joined us! [URL.QL]\n\nRemember your user details:\nEmail: [USER.EMAIL]\nPassword: [USER.PWD]\n\nWe do not have your original password anymore.\n\nRegards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(3, 'en_US', 0, '[EMAIL.SENDER] wants to contact you!', 'contact-admin', 'Hello Admin,\n\n [EMAIL.SENDER]: [EMAIL.FROM], have a message for you:\n\n [EMAIL.SUBJECT]\n\n [EMAIL.BODY] \n\n Regards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(4, 'en_US', 0, 'New reply: [TITLE]', 'new-reply', '[URL.QL]\n\n[DESCRIPTION]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(5, 'en_US', 0, 'Purchase Receipt for [PRODUCT.TITLE]', 'new-sale', '==== Order Details ====\nDate: [DATE]\nOrder ID: [ORDER.ID]\nName: [USER.NAME]\nEmail: [USER.EMAIL]\n\n==== Your Order ====\nProduct: [PRODUCT.TITLE]\nProduct Price: [PRODUCT.PRICE]\n\n[PRODUCT.NOTES][DOWNLOAD][EXPIRE][LICENSE]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(6, 'en_US', 0, 'Product updated [TITLE]', 'product-update', '==== Update Details ====\nVersion: [VERSION]\nProduct name: [TITLE][DOWNLOAD][EXPIRE]\n\n==== Product Page ====\n[URL.PRODUCT]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(7, 'en_US', 0, 'Ticket assigned to you: [TITLE]', 'assign-agent', '[URL.QL]\n\n[DESCRIPTION]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(8, 'en_US', 0, 'New review for [TITLE] [RATE]', 'review-product', '[URL.QL]\n\n[RATE]\n\n[DESCRIPTION]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(9, 'en_US', 0, 'New support ticket created `[TITLE]`', 'new-ticket', 'We have received your support inquiry. We will try to answer you within the next 24 working hours, thank you for your patience.\n\n[URL.QL]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(10, 'en_US', 0, 'Congratulations! New affiliate commission [AMOUNT]', 'affiliate-commission', 'Congratulations!,\n\n We just registered a sale from your affiliate link for the amount of [AMOUNT], check them all at your affiliate panel [URL.AFF]. \n\n Thanks for using our affiliate program!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(11, 'en_US', 0, 'Password Changed [SITE.NAME]', 'password-changed', 'Hello [USER.NAME],\n\nYour password has been changed.\n\nThese are now your user details:\nEmail: [USER.EMAIL]\nPassword: [USER.PWD]\n\nWe do not have your original password anymore.\n\nRegards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(12, 'en_US', 0, 'Receipt for [ORDER.DESC] #[ORDER.ID]', 'new-order', 'Hello [USER.NAME],Thanks for buying [ORDER.DESC].\n\nPlease complete the payment here [URL.CHECKOUT]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(13, 'en_US', 0, 'There is a new reply on the forum', 'new-forum-answer', 'There is a new reply on a forum post where you participated.<br><br><a target="_blank" href="[FORUM.LINK]">Check it here</a><br><br>[FORUM.LINK]<br>', '[[admin_email]]', '[[regtime]]', 'email', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]coupons`
--

CREATE TABLE `[[dbprefix]]coupons` (
  `id_coupon` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_product` int(10) unsigned DEFAULT NULL,
  `name` varchar(145) NOT NULL,
  `notes` varchar(245) DEFAULT NULL,
  `discount_amount` decimal(14,3) NOT NULL DEFAULT '0.000',
  `discount_percentage` decimal(14,3) NOT NULL DEFAULT '0.000',
  `number_coupons` int(10) DEFAULT NULL,
  `valid_date` datetime DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_coupon`),
  UNIQUE KEY `[[dbprefix]]coupons_UK_name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]crontab`
--

CREATE TABLE `[[dbprefix]]crontab` (
  `id_crontab` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` varchar(50) NOT NULL,
  `callback` varchar(140) NOT NULL,
  `params` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_started` datetime DEFAULT NULL,
  `date_finished` datetime DEFAULT NULL,
  `date_next` datetime DEFAULT NULL,
  `times_executed` bigint(20) DEFAULT '0',
  `output` varchar(50) DEFAULT NULL,
  `running` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_crontab`),
  UNIQUE KEY `[[dbprefix]]crontab_UK_name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]crontab`
--

INSERT INTO `[[dbprefix]]crontab` VALUES
(1, 'Sitemap', '0 3 * * *', 'Sitemap::generate', NULL, 'Regenerates the sitemap everyday at 3am', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(2, 'Clean Cache', '0 5 * * *', 'Core::delete_cache', NULL, 'Once day force to flush all the cache.', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(3, 'Optimize DB', '0 4 1 * *', 'Core::optimize_db', NULL, 'once a month we optimize the DB', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(4, 'Unpaid Orders', '0 7 * * *', 'Cron_Order::unpaid', NULL, 'Notify by email unpaid orders 2 days after was created', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]downloads`
--

CREATE TABLE `[[dbprefix]]downloads` (
  `id_download` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_order` int(10) unsigned NOT NULL,
  `id_user` int(10) unsigned NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip_address` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id_download`),
  KEY `[[dbprefix]]downloads_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]downloads_IK_id_order` (`id_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forums`
--

CREATE TABLE `[[dbprefix]]forums` (
  `id_forum` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(145) NOT NULL,
  `order` int(2) unsigned NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id_forum_parent` int(10) unsigned NOT NULL DEFAULT '0',
  `parent_deep` int(2) unsigned NOT NULL DEFAULT '0',
  `seoname` varchar(145) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY USING BTREE (`id_forum`),
  UNIQUE KEY `[[dbprefix]]forums_UK_seo_name` (`seoname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]licenses`
--

CREATE TABLE `[[dbprefix]]licenses` (
  `id_license` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_product` int(10) unsigned NOT NULL,
  `id_user` int(10) unsigned NOT NULL,
  `id_order` int(10) unsigned NOT NULL,
  `license` varchar(40) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `device_id` varchar(255) DEFAULT NULL,
  `ip_address` bigint(20) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active_date` datetime DEFAULT NULL,
  `valid_date` datetime DEFAULT NULL,
  `license_check_date` datetime DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_license`),
  UNIQUE KEY `[[dbprefix]]licenses_UK_license` (`license`),
  KEY `[[dbprefix]]licenses_IK_id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders`
--

CREATE TABLE `[[dbprefix]]orders` (
  `id_order` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `id_product` int(10) unsigned DEFAULT NULL,
  `id_coupon` int(10) unsigned DEFAULT NULL,
  `paymethod` varchar(20) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `currency` char(3) NOT NULL,
  `amount` decimal(14,3) NOT NULL DEFAULT '0.000',
  `amount_net` decimal(14,3) NOT NULL DEFAULT '0.000',
  `gateway_fee` decimal(14,3) NOT NULL DEFAULT '0.000',
  `ip_address` bigint(20) DEFAULT NULL,
  `txn_id` varchar(255) DEFAULT NULL,
  `pay_date` datetime DEFAULT NULL,
  `support_date` datetime DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `notes` varchar(245) DEFAULT NULL,
  `VAT` decimal(14,3) NOT NULL DEFAULT '0.000',
  `VAT_amount` decimal(14,3) NOT NULL DEFAULT '0.000',
  `VAT_number` varchar(65) DEFAULT NULL,
  `country` varchar(3) DEFAULT NULL,
  `city` varchar(65) DEFAULT NULL,
  `postal_code` varchar(20) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id_order`),
  KEY `[[dbprefix]]orders_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]orders_IK_status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]posts`
--

CREATE TABLE `[[dbprefix]]posts` (
  `id_post` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `id_post_parent` int(10) unsigned DEFAULT NULL,
  `id_forum` int(10) unsigned DEFAULT NULL,
  `title` varchar(245) NOT NULL,
  `seotitle` varchar(245) NOT NULL,
  `description` longtext NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip_address` bigint(20) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY USING BTREE (`id_post`),
  UNIQUE KEY `[[dbprefix]]posts_UK_seotitle` (`seotitle`),
  KEY `[[dbprefix]]posts_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]posts_IK_id_post_parent` (`id_post_parent`),
  KEY `[[dbprefix]]posts_IK_id_forum` (`id_forum`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products`
--

CREATE TABLE `[[dbprefix]]products` (
  `id_product` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned DEFAULT NULL,
  `id_category` int(10) unsigned DEFAULT NULL,
  `title` varchar(145) NOT NULL,
  `seotitle` varchar(145) NOT NULL,
  `skins` varchar(245) NOT NULL,
  `url_demo` varchar(145) NOT NULL,
  `url_buy` varchar(245) DEFAULT NULL,
  `description` text NOT NULL,
  `email_purchase_notes` text NOT NULL,
  `version` varchar(10) NOT NULL,
  `currency` char(3) NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `price_offer` decimal(10,2) NOT NULL DEFAULT '0.00',
  `offer_valid` datetime DEFAULT NULL,
  `featured` datetime DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated` datetime DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `has_images` tinyint(1) NOT NULL DEFAULT '0',
  `file_name` varchar(40) DEFAULT NULL,
  `support_days` int(10) NOT NULL DEFAULT '0',
  `licenses` int(10) NOT NULL DEFAULT '1',
  `license_days` int(10) NOT NULL DEFAULT '0',
  `rate` float(4,2) DEFAULT NULL,
  `affiliate_percentage` decimal(14,3) NOT NULL DEFAULT '0.000',
  PRIMARY KEY (`id_product`),
  KEY `[[dbprefix]]products_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]products_IK_id_category` (`id_category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reviews`
--

CREATE TABLE `[[dbprefix]]reviews` (
  `id_review` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `id_order` int(10) unsigned NOT NULL,
  `id_product` int(10) unsigned NOT NULL,
  `rate` int(2) unsigned NOT NULL DEFAULT '0',
  `description` varchar(1000) NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip_address` bigint(20) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY USING BTREE (`id_review`),
  KEY `[[dbprefix]]reviews_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]reviews_IK_id_order` (`id_order`),
  KEY `[[dbprefix]]reviews_IK_id_product` (`id_product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]roles`
--

CREATE TABLE `[[dbprefix]]roles` (
  `id_role` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `description` varchar(245) DEFAULT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_role`),
  UNIQUE KEY `[[dbprefix]]roles_UK_name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]roles`
--

INSERT INTO `[[dbprefix]]roles` VALUES
(1, 'user', 'Normal user', '[[regtime]]'),
(5, 'translator', 'User + Translations', '[[regtime]]'),
(10, 'admin', 'Full access', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tickets`
--

CREATE TABLE `[[dbprefix]]tickets` (
  `id_ticket` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_ticket_parent` int(10) unsigned DEFAULT NULL,
  `id_product` int(10) unsigned NOT NULL,
  `id_order` int(10) unsigned NOT NULL,
  `id_user` int(10) unsigned NOT NULL,
  `id_user_support` int(10) unsigned DEFAULT NULL,
  `title` varchar(145) NOT NULL,
  `description` text NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `read_date` datetime DEFAULT NULL,
  `ip_address` bigint(20) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_ticket`),
  KEY `[[dbprefix]]tickets_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]tickets_IK_id_ticket_parent` (`id_ticket_parent`),
  KEY `[[dbprefix]]tickets_IK_id_product` (`id_product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id_user` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(145) DEFAULT NULL,
  `seoname` varchar(145) DEFAULT NULL,
  `email` varchar(145) NOT NULL,
  `paypal_email` varchar(145) DEFAULT NULL,
  `password` varchar(64) NOT NULL,
  `description` text,
  `status` int(1) NOT NULL DEFAULT '0',
  `id_role` int(10) unsigned DEFAULT '1',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_modified` datetime DEFAULT NULL,
  `logins` int(10) unsigned NOT NULL DEFAULT '0',
  `last_login` datetime DEFAULT NULL,
  `last_ip` bigint(20) DEFAULT NULL,
  `user_agent` varchar(40) DEFAULT NULL,
  `token` varchar(40) DEFAULT NULL,
  `token_created` datetime DEFAULT NULL,
  `token_expires` datetime DEFAULT NULL,
  `api_token` varchar(40) DEFAULT NULL,
  `hybridauth_provider_name` varchar(40) DEFAULT NULL,
  `hybridauth_provider_uid` varchar(245) DEFAULT NULL,
  `signature` varchar(245) DEFAULT NULL,
  `subscriber` tinyint(1) NOT NULL DEFAULT '1',
  `has_image` tinyint(1) NOT NULL DEFAULT '0',
  `failed_attempts` int(10) unsigned NOT NULL DEFAULT '0',
  `last_failed` datetime DEFAULT NULL,
  `VAT_number` varchar(65) DEFAULT NULL,
  `country` varchar(3) DEFAULT NULL,
  `city` varchar(65) DEFAULT NULL,
  `postal_code` varchar(20) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  `google_authenticator` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id_user`),
  UNIQUE KEY `[[dbprefix]]users_UK_email` (`email`),
  UNIQUE KEY `[[dbprefix]]users_UK_token` (`token`),
  UNIQUE KEY `[[dbprefix]]users_UK_api_token` (`api_token`),
  UNIQUE KEY `[[dbprefix]]users_UK_seoname` (`seoname`),
  UNIQUE KEY `[[dbprefix]]users_UK_provider_AND_uid` (`hybridauth_provider_name`,`hybridauth_provider_uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', 'admin', '[[admin_email]]', NULL, '[[admin_pass]]', NULL, 1, 10, '[[regtime]]', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]visits`
--

CREATE TABLE `[[dbprefix]]visits` (
  `id_visit` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_product` int(10) unsigned DEFAULT NULL,
  `id_user` int(10) unsigned DEFAULT NULL,
  `id_affiliate` int(10) unsigned DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip_address` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id_visit`),
  KEY `[[dbprefix]]visits_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]visits_IK_id_product` (`id_product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
