const defaultTheme = require('tailwindcss/defaultTheme');

module.exports = {
    theme: {
        extend: {
            fontFamily: {
                sans: ['Inter var', ...defaultTheme.fontFamily.sans],
            },
        },
    },
    variants: {},
    purge: {
        content: [
            // './app/**/*.php',
            './views/**/*.html',
            './views/**/*.js',
            './views/**/*.jsx',
            './views/**/*.ts',
            './views/**/*.tsx',
            './views/**/*.php',
            './views/**/*.vue',
            './views/**/*.twig',
        ],
        options: {
            defaultExtractor: (content) => content.match(/[\w-/.:]+(?<!:)/g) || [],
            whitelistPatterns: [/-active$/, /-enter$/, /-leave-to$/, /show$/],
        },
    },
    prefix: 'tw-',
};
