
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `script_openclass440`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]access`
--

CREATE TABLE `[[dbprefix]]access` (
  `id_access` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_role` int(10) unsigned NOT NULL,
  `access` varchar(100) NOT NULL,
  PRIMARY KEY (`id_access`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=33 ;

--
-- Dumping data for table `[[dbprefix]]access`
--

INSERT INTO `[[dbprefix]]access` VALUES
(1, 10, '*.*'),
(2, 1, 'profile.*'),
(3, 1, 'stats.user'),
(4, 1, 'myads.*'),
(5, 1, 'escrow.*'),
(6, 1, 'mylistings.*'),
(7, 1, 'messages.*'),
(8, 1, 'ewallet.*'),
(9, 5, 'translations.*'),
(10, 5, 'profile.*'),
(11, 5, 'stats.user'),
(12, 5, 'content.*'),
(13, 5, 'myads.*'),
(14, 5, 'escrow.*'),
(15, 5, 'mylistings.*'),
(16, 5, 'messages.*'),
(17, 5, 'ewallet.*'),
(18, 7, 'profile.*'),
(19, 7, 'content.*'),
(20, 7, 'stats.user'),
(21, 7, 'blog.*'),
(22, 7, 'translations.*'),
(23, 7, 'ad.*'),
(24, 7, 'widgets.*'),
(25, 7, 'menu.*'),
(26, 7, 'category.*'),
(27, 7, 'location.*'),
(28, 7, 'myads.*'),
(29, 7, 'escrow.*'),
(30, 7, 'mylistings.*'),
(31, 7, 'messages.*'),
(32, 7, 'ewallet.*');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ads`
--

CREATE TABLE `[[dbprefix]]ads` (
  `id_ad` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `id_category` int(10) unsigned NOT NULL DEFAULT '0',
  `id_location` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(145) NOT NULL,
  `seotitle` varchar(145) NOT NULL,
  `description` text,
  `address` varchar(145) DEFAULT '0',
  `latitude` float(10,6) DEFAULT NULL,
  `longitude` float(10,6) DEFAULT NULL,
  `price` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `phone` varchar(30) DEFAULT NULL,
  `website` varchar(200) DEFAULT NULL,
  `ip_address` bigint(20) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `published` datetime DEFAULT NULL,
  `featured` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `has_images` tinyint(1) NOT NULL DEFAULT '0',
  `stock` int(10) unsigned DEFAULT NULL,
  `rate` float(4,2) DEFAULT NULL,
  `favorited` int(10) unsigned NOT NULL DEFAULT '0',
  `locale` varchar(5) DEFAULT NULL,
  PRIMARY KEY USING BTREE (`id_ad`),
  UNIQUE KEY `[[dbprefix]]ads_UK_seotitle` (`seotitle`),
  KEY `[[dbprefix]]ads_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]ads_IK_id_category` (`id_category`),
  KEY `[[dbprefix]]ads_IK_title` (`title`),
  KEY `[[dbprefix]]ads_IK_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `id_category` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(145) NOT NULL,
  `order` int(2) unsigned NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id_category_parent` int(10) unsigned NOT NULL DEFAULT '0',
  `parent_deep` int(2) unsigned NOT NULL DEFAULT '0',
  `seoname` varchar(145) NOT NULL,
  `description` text,
  `price` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `last_modified` datetime DEFAULT NULL,
  `has_image` tinyint(1) NOT NULL DEFAULT '0',
  `translations` text,
  `icon_font` varchar(145) DEFAULT NULL,
  PRIMARY KEY USING BTREE (`id_category`),
  UNIQUE KEY `[[dbprefix]]categories_IK_seo_name` (`seoname`),
  KEY `[[dbprefix]]categories_IK_id_category_parent` (`id_category_parent`),
  KEY `[[dbprefix]]categories_IK_id_category_parent_AND_parent_deep` (`id_category_parent`,`parent_deep`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=26 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, 'Home category', 0, '[[regtime]]', 0, 0, 'all', 'root category', '0.00000000', NULL, 0, NULL, NULL),
(2, 'Jobs', 1, '2013-05-01 20:41:04', 1, 0, 'jobs', 'The best place to find work is with our job offers. Also you can ask for work in the ''Need'' section.', '0.00000000', NULL, 0, NULL, NULL),
(3, 'Languages', 2, '2013-05-01 20:41:04', 1, 0, 'languages', 'You want to learn a new language? Or can you teach a language? This is your section!', '0.00000000', NULL, 0, NULL, NULL),
(4, 'Others', 4, '2013-05-01 20:41:04', 1, 0, 'others', 'Whatever you can imagine is in this section.', '0.00000000', NULL, 0, NULL, NULL),
(5, 'Housing', 0, '2013-05-01 20:41:53', 1, 0, 'housing', 'Do you need a place to sleep, or you have something to offer; rooms, shared apartments, houses... etc.\n\nFind your perfect roommate here!', '0.00000000', NULL, 0, NULL, NULL),
(6, 'Market', 3, '2013-05-01 20:41:04', 1, 0, 'market', 'Buy or sell things that you don''t need anymore in the City, you will find someone interested, or maybe you are going to find exactly what you need.', '0.00000000', NULL, 0, NULL, NULL),
(7, 'Full Time', 1, '2009-04-22 21:31:43', 2, 1, 'full-time', 'Are you looking for a fulltime job? Or do you have a fulltime job to offer? Post your Ad here!', '0.00000000', NULL, 0, NULL, NULL),
(8, 'Part Time', 2, '2009-04-22 21:32:15', 2, 1, 'part-time', 'Are you looking for a parttime job? Or do you have a partime job to offer? Post your Ad here!', '0.00000000', NULL, 0, NULL, NULL),
(9, 'Internship', 3, '2009-04-22 21:33:05', 2, 1, 'internship', 'Are you looking for a internship in the City? Or do you have an internship to offer? Post it here!', '0.00000000', NULL, 0, NULL, NULL),
(10, 'Au pair', 4, '2009-06-19 13:26:22', 2, 1, 'au-pair', 'Find or require for a Au Pair service. Here is the best place', '0.00000000', NULL, 0, NULL, NULL),
(11, 'English', 1, '2009-04-22 21:33:52', 3, 1, 'english', 'Do you speak English? Or can you teach it? Do you want to learn? This is your category.', '0.00000000', NULL, 0, NULL, NULL),
(12, 'Spanish', 2, '2009-04-22 21:34:29', 3, 1, 'spanish', 'You want to learn Spanish? Or can you teach Spanish? This is your section!', '0.00000000', NULL, 0, NULL, NULL),
(13, 'Other Languages', 3, '2009-04-22 21:35:34', 3, 1, 'other-languages', 'Are you interested in learning or teaching any other language that is not listed? Post it here!', '0.00000000', NULL, 0, NULL, NULL),
(14, 'Events', 0, '2013-05-01 20:41:11', 4, 1, 'events', 'Upcoming Parties, Cinema, Museums, Parades, Birthdays, Dinners.... Everything!', '0.00000000', NULL, 0, NULL, NULL),
(15, 'Hobbies', 1, '2013-05-01 20:41:11', 4, 1, 'hobbies', 'Share your hobby with someone! Football, running, cinema, music, cinema, party ... Post it here!', '0.00000000', NULL, 0, NULL, NULL),
(16, 'Services', 3, '2009-04-22 21:38:33', 4, 1, 'services', 'Do you need a service? Relocation? Insurance? Doctor? Cleaning? Here you can ask for it or offer services!', '0.00000000', NULL, 0, NULL, NULL),
(17, 'Friendship', 2, '2013-05-01 20:41:17', 1, 1, 'friendship', 'Are you alone in the City? Here you can find new friends! or a new boyfriend/girlfriend ;)', '0.00000000', NULL, 0, NULL, NULL),
(18, 'Apartment', 1, '2009-04-22 21:39:32', 5, 1, 'apartment', 'Apartments, flats, monthly rentals, long terms, for days... this is the section to have your apartment in the City!', '0.00000000', NULL, 0, NULL, NULL),
(19, 'Shared Apartments - Rooms', 2, '2009-05-04 01:53:57', 5, 1, 'shared-apartments-rooms', 'You want to share an apartment? Then you need a room! Ask for rooms or add yours in this section.', '0.00000000', NULL, 0, NULL, NULL),
(20, 'House', 3, '2009-04-22 21:40:50', 5, 1, 'house', 'Rent a house, or offer your house for rent! Here you can find your beach house close to the City!', '0.00000000', NULL, 0, NULL, NULL),
(21, 'TV', 1, '2009-04-22 21:41:39', 6, 1, 'tv', 'TV, Video Games, TFT, Plasma, your old TV, or your new one can find a new owner!', '0.00000000', NULL, 0, NULL, NULL),
(22, 'Audio', 2, '2009-04-22 21:42:13', 6, 1, 'audio', 'HI-FI systems, iPod, MP3 players, MP4, if you don''t use it anymore sell it! If you try to find a second hand one, this is your place!', '0.00000000', NULL, 0, NULL, NULL),
(23, 'Furniture', 3, '2009-04-22 21:43:16', 6, 1, 'furniture', 'Do you need to furnish your home? Or would you like to sell your furniture? Post it here!', '0.00000000', NULL, 0, NULL, NULL),
(24, 'IT', 4, '2009-04-22 21:43:48', 6, 1, 'it', 'You need a computer? Laptop? Or do you have some old components? This is the IT market of the City!', '0.00000000', NULL, 0, NULL, NULL),
(25, 'Other Market', 5, '2009-04-22 21:44:12', 6, 1, 'other-market', 'In this market you can sell everything you want! Or search for it!', '0.00000000', NULL, 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `group_name` varchar(128) NOT NULL,
  `config_key` varchar(128) NOT NULL,
  `config_value` mediumtext,
  PRIMARY KEY (`config_key`),
  UNIQUE KEY `[[dbprefix]]config_UK_group_name_AND_config_key` (`group_name`,`config_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('advertisement', 'access_token', ''),
('advertisement', 'access_token_secret', ''),
('general', 'adblock', '0'),
('advertisement', 'address', '1'),
('general', 'add_to_home_screen', '0'),
('advertisement', 'ads_in_home', '0'),
('advertisement', 'ads_per_day_limit', '0'),
('advertisement', 'advertisements_per_page', '10'),
('general', 'akismet_key', ''),
('general', 'alert_terms', ''),
('general', 'algolia_powered_by_enabled', '1'),
('general', 'algolia_search', '0'),
('general', 'algolia_search_admin_key', ''),
('general', 'algolia_search_application_id', ''),
('general', 'algolia_search_only_key', ''),
('image', 'allowed_formats', 'jpeg,jpg,png,'),
('i18n', 'allow_query_language', '0'),
('appearance', 'allow_query_theme', '0'),
('payment', 'alternative', ''),
('general', 'analytics', ''),
('general', 'analytics_global_site_tag', ''),
('general', 'api_key', '[[api_key]]'),
('theme', 'atlantic-lite', '{"category_badge":"0","hide_description_icon":"0"}'),
('payment', 'authorize_key', ''),
('payment', 'authorize_login', ''),
('payment', 'authorize_sandbox', '0'),
('general', 'autodata', '0'),
('general', 'auto_locate', '0'),
('advertisement', 'auto_locate_distance', '100'),
('image', 'aws_access_key', ''),
('image', 'aws_s3_active', '0'),
('image', 'aws_s3_bucket', ''),
('image', 'aws_s3_domain', '0'),
('image', 'aws_secret_key', ''),
('advertisement', 'banned_words', ''),
('advertisement', 'banned_words_among', '0'),
('advertisement', 'banned_words_replacement', 'xxx'),
('general', 'base_url', '[[softurl]]/'),
('payment', 'bitpay_pairing_code', ''),
('payment', 'bitpay_private_key', ''),
('payment', 'bitpay_public_key', ''),
('payment', 'bitpay_sandbox', '0'),
('payment', 'bitpay_token', ''),
('general', 'black_list', '1'),
('general', 'blog', '0'),
('general', 'blog_disqus', ''),
('advertisement', 'captcha', '1'),
('general', 'carquery', '0'),
('advertisement', 'center_lat', ''),
('advertisement', 'center_lon', ''),
('i18n', 'charset', 'utf-8'),
('advertisement', 'cloudinary_api_key', ''),
('advertisement', 'cloudinary_api_secret', ''),
('advertisement', 'cloudinary_cloud_name', ''),
('advertisement', 'cloudinary_cloud_preset', ''),
('social', 'config', '{"debug_mode":"0","providers":{"OpenID":{"enabled":"0"},"Yahoo":{"enabled":"0","keys":{"id":"","secret":""}},\n"AOL":{"enabled":"0"},"Google":{"enabled":"0","keys":{"id":"","secret":""}},"Facebook":{"enabled":"0","keys":{"id":"","secret":""}},\n"Twitter":{"enabled":"0","keys":{"key":"","secret":""}},"Live":{"enabled":"0","keys":{"id":"","secret":""}},"MySpace":{"enabled":"0","keys":{"key":"","secret":""}},\n"LinkedIn":{"enabled":"0","keys":{"key":"","secret":""}},"Foursquare":{"enabled":"0","keys":{"id":"","secret":""}},"Vkontakte":{"enabled":"0","keys":{"id":"","secret":""}}},"base_url":"","debug_file":""}'),
('advertisement', 'contact', '1'),
('general', 'contact_page', ''),
('advertisement', 'contact_price', '1'),
('general', 'cookie_consent', '0'),
('general', 'country', ''),
('advertisement', 'count_visits', '1'),
('general', 'cron', '1'),
('appearance', 'custom_css', '0'),
('appearance', 'custom_css_version', '0'),
('general', 'custom_orders', '0'),
('general', 'date_format', 'd-m-y'),
('advertisement', 'delete_ad', '0'),
('advertisement', 'description', '1'),
('advertisement', 'description_bbcode', '1'),
('email', 'digest', '0'),
('email', 'digest_ad_limit', '20'),
('email', 'digest_ad_type', 'normal'),
('general', 'disallowbots', '0'),
('general', 'disallowed_email_domains', ''),
('image', 'disallow_nudes', '0'),
('advertisement', 'disqus', ''),
('advertisement', 'dropbox_app_key', ''),
('email', 'elastic_listname', ''),
('email', 'elastic_password', ''),
('email', 'elastic_username', ''),
('general', 'email_domains', ''),
('payment', 'escrow_pay', '0'),
('payment', 'escrow_sandbox', '0'),
('general', 'ewallet', '0'),
('general', 'ewallet_add_money', '0'),
('general', 'ewallet_gamification', '0'),
('general', 'ewallet_gamification_earn_on_sign_up', '0'),
('general', 'ewallet_mark_as_received_after_n_days', '14'),
('general', 'ewallet_mark_as_received_reminder_after_n_days', '7'),
('general', 'ewallet_money_packages', '{"1000":"10"}'),
('general', 'ewallet_money_symbol', '$'),
('advertisement', 'expire_date', '0'),
('advertisement', 'expire_reactivation', '1'),
('advertisement', 'facebook', '0'),
('advertisement', 'facebook_access_token', ''),
('advertisement', 'facebook_app_id', ''),
('advertisement', 'facebook_app_secret', ''),
('advertisement', 'facebook_id', ''),
('general', 'faq', '0'),
('general', 'faq_disqus', ''),
('advertisement', 'fbcomments', ''),
('payment', 'featured_plans', '{"5":"10"}'),
('advertisement', 'feed_elements', '20'),
('advertisement', 'fields', ''),
('general', 'forums', '0'),
('payment', 'fraudlabspro', ''),
('advertisement', 'free', '0'),
('general', 'gcm_apikey', ''),
('advertisement', 'gm_api_key', ''),
('general', 'google_authenticator', '1'),
('image', 'height', ''),
('image', 'height_thumb', '200'),
('general', 'hide_homepage_categories', '{}'),
('advertisement', 'homepage_map', ''),
('advertisement', 'homepage_map_allowfullscreen', ''),
('advertisement', 'homepage_map_height', ''),
('general', 'html_footer', ''),
('general', 'html_head', ''),
('advertisement', 'instagram', '0'),
('advertisement', 'instagram_app_id', ''),
('advertisement', 'instagram_app_secret', ''),
('advertisement', 'instagram_password', ''),
('advertisement', 'instagram_username', ''),
('general', 'landing_page', '{"controller":"home","action":"index"}'),
('general', 'languages', ''),
('advertisement', 'leave_alert', '1'),
('i18n', 'locale', '[[language]]'),
('advertisement', 'location', '1'),
('advertisement', 'logbee', '0'),
('advertisement', 'login_to_contact', '0'),
('advertisement', 'login_to_post', '0'),
('advertisement', 'login_to_view_ad', '0'),
('email', 'mailgun_api_key', ''),
('email', 'mailgun_domain', ''),
('general', 'maintenance', '0'),
('advertisement', 'map', '0'),
('appearance', 'map_active', '0'),
('advertisement', 'map_elements', '100'),
('appearance', 'map_jscode', ''),
('advertisement', 'map_pub_new', '0'),
('appearance', 'map_settings', ''),
('advertisement', 'map_style', ''),
('advertisement', 'map_zoom', '14'),
('image', 'max_image_size', '5'),
('general', 'measurement', 'metric'),
('payment', 'mercadopago_client_id', ''),
('payment', 'mercadopago_client_secret', ''),
('general', 'messaging', '1'),
('general', 'minify', '0'),
('general', 'moderation', '0'),
('payment', 'mollie_api_key', ''),
('general', 'multilingual', '0'),
('email', 'new_ad_notify', '0'),
('email', 'notify_email', '[[admin_email]]'),
('email', 'notify_name', 'no-reply [[site_name]]'),
('general', 'number_format', '%n'),
('advertisement', 'num_images', '4'),
('social', 'oauth2_client_id', ''),
('social', 'oauth2_client_secret', ''),
('social', 'oauth2_enabled', '0'),
('social', 'oauth2_url_access_token', ''),
('social', 'oauth2_url_authorize', ''),
('social', 'oauth2_url_resource_owner_details', ''),
('general', 'ocacu', '0'),
('advertisement', 'only_admin_post', '0'),
('payment', 'paguelofacil_cclw', ''),
('payment', 'paguelofacil_testing', '0'),
('advertisement', 'parent_category', '1'),
('payment', 'payfast_merchant_id', ''),
('payment', 'payfast_merchant_key', ''),
('payment', 'payfast_sandbox', '0'),
('payment', 'payline_access_key', ''),
('payment', 'payline_contract_number', ''),
('payment', 'payline_merchant_id', ''),
('payment', 'payline_testing', '0'),
('payment', 'paymill_private', ''),
('payment', 'paymill_public', ''),
('payment', 'paypal_account', ''),
('payment', 'paypal_currency', 'USD'),
('payment', 'paypal_seller', '0'),
('payment', 'paysbuy', ''),
('payment', 'paysbuy_sandbox', '0'),
('payment', 'paytabs_merchant_email', ''),
('payment', 'paytabs_secret_key', ''),
('payment', 'pay_to_go_on_feature', '1'),
('payment', 'pay_to_go_on_top', '5'),
('advertisement', 'phone', '1'),
('advertisement', 'picker_api_key', ''),
('advertisement', 'picker_client_id', ''),
('advertisement', 'price', '1'),
('general', 'private_site', '0'),
('general', 'private_site_page', ''),
('general', 'pusher_notifications', '0'),
('general', 'pusher_notifications_app_id', ''),
('general', 'pusher_notifications_cluster', 'eu'),
('general', 'pusher_notifications_key', ''),
('general', 'pusher_notifications_secret', ''),
('advertisement', 'qr_code', '0'),
('image', 'quality', '90'),
('payment', 'razorpay_key_id', ''),
('payment', 'razorpay_key_secret', ''),
('general', 'recaptcha_active', '0'),
('general', 'recaptcha_secretkey', ''),
('general', 'recaptcha_sitekey', ''),
('general', 'recaptcha_type', 'checkbox'),
('advertisement', 'related', '5'),
('advertisement', 'report', '1'),
('advertisement', 'reviews', '0'),
('advertisement', 'reviews_paid', '0'),
('advertisement', 'rich_snippets', '0'),
('payment', 'robokassa_login', ''),
('payment', 'robokassa_pass1', ''),
('payment', 'robokassa_pass2', ''),
('payment', 'robokassa_testing', '0'),
('payment', 'sandbox', '0'),
('general', 'search_by_description', '0'),
('general', 'search_multi_catloc', '0'),
('payment', 'securepay_merchant', ''),
('payment', 'securepay_password', ''),
('payment', 'securepay_testing', '0'),
('payment', 'serfinsa_sandbox', '0'),
('payment', 'serfinsa_token', ''),
('email', 'service', 'mail'),
('advertisement', 'sharing', '0'),
('general', 'site_description', ''),
('general', 'site_name', '[[site_name]]'),
('general', 'smartarget_id', ''),
('general', 'sms_2factorin_api', ''),
('general', 'sms_2factorin_expiring_subscription_template', ''),
('general', 'sms_2factorin_featured_ad_payment_template', ''),
('general', 'sms_2factorin_sender_id', ''),
('general', 'sms_2factorin_subscription_payment_template', ''),
('general', 'sms_auth', '0'),
('general', 'sms_clickatell_api', ''),
('general', 'sms_clickatell_two_way_phone', ''),
('general', 'sms_service', 'clickatell'),
('email', 'smtp_auth', '0'),
('email', 'smtp_host', ''),
('email', 'smtp_pass', ''),
('email', 'smtp_port', ''),
('email', 'smtp_secure', ''),
('email', 'smtp_user', ''),
('general', 'social_auth', '0'),
('advertisement', 'social_post_only_featured', '0'),
('advertisement', 'sort_by', 'published-desc'),
('payment', 'stock', '0'),
('payment', 'stripe_3d_secure', '0'),
('payment', 'stripe_address', '0'),
('payment', 'stripe_alipay', '0'),
('payment', 'stripe_appfee', '0'),
('payment', 'stripe_appfee_fixed', '0'),
('payment', 'stripe_cancel_orders_after_n_days', '30'),
('payment', 'stripe_clientid', ''),
('payment', 'stripe_connect', '0'),
('payment', 'stripe_connected_account_mandatory', '0'),
('payment', 'stripe_connect_legacy', '0'),
('payment', 'stripe_escrow', '1'),
('payment', 'stripe_ideal', '0'),
('payment', 'stripe_legacy', '1'),
('payment', 'stripe_private', ''),
('payment', 'stripe_public', ''),
('payment', 'stripe_webhooks', '0'),
('payment', 'stripe_webhook_secret', ''),
('general', 'subscribe', '0'),
('general', 'subscriptions', '0'),
('general', 'subscriptions_expire', '0'),
('general', 'subscriptions_expire_dont_limit_access', '0'),
('general', 'subscriptions_mark_as_sold', '0'),
('advertisement', 'thanks_page', ''),
('appearance', 'theme', 'atlantic-lite'),
('i18n', 'timezone', 'America/New_York'),
('advertisement', 'tos', ''),
('payment', 'to_featured', '0'),
('payment', 'to_top', '0'),
('general', 'translate', ''),
('advertisement', 'twitter', '0'),
('advertisement', 'twitter_consumer_key', ''),
('advertisement', 'twitter_consumer_secret', ''),
('payment', 'twocheckout_sandbox', '0'),
('payment', 'twocheckout_secretword', ''),
('payment', 'twocheckout_sid', ''),
('advertisement', 'upload_file', '0'),
('image', 'upload_from_url', '0'),
('general', 'users_must_verify_email', '0'),
('user', 'user_fields', '{}'),
('advertisement', 'validate_banned_words', '0'),
('payment', 'vat_country', ''),
('payment', 'vat_non_eu', ''),
('payment', 'vat_number', ''),
('image', 'watermark', '0'),
('image', 'watermark_path', ''),
('image', 'watermark_position', '0'),
('advertisement', 'website', '1'),
('image', 'width', '1200'),
('image', 'width_thumb', '200'),
('payment', 'zenith_merchantid', ''),
('payment', 'zenith_merchant_name', ''),
('payment', 'zenith_merchant_phone', ''),
('payment', 'zenith_pwd', ''),
('payment', 'zenith_testing', '0'),
('payment', 'zenith_uid', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content`
--

CREATE TABLE `[[dbprefix]]content` (
  `id_content` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `locale` varchar(8) NOT NULL DEFAULT 'en_UK',
  `order` int(2) unsigned NOT NULL DEFAULT '0',
  `title` varchar(145) NOT NULL,
  `seotitle` varchar(145) NOT NULL,
  `description` mediumtext,
  `from_email` varchar(145) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` enum('page','email','help') NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_content`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=103 ;

--
-- Dumping data for table `[[dbprefix]]content`
--

INSERT INTO `[[dbprefix]]content` VALUES
(1, 'en_UK', 0, 'Change Password [SITE.NAME]', 'auth-remember', 'Hello [USER.NAME],\n\nFollow this link  [URL.QL]\n\nThanks!!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(2, 'en_UK', 0, 'Welcome to [SITE.NAME]!', 'auth-register', 'Welcome [USER.NAME],\n\nWe are really happy that you have joined us! [URL.QL]\n\nRemember your user details:\nEmail: [USER.EMAIL]\nPassword: [USER.PWD]\n\nWe do not have your original password anymore.\n\nRegards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(3, 'en_UK', 0, 'Welcome to [SITE.NAME]!', 'auth-verify-email', 'Welcome [USER.NAME],\n\nWe are really happy that you have joined us!\nPlease click on this link [URL.QL] to confirm your email\n\nRemember your user details:\nEmail: [USER.EMAIL]\nPassword: [USER.PWD]\n\nWe do not have your original password anymore.\n\nRegards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(4, 'en_UK', 0, 'Hello [USER.NAME]!', 'user-contact', 'You have been contacted regarding your advertisement: \n\n`[AD.NAME]`. \n\n User [EMAIL.SENDER] [EMAIL.FROM], have a message for you: \n\n[EMAIL.BODY]. \n\nYou can check your advertisement by following this link [URL.AD]\n\n Regards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(5, 'en_UK', 0, 'Hello [USER.NAME]!', 'user-profile-contact', 'User [EMAIL.SENDER] [EMAIL.FROM], have a message for you: \n\n[EMAIL.SUBJECT] \n\n[EMAIL.BODY]. \n\n Regards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(6, 'en_UK', 0, '[EMAIL.SENDER] wants to contact you!', 'contact-admin', 'Hello Admin,\n\n [EMAIL.SENDER]: [EMAIL.FROM], have a message for you:\n\n [EMAIL.SUBJECT]\n\n [EMAIL.BODY] \n\n Regards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(7, 'en_UK', 0, 'Your advertisement `[AD.NAME]` at [SITE.NAME], has been activated!', 'ads-activated', 'Hello [USER.OWNER],\n\n We want to inform you that your advertisement [URL.QL] has been activated!\n\n Now it can be seen by others. \n\n We hope we did not make you wait for long. \n\nRegards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(8, 'en_UK', 0, 'Success! Your advertisement `[AD.NAME]` is created on [SITE.NAME]!', 'ads-notify', 'Hello [USER.NAME],\n\nThank you for creating an advertisement at [SITE.NAME]! \n\nYou can edit your advertisement here [URL.QL].\n\n Your ad is still not published, it needs to be validated by an administrator. \n\n We are sorry for any inconvenience. We will review it as soon as possible. \n\nRegards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(9, 'en_UK', 0, 'Advertisement `[AD.NAME]` is created on [SITE.NAME]!', 'ads-user-check', 'Hello [USER.NAME],\n\n Advertisement is created under your account [USER.NAME]! You can visit this link to see advertisement [URL.AD]\n\n If you are not responsible for creating this advertisement, click a link to contact us [URL.CONTACT].\n\n', '[[admin_email]]', '[[regtime]]', 'email', 1),
(10, 'en_UK', 0, 'Advertisement `[AD.TITLE]` is created on [SITE.NAME]!', 'ads-subscribers', 'Hello,\n\n You may be interested in this one!\n\nYou can visit this link to see advertisement [URL.AD]\n\n', '[[admin_email]]', '[[regtime]]', 'email', 1),
(11, 'en_UK', 0, 'Advertisement `[AD.TITLE]` is created on [SITE.NAME]!', 'ads-to-admin', 'Click here to visit [URL.AD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(12, 'en_UK', 0, 'Advertisement `[AD.TITLE]` is sold on [SITE.NAME]!', 'ads-sold', 'Order ID: [ORDER.ID]\n\nProduct ID: [PRODUCT.ID]\n\nPlease check your account for the incoming payment.\n\nClick here to visit [URL.AD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(13, 'en_UK', 0, 'Advertisement `[AD.TITLE]` is out of stock on [SITE.NAME]!', 'out-of-stock', 'Hello [USER.NAME],\n\nWhile your ad is out of stock, it is unavailable for others to see. If you wish to increase stock and activate, please follow this link [URL.EDIT].\n\nRegards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(14, 'en_UK', 0, 'You bought `[AD.TITLE]`', 'ads-purchased', 'Order ID: [ORDER.ID]\n\nProduct ID: [PRODUCT.ID]\n\nClick here to visit [URL.AD]\n\n[BUYER.INSTRUCTIONS]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(15, 'en_UK', 0, 'Receipt for [ORDER.DESC] #[ORDER.ID]', 'new-order', 'Hello [USER.NAME],Thanks for buying [ORDER.DESC].\n\nPlease complete the payment here [URL.CHECKOUT]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(16, 'en_UK', 0, 'Mark as received reminder for [ORDER.DESC] #[ORDER.ID]', 'mark-as-received', 'Hello [USER.NAME],Thanks for buying [ORDER.DESC].\n\nPlease mark it as received here [URL.CHECKOUT]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(17, 'en_UK', 0, 'Order shipped for [ORDER.DESC] #[ORDER.ID]', 'order-shipped', 'Hello [USER.NAME],\n\nThanks for buying [ORDER.DESC].\n\nYour order has been shipped.\n\nTracking code [ORDER.SHIPPING_PROVIDER_NAME] [ORDER.SHIPPING_TRACKING_CODE] [URL.QL]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(18, 'en_UK', 0, 'Order cancelled for [ORDER.DESC] #[ORDER.ID]', 'order-cancelled', 'Hello [USER.NAME],\n\nYour order has been cancelled.', '[[admin_email]]', '[[regtime]]', 'email', 1),
(19, 'en_UK', 0, 'Safe payment request for [AD.NAME]', 'safe-payment-requested', 'Hello [USER.NAME],\n\nYour ad [AD.NAME] received a safe payment request. Please register with Stripe Connect to receive payments [URL.QL].', '[[admin_email]]', '[[regtime]]', 'email', 1),
(20, 'en_UK', 0, 'Success! Your advertisement `[AD.NAME]` is created on [SITE.NAME]!', 'ads-confirm', 'Welcome [USER.NAME],\n\nThank you for creating an advertisement at [SITE.NAME]! \n\nPlease click on this link [URL.QL] to confirm it.\n\nRegards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(21, 'en_UK', 0, 'Your ad [AD.NAME] has expired', 'ad-expired', 'Hello [USER.NAME],Your ad [AD.NAME] has expired \n\nPlease check your ad here [URL.EDITAD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(22, 'en_UK', 0, 'Your ad [AD.NAME] is going to expire', 'ad-to-expire', 'Hello [USER.NAME],Your ad [AD.NAME] will expire soon \n\nPlease check your ad here [URL.EDITAD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(23, 'en_UK', 0, 'Password Changed [SITE.NAME]', 'password-changed', 'Hello [USER.NAME],\n\nYour password has been changed.\n\nThese are now your user details:\nEmail: [USER.EMAIL]\nPassword: [USER.PWD]\n\nWe do not have your original password anymore.\n\nRegards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(24, 'en_UK', 0, 'New reply: [TITLE]', 'messaging-reply', '[URL.QL]\n\n[DESCRIPTION]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(25, 'en_UK', 0, '[FROM.NAME] sent you a direct message', 'messaging-user-contact', 'Hello [TO.NAME],\n\n[FROM.NAME] have a message for you:\n\n[DESCRIPTION]\n\n[URL.QL]\n\nRegards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(26, 'en_UK', 0, 'Hello [TO.NAME]!', 'messaging-ad-contact', 'You have been contacted regarding your advertisement:\n\n`[AD.NAME]`.\n\nUser [FROM.NAME], have a message for you:\n\n[DESCRIPTION]\n\n[URL.QL]\n\nRegards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(27, 'en_UK', 0, 'New review for [AD.TITLE] [RATE]', 'ad-review', '[URL.QL]\n\n[RATE]\n\n[DESCRIPTION]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(28, 'en_UK', 0, 'There is a new reply on the forum', 'new-forum-answer', 'There is a new reply on a forum post where you participated.<br><br><a target="_blank" href="[FORUM.LINK]">Check it here</a><br><br>[FORUM.LINK]<br>', '[[admin_email]]', '[[regtime]]', 'email', 1),
(29, 'en_UK', 0, 'Email digest [SITE.NAME]', 'digest', 'Hello,\n\nWhat''s new on [SITE.NAME], a digest of published ads during the past days. Please click on the ad title below for more information or to contact the publisher. [ADS]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(30, 'en_UK', 0, 'Your plan [PLAN.NAME] has expired', 'plan-expired', 'Hello [USER.NAME],Your plan [PLAN.NAME] has expired \n\nPlease renew your plan here [URL.CHECKOUT]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(31, 'es_ES', 0, 'Cambiar Contraseña [SITE.NAME]', 'auth-remember', 'Hola [USER.NAME],\r\n\r\nSigue este enlace  [URL.QL]\r\n\r\n¡Gracias!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(32, 'es_ES', 0, '¡Bienvenido a [SITE.NAME]!', 'auth-register', 'Bienvenido [USER.NAME],\r\n\r\n¡Estamos muy contentos de que te no hayas unido! [URL.QL]\r\n\r\nRecuerda tus detalles de usuario:\r\nEmail: [USER.EMAIL]\r\nContraseña: [USER.PWD]\r\n\r\nYa no tenemos más tu contraseña original.\r\n\r\n¡Saludos!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(33, 'es_ES', 0, '¡Bienvenido a [SITE.NAME]!', 'auth-verify-email', 'Bienvenido [USER.NAME],\r\n\r\n¡Estamos muy contentos de que te no hayas unido!\nPor favor, has clic en este enlace [URL.QL] para confirmar tu email\n\nRecuerda tus detalles de usuario:\r\nEmail: [USER.EMAIL]\r\nContraseña: [USER.PWD]\r\n\r\nYa no tenemos más tu contraseña original.\r\n\r\n¡Saludos!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(34, 'es_ES', 0, '¡Hola [USER.NAME]!', 'user-contact', 'Has sido contactado en relación con tu anuncio: \r\n\r\n`[AD.NAME]`. \r\n\r\n Usuario [EMAIL.SENDER] [EMAIL.FROM], tiene un mensaje para ti: \r\n\r\n[EMAIL.BODY]. \r\n\r\n ¡Saludos!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(35, 'es_ES', 0, '¡Hola [USER.NAME]!', 'user-profile-contact', 'Usuario [EMAIL.SENDER] [EMAIL.FROM], tiene un mensaje para ti: \r\n\r\n[EMAIL.SUBJECT] \r\n\r\n[EMAIL.BODY]. \r\n\r\n ¡Saludos!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(36, 'es_ES', 0, '¡[EMAIL.SENDER] quiere contactarte!', 'contact-admin', 'Hello Admin,\r\n\r\n [EMAIL.SENDER]: [EMAIL.FROM], tiene un mensaje para ti:\r\n\r\n [EMAIL.BODY] \r\n\r\n ¡Saludos!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(37, 'es_ES', 0, '¡Tu anuncio `[AD.NAME]` en [SITE.NAME] ha sido activado!', 'ads-activated', 'Hola [USER.OWNER],\r\n\r\n ¡Queremos informate que tu anuncio [URL.QL] ha sido activado!\r\n\r\n Ahora puede ser visto por otros usuarios. \r\n\r\n Esperamos no habarte hecho esperar demasiado. \r\n\r\n¡Saludos!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(38, 'es_ES', 0, '¡Enhorabuena! Tu anuncio `[AD.NAME]` ha sido creado en [SITE.NAME]!', 'ads-notify', 'Hola [USER.NAME],\r\n\r\n¡Gracias por crear un anuncio en [SITE.NAME]! \r\n\r\nPuedes editar tu anuncio aquí [URL.QL].\r\n\r\n Tu anuncio aún no está publicado, necesita que sea validado por un administrador. \r\n\r\n Lamentamos el inconveniente. Lo revisaremos lo más pronto posible.\r\n\r\n¡Saludos!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(39, 'es_ES', 0, '¡Anuncio `[AD.NAME]` ha sido creado en [SITE.NAME]!', 'ads-user-check', 'Hola [USER.NAME],\r\n\r\n ¡[USER.NAME], un anuncio ha sido creado en tu cuenta! Puedes visitar este enlace para verlo [URL.AD]\r\n\r\n Si no eres el responsable de la creación de este anuncio, has clic en este enlace para contactarnos [URL.CONTACT].\r\n\r\n', '[[admin_email]]', '[[regtime]]', 'email', 1),
(40, 'es_ES', 0, '¡Anuncio `[AD.TITLE]` ha sido creado en [SITE.NAME]!', 'ads-subscribers', '¡Hola,\r\n\r\n ¡Quizás te interese esto!\r\n\r\nPuede visitar este enlace para ver el anuncio [URL.AD]\r\n\r\n', '[[admin_email]]', '[[regtime]]', 'email', 1),
(41, 'es_ES', 0, '¡Anuncio `[AD.TITLE]` ha sido creado en [SITE.NAME]!', 'ads-to-admin', 'Clic aquí para visitarlo [URL.AD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(42, 'es_ES', 0, '¡Anuncio `[AD.TITLE]` ha sido vendido en [SITE.NAME]!', 'ads-sold', 'ID de la orden: [ORDER.ID]\r\n\r\nID del producto: [PRODUCT.ID]\r\n\r\nPor favor, verifica tu cuenta para el pago recibido.\r\n\r\nClic aquí para visitar [URL.AD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(43, 'es_ES', 0, '¡El anuncio `[AD.TITLE]` ya no cuenta con stock en [SITE.NAME]!', 'out-of-stock', 'Hola [USER.NAME],\r\n\r\nMientras tu anuncio está fuera de stock, no estará disponible para que otros usuarios lo vean. Si deseas incrementar tu stock y activar tu anuncio, por favor sigue este enlace [URL.EDIT].\r\n\r\n¡Saludos!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(44, 'es_ES', 0, 'Ha comprado `[AD.TITLE]`', 'ads-purchased', 'ID de la orden: [ORDER.ID]\r\n\r\nID del producto: [PRODUCT.ID]\r\n\r\nClic aquí para visitar [URL.AD]\n\n[BUYER.INSTRUCTIONS]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(45, 'es_ES', 0, 'Recibo de [ORDER.DESC] #[ORDER.ID]', 'new-order', 'Hola [USER.NAME], gracias por comprar [ORDER.DESC].\r\n\r\nPor favor, completa tu pago aquí [URL.CHECKOUT]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(46, 'es_ES', 0, '¡Enhorabuena! Tu anuncio `[AD.NAME]` fue creado en [SITE.NAME]!', 'ads-confirm', 'Bienvenido [USER.NAME],\r\n\r\nGracias por crear un anuncio en [SITE.NAME]! \r\n\r\nPor favor, has clic en este enlace [URL.QL] para confirmarlo.\r\n\r\n¡Saludos!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(47, 'es_ES', 0, 'Tu anuncio [AD.NAME] ha expirado', 'ad-expired', 'Hola [USER.NAME], Tu anuncio [AD.NAME] ha expirado \r\n\r\nPor favor, revisa tu anuncio aquí [URL.EDITAD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(48, 'es_ES', 0, 'Opinión nueva para [AD.TITLE] [RATE]', 'ad-review', '[URL.QL]\r\n\r\n[RATE]\r\n\r\n[DESCRIPTION]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(49, 'es_ES', 0, 'Tu anuncio [AD.NAME] está por expirar', 'ad-to-expire', 'Hola [USER.NAME], Tu anuncio [AD.NAME] pronto expirará \n\nPor favor, revisa tu anuncio aquí [URL.EDITAD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(50, 'es_ES', 0, 'Contraseña modificada [SITE.NAME]', 'password-changed', 'Hola [USER.NAME],\n\nTu contraseña ha sido modificada.\n\nEstos son ahora tus detalles:\nEmail: [USER.EMAIL]\nContraseña: [USER.PWD]\n\n\n\nSaludos', '[[admin_email]]', '[[regtime]]', 'email', 1),
(51, 'es_ES', 0, 'Respuesta nueva: [TITLE]', 'messaging-reply', '[URL.QL]\n\n[DESCRIPTION]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(52, 'es_ES', 0, '[FROM.NAME] Te ha enviado un mensaje directo', 'messaging-user-contact', 'Hola [TO.NAME],\n\n[FROM.NAME] tiene un mensaje para ti:\n\n[DESCRIPTION]\n\n[URL.QL]\n\nSaludos', '[[admin_email]]', '[[regtime]]', 'email', 1),
(53, 'es_ES', 0, 'Hola [TO.NAME]!', 'messaging-ad-contact', 'Has sido contactado respecto al anuncio:\n\n`[AD.NAME]`.\n\nEl usuario [FROM.NAME], tiene un mensaje para ti:\n\n[DESCRIPTION]\n\n[URL.QL]\n\nSaludos', '[[admin_email]]', '[[regtime]]', 'email', 1),
(54, 'es_ES', 0, 'Hay una nueva respuesta en el foro', 'new-forum-answer', 'Hay una nueva respuesta en el foro donde has participado.\r\n<br><br>\r\n<a target="_blank" href="[FORUM.LINK]">Puedes revisarla aquí</a>\r\n<br><br>\r\n[FORUM.LINK]\r\n<br>', '[[admin_email]]', '[[regtime]]', 'email', 1),
(55, 'es_ES', 0, 'Su plan [PLAN.NAME] ha expirado', 'plan-expired', 'Hola [USER.NAME],Su plan [PLAN.NAME] ha expirado \n\nPor favor renueve su plan aquí [URL.CHECKOUT]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(56, 'fr_FR', 0, 'Félicitations! Votre annonce a bien été créée sur [SITE.NAME]!', 'ads-confirm', 'Bienvenue [USER.NAME],<br /><br />\n<br /><br />\nMerci d''avoir créé une anonnce sur [SITE.NAME]! <br /><br />\n<br /><br />\nVeuillez cliquer sur ce lien [URL.QL] pour la confirmer.<br /><br />\n<br /><br />\nCordialement!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(57, 'fr_FR', 0, 'Félicitations! Votre annonce a été créée sur [SITE.NAME]!', 'ads-notify', 'Bonjour [USER.NAME],<br /><br />\n<br /><br />\nMerci d''avoir créé une anonnce sur [SITE.NAME]! <br /><br />\n<br /><br />\nVous pouvez modifier votre annonce ici [URL.QL].<br /><br />\n<br /><br />\nVotre annonce est en attente de publication, elle doit encore être validée par l''administrateur. Nous allons l''examiner dès que possible. <br /><br />\n<br /><br />\nNous sommes désolés pour le délai et la gène occasionnée. Merci de votre compréhension.<br /><br />\n<br /><br />\nCordialement!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(58, 'fr_FR', 0, '[EMAIL.SENDER] souhaite vous contacter!', 'contact-admin', 'Bonjour Administrateur,<br /><br />\n<br /><br />\n[EMAIL.SENDER]: [EMAIL.FROM], a un message pour vous:<br /><br />\n<br /><br />\n[EMAIL.BODY] <br /><br />\n<br /><br />\nCordialement!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(59, 'fr_FR', 0, 'Votre annonce sur [SITE.NAME] a été activée!', 'ads-activated', 'Bonjour [USER.OWNER],<br /><br />\n<br /><br />\nNous vous informons que votre annonce [URL.QL] a été activée!<br /><br />\nElle est désormais visible de tous sur le site. <br /><br />\n<br /><br />\nEn espérant ne pas vous avoir fait trop attendre. <br /><br />\n<br /><br />\nCordialement!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(60, 'fr_FR', 0, 'Bonjour [USER.NAME]!', 'user-new', 'Bienvenue sur [SITE.NAME]. <br /><br />\n<br /><br />\nNous sommes ravis de votre participation,<br /><br />\nVous pouvez vous connecter avec votre email: [USER.EMAIL], <br /><br />\net votre mot de passe: [USER.PWD]. <br /><br />\n<br /><br />\nLe mot de passe a été généré automatiquement; pour le remplacer par votre mot de passe préféré, cliquez sur ce lien: [URL.PWCH]. <br /><br />\n<br /><br />\nMerci de votre confiance! <br /><br />\n<br /><br />\nCordialement!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(61, 'fr_FR', 0, 'Bonjour [USER.NAME]!', 'user-contact', 'Vous avez été contacté au sujet de votre annonce. <br /><br />\nL''utilisateur [EMAIL.SENDER] [EMAIL.FROM] vous a envoyé le message suivant:<br /><br />\n[EMAIL.BODY]. <br /><br />\n<br /><br />\nCordialement!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(62, 'fr_FR', 0, 'Changement de mot de passe [SITE.NAME]', 'auth-remember', 'Bonjour [USER.NAME],<br /><br />\n<br /><br />\nVeuillez suivre ce lien [URL.QL]<br /><br />\n<br /><br />\nMerci!!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(63, 'fr_FR', 0, 'Bienvenue sur [SITE.NAME]!', 'auth-register', 'Bienvenue [USER.NAME],<br /><br />\n<br /><br />\nNous sommes ravis de votre participation! [URL.QL]<br /><br />\nVoici pour rappel vos informations de connexion:<br /><br />\nEmail: [USER.EMAIL]<br /><br />\nMot de passe: [USER.PWD]<br /><br />\n<br /><br />\nPour des raisons de sécurité, nous ne gardons pas votre mot de passe original.<br /><br />\n<br /><br />\nCordialement!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(64, 'fr_FR', 0, 'Bonjour [USER.NAME]!', 'user-profile-contact', 'L''utilisateur [Email.SENDER] [EMAIL.From] a un message pour vous: [EMAIL.SUBJECT] [EMAIL.BODY]. Cordialement,', '[[admin_email]]', '[[regtime]]', 'email', 1),
(65, 'fr_FR', 0, 'L''annonce `[AD.NAME]` a été créée sur [SITE.NAME]!', 'ads-user-check', 'Bonjour [USER.NAME], l''annonce a été créée avec votre compte [USER.NAME]! Vous pouvez visiter ce lien pour Cliquez ici pour accéder à votre annonce: [URL.AD] Si vous n''êtes pas l''auteur de cette annonce, cliquez sur le lien pour nous contacter: [URL.CONTACT].', '[[admin_email]]', '[[regtime]]', 'email', 1),
(66, 'fr_FR', 0, 'L''annonce `[AD.TITLE]` vient d''être publiée sur [SITE.NAME]!', 'ads-subscribers', 'Bonjour, Vous êtes peut être intéressé(e) par cette nouvelle annonce! Cliquez sur ce lien pour Cliquez ici pour accéder à votre annonce: [URL.AD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(67, 'fr_FR', 0, 'L''annonce `[AD.TITLE]` vient d''être créée sur [SITE.NAME]!', 'ads-to-admin', 'Cliquez ici pour voir l''annnonce [URL.AD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(68, 'fr_FR', 0, 'L''annonce `[AD.TITLE]` a été vendue sur [SITE.NAME]!', 'ads-sold', 'Numéro de commande: [ORDER.ID] ID de produit: [PRODUCT.ID] Veuillez svp vérifier votre compte pour le paiement entrant. Cliquez ici pour accéder à votre annonce: [URL.AD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(69, 'fr_FR', 0, 'L''annonce `[AD.TITLE]` est en rupture de stock sur [SITE.NAME]!', 'out-of-stock', 'Bonjour [USER.NAME]. Comme votre annonce est en rupture de stock, il n''est pas posible pour les visiteurs du site de la voir. Si vous souhaitez augmenter sa disponibilité et ainsi activer votre annonce, veuillez svp cliquer sur le lien suivant: [URL.EDIT]. Cordialement!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(70, 'fr_FR', 0, 'Reçu pour votre commande [ORDER.DESC] # [ORDER.ID]', 'new-order', 'Bonjour [USER.NAME], Merci pour votre commande [ORDER.DESC]. Veuillez svp régler votre commande et procéder à son paiement ici: [URL.CHECKOUT]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(71, 'fr_FR', 0, 'Votre annonce [AD.NAME] a expiré', 'ad-expired', 'Bonjour [USER.NAME], Votre annonce [AD.NAME] a expiré. Veuillez svp vérifier votre annonce ici: [URL.EDITAD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(72, 'fr_FR', 0, 'L''annonce `[AD.TITLE]` a été achetée sur [SITE.NAME]!', 'ads-purchased', 'Numéro de commande: [ORDER.ID] ID du produit: [PRODUCT.ID] Pour toute question ou demande veuillez svp contacter l''administrateur du site [SITE.NAME] Cliquez ici pour accéder à votre annonce: [URL.AD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(73, 'fr_FR', 0, 'Mot de passe modifié [SITE.NAME]', 'password-changed', 'Bonjour [USER.NAME], Votre mot de passe a été changé. Voici vos nouvelles informations de connexion: Email: [USER.EMAIL] Mot de passe: [USER.PWD] . Pour des raisons de sécurité, nous ne gardons pas votre mot de passe original. Cordialement!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(74, 'fr_FR', 0, 'Votre annonce [AD.NAME] va expirer', 'ad-to-expire', 'Bonjour [USER.NAME], Votre annonce [AD.NAME] va bientôt expirer. Veuillez svp vérifier votre annonce en cliquant sur ce lien: [URL.EDITAD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(75, 'fr_FR', 0, 'Nouvelle réponse: [TITRE]', 'messaging-reply', '[URL.QL]\r\n\r\n[DESCRIPTION]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(76, 'fr_FR', 0, '[FROM.NAME] vous a envoyé un message direct', 'messaging-user-contact', 'Bonjour [TO.NAME], [FROM.NAME] a un message pour vous: [description] [URL.QL] Cordialement!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(77, 'fr_FR', 0, 'Nouveau commentaire sur votre annonce [AD.TITLE] [RATE]', 'ad-review', 'Bonjour, une nouveau commentaire et une appréciation ont été publiés pour votre annonce. [URL.QL]\r\n\r\n[RATE]\r\n\r\n[DESCRIPTION]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(78, 'fr_FR', 0, 'Bonjour [TO.NAME]!', 'messaging-ad-contact', 'Vous avez été contacté au sujet de votre annonce: `[AD.NAME]`. L''utilisateur [FROM.NAME] a un message pour vous: [DESCRIPTION] [URL.QL] Cordialement!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(79, 'ru_RU', 0, 'Добро Пожаловать на [SITE.NAME]!', 'auth-register', '<p>Добро Пожаловать [USER.NAME], мы очень рады, что Вы присоединились к нам! &nbsp;[URL.QL] Запомните детали своего профайла:\r\nEmail: [USER.EMAIL] Пароль: [USER.PWD] У нас больше нет вашего первоначального пароля. С уважением!&nbsp;</p>', '[[admin_email]]', '[[regtime]]', 'email', 1),
(80, 'ru_RU', 0, 'Изменить пароль на [SITE.NAME]', 'auth-remember', 'Здравствуйте [USER.NAME], перейдите за ссылкой [URL.QL] Спасибо!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(81, 'ru_RU', 0, 'Здравствуйте [USER.NAME]!', 'user-profile-contact', 'Пользователь [EMAIL.SENDER] [EMAIL.FROM], прислал вам сообщение: \r\n\r\n[EMAIL.SUBJECT] \r\n\r\n[EMAIL.BODY]. С уважением!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(82, 'ru_RU', 0, 'Здравствуйте [USER.NAME]!', 'user-contact', 'С Вами хотят связаться насчёт Вашего объявления: `[AD.NAME]`. Пользователь [EMAIL.SENDER] [EMAIL.FROM], прислал Вам сообщение: [EMAIL.BODY]. С уважением!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(83, 'ru_RU', 0, '[EMAIL.SENDER] хочет с Вами связаться!', 'contact-admin', 'Здравствуйте Адміністратор, [EMAIL.SENDER]: [EMAIL.FROM], прислал Вам сообщение: [EMAIL.BODY] С уважением!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(84, 'ru_RU', 0, 'Наши поздравления, объявление `[AD.NAME]` на [SITE.NAME] было успешно создано!', 'ads-notify', 'Здравствуйте [USER.NAME], Большое спасибо за объявление на [SITE.NAME]! Вы можете редактировать его здесь [URL.QL]. Ваше объявление еще не опубликовано, сначало оно должно быть подтверждено администратором. Приносим извинения за возможные неудобства. Мы рассмотрим его как можно скорее. С уважением!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(85, 'ru_RU', 0, 'Квитанция за [ORDER.DESC] #[ORDER.ID]', 'new-order', 'Здавствуйте [USER.NAME], Большое спасибо за покупку [ORDER.DESC]. Пожалуйста, продолжите оплату здесь  [URL.CHECKOUT].', '[[admin_email]]', '[[regtime]]', 'email', 1),
(86, 'ru_RU', 0, 'Объявление `[AD.TITLE]` is out of stock on [SITE.NAME]!', 'out-of-stock', 'Здавствуйте [USER.NAME],\r\n\r\nWhile your ad is out of stock, it is unavailable for others to see. If you wish to increase stock and activate, please follow this link [URL.EDIT].\r\n\r\nRegards!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(87, 'ru_RU', 0, 'Объявление`[AD.TITLE]` продано на [SITE.NAME]!', 'ads-sold', 'Номер заказа: [ORDER.ID] Номер продукта: [PRODUCT.ID] Пожалуйста, проверте свой акаунт на оплату. Для просмотра нажмите здесь [URL.AD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(88, 'ru_RU', 0, 'Объявление `[AD.TITLE]` создано на [SITE.NAME]!', 'ads-to-admin', 'Для просмотра нажмите здесь [URL.AD]&nbsp;', '[[admin_email]]', '[[regtime]]', 'email', 1),
(89, 'ru_RU', 0, 'Объявление`[AD.TITLE]` создано на [SITE.NAME]!', 'ads-subscribers', 'Здравствуйте, Вам может быть интересно это объявление, перейдите по ссылке, что бы посмотреть [URL.AD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(90, 'ru_RU', 0, 'Объявление `[AD.NAME]`создано на [SITE.NAME]!', 'ads-user-check', 'Здравстуйте [USER.NAME], Объявление создано под именем [USER.NAME]! Вы можете просмотреть его за ссылкой [URL.AD]. Если Вы не создавали это объявление, перейдите за ссылкой, чтобы связаться с нами [URL.CONTACT].', '[[admin_email]]', '[[regtime]]', 'email', 1),
(91, 'ru_RU', 0, 'Наши поздравления, объявление `[AD.NAME]` на [SITE.NAME] было успешно создано!', 'ads-confirm', 'Добро Пожаловать [USER.NAME], Большое спасибо за создание объявления на [SITE.NAME]! Пожалуйста, перейдите за ссылкой [URL.QL] чтобы подтвердить. С уважением!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(92, 'ru_RU', 0, 'Объявление `[AD.TITLE]` выставлено на [SITE.NAME]!', 'ads-purchased', 'Номер заказа: [ORDER.ID] Номер продукта: [PRODUCT.ID] Если у Вас возникли проблемы, пожалуйста, свяжитесь с администратором сайта [SITE.NAME] Перейдите за ссылкой для просмотра [URL.AD]\r\n\r\n[BUYER.INSTRUCTIONS]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(93, 'ru_RU', 0, 'Заканчивается срок публикации Вашего объявления [AD.NAME]', 'ad-to-expire', 'Здравствуйте [USER.NAME], Скоро истечёт срок вашего объявления [AD.NAME], пожалуйста, перейдите за ссылкой чтобы просмотреть [URL.EDITAD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(94, 'ru_RU', 0, 'Пароль Изменён [SITE.NAME]', 'password-changed', 'Здравствуйте[USER.NAME], Ваш пароль был изменён. Это Вашы новые детали :\r\nEmail: [USER.EMAIL] Пароль: [USER.PWD] У нас больше нет Вашего первоначального пароля. С уважением!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(95, 'ru_RU', 0, 'Вышел срок публикации Вашего объявления [AD.NAME] ', 'ad-expired', 'Здавствуйте [USER.NAME], Вышел срок публикации Вашего объявления [AD.NAME], Пожалуйста, перейдите за ссылкой для просмотра [URL.EDITAD]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(96, 'ru_RU', 0, '[FROM.NAME] прислал Вам сообщение', 'messaging-user-contact', 'Здравствуйте [TO.NAME], [FROM.NAME] прислал Вам сообщение: [DESCRIPTION] [URL.QL] С уважением!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(97, 'ru_RU', 0, 'Новый ответ: [TITLE]', 'messaging-reply', '[URL.QL]\r\n\r\n[DESCRIPTION]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(98, 'ru_RU', 0, 'Здравствуйте [TO.NAME]!', 'messaging-ad-contact', 'С Вами хотят связаться насчёт&nbsp;объявления: `[AD.NAME]`. Пользователь [FROM.NAME], прислал Вам сообщение: [DESCRIPTION] [URL.QL] С уважением!', '[[admin_email]]', '[[regtime]]', 'email', 1),
(99, 'ru_RU', 0, 'Срок Вашего тарифного плана [PLAN.NAME] истёк', 'plan-expired', 'Здравствуйте [USER.NAME], Истёк срок Вашего тарифного плана [PLAN.NAME], Пожалуйста, перейдите за &nbsp;ссылкой чтобы просмотрет [URL.CHECKOUT]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(100, 'ru_RU', 0, 'Новый ответ на форуме', 'new-forum-answer', '<p>Новый ответ на форуме<br></p><p><br>&nbsp;&nbsp;<a href="[FORUM.LINK]" >Просмотреть здесь</a><br><br>[FORUM.LINK]<br></p>', '[[admin_email]]', '[[regtime]]', 'email', 1),
(101, 'ru_RU', 0, 'Новый отзыв на  [AD.TITLE] [RATE]', 'ad-review', '[URL.QL]\r\n\r\n[RATE]\r\n\r\n[DESCRIPTION]', '[[admin_email]]', '[[regtime]]', 'email', 1),
(102, 'ru_RU', 0, 'Ваше объявление `[AD.NAME]` на [SITE.NAME], активировано', 'ads-activated', 'Здравствуйте [USER.OWNER], Ваше объявление [URL.QL] активировано! Теперь его может увидеть каждый посетитель. Надеемся, что мы не заставили Вас долго ждать. С уважением!', '[[admin_email]]', '[[regtime]]', 'email', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]coupons`
--

CREATE TABLE `[[dbprefix]]coupons` (
  `id_coupon` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_product` int(10) unsigned DEFAULT NULL,
  `name` varchar(145) NOT NULL,
  `notes` varchar(245) DEFAULT NULL,
  `discount_amount` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `discount_percentage` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `number_coupons` int(10) DEFAULT NULL,
  `valid_date` datetime DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_coupon`),
  UNIQUE KEY `[[dbprefix]]coupons_UK_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]crontab`
--

CREATE TABLE `[[dbprefix]]crontab` (
  `id_crontab` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` varchar(50) NOT NULL,
  `callback` varchar(140) NOT NULL,
  `params` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_started` datetime DEFAULT NULL,
  `date_finished` datetime DEFAULT NULL,
  `date_next` datetime DEFAULT NULL,
  `times_executed` bigint(20) DEFAULT '0',
  `output` varchar(50) DEFAULT NULL,
  `running` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_crontab`),
  UNIQUE KEY `[[dbprefix]]crontab_UK_name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]crontab`
--

INSERT INTO `[[dbprefix]]crontab` VALUES
(1, 'Sitemap', '0 3 * * *', 'Sitemap::generate', NULL, 'Regenerates the sitemap everyday at 3am', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(2, 'Clean Cache', '0 5 * * *', 'Core::delete_cache', NULL, 'Once day force to flush all the cache.', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(3, 'Optimize DB', '0 4 1 * *', 'Core::optimize_db', NULL, 'once a month we optimize the DB', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(4, 'Unpaid Orders', '0 7 * * *', 'Cron_Ad::unpaid', NULL, 'Notify unpaid orders 2 days after was created', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(5, 'Expired Featured Ad', '0 8 * * *', 'Cron_Ad::expired_featured', NULL, 'Notify by email of expired featured ad', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(6, 'Expired Ad', '0 9 * * *', 'Cron_Ad::expired', NULL, 'Email reminder of unreceived orders n days after was paid', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(7, 'Unreceived orders reminder', '0 10 * * *', 'Cron_Ad::unreceived', NULL, 'Mark unreceived orders as received n days after was paid', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(8, 'Mark unreceived orders as received', '0 11 * * *', 'Cron_Ad::mark_as_received', NULL, 'Notify by email of expired ad', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(9, 'Mark unshipped orders as cancelled', '0 11 * * *', 'Cron_Ad::mark_as_cancelled', NULL, 'Mark unshipped orders as cancelled n days after was paid', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(10, 'About to Expire Ad', '05 9 * * *', 'Cron_Ad::to_expire', NULL, 'Notify by email your ad is about to expire', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(11, 'About to Expire Subscription', '05 9 * * *', 'Cron_Subscription::to_expire', NULL, 'Notify by sms your subscription is about to expire', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(12, 'Renew subscription', '*/5 * * * *', 'Cron_Subscription::renew', NULL, 'Notify by email user subscription will expire.', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(13, 'Notify new updates', '0 9 * * 1', 'Cron_Update::notify', NULL, 'Notify by email of new site updates.', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(14, 'Generate Access Token', '10 9 1 * *', 'Social::GetAccessToken', NULL, 'Generate Facebook long-lived Access Token.', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(15, 'Algolia Search re-index', '0 * * * *', 'Cron_Algolia::reindex', NULL, 'Re-index everything', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(16, 'About to Expire Instagram Token', '0 12 * * *', 'Cron_Instagram::refreshUserTokens', NULL, 'Refresh user tokens two days before expiration date', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(17, 'Dispatch Daily Digest', '0 7 * * *', 'Cron_Digestmail::dispatch_daily_digest', NULL, 'Dispatch Daily Digest at 07:00', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(18, 'Dispatch Weekly Digest', '0 7 * * SAT', 'Cron_Digestmail::dispatch_weekly_digest', NULL, 'Dispatch Weekly Digest at 07:00 on Saturday', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1),
(19, 'Dispatch Monthly Digest', '0 7 1 * *', 'Cron_Digestmail::dispatch_monthly_digest', NULL, 'Dispatch Monthly Digest at 07:00 on day-of-month 1', '[[regtime]]', NULL, NULL, NULL, 0, NULL, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favorites`
--

CREATE TABLE `[[dbprefix]]favorites` (
  `id_favorite` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `id_ad` int(10) unsigned NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`id_favorite`),
  KEY `[[dbprefix]]favorites_IK_id_user_AND_id_ad` (`id_user`,`id_ad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forums`
--

CREATE TABLE `[[dbprefix]]forums` (
  `id_forum` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(145) NOT NULL,
  `order` int(2) unsigned NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id_forum_parent` int(10) unsigned NOT NULL DEFAULT '0',
  `parent_deep` int(2) unsigned NOT NULL DEFAULT '0',
  `seoname` varchar(145) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY USING BTREE (`id_forum`),
  UNIQUE KEY `[[dbprefix]]forums_IK_seo_name` (`seoname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]locations`
--

CREATE TABLE `[[dbprefix]]locations` (
  `id_location` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `order` int(2) unsigned NOT NULL DEFAULT '0',
  `id_location_parent` int(10) unsigned NOT NULL DEFAULT '0',
  `parent_deep` int(2) unsigned NOT NULL DEFAULT '0',
  `seoname` varchar(145) NOT NULL,
  `description` text,
  `last_modified` datetime DEFAULT NULL,
  `has_image` tinyint(1) NOT NULL DEFAULT '0',
  `latitude` float(10,6) DEFAULT NULL,
  `longitude` float(10,6) DEFAULT NULL,
  `id_geoname` int(10) unsigned DEFAULT NULL,
  `fcodename_geoname` varchar(145) DEFAULT NULL,
  `translations` text,
  PRIMARY KEY (`id_location`),
  UNIQUE KEY `[[dbprefix]]loations_UK_seoname` (`seoname`),
  KEY `[[dbprefix]]locations_IK_id_location_parent` (`id_location_parent`),
  KEY `[[dbprefix]]locations_IK_id_location_parent_AND_parent_deep` (`id_location_parent`,`parent_deep`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]locations`
--

INSERT INTO `[[dbprefix]]locations` VALUES
(1, 'Home location', 0, 0, 0, 'all', 'root location', NULL, 0, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `id_message` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_ad` int(10) unsigned DEFAULT NULL,
  `id_message_parent` int(10) unsigned DEFAULT NULL,
  `id_user_from` int(10) unsigned NOT NULL,
  `id_user_to` int(10) unsigned NOT NULL,
  `message` text NOT NULL,
  `price` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `read_date` datetime DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status_to` tinyint(1) NOT NULL DEFAULT '0',
  `status_from` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY USING BTREE (`id_message`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders`
--

CREATE TABLE `[[dbprefix]]orders` (
  `id_order` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `id_ad` int(10) unsigned DEFAULT NULL,
  `id_product` varchar(20) NOT NULL,
  `id_coupon` int(10) unsigned DEFAULT NULL,
  `paymethod` varchar(20) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `pay_date` datetime DEFAULT NULL,
  `currency` char(3) NOT NULL,
  `amount` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `description` varchar(145) DEFAULT NULL,
  `txn_id` varchar(255) DEFAULT NULL,
  `featured_days` int(10) unsigned DEFAULT NULL,
  `VAT_country` varchar(20) DEFAULT NULL,
  `VAT_number` varchar(20) DEFAULT NULL,
  `VAT` varchar(20) DEFAULT NULL,
  `quantity` int(11) NOT NULL DEFAULT '0',
  `received` datetime DEFAULT NULL,
  `shipped` datetime DEFAULT NULL,
  `shipping_tracking_code` varchar(255) DEFAULT NULL,
  `shipping_provider_name` varchar(140) DEFAULT NULL,
  `cancelled` datetime DEFAULT NULL,
  `paid_out` datetime DEFAULT NULL,
  PRIMARY KEY (`id_order`),
  KEY `[[dbprefix]]orders_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]orders_IK_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plans`
--

CREATE TABLE `[[dbprefix]]plans` (
  `id_plan` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(145) NOT NULL,
  `seoname` varchar(145) NOT NULL,
  `description` mediumtext NOT NULL,
  `price` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `days` int(10) DEFAULT '1',
  `amount_ads` int(10) DEFAULT '1',
  `marketplace_fee` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_plan`),
  UNIQUE KEY `[[dbprefix]]plan_UK_seoname` (`seoname`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=100 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]posts`
--

CREATE TABLE `[[dbprefix]]posts` (
  `id_post` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `id_post_parent` int(10) unsigned DEFAULT NULL,
  `id_forum` int(10) unsigned DEFAULT NULL,
  `title` varchar(245) NOT NULL,
  `seotitle` varchar(191) NOT NULL,
  `description` mediumtext NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip_address` bigint(20) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `locale` varchar(5) DEFAULT NULL,
  PRIMARY KEY USING BTREE (`id_post`),
  UNIQUE KEY `[[dbprefix]]posts_UK_locale_AND_seotitle` (`locale`,`seotitle`),
  KEY `[[dbprefix]]posts_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]posts_IK_id_post_parent` (`id_post_parent`),
  KEY `[[dbprefix]]posts_IK_id_forum` (`id_forum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reviews`
--

CREATE TABLE `[[dbprefix]]reviews` (
  `id_review` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `id_ad` int(10) unsigned NOT NULL,
  `rate` int(2) unsigned NOT NULL DEFAULT '0',
  `description` varchar(1000) NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip_address` bigint(20) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY USING BTREE (`id_review`),
  KEY `[[dbprefix]]reviews_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]reviews_IK_id_ad` (`id_ad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]roles`
--

CREATE TABLE `[[dbprefix]]roles` (
  `id_role` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `description` varchar(245) DEFAULT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_role`),
  UNIQUE KEY `[[dbprefix]]roles_UK_name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]roles`
--

INSERT INTO `[[dbprefix]]roles` VALUES
(1, 'user', 'Normal user', '[[regtime]]'),
(5, 'translator', 'User + Translations', '[[regtime]]'),
(7, 'moderator', 'Moderator', '[[regtime]]'),
(10, 'admin', 'Full access', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]subscribers`
--

CREATE TABLE `[[dbprefix]]subscribers` (
  `id_subscribe` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `id_category` int(10) unsigned NOT NULL DEFAULT '0',
  `id_location` int(10) unsigned NOT NULL DEFAULT '0',
  `min_price` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `max_price` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_subscribe`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]subscriptions`
--

CREATE TABLE `[[dbprefix]]subscriptions` (
  `id_subscription` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_order` int(10) unsigned NOT NULL,
  `id_user` int(10) unsigned NOT NULL,
  `id_plan` int(10) unsigned NOT NULL,
  `amount_ads` int(10) DEFAULT '1',
  `amount_ads_left` int(10) DEFAULT '0',
  `expire_date` datetime DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_subscription`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]transactions`
--

CREATE TABLE `[[dbprefix]]transactions` (
  `id_transaction` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned DEFAULT NULL,
  `id_user_from` int(10) unsigned DEFAULT NULL,
  `id_order` int(10) unsigned DEFAULT NULL,
  `amount` int(10) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_transaction`),
  KEY `[[dbprefix]]transactions_IK_id_user` (`id_user`),
  KEY `[[dbprefix]]transactions_IK_id_user_from` (`id_user_from`),
  KEY `[[dbprefix]]transactions_IK_id_order` (`id_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id_user` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(145) DEFAULT NULL,
  `seoname` varchar(145) DEFAULT NULL,
  `email` varchar(145) NOT NULL,
  `password` varchar(64) NOT NULL,
  `description` text,
  `status` int(1) NOT NULL DEFAULT '0',
  `id_role` int(10) unsigned DEFAULT '1',
  `id_location` int(10) unsigned DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_modified` datetime DEFAULT NULL,
  `logins` int(10) unsigned NOT NULL DEFAULT '0',
  `last_login` datetime DEFAULT NULL,
  `last_ip` bigint(20) DEFAULT NULL,
  `user_agent` varchar(40) DEFAULT NULL,
  `token` varchar(40) DEFAULT NULL,
  `token_created` datetime DEFAULT NULL,
  `token_expires` datetime DEFAULT NULL,
  `api_token` varchar(40) DEFAULT NULL,
  `hybridauth_provider_name` varchar(40) DEFAULT NULL,
  `hybridauth_provider_uid` varchar(191) DEFAULT NULL,
  `subscriber` tinyint(1) NOT NULL DEFAULT '1',
  `rate` float(4,2) DEFAULT NULL,
  `has_image` tinyint(1) NOT NULL DEFAULT '0',
  `failed_attempts` int(10) unsigned NOT NULL DEFAULT '0',
  `last_failed` datetime DEFAULT NULL,
  `notification_date` datetime DEFAULT NULL,
  `device_id` varchar(255) DEFAULT NULL,
  `stripe_user_id` varchar(140) DEFAULT NULL,
  `stripe_agreement` varchar(40) DEFAULT NULL,
  `escrow_email` varchar(140) DEFAULT NULL,
  `escrow_api_key` varchar(140) DEFAULT NULL,
  `google_authenticator` varchar(40) DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `latitude` float(10,6) DEFAULT NULL,
  `longitude` float(10,6) DEFAULT NULL,
  `address` varchar(145) DEFAULT NULL,
  `locale` varchar(5) DEFAULT NULL,
  `verification_code` int(6) DEFAULT NULL,
  `ewallet_balance` int(10) unsigned DEFAULT '0',
  `digest_interval` varchar(140) DEFAULT 'never',
  `instagram_token` varchar(255) DEFAULT NULL,
  `instagram_token_expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_user`),
  UNIQUE KEY `[[dbprefix]]users_UK_email` (`email`),
  UNIQUE KEY `[[dbprefix]]users_UK_token` (`token`),
  UNIQUE KEY `[[dbprefix]]users_UK_api_token` (`api_token`),
  UNIQUE KEY `[[dbprefix]]users_UK_seoname` (`seoname`),
  UNIQUE KEY `[[dbprefix]]users_UK_provider_AND_uid` (`hybridauth_provider_name`,`hybridauth_provider_uid`),
  KEY `[[dbprefix]]users_IK_status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', 'admin', '[[admin_email]]', '[[admin_pass]]', NULL, 1, 10, NULL, '[[regtime]]', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 'never', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]visits`
--

CREATE TABLE `[[dbprefix]]visits` (
  `id_visit` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_ad` int(10) unsigned DEFAULT NULL,
  `hits` int(10) NOT NULL DEFAULT '0',
  `contacts` int(10) NOT NULL DEFAULT '0',
  `created` date NOT NULL,
  PRIMARY KEY (`id_visit`),
  UNIQUE KEY `[[dbprefix]]visits_UK_id_ad_AND_created` (`id_ad`,`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
