<?php
//---------------------------------------------------------
//صxml
//---------------------------------------------------------

class XmlParseUtil{
	
	/**
	 * xmlַΪDocument
	 * 
	 * @param xmlStr
	 * @param charsetName
	 * @return
	 */
	function parseDoc($xmlStr, $charsetName){
		$dom = new DOMDocument('1.0', $charsetName);
        $dom->loadXML($xmlStr);
		return $dom;
	}
	
	/**
	 * xmlΪmap
	 * 
	 * @param xml
	 * @param charset
	 * @return
	 */
	function openapiXmlToMapByDoc($doc, $charset) {
		$doc->normalize();
		$root = $doc->documentElement; //ȡXMLݵĸ
		$nodeList = $root->childNodes; //$nodeӽڵ
		return $this->openapiXmlToMapByNodeList($nodeList, $charset);
	}

	/**
	 * xml nodelistΪmap
	 * 
	 * @param xml
	 * @param charset
	 * @return
	 */
	function openapiXmlToMapByNodeList($nodeList, $charset) {
		$hashMap = array();
		if(!empty($nodeList)){
			foreach($nodeList as $e) //ѭȡÿһӽڵ
			{
				if($e->nodeType == XML_ELEMENT_NODE) //ӽڵΪڵú
				{
					$value= iconv("UTF-8",$charset,$e->nodeValue); //עҪתģΪXMLĬΪUTF-8ʽ
					$hashMap[$e->nodeName] = $value;
				}
			}
		}
		return $hashMap;
	}

	/**
	 * xmlΪmap
	 * 
	 * @param xml
	 * @param charset
	 * @return
	 */
	function openapiXmlToMap($xml, $charset) {
		$stringDOM = new DOMDocument();
		try{
			@$stringDOM->loadXML($xml);
			return $this->openapiXmlToMapByDoc($stringDOM, $charset);
		}
		catch(Exception $e){
			throw new SDKRuntimeException("xmlʧ:" . $xml . ",". $e . "<br>");
		}
	}
	
	/**
	 * õΨһı
	 * 
	 * @param doc      XML Document
	 * @param tagName  
	 * @return
	 */
	function getSingleValue($doc, $tagName) {
		$tmp_tag = $doc->getElementsByTagName($TagName);
        $tmp_value = $tmp_tag -> nodeValue;
        return iconv("UTF-8","GBK",$tmp_value);
	}

	
}


?>