
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `cubi309`
--

-- --------------------------------------------------------

--
-- Table structure for table `acl_action`
--

CREATE TABLE `acl_action` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(64) NOT NULL DEFAULT '',
  `resource` varchar(64) NOT NULL DEFAULT '',
  `action` varchar(64) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=52 ;

--
-- Dumping data for table `acl_action`
--

INSERT INTO `acl_action` VALUES
(1, 'system', 'Site', 'Administer_General', 'General administration of the site'),
(2, 'system', 'User', 'Administer_Users', 'Administration of users'),
(3, 'system', 'User', 'Administer_User_ACL', 'Administration of user access control'),
(4, 'system', 'Role', 'Administer_Roles', 'Administration of user roles'),
(5, 'system', 'Group', 'Administer_Groups', 'Administration of user groups'),
(6, 'system', 'Module', 'Administer_Modules', 'Administration includes view modules, load modules, activate/deactivate modules'),
(7, 'system', 'System', 'Administer_System', 'Administration of system setting'),
(8, 'system', 'Session', 'Administer_Session', 'Administration of user sessions'),
(9, 'system', 'Session', 'Switch_Session', 'Switch user session on fly'),
(10, 'menu', 'Menu', 'Administer_Menu', 'Can manage menu content for the application'),
(11, 'help', 'Help', 'Administer_Help', 'Can manage help content for the application'),
(12, 'help', 'Help', 'Access_Widget', 'Show help widget on users left panel'),
(13, 'contact', 'contact', 'access', 'access my contact'),
(14, 'contact', 'contact', 'view_level_1', 'view level 1 protected field'),
(15, 'contact', 'contact', 'view_level_2', 'view level 2 protected field'),
(16, 'contact', 'contact', 'view_level_3', 'view level 3 protected field'),
(17, 'cronjob', 'cronjob', 'Administer_Cron', 'Manage cronjobs with crontab syntax'),
(18, 'attachment', 'attachment', 'access', 'access attachments'),
(19, 'backup', 'backup', 'Access_Backup', 'Access Backup'),
(20, 'cache', 'cache', 'Administer_Cache', 'manage and view cache usage information'),
(21, 'changelog', 'changelog', 'access', 'access data change logs'),
(22, 'chart', 'Chart', 'View_Chart', 'View Charts'),
(23, 'common', 'data_assign', 'assign_to_other', 'Enable assign data to other groups'),
(24, 'common', 'data_assign', 'accept_other_assigned', 'Accept other groups assigned data'),
(25, 'common', 'data_manage', 'manage', 'Manage all data in entire system'),
(26, 'email', 'EmailQueue', 'Administer_Email_Queue', 'Can view/send/delete emails in the queue'),
(27, 'email', 'EmailLog', 'Administer_Email_Log', 'Can view/clear emails logs'),
(28, 'email', 'EmailSetting', 'Administer_Email_Setting', 'Can manage system email accounts'),
(29, 'email', 'EmailTemplate', 'Administer_Email_Template', 'Can manage system email templates'),
(30, 'eventlog', 'EventLog', 'Access_EventLog', 'Access event logs'),
(31, 'eventlog', 'EventLog', 'Administer_EventLog', 'Manage event logs'),
(32, 'extend', 'extend', 'access', 'access extend fields'),
(33, 'extend', 'extend', 'view_level_1', 'Extend Data Access Level 1'),
(34, 'extend', 'extend', 'view_level_2', 'Extend Data Access Level 2'),
(35, 'extend', 'extend', 'view_level_3', 'Extend Data Access Level 3'),
(36, 'location', 'location', 'access', 'access location'),
(37, 'location', 'location', 'setting', 'Administration of system default location setting'),
(38, 'market', 'Market', 'Manage', 'Manage App market repository and app installation'),
(39, 'myaccount', 'myaccount', 'access', 'access my account dashboard'),
(40, 'oauth', 'oauth', 'Administer', 'Manage OAuth Provider Setting'),
(41, 'oauth', 'oauth', 'MyAccount', 'Manage My Soical Accounts'),
(42, 'payment', 'payment', 'Manage', 'Can manage system Payment intergration'),
(43, 'picture', 'picture', 'access', 'access pictures'),
(44, 'security', 'Security', 'Administer_Security', 'Can manage security filtering rules for the application'),
(45, 'sms', 'sms', 'Manage', 'Can manage system SMS intergration'),
(46, 'theme', 'Theme', 'Administer_Theme', 'Can manage system theme package for the application'),
(47, 'translation', 'Translation', 'Administer_Transation', 'Can manage user interface translation for the application'),
(48, 'user', 'UserAccount', 'Edit_Own_Account', 'Can edit user own account data'),
(49, 'websvc', 'websvc', 'Access', 'Access Websvc Module Dashboard'),
(50, 'websvc', 'websvc.websvc', 'Access', 'Access WebsvcWebsvc'),
(51, 'websvc', 'websvc.websvc', 'Manage', 'Manage WebsvcWebsvc');

-- --------------------------------------------------------

--
-- Table structure for table `acl_role_action`
--

CREATE TABLE `acl_role_action` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL DEFAULT '0',
  `action_id` int(10) unsigned NOT NULL DEFAULT '0',
  `access_level` varchar(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  KEY `action_id` (`action_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=121 ;

--
-- Dumping data for table `acl_role_action`
--

INSERT INTO `acl_role_action` VALUES
(120, 1, 51, '1'),
(119, 1, 50, '1'),
(118, 1, 49, '1'),
(117, 1, 48, '1'),
(116, 1, 47, '1'),
(115, 1, 46, '1'),
(114, 1, 45, '1'),
(113, 1, 44, '1'),
(112, 1, 43, '1'),
(111, 1, 42, '1'),
(110, 1, 41, '1'),
(109, 1, 40, '1'),
(13, 2, 12, '1'),
(108, 1, 39, '1'),
(107, 1, 38, '1'),
(106, 1, 37, '1'),
(105, 1, 36, '1'),
(18, 4, 13, '1'),
(19, 4, 14, '1'),
(20, 4, 15, '1'),
(21, 4, 16, '1'),
(104, 1, 35, '1'),
(103, 1, 34, '1'),
(24, 2, 18, '1'),
(102, 1, 33, '1'),
(101, 1, 32, '1'),
(100, 1, 31, '1'),
(28, 2, 21, '1'),
(99, 1, 30, '1'),
(30, 2, 22, '1'),
(98, 1, 29, '1'),
(97, 1, 28, '1'),
(96, 1, 27, '1'),
(34, 5, 23, '1'),
(35, 6, 23, '1'),
(36, 5, 24, '1'),
(37, 6, 24, '1'),
(38, 6, 25, '1'),
(95, 1, 26, '1'),
(94, 1, 25, '1'),
(93, 1, 24, '1'),
(92, 1, 23, '1'),
(91, 1, 22, '1'),
(90, 1, 21, '1'),
(89, 1, 20, '1'),
(88, 1, 19, '1'),
(87, 1, 18, '1'),
(86, 1, 17, '1'),
(49, 2, 32, '1'),
(85, 1, 16, '1'),
(84, 1, 15, '1'),
(52, 2, 36, '1'),
(83, 1, 14, '1'),
(82, 1, 13, '1'),
(55, 2, 39, '1'),
(81, 1, 12, '1'),
(80, 1, 11, '1'),
(79, 1, 10, '1'),
(78, 1, 9, '1'),
(60, 2, 43, '1'),
(77, 1, 8, '1'),
(76, 1, 7, '1'),
(75, 1, 6, '1'),
(74, 1, 5, '1'),
(73, 1, 4, '1'),
(66, 2, 48, '1'),
(72, 1, 3, '1'),
(71, 1, 2, '1'),
(70, 1, 1, '1');

-- --------------------------------------------------------

--
-- Table structure for table `attachment`
--

CREATE TABLE `attachment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT '',
  `foreign_id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT '',
  `description` text NOT NULL,
  `path` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `filename` varchar(255) DEFAULT '',
  `filesize` int(11) DEFAULT '0',
  `md5` varchar(255) DEFAULT '',
  `sha256` varchar(255) DEFAULT '',
  `download_count` int(11) DEFAULT '0',
  `group_id` int(11) DEFAULT '1',
  `group_perm` int(11) DEFAULT '1',
  `other_perm` int(11) DEFAULT '1',
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `attachment_download_log`
--

CREATE TABLE `attachment_download_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `backup_device`
--

CREATE TABLE `backup_device` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `location` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `sortorder` int(11) NOT NULL,
  `system` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `backup_device`
--

INSERT INTO `backup_device` VALUES
(1, 'Cubi Storage', '{APP_FILE_PATH}/backup', 'Openbiz Cubi in system default backup files storage area.', 50, 1, 1, 1, '2011-04-16 12:44:45', 1, '2011-04-16 09:06:37');

-- --------------------------------------------------------

--
-- Table structure for table `changelog`
--

CREATE TABLE `changelog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT '',
  `foreign_id` int(11) NOT NULL,
  `form` text NOT NULL,
  `data` text NOT NULL,
  `comment` text NOT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `chart_color`
--

CREATE TABLE `chart_color` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `color_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort_order` int(2) DEFAULT NULL,
  `create_by` int(11) NOT NULL DEFAULT '1',
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL DEFAULT '1',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `chart_color`
--

INSERT INTO `chart_color` VALUES
(1, 'red', 'ff0000', 10, 1, '2010-10-25 23:27:36', 1, '2010-10-26 03:27:36'),
(2, 'blue', '000dff', 50, 1, '2010-10-25 23:27:55', 1, '2010-10-26 03:27:55');

-- --------------------------------------------------------

--
-- Table structure for table `contact`
--

CREATE TABLE `contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `company` varchar(255) NOT NULL,
  `department` varchar(255) DEFAULT '',
  `position` varchar(255) DEFAULT '',
  `fast_index` varchar(10) DEFAULT '',
  `photo` varchar(255) DEFAULT '',
  `phone` varchar(255) DEFAULT '',
  `mobile` varchar(255) DEFAULT '',
  `fax` varchar(255) DEFAULT '',
  `zipcode` varchar(255) DEFAULT '',
  `province` varchar(255) DEFAULT '',
  `city` varchar(255) DEFAULT '',
  `street` varchar(255) DEFAULT '',
  `country` varchar(255) DEFAULT '',
  `email` varchar(255) DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `qq` varchar(255) DEFAULT '',
  `icq` varchar(255) DEFAULT '',
  `skype` varchar(255) DEFAULT '',
  `yahoo` varchar(255) DEFAULT '',
  `misc` text,
  `type_id` int(11) NOT NULL,
  `sortorder` int(11) NOT NULL,
  `user_id` int(11) DEFAULT '0',
  `published` int(11) NOT NULL DEFAULT '1',
  `default` int(11) DEFAULT '0',
  `access` varchar(255) DEFAULT NULL,
  `params` text,
  `foreign_key` varchar(255) DEFAULT '',
  `source` varchar(255) DEFAULT NULL,
  `owner_id` int(11) DEFAULT '0',
  `account_id` int(11) DEFAULT '0',
  `group_id` int(11) DEFAULT '0',
  `group_perm` int(11) DEFAULT NULL,
  `other_perm` int(11) DEFAULT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_id` (`type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `contact`
--

INSERT INTO `contact` VALUES
(1, '', '', '[[admin_username]]', '[[site_name]]', '', '', '', '', '', '0000000000', '', '', '', '', '', '', '[[admin_email]]', '', '', '', '', '', NULL, 1, 100, 1, 1, 0, NULL, NULL, '', NULL, 1, 0, 1, 1, 1, 1, '2010-05-24 08:00:01', 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `contact_import`
--

CREATE TABLE `contact_import` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `company` varchar(255) NOT NULL,
  `department` varchar(255) DEFAULT '',
  `position` varchar(255) DEFAULT '',
  `fast_index` varchar(10) DEFAULT '',
  `photo` varchar(255) DEFAULT '',
  `phone` varchar(255) DEFAULT '',
  `mobile` varchar(255) DEFAULT '',
  `fax` varchar(255) DEFAULT '',
  `zipcode` varchar(255) DEFAULT '',
  `province` varchar(255) DEFAULT '',
  `city` varchar(255) DEFAULT '',
  `street` varchar(255) DEFAULT '',
  `country` varchar(255) DEFAULT '',
  `email` varchar(255) DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `qq` varchar(255) DEFAULT '',
  `icq` varchar(255) DEFAULT '',
  `skype` varchar(255) DEFAULT '',
  `yahoo` varchar(255) DEFAULT '',
  `user_id` int(11) DEFAULT '0',
  `selected` int(11) DEFAULT '0',
  `foreign_key` varchar(255) DEFAULT '',
  `source` varchar(255) DEFAULT '',
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `contact_related`
--

CREATE TABLE `contact_related` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL DEFAULT '0',
  `related_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `related_id` (`related_id`),
  KEY `contact_id` (`contact_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `contact_type`
--

CREATE TABLE `contact_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `color` varchar(255) NOT NULL,
  `sortorder` int(11) NOT NULL,
  `published` int(11) NOT NULL,
  `group_id` int(11) DEFAULT NULL,
  `group_perm` int(11) DEFAULT NULL,
  `other_perm` int(11) DEFAULT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `contact_type`
--

INSERT INTO `contact_type` VALUES
(1, 'Colleague', 'Our company colleagues contacts', '66c2ff', 45, 1, 1, 1, 1, 1, '2010-05-23 01:09:06', 1, '2012-02-05 15:59:07'),
(2, 'Potential Client', 'Potential clients, People interested buy not start using our product yet.', 'b8ff7d', 45, 1, 1, 1, 1, 1, '2010-05-23 01:23:04', 1, '2012-02-05 16:02:01'),
(3, 'Provider', 'All kind of providers. Like product hardware provider, printing service providers etc.', '7fff7f', 50, 1, 1, 1, 1, 1, '2010-05-23 01:34:12', 1, '2012-02-05 16:03:38'),
(4, 'Existing Client', 'Client who already started using our products.', 'ffd042', 45, 1, 1, 1, 1, 1, '2010-05-23 01:34:39', 1, '2012-02-05 16:02:29'),
(5, 'Government', 'Government department managers contacts', 'fa8282', 50, 1, 1, 1, 1, 1, '2011-12-02 23:11:18', 1, '2012-02-05 15:58:44'),
(6, 'Misc', 'Miscellaneous, Other type of contacts', 'd1d1d1', 50, 1, 1, 1, 1, 1, '2012-02-05 10:56:40', 1, '2012-02-05 15:58:39');

-- --------------------------------------------------------

--
-- Table structure for table `cronjob`
--

CREATE TABLE `cronjob` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `minute` varchar(255) NOT NULL DEFAULT '',
  `hour` varchar(255) NOT NULL DEFAULT '',
  `day` varchar(255) NOT NULL DEFAULT '',
  `month` varchar(255) NOT NULL DEFAULT '',
  `weekday` varchar(255) NOT NULL DEFAULT '',
  `command` varchar(255) NOT NULL DEFAULT '',
  `sendmail` varchar(255) DEFAULT '',
  `max_run` int(2) DEFAULT '1',
  `num_run` int(2) DEFAULT '0',
  `description` varchar(255) DEFAULT NULL,
  `status` int(1) DEFAULT '1',
  `last_exec` int(11) DEFAULT NULL,
  `create_by` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_by` int(11) DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `minute` (`minute`),
  KEY `hour` (`hour`),
  KEY `weekday` (`day`),
  KEY `month` (`month`),
  KEY `week` (`weekday`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `cronjob`
--

INSERT INTO `cronjob` VALUES
(1, 'Weekly Backup Entire System', '1', '20', '*', '*', '5', '{APP_HOME}/bin/cronjob/run_svc.php backup.lib.BackupService BackupSystem SystemBak', '', 1, 0, 'Weekly backup entire system,\nRun at every Friday 8pm', 1, NULL, 2, '2012-02-07 10:37:15', 2, '2012-02-07 10:37:15'),
(2, 'Daily Backup System DB', '1', '1', '*', '*', '*', '{APP_HOME}/bin/cronjob/run_svc.php backup.lib.BackupService BackupDB SystemDB', '', 1, 0, 'Daily backup system database into default backup location.\nRunning in everyday midnight', 1, NULL, 2, '2012-02-07 10:35:02', 2, '2012-02-07 10:37:30'),
(3, 'Sending Email Job', '*', '*', '*', '*', '*', '{APP_HOME}/bin/cronjob/run_svc.php  userEmailService sendEmailFromQueue', '', 1, 0, 'System Email Queue Service', 1, 1296586403, 1, '2011-02-01 10:24:31', 1, '2011-02-01 10:51:04'),
(4, 'Sending SMS Job', '*', '*', '*', '*', '*', '{APP_HOME}/bin/cronjob/run_svc.php  sms.lib.SmsService SendSmsFromQueue', '', 1, 0, 'System SMS Queue Service', 1, 1296586403, 1, '2011-02-01 10:24:31', 1, '2011-02-01 10:51:04');

-- --------------------------------------------------------

--
-- Table structure for table `data_acl`
--

CREATE TABLE `data_acl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `record_table` varchar(255) NOT NULL,
  `record_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user_perm` int(11) NOT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `record_table` (`record_table`),
  KEY `record_id` (`record_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_log`
--

CREATE TABLE `email_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `result` varchar(255) NOT NULL,
  `sender` varchar(255) NOT NULL,
  `sender_name` varchar(255) NOT NULL,
  `recipients` text NOT NULL,
  `subject` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `result` (`result`),
  KEY `sender` (`sender`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_queue`
--

CREATE TABLE `email_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sender` varchar(255) NOT NULL,
  `recipient_name` varchar(255) NOT NULL,
  `recipient` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `status` enum('pending','sending','sent') NOT NULL,
  `create_time` datetime NOT NULL,
  `sent_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `flag` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `event_log`
--

CREATE TABLE `event_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `ipaddr` varchar(16) NOT NULL,
  `event` varchar(255) NOT NULL,
  `message` varchar(255) NOT NULL,
  `comment` text NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `UserID` (`user_id`,`ipaddr`,`event`),
  KEY `Message` (`message`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `event_log`
--


-- --------------------------------------------------------

--
-- Table structure for table `extend_data`
--

CREATE TABLE `extend_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(255) NOT NULL,
  `type_id` int(11) NOT NULL,
  `record_id` int(11) NOT NULL,
  `field_1` longtext NOT NULL,
  `field_2` longtext NOT NULL,
  `field_3` longtext NOT NULL,
  `field_4` longtext NOT NULL,
  `field_5` longtext NOT NULL,
  `field_6` longtext NOT NULL,
  `field_7` longtext NOT NULL,
  `field_8` longtext NOT NULL,
  `field_9` longtext NOT NULL,
  `field_10` longtext NOT NULL,
  `field_11` longtext NOT NULL,
  `field_12` longtext NOT NULL,
  `field_13` longtext NOT NULL,
  `field_14` longtext NOT NULL,
  `field_15` longtext NOT NULL,
  `field_16` longtext NOT NULL,
  `field_17` longtext NOT NULL,
  `field_18` longtext NOT NULL,
  `field_19` longtext NOT NULL,
  `field_20` longtext NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` datetime NOT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`,`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `extend_setting`
--

CREATE TABLE `extend_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(255) NOT NULL,
  `type_id` int(11) NOT NULL,
  `class` varchar(255) NOT NULL,
  `field` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `defaultvalue` varchar(255) NOT NULL,
  `options` longtext NOT NULL,
  `sortorder` int(11) NOT NULL,
  `access` varchar(255) NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` datetime NOT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`,`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `extend_setting_option`
--

CREATE TABLE `extend_setting_option` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_id` int(11) NOT NULL,
  `lang` varchar(255) NOT NULL,
  `text` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `lang` (`lang`,`setting_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `extend_setting_translation`
--

CREATE TABLE `extend_setting_translation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_id` int(11) NOT NULL,
  `lang` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `defaultvalue` varchar(255) NOT NULL,
  `options` longtext NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` datetime NOT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `lang` (`lang`,`setting_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group`
--

CREATE TABLE `group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  `default` int(2) DEFAULT '0',
  `status` int(2) DEFAULT '1',
  `create_by` int(10) DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  `update_by` int(10) DEFAULT '1',
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `group`
--

INSERT INTO `group` VALUES
(1, 'Default Group', NULL, 1, 1, 1, '2011-07-06 18:33:15', 1, '2011-07-06 18:33:15');

-- --------------------------------------------------------

--
-- Table structure for table `help`
--

CREATE TABLE `help` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '10',
  `content` longtext,
  `add1` varchar(255) DEFAULT NULL,
  `add2` int(10) DEFAULT NULL,
  `add3` varchar(255) DEFAULT NULL,
  `add4` int(10) DEFAULT NULL,
  `create_by` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_by` int(11) DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `create_by` (`create_by`),
  KEY `update_by` (`update_by`),
  KEY `category_id` (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=55 ;

--
-- Dumping data for table `help`
--

INSERT INTO `help` VALUES
(1, 3, 'What is Module Management?', '<p>\n	Module Management screen allows administrator to manage modules in the application</p>\n', 10, '<p>\n	Action can be done on the module management screen.</p>\n<ul>\n	<li>\n		Edit button. This is to activate or deactivate a module</li>\n	<li>\n		Delete button. This is to delete a module. When a module is deleted, its ACL settings are deleted as well.</li>\n	<li>\n		Load button. This is to load new modules added in the modules directory. The loading processor will read mod.xml, and load module and it ACL info to the system.</li>\n</ul>\n', NULL, NULL, NULL, NULL, 1, '2010-05-01 13:01:58', 1, '2010-05-01 13:06:21'),
(2, 1, 'What is User Management ?', '<p>\n	User Manage screen allows administrator to manage application users</p>\n', 10, '<p>\n	Action can be done on the user management screen</p>\n<ul>\n	<li>\n		Add button to add a new user</li>\n	<li>\n		Edit button to edit a selected user</li>\n	<li>\n		Delete button to delete a selected user</li>\n</ul>\n', NULL, NULL, NULL, NULL, 1, '2010-02-07 16:07:21', 1, '2010-05-01 12:50:12'),
(3, 2, 'What is Role Management?', '<p>\n	Role Management screen allows administrator to manage roles in the application</p>\n', 10, '<p>\n	Actions can be done on the role management screen.</p>\n<ul>\n	<li>\n		Add button</li>\n	<li>\n		Edit button</li>\n	<li>\n		Delete button. If a role is deleted, its permissions will be deleted as well.</li>\n</ul>\n', NULL, NULL, NULL, NULL, 1, '2010-02-07 17:25:46', 1, '2010-05-01 12:58:06'),
(4, 6, 'How to ceate a help tip?', '<p>\r\n	You need to go to Manage Help tips module and click Add button to create a new help tips.</p>\r\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2010-04-24 04:18:35', 1, '2010-04-24 04:19:35'),
(5, 6, 'How to map a help category to system module?', '<p>\r\n	You can mapping a help category to a module&#39;s left help panel by specified URL match. then the module will only show help tips under this category.</p>\r\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2010-04-24 04:21:54', 1, '2010-04-24 04:21:54'),
(6, 3, 'How to reload a module?', '<p>\n	A module can be reloaded to update its change</p>\n', 10, '<p>\n	On the module management screen, click the module name to drilldown the module detail form. On this form, click Reload button to update the changes into the system</p>\n', NULL, NULL, NULL, NULL, 1, '2010-05-01 13:09:09', 1, '2010-05-01 13:09:09'),
(7, 4, 'What is Event Log?', '<p>\n	Event log screen is to list all events logged by the application</p>\n', 10, '<p>\n	On the Event Log screen, clicking on the comments link to see to event log detail.</p>\n<p>\n	Clicking on the Clear button, all log records will be deleted from the log table. Be careful of using it.</p>\n', NULL, NULL, NULL, NULL, 1, '2010-05-01 13:12:11', 1, '2010-05-01 13:15:33'),
(8, 5, 'How to manage email queue?', '<p>\n	Email Queue Management screen allows user to manage queued emails</p>\n', 10, '<p>\n	Action can be done on the email queue management screen.</p>\n<ul>\n	<li>\n		Send All button. This is to send all queued email immediately</li>\n	<li>\n		Send button. This is to send the selected email immediately</li>\n	<li>\n		Delete. This is to delete the selected email from the queue</li>\n	<li>\n		Delete Sent. This is to delete all sent emails from the queue</li>\n	<li>\n		Delete All. This is to empty the email queue</li>\n</ul>\n', NULL, NULL, NULL, NULL, 1, '2010-05-01 13:17:05', 1, '2010-05-01 16:18:48'),
(9, 5, 'How to manage email log?', '<p>\n	Email Log Management screen allows user to manage email activities</p>\n', 10, '<p>\n	Clicking the Clear button will empty the email log records.</p>\n', NULL, NULL, NULL, NULL, 1, '2010-05-01 13:18:11', 1, '2010-05-01 16:19:59'),
(10, 8, 'What is theme management', '<p>\n	Theme Management allow administor to review / install or uninstall a theme for the system. </p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2011-12-15 19:31:11', 1, '2011-12-15 19:31:11'),
(11, 11, 'How to change default language', '<p>\n	change cubi platfrom language from user preference setting.</p>\n', 10, '<p>\n	1 click user module and select user preference setting.&nbsp;</p>\n<p>\n	2 go down the the bottom of the page click &#39;edit&#39; button.</p>\n<p>\n	3 select the language you want to used for your cubi platform from &#39;general&#39;--&gt;&#39;default language&#39; options.</p>\n<p>\n	4 go to bottom of the page click &#39;save&#39; button.</p>\n<p>\n	5 re-log into the cubi.</p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-16 10:59:20', 1, '2011-12-16 16:05:57'),
(12, 10, 'What is Cronjob item', '<p>\n	Cron is a time-based job scheduler in cubi systems.It&#39;s enables users to schedule jobs (commands or shell scripts) to run periodically at certain times or dates.</p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2011-12-16 15:52:21', 1, '2011-12-27 02:38:19'),
(13, 1, 'How to add a new user?', '<p>\n	follow the user manangement module to add an new user into cubi platform.</p>\n', 10, '<p>\n	1 Click user management function add button under user module as below screen picture.</p>\n<p>\n	<img alt="" height="198" src="/cubi/files/upload/helptips/user/1.png" width="732" /></p>\n<p>\n	2 input the new user name and password and email address and set state to active then click save.</p>\n<p>\n	<img alt="" height="352" src="/cubi/files/upload/helptips/user/2.png" width="381" /></p>\n<p>\n	3 input the related user information like address, telephone and so on in the contact profile form then save.</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/user/3.png" /></p>\n<p>\n	4 now you have add an new user into cubi platform.</p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-16 17:33:15', 1, '2011-12-25 19:40:53'),
(14, 1, 'How to change user profile', '<p>\n	change or replenish user&#39;s personal information&nbsp;</p>\n', 10, '<p>\n	&nbsp;1 log into cubi</p>\n<p>\n	&nbsp;</p>\n<p>\n	2 click left navigation user module</p>\n<p>\n	<img alt="" height="126" src="/cubi/files/upload/helptips/user/4.png" width="189" /></p>\n<p>\n	3 select the user that you need to change information</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/user/5.png" /></p>\n<p>\n	3 click profile button to change or replenish your personal information like phone number or address</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/user/6.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-22 23:21:39', 1, '2011-12-25 19:47:18'),
(15, 2, 'What is role for?', '<p>\n	User role could be used for assign different role management in different modules.</p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2011-12-23 16:06:02', 1, '2011-12-23 16:06:02'),
(16, 2, 'How to create an role and set up his authority??', '<p>\n	User could split up administrator and common user with role management</p>\n', 10, '<p>\n	1 click left navigation role moudle</p>\n<p>\n	<img alt="" height="119" src="/cubi/files/upload/helptips/role/1.png" width="189" /></p>\n<p>\n	2 click add button to create an new type role you needed for your application</p>\n<p>\n	<img alt="" height="138" src="/cubi/files/upload/helptips/role/2.png" width="715" /></p>\n<p>\n	3 create an new type of role you needed</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/role/3.png" /></p>\n<p>\n	4 back to role management page select the new role you have created and click perm for set up access permission</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/role/4.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-23 16:51:56', 1, '2011-12-25 20:06:11'),
(17, 2, 'what is default page for?', '<p>\n	there is an option when user create an new type of role in cubi platfrom called &quot;default page&quot;</p>\n', 10, '<p>\n	1 there is an option when user create an new type of role in cubi platfrom called &quot;Default page&quot;</p>\n<p>\n	/cubi/files/upload/helptips/role/2.png<img alt="" src="/cubi/files/upload/helptips/role/5.png" /></p>\n<p>\n	2 the default page option is the first start page when user are using the role log into cubi platform.</p>\n<p>\n	&nbsp;</p>\n<p>\n	3 the default page option is part of full path of the moudle, for example: email moudle user default page should be the path &quot;/email/email_queue_list&quot; after index.php</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/role/6.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-23 17:12:17', 1, '2011-12-25 20:07:13'),
(19, 12, 'backup Cubi system to portable hard disk', '<p>\n	user can use &quot;Device and Location&quot; funcation under backup module to backup their cubi data into their portable hard disk or the other hard disk</p>\n', 10, '<p>\n	1 click &quot;Device and Location&quot; function under Backup module</p>\n<p>\n	<img alt="" height="82" src="/cubi/files/upload/helptips/backup/5.png" width="198" /></p>\n<p>\n	2 click add button to set up an user&#39;s backup device</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/backup/6.png" /></p>\n<p>\n	3 input the user&#39;s backup device path like: /mnt/ (the user&#39;s backup up device could be an portable hard disk or even a flahs disk that connected with cubi server, then administrator can set up the hard disk mount point usually /mnt/)</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/backup/7.png" /></p>\n<p>\n	&nbsp;</p>\n<p>\n	4 save and then Cubi&#39;s data have been backup into user&#39;s backup device.</p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-25 21:10:33', 1, '2011-12-25 21:10:33'),
(20, 12, 'why backup?', '<p>\n	Usually all the user&#39;s Cubi apply information and data have been saved into Cubi server, but for enhance system safety user&#39;s can backup Cubi date into Portable hard disk</p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2011-12-25 21:15:20', 1, '2011-12-25 21:15:20'),
(21, 14, 'what is group module for?', '<p>\n	group module can set up different group for user that could be used for split up user from different projects</p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2011-12-26 00:22:49', 1, '2011-12-26 00:22:49'),
(22, 14, 'How to create a group and set user into it', '<p>\n	this is an example of how to use group to partition users</p>\n', 10, '<p>\n	1 click &quot;Group Management&quot; function under dgroup module</p>\n<p>\n	<img alt="" height="80" src="/cubi/files/upload/helptips/group/1.png" width="190" /></p>\n<p>\n	2 click add button to create an new group</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/group/2.png" /></p>\n<p>\n	3 input the new group name and description then save it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/group/3.png" /></p>\n<p>\n	4 go to the &quot;User Management&quot; function under user module</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/group/4.png" /></p>\n<p>\n	5 select the user &quot;jack&quot; who you want to assign to the new create group &quot;project&quot; and click Detail button</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/group/5.png" /></p>\n<p>\n	6 click add button in user group panel in the bottom of the User Detail page </p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/group/6.png" /></p>\n<p>\n	7 select the group you want the user &quot;jack&quot; belong to and check it then will automatically save the change</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/group/7.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-26 00:34:51', 1, '2011-12-26 00:56:52'),
(23, 14, 'what is Group Data Sharing for?', '<p>\n	It is set up the default Group Data Share rule </p>\n<p>\n	Default setting is user create an new record will auto have full control and his group can read the record and others can not see it</p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2011-12-26 01:25:10', 1, '2011-12-26 01:25:10'),
(24, 15, 'How to connect database', '<p>\n	Cubi platform not only limit to connect with it&#39;s own database but also can connect to other database in different locations</p>\n', 10, '<p>\n	1 click &quot;Database Connections&quot; function under system module</p>\n<p>\n	<img alt="" height="78" src="/cubi/files/upload/helptips/system/1.png" width="189" /></p>\n<p>\n	2 click add button to create an new database connection</p>\n<p>\n	<img alt="" height="268" src="/cubi/files/upload/helptips/system/2.png" width="727" /></p>\n<p>\n	3 input the database connection name and select database type and input username and password of the database connection</p>\n<p>\n	&nbsp; if you have input right user name and password of the database connection that you are trying to connected then you could click Load Database to list your database information</p>\n<p>\n	<img alt="" height="503" src="/cubi/files/upload/helptips/system/3.png" width="470" /></p>\n<p>\n	4 back to Database Connection function page where you can see the new connection have been successed created now and status is check.</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/system/4.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-26 02:36:33', 1, '2011-12-26 02:57:51'),
(25, 5, 'What is email module for?', '<p>\n	Cubi Email module is&nbsp; an internal notify email module that can auto send some email to company user for new user registration or email password reset or system error notice or Cronjob progress.</p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2011-12-27 02:03:20', 1, '2011-12-27 02:03:20'),
(26, 5, 'Email module function introduce', '<p>\n	Email module have four functions: 1 queue 2 log 3 account 4 template</p>\n', 10, '<p>\n	1 there are four functions under email module</p>\n<p>\n	<img alt="" height="124" src="/cubi/files/upload/helptips/email/1.png" width="191" /></p>\n<p>\n	2 Manage Email Queue function could see the emails are waiting for sent to the users</p>\n<p>\n	<img alt="" height="229" src="/cubi/files/upload/helptips/email/2.png" width="668" /></p>\n<p>\n	3 Manage Email log function can manage all the emails have been auto sent by email module <img alt="" height="287" src="/cubi/files/upload/helptips/email/3.png" width="659" /></p>\n<p>\n	4 Email Accounts Management function can manage the auto send email account from which email account <img alt="" src="/cubi/files/upload/helptips/email/4.png" /></p>\n<p>\n	5 Email Template Management function can edit the auto send email information like welcome letter detail<img alt="" height="286" src="/cubi/files/upload/helptips/email/5.png" width="656" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-27 02:16:38', 1, '2011-12-27 02:29:04'),
(27, 16, 'What is Cache module for?', '<p>\n	Cache module can be used to manage Cubi platform cache when add new module or add new function in Cubi need reload or clear cache.</p>\n', 10, '<p>\n	1 Click Manage System Cache under Cache</p>\n<p>\n	<img alt="" height="53" src="/cubi/files/upload/helptips/cache/1.png" width="175" /></p>\n<p>\n	2 user can reload or clear cache from cache management when some system module have been changed to let the new change take effect</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/cache/2.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-27 03:08:41', 1, '2011-12-27 03:08:41'),
(28, 17, 'What is Security module for?', '<p>\r\n	Security module is designed for set up some access&nbsp;rules between internet and intranet.</p>\r\n', 10, '<p>\r\n	&nbsp;1 click &quot;Management Security Rules&quot; function under Security module</p>\r\n<p>\r\n	<img alt="" height="55" src="/cubi/files/upload/helptips/security/1.PNG" width="187" /></p>\r\n<p>\r\n	2 administrator can use security rules to set up six types access rules:</p>\r\n<p>\r\n	&nbsp;&nbsp; 1) access authority based on certain URL</p>\r\n<p>\r\n	&nbsp;&nbsp; 2) access authority based on certain Domain like only permit access from <a href="http://www.openbiz.cn">www.openbiz.cn</a></p>\r\n<p>\r\n	&nbsp;&nbsp; 3) access authority based on certain IP like only permit 192.168.1.xxx and from company can access to user&#39;s company cubi server</p>\r\n<p>\r\n	&nbsp;&nbsp; and so on</p>\r\n<p>\r\n	<img alt="" src="/cubi/files/upload/helptips/security/2.PNG" /></p>\r\n', NULL, NULL, NULL, NULL, 1, '2011-12-27 06:19:45', 1, '2011-12-27 06:19:45'),
(29, 18, 'What is Translation module for?', '<p>\r\n	Translation module can let user translate Cubi into whatever language they want Cubi using. Here is an chinese translation example</p>\r\n', 10, '<p>\r\n	1 click &quot;Manage Languages&quot;</p>\r\n<p>\r\n	<img alt="" height="80" src="/cubi/files/upload/helptips/translation/1.PNG" width="191" /></p>\r\n<p>\r\n	2 click add button to add one new language package that you needed then Cubi system will auto download the language you select from google language package.&nbsp;&nbsp;&nbsp;<img alt="" height="183" src="/cubi/files/upload/helptips/translation/2(1).png" width="734" /></p>\r\n<p>\r\n	3&nbsp; In this example i select chinese language and save</p>\r\n<p>\r\n	<img alt="" height="744" src="/cubi/files/upload/helptips/translation/3(1).png" width="719" /></p>\r\n<p>\r\n	4&nbsp; back to &quot;Manage UI Translation&quot; function</p>\r\n<p>\r\n	<img alt="" src="/cubi/files/upload/helptips/translation/8.PNG" /></p>\r\n<p>\r\n	5 select the language you just download in this example i select chinese</p>\r\n<p>\r\n	<img alt="" height="196" src="/cubi/files/upload/helptips/translation/4.PNG" width="710" /></p>\r\n<p>\r\n	6 Cubi will list all the Cubi platform background module select the module you want to translate</p>\r\n<p>\r\n	<img alt="" height="795" src="/cubi/files/upload/helptips/translation/5.PNG" width="554" /></p>\r\n<p>\r\n	7 in this example i select System module which metadata is mod.system.ini and change one label into &quot;用户亲景设置1&quot; and save it</p>\r\n<p>\r\n	<img alt="" src="/cubi/files/upload/helptips/translation/6.PNG" /></p>\r\n<p>\r\n	8 back to &quot;Preference Setting&quot; function under system module check the change i just made that could see the new brower lab have been change into &quot;用户亲景设置1&quot; now</p>\r\n<p>\r\n	<img alt="" src="/cubi/files/upload/helptips/translation/7.PNG" /></p>', NULL, NULL, NULL, NULL, 1, '2011-12-27 08:18:54', 1, '2011-12-27 08:30:35'),
(30, 4, 'What is event log for?', '<p>\r\n	Event log&nbsp;module create an API that &nbsp;can easily to&nbsp;see server log detail</p>\r\n', 10, '<p>\r\n	Event Log module can let administrator easily to see server&#39;s log, right now we just create one kind of log in or log out log information in this event log module.</p>\r\n<p>\r\n	If there are more specific require we can add more event log function in it</p>\r\n<p>\r\n	1 click &quot;Manage Eventlog&quot; function under Event Log module</p>\r\n<p>\r\n	&nbsp;<img alt="" height="57" src="/cubi/files/upload/helptips/event_log/1.PNG" width="189" /></p>\r\n<p>\r\n	2 Check all the event log</p>\r\n<p>\r\n	<img alt="" height="504" src="/cubi/files/upload/helptips/event_log/2.PNG" width="735" /></p>\r\n', NULL, NULL, NULL, NULL, 1, '2011-12-27 08:48:20', 1, '2011-12-27 08:48:20'),
(31, 20, 'What is Contacts?', '<p>\n	Contacts module provide user more contact information input options like user&#39;s photo, phone number, address so on.</p>\n', 10, '<p>\n	1 click &quot;Contack Manage&quot; function under contacts module.</p>\n<p>\n	<img alt="" height="99" src="/cubi/files/upload/helptips/Collaboration/contacts/1(1).png" width="190" /></p>\n<p>\n	2 replenish the user&#39;s information in there like phone number, address so on</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/2.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-28 01:53:37', 1, '2011-12-28 01:56:33'),
(32, 20, 'Dispaly contacts as required', '<p>\n	Collaboration can let user check all the contacts as they required way like: group by company, or group by cards</p>\n', 10, '<p>\n	1 Click &quot;Contact Manage&quot; function under contacts module and select Contact View Mode as Phone Book </p>\n<p>\n	<img alt="" height="525" src="/cubi/files/upload/helptips/Collaboration/contacts/3.png" width="199" /></p>\n<p>\n	2 then all the contacts will arrange as phone book number</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/4.png" /></p>\n<p>\n	3 select Contact View Mode as Contac Cards </p>\n<p>\n	<img alt="" height="172" src="/cubi/files/upload/helptips/Collaboration/contacts/5.png" width="193" /></p>\n<p>\n	4 then all the contacts will arrange as Contact Cards mode</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/6.png" /></p>\n<p>\n	5 select Group by Company</p>\n<p>\n	<img alt="" height="167" src="/cubi/files/upload/helptips/Collaboration/contacts/7.png" width="192" /></p>\n<p>\n	6 all the contacts will arrange by company mode</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/8.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-28 02:11:24', 1, '2011-12-28 02:36:27'),
(33, 20, 'How to add new type of contact', '<p>\n	User can add new type of contact according to their practical need, here is an example of add new type of contact</p>\n', 10, '<p>\n	1 click &quot;Contact Type&quot; function under contacts module</p>\n<p>\n	<img alt="" height="109" src="/cubi/files/upload/helptips/Collaboration/contacts/9.png" width="189" /></p>\n<p>\n	2 click add button to create an new type of contact</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/10.png" /></p>\n<p>\n	3 input new type of contact name and description and&nbsp; represented color and for public and save it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/11.png" /></p>\n<p>\n	4 then the new type of contact have been created now</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/12.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-28 03:01:18', 1, '2011-12-28 03:06:00'),
(34, 21, 'What is message for?', '<p>\n	Collaboration Message module is designed for send realtime message.</p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2011-12-28 18:59:22', 1, '2011-12-28 18:59:22'),
(35, 21, 'How to send a message', '<p>\n	Here is an example of how to send a message</p>\n', 10, '<p>\n	1 Click &quot;Compose Message&quot; function under</p>\n<p>\n	<img alt="" height="146" src="/cubi/files/upload/helptips/Collaboration/message/1.png" width="191" /></p>\n<p>\n	2 select contact who you want to send and forward the message from contacts list</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/message/2.png" /></p>\n<p>\n	3 add attachment for the message</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/message/3.png" /></p>\n<p>\n	4 input message details and send</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/message/4.png" /></p>\n<p>\n	5 then the send message will be saved in your &quot;sent Message&quot; </p>\n<p>\n	<img alt="" height="310" src="/cubi/files/upload/helptips/Collaboration/message/5.png" width="737" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-28 20:42:31', 1, '2011-12-28 20:51:12'),
(36, 21, 'Message type', '<p>\n	User can set up new type of message as they needed.</p>\n', 10, '<p>\n	1 Click &quot;Message Type&quot; function under Message module</p>\n<p>\n	<img alt="" height="147" src="/cubi/files/upload/helptips/Collaboration/message/6.png" width="189" /></p>\n<p>\n	&nbsp;</p>\n<p>\n	2 add or edit the message type as they needed</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/message/7.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-28 21:13:38', 1, '2011-12-28 21:13:38'),
(37, 22, 'What is Calendar for?', '<p>\n	Calendar module provide user an regular event setting manage platform with is user can set some meeting or appointment every week or month or one of specific tiem.</p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2011-12-28 22:32:08', 1, '2011-12-28 22:32:08'),
(38, 22, 'How to create an calendar?', '<p>\n	Here is an example of creating an calendar.</p>\n', 10, '<p>\n	1 Click &quot;Event Manage&quot; function under Calendar module</p>\n<p>\n	<img alt="" height="78" src="/cubi/files/upload/helptips/Collaboration/calendar/1.png" width="192" /></p>\n<p>\n	2 click add button to create an new meeting </p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/2.png" /></p>\n<p>\n	3 input the new meeting information like meeting detail and location and so on then quick finish or click next go to step 5</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/3.png" /></p>\n<p>\n	4 this calendar also can be set as regular meeting at every weekly or month or year</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/4.png" /></p>\n<p>\n	5 when you click next you can select which user you want to invite to the meeting from contacts or add an new contacts in it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/5.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-28 22:44:42', 1, '2011-12-28 22:52:11'),
(39, 22, 'How to add new type of event?', '<p>\n	User can create new type of event as their needed.</p>\n', 10, '<p>\n	1 click &quot;Event Type&quot; function under Calendar</p>\n<p>\n	<img alt="" height="71" src="/cubi/files/upload/helptips/Collaboration/calendar/6.png" width="169" /></p>\n<p>\n	2 click add button to add an new type of calendar</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/7.png" /></p>\n<p>\n	3 input the new calendar details like meeting name and save it</p>\n<p>\n	<img alt="" height="462" src="/cubi/files/upload/helptips/Collaboration/calendar/8.png" width="657" /></p>\n<p>\n	4 back to &quot;Event Type Manage&quot; view that you can see the new calendar you just created now</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/9.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-28 23:38:37', 1, '2011-12-29 00:00:35'),
(40, 23, 'What is Task module for?', '<p>\n	Task module is designed for report or check user&#39;s work progress.</p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2011-12-29 01:26:57', 1, '2011-12-29 01:26:57'),
(41, 23, 'How to use Task module', '<p>\n	Here is an example of using Task module.</p>\n', 10, '<p>\n	1 click &quot;Task Manage&quot; function under Task module</p>\n<p>\n	<img alt="" height="70" src="/cubi/files/upload/helptips/Collaboration/task/1.png" width="177" /></p>\n<p>\n	2 click add button to create an new task</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/2.png" /></p>\n<p>\n	3 input the task detail like task title, description and set up the task laste time like one month from now and quick finish or click next to add more detail</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/3.png" /></p>\n<p>\n	4 add the user who involve in this task from contacts list or add new user into the task</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/4.png" /></p>\n<p>\n	5 click share icon to set the access or update authority for the task<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/5.png" /></p>\n<p>\n	6 set the tast share in Project A group</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/6.png" /></p>\n<p>\n	7 when you have finish a part of the task you can update the task by click update button </p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/7.png" /></p>\n<p>\n	8 update the task progress to 15%</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/8.png" /></p>\n<p>\n	9 then the task have been update into 15% now</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/9.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-29 01:35:35', 1, '2011-12-29 01:48:58'),
(42, 23, 'How to add an new Type of Task?', '<p>\n	Here is an example of how to add new type of task.</p>\n', 10, '<p>\n	User can customize their own task type</p>\n<p>\n	1 click &quot;Task Type&quot; function under Task module</p>\n<p>\n	<img alt="" height="78" src="/cubi/files/upload/helptips/Collaboration/task/10.png" width="192" /></p>\n<p>\n	2 click add button to create new type of task</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/11.png" /></p>\n<p>\n	3 input the description for the new task type and save it</p>\n<p>\n	<img alt="" height="524" src="/cubi/files/upload/helptips/Collaboration/task/12.png" width="729" /></p>\n<p>\n	4 then the new type of task have been created now</p>\n<p>\n	<img alt="" height="41" src="/cubi/files/upload/helptips/Collaboration/task/13.png" width="715" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-29 02:38:42', 1, '2011-12-29 02:45:25'),
(43, 24, 'What is work log for?', '<p>\n	Work log is used for save task progress work log that can be used as a daily work report.</p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2011-12-29 03:36:40', 1, '2011-12-29 03:36:40'),
(44, 24, 'How to use work log to record daily report', '<p>\n	Here is an example of how to use work log to record daily work report.</p>\n', 10, '<p>\n	1 click &quot;Work Log Manage&quot; function under Work Log module</p>\n<p>\n	<img alt="" height="58" src="/cubi/files/upload/helptips/Collaboration/work_log/1.png" width="192" /></p>\n<p>\n	2 click add button to add an new work log</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/work_log/2.png" /></p>\n<p>\n	3 select which task you have worked on today and how many hours working on it and save it</p>\n<p>\n	<img alt="" height="528" src="/cubi/files/upload/helptips/Collaboration/work_log/3.png" width="742" /></p>\n<p>\n	4 add another work log for different task in today&#39;s work log and save it</p>\n<p>\n	<img alt="" height="436" src="/cubi/files/upload/helptips/Collaboration/work_log/4.png" width="734" /></p>\n<p>\n	5 then we can see today&#39;s two work logs about how i spent 8 working hours working at</p>\n<p>\n	<img alt="" height="252" src="/cubi/files/upload/helptips/Collaboration/work_log/5.png" width="734" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-29 03:53:14', 1, '2011-12-29 04:03:02'),
(45, 25, 'What is Note for?', '<p>\n	Note is a temporary or not important record save tool for convenience user&#39;s work without using real paper. Here is an simple example of it.</p>\n', 10, '<p>\n	1 click &quot;Note Type&quot; function under Note module</p>\n<p>\n	<img alt="" height="79" src="/cubi/files/upload/helptips/Collaboration/note/1.png" width="188" /></p>\n<p>\n	2 input content of the note and save it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/note/2.png" /></p>\n<p>\n	3 then you can see the note have been create in Note Management panel</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/note/3.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-29 19:08:43', 1, '2011-12-29 19:15:18'),
(46, 26, 'What is Announcement for?', '<p>\n	Announcement module is designed for publish some important notification to the all user like whole company user or specific group user like HR department.</p>\n', 10, '<p>\n	Usually the Collaboration there is two type of user. 1 system administrator or department manager who can publish announcement 2 common user who just can see the announcement</p>\n<p>\n	1 administrator log in can see &quot;Announcement Manage&quot; function</p>\n<p>\n	<img alt="" height="100" src="/cubi/files/upload/helptips/Collaboration/announcement/1.png" width="195" /></p>\n<p>\n	2 common user just can see &quot;View Announcement&quot; function</p>\n<p>\n	<img alt="" height="54" src="/cubi/files/upload/helptips/Collaboration/announcement/8.png" width="191" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-29 20:23:15', 1, '2011-12-29 20:29:36'),
(47, 26, 'How to create an announcement', '<p>\n	Here is an example of how to create an announcement.</p>\n', 10, '<p>\n	1 click &quot;Announcement Manage&quot; function user Announcement module</p>\n<p>\n	<img alt="" height="100" src="/cubi/files/upload/helptips/Collaboration/announcement/1.png" width="195" /></p>\n<p>\n	2 click add button to create an new announcemtn</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/announcement/2.png" /></p>\n<p>\n	3 input the new announcement title and content and save it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/announcement/3.png" /></p>\n<p>\n	4 because usually we do not suggest user publish the announcement as soon as it be created for this announcement can be created before it is need to be publish.</p>\n<p>\n	&nbsp;&nbsp; so when user want to publish the announcement they can click publish icon to publish it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/announcement/4.png" /></p>\n<p>\n	5 defualt announcement setting is pending </p>\n<p>\n	&nbsp;&nbsp; select published to send the announcement</p>\n<p>\n	<img alt="" height="354" src="/cubi/files/upload/helptips/Collaboration/announcement/5.png" width="655" /></p>\n<p>\n	6 the announcement can be sent to certain group like: only HR department or project A group</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/announcement/6.png" /></p>\n<p>\n	7 if you want all the user see the announcement just select : Global Group to send the announcement and click ok</p>\n<p>\n	<img alt="" height="378" src="/cubi/files/upload/helptips/Collaboration/announcement/7.png" width="650" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-29 20:38:16', 1, '2011-12-29 21:07:50'),
(48, 27, 'Why user need Document Management module?', '<p>\n	Document module is designed for let all the user&#39;s document can have a central storage and manage and archive that will make document share and check much easily and efficient.</p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2011-12-29 21:17:12', 1, '2011-12-29 21:17:12'),
(49, 27, 'How to use Document module and share it with others?', '<p>\n	Here is a example of how to create an new document and share it with others.</p>\n', 10, '<p>\n	1 click &quot;Document Manage&quot; function under Document module</p>\n<p>\n	<img alt="" height="79" src="/cubi/files/upload/helptips/Collaboration/document/1.png" width="194" /></p>\n<p>\n	2 click add button to create an new document</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/document/2.png" /></p>\n<p>\n	3 input the content of the new document and save it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/document/3.png" /></p>\n<p>\n	4 click share icon to set up which group you want to share the document with</p>\n<p>\n	<img alt="" height="397" src="/cubi/files/upload/helptips/Collaboration/document/4(1).png" width="716" /></p>\n<p>\n	5 select the group you want they share the document and click ok</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/document/5.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-29 21:31:08', 1, '2011-12-29 21:35:04'),
(50, 28, 'What is Bookmark module for?', '<p>\n	Bookmark module is designed for convenient to share some webiste link with group member.</p>\n', 10, '<p>\n	1 click &quot;Bookmark Manage&quot; function under Bookmark module</p>\n<p>\n	<img alt="" height="89" src="/cubi/files/upload/helptips/Collaboration/bookmark/1.png" width="191" /></p>\n<p>\n	2 input the link that you want to share with your group member and save it</p>\n<p>\n	<img alt="" height="522" src="/cubi/files/upload/helptips/Collaboration/bookmark/2.png" width="688" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-29 23:24:22', 1, '2011-12-29 23:24:22'),
(51, 23, 'Check task progress with Gant View.', '<p>\n	For more clearly see the task progress user can use Gant View to check all task progress.</p>\n', 10, '<p>\n	1 click &quot;Task Gant View&quot; function under Task module to see all the task progress</p>\n<p>\n	<img alt="" height="455" src="/cubi/files/upload/helptips/Collaboration/task/14.png" width="206" /></p>\n<p>\n	2 from this Gant View user can clearly see every task progress and when it is started and when it will be end</p>\n<p>\n	<img alt="" height="445" src="/cubi/files/upload/helptips/Collaboration/task/15.png" width="721" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-29 23:48:02', 1, '2011-12-29 23:48:02'),
(52, 22, 'Calendar view', '<p>\n	For more fit for human common sense we have designed an common Calendar view for Calendar module.</p>\n', 10, '<p>\n	1 click &quot;Calendar View&quot; function under Calendar module</p>\n<p>\n	<img alt="" height="451" src="/cubi/files/upload/helptips/Collaboration/calendar/10.png" width="190" /></p>\n<p>\n	2 then all the Calendar like meeting records have been displayed as Calendar view now</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/11.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-30 00:00:07', 1, '2011-12-30 00:00:07'),
(53, 19, 'How to start use Collaboration?', '<p>\n	There are 8 areas in Collaboration that have been tightly arranged in the platform.</p>\n', 10, '<p>\n	1&nbsp; the navigation and Help center are arranged in the left panel of&nbsp; platform</p>\n<p>\n	<img alt="" height="387" src="/cubi/files/upload/helptips/Collaboration/1.png" width="186" /></p>\n<p>\n	2&nbsp; all the core modules have been displayed in the right panel&nbsp; of platform</p>\n<p>\n	&nbsp; &nbsp; that will display company announcement and the latest three Tasks and two work logs; six latest messages; six latest calendar; four contacts; six documents and three Bookmarks and notes</p>\n<p>\n	<img alt="" height="527" src="/cubi/files/upload/helptips/Collaboration/2.png" width="864" /></p>\n', NULL, NULL, NULL, NULL, 1, '2012-01-01 23:49:15', 1, '2012-01-02 01:25:46'),
(54, 19, 'What is Collaboration?', '<p>\n	Collaboration is an platform of office automation that include of 9 modules like contacts manage; message; task manage and so on.</p>\n', 10, NULL, NULL, NULL, NULL, NULL, 1, '2012-01-02 01:30:44', 1, '2012-01-02 01:31:40'),
(18, 12, 'How to Backup your Cubi system?', '<p>\n	In case user make some wrong operations we can backup Cubi system so that user can reverse Cubi system to the state of backup</p>\n', 10, '<p>\n	1 Click backup module--&gt;Manage Backup in left navigation bar</p>\n<p>\n	<img alt="" height="82" src="/cubi/files/upload/helptips/backup/1.png" width="193" /></p>\n<p>\n	&nbsp;</p>\n<p>\n	2 Click Backup button to set up a backup&nbsp;</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/backup/2.png" /></p>\n<p>\n	3 Input the backup file name and select backup database or entire Cubi system and select a timestamp for it.</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/backup/3.png" /></p>\n<p>\n	4 when you save your backup you could download it into your local device like portable hard disk then copy it into the other computer.</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/backup/4.png" /></p>\n', NULL, NULL, NULL, NULL, 1, '2011-12-25 19:24:22', 1, '2011-12-25 20:42:59');

-- --------------------------------------------------------

--
-- Table structure for table `help_category`
--

CREATE TABLE `help_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `url_match` varchar(255) DEFAULT NULL,
  `description` text,
  `sort_order` int(11) NOT NULL DEFAULT '10',
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=29 ;

--
-- Dumping data for table `help_category`
--

INSERT INTO `help_category` VALUES
(1, 7, 'User Management', '/system/user_list.*', '<p>\n	About how to manage users and system access.</p>\n', 5, 1, '2010-04-19 18:15:18', 1, '2011-12-16 16:04:43'),
(2, 7, 'Role Management', '/system/role_list.*', '<p>\n	About how to manage system role and permissions group.</p>\n', 20, 1, '2010-04-19 19:50:23', 1, '2010-04-21 08:10:48'),
(3, 7, 'Module Management', '/system/module_list.*', '<p>\n	About how to mount a module into Cubi system.</p>\n', 30, 1, '2010-04-21 03:35:11', 1, '2010-04-21 05:11:09'),
(4, 7, 'Event Log Management', '/eventlog.*', '<p>\r\n	About system event log</p>\r\n', 40, 1, '2010-04-21 05:01:44', 1, '2011-12-27 08:52:27'),
(5, 7, 'Email Management', '/email/email_.*', '<p>\n	About how to manage system email function</p>\n', 50, 1, '2010-04-21 05:03:43', 1, '2010-05-01 13:19:08'),
(6, 7, 'Help Management', '/help/help_.*', '<p>\r\n	About how to manage the online help module of cubi system.</p>\r\n', 60, 1, '2010-04-21 05:09:50', 1, '2010-04-24 05:16:02'),
(7, 0, 'Openbiz Cubi System', '', '<p>\n	Cubi system help content.</p>\n', 10, 1, '2010-04-21 05:10:29', 1, '2011-12-25 23:39:14'),
(8, 7, 'Theme Management', '/theme/manage_theme', NULL, 60, 1, '2011-12-15 19:14:01', 1, '2011-12-15 19:14:29'),
(10, 7, 'Cronjob', '/cronjob/cronjob_list.*', NULL, 30, 1, '2011-12-16 15:50:00', 1, '2011-12-16 16:05:11'),
(11, 7, 'Preference setting', '/system/user_preference.*', NULL, 5, 1, '2011-12-16 16:04:20', 1, '2011-12-16 16:04:38'),
(12, 7, 'Backup Management', '/backup.*', '<p>\n	Backup or downlaod your Cubi system data.</p>\n', 10, 1, '2011-12-25 18:11:21', 1, '2011-12-25 20:57:35'),
(14, 7, 'Group', '/system/group_.*', '<p>\n	About split user into different groups</p>\n', 10, 1, '2011-12-25 23:20:59', 1, '2011-12-26 01:11:11'),
(15, 7, 'System', '/system/database_list.*', '<p>\n	Setting database connection</p>\n', 10, 1, '2011-12-26 02:18:37', 1, '2011-12-26 02:19:46'),
(16, 7, 'Cache', '/cache/manage.*', '<p>\n	About Cubi Platform cache management.</p>\n', 10, 1, '2011-12-27 02:46:02', 1, '2011-12-27 02:46:02'),
(17, 7, 'Security', '/security/security_rule.*', '<p>\r\n	About internal and external internet access authorication </p>\r\n', 10, 1, '2011-12-27 06:05:15', 1, '2011-12-27 06:05:15'),
(18, 7, 'Translation', '/translation.*', '<p>\r\n	About Cubi platform language setting</p>\r\n', 10, 1, '2011-12-27 08:04:04', 1, '2011-12-27 08:04:04'),
(19, 0, 'Collaboration', '/collab/dashboard', '<p>\n	Collaboration help content.</p>\n', 10, 1, '2011-12-28 00:43:36', 1, '2012-01-01 23:39:59'),
(20, 19, 'Contact Manage', '/collab/contact_.*', '<p>\n	About Contact Management.</p>\n', 10, 1, '2011-12-28 00:49:11', 1, '2011-12-28 00:49:11'),
(21, 19, 'Message', '/collab/message_.*', '<p>\n	About internal message module.</p>\n', 10, 1, '2011-12-28 03:36:03', 1, '2011-12-28 03:36:03'),
(22, 19, 'Calendar', '/collab/event_.*', '<p>\n	About Collaboration Calendar management</p>\n', 10, 1, '2011-12-28 03:37:36', 1, '2011-12-28 03:37:36'),
(23, 19, 'Task', '/collab/task_.*', '<p>\n	About Collaboration Task management</p>\n', 10, 1, '2011-12-28 03:38:35', 1, '2011-12-28 03:38:35'),
(24, 19, 'Work Log', '/collab/worklog_.*', '<p>\n	About Collaboration Work Log management</p>\n', 10, 1, '2011-12-28 03:39:34', 1, '2011-12-28 03:39:34'),
(25, 19, 'Note', '/collab/note_.*', '<p>\n	About Collaboration Note management</p>\n', 10, 1, '2011-12-28 03:41:18', 1, '2011-12-28 03:41:18'),
(26, 19, 'Announcement', '/collab/announcement_.*', '<p>\n	About Collaboration Announcement management</p>\n', 10, 1, '2011-12-28 03:43:01', 1, '2011-12-28 03:43:01'),
(27, 19, 'Document', '/collab/document_.*', '<p>\n	About Collaboration Document management</p>\n', 10, 1, '2011-12-28 03:45:05', 1, '2011-12-28 03:45:05'),
(28, 19, 'Bookmark', '/collab/bookmark_.*', '<p>\n	About Collaboration Bookmark management</p>\n', 10, 1, '2011-12-28 03:46:10', 1, '2011-12-28 03:46:31');

-- --------------------------------------------------------

--
-- Table structure for table `help_category_mapping`
--

CREATE TABLE `help_category_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `cat_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `url` (`url`),
  KEY `cat_id` (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `help_tutorial`
--

CREATE TABLE `help_tutorial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url_match` varchar(255) NOT NULL,
  `type` enum('url','content') NOT NULL,
  `content_url` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `create_by` int(1) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(1) NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `url_match` (`url_match`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- Dumping data for table `help_tutorial`
--

INSERT INTO `help_tutorial` VALUES
(2, '/system/general_default', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-welcome.php', 'cubi初次登陆', '', 550, 330, 1, '2012-10-27 16:17:32', 1, '2012-10-29 20:27:28'),
(3, '/system/group_list', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-group.php', '用户部门设置', '', 550, 280, 1, '2012-10-27 16:27:31', 1, '2012-10-27 16:30:19'),
(4, '/system/group_data_sharing', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-share.php', '部门共享设置', '', 500, 280, 1, '2012-10-27 16:36:57', 1, '2012-10-27 16:37:41'),
(5, '/system/user_list', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-user.php', '用户设置', '', 550, 260, 1, '2012-10-29 18:45:17', 1, '2012-10-29 18:54:00'),
(6, '/system/user_preference', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-system.php', '系统偏好设置', '', 550, 280, 1, '2012-10-29 19:21:49', 1, '2012-10-29 19:21:49'),
(7, '/system/module_list', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-module.php', '模块管理', '', 500, 240, 1, '2012-10-29 19:34:35', 1, '2012-10-29 19:38:58'),
(8, '/backup/backup_list', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-backup.php', '备份数据', '', 550, 260, 1, '2012-10-29 19:46:25', 1, '2012-10-29 19:46:25'),
(9, '/email/email_setting_list', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-email.php', '系统邮件账户', '', 550, 300, 1, '2012-10-29 19:53:13', 1, '2012-10-29 19:53:13'),
(10, '/mystore/profile', 'url', 'http://www.openbiz.cn/enterprise/store/tutorial/store-profile.php', '个人档案管理', '', 550, 300, 1, '2012-10-30 18:40:18', 1, '2012-10-30 18:42:48'),
(11, '/myaccount/reset_password/force', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-firstlogin-passwd.php', '初次登陆密码重置', '', 550, 280, 1, '2013-01-07 19:12:07', 1, '2013-01-07 19:15:21'),
(12, '/myaccount/my_profile/force', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-firstlogin-profile.php', '初次登陆完善资料', '', 550, 280, 1, '2013-01-07 19:13:39', 1, '2013-01-07 19:13:39'),
(13, '/contact/contact_detail/.*', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-user-profile.php', '完善联系人资料', '', 550, 280, 1, '2013-01-10 12:47:54', 1, '2013-01-10 12:52:00'),
(14, '/contact/contact_list', 'url', 'http://www.openbiz.cn/enterprise/contact/tutorial/contact-manage.php', '联系人列表', '', 550, 280, 1, '2012-12-31 19:29:32', 1, '2012-12-31 19:29:32');

-- --------------------------------------------------------

--
-- Table structure for table `help_tutorial_user`
--

CREATE TABLE `help_tutorial_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tutorial_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `autoshow` int(11) NOT NULL,
  `create_by` int(1) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(1) NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tutorial_id` (`tutorial_id`,`user_id`),
  KEY `tutorial_id_2` (`tutorial_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `location`
--

CREATE TABLE `location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT '',
  `foreign_id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT '',
  `address` varchar(255) DEFAULT '',
  `description` text NOT NULL,
  `longtitude` varchar(255) DEFAULT '',
  `latitude` varchar(255) DEFAULT '',
  `group_id` int(11) DEFAULT '1',
  `group_perm` int(11) DEFAULT '1',
  `other_perm` int(11) DEFAULT '1',
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `market_installed`
--

CREATE TABLE `market_installed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `repository_uid` varchar(255) NOT NULL,
  `app_id` int(11) NOT NULL,
  `version` varchar(255) NOT NULL,
  `install_time` datetime NOT NULL,
  `install_state` varchar(255) NOT NULL,
  `install_download` int(11) NOT NULL,
  `install_download_filesize` int(11) NOT NULL,
  `install_progress` int(11) NOT NULL,
  `install_log` varchar(255) NOT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `repository_uid` (`repository_uid`,`app_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `market_repository`
--

CREATE TABLE `market_repository` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `repository_uri` varchar(255) NOT NULL,
  `repository_uid` varchar(255) NOT NULL,
  `repository_name` varchar(255) NOT NULL,
  `status` int(2) NOT NULL,
  `sort_order` int(11) NOT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `repository_uid` (`repository_uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `market_repository`
--

INSERT INTO `market_repository` VALUES
(1, 'http://repos.openbiz.cn', 'repos.openbiz.cn', 'Openbiz Offical Repository - China', 1, 50, 1, '2012-03-24 19:41:28');

-- --------------------------------------------------------

--
-- Table structure for table `menu`
--

CREATE TABLE `menu` (
  `name` varchar(100) NOT NULL DEFAULT '',
  `module` varchar(100) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `url_match` varchar(255) DEFAULT NULL,
  `view` varchar(255) DEFAULT NULL,
  `type` varchar(50) NOT NULL DEFAULT '',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `parent` varchar(255) DEFAULT '',
  `ordering` int(4) DEFAULT '10',
  `access` varchar(100) DEFAULT NULL,
  `icon` varchar(100) DEFAULT NULL,
  `icon_css` varchar(100) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `create_by` int(10) DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  `update_by` int(10) DEFAULT '1',
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`name`),
  KEY `parent` (`parent`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `menu`
--

INSERT INTO `menu` VALUES
('System', 'system', 'Administration', '/system/general_default', '', NULL, '', 1, '', 10, 'Site.Administer_General', '', '', '', 1, NULL, 1, NULL),
('System.User', 'system', 'User', '', '', NULL, '', 1, 'System', 10, 'User.Administer_Users', 'spacer.gif', 'icon_user', 'System User Management', 1, NULL, 1, NULL),
('System.User.List', 'system', 'User Management', '/system/user_list', '', NULL, '', 1, 'System.User', 10, '', '', '', '', 1, NULL, 1, NULL),
('System.User.Detail', 'system', 'User Detail', '/system/user_detail', '', NULL, '', 1, 'System.User.List', 10, '', '', '', '', 1, NULL, 1, NULL),
('System.Session_Management', 'system', 'Session Management', '/system/session_manage', '', NULL, '', 1, 'System.User', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Role', 'system', 'Role', '', '', NULL, '', 1, 'System', 12, '', 'spacer.gif', 'icon_role', 'Role Management Module', 1, NULL, 1, NULL),
('System.Role.List', 'system', 'Role Management', '/system/role_list', '', NULL, '', 1, 'System.Role', 10, '', '', '', '', 1, NULL, 1, NULL),
('System.Role.Detail', 'system', 'Role Detail', '/system/role_detail', '', NULL, '', 1, 'System.Role.List', 10, '', '', '', '', 1, NULL, 1, NULL),
('System.Module', 'system', 'Module', '', '', NULL, '', 1, 'System', 16, '', 'spacer.gif', 'icon_module', 'Modules Management', 1, NULL, 1, NULL),
('System.Modules.List', 'system', 'Module Management', '/system/module_list', '', NULL, '', 1, 'System.Module', 10, '', '', '', '', 1, NULL, 1, NULL),
('System.Modules.Detail', 'system', 'Module Detail', '/system/module_detail', '', NULL, '', 1, 'System.Modules.List', 10, '', '', '', '', 1, NULL, 1, NULL),
('System.Modules.ChangeLog', 'system', 'Change Logs', '/system/module_change_log', '', NULL, '', 1, 'System.Module', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Group', 'system', 'Group', '', '', NULL, '', 1, 'System', 14, '', 'spacer.gif', 'icon_group', 'Group Management Module', 1, NULL, 1, NULL),
('System.Group.List', 'system', 'Group Management', '/system/group_list', '', NULL, '', 1, 'System.Group', 10, '', '', '', '', 1, NULL, 1, NULL),
('System.Group.Detail', 'system', 'Group Detail', '/system/group_detail', '', NULL, '', 1, 'System.Group.List', 10, '', '', '', '', 1, NULL, 1, NULL),
('System.Group.Initialize', 'system', 'Initialize Group', '/system/initialize_group', '', NULL, '', 1, 'System.Group.List', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Group.DataShare', 'system', 'Group Data Sharing', '/system/group_data_sharing', '', NULL, '', 1, 'System.Group', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Setting', 'system', 'System', '', '', NULL, '', 1, 'System', 17, 'System.Administer_System', 'spacer.gif', 'icon_system', 'System Management', 1, NULL, 1, NULL),
('System.Setting.Database', 'system', 'Database Connections', '/system/database_list', '', NULL, '', 1, 'System.Setting', 10, '', '', '', '', 1, NULL, 1, NULL),
('System.Setting.Preference', 'system', 'Preference Setting', '/system/user_preference', '', NULL, '', 1, 'System.Setting', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Extension', 'system', 'Extension', '', '', NULL, '', 1, 'System', 18, 'System.Administer_System', 'spacer.gif', 'icon_extension', 'System Extension', 1, NULL, 1, NULL),
('System.Menu', 'menu', 'Menu', '', '', NULL, '', 1, 'System', 30, '', 'spacer.gif', 'icon_menu', 'System Menu Management', 1, NULL, 1, NULL),
('System.Menu.List', 'menu', 'Manage Menu by List', '/menu/menu_list', '', NULL, '', 1, 'System.Menu', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Menu.Tree', 'menu', 'Manage Menu by Tree', '/menu/menu_tree', '', NULL, '', 1, 'System.Menu', 30, '', '', '', '', 1, NULL, 1, NULL),
('System.Help', 'help', 'Help', '', '', NULL, '', 1, 'System', 50, '', 'spacer.gif', 'icon_help', 'Help Management', 1, NULL, 1, NULL),
('System.Help.Cat', 'help', 'Manage Help Category', '/help/help_category', '', NULL, '', 1, 'System.Help', 10, '', '', '', '', 1, NULL, 1, NULL),
('System.Htlp.Tip', 'help', 'Manage Help Tips', '/help/help_list', '', NULL, '', 1, 'System.Help', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Htlp.Tutorial', 'help', 'Manage Tutorial', '/help/tutorial', '', NULL, '', 1, 'System.Help', 30, '', '', '', '', 1, NULL, 1, NULL),
('ContactTopMenu', 'contact', 'Contact', '/contact/contact_list', '', NULL, '', 1, '', 50, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('Contact', 'contact', 'Contact', '', '', NULL, '', 1, 'ContactTopMenu', 10, 'contact.access', 'spacer.gif', 'icon_contact', '', 1, NULL, 1, NULL),
('Contact.Manage', 'contact', 'View Contacts', '/contact/contact_list', '', NULL, '', 1, 'Contact', 10, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('Contact.Detail', 'contact', 'Contact Detail', '/contact/contact_detail', '', NULL, '', 1, 'Contact.Manage', 5, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('Contact.GCard', 'contact', 'View General Card', '/contact/contact_general_card', '', NULL, '', 1, 'Contact.Manage', 10, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('Contact.DCard', 'contact', 'View Detailed Card', '/contact/contact_detail_card', '', NULL, '', 1, 'Contact.Manage', 20, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('Contact.PhoneBook', 'contact', 'View Phone Book', '/contact/contact_list', '', NULL, '', 1, 'Contact.Manage', 30, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('Contact.Company', 'contact', 'View Company', '/contact/company_list', '', NULL, '', 1, 'Contact.Manage', 40, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('Contact.ByType', 'contact', 'View By Contact Type', '/contact/contact_type_list', '', NULL, '', 1, 'Contact.Manage', 50, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('Contact.New', 'contact', 'New Contact', '/contact/contact_new', '', NULL, '', 1, 'Contact', 12, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('Contact.Map', 'contact', 'Contact Map', '/contact/contact_map', '', NULL, '', 1, 'Contact', 15, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('Contact.Garbber', 'contact', 'Import Contacts', '/contact/contact_import', '', NULL, '', 1, 'Contact', 20, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('Contact.Type', 'contact', 'Contact Types', '/contact/contact_type', '', NULL, '', 1, 'Contact', 30, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('System.Cronjob', 'cronjob', 'Cronjob', '', '', NULL, '', 1, 'System', 40, '', 'spacer.gif', 'icon_cronjob', 'Cronjob Management Module', 1, NULL, 1, NULL),
('System.Cronjob.List', 'cronjob', 'Manage Cronjobs', '/cronjob/cronjob_list', '', NULL, '', 1, 'System.Cronjob', 10, '', '', '', '', 1, NULL, 1, NULL),
('Backup', 'backup', 'Backup', '', '', NULL, '', 1, 'system', 20, '', '', 'icon_backup', 'Database Backup Management', 1, NULL, 1, NULL),
('Backup.List', 'backup', 'Manage Backup', '{@home:url}/backup/backup_list', '', NULL, '', 1, 'Backup', 10, '', '', '', '', 1, NULL, 1, NULL),
('Backup.Device', 'backup', 'Device and Location', '{@home:url}/backup/backup_device_list', '', NULL, '', 1, 'Backup', 20, '', '', '', '', 1, NULL, 1, NULL),
('Cache', 'cache', 'Cache', '', '', NULL, '', 1, 'System', 50, '', 'spacer.gif', 'icon_cache', 'Cache Management', 1, NULL, 1, NULL),
('cache.manage', 'cache', 'Manage System Cache ', '/cache/manage', '', NULL, '', 1, 'Cache', 10, '', '', '', '', 1, NULL, 1, NULL),
('ContactMobile', 'contact_mob', 'Contacts', '/contact_mob/contact_list', '', NULL, '', 1, 'MobileRoot', 10, 'contact.access', 'spacer.gif', 'icon_contact', '', 1, NULL, 1, NULL),
('ContactMobile.Manage', 'contact_mob', 'View Contacts', '/contact_mob/contact_list', '', NULL, '', 1, 'ContactMobile', 10, 'contact.access', '', '', '', 1, NULL, 1, NULL),
('System.Email', 'email', 'Email', '', '', NULL, '', 1, 'System', 30, '', 'spacer.gif', 'icon_email_queue', 'System Email Management', 1, NULL, 1, NULL),
('System.Email.Queue', 'email', 'Manage Email Queue', '/email/email_queue_list', '', NULL, '', 1, 'System.Email', 10, '', '', '', '', 1, NULL, 1, NULL),
('System.Email.Log', 'email', 'Manage Email Log', '/email/email_log_list', '', NULL, '', 1, 'System.Email', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Email.Setting', 'email', 'Manage Email Account', '/email/email_setting_list', '', NULL, '', 1, 'System.Email', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Email.Template', 'email', 'Manage Email Template', '/email/email_template_list', '', NULL, '', 1, 'System.Email', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.EventLog', 'eventlog', 'Event Log', '', '', NULL, '', 1, 'System', 60, '', 'spacer.gif', 'icon_eventlog', 'Event Log Management', 1, NULL, 1, NULL),
('System.EventLog.List', 'eventlog', 'Manage EventLog', '/eventlog/event_log_list', '', NULL, '', 1, 'System.EventLog', 10, '', '', '', '', 1, NULL, 1, NULL),
('System.Setting.Location', 'location', 'Location Setting', '/location/location_setting', '', NULL, '', 1, 'System.Setting', 30, '', '', '', '', 1, NULL, 1, NULL),
('Market', 'market', 'Market', '', '', NULL, '', 1, 'System', 18, 'Market.Manage', 'spacer.gif', 'icon_market', '', 1, NULL, 1, NULL),
('Market.FeaturedApps', 'market', 'Featured Apps', '/market/featured_apps', '', NULL, '', 1, 'Market', 10, 'Market.Manage', '', '', '', 1, NULL, 1, NULL),
('Market.Application', 'market', 'Applications', '/market/applications', '', NULL, '', 1, 'Market', 20, 'Market.Manage', '', '', '', 1, NULL, 1, NULL),
('Market.ApplicationDetail', 'market', 'Application Detail', '/market/application_detail', '', NULL, '', 1, 'Market.Application', 20, 'Market.Manage', '', '', '', 1, NULL, 1, NULL),
('Market.Installed', 'market', 'Installed', '/market/app_installed', '', NULL, '', 1, 'Market', 35, 'Market.Manage', '', '', '', 1, NULL, 1, NULL),
('Market.ApplicationInstallDetail', 'market', 'Application Detail', '/market/application_installed_detail', '', NULL, '', 1, 'Market.Installed', 20, 'Market.Manage', '', '', '', 1, NULL, 1, NULL),
('Market.Updates', 'market', 'Updates', '/market/app_updates', '', NULL, '', 1, 'Market', 40, 'Market.Manage', '', '', '', 1, NULL, 1, NULL),
('Market.ApplicationUpdateDetail', 'market', 'Application Detail', '/market/application_update_detail', '', NULL, '', 1, 'Market.Updates', 20, 'Market.Manage', '', '', '', 1, NULL, 1, NULL),
('Market.Repository', 'market', 'Repositories', '/market/app_repository', '', NULL, '', 1, 'Market', 50, 'Market.Manage', '', '', '', 1, NULL, 1, NULL),
('MyAccount', 'myaccount', 'My Account', '', '', NULL, '', 1, 'TopHeader', 50, '', '', '', '', 1, NULL, 1, NULL),
('MyAccount.EditAccount', 'myaccount', 'General', '/myaccount/dashboard', '', NULL, '', 1, 'MyAccount', 10, '', '', 'icon_myaccount', 'General system settings', 1, NULL, 1, NULL),
('MyAccount.EditProfile', 'myaccount', 'My Profile', '/myaccount/my_profile', '', NULL, '', 1, 'MyAccount.EditAccount', 10, '', '', '', '', 1, NULL, 1, NULL),
('MyAccount.EditLocation', 'myaccount', 'My Locations', '/myaccount/my_location', '', NULL, '', 1, 'MyAccount.EditAccount', 15, '', '', '', '', 1, NULL, 1, NULL),
('MyAccount.EditPicture', 'myaccount', 'My Pictures', '/myaccount/my_picture', '', NULL, '', 1, 'MyAccount.EditAccount', 18, '', '', '', '', 1, NULL, 1, NULL),
('MyAccount.EditPref', 'myaccount', 'My Preferences', '/myaccount/my_preference', '', NULL, '', 1, 'MyAccount.EditAccount', 20, '', '', '', '', 1, NULL, 1, NULL),
('MyAccount.EditDashboard', 'myaccount', 'My Dashboard', '/myaccount/my_dashboard', '', NULL, '', 1, 'MyAccount.EditAccount', 25, '', '', '', '', 1, NULL, 1, NULL),
('MyAccount.ViewEventLog', 'myaccount', 'My Event Log', '/myaccount/my_event_log', '', NULL, '', 1, 'MyAccount.EditAccount', 30, '', '', '', '', 1, NULL, 1, NULL),
('MyAccount.SetPassword', 'myaccount', 'Change Password', '/myaccount/reset_password', '', NULL, '', 1, 'MyAccount.EditAccount', 40, '', '', '', '', 1, NULL, 1, NULL),
('Oauth.List', 'oauth', 'OAuth Intergration', '/oauth/provider_setting', '', NULL, '', 1, 'System.Extension', 10, '', '', '', '', 1, NULL, 1, NULL),
('Oauth.MyAccount', 'oauth', 'My Social Account', '/myaccount/my_social_account', '', NULL, '', 1, 'MyAccount.EditAccount', 25, '', '', '', '', 1, NULL, 1, NULL),
('System.Payment.Provider', 'payment', 'Payment Intergration', '/payment/intergration_setting', '', NULL, '', 1, 'System.Extension', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Security', 'security', 'Security', '', '', NULL, '', 1, 'System', 50, '', 'spacer.gif', 'icon_security', 'Security Rules Management', 1, NULL, 1, NULL),
('System.Security.rule', 'security', 'Manage Security Rules', '/security/security_rule', '', NULL, '', 1, 'System.Security', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Sms.Provider', 'sms', 'SMS Intergration', '/sms/intergration_setting', '', NULL, '', 1, 'System.Extension', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Theme', 'theme', 'Theme', '', '', NULL, '', 1, 'System', 50, 'Theme.Administer_Theme', 'spacer.gif', 'icon_theme', 'Theme Management', 1, NULL, 1, NULL),
('System.Theme.Manage', 'theme', 'Manage Theme', '/theme/manage_theme', '', NULL, '', 1, 'System.Theme', 10, 'Theme.Administer_Theme', '', '', '', 1, NULL, 1, NULL),
('System.Theme.CustomLogo', 'theme', 'Custom Logo', '/theme/custom_logo', '', NULL, '', 1, 'System.Theme', 20, 'Theme.Administer_Theme', '', '', '', 1, NULL, 1, NULL),
('System.Theme.CustomHeader', 'theme', 'Custom Header', '/theme/custom_header', '', NULL, '', 1, 'System.Theme', 30, 'Theme.Administer_Theme', '', '', '', 1, NULL, 1, NULL),
('System.Translation', 'translation', 'Translation', '', '', NULL, '', 1, 'System', 50, '', 'spacer.gif', 'icon_translation', 'Translation Management', 1, NULL, 1, NULL),
('System.Translation.translation', 'translation', 'Manage UI Translation', '/translation/manage_translation', '', NULL, '', 1, 'System.Translation', 20, '', '', '', '', 1, NULL, 1, NULL),
('System.Translation.language', 'translation', 'Manage Languages', '/translation/manage_language', '', NULL, '', 1, 'System.Translation', 30, '', '', '', '', 1, NULL, 1, NULL),
('MobileRoot', 'user_mob', 'Mobile Home', '', '', NULL, '', 1, 'NONE', 10, '', '', '', '', 1, NULL, 1, NULL),
('Websvc.Websvc', 'websvc', 'Web Services', '', '', NULL, '', 1, 'System', 100, '', 'spacer.gif', 'icon_websvc', 'Web service administration', 1, NULL, 1, NULL),
('Websvc.Websvc.List', 'websvc', 'Web Service Admin', '{@home:url}/websvc/websvc_list', '', NULL, '', 1, 'Websvc.Websvc', 10, '', '', '', '', 1, NULL, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `meta_do`
--

CREATE TABLE `meta_do` (
  `name` varchar(100) NOT NULL,
  `module` varchar(100) NOT NULL,
  `class` varchar(100) NOT NULL,
  `dbname` varchar(100) DEFAULT NULL,
  `table` varchar(100) DEFAULT NULL,
  `data` text,
  `fields` text,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `meta_form`
--

CREATE TABLE `meta_form` (
  `name` varchar(100) NOT NULL,
  `module` varchar(100) NOT NULL,
  `class` varchar(100) NOT NULL,
  `dataobj` varchar(100) DEFAULT NULL,
  `template` varchar(100) DEFAULT NULL,
  `data` text,
  `elements` text,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `meta_view`
--

CREATE TABLE `meta_view` (
  `name` varchar(100) NOT NULL,
  `module` varchar(100) NOT NULL,
  `class` varchar(100) NOT NULL,
  `template` varchar(100) DEFAULT NULL,
  `data` text,
  `forms` text,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `module`
--

CREATE TABLE `module` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  `status` int(2) DEFAULT '1',
  `author` varchar(64) DEFAULT NULL,
  `version` varchar(64) DEFAULT NULL,
  `openbiz_version` varchar(64) DEFAULT NULL,
  `depend_on` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=31 ;

--
-- Dumping data for table `module`
--

INSERT INTO `module` VALUES
(1, 'system', 'system module, only administrator can access', 1, 'Rocky', '2.3', '3.0', ''),
(2, 'menu', 'menu management module', 1, 'Jixian, Rocky', '0.4', '3.0', 'system'),
(3, 'help', 'help management module', 1, '', '1.1', '3.0', 'system,menu'),
(4, 'contact', 'contact management module', 1, '', '0.7.10', '3.0', 'system,menu'),
(5, 'cronjob', 'cronjob management module', 1, '', '0.4', '3.0', 'system,menu'),
(6, 'attachment', 'attachments management module', 1, 'Jixian', '0.4', '3.0', 'system,menu'),
(7, 'backup', 'backup module', 1, 'Jixian', '0.5', '2.4', 'system,cronjob'),
(8, 'cache', 'Cache management module', 1, 'Jixian', '0.4', '3.0', 'system,menu'),
(9, 'changelog', 'This module designed for record and review data change logs', 1, 'Jixian', '0.1', '3.0', 'system,menu'),
(10, 'chart', 'Report Chart Module', 1, '', '0.3', '2.4', 'system'),
(11, 'common', 'common module', 1, '', '2.0', '3.0', ''),
(12, 'contact_mob', 'Contact mobile module', 1, '', '0.1.2', '3.0', 'system,menu'),
(13, 'email', 'email module is to provide email queue and log functions', 1, 'Jixian', '0.5', '3.0', 'system,menu'),
(14, 'eventlog', 'Event log module, only administrator can access', 1, 'Rocky', '0.4', '3.0', ''),
(15, 'extend', 'contact management module', 1, '', '0.3', '3.0', 'system,menu'),
(16, 'location', 'locations management module', 1, 'Jixian', '0.3', '3.0', 'system,menu'),
(17, 'market', 'Openbiz Cubi app market module', 1, 'Jixian Wang', '0.8', '2.4', 'system'),
(18, 'myaccount', 'My Account Module', 1, '', '1.0.2', '3.0', 'system,menu,contact'),
(19, 'notification', 'Openbiz Cubi notification module', 1, 'Jixian Wang', '0.2', '2.4', 'system'),
(20, 'oauth', 'OAuth extension module', 1, '', '0.4', '3.0', 'system'),
(21, 'payment', 'payment intergration could be used for Store system', 1, 'Jixian Wang', '0.6', '3.0', 'system,menu'),
(22, 'picture', 'pictures management module', 1, 'Jixian', '0.2', '3.0', 'system,menu'),
(23, 'security', 'system security module', 1, 'Jixian', '0.2', '3.0', 'system,menu'),
(24, 'service', 'Shared Serivce Library', 1, 'Jixian Wang, Rocky Swen', '0.6', '3.0', 'system,menu'),
(25, 'sms', 'Sms module provides SMS queue and log functions', 1, 'Feng ShengLong', '0.6', '3.0', 'system,menu'),
(26, 'theme', 'Theme management module', 1, 'Jixian', '0.7', '3.0', 'system,menu'),
(27, 'translation', 'UI translation management module', 1, 'Jixian', '0.2', '2.4', 'system,menu'),
(28, 'user', 'usr login, my account edit, password reset', 1, 'Rocky, Jixian', '0.4', '3.0', 'system,menu'),
(29, 'user_mob', 'usr login, my account edit, password reset', 1, 'Rocky, Jixian', '0.4.1', '3.0', 'system,menu'),
(30, 'websvc', 'websvc module', 1, '', '0.5', '3.0', 'system');

-- --------------------------------------------------------

--
-- Table structure for table `module_changelog`
--

CREATE TABLE `module_changelog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `version` varchar(64) DEFAULT NULL,
  `publish_date` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=48 ;

--
-- Dumping data for table `module_changelog`
--

INSERT INTO `module_changelog` VALUES
(1, 'system', 'system_feature_23', 'Add group setting initialize feature', 'Finished', 'New_Feature', '2.3', '2013-01-09'),
(2, 'system', 'system_feature_21', 'added system initialize feature', 'Finished', 'New_Feature', '2.1', '2012-10-17'),
(3, 'system', 'system_feature_20', 'Added OAuth supports', 'Finished', 'New_Feature', '2.0', '2012-04-30'),
(4, 'system', 'feature_11', 'Added multi currency supports', 'Finished', 'New_Feature', '1.1', '2012-03-15'),
(5, 'system', 'feature_19', 'Role and group detail views can show associated users', 'Finished', 'New_Feature', '1.0', '2012-03-04'),
(6, 'system', 'feature_09', 'Added a super switch user feature, Users who has this permission change change himself into another one on fly, even without knowing it''s password', 'Finished', 'New_Feature', '0.9', '2012-01-29'),
(7, 'system', 'feature_08', 'Added session manager can allow administrator to view and manage user session', 'Finished', 'New_Feature', '0.8', '2012-01-03'),
(8, 'system', 'feature_07.7', 'Added module and resource selectors in Role permission setting.', 'Finished', 'New_Feature', '0.7', '2011-05-02'),
(9, 'system', 'feature_06.7', 'Added module and resource selectors in Role permission setting.', 'Finished', 'New_Feature', '0.6', '2011-05-02'),
(10, 'system', 'feature_06.6', 'Fiexed display of module dependency framework version.', 'Finished', 'Bug_Fiexed', '0.6', '2011-05-02'),
(11, 'system', 'feature_06.5', 'Change log module added a load changes for all modules.', 'Finished', 'New_Feature', '0.6', '2011-04-18'),
(12, 'system', 'feature_06.4', 'Checkbox element support default status by specify DefaultChecked attribute in metadata', 'Finished', 'Bug_Fiexed', '0.6', '2011-04-17'),
(13, 'system', 'feature_06.3', 'Added Change log history view.', 'Finished', 'New_Feature', '0.6', '2011-04-17'),
(14, 'system', 'feature_06.2', 'Added Change log feature for module management , It coulds allow user to view history of a module ,and what''s new in the new version release.', 'Finished', 'New_Feature', '0.6', '2011-04-17'),
(15, 'system', 'feature_06.1', 'Added multiplue group and role selection supports in user detail view.', 'Finished', 'New_Feature', '0.6', '2011-04-15'),
(16, 'help', 'help_feature_11', 'tutorial could be URL (iframe) or Content', 'Finished', 'New_Feature', '1.1', '2012-10-26'),
(17, 'help', 'help_feature_10', 'Help module support user tutorial feature', 'Finished', 'New_Feature', '1.0', '2012-10-18'),
(18, 'contact', 'feature_071', 'support extend fields feature', 'Finished', 'Feature', '0.7', '2012-03-03'),
(19, 'contact', 'feature_062', 'Custom fields has protect level control', 'Finished', 'Feature', '0.6', '2012-02-18'),
(20, 'contact', 'feature_061', 'Added custom field feature for contact', 'Finished', 'Feature', '0.6', '2012-02-18'),
(21, 'common', 'feature_060', 'Added advanced data manager feature', 'Finished', 'Feature', '0.6.0', '2012-02-15'),
(22, 'contact', 'feature_051', 'Added display_name_mask field for save name display logic', 'Finished', 'Feature', '0.5.1', '2012-02-14'),
(23, 'common', 'feature_050', 'Added advanced data assign feature', 'Finished', 'Feature', '0.5.0', '2012-02-14'),
(24, 'contact', 'feature_04', 'Added support Microsoft Excel 2003 format file import', 'Finished', 'Feature', '0.4', '2012-01-15'),
(25, 'extend', 'feature_03.1', 'Added module loader for extend module.', 'Finished', 'Feature', '0.3', '2012-03-03'),
(26, 'backup', 'feature_05.1', 'New feature of scheduled backup system available', 'Finished', 'New_Feature', '0.5', '2011-02-07'),
(27, 'backup', 'feature_04.1', 'Added missing icons to module resources', 'Finished', 'Bug_Fixed', '0.4', '2011-12-05'),
(35, 'picture', 'feature_02', 'added javascript slider feature', 'Finished', 'New_Feature', '0.2', '2012-03-13'),
(28, 'backup', 'bugfix_03.1', 'Fix backup archives management view sorting error bug, Removed sorting features', 'Finished', 'Bug_Fixed', '0.3', '2011-04-16'),
(29, 'backup', 'feature_03.2', 'Moved backup module related resources file to system resource folder.', 'Finished', 'New_Feature', '0.3', '2011-04-16'),
(30, 'extend', 'feature_02.1', 'Added default value supports.', 'Finished', 'Feature', '0.2', '2012-03-02'),
(34, 'extend', 'feature_01.1', 'Added access control attribute on form level.', 'Finished', 'Feature', '0.1', '2012-02-26'),
(31, 'chart', 'feature_2', 'added report chart color defines.', 'Finished', 'New_Feature', '0.2', '2012-02-01'),
(32, 'common', 'feature_200', 'Added advanced software product activation forms', 'Finished', 'Feature', '2.0', '2012-12-30'),
(33, 'websvc', 'feature_05', 'Enhanced UI for webservice module', 'Finished', 'Enhancement', '0.5', '2012-03-12'),
(36, 'market', 'market_feature_08', 'Added multi language support for market', 'Finished', 'Feature', '0.8', '2013-01-04'),
(37, 'market', 'market_feature_071', 'enhanced app update list, it able to shows install time and new release time', 'Finished', 'Feature', '0.7', '2012-11-13'),
(38, 'market', 'market_feature_072', 'add a cleanup button for app market to cleanup error or staled installs', 'Finished', 'Feature', '0.7', '2012-11-13'),
(39, 'market', 'market_feature_073', 'Setup default sort rule for installed and updated app list', 'Finished', 'Feature', '0.7', '2012-11-13'),
(40, 'market', 'market_feature_05', 'Fix a update list display issue', 'Finished', 'Bugfix', '0.5', '2012-04-17'),
(41, 'market', 'market_feature_04', 'Supports system theme deploy.', 'Finished', 'Bugfix', '0.5', '2012-04-11'),
(42, 'market', 'market_feature_03', 'Bugfix for notification service module.', 'Finished', 'Bugfix', '0.5', '2012-04-08'),
(43, 'myaccount', 'feature_102', 'Add initializae user profile feature', 'Finished', 'Feature', '1.0.2', '2013-01-07'),
(44, 'myaccount', 'feature_1', 'Added drag-n-drop dashboard', 'Finished', 'Feature', '1.0', '2012-08-01'),
(45, 'myaccount', 'feature_07', 'Added my pictures feature, allow user set their pictures', 'Finished', 'Feature', '0.7', '2012-02-26'),
(46, 'myaccount', 'feature_06', 'Added my locations feature, allow user set their default location', 'Finished', 'Feature', '0.6', '2012-02-13'),
(47, 'picture', 'feature_01', 'replaced a default icon', 'Finished', 'New_Feature', '0.1', '2012-01-16');

-- --------------------------------------------------------

--
-- Table structure for table `notification`
--

CREATE TABLE `notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `goto_url` varchar(255) NOT NULL DEFAULT '',
  `read_state` int(11) NOT NULL,
  `read_access` varchar(255) NOT NULL DEFAULT '',
  `update_access` varchar(255) NOT NULL DEFAULT '',
  `create_time` datetime NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `notification`
--


-- --------------------------------------------------------

--
-- Table structure for table `notification_checker`
--

CREATE TABLE `notification_checker` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `checker` varchar(255) NOT NULL DEFAULT '',
  `last_checktime` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `checker` (`checker`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `notification_checker`
--

INSERT INTO `notification_checker` VALUES
(1, 'market_checker', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `oauth_provider`
--

CREATE TABLE `oauth_provider` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `site_url` varchar(255) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) NOT NULL,
  `status` int(2) NOT NULL DEFAULT '0',
  `sortorder` int(11) NOT NULL DEFAULT '50',
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `create_by` (`create_by`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `oauth_provider`
--

INSERT INTO `oauth_provider` VALUES
(1, 'sina', 'http://open.weibo.com/', '', '', 0, 50, 1, '0000-00-00 00:00:00', 1, '0000-00-00 00:00:00'),
(2, 'qq', 'http://dev.t.qq.com/', '', '', 0, 50, 1, '0000-00-00 00:00:00', 1, '0000-00-00 00:00:00'),
(3, 'alipay', 'https://b.alipay.com/', '', '', 0, 50, 1, '0000-00-00 00:00:00', 1, '0000-00-00 00:00:00'),
(4, 'google', 'https://code.google.com/apis/console/', '', '', 0, 50, 1, '0000-00-00 00:00:00', 1, '0000-00-00 00:00:00'),
(5, 'facebook', 'https://developers.facebook.com/apps', '', '', 0, 50, 1, '0000-00-00 00:00:00', 1, '0000-00-00 00:00:00'),
(6, 'qzone', 'http://connect.qq.com', '', '', 0, 50, 1, '0000-00-00 00:00:00', 1, '0000-00-00 00:00:00'),
(7, 'twitter', 'http://api.twitter.com', '', '', 0, 50, 1, '0000-00-00 00:00:00', 1, '0000-00-00 00:00:00'),
(8, 'alitao', 'https://open.taobao.com/', '', '', 0, 50, 1, '0000-00-00 00:00:00', 1, '0000-00-00 00:00:00'),
(9, 'baiduapp', 'http://developer.baidu.com', '', '', 0, 50, 1, '0000-00-00 00:00:00', 1, '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `pass_token`
--

CREATE TABLE `pass_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `token` varchar(64) NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `token` (`token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `payment_log`
--

CREATE TABLE `payment_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `provider_id` int(11) NOT NULL,
  `txn_id` varchar(255) NOT NULL,
  `order_id` varchar(255) NOT NULL,
  `payer_email` varchar(255) NOT NULL,
  `payer_id` varchar(255) NOT NULL,
  `payment_subject` varchar(255) NOT NULL,
  `payment_amount` float NOT NULL,
  `payment_status` varchar(255) NOT NULL,
  `rawdata` longtext NOT NULL,
  `processed` int(2) NOT NULL,
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `payment_provider`
--

CREATE TABLE `payment_provider` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `driver` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `require_auth` int(11) NOT NULL DEFAULT '1',
  `account` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `secret` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `site_url` varchar(255) NOT NULL,
  `description` text,
  `priority` int(2) DEFAULT '50',
  `status` int(2) NOT NULL DEFAULT '1',
  `update_by` int(11) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `payment_provider`
--

INSERT INTO `payment_provider` VALUES
(1, 'payment.lib.driver.PaypalCN', 'Paypal 贝宝', 0, '', '', '', 'paypalcn', 'http://www.paypal.cn', NULL, 50, 0, 1, '2012-09-13 21:46:51', 0, '0000-00-00 00:00:00'),
(2, 'payment.lib.driver.Alipay', '支付宝', 1, '', '', '', 'alipay', 'https://b.alipay.com/', NULL, 55, 0, 1, '2012-09-16 23:07:15', 1, '0000-00-00 00:00:00'),
(3, 'payment.lib.driver.Paypal', 'Paypal', 0, '', '', '', 'paypal', 'http://www.paypal.com/', NULL, 50, 0, 1, '2012-09-14 22:10:53', 1, '0000-00-00 00:00:00'),
(4, 'payment.lib.driver.ChinaBank', '网银在线', 1, '', '', '', 'chinabank', 'http://www.chinabank.com.cn/', NULL, 50, 0, 1, '2012-09-20 16:28:03', 1, '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `picture`
--

CREATE TABLE `picture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT '',
  `foreign_id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT '',
  `description` text NOT NULL,
  `path` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `filename` varchar(255) DEFAULT '',
  `filesize` int(11) DEFAULT '0',
  `md5` varchar(255) DEFAULT '',
  `sha256` varchar(255) DEFAULT '',
  `group_id` int(11) DEFAULT '1',
  `group_perm` int(11) DEFAULT '1',
  `other_perm` int(11) DEFAULT '1',
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `preference`
--

CREATE TABLE `preference` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `section` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text,
  `type` varchar(255) NOT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

--
-- Dumping data for table `preference`
--

INSERT INTO `preference` VALUES
(1, 0, 'General', 'group_data_share', '1', 'Radio', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(2, 0, 'Data Sharing', 'owner_perm', '3', 'DropDownList', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(3, 0, 'Data Sharing', 'group_perm', '1', 'DropDownList', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(4, 0, 'Data Sharing', 'other_perm', '0', 'DropDownList', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(5, 0, 'General', 'siteurl', '[[softurl]]', 'InputText', 1, '2011-12-01 01:57:43', 1, '[[regtime]]'),
(6, 0, 'Localization', 'language', 'en_US', 'myaccount.form.LanguageSelector', 1, '2011-12-01 01:57:43', 1, '[[regtime]]'),
(7, 0, 'General', 'theme', 'default', 'myaccount.form.ThemeSelector', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(8, 0, 'General', 'appbuilder', '1', 'DropDownList', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(9, 0, 'Timezone', 'continent', 'Asia', 'myaccount.form.ContinentSelector', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(10, 0, 'Timezone', 'timezone', 'Asia/Chongqing', 'myaccount.form.TimezoneSelector', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(11, 0, 'Login', 'smartcard_auth', '0', 'DropDownList', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(12, 0, 'Login', 'anti_spam', '0', 'DropDownList', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(13, 0, 'Login', 'language_selector', '1', 'DropDownList', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(14, 0, 'Login', 'theme_selector', '0', 'DropDownList', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(15, 0, 'Login', 'keep_cookies', '1', 'DropDownList', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(16, 0, 'Register', 'open_register', '1', 'DropDownList', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(17, 0, 'Register', 'find_password', '1', 'DropDownList', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(18, 0, 'General', 'system_name', '[[site_name]]', 'InputText', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43'),
(19, 0, 'Session', 'sessionstrict', '0', 'DropDownList', 1, '2011-12-01 01:57:43', 1, '2011-12-01 01:57:43');

-- --------------------------------------------------------

--
-- Table structure for table `role`
--

CREATE TABLE `role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  `status` int(2) DEFAULT '1',
  `default` int(2) DEFAULT '0',
  `startpage` varchar(255) NOT NULL,
  `create_by` int(10) DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  `update_by` int(10) DEFAULT '1',
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `default` (`default`),
  KEY `status` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `role`
--

INSERT INTO `role` VALUES
(1, 'Cubi Administrator', 'System administrator', 1, 0, '/system/general_default', 1, NULL, 1, NULL),
(2, 'Cubi Member', 'General registered users', 1, 1, '/myaccount/my_profile', 1, NULL, 1, NULL),
(3, 'Cubi Guest', 'Guest users are unregistered users', 1, 0, '/system/general_default', 1, NULL, 1, NULL),
(4, 'Contact Member', 'Openbiz Contact Member', 1, 1, '/contact/contact_list', 1, NULL, 1, NULL),
(5, 'Data Assigner', 'Can manage data assignment between groups', 1, 1, '/myaccount/my_profile', 1, NULL, 1, NULL),
(6, 'Data Manager', 'Can manage all data in entire system', 1, 0, '/myaccount/my_profile', 1, NULL, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `session`
--

CREATE TABLE `session` (
  `id` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL,
  `user_id` int(11) NOT NULL,
  `expiration` int(10) unsigned NOT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL,
  `ipaddr` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `last_url` text COLLATE utf8_unicode_ci NOT NULL,
  `create_time` datetime NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `session`
--


-- --------------------------------------------------------

--
-- Table structure for table `sms_log`
--

CREATE TABLE `sms_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `provider_id` int(11) NOT NULL,
  `mobile` varchar(11) NOT NULL,
  `content` longtext NOT NULL,
  `schedule` datetime NOT NULL,
  `sent_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Table structure for table `sms_provider`
--

CREATE TABLE `sms_provider` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `driver` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `site_url` varchar(255) NOT NULL,
  `description` text,
  `msg_sent_count` int(11) DEFAULT '0',
  `msg_balance` int(11) DEFAULT '0',
  `msg_last_sendtime` datetime NOT NULL,
  `priority` int(2) DEFAULT '1',
  `status` int(2) NOT NULL DEFAULT '1',
  `update_by` int(11) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `sms_provider`
--

INSERT INTO `sms_provider` VALUES
(1, 'sms.lib.driver.SP18dx', '八信科技', '', '', '18dx', 'http://www.18dx.cn/', '长沙八信通讯科技有限公司是一家专注于移动通讯领域的科技公司。', 0, 0, '2012-09-06 09:52:03', 50, 0, 1, '2012-09-06 14:55:43', 1, '2012-08-01 23:10:17'),
(2, 'sms.lib.driver.SPc123', '创明短信', '', '', 'c123', 'http://www.c123.com', '上海创明网络科技有限公司是一家专注企业短信、移动商务、无线广告业务的公司', 0, 0, '2012-09-06 09:58:29', 50, 0, 1, '2012-09-06 14:59:11', 1, '0000-00-00 00:00:00'),
(3, 'sms.lib.driver.SPemay', '亿美软通', '', '', 'emay', 'http://www.emay.cn', '北京亿美软通科技有限公司（ Beijing Emay Softcom Technology Ltd.）是国际数据集团风险投资（IDG资本）在华注资的高科技企业、全球最大的信用局和数据营销公司Experian（益百利）的中国战略合作伙伴，是具备国际水准的移动商务平台技术和应用方案提供商。', 0, 0, '0000-00-00 00:00:00', 50, 0, 1, '2012-09-08 21:06:57', 1, '0000-00-00 00:00:00'),
(4, 'sms.lib.driver.SPc8686', '八优信息', '', '', 'c8686', 'http://www.c8686.com/', '上海八优信息科技有限公司是一家SP增值、软件开发、技术咨询和网站建设为主要业务的企业。', 0, 0, '0000-00-00 00:00:00', 50, 0, 1, '2012-09-08 21:06:57', 1, '0000-00-00 00:00:00'),
(5, 'sms.lib.driver.SPtclk', '同创凌凯', '', '', 'tclk', 'http://www.bjtclk.com/', '北京同创凌凯信息技术有限公司是以移动商务产品的研发、营销、短信中心平台运营为一体的信息技术科技公司', 0, 0, '0000-00-00 00:00:00', 50, 0, 1, '2012-09-08 21:06:57', 1, '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `sms_queue`
--

CREATE TABLE `sms_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mobile` varchar(11) NOT NULL,
  `content` longtext NOT NULL,
  `status` enum('pending','sending','sent') DEFAULT 'pending',
  `schedule` datetime NOT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `flag` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- Table structure for table `user`
--

CREATE TABLE `user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(64) NOT NULL DEFAULT '',
  `password` varchar(64) NOT NULL DEFAULT '',
  `enctype` varchar(64) NOT NULL DEFAULT 'SHA1',
  `email` varchar(64) DEFAULT '',
  `smartcard` varchar(255) DEFAULT NULL,
  `status` int(2) DEFAULT '1',
  `lastlogin` datetime DEFAULT NULL,
  `lastlogout` datetime DEFAULT NULL,
  `create_by` int(10) DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  `update_by` int(10) DEFAULT '1',
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `smartcard` (`smartcard`),
  KEY `email` (`email`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user`
--

INSERT INTO `user` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', 'SHA1', 'admin@yourcompany.com', NULL, 1, '[[regtime]]', '2009-08-24 13:24:14', 1, '2010-05-01 01:19:57', 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `user_group`
--

CREATE TABLE `user_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `default` int(2) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_group`
--

INSERT INTO `user_group` VALUES
(1, 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `user_oauth`
--

CREATE TABLE `user_oauth` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `oauth_uid` varchar(255) NOT NULL DEFAULT '',
  `oauth_class` char(80) NOT NULL,
  `oauth_token` varchar(255) DEFAULT NULL,
  `oauth_token_secret` varchar(255) DEFAULT NULL,
  `oauth_user_info` longtext,
  `oauth_rawdata` longtext NOT NULL,
  `is_sync` tinyint(1) NOT NULL,
  `status` int(11) NOT NULL,
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_pref`
--

CREATE TABLE `user_pref` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  `value` varchar(255) NOT NULL,
  `type` varchar(128) DEFAULT NULL,
  `create_by` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_by` int(11) DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_role`
--

CREATE TABLE `user_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `role_id` int(10) unsigned NOT NULL DEFAULT '0',
  `default` int(2) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `role_id` (`role_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `user_role`
--

INSERT INTO `user_role` VALUES
(1, 1, 1, 0),
(2, 1, 2, 0);

-- --------------------------------------------------------

--
-- Table structure for table `user_widget`
--

CREATE TABLE `user_widget` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `widget` varchar(255) NOT NULL,
  `view` varchar(255) NOT NULL DEFAULT '',
  `column` int(2) NOT NULL DEFAULT '1',
  `ordering` int(10) NOT NULL DEFAULT '10',
  `config` text,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `create_by` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_by` int(11) DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `widget` (`widget`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_widget`
--

INSERT INTO `user_widget` VALUES
(1, 1, 'myaccount.widget.DashboardForm', '', 1, 10, '', 1, 1, '2011-07-23 16:05:55', 1, '2011-07-23 16:05:55');

-- --------------------------------------------------------

--
-- Table structure for table `websvc`
--

CREATE TABLE `websvc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `api_key` varchar(255) DEFAULT NULL,
  `secret` varchar(255) DEFAULT NULL,
  `status` int(2) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `create_by` int(11) DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  `update_by` int(11) DEFAULT '1',
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `widget`
--

CREATE TABLE `widget` (
  `name` varchar(100) NOT NULL DEFAULT '',
  `module` varchar(100) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `configable` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '10',
  `create_by` int(10) DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  `update_by` int(10) DEFAULT '1',
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `widget`
--

INSERT INTO `widget` VALUES
('myaccount.widget.DashboardWidget', 'myaccount', 'My Account Features', NULL, 0, 1, 10, 1, '[[regtime]]', 1, '[[regtime]]'),
('myaccount.widget.EventLogWidget', 'myaccount', 'My Event Logs', NULL, 0, 1, 10, 1, '[[regtime]]', 1, '[[regtime]]');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
