
DROP TABLE IF EXISTS `help`;
CREATE TABLE IF NOT EXISTS `help` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '10',
  `content` longtext,
  `add1` varchar(255) DEFAULT NULL,
  `add2` int(10) DEFAULT NULL,
  `add3` varchar(255) DEFAULT NULL,
  `add4` int(10) DEFAULT NULL,
  `create_by` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_by` int(11) DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `create_by` (`create_by`),
  KEY `update_by` (`update_by`),
  KEY `category_id` (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
--

INSERT INTO `help` (`id`, `category_id`, `title`, `description`, `sort_order`, `content`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES
(1, 3, 'What is Module Management?', '<p>\n	Module Management screen allows administrator to manage modules in the application</p>\n', 10, '<p>\n	Action can be done on the module management screen.</p>\n<ul>\n	<li>\n		Edit button. This is to activate or deactivate a module</li>\n	<li>\n		Delete button. This is to delete a module. When a module is deleted, its ACL settings are deleted as well.</li>\n	<li>\n		Load button. This is to load new modules added in the modules directory. The loading processor will read mod.xml, and load module and it ACL info to the system.</li>\n</ul>\n', 1, '2010-05-01 13:01:58', 1, '2010-05-01 13:06:21'),
(2, 1, 'What is User Management ?', '<p>\n	User Manage screen allows administrator to manage application users</p>\n', 10, '<p>\n	Action can be done on the user management screen</p>\n<ul>\n	<li>\n		Add button to add a new user</li>\n	<li>\n		Edit button to edit a selected user</li>\n	<li>\n		Delete button to delete a selected user</li>\n</ul>\n', 1, '2010-02-07 16:07:21', 1, '2010-05-01 12:50:12'),
(3, 2, 'What is Role Management?', '<p>\n	Role Management screen allows administrator to manage roles in the application</p>\n', 10, '<p>\n	Actions can be done on the role management screen.</p>\n<ul>\n	<li>\n		Add button</li>\n	<li>\n		Edit button</li>\n	<li>\n		Delete button. If a role is deleted, its permissions will be deleted as well.</li>\n</ul>\n', 1, '2010-02-07 17:25:46', 1, '2010-05-01 12:58:06'),
(4, 6, 'How to ceate a help tip?', '<p>\r\n	You need to go to Manage Help tips module and click Add button to create a new help tips.</p>\r\n', 10, NULL, 1, '2010-04-24 04:18:35', 1, '2010-04-24 04:19:35'),
(5, 6, 'How to map a help category to system module?', '<p>\r\n	You can mapping a help category to a module&#39;s left help panel by specified URL match. then the module will only show help tips under this category.</p>\r\n', 10, NULL, 1, '2010-04-24 04:21:54', 1, '2010-04-24 04:21:54'),
(6, 3, 'How to reload a module?', '<p>\n	A module can be reloaded to update its change</p>\n', 10, '<p>\n	On the module management screen, click the module name to drilldown the module detail form. On this form, click Reload button to update the changes into the system</p>\n', 1, '2010-05-01 13:09:09', 1, '2010-05-01 13:09:09'),
(7, 4, 'What is Event Log?', '<p>\n	Event log screen is to list all events logged by the application</p>\n', 10, '<p>\n	On the Event Log screen, clicking on the comments link to see to event log detail.</p>\n<p>\n	Clicking on the Clear button, all log records will be deleted from the log table. Be careful of using it.</p>\n', 1, '2010-05-01 13:12:11', 1, '2010-05-01 13:15:33'),
(8, 5, 'How to manage email queue?', '<p>\n	Email Queue Management screen allows user to manage queued emails</p>\n', 10, '<p>\n	Action can be done on the email queue management screen.</p>\n<ul>\n	<li>\n		Send All button. This is to send all queued email immediately</li>\n	<li>\n		Send button. This is to send the selected email immediately</li>\n	<li>\n		Delete. This is to delete the selected email from the queue</li>\n	<li>\n		Delete Sent. This is to delete all sent emails from the queue</li>\n	<li>\n		Delete All. This is to empty the email queue</li>\n</ul>\n', 1, '2010-05-01 13:17:05', 1, '2010-05-01 16:18:48'),
(9, 5, 'How to manage email log?', '<p>\n	Email Log Management screen allows user to manage email activities</p>\n', 10, '<p>\n	Clicking the Clear button will empty the email log records.</p>\n', 1, '2010-05-01 13:18:11', 1, '2010-05-01 16:19:59'),
(10, 8, 'What is theme management', '<p>\n	Theme Management allow administor to review / install or uninstall a theme for the system. </p>\n', 10, NULL, 1, '2011-12-15 19:31:11', 1, '2011-12-15 19:31:11'),
(11, 11, 'How to change default language', '<p>\n	change cubi platfrom language from user preference setting.</p>\n', 10, '<p>\n	1 click user module and select user preference setting.&nbsp;</p>\n<p>\n	2 go down the the bottom of the page click &#39;edit&#39; button.</p>\n<p>\n	3 select the language you want to used for your cubi platform from &#39;general&#39;--&gt;&#39;default language&#39; options.</p>\n<p>\n	4 go to bottom of the page click &#39;save&#39; button.</p>\n<p>\n	5 re-log into the cubi.</p>\n', 1, '2011-12-16 10:59:20', 1, '2011-12-16 16:05:57'),
(12, 10, 'What is Cronjob item', '<p>\n	Cron is a time-based job scheduler in cubi systems.It&#39;s enables users to schedule jobs (commands or shell scripts) to run periodically at certain times or dates.</p>\n', 10, NULL, 1, '2011-12-16 15:52:21', 1, '2011-12-27 02:38:19'),
(13, 1, 'How to add a new user?', '<p>\n	follow the user manangement module to add an new user into cubi platform.</p>\n', 10, '<p>\n	1 Click user management function add button under user module as below screen picture.</p>\n<p>\n	<img alt="" height="198" src="/cubi/files/upload/helptips/user/1.png" width="732" /></p>\n<p>\n	2 input the new user name and password and email address and set state to active then click save.</p>\n<p>\n	<img alt="" height="352" src="/cubi/files/upload/helptips/user/2.png" width="381" /></p>\n<p>\n	3 input the related user information like address, telephone and so on in the contact profile form then save.</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/user/3.png" /></p>\n<p>\n	4 now you have add an new user into cubi platform.</p>\n', 1, '2011-12-16 17:33:15', 1, '2011-12-25 19:40:53'),
(14, 1, 'How to change user profile', '<p>\n	change or replenish user&#39;s personal information&nbsp;</p>\n', 10, '<p>\n	&nbsp;1 log into cubi</p>\n<p>\n	&nbsp;</p>\n<p>\n	2 click left navigation user module</p>\n<p>\n	<img alt="" height="126" src="/cubi/files/upload/helptips/user/4.png" width="189" /></p>\n<p>\n	3 select the user that you need to change information</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/user/5.png" /></p>\n<p>\n	3 click profile button to change or replenish your personal information like phone number or address</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/user/6.png" /></p>\n', 1, '2011-12-22 23:21:39', 1, '2011-12-25 19:47:18'),
(15, 2, 'What is role for?', '<p>\n	User role could be used for assign different role management in different modules.</p>\n', 10, NULL, 1, '2011-12-23 16:06:02', 1, '2011-12-23 16:06:02'),
(16, 2, 'How to create an role and set up his authority??', '<p>\n	User could split up administrator and common user with role management</p>\n', 10, '<p>\n	1 click left navigation role moudle</p>\n<p>\n	<img alt="" height="119" src="/cubi/files/upload/helptips/role/1.png" width="189" /></p>\n<p>\n	2 click add button to create an new type role you needed for your application</p>\n<p>\n	<img alt="" height="138" src="/cubi/files/upload/helptips/role/2.png" width="715" /></p>\n<p>\n	3 create an new type of role you needed</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/role/3.png" /></p>\n<p>\n	4 back to role management page select the new role you have created and click perm for set up access permission</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/role/4.png" /></p>\n', 1, '2011-12-23 16:51:56', 1, '2011-12-25 20:06:11'),
(17, 2, 'what is default page for?', '<p>\n	there is an option when user create an new type of role in cubi platfrom called &quot;default page&quot;</p>\n', 10, '<p>\n	1 there is an option when user create an new type of role in cubi platfrom called &quot;Default page&quot;</p>\n<p>\n	/cubi/files/upload/helptips/role/2.png<img alt="" src="/cubi/files/upload/helptips/role/5.png" /></p>\n<p>\n	2 the default page option is the first start page when user are using the role log into cubi platform.</p>\n<p>\n	&nbsp;</p>\n<p>\n	3 the default page option is part of full path of the moudle, for example: email moudle user default page should be the path &quot;/email/email_queue_list&quot; after index.php</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/role/6.png" /></p>\n', 1, '2011-12-23 17:12:17', 1, '2011-12-25 20:07:13'),
(19, 12, 'backup Cubi system to portable hard disk', '<p>\n	user can use &quot;Device and Location&quot; funcation under backup module to backup their cubi data into their portable hard disk or the other hard disk</p>\n', 10, '<p>\n	1 click &quot;Device and Location&quot; function under Backup module</p>\n<p>\n	<img alt="" height="82" src="/cubi/files/upload/helptips/backup/5.png" width="198" /></p>\n<p>\n	2 click add button to set up an user&#39;s backup device</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/backup/6.png" /></p>\n<p>\n	3 input the user&#39;s backup device path like: /mnt/ (the user&#39;s backup up device could be an portable hard disk or even a flahs disk that connected with cubi server, then administrator can set up the hard disk mount point usually /mnt/)</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/backup/7.png" /></p>\n<p>\n	&nbsp;</p>\n<p>\n	4 save and then Cubi&#39;s data have been backup into user&#39;s backup device.</p>\n', 1, '2011-12-25 21:10:33', 1, '2011-12-25 21:10:33'),
(20, 12, 'why backup?', '<p>\n	Usually all the user&#39;s Cubi apply information and data have been saved into Cubi server, but for enhance system safety user&#39;s can backup Cubi date into Portable hard disk</p>\n', 10, NULL, 1, '2011-12-25 21:15:20', 1, '2011-12-25 21:15:20'),
(21, 14, 'what is group module for?', '<p>\n	group module can set up different group for user that could be used for split up user from different projects</p>\n', 10, NULL, 1, '2011-12-26 00:22:49', 1, '2011-12-26 00:22:49'),
(22, 14, 'How to create a group and set user into it', '<p>\n	this is an example of how to use group to partition users</p>\n', 10, '<p>\n	1 click &quot;Group Management&quot; function under dgroup module</p>\n<p>\n	<img alt="" height="80" src="/cubi/files/upload/helptips/group/1.png" width="190" /></p>\n<p>\n	2 click add button to create an new group</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/group/2.png" /></p>\n<p>\n	3 input the new group name and description then save it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/group/3.png" /></p>\n<p>\n	4 go to the &quot;User Management&quot; function under user module</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/group/4.png" /></p>\n<p>\n	5 select the user &quot;jack&quot; who you want to assign to the new create group &quot;project&quot; and click Detail button</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/group/5.png" /></p>\n<p>\n	6 click add button in user group panel in the bottom of the User Detail page </p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/group/6.png" /></p>\n<p>\n	7 select the group you want the user &quot;jack&quot; belong to and check it then will automatically save the change</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/group/7.png" /></p>\n', 1, '2011-12-26 00:34:51', 1, '2011-12-26 00:56:52'),
(23, 14, 'what is Group Data Sharing for?', '<p>\n	It is set up the default Group Data Share rule </p>\n<p>\n	Default setting is user create an new record will auto have full control and his group can read the record and others can not see it</p>\n', 10, NULL, 1, '2011-12-26 01:25:10', 1, '2011-12-26 01:25:10'),
(24, 15, 'How to connect database', '<p>\n	Cubi platform not only limit to connect with it&#39;s own database but also can connect to other database in different locations</p>\n', 10, '<p>\n	1 click &quot;Database Connections&quot; function under system module</p>\n<p>\n	<img alt="" height="78" src="/cubi/files/upload/helptips/system/1.png" width="189" /></p>\n<p>\n	2 click add button to create an new database connection</p>\n<p>\n	<img alt="" height="268" src="/cubi/files/upload/helptips/system/2.png" width="727" /></p>\n<p>\n	3 input the database connection name and select database type and input username and password of the database connection</p>\n<p>\n	&nbsp; if you have input right user name and password of the database connection that you are trying to connected then you could click Load Database to list your database information</p>\n<p>\n	<img alt="" height="503" src="/cubi/files/upload/helptips/system/3.png" width="470" /></p>\n<p>\n	4 back to Database Connection function page where you can see the new connection have been successed created now and status is check.</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/system/4.png" /></p>\n', 1, '2011-12-26 02:36:33', 1, '2011-12-26 02:57:51'),
(25, 5, 'What is email module for?', '<p>\n	Cubi Email module is&nbsp; an internal notify email module that can auto send some email to company user for new user registration or email password reset or system error notice or Cronjob progress.</p>\n', 10, NULL, 1, '2011-12-27 02:03:20', 1, '2011-12-27 02:03:20'),
(26, 5, 'Email module function introduce', '<p>\n	Email module have four functions: 1 queue 2 log 3 account 4 template</p>\n', 10, '<p>\n	1 there are four functions under email module</p>\n<p>\n	<img alt="" height="124" src="/cubi/files/upload/helptips/email/1.png" width="191" /></p>\n<p>\n	2 Manage Email Queue function could see the emails are waiting for sent to the users</p>\n<p>\n	<img alt="" height="229" src="/cubi/files/upload/helptips/email/2.png" width="668" /></p>\n<p>\n	3 Manage Email log function can manage all the emails have been auto sent by email module <img alt="" height="287" src="/cubi/files/upload/helptips/email/3.png" width="659" /></p>\n<p>\n	4 Email Accounts Management function can manage the auto send email account from which email account <img alt="" src="/cubi/files/upload/helptips/email/4.png" /></p>\n<p>\n	5 Email Template Management function can edit the auto send email information like welcome letter detail<img alt="" height="286" src="/cubi/files/upload/helptips/email/5.png" width="656" /></p>\n', 1, '2011-12-27 02:16:38', 1, '2011-12-27 02:29:04'),
(27, 16, 'What is Cache module for?', '<p>\n	Cache module can be used to manage Cubi platform cache when add new module or add new function in Cubi need reload or clear cache.</p>\n', 10, '<p>\n	1 Click Manage System Cache under Cache</p>\n<p>\n	<img alt="" height="53" src="/cubi/files/upload/helptips/cache/1.png" width="175" /></p>\n<p>\n	2 user can reload or clear cache from cache management when some system module have been changed to let the new change take effect</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/cache/2.png" /></p>\n', 1, '2011-12-27 03:08:41', 1, '2011-12-27 03:08:41'),
(28, 17, 'What is Security module for?', '<p>\r\n	Security module is designed for set up some access&nbsp;rules between internet and intranet.</p>\r\n', 10, '<p>\r\n	&nbsp;1 click &quot;Management Security Rules&quot; function under Security module</p>\r\n<p>\r\n	<img alt="" height="55" src="/cubi/files/upload/helptips/security/1.PNG" width="187" /></p>\r\n<p>\r\n	2 administrator can use security rules to set up six types access rules:</p>\r\n<p>\r\n	&nbsp;&nbsp; 1) access authority based on certain URL</p>\r\n<p>\r\n	&nbsp;&nbsp; 2) access authority based on certain Domain like only permit access from <a href="http://www.openbiz.cn">www.openbiz.cn</a></p>\r\n<p>\r\n	&nbsp;&nbsp; 3) access authority based on certain IP like only permit 192.168.1.xxx and from company can access to user&#39;s company cubi server</p>\r\n<p>\r\n	&nbsp;&nbsp; and so on</p>\r\n<p>\r\n	<img alt="" src="/cubi/files/upload/helptips/security/2.PNG" /></p>\r\n', 1, '2011-12-27 06:19:45', 1, '2011-12-27 06:19:45'),
(29, 18, 'What is Translation module for?', '<p>\r\n	Translation module can let user translate Cubi into whatever language they want Cubi using. Here is an chinese translation example</p>\r\n', 10, '<p>\r\n	1 click &quot;Manage Languages&quot;</p>\r\n<p>\r\n	<img alt="" height="80" src="/cubi/files/upload/helptips/translation/1.PNG" width="191" /></p>\r\n<p>\r\n	2 click add button to add one new language package that you needed then Cubi system will auto download the language you select from google language package.&nbsp;&nbsp;&nbsp;<img alt="" height="183" src="/cubi/files/upload/helptips/translation/2(1).png" width="734" /></p>\r\n<p>\r\n	3&nbsp; In this example i select chinese language and save</p>\r\n<p>\r\n	<img alt="" height="744" src="/cubi/files/upload/helptips/translation/3(1).png" width="719" /></p>\r\n<p>\r\n	4&nbsp; back to &quot;Manage UI Translation&quot; function</p>\r\n<p>\r\n	<img alt="" src="/cubi/files/upload/helptips/translation/8.PNG" /></p>\r\n<p>\r\n	5 select the language you just download in this example i select chinese</p>\r\n<p>\r\n	<img alt="" height="196" src="/cubi/files/upload/helptips/translation/4.PNG" width="710" /></p>\r\n<p>\r\n	6 Cubi will list all the Cubi platform background module select the module you want to translate</p>\r\n<p>\r\n	<img alt="" height="795" src="/cubi/files/upload/helptips/translation/5.PNG" width="554" /></p>\r\n<p>\r\n	7 in this example i select System module which metadata is mod.system.ini and change one label into &quot;用户亲景设置1&quot; and save it</p>\r\n<p>\r\n	<img alt="" src="/cubi/files/upload/helptips/translation/6.PNG" /></p>\r\n<p>\r\n	8 back to &quot;Preference Setting&quot; function under system module check the change i just made that could see the new brower lab have been change into &quot;用户亲景设置1&quot; now</p>\r\n<p>\r\n	<img alt="" src="/cubi/files/upload/helptips/translation/7.PNG" /></p>', 1, '2011-12-27 08:18:54', 1, '2011-12-27 08:30:35'),
(30, 4, 'What is event log for?', '<p>\r\n	Event log&nbsp;module create an API that &nbsp;can easily to&nbsp;see server log detail</p>\r\n', 10, '<p>\r\n	Event Log module can let administrator easily to see server&#39;s log, right now we just create one kind of log in or log out log information in this event log module.</p>\r\n<p>\r\n	If there are more specific require we can add more event log function in it</p>\r\n<p>\r\n	1 click &quot;Manage Eventlog&quot; function under Event Log module</p>\r\n<p>\r\n	&nbsp;<img alt="" height="57" src="/cubi/files/upload/helptips/event_log/1.PNG" width="189" /></p>\r\n<p>\r\n	2 Check all the event log</p>\r\n<p>\r\n	<img alt="" height="504" src="/cubi/files/upload/helptips/event_log/2.PNG" width="735" /></p>\r\n', 1, '2011-12-27 08:48:20', 1, '2011-12-27 08:48:20'),
(31, 20, 'What is Contacts?', '<p>\n	Contacts module provide user more contact information input options like user&#39;s photo, phone number, address so on.</p>\n', 10, '<p>\n	1 click &quot;Contack Manage&quot; function under contacts module.</p>\n<p>\n	<img alt="" height="99" src="/cubi/files/upload/helptips/Collaboration/contacts/1(1).png" width="190" /></p>\n<p>\n	2 replenish the user&#39;s information in there like phone number, address so on</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/2.png" /></p>\n', 1, '2011-12-28 01:53:37', 1, '2011-12-28 01:56:33'),
(32, 20, 'Dispaly contacts as required', '<p>\n	Collaboration can let user check all the contacts as they required way like: group by company, or group by cards</p>\n', 10, '<p>\n	1 Click &quot;Contact Manage&quot; function under contacts module and select Contact View Mode as Phone Book </p>\n<p>\n	<img alt="" height="525" src="/cubi/files/upload/helptips/Collaboration/contacts/3.png" width="199" /></p>\n<p>\n	2 then all the contacts will arrange as phone book number</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/4.png" /></p>\n<p>\n	3 select Contact View Mode as Contac Cards </p>\n<p>\n	<img alt="" height="172" src="/cubi/files/upload/helptips/Collaboration/contacts/5.png" width="193" /></p>\n<p>\n	4 then all the contacts will arrange as Contact Cards mode</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/6.png" /></p>\n<p>\n	5 select Group by Company</p>\n<p>\n	<img alt="" height="167" src="/cubi/files/upload/helptips/Collaboration/contacts/7.png" width="192" /></p>\n<p>\n	6 all the contacts will arrange by company mode</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/8.png" /></p>\n', 1, '2011-12-28 02:11:24', 1, '2011-12-28 02:36:27'),
(33, 20, 'How to add new type of contact', '<p>\n	User can add new type of contact according to their practical need, here is an example of add new type of contact</p>\n', 10, '<p>\n	1 click &quot;Contact Type&quot; function under contacts module</p>\n<p>\n	<img alt="" height="109" src="/cubi/files/upload/helptips/Collaboration/contacts/9.png" width="189" /></p>\n<p>\n	2 click add button to create an new type of contact</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/10.png" /></p>\n<p>\n	3 input new type of contact name and description and&nbsp; represented color and for public and save it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/11.png" /></p>\n<p>\n	4 then the new type of contact have been created now</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/contacts/12.png" /></p>\n', 1, '2011-12-28 03:01:18', 1, '2011-12-28 03:06:00'),
(34, 21, 'What is message for?', '<p>\n	Collaboration Message module is designed for send realtime message.</p>\n', 10, NULL, 1, '2011-12-28 18:59:22', 1, '2011-12-28 18:59:22'),
(35, 21, 'How to send a message', '<p>\n	Here is an example of how to send a message</p>\n', 10, '<p>\n	1 Click &quot;Compose Message&quot; function under</p>\n<p>\n	<img alt="" height="146" src="/cubi/files/upload/helptips/Collaboration/message/1.png" width="191" /></p>\n<p>\n	2 select contact who you want to send and forward the message from contacts list</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/message/2.png" /></p>\n<p>\n	3 add attachment for the message</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/message/3.png" /></p>\n<p>\n	4 input message details and send</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/message/4.png" /></p>\n<p>\n	5 then the send message will be saved in your &quot;sent Message&quot; </p>\n<p>\n	<img alt="" height="310" src="/cubi/files/upload/helptips/Collaboration/message/5.png" width="737" /></p>\n', 1, '2011-12-28 20:42:31', 1, '2011-12-28 20:51:12'),
(36, 21, 'Message type', '<p>\n	User can set up new type of message as they needed.</p>\n', 10, '<p>\n	1 Click &quot;Message Type&quot; function under Message module</p>\n<p>\n	<img alt="" height="147" src="/cubi/files/upload/helptips/Collaboration/message/6.png" width="189" /></p>\n<p>\n	&nbsp;</p>\n<p>\n	2 add or edit the message type as they needed</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/message/7.png" /></p>\n', 1, '2011-12-28 21:13:38', 1, '2011-12-28 21:13:38'),
(37, 22, 'What is Calendar for?', '<p>\n	Calendar module provide user an regular event setting manage platform with is user can set some meeting or appointment every week or month or one of specific tiem.</p>\n', 10, NULL, 1, '2011-12-28 22:32:08', 1, '2011-12-28 22:32:08'),
(38, 22, 'How to create an calendar?', '<p>\n	Here is an example of creating an calendar.</p>\n', 10, '<p>\n	1 Click &quot;Event Manage&quot; function under Calendar module</p>\n<p>\n	<img alt="" height="78" src="/cubi/files/upload/helptips/Collaboration/calendar/1.png" width="192" /></p>\n<p>\n	2 click add button to create an new meeting </p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/2.png" /></p>\n<p>\n	3 input the new meeting information like meeting detail and location and so on then quick finish or click next go to step 5</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/3.png" /></p>\n<p>\n	4 this calendar also can be set as regular meeting at every weekly or month or year</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/4.png" /></p>\n<p>\n	5 when you click next you can select which user you want to invite to the meeting from contacts or add an new contacts in it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/5.png" /></p>\n', 1, '2011-12-28 22:44:42', 1, '2011-12-28 22:52:11'),
(39, 22, 'How to add new type of event?', '<p>\n	User can create new type of event as their needed.</p>\n', 10, '<p>\n	1 click &quot;Event Type&quot; function under Calendar</p>\n<p>\n	<img alt="" height="71" src="/cubi/files/upload/helptips/Collaboration/calendar/6.png" width="169" /></p>\n<p>\n	2 click add button to add an new type of calendar</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/7.png" /></p>\n<p>\n	3 input the new calendar details like meeting name and save it</p>\n<p>\n	<img alt="" height="462" src="/cubi/files/upload/helptips/Collaboration/calendar/8.png" width="657" /></p>\n<p>\n	4 back to &quot;Event Type Manage&quot; view that you can see the new calendar you just created now</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/9.png" /></p>\n', 1, '2011-12-28 23:38:37', 1, '2011-12-29 00:00:35'),
(40, 23, 'What is Task module for?', '<p>\n	Task module is designed for report or check user&#39;s work progress.</p>\n', 10, NULL, 1, '2011-12-29 01:26:57', 1, '2011-12-29 01:26:57'),
(41, 23, 'How to use Task module', '<p>\n	Here is an example of using Task module.</p>\n', 10, '<p>\n	1 click &quot;Task Manage&quot; function under Task module</p>\n<p>\n	<img alt="" height="70" src="/cubi/files/upload/helptips/Collaboration/task/1.png" width="177" /></p>\n<p>\n	2 click add button to create an new task</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/2.png" /></p>\n<p>\n	3 input the task detail like task title, description and set up the task laste time like one month from now and quick finish or click next to add more detail</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/3.png" /></p>\n<p>\n	4 add the user who involve in this task from contacts list or add new user into the task</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/4.png" /></p>\n<p>\n	5 click share icon to set the access or update authority for the task<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/5.png" /></p>\n<p>\n	6 set the tast share in Project A group</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/6.png" /></p>\n<p>\n	7 when you have finish a part of the task you can update the task by click update button </p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/7.png" /></p>\n<p>\n	8 update the task progress to 15%</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/8.png" /></p>\n<p>\n	9 then the task have been update into 15% now</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/9.png" /></p>\n', 1, '2011-12-29 01:35:35', 1, '2011-12-29 01:48:58'),
(42, 23, 'How to add an new Type of Task?', '<p>\n	Here is an example of how to add new type of task.</p>\n', 10, '<p>\n	User can customize their own task type</p>\n<p>\n	1 click &quot;Task Type&quot; function under Task module</p>\n<p>\n	<img alt="" height="78" src="/cubi/files/upload/helptips/Collaboration/task/10.png" width="192" /></p>\n<p>\n	2 click add button to create new type of task</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/task/11.png" /></p>\n<p>\n	3 input the description for the new task type and save it</p>\n<p>\n	<img alt="" height="524" src="/cubi/files/upload/helptips/Collaboration/task/12.png" width="729" /></p>\n<p>\n	4 then the new type of task have been created now</p>\n<p>\n	<img alt="" height="41" src="/cubi/files/upload/helptips/Collaboration/task/13.png" width="715" /></p>\n', 1, '2011-12-29 02:38:42', 1, '2011-12-29 02:45:25'),
(43, 24, 'What is work log for?', '<p>\n	Work log is used for save task progress work log that can be used as a daily work report.</p>\n', 10, NULL, 1, '2011-12-29 03:36:40', 1, '2011-12-29 03:36:40'),
(44, 24, 'How to use work log to record daily report', '<p>\n	Here is an example of how to use work log to record daily work report.</p>\n', 10, '<p>\n	1 click &quot;Work Log Manage&quot; function under Work Log module</p>\n<p>\n	<img alt="" height="58" src="/cubi/files/upload/helptips/Collaboration/work_log/1.png" width="192" /></p>\n<p>\n	2 click add button to add an new work log</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/work_log/2.png" /></p>\n<p>\n	3 select which task you have worked on today and how many hours working on it and save it</p>\n<p>\n	<img alt="" height="528" src="/cubi/files/upload/helptips/Collaboration/work_log/3.png" width="742" /></p>\n<p>\n	4 add another work log for different task in today&#39;s work log and save it</p>\n<p>\n	<img alt="" height="436" src="/cubi/files/upload/helptips/Collaboration/work_log/4.png" width="734" /></p>\n<p>\n	5 then we can see today&#39;s two work logs about how i spent 8 working hours working at</p>\n<p>\n	<img alt="" height="252" src="/cubi/files/upload/helptips/Collaboration/work_log/5.png" width="734" /></p>\n', 1, '2011-12-29 03:53:14', 1, '2011-12-29 04:03:02'),
(45, 25, 'What is Note for?', '<p>\n	Note is a temporary or not important record save tool for convenience user&#39;s work without using real paper. Here is an simple example of it.</p>\n', 10, '<p>\n	1 click &quot;Note Type&quot; function under Note module</p>\n<p>\n	<img alt="" height="79" src="/cubi/files/upload/helptips/Collaboration/note/1.png" width="188" /></p>\n<p>\n	2 input content of the note and save it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/note/2.png" /></p>\n<p>\n	3 then you can see the note have been create in Note Management panel</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/note/3.png" /></p>\n', 1, '2011-12-29 19:08:43', 1, '2011-12-29 19:15:18'),
(46, 26, 'What is Announcement for?', '<p>\n	Announcement module is designed for publish some important notification to the all user like whole company user or specific group user like HR department.</p>\n', 10, '<p>\n	Usually the Collaboration there is two type of user. 1 system administrator or department manager who can publish announcement 2 common user who just can see the announcement</p>\n<p>\n	1 administrator log in can see &quot;Announcement Manage&quot; function</p>\n<p>\n	<img alt="" height="100" src="/cubi/files/upload/helptips/Collaboration/announcement/1.png" width="195" /></p>\n<p>\n	2 common user just can see &quot;View Announcement&quot; function</p>\n<p>\n	<img alt="" height="54" src="/cubi/files/upload/helptips/Collaboration/announcement/8.png" width="191" /></p>\n', 1, '2011-12-29 20:23:15', 1, '2011-12-29 20:29:36'),
(47, 26, 'How to create an announcement', '<p>\n	Here is an example of how to create an announcement.</p>\n', 10, '<p>\n	1 click &quot;Announcement Manage&quot; function user Announcement module</p>\n<p>\n	<img alt="" height="100" src="/cubi/files/upload/helptips/Collaboration/announcement/1.png" width="195" /></p>\n<p>\n	2 click add button to create an new announcemtn</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/announcement/2.png" /></p>\n<p>\n	3 input the new announcement title and content and save it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/announcement/3.png" /></p>\n<p>\n	4 because usually we do not suggest user publish the announcement as soon as it be created for this announcement can be created before it is need to be publish.</p>\n<p>\n	&nbsp;&nbsp; so when user want to publish the announcement they can click publish icon to publish it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/announcement/4.png" /></p>\n<p>\n	5 defualt announcement setting is pending </p>\n<p>\n	&nbsp;&nbsp; select published to send the announcement</p>\n<p>\n	<img alt="" height="354" src="/cubi/files/upload/helptips/Collaboration/announcement/5.png" width="655" /></p>\n<p>\n	6 the announcement can be sent to certain group like: only HR department or project A group</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/announcement/6.png" /></p>\n<p>\n	7 if you want all the user see the announcement just select : Global Group to send the announcement and click ok</p>\n<p>\n	<img alt="" height="378" src="/cubi/files/upload/helptips/Collaboration/announcement/7.png" width="650" /></p>\n', 1, '2011-12-29 20:38:16', 1, '2011-12-29 21:07:50'),
(48, 27, 'Why user need Document Management module?', '<p>\n	Document module is designed for let all the user&#39;s document can have a central storage and manage and archive that will make document share and check much easily and efficient.</p>\n', 10, NULL, 1, '2011-12-29 21:17:12', 1, '2011-12-29 21:17:12'),
(49, 27, 'How to use Document module and share it with others?', '<p>\n	Here is a example of how to create an new document and share it with others.</p>\n', 10, '<p>\n	1 click &quot;Document Manage&quot; function under Document module</p>\n<p>\n	<img alt="" height="79" src="/cubi/files/upload/helptips/Collaboration/document/1.png" width="194" /></p>\n<p>\n	2 click add button to create an new document</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/document/2.png" /></p>\n<p>\n	3 input the content of the new document and save it</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/document/3.png" /></p>\n<p>\n	4 click share icon to set up which group you want to share the document with</p>\n<p>\n	<img alt="" height="397" src="/cubi/files/upload/helptips/Collaboration/document/4(1).png" width="716" /></p>\n<p>\n	5 select the group you want they share the document and click ok</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/document/5.png" /></p>\n', 1, '2011-12-29 21:31:08', 1, '2011-12-29 21:35:04'),
(50, 28, 'What is Bookmark module for?', '<p>\n	Bookmark module is designed for convenient to share some webiste link with group member.</p>\n', 10, '<p>\n	1 click &quot;Bookmark Manage&quot; function under Bookmark module</p>\n<p>\n	<img alt="" height="89" src="/cubi/files/upload/helptips/Collaboration/bookmark/1.png" width="191" /></p>\n<p>\n	2 input the link that you want to share with your group member and save it</p>\n<p>\n	<img alt="" height="522" src="/cubi/files/upload/helptips/Collaboration/bookmark/2.png" width="688" /></p>\n', 1, '2011-12-29 23:24:22', 1, '2011-12-29 23:24:22'),
(51, 23, 'Check task progress with Gant View.', '<p>\n	For more clearly see the task progress user can use Gant View to check all task progress.</p>\n', 10, '<p>\n	1 click &quot;Task Gant View&quot; function under Task module to see all the task progress</p>\n<p>\n	<img alt="" height="455" src="/cubi/files/upload/helptips/Collaboration/task/14.png" width="206" /></p>\n<p>\n	2 from this Gant View user can clearly see every task progress and when it is started and when it will be end</p>\n<p>\n	<img alt="" height="445" src="/cubi/files/upload/helptips/Collaboration/task/15.png" width="721" /></p>\n', 1, '2011-12-29 23:48:02', 1, '2011-12-29 23:48:02'),
(52, 22, 'Calendar view', '<p>\n	For more fit for human common sense we have designed an common Calendar view for Calendar module.</p>\n', 10, '<p>\n	1 click &quot;Calendar View&quot; function under Calendar module</p>\n<p>\n	<img alt="" height="451" src="/cubi/files/upload/helptips/Collaboration/calendar/10.png" width="190" /></p>\n<p>\n	2 then all the Calendar like meeting records have been displayed as Calendar view now</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/Collaboration/calendar/11.png" /></p>\n', 1, '2011-12-30 00:00:07', 1, '2011-12-30 00:00:07'),
(53, 19, 'How to start use Collaboration?', '<p>\n	There are 8 areas in Collaboration that have been tightly arranged in the platform.</p>\n', 10, '<p>\n	1&nbsp; the navigation and Help center are arranged in the left panel of&nbsp; platform</p>\n<p>\n	<img alt="" height="387" src="/cubi/files/upload/helptips/Collaboration/1.png" width="186" /></p>\n<p>\n	2&nbsp; all the core modules have been displayed in the right panel&nbsp; of platform</p>\n<p>\n	&nbsp; &nbsp; that will display company announcement and the latest three Tasks and two work logs; six latest messages; six latest calendar; four contacts; six documents and three Bookmarks and notes</p>\n<p>\n	<img alt="" height="527" src="/cubi/files/upload/helptips/Collaboration/2.png" width="864" /></p>\n', 1, '2012-01-01 23:49:15', 1, '2012-01-02 01:25:46'),
(54, 19, 'What is Collaboration?', '<p>\n	Collaboration is an platform of office automation that include of 9 modules like contacts manage; message; task manage and so on.</p>\n', 10, NULL, 1, '2012-01-02 01:30:44', 1, '2012-01-02 01:31:40'),
(18, 12, 'How to Backup your Cubi system?', '<p>\n	In case user make some wrong operations we can backup Cubi system so that user can reverse Cubi system to the state of backup</p>\n', 10, '<p>\n	1 Click backup module--&gt;Manage Backup in left navigation bar</p>\n<p>\n	<img alt="" height="82" src="/cubi/files/upload/helptips/backup/1.png" width="193" /></p>\n<p>\n	&nbsp;</p>\n<p>\n	2 Click Backup button to set up a backup&nbsp;</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/backup/2.png" /></p>\n<p>\n	3 Input the backup file name and select backup database or entire Cubi system and select a timestamp for it.</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/backup/3.png" /></p>\n<p>\n	4 when you save your backup you could download it into your local device like portable hard disk then copy it into the other computer.</p>\n<p>\n	<img alt="" src="/cubi/files/upload/helptips/backup/4.png" /></p>\n', 1, '2011-12-25 19:24:22', 1, '2011-12-25 20:42:59');

-- --------------------------------------------------------

--
--

DROP TABLE IF EXISTS `help_category`;
CREATE TABLE IF NOT EXISTS `help_category` (
  `id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) default '0',
  `name` varchar(255) NOT NULL,
  `url_match` varchar(255) default NULL,
  `description` text,
  `sort_order` int(11) NOT NULL default '10',
  `create_by` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(11) NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
--

INSERT INTO `help_category` (`id`, `parent_id`, `name`, `url_match`, `description`, `sort_order`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES
(1, 7, 'User Management', '/system/user_list.*', '<p>\n	About how to manage users and system access.</p>\n', 5, 1, '2010-04-19 18:15:18', 1, '2011-12-16 16:04:43'),
(2, 7, 'Role Management', '/system/role_list.*', '<p>\n	About how to manage system role and permissions group.</p>\n', 20, 1, '2010-04-19 19:50:23', 1, '2010-04-21 08:10:48'),
(3, 7, 'Module Management', '/system/module_list.*', '<p>\n	About how to mount a module into Cubi system.</p>\n', 30, 1, '2010-04-21 03:35:11', 1, '2010-04-21 05:11:09'),
(4, 7, 'Event Log Management', '/eventlog.*', '<p>\r\n	About system event log</p>\r\n', 40, 1, '2010-04-21 05:01:44', 1, '2011-12-27 08:52:27'),
(5, 7, 'Email Management', '/email/email_.*', '<p>\n	About how to manage system email function</p>\n', 50, 1, '2010-04-21 05:03:43', 1, '2010-05-01 13:19:08'),
(6, 7, 'Help Management', '/help/help_.*', '<p>\r\n	About how to manage the online help module of cubi system.</p>\r\n', 60, 1, '2010-04-21 05:09:50', 1, '2010-04-24 05:16:02'),
(7, 0, 'Openbiz Cubi System', '', '<p>\n	Cubi system help content.</p>\n', 10, 1, '2010-04-21 05:10:29', 1, '2011-12-25 23:39:14'),
(8, 7, 'Theme Management', '/theme/manage_theme', NULL, 60, 1, '2011-12-15 19:14:01', 1, '2011-12-15 19:14:29'),
(10, 7, 'Cronjob', '/cronjob/cronjob_list.*', NULL, 30, 1, '2011-12-16 15:50:00', 1, '2011-12-16 16:05:11'),
(11, 7, 'Preference setting', '/system/user_preference.*', NULL, 5, 1, '2011-12-16 16:04:20', 1, '2011-12-16 16:04:38'),
(12, 7, 'Backup Management', '/backup.*', '<p>\n	Backup or downlaod your Cubi system data.</p>\n', 10, 1, '2011-12-25 18:11:21', 1, '2011-12-25 20:57:35'),
(14, 7, 'Group', '/system/group_.*', '<p>\n	About split user into different groups</p>\n', 10, 1, '2011-12-25 23:20:59', 1, '2011-12-26 01:11:11'),
(15, 7, 'System', '/system/database_list.*', '<p>\n	Setting database connection</p>\n', 10, 1, '2011-12-26 02:18:37', 1, '2011-12-26 02:19:46'),
(16, 7, 'Cache', '/cache/manage.*', '<p>\n	About Cubi Platform cache management.</p>\n', 10, 1, '2011-12-27 02:46:02', 1, '2011-12-27 02:46:02'),
(17, 7, 'Security', '/security/security_rule.*', '<p>\r\n	About internal and external internet access authorication </p>\r\n', 10, 1, '2011-12-27 06:05:15', 1, '2011-12-27 06:05:15'),
(18, 7, 'Translation', '/translation.*', '<p>\r\n	About Cubi platform language setting</p>\r\n', 10, 1, '2011-12-27 08:04:04', 1, '2011-12-27 08:04:04'),
(19, 0, 'Collaboration', '/collab/dashboard', '<p>\n	Collaboration help content.</p>\n', 10, 1, '2011-12-28 00:43:36', 1, '2012-01-01 23:39:59'),
(20, 19, 'Contact Manage', '/collab/contact_.*', '<p>\n	About Contact Management.</p>\n', 10, 1, '2011-12-28 00:49:11', 1, '2011-12-28 00:49:11'),
(21, 19, 'Message', '/collab/message_.*', '<p>\n	About internal message module.</p>\n', 10, 1, '2011-12-28 03:36:03', 1, '2011-12-28 03:36:03'),
(22, 19, 'Calendar', '/collab/event_.*', '<p>\n	About Collaboration Calendar management</p>\n', 10, 1, '2011-12-28 03:37:36', 1, '2011-12-28 03:37:36'),
(23, 19, 'Task', '/collab/task_.*', '<p>\n	About Collaboration Task management</p>\n', 10, 1, '2011-12-28 03:38:35', 1, '2011-12-28 03:38:35'),
(24, 19, 'Work Log', '/collab/worklog_.*', '<p>\n	About Collaboration Work Log management</p>\n', 10, 1, '2011-12-28 03:39:34', 1, '2011-12-28 03:39:34'),
(25, 19, 'Note', '/collab/note_.*', '<p>\n	About Collaboration Note management</p>\n', 10, 1, '2011-12-28 03:41:18', 1, '2011-12-28 03:41:18'),
(26, 19, 'Announcement', '/collab/announcement_.*', '<p>\n	About Collaboration Announcement management</p>\n', 10, 1, '2011-12-28 03:43:01', 1, '2011-12-28 03:43:01'),
(27, 19, 'Document', '/collab/document_.*', '<p>\n	About Collaboration Document management</p>\n', 10, 1, '2011-12-28 03:45:05', 1, '2011-12-28 03:45:05'),
(28, 19, 'Bookmark', '/collab/bookmark_.*', '<p>\n	About Collaboration Bookmark management</p>\n', 10, 1, '2011-12-28 03:46:10', 1, '2011-12-28 03:46:31');


CREATE TABLE IF NOT EXISTS `help_category_mapping` (
  `id` int(11) NOT NULL auto_increment,
  `url` varchar(255) NOT NULL,
  `cat_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `url` (`url`),
  KEY `cat_id` (`cat_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `help_tutorial`;
CREATE TABLE IF NOT EXISTS `help_tutorial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url_match` varchar(255) NOT NULL,
  `type` enum('url','content') NOT NULL,
  `content_url` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `create_by` int(1) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(1) NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `url_match` (`url_match`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;



INSERT INTO `help_tutorial` (`id`, `url_match`, `type`, `content_url`, `subject`, `content`, `width`, `height`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES
(2, '/system/general_default', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-welcome.php', 'cubi初次登陆', '', 550, 330, 1, '2012-10-27 16:17:32', 1, '2012-10-29 20:27:28'),
(3, '/system/group_list', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-group.php', '用户部门设置', '', 550, 280, 1, '2012-10-27 16:27:31', 1, '2012-10-27 16:30:19'),
(4, '/system/group_data_sharing', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-share.php', '部门共享设置', '', 500, 280, 1, '2012-10-27 16:36:57', 1, '2012-10-27 16:37:41'),
(5, '/system/user_list', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-user.php', '用户设置', '', 550, 260, 1, '2012-10-29 18:45:17', 1, '2012-10-29 18:54:00'),
(6, '/system/user_preference', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-system.php', '系统偏好设置', '', 550, 280, 1, '2012-10-29 19:21:49', 1, '2012-10-29 19:21:49'),
(7, '/system/module_list', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-module.php', '模块管理', '', 500, 240, 1, '2012-10-29 19:34:35', 1, '2012-10-29 19:38:58'),
(8, '/backup/backup_list', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-backup.php', '备份数据', '', 550, 260, 1, '2012-10-29 19:46:25', 1, '2012-10-29 19:46:25'),
(9, '/email/email_setting_list', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-email.php', '系统邮件账户', '', 550, 300, 1, '2012-10-29 19:53:13', 1, '2012-10-29 19:53:13'),
(10, '/mystore/profile', 'url', 'http://www.openbiz.cn/enterprise/store/tutorial/store-profile.php', '个人档案管理', '', 550, 300, 1, '2012-10-30 18:40:18', 1, '2012-10-30 18:42:48');

INSERT INTO `help_tutorial` (`url_match`, `type`, `content_url`, `subject`, `content`, `width`, `height`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES
('/myaccount/reset_password/force', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-firstlogin-passwd.php', '初次登陆密码重置', '', 550, 280, 1, '2013-01-07 19:12:07', 1, '2013-01-07 19:15:21'),
('/myaccount/my_profile/force', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-firstlogin-profile.php', '初次登陆完善资料', '', 550, 280, 1, '2013-01-07 19:13:39', 1, '2013-01-07 19:13:39'),
('/contact/contact_detail/.*', 'url', 'http://www.openbiz.cn/developer/cubi/tutorial/cubi-user-profile.php', '完善联系人资料', '', 550, 280, 1, '2013-01-10 12:47:54', 1, '2013-01-10 12:52:00');

DROP TABLE IF EXISTS `help_tutorial_user`;
CREATE TABLE IF NOT EXISTS `help_tutorial_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tutorial_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `autoshow` int(11) NOT NULL,
  `create_by` int(1) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_by` int(1) NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tutorial_id` (`tutorial_id`,`user_id`),
  KEY `tutorial_id_2` (`tutorial_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;