
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_ocs236`
--

-- --------------------------------------------------------

--
-- Table structure for table `access_keys`
--

CREATE TABLE `access_keys` (
  `access_key_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context` varchar(40) NOT NULL,
  `key_hash` varchar(40) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `expiry_date` datetime NOT NULL,
  PRIMARY KEY (`access_key_id`),
  KEY `access_keys_hash` (`key_hash`,`user_id`,`context`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcements`
--

CREATE TABLE `announcements` (
  `announcement_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` smallint(6) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `type_id` bigint(20) DEFAULT NULL,
  `date_expire` datetime DEFAULT NULL,
  `date_posted` datetime NOT NULL,
  PRIMARY KEY (`announcement_id`),
  KEY `announcements_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_settings`
--

CREATE TABLE `announcement_settings` (
  `announcement_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `announcement_settings_pkey` (`announcement_id`,`locale`,`setting_name`),
  KEY `announcement_settings_announcement_id` (`announcement_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_types`
--

CREATE TABLE `announcement_types` (
  `type_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` smallint(6) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  PRIMARY KEY (`type_id`),
  KEY `announcement_types_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_type_settings`
--

CREATE TABLE `announcement_type_settings` (
  `type_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `announcement_type_settings_pkey` (`type_id`,`locale`,`setting_name`),
  KEY `announcement_type_settings_type_id` (`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `auth_sources`
--

CREATE TABLE `auth_sources` (
  `auth_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(60) NOT NULL,
  `plugin` varchar(32) NOT NULL,
  `auth_default` tinyint(4) NOT NULL DEFAULT '0',
  `settings` text,
  PRIMARY KEY (`auth_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `buildings`
--

CREATE TABLE `buildings` (
  `building_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sched_conf_id` bigint(20) NOT NULL,
  PRIMARY KEY (`building_id`),
  KEY `building_sched_conf_id` (`sched_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `building_settings`
--

CREATE TABLE `building_settings` (
  `building_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `building_settings_pkey` (`building_id`,`locale`,`setting_name`),
  KEY `building_settings_building_id` (`building_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `captchas`
--

CREATE TABLE `captchas` (
  `captcha_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `session_id` varchar(40) NOT NULL,
  `value` varchar(20) NOT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`captcha_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `comments`
--

CREATE TABLE `comments` (
  `comment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paper_id` bigint(20) NOT NULL,
  `parent_comment_id` bigint(20) DEFAULT NULL,
  `num_children` int(11) NOT NULL DEFAULT '0',
  `user_id` bigint(20) DEFAULT NULL,
  `poster_ip` varchar(15) NOT NULL,
  `poster_name` varchar(90) DEFAULT NULL,
  `poster_email` varchar(90) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `body` text,
  `date_posted` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `comments_paper_id` (`paper_id`),
  KEY `comments_parent_comment_id` (`parent_comment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `conferences`
--

CREATE TABLE `conferences` (
  `conference_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` varchar(32) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `primary_locale` varchar(5) NOT NULL,
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`conference_id`),
  UNIQUE KEY `conferences_path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `conference_event_log`
--

CREATE TABLE `conference_event_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sched_conf_id` bigint(20) DEFAULT NULL,
  `conference_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `date_logged` datetime NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `log_level` varchar(1) DEFAULT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `assoc_type` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `is_translated` tinyint(4) DEFAULT NULL,
  `entry_params` text,
  `message` text,
  PRIMARY KEY (`log_id`),
  KEY `conference_event_log_sched_conf_id` (`sched_conf_id`),
  KEY `conference_event_log_conference_id` (`conference_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `conference_settings`
--

CREATE TABLE `conference_settings` (
  `conference_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `conference_settings_pkey` (`conference_id`,`locale`,`setting_name`),
  KEY `conference_settings_conference_id` (`conference_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocabs`
--

CREATE TABLE `controlled_vocabs` (
  `controlled_vocab_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `symbolic` varchar(32) NOT NULL,
  `assoc_type` bigint(20) NOT NULL DEFAULT '0',
  `assoc_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`controlled_vocab_id`),
  UNIQUE KEY `controlled_vocab_symbolic` (`symbolic`,`assoc_type`,`assoc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocab_entries`
--

CREATE TABLE `controlled_vocab_entries` (
  `controlled_vocab_entry_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `controlled_vocab_id` bigint(20) NOT NULL,
  `seq` double DEFAULT NULL,
  PRIMARY KEY (`controlled_vocab_entry_id`),
  KEY `controlled_vocab_entries_cv_id` (`controlled_vocab_id`,`seq`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocab_entry_settings`
--

CREATE TABLE `controlled_vocab_entry_settings` (
  `controlled_vocab_entry_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `c_v_e_s_pkey` (`controlled_vocab_entry_id`,`locale`,`setting_name`),
  KEY `c_v_e_s_entry_id` (`controlled_vocab_entry_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `custom_track_orders`
--

CREATE TABLE `custom_track_orders` (
  `sched_conf_id` bigint(20) NOT NULL,
  `track_id` bigint(20) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  KEY `custom_track_orders_pkey` (`sched_conf_id`,`track_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `edit_assignments`
--

CREATE TABLE `edit_assignments` (
  `edit_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paper_id` bigint(20) NOT NULL,
  `director_id` bigint(20) NOT NULL,
  `date_assigned` datetime DEFAULT NULL,
  `date_notified` datetime DEFAULT NULL,
  `date_underway` datetime DEFAULT NULL,
  PRIMARY KEY (`edit_id`),
  KEY `edit_assignments_paper_id` (`paper_id`),
  KEY `edit_assignments_director_id` (`director_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `edit_decisions`
--

CREATE TABLE `edit_decisions` (
  `edit_decision_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paper_id` bigint(20) NOT NULL,
  `stage` tinyint(4) NOT NULL,
  `director_id` bigint(20) NOT NULL,
  `decision` tinyint(4) NOT NULL,
  `date_decided` datetime NOT NULL,
  PRIMARY KEY (`edit_decision_id`),
  KEY `edit_decisions_paper_id` (`paper_id`),
  KEY `edit_decisions_director_id` (`director_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates`
--

CREATE TABLE `email_templates` (
  `email_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_key` varchar(64) NOT NULL,
  `assoc_type` bigint(20) DEFAULT '0',
  `assoc_id` bigint(20) DEFAULT '0',
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`email_id`),
  UNIQUE KEY `email_templates_email_key` (`email_key`,`assoc_type`,`assoc_id`),
  KEY `email_templates_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_data`
--

CREATE TABLE `email_templates_data` (
  `email_key` varchar(64) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT 'en_US',
  `assoc_type` bigint(20) DEFAULT '0',
  `assoc_id` bigint(20) DEFAULT '0',
  `subject` varchar(120) NOT NULL,
  `body` text,
  UNIQUE KEY `email_templates_data_pkey` (`email_key`,`locale`,`assoc_type`,`assoc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_default`
--

CREATE TABLE `email_templates_default` (
  `email_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_key` varchar(30) NOT NULL,
  `can_disable` tinyint(4) NOT NULL DEFAULT '1',
  `can_edit` tinyint(4) NOT NULL DEFAULT '1',
  `from_role_id` bigint(20) DEFAULT NULL,
  `to_role_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`email_id`),
  KEY `email_templates_default_email_key` (`email_key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=38 ;

--
-- Dumping data for table `email_templates_default`
--

INSERT INTO `email_templates_default` VALUES
(1, 'NOTIFICATION', 0, 1, NULL, NULL),
(2, 'NOTIFICATION_MAILLIST', 0, 1, NULL, NULL),
(3, 'NOTIFICATION_MAILLIST_WELCOME', 0, 1, NULL, NULL),
(4, 'NOTIFICATION_MAILLIST_PASSWORD', 0, 1, NULL, NULL),
(5, 'PASSWORD_RESET_CONFIRM', 0, 1, NULL, NULL),
(6, 'PASSWORD_RESET', 0, 1, NULL, NULL),
(7, 'USER_REGISTER', 0, 1, NULL, NULL),
(8, 'USER_VALIDATE', 0, 1, NULL, NULL),
(9, 'SUBMISSION_ACK', 1, 1, NULL, 4096),
(10, 'SUBMISSION_UPLOAD_ACK', 1, 1, NULL, 4096),
(11, 'SUBMISSION_UNSUITABLE', 1, 1, 128, 4096),
(12, 'SUBMISSION_COMMENT', 0, 1, NULL, NULL),
(13, 'SUBMISSION_DECISION_REVIEWERS', 0, 1, 128, 256),
(14, 'DIRECTOR_ASSIGN', 1, 1, 64, 128),
(15, 'REVIEW_CANCEL', 1, 1, 128, 256),
(16, 'REVIEW_REQUEST', 1, 1, 128, 256),
(17, 'REVIEW_REQUEST_ONECLICK', 1, 1, 128, 256),
(18, 'REVIEW_CONFIRM', 1, 1, 256, 128),
(19, 'REVIEW_CONFIRM_ACK', 1, 1, 128, 256),
(20, 'REVIEW_DECLINE', 1, 1, 256, 128),
(21, 'REVIEW_COMPLETE', 1, 1, 256, 128),
(22, 'REVIEW_ACK', 1, 1, 128, 256),
(23, 'REVIEW_REMIND', 0, 1, 128, 256),
(24, 'REVIEW_REMIND_AUTO', 0, 1, NULL, 256),
(25, 'REVIEW_REMIND_ONECLICK', 0, 1, 128, 256),
(26, 'REVIEW_REMIND_AUTO_ONECLICK', 0, 1, NULL, 256),
(27, 'SUBMISSION_ABSTRACT_ACCEPT', 0, 1, 128, 4096),
(28, 'SUBMISSION_ABSTRACT_DECLINE', 0, 1, 128, 4096),
(29, 'SUBMISSION_ABSTRACT_REVISE', 0, 1, 128, 4096),
(30, 'SUBMISSION_PAPER_ACCEPT', 0, 1, 128, 4096),
(31, 'SUBMISSION_PAPER_DECLINE', 0, 1, 128, 4096),
(32, 'SUBMISSION_PAPER_REVISE', 0, 1, 128, 4096),
(33, 'SUBMISSION_PAPER_INVITE', 0, 1, 128, 4096),
(34, 'REGISTRATION_NOTIFY', 0, 1, NULL, 32768),
(35, 'MANUAL_PAYMENT_RECEIVED', 0, 1, NULL, NULL),
(36, 'MANUAL_PAYMENT_NOTIFICATION', 0, 1, NULL, NULL),
(37, 'PAYPAL_INVESTIGATE_PAYMENT', 0, 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_default_data`
--

CREATE TABLE `email_templates_default_data` (
  `email_key` varchar(30) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT 'en_US',
  `subject` varchar(120) NOT NULL,
  `body` text,
  `description` text,
  UNIQUE KEY `email_templates_default_data_pkey` (`email_key`,`locale`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `email_templates_default_data`
--

INSERT INTO `email_templates_default_data` VALUES
('NOTIFICATION', 'en_US', 'New notification from {$siteTitle}', 'You have a new notification from {$siteTitle}:\n\n{$notificationContents}\n\nLink: {$url}\n\n{$principalContactSignature}', 'The email is sent to registered users that have selected to have this type of notification emailed to them.'),
('NOTIFICATION_MAILLIST', 'en_US', 'New notification from {$siteTitle}', 'You have a new notification from {$siteTitle}:\n--\n{$notificationContents}\n\nLink: {$url}\n--\n\nIf you wish to stop receiving notification emails, please go to {$unsubscribeLink} and enter your email address and password.\n\n{$principalContactSignature}', 'This email is sent to unregistered users on the notification mailing list.'),
('NOTIFICATION_MAILLIST_WELCOME', 'en_US', 'Welcome to the the {$siteTitle} mailing list!', 'You have signed up to receive notifications from {$siteTitle}.\n			\nPlease click on this link to confirm your request and add your email address to the mailing list: {$confirmLink}\n\nIf you wish to stop receiving notification emails, please go to {$unsubscribeLink} and enter your email address and password.\n\nYour password for disabling notification emails is: {$password}\n\n{$principalContactSignature}', 'This email is sent to an unregistered user who just registered with the notification mailing list.'),
('NOTIFICATION_MAILLIST_PASSWORD', 'en_US', 'Your notification mailing list information for {$siteTitle}', 'Your new password for disabling notification emails is: {$password}\n\nIf you wish to stop receiving notification emails, please go to {$unsubscribeLink} and enter your email address and password.\n\n{$principalContactSignature}', 'This email is sent to an unregistered user on the notification mailing list when they indicate that they have forgotten their password or are unable to login. It provides a URL they can follow to reset their password.'),
('PASSWORD_RESET_CONFIRM', 'en_US', 'Password Reset Confirmation', 'We have received a request to reset your password for the {$siteTitle} web site.\n\nIf you did not make this request, please ignore this email and your password will not be changed. If you wish to reset your password, click on the below URL.\n\nReset my password: {$url}\n\n{$principalContactSignature}', 'This email is sent to a registered user when they indicate that they have forgotten their password or are unable to login. It provides a URL they can follow to reset their password.'),
('PASSWORD_RESET', 'en_US', 'Password Reset', 'Your password has been successfully reset for use with the {$siteTitle} web site. Please retain this username and password, as it is necessary for all work with the conference.\n\nYour username: {$username}\nYour new password: {$password}\n\n{$principalContactSignature}', 'This email is sent to a registered user when they have successfully reset their password following the process described in the PASSWORD_RESET_CONFIRM email.'),
('USER_REGISTER', 'en_US', 'New User Registration', 'Thank you for registering as a user with {$conferenceName}. Please keep track of your username and password, which are needed for all work with this conference.\n\nUsername: {$username}\nPassword: {$password}\n\nThank you,\n{$principalContactSignature}', 'This email is sent to a newly registered user to welcome them to the system and provide them with a record of their username and password.'),
('USER_VALIDATE', 'en_US', 'Validate Your Account', '{$userFullName}\n\nYou have created an account with {$conferenceName}, but before you can start using it, you need to validate your email account. To do this, simply follow the link below:\n\n{$activateUrl}\n\nThank you,\n{$principalContactSignature}', 'This email is sent to a newly created user to welcome them to the system and provide them with a record of their username and password.'),
('SUBMISSION_ACK', 'en_US', 'Submission Acknowledgement', '{$authorName}:\n\nThank you for your submission, "{$paperTitle}" to {$conferenceName}. With the online conference management system that we are using, you will be able to track its progress through the editorial process by logging in to the conference web site:\n\nSubmission URL: {$submissionUrl}\nUsername: {$authorUsername}\n\nIf you have any questions, please contact me. Thank you for considering this conference as a venue for your work.\n\n{$editorialContactSignature}', 'This email, when enabled, is automatically sent to a author when he or she completes the process of submitting a paper or abstract to the conference. It provides information about tracking the submission through the process and thanks the author for the submission.'),
('SUBMISSION_UPLOAD_ACK', 'en_US', 'Submission Upload Acknowledgement', '{$authorName}:\n\nThank you for uploading your presentation, "{$paperTitle}" to {$conferenceName}. With the online conference management system that we are using, you will be able to track its progress through the editorial process by logging in to the conference web site:\n\nSubmission URL: {$submissionUrl}\nUsername: {$authorUsername}\n\nIf you have any questions, please contact me. Thank you for considering this conference as a venue for your work.\n\n{$editorialContactSignature}', 'This email, when enabled, is automatically sent to a author when he or she completes the process of submitting a paper or abstract to the conference. It provides information about tracking the submission through the process and thanks the author for the submission.'),
('SUBMISSION_UNSUITABLE', 'en_US', 'Unsuitable Submission', '{$authorName}:\n\nAn initial review of "{$paperTitle}" has made it clear that this submission does not fit within the scope and focus of {$conferenceName}. I recommend that you consult the description of this conference under About, as well as any previous scheduled conferences, to learn more about the work that we accept. You might also consider submitting this paper or abstract to another, more suitable conference.\n\n{$editorialContactSignature}', ''),
('SUBMISSION_COMMENT', 'en_US', 'Submission Comment', '{$name}:\n\n{$commentName} has added a comment to the submission, "{$paperTitle}" in {$conferenceName}:\n\n{$comments}', 'This email notifies the various people involved in a submission''s editing process that a new comment has been posted.'),
('SUBMISSION_DECISION_REVIEWERS', 'en_US', 'Decision on "{$paperTitle}"', 'As one of the reviewers for the submission, "{$paperTitle}," to {$conferenceName}, I am sending you the reviews and editorial decision sent to the author of this piece. Thank you again for your important contribution to this process.\n \n{$editorialContactSignature}\n\n{$comments}', 'This email notifies the reviewers of a submission that the review process has been completed. It includes information about the paper and the decision reached, and thanks the reviewers for their contributions.'),
('DIRECTOR_ASSIGN', 'en_US', 'Director Assignment', '{$editorialContactName}:\n\nThe submission, "{$paperTitle}," to {$conferenceName} has been assigned to you to see through the editorial process in your role as Track Director.  \n\nSubmission URL: {$submissionUrl}\nUsername: {$directorUsername}\n\nThank you,\n{$editorialContactSignature}', 'This email notifies a Track Director that the Director has assigned them the task of overseeing a submission through the editing process. It provides information about the submission and how to access the conference site.'),
('REVIEW_REQUEST', 'en_US', 'Paper Review Request', '{$reviewerName}:\n\nI believe that you would serve as an excellent reviewer of the proposal, "{$paperTitle}," which has been submitted to {$conferenceName}. The submission''s extract is inserted below, and I hope that you will consider undertaking this important task for us.\n\nPlease log into the conference web site by {$weekLaterDate} to indicate whether you will undertake the review or not, as well as to access the submission and to record your review and recommendation. The web site is {$conferenceUrl}\n\nThe review itself is due {$reviewDueDate}.\n\nIf you do not have your username and password for the conference''s web site, you can use this link to reset your password (which will then be emailed to you along with your username). {$passwordResetUrl}\n\nSubmission URL: {$submissionReviewUrl}\n\nThank you for considering this request.\n\n{$editorialContactSignature}\n\n\n\n"{$paperTitle}"\n\nAbstract\n{$paperAbstract}', 'This email from the Track Director to a Reviewer requests that the reviewer accept or decline the task of reviewing a submission. It provides information about the submission such as the title and abstract, a review due date, and how to access the submission itself.'),
('REVIEW_REQUEST_ONECLICK', 'en_US', 'Paper Review Request', '{$reviewerName}:\n\nI believe that you would serve as an excellent reviewer of the submission, "{$paperTitle}," which has been submitted to {$conferenceName}. The submission''s extract is inserted below, and I hope that you will consider undertaking this important task for us.\n\nPlease log into the conference web site by {$weekLaterDate} to indicate whether you will undertake the review or not, as well as to access the submission and to record your review and recommendation.\n\nThe review itself is due {$reviewDueDate}.\n\nSubmission URL: {$submissionReviewUrl}\n\nThank you for considering this request.\n\n{$editorialContactSignature}\n\n\n\n"{$paperTitle}"\n\nAbstract\n{$paperAbstract}', 'This email from the Track Director to a Reviewer requests that the reviewer accept or decline the task of reviewing a submission. It provides information about the submission such as the title and abstract, a review due date, and how to access the submission itself. This message is used when the Standard Review Process is selected in Conference Setup, Step 2, and one-click reviewer access is enabled.'),
('REVIEW_CANCEL', 'en_US', 'Request for Review Cancelled', '{$reviewerName}:\n\nWe have decided at this point to cancel our request for you to review the submission, "{$paperTitle}," for {$conferenceName}. We apologize for any inconvenience this may cause you and hope that we will be able to call on you to assist with this conference''s review process in the future.\n\nIf you have any questions, please contact me.\n\n{$editorialContactSignature}', 'This email is sent by the Track Director to a Reviewer who has a submission review in progress to notify them that the review has been cancelled.'),
('REVIEW_CONFIRM', 'en_US', 'Able to Review', '{$editorialContactName}:\n\nI am able and willing to review the submission, "{$paperTitle}," for {$conferenceName}. Thank you for thinking of me, and I plan to have the review completed by its due date, {$reviewDueDate}, if not before.\n\n{$reviewerName}', 'This email is sent by a Reviewer to the Track Director in response to a review request to notify the Track Director that the review request has been accepted and will be completed by the specified date.'),
('REVIEW_CONFIRM_ACK', 'en_US', 'Review Underway Acknowledgement', '{$reviewerName}:\n\nThank you for agreeing to review the submission "{$paperTitle}" for {$conferenceName} by {$reviewDueDate}.\n\n{$editorialContactSignature}', 'This email is sent from the Track Director to the Reviewer to acknowledge their acceptance of a review or encourage them to complete the review.'),
('REVIEW_DECLINE', 'en_US', 'Unable to Review', '{$editorialContactName}:\n\nI am afraid that at this time I am unable to review the submission, "{$paperTitle}," for {$conferenceName}. Thank you for thinking of me, and another time feel free to call on me.\n\n{$reviewerName}', 'This email is sent by a Reviewer to the Track Director in response to a review request to notify the Track Director that the review request has been declined.'),
('REVIEW_COMPLETE', 'en_US', 'Paper Review Completed', '{$editorialContactName}:\n\nI have now completed my review of "{$paperTitle}" for {$conferenceName}, and submitted my recommendation, "{$recommendation}."\n\n{$reviewerName}', 'This email is sent by a Reviewer to the Track Director to notify them that a review has been completed and the comments and recommendations have been recorded on the conference web site.'),
('REVIEW_ACK', 'en_US', 'Paper Review Acknowledgement', '{$reviewerName}:\n\nThank you for completing the review of the submission, "{$paperTitle}," for {$conferenceName}. We appreciate your contribution to the quality of the work that we produce.\n\n{$editorialContactSignature}', 'This email is sent by a Track Director to confirm receipt of a completed review and thank the reviewer for their contributions.'),
('REVIEW_REMIND', 'en_US', 'Submission Review Reminder', '{$reviewerName}:\n\nJust a gentle reminder of our request for your review of the submission, "{$paperTitle}," for {$conferenceName}. We were hoping to have this review by {$reviewDueDate}, and would be pleased to receive it as soon as you are able to prepare it.\n\nIf you do not have your username and password for the conference''s web site, you can use this link to reset your password (which will then be emailed to you along with your username). {$passwordResetUrl}\n\nSubmission URL: {$submissionReviewUrl}\n\nPlease confirm your ability to complete this vital contribution to the work of the conference. I look forward to hearing from you.\n\n{$editorialContactSignature}', 'This email is sent by a Track Director to remind a reviewer that their review is due.'),
('REVIEW_REMIND_ONECLICK', 'en_US', 'Submission Review Reminder', '{$reviewerName}:\n\nJust a gentle reminder of our request for your review of the submission, "{$paperTitle}," for {$conferenceName}. We were hoping to have this review by {$reviewDueDate}, and would be pleased to receive it as soon as you are able to prepare it.\n\nSubmission URL: {$submissionReviewUrl}\n\nPlease confirm your ability to complete this vital contribution to the work of the conference. I look forward to hearing from you.\n\n{$editorialContactSignature}', 'This email is sent by a Track Director to remind a reviewer that their review is due.'),
('REVIEW_REMIND_AUTO', 'en_US', 'Automated Submission Review Reminder', '{$reviewerName}:\n\nJust a gentle reminder of our request for your review of the submission, "{$paperTitle}," for {$conferenceName}. We were hoping to have this review by {$reviewDueDate}, and this email has been automatically generated and sent with the passing of that date. We would still be pleased to receive it as soon as you are able to prepare it.\n\nIf you do not have your username and password for the conference''s web site, you can use this link to reset your password (which will then be emailed to you along with your username). {$passwordResetUrl}\n\nSubmission URL: {$submissionReviewUrl}\n\nPlease confirm your ability to complete this vital contribution to the work of the conference. I look forward to hearing from you.\n\n{$editorialContactSignature}', 'This email is automatically sent when a reviewer''s due date elapses (see Review Options under Conference Setup, Step 2) and one-click reviewer access is disabled. Scheduled tasks must be enabled and configured (see the site configuration file).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'en_US', 'Automated Submission Review Reminder', '{$reviewerName}:\n\nJust a gentle reminder of our request for your review of the submission, "{$paperTitle}," for {$conferenceName}. We were hoping to have this review by {$reviewDueDate}, and this email has been automatically generated and sent with the passing of that date. We would still be pleased to receive it as soon as you are able to prepare it.\n\nSubmission URL: {$submissionReviewUrl}\n\nPlease confirm your ability to complete this vital contribution to the work of the conference. I look forward to hearing from you.\n\n{$editorialContactSignature}', 'This email is automatically sent when a reviewer''s due date elapses (see Review Options under Conference Setup, Step 2) and one-click reviewer access is enabled. Scheduled tasks must be enabled and configured (see the site configuration file).'),
('SUBMISSION_ABSTRACT_ACCEPT', 'en_US', 'Editorial Decision on Abstract', '{$authorName}:\n\nCongratulations, your abstract {$paperTitle} has been accepted for presentation at {$conferenceTitle} which is being held {$conferenceDate} at {$locationCity}. \n\nThank you and looking forward to your participation in this event.\n{$editorialContactSignature}', 'This email is sent by a Track Director to a submission''s Author to notify them that a decision has been reached in regard to a submission.'),
('SUBMISSION_ABSTRACT_DECLINE', 'en_US', 'Editorial Decision on Paper', '{$authorName}:\n\nWe have now completed the review of your submission "{$paperTitle}." As a result...\n\n{$editorialContactSignature}', 'This email is sent by a Track Director to a submission''s Author to notify them that a decision has been reached in regard to a submission.'),
('SUBMISSION_ABSTRACT_REVISE', 'en_US', 'Editorial Decision on Paper', '{$authorName}:\n\nAfter a careful review of your submission, "{$paperTitle}" will be considered for presentation at {$conferenceTitle} if the following revisions are successfully implemented.\n\nThank you and looking forward to your participation in this event.\n\n{$editorialContactSignature}', 'This email is sent by a Track Director to a submission''s Author to notify them that a decision has been reached in regard to a submission.'),
('SUBMISSION_PAPER_ACCEPT', 'en_US', 'Editorial Decision on Paper', '{$authorName}:\n\nCongratulations, your submission {$paperTitle} has been accepted for presentation at {$conferenceTitle} which is being held {$conferenceDate} at {$locationCity}. \n\nThank you and looking forward to your participation in this event.\n{$editorialContactSignature}', 'This email is sent by a Track Director to a submission''s Author to notify them that a decision has been reached in regard to a submission.'),
('SUBMISSION_PAPER_DECLINE', 'en_US', 'Editorial Decision on Paper', '{$authorName}:\n\nWe have now completed the review of your submission "{$paperTitle}." As a result...\n\n{$editorialContactSignature}', 'This email is sent by a Track Director to a submission''s Author to notify them that a decision has been reached in regard to a submission.'),
('SUBMISSION_PAPER_REVISE', 'en_US', 'Editorial Decision on Paper', '{$authorName}:\n\nAfter a careful review of your submission, "{$paperTitle}" will be considered for presentation at {$conferenceTitle} if the following revisions are successfully implemented.\n\nThank you and looking forward to your participation in this event.\n\n{$editorialContactSignature}', 'This email is sent by a Track Director to a submission''s Author to notify them that a decision has been reached in regard to a submission.'),
('SUBMISSION_PAPER_INVITE', 'en_US', 'Editorial Decision on Abstract', '{$authorName}:\n\nCongratulations, your abstract {$paperTitle} has been accepted for presentation at {$conferenceTitle} which is being held {$conferenceDate} at {$locationCity}. You may now submit your paper for further review.\n\nThank you and looking forward to your participation in this event.\n{$editorialContactSignature}', 'This email is sent by a Track Director to a submission''s Author to notify them that a decision has been reached in regard to an abstract and invite them to submit a paper for subsequent review.'),
('REGISTRATION_NOTIFY', 'en_US', 'Registration Notification', '{$registrantName}:\n\nYou have now been registered as a registrant in our online conference management system for {$conferenceName}, with the following registration:\n\n{$registrationType}\n\nTo access content that is available only to registrants, simply log in to the system with your username, "{$username}".\n\nOnce you have logged in to the system you can change your profile details and password at any point.\n\nPlease note that if you have an institutional registration, there is no need for users at your institution to log in, since requests for registration content will be automatically authenticated by the system.\n\nIf you have any questions, please feel free to contact me.\n\n{$registrationContactSignature}', 'This email notifies a registered reader that the Manager has created a registration for them. It provides the conference''s URL along with instructions for access.'),
('OPEN_ACCESS_NOTIFY', 'en_US', 'Issue Now Open Access', 'Readers:\n\n{$conferenceName} has just made available in an open access format the following issue. We invite you to review the Table of Contents here and then visit our web site ({$conferenceUrl}) to review papers and items of interest.\n\nThanks for the continuing interest in our work,\n{$editorialContactSignature}', 'This email is sent to registered readers who have requested to receive a notification email when an issue becomes open access.'),
('MANUAL_PAYMENT_RECEIVED', 'en_US', 'Your payment for {$conferenceName} has been received', '{$registrantName}:\n\nYour payment for {$conferenceName} has been received and recorded in your account.\n\nIf you have any questions, please feel free to contact me.\n\n{$registrationContactSignature}', 'This email notifies a registered reader that the Manager has created a registration for them. It provides the conference''s URL along with instructions for access.'),
('MANUAL_PAYMENT_NOTIFICATION', 'en_US', 'Manual Payment Notification', 'A manual payment needs to be processed for the conference {$schedConfName} and the user {$userFullName} (username "{$userName}").\n\nThe item being paid for is "{$itemName}".\nThe cost is {$itemCost} ({$itemCurrencyCode}).\n\nThis email was generated by Open Conference Systems'' Manual Payment plugin.', 'This email template is used to notify a conference''s registration contact that a manual payment was requested.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'en_US', 'Unusual PayPal Activity', 'Open Conference Systems has encountered unusual activity relating to PayPal payment support for the conference {$schedConfName}. This activity may need further investigation or manual intervention.\n			\nThis email was generated by Open Conference Systems'' PayPal plugin.\n\nFull post information for the request:\n{$postInfo}\n\nAdditional information (if supplied):\n{$additionalInfo}\n\nServer vars:\n{$serverVars}\n', 'This email template is used to notify a conference''s primary contact that suspicious activity or activity requiring manual intervention was encountered by the PayPal plugin.');

-- --------------------------------------------------------

--
-- Table structure for table `groups`
--

CREATE TABLE `groups` (
  `group_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` smallint(6) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `context` bigint(20) DEFAULT NULL,
  `about_displayed` tinyint(4) NOT NULL DEFAULT '0',
  `seq` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`group_id`),
  KEY `groups_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group_memberships`
--

CREATE TABLE `group_memberships` (
  `user_id` bigint(20) NOT NULL,
  `group_id` bigint(20) NOT NULL,
  `about_displayed` tinyint(4) NOT NULL DEFAULT '1',
  `seq` double NOT NULL DEFAULT '0',
  UNIQUE KEY `group_memberships_pkey` (`user_id`,`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `group_settings`
--

CREATE TABLE `group_settings` (
  `group_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `group_settings_pkey` (`group_id`,`locale`,`setting_name`),
  KEY `group_settings_group_id` (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `notification_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `level` bigint(20) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_read` datetime DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `contents` text,
  `param` varchar(255) DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `is_localized` tinyint(4) NOT NULL DEFAULT '1',
  `product` varchar(20) DEFAULT NULL,
  `context` bigint(20) NOT NULL,
  `assoc_type` bigint(20) NOT NULL,
  PRIMARY KEY (`notification_id`),
  KEY `notifications_by_user` (`product`,`user_id`,`level`,`context`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notification_settings`
--

CREATE TABLE `notification_settings` (
  `setting_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `setting_name` varchar(64) NOT NULL,
  `setting_value` text,
  `user_id` bigint(20) NOT NULL,
  `product` varchar(20) DEFAULT NULL,
  `context` bigint(20) NOT NULL,
  PRIMARY KEY (`setting_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oai_resumption_tokens`
--

CREATE TABLE `oai_resumption_tokens` (
  `token` varchar(32) NOT NULL,
  `expire` bigint(20) NOT NULL,
  `record_offset` int(11) NOT NULL,
  `params` text,
  UNIQUE KEY `oai_resumption_tokens_pkey` (`token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `papers`
--

CREATE TABLE `papers` (
  `paper_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `sched_conf_id` bigint(20) NOT NULL,
  `track_id` bigint(20) DEFAULT NULL,
  `language` varchar(10) DEFAULT 'en',
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `comments_to_dr` text,
  `citations` text,
  `date_submitted` datetime DEFAULT NULL,
  `date_reminded` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_status_modified` datetime DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `submission_progress` tinyint(4) NOT NULL DEFAULT '1',
  `review_mode` bigint(20) DEFAULT NULL,
  `current_stage` tinyint(4) NOT NULL DEFAULT '1',
  `submission_file_id` bigint(20) DEFAULT NULL,
  `revised_file_id` bigint(20) DEFAULT NULL,
  `review_file_id` bigint(20) DEFAULT NULL,
  `layout_file_id` bigint(20) DEFAULT NULL,
  `director_file_id` bigint(20) DEFAULT NULL,
  `pages` varchar(255) DEFAULT NULL,
  `date_to_presentations` datetime DEFAULT NULL,
  `date_to_archive` datetime DEFAULT NULL,
  `comments_status` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`paper_id`),
  KEY `papers_user_id` (`user_id`),
  KEY `papers_sched_conf_id` (`sched_conf_id`),
  KEY `papers_track_id` (`track_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paper_authors`
--

CREATE TABLE `paper_authors` (
  `author_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paper_id` bigint(20) NOT NULL,
  `primary_contact` tinyint(4) NOT NULL DEFAULT '0',
  `seq` double NOT NULL DEFAULT '0',
  `first_name` varchar(40) NOT NULL,
  `middle_name` varchar(40) DEFAULT NULL,
  `last_name` varchar(90) NOT NULL,
  `affiliation` varchar(255) DEFAULT NULL,
  `country` varchar(90) DEFAULT NULL,
  `email` varchar(90) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`author_id`),
  KEY `paper_authors_paper_id` (`paper_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paper_author_settings`
--

CREATE TABLE `paper_author_settings` (
  `author_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `paper_author_settings_pkey` (`author_id`,`locale`,`setting_name`),
  KEY `author_settings_author_id` (`author_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `paper_comments`
--

CREATE TABLE `paper_comments` (
  `comment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `comment_type` bigint(20) DEFAULT NULL,
  `role_id` bigint(20) NOT NULL,
  `paper_id` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `author_id` bigint(20) NOT NULL,
  `comment_title` varchar(255) NOT NULL,
  `comments` text,
  `date_posted` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `viewable` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `paper_comments_paper_id` (`paper_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paper_email_log`
--

CREATE TABLE `paper_email_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paper_id` bigint(20) NOT NULL,
  `sender_id` bigint(20) NOT NULL,
  `date_sent` datetime NOT NULL,
  `ip_address` varchar(15) DEFAULT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `assoc_type` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `from_address` varchar(255) DEFAULT NULL,
  `recipients` text,
  `cc_recipients` text,
  `bcc_recipients` text,
  `subject` varchar(255) DEFAULT NULL,
  `body` text,
  PRIMARY KEY (`log_id`),
  KEY `paper_email_log_paper_id` (`paper_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paper_event_log`
--

CREATE TABLE `paper_event_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paper_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `date_logged` datetime NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `log_level` varchar(1) DEFAULT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `assoc_type` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `is_translated` tinyint(4) DEFAULT NULL,
  `entry_params` text,
  `message` text,
  PRIMARY KEY (`log_id`),
  KEY `paper_event_log_paper_id` (`paper_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paper_files`
--

CREATE TABLE `paper_files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `revision` bigint(20) NOT NULL,
  `paper_id` bigint(20) NOT NULL,
  `file_name` varchar(90) NOT NULL,
  `file_type` varchar(255) NOT NULL,
  `file_size` bigint(20) NOT NULL,
  `original_file_name` varchar(127) DEFAULT NULL,
  `type` varchar(40) NOT NULL,
  `stage` tinyint(4) DEFAULT NULL,
  `viewable` tinyint(4) DEFAULT NULL,
  `date_uploaded` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`file_id`,`revision`),
  KEY `paper_files_paper_id` (`paper_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paper_galleys`
--

CREATE TABLE `paper_galleys` (
  `galley_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `locale` varchar(5) DEFAULT NULL,
  `paper_id` bigint(20) NOT NULL,
  `file_id` bigint(20) NOT NULL,
  `label` varchar(32) DEFAULT NULL,
  `html_galley` tinyint(4) NOT NULL DEFAULT '0',
  `style_file_id` bigint(20) DEFAULT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `views` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`galley_id`),
  KEY `paper_galleys_paper_id` (`paper_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paper_html_galley_images`
--

CREATE TABLE `paper_html_galley_images` (
  `galley_id` bigint(20) NOT NULL,
  `file_id` bigint(20) NOT NULL,
  UNIQUE KEY `paper_html_galley_images_pkey` (`galley_id`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `paper_notes`
--

CREATE TABLE `paper_notes` (
  `note_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paper_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `title` varchar(255) NOT NULL,
  `note` text,
  `file_id` bigint(20) NOT NULL,
  PRIMARY KEY (`note_id`),
  KEY `paper_notes_paper_id` (`paper_id`),
  KEY `paper_notes_user_id` (`user_id`),
  KEY `paper_notes_file_id` (`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paper_search_keyword_list`
--

CREATE TABLE `paper_search_keyword_list` (
  `keyword_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `keyword_text` varchar(60) NOT NULL,
  PRIMARY KEY (`keyword_id`),
  UNIQUE KEY `paper_search_keyword_text` (`keyword_text`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paper_search_objects`
--

CREATE TABLE `paper_search_objects` (
  `object_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paper_id` bigint(20) NOT NULL,
  `type` int(11) NOT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paper_search_object_keywords`
--

CREATE TABLE `paper_search_object_keywords` (
  `object_id` bigint(20) NOT NULL,
  `keyword_id` bigint(20) NOT NULL,
  `pos` int(11) NOT NULL,
  UNIQUE KEY `paper_search_object_keywords_pkey` (`object_id`,`pos`),
  KEY `paper_search_object_keywords_keyword_id` (`keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `paper_settings`
--

CREATE TABLE `paper_settings` (
  `paper_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `paper_settings_pkey` (`paper_id`,`locale`,`setting_name`),
  KEY `paper_settings_paper_id` (`paper_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `paper_supplementary_files`
--

CREATE TABLE `paper_supplementary_files` (
  `supp_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `paper_id` bigint(20) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `public_supp_file_id` varchar(255) DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `show_reviewers` tinyint(4) DEFAULT '0',
  `date_submitted` datetime NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`supp_id`),
  KEY `paper_supplementary_files_file_id` (`file_id`),
  KEY `paper_supplementary_files_paper_id` (`paper_id`),
  KEY `paper_supplementary_files_public_issue_id` (`public_supp_file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paper_supp_file_settings`
--

CREATE TABLE `paper_supp_file_settings` (
  `supp_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `paper_supp_file_settings_pkey` (`supp_id`,`locale`,`setting_name`),
  KEY `paper_supp_file_settings_supp_id` (`supp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `paypal_transactions`
--

CREATE TABLE `paypal_transactions` (
  `txn_id` varchar(17) NOT NULL,
  `txn_type` varchar(20) DEFAULT NULL,
  `payer_email` varchar(127) DEFAULT NULL,
  `receiver_email` varchar(127) DEFAULT NULL,
  `item_number` varchar(127) DEFAULT NULL,
  `payment_date` varchar(127) DEFAULT NULL,
  `payer_id` varchar(13) DEFAULT NULL,
  `receiver_id` varchar(13) DEFAULT NULL,
  PRIMARY KEY (`txn_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `plugin_settings`
--

CREATE TABLE `plugin_settings` (
  `plugin_name` varchar(80) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `conference_id` bigint(20) NOT NULL,
  `sched_conf_id` bigint(20) NOT NULL,
  `setting_name` varchar(80) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `plugin_settings_pkey` (`plugin_name`,`locale`,`sched_conf_id`,`conference_id`,`setting_name`),
  KEY `plugin_settings_plugin_name` (`plugin_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `plugin_settings`
--

INSERT INTO `plugin_settings` VALUES
('TinyMCEPlugin', '', 0, 0, 'enabled', '1', 'bool'),
('HelpBlockPlugin', '', 0, 0, 'enabled', '1', 'bool'),
('HelpBlockPlugin', '', 0, 0, 'seq', '1', 'int'),
('HelpBlockPlugin', '', 0, 0, 'context', '2', 'int'),
('NavigationBlockPlugin', '', 0, 0, 'enabled', '1', 'bool'),
('NavigationBlockPlugin', '', 0, 0, 'seq', '5', 'int'),
('NavigationBlockPlugin', '', 0, 0, 'context', '2', 'int'),
('NotificationBlockPlugin', '', 0, 0, 'enabled', '1', 'bool'),
('NotificationBlockPlugin', '', 0, 0, 'seq', '3', 'int'),
('NotificationBlockPlugin', '', 0, 0, 'context', '2', 'int'),
('UserBlockPlugin', '', 0, 0, 'enabled', '1', 'bool'),
('UserBlockPlugin', '', 0, 0, 'seq', '2', 'int'),
('UserBlockPlugin', '', 0, 0, 'context', '2', 'int'),
('DevelopedByBlockPlugin', '', 0, 0, 'enabled', '1', 'bool'),
('DevelopedByBlockPlugin', '', 0, 0, 'seq', '0', 'int'),
('DevelopedByBlockPlugin', '', 0, 0, 'context', '2', 'int'),
('LanguageToggleBlockPlugin', '', 0, 0, 'enabled', '1', 'bool'),
('LanguageToggleBlockPlugin', '', 0, 0, 'seq', '4', 'int'),
('LanguageToggleBlockPlugin', '', 0, 0, 'context', '2', 'int'),
('FontSizeBlockPlugin', '', 0, 0, 'enabled', '1', 'bool'),
('FontSizeBlockPlugin', '', 0, 0, 'seq', '6', 'int'),
('FontSizeBlockPlugin', '', 0, 0, 'context', '2', 'int');

-- --------------------------------------------------------

--
-- Table structure for table `published_papers`
--

CREATE TABLE `published_papers` (
  `pub_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paper_id` bigint(20) NOT NULL,
  `sched_conf_id` bigint(20) NOT NULL,
  `room_id` bigint(20) DEFAULT NULL,
  `date_published` datetime NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `views` int(11) NOT NULL DEFAULT '0',
  `public_paper_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`pub_id`),
  UNIQUE KEY `published_papers_paper_id` (`paper_id`),
  KEY `published_papers_sched_conf_id` (`sched_conf_id`),
  KEY `published_papers_public_paper_id` (`public_paper_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `queued_payments`
--

CREATE TABLE `queued_payments` (
  `queued_payment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_created` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `payment_data` text,
  PRIMARY KEY (`queued_payment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `registrations`
--

CREATE TABLE `registrations` (
  `registration_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sched_conf_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `type_id` bigint(20) NOT NULL,
  `date_registered` date NOT NULL,
  `date_paid` date DEFAULT NULL,
  `membership` varchar(40) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `ip_range` text,
  `special_requests` text,
  PRIMARY KEY (`registration_id`),
  UNIQUE KEY `registration_sched_conf_id` (`sched_conf_id`,`user_id`),
  KEY `registration_domain` (`domain`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `registration_options`
--

CREATE TABLE `registration_options` (
  `option_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sched_conf_id` bigint(20) NOT NULL,
  `code` varchar(80) DEFAULT NULL,
  `opening_date` date DEFAULT NULL,
  `closing_date` datetime NOT NULL,
  `pub` tinyint(4) NOT NULL,
  `seq` double NOT NULL,
  PRIMARY KEY (`option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `registration_option_assoc`
--

CREATE TABLE `registration_option_assoc` (
  `option_id` bigint(20) NOT NULL,
  `registration_id` bigint(20) NOT NULL,
  UNIQUE KEY `registration_option_assoc_pkey` (`option_id`,`registration_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `registration_option_costs`
--

CREATE TABLE `registration_option_costs` (
  `type_id` bigint(20) NOT NULL,
  `option_id` bigint(20) NOT NULL,
  `cost` double NOT NULL,
  UNIQUE KEY `registration_option_costs_pkey` (`type_id`,`option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `registration_option_settings`
--

CREATE TABLE `registration_option_settings` (
  `option_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `registration_option_settings_pkey` (`option_id`,`locale`,`setting_name`),
  KEY `registration_option_settings_type_id` (`option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `registration_types`
--

CREATE TABLE `registration_types` (
  `type_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sched_conf_id` bigint(20) NOT NULL,
  `code` varchar(80) DEFAULT NULL,
  `cost` double NOT NULL,
  `currency_code_alpha` varchar(3) NOT NULL,
  `opening_date` date DEFAULT NULL,
  `closing_date` datetime NOT NULL,
  `expiry_date` datetime DEFAULT NULL,
  `access` smallint(6) NOT NULL,
  `institutional` tinyint(4) NOT NULL DEFAULT '0',
  `membership` tinyint(4) NOT NULL DEFAULT '0',
  `pub` tinyint(4) NOT NULL,
  `seq` double NOT NULL,
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `registration_type_settings`
--

CREATE TABLE `registration_type_settings` (
  `type_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `registration_type_settings_pkey` (`type_id`,`locale`,`setting_name`),
  KEY `registration_type_settings_type_id` (`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `review_assignments`
--

CREATE TABLE `review_assignments` (
  `review_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paper_id` bigint(20) NOT NULL,
  `reviewer_id` bigint(20) NOT NULL,
  `recommendation` tinyint(4) DEFAULT NULL,
  `date_assigned` datetime DEFAULT NULL,
  `date_notified` datetime DEFAULT NULL,
  `date_confirmed` datetime DEFAULT NULL,
  `date_completed` datetime DEFAULT NULL,
  `date_acknowledged` datetime DEFAULT NULL,
  `date_due` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reminder_was_automatic` tinyint(4) NOT NULL DEFAULT '0',
  `declined` tinyint(4) NOT NULL DEFAULT '0',
  `replaced` tinyint(4) NOT NULL DEFAULT '0',
  `cancelled` tinyint(4) NOT NULL DEFAULT '0',
  `reviewer_file_id` bigint(20) DEFAULT NULL,
  `date_rated` datetime DEFAULT NULL,
  `date_reminded` datetime DEFAULT NULL,
  `quality` tinyint(4) DEFAULT NULL,
  `stage` tinyint(4) NOT NULL DEFAULT '1',
  `review_form_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`review_id`),
  KEY `review_assignments_paper_id` (`paper_id`),
  KEY `review_assignments_reviewer_id` (`reviewer_id`),
  KEY `review_assignments_form_id` (`review_form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_forms`
--

CREATE TABLE `review_forms` (
  `review_form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `seq` double DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`review_form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_elements`
--

CREATE TABLE `review_form_elements` (
  `review_form_element_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `review_form_id` bigint(20) NOT NULL,
  `seq` double DEFAULT NULL,
  `element_type` bigint(20) DEFAULT NULL,
  `required` tinyint(4) DEFAULT NULL,
  `included` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`review_form_element_id`),
  KEY `review_form_elements_review_form_id` (`review_form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_element_settings`
--

CREATE TABLE `review_form_element_settings` (
  `review_form_element_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `review_form_element_settings_pkey` (`review_form_element_id`,`locale`,`setting_name`),
  KEY `review_form_element_settings_review_form_element_id` (`review_form_element_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_responses`
--

CREATE TABLE `review_form_responses` (
  `review_form_element_id` bigint(20) NOT NULL,
  `review_id` bigint(20) NOT NULL,
  `response_type` varchar(6) DEFAULT NULL,
  `response_value` text,
  KEY `review_form_responses_pkey` (`review_form_element_id`,`review_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_settings`
--

CREATE TABLE `review_form_settings` (
  `review_form_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `review_form_settings_pkey` (`review_form_id`,`locale`,`setting_name`),
  KEY `review_form_settings_review_form_id` (`review_form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `review_stages`
--

CREATE TABLE `review_stages` (
  `paper_id` bigint(20) NOT NULL,
  `stage` tinyint(4) NOT NULL,
  `review_revision` bigint(20) DEFAULT NULL,
  UNIQUE KEY `review_stages_pkey` (`paper_id`,`stage`),
  KEY `review_stages_paper_id` (`paper_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `conference_id` bigint(20) NOT NULL,
  `sched_conf_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `role_id` bigint(20) NOT NULL,
  UNIQUE KEY `roles_pkey` (`conference_id`,`sched_conf_id`,`user_id`,`role_id`),
  KEY `roles_conference_id` (`conference_id`),
  KEY `roles_sched_conf_id` (`sched_conf_id`),
  KEY `roles_user_id` (`user_id`),
  KEY `roles_role_id` (`role_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` VALUES
(0, 0, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `rooms`
--

CREATE TABLE `rooms` (
  `room_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `building_id` bigint(20) NOT NULL,
  PRIMARY KEY (`room_id`),
  KEY `room_building_id` (`building_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `room_settings`
--

CREATE TABLE `room_settings` (
  `room_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `room_settings_pkey` (`room_id`,`locale`,`setting_name`),
  KEY `room_settings_room_id` (`room_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `rt_contexts`
--

CREATE TABLE `rt_contexts` (
  `context_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `version_id` bigint(20) NOT NULL,
  `title` varchar(120) NOT NULL,
  `abbrev` varchar(32) NOT NULL,
  `description` text,
  `cited_by` tinyint(4) NOT NULL DEFAULT '0',
  `author_terms` tinyint(4) NOT NULL DEFAULT '0',
  `define_terms` tinyint(4) NOT NULL DEFAULT '0',
  `geo_terms` tinyint(4) NOT NULL DEFAULT '0',
  `seq` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`context_id`),
  KEY `rt_contexts_version_id` (`version_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rt_searches`
--

CREATE TABLE `rt_searches` (
  `search_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `title` varchar(120) NOT NULL,
  `description` text,
  `url` text,
  `search_url` text,
  `search_post` text,
  `seq` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`search_id`),
  KEY `rt_searches_context_id` (`context_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rt_versions`
--

CREATE TABLE `rt_versions` (
  `version_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `conference_id` bigint(20) NOT NULL,
  `version_key` varchar(40) NOT NULL,
  `locale` varchar(5) DEFAULT 'en_US',
  `title` varchar(120) NOT NULL,
  `description` text,
  PRIMARY KEY (`version_id`),
  KEY `rt_versions_conference_id` (`conference_id`),
  KEY `rt_versions_version_key` (`version_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `scheduled_tasks`
--

CREATE TABLE `scheduled_tasks` (
  `class_name` varchar(255) NOT NULL,
  `last_run` datetime DEFAULT NULL,
  UNIQUE KEY `scheduled_tasks_pkey` (`class_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sched_confs`
--

CREATE TABLE `sched_confs` (
  `sched_conf_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `conference_id` bigint(20) DEFAULT NULL,
  `path` varchar(32) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  PRIMARY KEY (`sched_conf_id`),
  KEY `sched_conf_path` (`path`),
  KEY `sched_conf_conference_id` (`conference_id`),
  KEY `sched_confs_start_end_date` (`start_date`,`end_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sched_conf_settings`
--

CREATE TABLE `sched_conf_settings` (
  `sched_conf_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `sched_conf_settings_pkey` (`sched_conf_id`,`locale`,`setting_name`),
  KEY `sched_conf_settings_sched_conf_id` (`sched_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `session_id` varchar(40) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `ip_address` varchar(39) NOT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `created` bigint(20) NOT NULL DEFAULT '0',
  `last_used` bigint(20) NOT NULL DEFAULT '0',
  `remember` tinyint(4) NOT NULL DEFAULT '0',
  `data` text,
  UNIQUE KEY `sessions_pkey` (`session_id`),
  KEY `sessions_user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `site`
--

CREATE TABLE `site` (
  `redirect` bigint(20) NOT NULL DEFAULT '0',
  `primary_locale` varchar(5) NOT NULL,
  `min_password_length` tinyint(4) NOT NULL DEFAULT '6',
  `installed_locales` varchar(255) NOT NULL DEFAULT 'en_US',
  `supported_locales` varchar(255) DEFAULT NULL,
  `original_style_file_name` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `site`
--

INSERT INTO `site` VALUES
(0, 'en_US', 6, 'en_US', 'en_US', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `site_settings`
--

CREATE TABLE `site_settings` (
  `setting_name` varchar(255) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `site_settings_pkey` (`setting_name`,`locale`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `site_settings`
--

INSERT INTO `site_settings` VALUES
('title', 'en_US', 'Open Conference Systems', 'string'),
('contactName', 'en_US', 'Open Conference Systems', 'string'),
('contactEmail', 'en_US', '[[admin_email]]', 'string');

-- --------------------------------------------------------

--
-- Table structure for table `special_events`
--

CREATE TABLE `special_events` (
  `special_event_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sched_conf_id` bigint(20) NOT NULL,
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `room_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`special_event_id`),
  KEY `special_event_sched_conf_id` (`sched_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `special_event_settings`
--

CREATE TABLE `special_event_settings` (
  `special_event_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `special_event_settings_pkey` (`special_event_id`,`locale`,`setting_name`),
  KEY `special_event_settings_special_event_id` (`special_event_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `static_pages`
--

CREATE TABLE `static_pages` (
  `static_page_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` varchar(255) NOT NULL,
  `conference_id` bigint(20) NOT NULL,
  PRIMARY KEY (`static_page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `static_page_settings`
--

CREATE TABLE `static_page_settings` (
  `static_page_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` longtext,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `static_page_settings_pkey` (`static_page_id`,`locale`,`setting_name`),
  KEY `static_page_settings_static_page_id` (`static_page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `temporary_files`
--

CREATE TABLE `temporary_files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `file_name` varchar(90) NOT NULL,
  `file_type` varchar(255) DEFAULT NULL,
  `file_size` bigint(20) NOT NULL,
  `original_file_name` varchar(127) DEFAULT NULL,
  `date_uploaded` datetime NOT NULL,
  PRIMARY KEY (`file_id`),
  KEY `temporary_files_user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `time_blocks`
--

CREATE TABLE `time_blocks` (
  `time_block_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sched_conf_id` bigint(20) NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `assigned_colour` varchar(6) DEFAULT NULL,
  `unassigned_colour` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`time_block_id`),
  UNIQUE KEY `time_block_unique` (`sched_conf_id`,`start_time`,`end_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `time_block_settings`
--

CREATE TABLE `time_block_settings` (
  `time_block_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `time_block_settings_pkey` (`time_block_id`,`locale`,`setting_name`),
  KEY `time_block_settings_time_block_id` (`time_block_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tracks`
--

CREATE TABLE `tracks` (
  `track_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sched_conf_id` bigint(20) NOT NULL,
  `review_form_id` bigint(20) DEFAULT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `director_restricted` tinyint(4) NOT NULL DEFAULT '0',
  `meta_reviewed` tinyint(4) NOT NULL DEFAULT '1',
  `hide_about` tinyint(4) NOT NULL DEFAULT '0',
  `disable_comments` tinyint(4) NOT NULL DEFAULT '0',
  `abstract_word_count` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`track_id`),
  KEY `tracks_sched_conf_id` (`sched_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_directors`
--

CREATE TABLE `track_directors` (
  `sched_conf_id` bigint(20) NOT NULL,
  `track_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  UNIQUE KEY `track_directors_pkey` (`sched_conf_id`,`track_id`,`user_id`),
  KEY `track_directors_sched_conf_id` (`sched_conf_id`),
  KEY `track_directors_track_id` (`track_id`),
  KEY `track_directors_user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `track_settings`
--

CREATE TABLE `track_settings` (
  `track_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `track_settings_pkey` (`track_id`,`locale`,`setting_name`),
  KEY `track_settings_track_id` (`track_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `user_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(32) NOT NULL,
  `password` varchar(40) NOT NULL,
  `salutation` varchar(40) DEFAULT NULL,
  `first_name` varchar(40) NOT NULL,
  `middle_name` varchar(40) DEFAULT NULL,
  `last_name` varchar(90) NOT NULL,
  `gender` varchar(1) DEFAULT NULL,
  `initials` varchar(5) DEFAULT NULL,
  `affiliation` varchar(255) DEFAULT NULL,
  `email` varchar(90) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `phone` varchar(24) DEFAULT NULL,
  `fax` varchar(24) DEFAULT NULL,
  `mailing_address` varchar(255) DEFAULT NULL,
  `country` varchar(90) DEFAULT NULL,
  `locales` varchar(255) DEFAULT NULL,
  `date_last_email` datetime DEFAULT NULL,
  `date_registered` datetime NOT NULL,
  `date_validated` datetime DEFAULT NULL,
  `date_last_login` datetime NOT NULL,
  `must_change_password` tinyint(4) DEFAULT NULL,
  `auth_id` bigint(20) DEFAULT NULL,
  `auth_str` varchar(255) DEFAULT NULL,
  `disabled` tinyint(4) NOT NULL DEFAULT '0',
  `disabled_reason` text,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `users_username` (`username`),
  UNIQUE KEY `users_email` (`email`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', NULL, '[[admin_username]]', NULL, '', NULL, NULL, NULL, '[[admin_email]]', NULL, NULL, NULL, NULL, NULL, '', NULL, '[[regtime]]', NULL, '[[regtime]]', 0, NULL, NULL, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `user_settings`
--

CREATE TABLE `user_settings` (
  `user_id` bigint(20) NOT NULL,
  `locale` varchar(5) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `assoc_type` bigint(20) DEFAULT '0',
  `assoc_id` bigint(20) DEFAULT '0',
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `user_settings_pkey` (`user_id`,`locale`,`setting_name`,`assoc_type`,`assoc_id`),
  KEY `user_settings_user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `versions`
--

CREATE TABLE `versions` (
  `major` int(11) NOT NULL DEFAULT '0',
  `minor` int(11) NOT NULL DEFAULT '0',
  `revision` int(11) NOT NULL DEFAULT '0',
  `build` int(11) NOT NULL DEFAULT '0',
  `date_installed` datetime NOT NULL,
  `current` tinyint(4) NOT NULL DEFAULT '0',
  `product_type` varchar(30) DEFAULT NULL,
  `product` varchar(30) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `versions`
--

INSERT INTO `versions` VALUES
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.auth', 'ldap'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'help'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'navigation'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'information'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'role'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'notification'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'user'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'developedBy'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'languageToggle'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'fontSize'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.citationFormats', 'mla'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.citationFormats', 'proCite'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.citationFormats', 'apa'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.citationFormats', 'refWorks'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.citationFormats', 'abnt'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.citationFormats', 'turabian'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.citationFormats', 'bibtex'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.citationFormats', 'refMan'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.citationFormats', 'cbe'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.citationFormats', 'endNote'),
(1, 2, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'staticPages'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'customLocale'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'jquery'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'tinymce'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'translator'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.gateways', 'announcementFeed'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.importexport', 'nlm'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.importexport', 'native'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.importexport', 'users'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.importexport', 'mets'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.paymethod', 'manual'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.paymethod', 'paypal'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.reports', 'papers'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.reports', 'reviews'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.reports', 'registrants'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'desert'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'redbar'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'classicBlue'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'classicNavy'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'lilac'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'night'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'vanilla'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'classicBrown'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'classicGreen'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'uncommon'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'steel'),
(1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'classicRed'),
(2, 3, 6, 0, '[[regtime]]', 1, 'core', 'ocs2');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
