{**
 * install.tpl
 *
 * Copyright (c) 2000-2012 John Willinsky
 * Distributed under the GNU GPL v2. For full terms see the file docs/COPYING.
 *
 * Installation form.
 *
 * $Id$
 *}
{strip}
{include file="common/header.tpl"}
{/strip}

<script type="text/javascript">
{literal}
<!--
// Ensure that the form submit button cannot be double-clicked
function doSubmit() {
	if (document.install.installing.value != 1) {
		document.install.installing.value = 1;
		document.install.submit();
	}
	return true;
}
// -->
{/literal}
</script>

{if is_writeable('config.inc.php')}{translate|assign:"writable_config" key="installer.checkYes"}{else}{translate|assign:"writable_config" key="installer.checkNo"}{/if}
{if is_writeable('cache')}{translate|assign:"writable_cache" key="installer.checkYes"}{else}{translate|assign:"writable_cache" key="installer.checkNo"}{/if}
{if is_writeable('public')}{translate|assign:"writable_public" key="installer.checkYes"}{else}{translate|assign:"writable_public" key="installer.checkNo"}{/if}
{if is_writeable('cache/_db')}{translate|assign:"writable_db_cache" key="installer.checkYes"}{else}{translate|assign:"writable_db_cache" key="installer.checkNo"}{/if}
{if is_writeable('cache/t_cache')}{translate|assign:"writable_templates_cache" key="installer.checkYes"}{else}{translate|assign:"writable_templates_cache" key="installer.checkNo"}{/if}
{if is_writeable('cache/t_compile')}{translate|assign:"writable_templates_compile" key="installer.checkYes"}{else}{translate|assign:"writable_templates_compile" key="installer.checkNo"}{/if}

{if !$phpIsSupportedVersion}
	{translate|assign:"wrongPhpText" key="installer.installationWrongPhp"}
{/if}

{url|assign:"upgradeUrl" page="install" op="upgrade"}
{translate key="installer.installationInstructions" version=$version->getVersionString() upgradeUrl=$upgradeUrl baseUrl=$baseUrl writable_config=$writable_config writable_db_cache=$writable_db_cache writable_cache=$writable_cache writable_public=$writable_public writable_templates_cache=$writable_templates_cache writable_templates_compile=$writable_templates_compile phpRequiredVersion=$phpRequiredVersion wrongPhpText=$wrongPhpText phpVersion=$phpVersion}

<div class="separator"></div>

<form method="post" name="install" action="{url op="install"}">
<input type="hidden" name="installing" value="0" />
{include file="common/formErrors.tpl"}

{if $isInstallError}
<p>
	<span class="formError">{translate key="installer.installErrorsOccurred"}:</span>
	<ul class="formErrorList">
		<li>{if $dbErrorMsg}{translate key="common.error.databaseError" error=$dbErrorMsg}{else}{translate key=$errorMsg}{/if}</li>
	</ul>
</p>
{/if}

<div id="localeSettings">
<h3>{translate key="installer.localeSettings"}</h3>

<p>{translate key="installer.localeSettingsInstructions" supportsMBString=$supportsMBString}</p>

<table width="100%" class="data">
	<tr valign="top">
		<td width="20%" class="label">{fieldLabel name="locale" key="locale.primary"}</td>
		<td width="80%" class="value">
			<select name="locale" id="locale" size="1" class="selectMenu">
				{html_options options=$localeOptions selected=$locale}
			</select>
			<br />
			<span class="instruct">{translate key="installer.localeInstructions"}</span>
		</td>
	</tr>
	<tr valign="top">
		<td class="label">{fieldLabel suppressId="true" name="additionalLocales" key="installer.additionalLocales"}</td>
		<td class="value">
			{foreach from=$localeOptions key=localeKey item=localeName}
				<input type="checkbox" name="additionalLocales[]" id="additionalLocales-{$localeKey|escape}" value="{$localeKey|escape}"{if in_array($localeKey, $additionalLocales)} checked="checked"{/if} /> <label for="additionalLocales-{$localeKey|escape}">{$localeName|escape} ({$localeKey|escape})</label>
				{if !$localesComplete[$localeKey]}
					<span class="formError">*</span>
					{assign var=incompleteLocaleFound value=1}
				{/if}<br />
			{/foreach}
			<span class="instruct">{translate key="installer.additionalLocalesInstructions"}</span>
			{if $incompleteLocaleFound}
				<br/>
				<span class="formError">*</span>&nbsp;{translate key="installer.locale.maybeIncomplete"}
			{/if}{* $incompleteLocaleFound *}
		</td>
	</tr>
	<tr valign="top">
		<td class="label">{fieldLabel name="clientCharset" key="installer.clientCharset"}</td>
		<td class="value">
			<select name="clientCharset" id="clientCharset" size="1" class="selectMenu">
				{html_options options=$clientCharsetOptions selected=$clientCharset}
			</select>
			<br />
			<span class="instruct">{translate key="installer.clientCharsetInstructions"}</span>
		</td>
	</tr>
	<tr valign="top">
		<td class="label">{fieldLabel name="connectionCharset" key="installer.connectionCharset"}</td>
		<td class="value">
			<select name="connectionCharset" id="connectionCharset" size="1" class="selectMenu">
				{html_options options=$connectionCharsetOptions selected=$connectionCharset}
			</select>
			<br />
			<span class="instruct">{translate key="installer.connectionCharsetInstructions"}</span>
		</td>
	</tr>
	<tr valign="top">
		<td class="label">{fieldLabel name="databaseCharset" key="installer.databaseCharset"}</td>
		<td class="value">
			<select name="databaseCharset" id="databaseCharset" size="1" class="selectMenu">
				{html_options options=$databaseCharsetOptions selected=$databaseCharset}
			</select>
			<br />
			<span class="instruct">{translate key="installer.databaseCharsetInstructions"}</span>
		</td>
	</tr>
</table>
</div>

<div class="separator"></div>

{if !$skipFilesDirSection}
<div id="fileSettings">
	<h3>{translate key="installer.fileSettings"}</h3>

	<table width="100%" class="data">
		<tr valign="top">
			<td width="20%" class="label">{fieldLabel name="filesDir" key="installer.filesDir"}</td>
			<td width="80%" class="value">
				<input type="text" name="filesDir" id="filesDir" value="{$filesDir|escape}" size="60" maxlength="255" class="textField" />
				<br />
				<span class="instruct">{translate key="installer.filesDirInstructions"}</span>
			</td>
		</tr>
		<tr valign="top">
			<td>&nbsp;</td>
			<td class="value"><input type="checkbox" name="skipFilesDir" id="skipFilesDir" value="1"{if $skipFilesDir} checked="checked"{/if} /> <label for="skipFilesDir">{translate key="installer.skipFilesDir"}</label></td>
		</tr>
	</table>

	<div class="separator"></div>
</div>
{/if}{* !$skipFilesDirSection *}

<div id="security">
<h3>{translate key="installer.securitySettings"}</h3>

<table width="100%" class="data">
	<tr valign="top">
		<td width="20%" class="label">{fieldLabel name="encryption" key="installer.encryption"}</td>
		<td width="80%" class="value">
			<select name="encryption" id="encryption" size="1" class="selectMenu">
				{html_options options=$encryptionOptions selected=$encryption}
			</select>
			<br />
			<span class="instruct">{translate key="installer.encryptionInstructions"}</span>
		</td>
	</tr>
</table>
</div>

<div class="separator"></div>

<div id="administratorAccount">
<h3>{translate key="installer.administratorAccount"}</h3>

<p>{translate key="installer.administratorAccountInstructions"}</p>

<table width="100%" class="data">
	<tr valign="top">
		<td width="20%" class="label">{fieldLabel name="adminUsername" key="user.username"}</td>
		<td width="80%" class="value"><input type="text" name="adminUsername" id="adminUsername" value="{$adminUsername|escape}" size="20" maxlength="32" class="textField" /></td>
	</tr>
	<tr valign="top">
		<td class="label">{fieldLabel name="adminPassword" key="user.password"}</td>
		<td class="value"><input type="password" name="adminPassword" id="adminPassword" value="{$adminPassword|escape}" size="20" maxlength="32" class="textField" /></td>
	</tr>
	<tr valign="top">
		<td class="label">{fieldLabel name="adminPassword2" key="user.register.repeatPassword"}</td>
		<td class="value"><input type="password" name="adminPassword2" id="adminPassword2" value="{$adminPassword2|escape}" size="20" maxlength="32" class="textField" /></td>
	</tr>
	<tr valign="top">
		<td width="20%" class="label">{fieldLabel name="adminEmail" key="user.email"}</td>
		<td width="80%" class="value"><input type="text" name="adminEmail" id="adminEmail" value="{$adminEmail|escape}" size="30" maxlength="90" class="textField" /></td>
	</tr>
</table>
</div>

<div class="separator"></div>

<div id="databaseSettings">
<h3>{translate key="installer.databaseSettings"}</h3>

<p>{translate key="installer.databaseSettingsInstructions"}</p>

<table width="100%" class="data">
	<tr valign="top">
		<td width="20%" class="label">{fieldLabel name="databaseDriver" key="installer.databaseDriver"}</td>
		<td width="80%" class="value">
			<select name="databaseDriver" id="databaseDriver" size="1" class="selectMenu">
				{html_options options=$databaseDriverOptions selected=$databaseDriver}
			</select>
			<br />
			<span class="instruct">{translate key="installer.databaseDriverInstructions"}</span>
		</td>
	</tr>
	<tr valign="top">
		<td class="label">{fieldLabel name="databaseHost" key="installer.databaseHost"}</td>
		<td class="value">
			<input type="text" name="databaseHost" id="databaseHost" value="{$databaseHost|escape}" size="30" maxlength="60" class="textField" />
			<br />
			<span class="instruct">{translate key="installer.databaseHostInstructions"}</span>
		</td>
	</tr>
	<tr valign="top">
		<td class="label">{fieldLabel name="databaseUsername" key="installer.databaseUsername"}</td>
		<td class="value"><input type="text" name="databaseUsername" id="databaseUsername" value="{$databaseUsername|escape}" size="30" maxlength="60" class="textField" /></td>
	</tr>
	<tr valign="top">
		<td class="label">{fieldLabel name="databasePassword" key="installer.databasePassword"}</td>
		<td class="value"><input type="text" name="databasePassword" id="databasePassword" value="{$databasePassword|escape}" size="30" maxlength="60" class="textField" /></td>
	</tr>
	<tr valign="top">
		<td class="label">{fieldLabel name="databaseName" key="installer.databaseName"}</td>
		<td class="value"><input type="text" name="databaseName" id="databaseName" value="{$databaseName|escape}" size="30" maxlength="60" class="textField" /></td>
	</tr>
	<tr valign="top">
		<td>&nbsp;</td>
		<td class="value">
			<input type="checkbox" name="createDatabase" id="createDatabase" value="1"{if $createDatabase} checked="checked"{/if} /> <label for="createDatabase">{translate key="installer.createDatabase"}</label>
			<br />
			<span class="instruct">{translate key="installer.createDatabaseInstructions"}</span>
		</td>
	</tr>
</table>
</div>

<div class="separator"></div>

{if !$skipMiscSettings}
<div id="miscSettings">
<h3>{translate key="installer.miscSettings"}</h3>

	<table width="100%" class="data">
		<tr valign="top">
			<td width="20%" class="label">{fieldLabel name="oaiRepositoryId" key="installer.oaiRepositoryId"}</td>
			<td width="80%" class="value">
				<input type="text" name="oaiRepositoryId" id="oaiRepositoryId" value="{$oaiRepositoryId|escape}" size="30" maxlength="60" class="textField" />
				<br />
				<span class="instruct">{translate key="installer.oaiRepositoryIdInstructions"}</span>
			</td>
		</tr>
	</table>

	<div class="separator"></div>
</div>
{/if}{* !$skipMiscSettings *}

<p><input name="install" type="button" id="install" value="{translate key="installer.installApplication"}" class="button defaultButton" onclick="doSubmit()" /></p>

</form>

{include file="common/footer.tpl"}
