
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `nextcloud2303`
--

-- --------------------------------------------------------

--
-- Table structure for table `oc_accounts`
--

CREATE TABLE `oc_accounts` (
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `data` longtext COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_accounts_data`
--

CREATE TABLE `oc_accounts_data` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `value` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `accounts_data_uid` (`uid`),
  KEY `accounts_data_name` (`name`),
  KEY `accounts_data_value` (`value`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_activity`
--

CREATE TABLE `oc_activity` (
  `activity_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `timestamp` int(11) NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '0',
  `type` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `user` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `affecteduser` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `app` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `subject` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `subjectparams` longtext COLLATE [[utf8]]_bin NOT NULL,
  `message` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `messageparams` longtext COLLATE [[utf8]]_bin,
  `file` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `link` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `object_type` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `object_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`activity_id`),
  KEY `activity_user_time` (`affecteduser`,`timestamp`),
  KEY `activity_filter_by` (`affecteduser`,`user`,`timestamp`),
  KEY `activity_filter` (`affecteduser`,`type`,`app`,`timestamp`),
  KEY `activity_object` (`object_type`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_activity_mq`
--

CREATE TABLE `oc_activity_mq` (
  `mail_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `amq_timestamp` int(11) NOT NULL DEFAULT '0',
  `amq_latest_send` int(11) NOT NULL DEFAULT '0',
  `amq_type` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `amq_affecteduser` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `amq_appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `amq_subject` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `amq_subjectparams` longtext COLLATE [[utf8]]_bin,
  `object_type` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `object_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`mail_id`),
  KEY `amp_user` (`amq_affecteduser`),
  KEY `amp_latest_send_time` (`amq_latest_send`),
  KEY `amp_timestamp_time` (`amq_timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_addressbookchanges`
--

CREATE TABLE `oc_addressbookchanges` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `synctoken` int(10) unsigned NOT NULL DEFAULT '1',
  `addressbookid` bigint(20) NOT NULL,
  `operation` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `addressbookid_synctoken` (`addressbookid`,`synctoken`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_addressbooks`
--

CREATE TABLE `oc_addressbooks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `principaluri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `displayname` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `description` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `synctoken` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `addressbook_index` (`principaluri`,`uri`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_appconfig`
--

CREATE TABLE `oc_appconfig` (
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `configkey` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `configvalue` longtext COLLATE [[utf8]]_bin,
  PRIMARY KEY (`appid`,`configkey`),
  KEY `appconfig_config_key_index` (`configkey`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

--
-- Dumping data for table `oc_appconfig`
--

INSERT INTO `oc_appconfig` VALUES
('accessibility', 'enabled', 'yes'),
('accessibility', 'installed_version', '1.9.0'),
('accessibility', 'types', ''),
('activity', 'enabled', 'yes'),
('activity', 'installed_version', '2.15.0'),
('activity', 'types', 'filesystem'),
('backgroundjob', 'lastjob', '1'),
('bruteforcesettings', 'enabled', 'yes'),
('bruteforcesettings', 'installed_version', '2.3.0'),
('bruteforcesettings', 'types', ''),
('circles', 'enabled', 'yes'),
('circles', 'installed_version', '23.1.0'),
('circles', 'types', 'filesystem,dav'),
('cloud_federation_api', 'enabled', 'yes'),
('cloud_federation_api', 'installed_version', '1.6.0'),
('cloud_federation_api', 'types', 'filesystem'),
('comments', 'enabled', 'yes'),
('comments', 'installed_version', '1.13.0'),
('comments', 'types', 'logging'),
('contactsinteraction', 'enabled', 'yes'),
('contactsinteraction', 'installed_version', '1.4.0'),
('contactsinteraction', 'types', 'dav'),
('core', 'installed.bundles', '["CoreBundle"]'),
('core', 'installedat', '[[timestamp]].4867'),
('core', 'lastcron', '[[timestamp]]'),
('core', 'lastupdatedat', '[[timestamp]].4928'),
('core', 'oc.integritycheck.checker', '[]'),
('core', 'public_files', 'files_sharing/public.php'),
('core', 'public_webdav', 'dav/appinfo/v1/publicwebdav.php'),
('core', 'theming.variables', ''),
('core', 'vendor', 'nextcloud'),
('dashboard', 'enabled', 'yes'),
('dashboard', 'installed_version', '7.3.0'),
('dashboard', 'types', ''),
('dav', 'enabled', 'yes'),
('dav', 'installed_version', '1.21.0'),
('dav', 'types', 'filesystem'),
('federatedfilesharing', 'enabled', 'yes'),
('federatedfilesharing', 'installed_version', '1.13.0'),
('federatedfilesharing', 'types', ''),
('federation', 'enabled', 'yes'),
('federation', 'installed_version', '1.13.0'),
('federation', 'types', 'authentication'),
('files', 'enabled', 'yes'),
('files', 'installed_version', '1.18.0'),
('files', 'types', 'filesystem'),
('files_pdfviewer', 'enabled', 'yes'),
('files_pdfviewer', 'installed_version', '2.4.0'),
('files_pdfviewer', 'types', ''),
('files_rightclick', 'enabled', 'yes'),
('files_rightclick', 'installed_version', '1.2.0'),
('files_rightclick', 'types', ''),
('files_sharing', 'enabled', 'yes'),
('files_sharing', 'installed_version', '1.15.0'),
('files_sharing', 'types', 'filesystem'),
('files_trashbin', 'enabled', 'yes'),
('files_trashbin', 'installed_version', '1.13.0'),
('files_trashbin', 'types', 'filesystem,dav'),
('files_versions', 'enabled', 'yes'),
('files_versions', 'installed_version', '1.16.0'),
('files_versions', 'types', 'filesystem,dav'),
('files_videoplayer', 'enabled', 'yes'),
('files_videoplayer', 'installed_version', '1.12.0'),
('files_videoplayer', 'types', ''),
('firstrunwizard', 'enabled', 'yes'),
('firstrunwizard', 'installed_version', '2.12.0'),
('firstrunwizard', 'types', 'logging'),
('logreader', 'enabled', 'yes'),
('logreader', 'installed_version', '2.8.0'),
('logreader', 'types', ''),
('lookup_server_connector', 'enabled', 'yes'),
('lookup_server_connector', 'installed_version', '1.11.0'),
('lookup_server_connector', 'types', 'authentication'),
('nextcloud_announcements', 'enabled', 'yes'),
('nextcloud_announcements', 'installed_version', '1.12.0'),
('nextcloud_announcements', 'types', 'logging'),
('notifications', 'enabled', 'yes'),
('notifications', 'installed_version', '2.11.1'),
('notifications', 'types', 'logging'),
('oauth2', 'enabled', 'yes'),
('oauth2', 'installed_version', '1.11.0'),
('oauth2', 'types', 'authentication'),
('password_policy', 'enabled', 'yes'),
('password_policy', 'installed_version', '1.13.0'),
('password_policy', 'types', 'authentication'),
('photos', 'enabled', 'yes'),
('photos', 'installed_version', '1.5.0'),
('photos', 'types', ''),
('privacy', 'enabled', 'yes'),
('privacy', 'installed_version', '1.7.0'),
('privacy', 'types', ''),
('provisioning_api', 'enabled', 'yes'),
('provisioning_api', 'installed_version', '1.13.0'),
('provisioning_api', 'types', 'prevent_group_restriction'),
('recommendations', 'enabled', 'yes'),
('recommendations', 'installed_version', '1.2.0'),
('recommendations', 'types', ''),
('serverinfo', 'enabled', 'yes'),
('serverinfo', 'installed_version', '1.13.0'),
('serverinfo', 'types', ''),
('settings', 'enabled', 'yes'),
('settings', 'installed_version', '1.5.0'),
('settings', 'types', ''),
('sharebymail', 'enabled', 'yes'),
('sharebymail', 'installed_version', '1.13.0'),
('sharebymail', 'types', 'filesystem'),
('support', 'enabled', 'yes'),
('support', 'installed_version', '1.6.0'),
('support', 'types', 'session'),
('survey_client', 'enabled', 'yes'),
('survey_client', 'installed_version', '1.11.0'),
('survey_client', 'types', ''),
('systemtags', 'enabled', 'yes'),
('systemtags', 'installed_version', '1.13.0'),
('systemtags', 'types', 'logging'),
('text', 'enabled', 'yes'),
('text', 'installed_version', '3.4.1'),
('text', 'types', 'dav'),
('theming', 'enabled', 'yes'),
('theming', 'installed_version', '1.14.0'),
('theming', 'types', 'logging'),
('twofactor_backupcodes', 'enabled', 'yes'),
('twofactor_backupcodes', 'installed_version', '1.12.0'),
('twofactor_backupcodes', 'types', ''),
('updatenotification', 'enabled', 'yes'),
('updatenotification', 'installed_version', '1.13.0'),
('updatenotification', 'types', ''),
('user_status', 'enabled', 'yes'),
('user_status', 'installed_version', '1.3.1'),
('user_status', 'types', ''),
('viewer', 'enabled', 'yes'),
('viewer', 'installed_version', '1.7.0'),
('viewer', 'types', ''),
('weather_status', 'enabled', 'yes'),
('weather_status', 'installed_version', '1.3.0'),
('weather_status', 'types', ''),
('workflowengine', 'enabled', 'yes'),
('workflowengine', 'installed_version', '2.5.0'),
('workflowengine', 'types', 'filesystem');

-- --------------------------------------------------------

--
-- Table structure for table `oc_authorized_groups`
--

CREATE TABLE `oc_authorized_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` varchar(200) COLLATE [[utf8]]_bin NOT NULL,
  `class` varchar(200) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `admindel_groupid_idx` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_authtoken`
--

CREATE TABLE `oc_authtoken` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `login_name` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `password` longtext COLLATE [[utf8]]_bin,
  `name` longtext COLLATE [[utf8]]_bin NOT NULL,
  `token` varchar(200) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `type` smallint(5) unsigned DEFAULT '0',
  `remember` smallint(5) unsigned DEFAULT '0',
  `last_activity` int(10) unsigned DEFAULT '0',
  `last_check` int(10) unsigned DEFAULT '0',
  `scope` longtext COLLATE [[utf8]]_bin,
  `expires` int(10) unsigned DEFAULT NULL,
  `private_key` longtext COLLATE [[utf8]]_bin,
  `public_key` longtext COLLATE [[utf8]]_bin,
  `version` smallint(5) unsigned NOT NULL DEFAULT '1',
  `password_invalid` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `authtoken_token_index` (`token`),
  KEY `authtoken_last_activity_idx` (`last_activity`),
  KEY `authtoken_uid_index` (`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

--
-- Dumping data for table `oc_authtoken`
--


-- --------------------------------------------------------

--
-- Table structure for table `oc_bruteforce_attempts`
--

CREATE TABLE `oc_bruteforce_attempts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `occurred` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `subnet` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `metadata` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `bruteforce_attempts_ip` (`ip`),
  KEY `bruteforce_attempts_subnet` (`subnet`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendarchanges`
--

CREATE TABLE `oc_calendarchanges` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `synctoken` int(10) unsigned NOT NULL DEFAULT '1',
  `calendarid` bigint(20) NOT NULL,
  `operation` smallint(6) NOT NULL,
  `calendartype` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `calid_type_synctoken` (`calendarid`,`calendartype`,`synctoken`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendarobjects`
--

CREATE TABLE `oc_calendarobjects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `calendardata` longblob,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `calendarid` bigint(20) unsigned NOT NULL,
  `lastmodified` int(10) unsigned DEFAULT NULL,
  `etag` varchar(32) COLLATE [[utf8]]_bin DEFAULT NULL,
  `size` bigint(20) unsigned NOT NULL,
  `componenttype` varchar(8) COLLATE [[utf8]]_bin DEFAULT NULL,
  `firstoccurence` bigint(20) unsigned DEFAULT NULL,
  `lastoccurence` bigint(20) unsigned DEFAULT NULL,
  `uid` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `classification` int(11) DEFAULT '0',
  `calendartype` int(11) NOT NULL DEFAULT '0',
  `deleted_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `calobjects_index` (`calendarid`,`calendartype`,`uri`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendarobjects_props`
--

CREATE TABLE `oc_calendarobjects_props` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `calendarid` bigint(20) NOT NULL DEFAULT '0',
  `objectid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `parameter` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `value` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `calendartype` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `calendarobject_index` (`objectid`,`calendartype`),
  KEY `calendarobject_name_index` (`name`,`calendartype`),
  KEY `calendarobject_value_index` (`value`,`calendartype`),
  KEY `calendarobject_calid_index` (`calendarid`,`calendartype`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendars`
--

CREATE TABLE `oc_calendars` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `principaluri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `displayname` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `synctoken` int(10) unsigned NOT NULL DEFAULT '1',
  `description` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `calendarorder` int(10) unsigned NOT NULL DEFAULT '0',
  `calendarcolor` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `timezone` longtext COLLATE [[utf8]]_bin,
  `components` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `transparent` smallint(6) NOT NULL DEFAULT '0',
  `deleted_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `calendars_index` (`principaluri`,`uri`),
  KEY `cals_princ_del_idx` (`principaluri`,`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendarsubscriptions`
--

CREATE TABLE `oc_calendarsubscriptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `principaluri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `displayname` varchar(100) COLLATE [[utf8]]_bin DEFAULT NULL,
  `refreshrate` varchar(10) COLLATE [[utf8]]_bin DEFAULT NULL,
  `calendarorder` int(10) unsigned NOT NULL DEFAULT '0',
  `calendarcolor` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `striptodos` smallint(6) DEFAULT NULL,
  `stripalarms` smallint(6) DEFAULT NULL,
  `stripattachments` smallint(6) DEFAULT NULL,
  `lastmodified` int(10) unsigned DEFAULT NULL,
  `synctoken` int(10) unsigned NOT NULL DEFAULT '1',
  `source` longtext COLLATE [[utf8]]_bin,
  PRIMARY KEY (`id`),
  UNIQUE KEY `calsub_index` (`principaluri`,`uri`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendar_invitations`
--

CREATE TABLE `oc_calendar_invitations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `recurrenceid` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `attendee` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `organizer` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `sequence` bigint(20) unsigned DEFAULT NULL,
  `token` varchar(60) COLLATE [[utf8]]_bin NOT NULL,
  `expiration` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_invitation_tokens` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendar_reminders`
--

CREATE TABLE `oc_calendar_reminders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` bigint(20) NOT NULL,
  `object_id` bigint(20) NOT NULL,
  `is_recurring` smallint(6) DEFAULT NULL,
  `uid` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `recurrence_id` bigint(20) unsigned DEFAULT NULL,
  `is_recurrence_exception` smallint(6) NOT NULL,
  `event_hash` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `alarm_hash` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `type` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `is_relative` smallint(6) NOT NULL,
  `notification_date` bigint(20) unsigned NOT NULL,
  `is_repeat_based` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_reminder_objid` (`object_id`),
  KEY `calendar_reminder_uidrec` (`uid`,`recurrence_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendar_resources`
--

CREATE TABLE `oc_calendar_resources` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `backend_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `resource_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `email` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `displayname` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `group_restrictions` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_resources_bkdrsc` (`backend_id`,`resource_id`),
  KEY `calendar_resources_email` (`email`),
  KEY `calendar_resources_name` (`displayname`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendar_resources_md`
--

CREATE TABLE `oc_calendar_resources_md` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `resource_id` bigint(20) unsigned NOT NULL,
  `key` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `value` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_resources_md_idk` (`resource_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendar_rooms`
--

CREATE TABLE `oc_calendar_rooms` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `backend_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `resource_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `email` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `displayname` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `group_restrictions` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_rooms_bkdrsc` (`backend_id`,`resource_id`),
  KEY `calendar_rooms_email` (`email`),
  KEY `calendar_rooms_name` (`displayname`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendar_rooms_md`
--

CREATE TABLE `oc_calendar_rooms_md` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `room_id` bigint(20) unsigned NOT NULL,
  `key` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `value` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_rooms_md_idk` (`room_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_cards`
--

CREATE TABLE `oc_cards` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `addressbookid` bigint(20) NOT NULL DEFAULT '0',
  `carddata` longblob,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `lastmodified` bigint(20) unsigned DEFAULT NULL,
  `etag` varchar(32) COLLATE [[utf8]]_bin DEFAULT NULL,
  `size` bigint(20) unsigned NOT NULL,
  `uid` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cards_abid` (`addressbookid`),
  KEY `cards_abiduri` (`addressbookid`,`uri`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_cards_properties`
--

CREATE TABLE `oc_cards_properties` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `addressbookid` bigint(20) NOT NULL DEFAULT '0',
  `cardid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `value` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `preferred` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `card_contactid_index` (`cardid`),
  KEY `card_name_index` (`name`),
  KEY `card_value_index` (`value`),
  KEY `cards_prop_abid` (`addressbookid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_circle`
--

CREATE TABLE `oc_circles_circle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unique_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(127) COLLATE [[utf8]]_bin NOT NULL,
  `display_name` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `sanitized_name` varchar(127) COLLATE [[utf8]]_bin DEFAULT '',
  `instance` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `config` int(10) unsigned DEFAULT NULL,
  `source` int(10) unsigned DEFAULT NULL,
  `settings` longtext COLLATE [[utf8]]_bin,
  `description` longtext COLLATE [[utf8]]_bin,
  `creation` datetime DEFAULT NULL,
  `contact_addressbook` int(10) unsigned DEFAULT NULL,
  `contact_groupname` varchar(127) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_8195F548E3C68343` (`unique_id`),
  KEY `IDX_8195F548D48A2F7C` (`config`),
  KEY `IDX_8195F5484230B1DE` (`instance`),
  KEY `IDX_8195F5485F8A7F73` (`source`),
  KEY `IDX_8195F548C317B362` (`sanitized_name`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_event`
--

CREATE TABLE `oc_circles_event` (
  `token` varchar(63) COLLATE [[utf8]]_bin NOT NULL,
  `instance` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `event` longtext COLLATE [[utf8]]_bin,
  `result` longtext COLLATE [[utf8]]_bin,
  `interface` int(11) NOT NULL DEFAULT '0',
  `severity` int(11) DEFAULT NULL,
  `retry` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `creation` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`token`,`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_member`
--

CREATE TABLE `oc_circles_member` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `single_id` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `circle_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `member_id` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `user_id` varchar(127) COLLATE [[utf8]]_bin NOT NULL,
  `user_type` smallint(6) NOT NULL DEFAULT '1',
  `instance` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `invited_by` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `level` smallint(6) NOT NULL,
  `status` varchar(15) COLLATE [[utf8]]_bin DEFAULT NULL,
  `note` longtext COLLATE [[utf8]]_bin,
  `cached_name` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `cached_update` datetime DEFAULT NULL,
  `contact_id` varchar(127) COLLATE [[utf8]]_bin DEFAULT NULL,
  `contact_meta` longtext COLLATE [[utf8]]_bin,
  `joined` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `circles_member_cisiuiutil` (`circle_id`,`single_id`,`user_id`,`user_type`,`instance`,`level`),
  KEY `circles_member_cisi` (`circle_id`,`single_id`),
  KEY `IDX_25C66A49E7A1254A` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_membership`
--

CREATE TABLE `oc_circles_membership` (
  `circle_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `single_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `level` int(10) unsigned NOT NULL,
  `inheritance_first` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `inheritance_last` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `inheritance_depth` int(10) unsigned NOT NULL,
  `inheritance_path` longtext COLLATE [[utf8]]_bin NOT NULL,
  UNIQUE KEY `UNIQ_8FC816EAE7C1D92B70EE2FF6` (`single_id`,`circle_id`),
  KEY `IDX_8FC816EAE7C1D92B` (`single_id`),
  KEY `circles_membership_ifilci` (`inheritance_first`,`inheritance_last`,`circle_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_mount`
--

CREATE TABLE `oc_circles_mount` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mount_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `circle_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `single_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `token` varchar(63) COLLATE [[utf8]]_bin DEFAULT NULL,
  `parent` int(11) DEFAULT NULL,
  `mountpoint` longtext COLLATE [[utf8]]_bin,
  `mountpoint_hash` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `circles_mount_cimipt` (`circle_id`,`mount_id`,`parent`,`token`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_mountpoint`
--

CREATE TABLE `oc_circles_mountpoint` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mount_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `single_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `mountpoint` longtext COLLATE [[utf8]]_bin,
  `mountpoint_hash` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `circles_mountpoint_ms` (`mount_id`,`single_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_remote`
--

CREATE TABLE `oc_circles_remote` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(15) COLLATE [[utf8]]_bin NOT NULL DEFAULT 'Unknown',
  `interface` int(11) NOT NULL DEFAULT '0',
  `uid` varchar(20) COLLATE [[utf8]]_bin DEFAULT NULL,
  `instance` varchar(127) COLLATE [[utf8]]_bin DEFAULT NULL,
  `href` varchar(254) COLLATE [[utf8]]_bin DEFAULT NULL,
  `item` longtext COLLATE [[utf8]]_bin,
  `creation` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_F94EF834230B1DE` (`instance`),
  KEY `IDX_F94EF83539B0606` (`uid`),
  KEY `IDX_F94EF8334F8E741` (`href`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_share_lock`
--

CREATE TABLE `oc_circles_share_lock` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `circle_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `instance` varchar(127) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_337F52F8126F525E70EE2FF6` (`item_id`,`circle_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_token`
--

CREATE TABLE `oc_circles_token` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `share_id` int(11) DEFAULT NULL,
  `circle_id` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `single_id` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `member_id` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `token` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `password` varchar(127) COLLATE [[utf8]]_bin DEFAULT NULL,
  `accepted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sicisimit` (`share_id`,`circle_id`,`single_id`,`member_id`,`token`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_collres_accesscache`
--

CREATE TABLE `oc_collres_accesscache` (
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `collection_id` bigint(20) NOT NULL DEFAULT '0',
  `resource_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `resource_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `access` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`user_id`,`collection_id`,`resource_type`,`resource_id`),
  KEY `collres_user_res` (`user_id`,`resource_type`,`resource_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_collres_collections`
--

CREATE TABLE `oc_collres_collections` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_collres_resources`
--

CREATE TABLE `oc_collres_resources` (
  `collection_id` bigint(20) NOT NULL,
  `resource_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `resource_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`collection_id`,`resource_type`,`resource_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_comments`
--

CREATE TABLE `oc_comments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `topmost_parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `children_count` int(10) unsigned NOT NULL DEFAULT '0',
  `actor_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `actor_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `message` longtext COLLATE [[utf8]]_bin,
  `verb` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `creation_timestamp` datetime DEFAULT NULL,
  `latest_child_timestamp` datetime DEFAULT NULL,
  `object_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `object_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `reference_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `comments_parent_id_index` (`parent_id`),
  KEY `comments_topmost_parent_id_idx` (`topmost_parent_id`),
  KEY `comments_object_index` (`object_type`,`object_id`,`creation_timestamp`),
  KEY `comments_actor_index` (`actor_type`,`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_comments_read_markers`
--

CREATE TABLE `oc_comments_read_markers` (
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `object_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `object_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `marker_datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`,`object_type`,`object_id`),
  KEY `comments_marker_object_index` (`object_type`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_dav_cal_proxy`
--

CREATE TABLE `oc_dav_cal_proxy` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `proxy_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `permissions` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dav_cal_proxy_uidx` (`owner_id`,`proxy_id`,`permissions`),
  KEY `dav_cal_proxy_ipid` (`proxy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_dav_shares`
--

CREATE TABLE `oc_dav_shares` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `principaluri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `type` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `access` smallint(6) DEFAULT NULL,
  `resourceid` bigint(20) unsigned NOT NULL,
  `publicuri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dav_shares_index` (`principaluri`,`resourceid`,`type`,`publicuri`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_directlink`
--

CREATE TABLE `oc_directlink` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `file_id` bigint(20) unsigned NOT NULL,
  `token` varchar(60) COLLATE [[utf8]]_bin DEFAULT NULL,
  `expiration` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `directlink_token_idx` (`token`),
  KEY `directlink_expiration_idx` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_direct_edit`
--

CREATE TABLE `oc_direct_edit` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `editor_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `token` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `file_id` bigint(20) NOT NULL,
  `user_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `share_id` bigint(20) DEFAULT NULL,
  `timestamp` bigint(20) unsigned NOT NULL,
  `accessed` tinyint(1) DEFAULT '0',
  `file_path` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_4D5AFECA5F37A13B` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_federated_reshares`
--

CREATE TABLE `oc_federated_reshares` (
  `share_id` bigint(20) NOT NULL,
  `remote_id` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  PRIMARY KEY (`share_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_filecache`
--

CREATE TABLE `oc_filecache` (
  `fileid` bigint(20) NOT NULL AUTO_INCREMENT,
  `storage` bigint(20) NOT NULL DEFAULT '0',
  `path` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `path_hash` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `parent` bigint(20) NOT NULL DEFAULT '0',
  `name` varchar(250) COLLATE [[utf8]]_bin DEFAULT NULL,
  `mimetype` bigint(20) NOT NULL DEFAULT '0',
  `mimepart` bigint(20) NOT NULL DEFAULT '0',
  `size` bigint(20) NOT NULL DEFAULT '0',
  `mtime` bigint(20) NOT NULL DEFAULT '0',
  `storage_mtime` bigint(20) NOT NULL DEFAULT '0',
  `encrypted` int(11) NOT NULL DEFAULT '0',
  `unencrypted_size` bigint(20) NOT NULL DEFAULT '0',
  `etag` varchar(40) COLLATE [[utf8]]_bin DEFAULT NULL,
  `permissions` int(11) DEFAULT '0',
  `checksum` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`fileid`),
  UNIQUE KEY `fs_storage_path_hash` (`storage`,`path_hash`),
  KEY `fs_parent_name_hash` (`parent`,`name`),
  KEY `fs_storage_mimetype` (`storage`,`mimetype`),
  KEY `fs_storage_mimepart` (`storage`,`mimepart`),
  KEY `fs_storage_size` (`storage`,`size`,`fileid`),
  KEY `fs_id_storage_size` (`fileid`,`storage`,`size`),
  KEY `fs_mtime` (`mtime`),
  KEY `fs_size` (`size`),
  KEY `fs_storage_path_prefix` (`storage`,`path`(64))
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

--
-- Dumping data for table `oc_filecache`
--

-- --------------------------------------------------------

--
-- Table structure for table `oc_filecache_extended`
--

CREATE TABLE `oc_filecache_extended` (
  `fileid` bigint(20) unsigned NOT NULL,
  `metadata_etag` varchar(40) COLLATE [[utf8]]_bin DEFAULT NULL,
  `creation_time` bigint(20) NOT NULL DEFAULT '0',
  `upload_time` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fileid`),
  KEY `fce_ctime_idx` (`creation_time`),
  KEY `fce_utime_idx` (`upload_time`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_files_trash`
--

CREATE TABLE `oc_files_trash` (
  `auto_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `id` varchar(250) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `user` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `timestamp` varchar(12) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `location` varchar(512) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `type` varchar(4) COLLATE [[utf8]]_bin DEFAULT NULL,
  `mime` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`auto_id`),
  KEY `id_index` (`id`),
  KEY `timestamp_index` (`timestamp`),
  KEY `user_index` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_file_locks`
--

CREATE TABLE `oc_file_locks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lock` int(11) NOT NULL DEFAULT '0',
  `key` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `ttl` int(11) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `lock_key_index` (`key`),
  KEY `lock_ttl_index` (`ttl`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_flow_checks`
--

CREATE TABLE `oc_flow_checks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(256) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `operator` varchar(16) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `value` longtext COLLATE [[utf8]]_bin,
  `hash` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `flow_unique_hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_flow_operations`
--

CREATE TABLE `oc_flow_operations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(256) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `name` varchar(256) COLLATE [[utf8]]_bin DEFAULT '',
  `checks` longtext COLLATE [[utf8]]_bin,
  `operation` longtext COLLATE [[utf8]]_bin,
  `entity` varchar(256) COLLATE [[utf8]]_bin NOT NULL DEFAULT 'OCA\\WorkflowEngine\\Entity\\File',
  `events` longtext COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_flow_operations_scope`
--

CREATE TABLE `oc_flow_operations_scope` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `operation_id` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `value` varchar(64) COLLATE [[utf8]]_bin DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `flow_unique_scope` (`operation_id`,`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_groups`
--

CREATE TABLE `oc_groups` (
  `gid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `displayname` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT 'name',
  PRIMARY KEY (`gid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

--
-- Dumping data for table `oc_groups`
--

INSERT INTO `oc_groups` VALUES
('admin', 'admin');

-- --------------------------------------------------------

--
-- Table structure for table `oc_group_admin`
--

CREATE TABLE `oc_group_admin` (
  `gid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`gid`,`uid`),
  KEY `group_admin_uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_group_user`
--

CREATE TABLE `oc_group_user` (
  `gid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`gid`,`uid`),
  KEY `gu_uid_index` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

--
-- Dumping data for table `oc_group_user`
--

INSERT INTO `oc_group_user` VALUES
('admin', '[[admin_username]]');

-- --------------------------------------------------------

--
-- Table structure for table `oc_jobs`
--

CREATE TABLE `oc_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `argument` varchar(4000) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `last_run` int(11) DEFAULT '0',
  `last_checked` int(11) DEFAULT '0',
  `reserved_at` int(11) DEFAULT '0',
  `execution_duration` int(11) DEFAULT '0',
  `argument_hash` varchar(32) COLLATE [[utf8]]_bin DEFAULT NULL,
  `time_sensitive` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `job_class_index` (`class`),
  KEY `job_lastcheck_reserved` (`last_checked`,`reserved_at`),
  KEY `job_argument_hash` (`class`,`argument_hash`),
  KEY `jobs_time_sensitive` (`time_sensitive`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=33 ;

--
-- Dumping data for table `oc_jobs`
--

INSERT INTO `oc_jobs` VALUES
(1, 'OCA\\Files_Sharing\\DeleteOrphanedSharesJob', 'null', [[timestamp]], [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(2, 'OCA\\Files_Sharing\\ExpireSharesJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(3, 'OCA\\Files_Sharing\\BackgroundJob\\FederatedSharesDiscoverJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(4, 'OCA\\ServerInfo\\Jobs\\UpdateStorageStats', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(5, 'OCA\\Text\\Cron\\Cleanup', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(6, 'OCA\\Support\\BackgroundJobs\\CheckSubscription', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(7, 'OCA\\UpdateNotification\\Notification\\BackgroundJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(8, 'OCA\\Federation\\SyncJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(9, 'OCA\\NextcloudAnnouncements\\Cron\\Crawler', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(10, 'OCA\\DAV\\BackgroundJob\\CleanupDirectLinksJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(11, 'OCA\\DAV\\BackgroundJob\\UpdateCalendarResourcesRoomsBackgroundJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(12, 'OCA\\DAV\\BackgroundJob\\CleanupInvitationTokenJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(13, 'OCA\\DAV\\BackgroundJob\\EventReminderJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(14, 'OCA\\DAV\\BackgroundJob\\CalendarRetentionJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(15, 'OCA\\Files\\BackgroundJob\\ScanFiles', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(16, 'OCA\\Files\\BackgroundJob\\DeleteOrphanedItems', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(17, 'OCA\\Files\\BackgroundJob\\CleanupFileLocks', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(18, 'OCA\\Files\\BackgroundJob\\CleanupDirectEditingTokens', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(19, 'OCA\\Files_Trashbin\\BackgroundJob\\ExpireTrash', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(20, 'OCA\\WorkflowEngine\\BackgroundJobs\\Rotate', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(21, 'OCA\\Notifications\\BackgroundJob\\GenerateUserSettings', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(22, 'OCA\\Notifications\\BackgroundJob\\SendNotificationMails', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(23, 'OCA\\Files_Versions\\BackgroundJob\\ExpireVersions', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(24, 'OCA\\Activity\\BackgroundJob\\EmailNotification', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(25, 'OCA\\Activity\\BackgroundJob\\ExpireActivities', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(26, 'OCA\\Activity\\BackgroundJob\\DigestMail', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(27, 'OCA\\Circles\\Cron\\Maintenance', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(28, 'OCA\\ContactsInteraction\\BackgroundJob\\CleanupJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(29, 'OCA\\UserStatus\\BackgroundJob\\ClearOldStatusesBackgroundJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(30, 'OC\\Authentication\\Token\\DefaultTokenCleanupJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(31, 'OC\\Log\\Rotate', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1),
(32, 'OC\\Preview\\BackgroundCleanupJob', 'null', 0, [[timestamp]], 0, 0, '37a6259cc0c1dae299a7866489dff0bd', 1);

-- --------------------------------------------------------

--
-- Table structure for table `oc_known_users`
--

CREATE TABLE `oc_known_users` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `known_to` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `known_user` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ku_known_to` (`known_to`),
  KEY `ku_known_user` (`known_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_login_flow_v2`
--

CREATE TABLE `oc_login_flow_v2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` bigint(20) unsigned NOT NULL,
  `started` smallint(5) unsigned NOT NULL DEFAULT '0',
  `poll_token` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `login_token` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `public_key` text COLLATE [[utf8]]_bin NOT NULL,
  `private_key` text COLLATE [[utf8]]_bin NOT NULL,
  `client_name` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `login_name` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `server` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `app_password` varchar(1024) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `poll_token` (`poll_token`),
  UNIQUE KEY `login_token` (`login_token`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_migrations`
--

CREATE TABLE `oc_migrations` (
  `app` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `version` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`app`,`version`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

--
-- Dumping data for table `oc_migrations`
--

INSERT INTO `oc_migrations` VALUES
('activity', '2006Date20170808154933'),
('activity', '2006Date20170808155040'),
('activity', '2006Date20170919095939'),
('activity', '2007Date20181107114613'),
('activity', '2008Date20181011095117'),
('activity', '2010Date20190416112817'),
('activity', '2011Date20201006132544'),
('activity', '2011Date20201006132545'),
('activity', '2011Date20201006132546'),
('activity', '2011Date20201006132547'),
('activity', '2011Date20201207091915'),
('circles', '0022Date20220526111723'),
('circles', '0022Date20220526113601'),
('circles', '0022Date20220703115023'),
('circles', '0023Date20211216113101'),
('circles', '0024Date20220203123901'),
('circles', '0024Date20220203123902'),
('contactsinteraction', '010000Date20200304152605'),
('core', '13000Date20170705121758'),
('core', '13000Date20170718121200'),
('core', '13000Date20170814074715'),
('core', '13000Date20170919121250'),
('core', '13000Date20170926101637'),
('core', '14000Date20180129121024'),
('core', '14000Date20180404140050'),
('core', '14000Date20180516101403'),
('core', '14000Date20180518120534'),
('core', '14000Date20180522074438'),
('core', '14000Date20180626223656'),
('core', '14000Date20180710092004'),
('core', '14000Date20180712153140'),
('core', '15000Date20180926101451'),
('core', '15000Date20181015062942'),
('core', '15000Date20181029084625'),
('core', '16000Date20190207141427'),
('core', '16000Date20190212081545'),
('core', '16000Date20190427105638'),
('core', '16000Date20190428150708'),
('core', '17000Date20190514105811'),
('core', '18000Date20190920085628'),
('core', '18000Date20191014105105'),
('core', '18000Date20191204114856'),
('core', '19000Date20200211083441'),
('core', '20000Date20201109081915'),
('core', '20000Date20201109081918'),
('core', '20000Date20201109081919'),
('core', '20000Date20201111081915'),
('core', '21000Date20201120141228'),
('core', '21000Date20201202095923'),
('core', '21000Date20210119195004'),
('core', '21000Date20210309185126'),
('core', '21000Date20210309185127'),
('core', '22000Date20210216080825'),
('core', '23000Date20210721100600'),
('core', '23000Date20210906132259'),
('core', '23000Date20210930122352'),
('core', '23000Date20211203110726'),
('core', '23000Date20211213203940'),
('core', '24000Date20211213081506'),
('core', '24000Date20211213081604'),
('core', '24000Date20211230140012'),
('core', '24000Date20220131153041'),
('dav', '1004Date20170825134824'),
('dav', '1004Date20170919104507'),
('dav', '1004Date20170924124212'),
('dav', '1004Date20170926103422'),
('dav', '1005Date20180413093149'),
('dav', '1005Date20180530124431'),
('dav', '1006Date20180619154313'),
('dav', '1006Date20180628111625'),
('dav', '1008Date20181030113700'),
('dav', '1008Date20181105104826'),
('dav', '1008Date20181105104833'),
('dav', '1008Date20181105110300'),
('dav', '1008Date20181105112049'),
('dav', '1008Date20181114084440'),
('dav', '1011Date20190725113607'),
('dav', '1011Date20190806104428'),
('dav', '1012Date20190808122342'),
('dav', '1016Date20201109085907'),
('dav', '1017Date20210216083742'),
('dav', '1018Date20210312100735'),
('federatedfilesharing', '1010Date20200630191755'),
('federatedfilesharing', '1011Date20201120125158'),
('federation', '1010Date20200630191302'),
('files', '11301Date20191205150729'),
('files_sharing', '11300Date20201120141438'),
('files_sharing', '21000Date20201223143245'),
('files_sharing', '22000Date20210216084241'),
('files_trashbin', '1010Date20200630192639'),
('notifications', '2004Date20190107135757'),
('notifications', '2010Date20210218082811'),
('notifications', '2010Date20210218082855'),
('notifications', '2011Date20210930134607'),
('oauth2', '010401Date20181207190718'),
('oauth2', '010402Date20190107124745'),
('privacy', '100Date20190217131943'),
('text', '010000Date20190617184535'),
('text', '030001Date20200402075029'),
('text', '030201Date20201116110353'),
('text', '030201Date20201116123153'),
('text', '030401Date20220203141002'),
('twofactor_backupcodes', '1002Date20170607104347'),
('twofactor_backupcodes', '1002Date20170607113030'),
('twofactor_backupcodes', '1002Date20170919123342'),
('twofactor_backupcodes', '1002Date20170926101419'),
('twofactor_backupcodes', '1002Date20180821043638'),
('user_status', '0001Date20200602134824'),
('user_status', '0002Date20200902144824'),
('user_status', '1000Date20201111130204'),
('user_status', '2301Date20210809144824'),
('workflowengine', '2000Date20190808074233'),
('workflowengine', '2200Date20210805101925');

-- --------------------------------------------------------

--
-- Table structure for table `oc_mimetypes`
--

CREATE TABLE `oc_mimetypes` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mimetype` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mimetype_id_index` (`mimetype`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=21 ;

--
-- Dumping data for table `oc_mimetypes`
--

INSERT INTO `oc_mimetypes` VALUES
(3, 'application'),
(18, 'application/javascript'),
(4, 'application/json'),
(9, 'application/octet-stream'),
(5, 'application/pdf'),
(11, 'application/vnd.oasis.opendocument.presentation'),
(6, 'application/vnd.oasis.opendocument.spreadsheet'),
(10, 'application/vnd.oasis.opendocument.text'),
(17, 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'),
(19, 'application/x-gzip'),
(1, 'httpd'),
(2, 'httpd/unix-directory'),
(14, 'image'),
(16, 'image/jpeg'),
(15, 'image/png'),
(7, 'text'),
(20, 'text/css'),
(8, 'text/markdown'),
(12, 'video'),
(13, 'video/mp4');

-- --------------------------------------------------------

--
-- Table structure for table `oc_mounts`
--

CREATE TABLE `oc_mounts` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `storage_id` bigint(20) NOT NULL,
  `root_id` bigint(20) NOT NULL,
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `mount_point` varchar(4000) COLLATE [[utf8]]_bin NOT NULL,
  `mount_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mounts_user_root_index` (`user_id`,`root_id`),
  KEY `mounts_storage_index` (`storage_id`),
  KEY `mounts_root_index` (`root_id`),
  KEY `mounts_mount_id_index` (`mount_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=2 ;

--
-- Dumping data for table `oc_mounts`
--

INSERT INTO `oc_mounts` VALUES
(1, 2, 5, '[[admin_username]]', '/[[admin_username]]/', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `oc_notifications`
--

CREATE TABLE `oc_notifications` (
  `notification_id` int(11) NOT NULL AUTO_INCREMENT,
  `app` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `user` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `timestamp` int(11) NOT NULL DEFAULT '0',
  `object_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `object_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `subject` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `subject_parameters` longtext COLLATE [[utf8]]_bin,
  `message` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `message_parameters` longtext COLLATE [[utf8]]_bin,
  `link` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `icon` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `actions` longtext COLLATE [[utf8]]_bin,
  PRIMARY KEY (`notification_id`),
  KEY `oc_notifications_app` (`app`),
  KEY `oc_notifications_user` (`user`),
  KEY `oc_notifications_timestamp` (`timestamp`),
  KEY `oc_notifications_object` (`object_type`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_notifications_pushhash`
--

CREATE TABLE `oc_notifications_pushhash` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `token` int(11) NOT NULL DEFAULT '0',
  `deviceidentifier` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  `devicepublickey` varchar(512) COLLATE [[utf8]]_bin NOT NULL,
  `devicepublickeyhash` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  `pushtokenhash` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  `proxyserver` varchar(256) COLLATE [[utf8]]_bin NOT NULL,
  `apptype` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  UNIQUE KEY `oc_npushhash_uid` (`uid`,`token`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_notifications_settings`
--

CREATE TABLE `oc_notifications_settings` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `batch_time` int(11) NOT NULL DEFAULT '0',
  `last_send_id` bigint(20) NOT NULL DEFAULT '0',
  `next_send_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `notset_user` (`user_id`),
  KEY `notset_nextsend` (`next_send_time`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_oauth2_access_tokens`
--

CREATE TABLE `oc_oauth2_access_tokens` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `token_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `hashed_code` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  `encrypted_token` varchar(786) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `oauth2_access_hash_idx` (`hashed_code`),
  KEY `oauth2_access_client_id_idx` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_oauth2_clients`
--

CREATE TABLE `oc_oauth2_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `redirect_uri` varchar(2000) COLLATE [[utf8]]_bin NOT NULL,
  `client_identifier` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `secret` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `oauth2_client_id_idx` (`client_identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_preferences`
--

CREATE TABLE `oc_preferences` (
  `userid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `configkey` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `configvalue` longtext COLLATE [[utf8]]_bin,
  PRIMARY KEY (`userid`,`appid`,`configkey`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

--
-- Dumping data for table `oc_preferences`
--

INSERT INTO `oc_preferences` VALUES
('[[admin_username]]', 'core', 'lang', '[[language]]'),
('[[admin_username]]', 'core', 'templateDirectory', 'Templates/'),
('[[admin_username]]', 'login', 'lastLogin', '[[timestamp]]');

-- --------------------------------------------------------

--
-- Table structure for table `oc_privacy_admins`
--

CREATE TABLE `oc_privacy_admins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `displayname` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_profile_config`
--

CREATE TABLE `oc_profile_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `config` longtext COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile_config_user_id_idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_properties`
--

CREATE TABLE `oc_properties` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `propertypath` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `propertyname` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `propertyvalue` longtext COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `property_index` (`userid`),
  KEY `properties_path_index` (`userid`,`propertypath`),
  KEY `properties_pathonly_index` (`propertypath`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ratelimit_entries`
--

CREATE TABLE `oc_ratelimit_entries` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hash` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  `delete_after` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ratelimit_hash` (`hash`),
  KEY `ratelimit_delete_after` (`delete_after`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_recent_contact`
--

CREATE TABLE `oc_recent_contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `actor_uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `uid` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `email` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `federated_cloud_id` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `card` longblob NOT NULL,
  `last_contact` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `recent_contact_actor_uid` (`actor_uid`),
  KEY `recent_contact_id_uid` (`id`,`actor_uid`),
  KEY `recent_contact_uid` (`uid`),
  KEY `recent_contact_email` (`email`),
  KEY `recent_contact_fed_id` (`federated_cloud_id`),
  KEY `recent_contact_last_contact` (`last_contact`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_schedulingobjects`
--

CREATE TABLE `oc_schedulingobjects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `principaluri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `calendardata` longblob,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `lastmodified` int(10) unsigned DEFAULT NULL,
  `etag` varchar(32) COLLATE [[utf8]]_bin DEFAULT NULL,
  `size` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `schedulobj_principuri_index` (`principaluri`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_share`
--

CREATE TABLE `oc_share` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `share_type` smallint(6) NOT NULL DEFAULT '0',
  `share_with` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `password` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `uid_owner` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `uid_initiator` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `parent` bigint(20) DEFAULT NULL,
  `item_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `item_source` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `item_target` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `file_source` bigint(20) DEFAULT NULL,
  `file_target` varchar(512) COLLATE [[utf8]]_bin DEFAULT NULL,
  `permissions` smallint(6) NOT NULL DEFAULT '0',
  `stime` bigint(20) NOT NULL DEFAULT '0',
  `accepted` smallint(6) NOT NULL DEFAULT '0',
  `expiration` datetime DEFAULT NULL,
  `token` varchar(32) COLLATE [[utf8]]_bin DEFAULT NULL,
  `mail_send` smallint(6) NOT NULL DEFAULT '0',
  `share_name` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `password_by_talk` tinyint(1) DEFAULT '0',
  `note` longtext COLLATE [[utf8]]_bin,
  `hide_download` smallint(6) DEFAULT '0',
  `label` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_share_type_index` (`item_type`,`share_type`),
  KEY `file_source_index` (`file_source`),
  KEY `token_index` (`token`),
  KEY `share_with_index` (`share_with`),
  KEY `parent_index` (`parent`),
  KEY `owner_index` (`uid_owner`),
  KEY `initiator_index` (`uid_initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_share_external`
--

CREATE TABLE `oc_share_external` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `parent` bigint(20) DEFAULT '-1',
  `share_type` int(11) DEFAULT NULL,
  `remote` varchar(512) COLLATE [[utf8]]_bin NOT NULL,
  `remote_id` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `share_token` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `password` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `owner` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `user` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `mountpoint` varchar(4000) COLLATE [[utf8]]_bin NOT NULL,
  `mountpoint_hash` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `accepted` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sh_external_mp` (`user`,`mountpoint_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_storages`
--

CREATE TABLE `oc_storages` (
  `numeric_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `available` int(11) NOT NULL DEFAULT '1',
  `last_checked` int(11) DEFAULT NULL,
  PRIMARY KEY (`numeric_id`),
  UNIQUE KEY `storages_id_index` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=3 ;

--
-- Dumping data for table `oc_storages`
--

INSERT INTO `oc_storages` VALUES
(1, 'local::[[softdatadir]]/', 1, NULL),
(2, 'home::[[admin_username]]', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `oc_storages_credentials`
--

CREATE TABLE `oc_storages_credentials` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `identifier` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `credentials` longtext COLLATE [[utf8]]_bin,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stocred_ui` (`user`,`identifier`),
  KEY `stocred_user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_systemtag`
--

CREATE TABLE `oc_systemtag` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `visibility` smallint(6) NOT NULL DEFAULT '1',
  `editable` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag_ident` (`name`,`visibility`,`editable`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_systemtag_group`
--

CREATE TABLE `oc_systemtag_group` (
  `systemtagid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `gid` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`gid`,`systemtagid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_systemtag_object_mapping`
--

CREATE TABLE `oc_systemtag_object_mapping` (
  `objectid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `objecttype` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `systemtagid` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`objecttype`,`objectid`,`systemtagid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_text_documents`
--

CREATE TABLE `oc_text_documents` (
  `id` bigint(20) unsigned NOT NULL,
  `current_version` bigint(20) unsigned DEFAULT '0',
  `last_saved_version` bigint(20) unsigned DEFAULT '0',
  `last_saved_version_time` bigint(20) unsigned NOT NULL,
  `last_saved_version_etag` varchar(64) COLLATE [[utf8]]_bin DEFAULT '',
  `base_version_etag` varchar(64) COLLATE [[utf8]]_bin DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_text_sessions`
--

CREATE TABLE `oc_text_sessions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `guest_name` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `color` varchar(7) COLLATE [[utf8]]_bin DEFAULT NULL,
  `token` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `document_id` bigint(20) NOT NULL,
  `last_contact` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rd_session_token_idx` (`token`),
  KEY `ts_lastcontact` (`last_contact`),
  KEY `ts_docid_lastcontact` (`document_id`,`last_contact`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_text_steps`
--

CREATE TABLE `oc_text_steps` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` bigint(20) unsigned NOT NULL,
  `session_id` bigint(20) unsigned NOT NULL,
  `data` longtext COLLATE [[utf8]]_bin NOT NULL,
  `version` bigint(20) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `rd_steps_did_idx` (`document_id`),
  KEY `rd_steps_version_idx` (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_trusted_servers`
--

CREATE TABLE `oc_trusted_servers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(512) COLLATE [[utf8]]_bin NOT NULL,
  `url_hash` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `token` varchar(128) COLLATE [[utf8]]_bin DEFAULT NULL,
  `shared_secret` varchar(256) COLLATE [[utf8]]_bin DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '2',
  `sync_token` varchar(512) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `url_hash` (`url_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_twofactor_backupcodes`
--

CREATE TABLE `oc_twofactor_backupcodes` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `code` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  `used` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `twofactor_backupcodes_uid` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_twofactor_providers`
--

CREATE TABLE `oc_twofactor_providers` (
  `provider_id` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `enabled` smallint(6) NOT NULL,
  PRIMARY KEY (`provider_id`,`uid`),
  KEY `twofactor_providers_uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

--
-- Dumping data for table `oc_twofactor_providers`
--

INSERT INTO `oc_twofactor_providers` VALUES
('backup_codes', '[[admin_username]]', 0);

-- --------------------------------------------------------

--
-- Table structure for table `oc_users`
--

CREATE TABLE `oc_users` (
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `displayname` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `password` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `uid_lower` varchar(64) COLLATE [[utf8]]_bin DEFAULT '',
  PRIMARY KEY (`uid`),
  KEY `user_uid_lower` (`uid_lower`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

--
-- Dumping data for table `oc_users`
--

INSERT INTO `oc_users` VALUES
('[[admin_username]]', NULL, '[[admin_pass]]', '[[admin_username_lower]]');

-- --------------------------------------------------------

--
-- Table structure for table `oc_user_status`
--

CREATE TABLE `oc_user_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `status` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `status_timestamp` int(10) unsigned NOT NULL,
  `is_user_defined` tinyint(1) DEFAULT NULL,
  `message_id` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `custom_icon` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `custom_message` longtext COLLATE [[utf8]]_bin,
  `clear_at` int(10) unsigned DEFAULT NULL,
  `is_backup` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_status_uid_ix` (`user_id`),
  KEY `user_status_clr_ix` (`clear_at`),
  KEY `user_status_tstmp_ix` (`status_timestamp`),
  KEY `user_status_iud_ix` (`is_user_defined`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_user_transfer_owner`
--

CREATE TABLE `oc_user_transfer_owner` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `source_user` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `target_user` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `file_id` bigint(20) NOT NULL,
  `node_name` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_vcategory`
--

CREATE TABLE `oc_vcategory` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `category` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uid_index` (`uid`),
  KEY `type_index` (`type`),
  KEY `category_index` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_vcategory_to_object`
--

CREATE TABLE `oc_vcategory_to_object` (
  `objid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `categoryid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`categoryid`,`objid`,`type`),
  KEY `vcategory_objectd_index` (`objid`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]];

-- --------------------------------------------------------

--
-- Table structure for table `oc_webauthn`
--

CREATE TABLE `oc_webauthn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `public_key_credential_id` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `data` longtext COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `webauthn_uid` (`uid`),
  KEY `webauthn_publicKeyCredentialId` (`public_key_credential_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_whats_new`
--

CREATE TABLE `oc_whats_new` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '11',
  `etag` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `last_check` int(10) unsigned NOT NULL DEFAULT '0',
  `data` longtext COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `version` (`version`),
  KEY `version_etag_idx` (`version`,`etag`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin[[row_format]] AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
