
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `myt151`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]android_udid`
--

CREATE TABLE `[[dbprefix]]android_udid` (
  `user_name` varchar(255) NOT NULL,
  `registration_id` varchar(255) NOT NULL,
  PRIMARY KEY (`registration_id`),
  KEY `[[dbprefix]]user_name` (`user_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attachment`
--

CREATE TABLE `[[dbprefix]]attachment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(30) DEFAULT NULL,
  `uri` text,
  `created` date DEFAULT NULL,
  `task_id` int(11) DEFAULT NULL,
  `project_id` int(11) DEFAULT NULL,
  `mega_id` char(8) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mega_id` (`mega_id`),
  KEY `[[dbprefix]]task_id` (`task_id`),
  KEY `[[dbprefix]]project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_assignment`
--

CREATE TABLE `[[dbprefix]]auth_assignment` (
  `itemname` varchar(255) NOT NULL,
  `userid` varchar(255) NOT NULL,
  `bizrule` text,
  `data` text,
  PRIMARY KEY (`itemname`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]auth_assignment`
--

INSERT INTO `[[dbprefix]]auth_assignment` VALUES
('Application Manager', '1', NULL, 'N;'),
('Developer', '1', NULL, 'N;'),
('Project Manager', '1', NULL, 'N;'),
('Role Manager', '1', NULL, 'N;'),
('Task Manager', '1', NULL, 'N;'),
('User Manager', '1', NULL, 'N;');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_item`
--

CREATE TABLE `[[dbprefix]]auth_item` (
  `name` varchar(255) NOT NULL,
  `type` int(11) NOT NULL,
  `description` text,
  `bizrule` text,
  `data` text,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]auth_item`
--

INSERT INTO `[[dbprefix]]auth_item` VALUES
('adminAllCharge', 0, 'Charge Admin All', NULL, 'N;'),
('adminCharge', 0, 'Charge Admin', NULL, 'N;'),
('adminConfig', 0, 'Application Configuration Management', NULL, 'N;'),
('adminRole', 0, 'Roles Configuration Management', NULL, 'N;'),
('Application Manager', 2, '', NULL, 'N;'),
('createCharge', 0, 'Charge Create', NULL, 'N;'),
('createProject', 0, 'Project Create', NULL, 'N;'),
('createTask', 0, 'Task Create', NULL, 'N;'),
('createUser', 0, 'User Create', NULL, 'N;'),
('deleteProject', 0, 'Project Delete', NULL, 'N;'),
('deleteTask', 0, 'Task Delete', NULL, 'N;'),
('deleteUser', 0, 'User Delete', NULL, 'N;'),
('Developer', 2, '', NULL, 'N;'),
('indexAllProject', 0, 'Project View All', NULL, 'N;'),
('indexAllTask', 0, 'Task View All', NULL, 'N;'),
('indexAllUser', 0, 'User View All', NULL, 'N;'),
('Project Manager', 2, '', NULL, 'N;'),
('Role Manager', 2, '', NULL, 'N;'),
('Task Manager', 2, '', NULL, 'N;'),
('updateProject', 0, 'Project Update', NULL, 'N;'),
('updateTask', 0, 'Task Update', NULL, 'N;'),
('updateUser', 0, 'User Update', NULL, 'N;'),
('User Manager', 2, '', NULL, 'N;');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_item_child`
--

CREATE TABLE `[[dbprefix]]auth_item_child` (
  `parent` varchar(255) NOT NULL,
  `child` varchar(255) NOT NULL,
  PRIMARY KEY (`parent`,`child`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]auth_item_child`
--

INSERT INTO `[[dbprefix]]auth_item_child` VALUES
('Application Manager', 'adminAllCharge'),
('Application Manager', 'adminConfig'),
('Developer', 'createCharge'),
('Developer', 'createTask'),
('Developer', 'deleteTask'),
('Developer', 'updateTask'),
('Project Manager', 'adminCharge'),
('Project Manager', 'createCharge'),
('Project Manager', 'createProject'),
('Project Manager', 'deleteProject'),
('Project Manager', 'indexAllProject'),
('Project Manager', 'updateProject'),
('Role Manager', 'adminRole'),
('Task Manager', 'createTask'),
('Task Manager', 'deleteTask'),
('Task Manager', 'indexAllTask'),
('Task Manager', 'updateTask'),
('User Manager', 'createUser'),
('User Manager', 'deleteUser'),
('User Manager', 'updateUser');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]charge`
--

CREATE TABLE `[[dbprefix]]charge` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `last_upd` datetime DEFAULT NULL,
  `last_upd_by` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `project_id` int(11) DEFAULT NULL,
  `task_id` int(11) DEFAULT NULL,
  `day` date DEFAULT NULL,
  `hours` float DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]created_by` (`created_by`),
  KEY `[[dbprefix]]last_upd_by` (`last_upd_by`),
  KEY `[[dbprefix]]user_id` (`user_id`),
  KEY `[[dbprefix]]project_id_charge` (`project_id`),
  KEY `[[dbprefix]]task_id_charge` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comment`
--

CREATE TABLE `[[dbprefix]]comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `last_upd` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `last_upd_by` int(11) DEFAULT NULL,
  `entity` varchar(255) NOT NULL,
  `entity_id` int(11) NOT NULL,
  `body` text,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]counter_save`
--

CREATE TABLE `[[dbprefix]]counter_save` (
  `save_name` varchar(10) NOT NULL,
  `save_value` int(11) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]counter_users`
--

CREATE TABLE `[[dbprefix]]counter_users` (
  `user_ip` varchar(39) NOT NULL,
  `user_time` int(11) unsigned NOT NULL,
  UNIQUE KEY `user_ip` (`user_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project`
--

CREATE TABLE `[[dbprefix]]project` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `last_upd` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `last_upd_by` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `prefix` varchar(3) DEFAULT NULL,
  `description` text,
  `champion_id` int(11) DEFAULT NULL,
  `status` varchar(3) DEFAULT NULL,
  `progress` smallint(5) unsigned DEFAULT NULL,
  `par_project_id` int(11) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `eff_start_date` date DEFAULT NULL,
  `eff_end_date` date DEFAULT NULL,
  `client` tinytext,
  `chargeable_flg` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]par_project` (`par_project_id`),
  KEY `[[dbprefix]]champion` (`champion_id`),
  KEY `[[dbprefix]]created_by_project` (`created_by`),
  KEY `[[dbprefix]]status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]project`
--

INSERT INTO `[[dbprefix]]project` VALUES
(1, '[[regtime]]', 1, '[[regtime]]', 1, 'Courses', '--0', NULL, 1, '4', 0, NULL, NULL, NULL, NULL, NULL, NULL, 1),
(2, '[[regtime]]', 1, '[[regtime]]', 1, 'Vacation', '--1', NULL, 1, '4', 0, NULL, NULL, NULL, NULL, NULL, NULL, 1),
(3, '[[regtime]]', 1, '[[regtime]]', 1, 'Public Holiday', '--2', NULL, 1, '4', 0, NULL, NULL, NULL, NULL, NULL, NULL, 1),
(4, '[[regtime]]', 1, '[[regtime]]', 1, 'Sick-leave', '--3', NULL, 1, '4', 0, NULL, NULL, NULL, NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]session`
--

CREATE TABLE `[[dbprefix]]session` (
  `id` char(32) NOT NULL,
  `user_id` int(11) unsigned NOT NULL,
  `expire` int(11) DEFAULT NULL,
  `data` longblob,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]user_id_session` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task`
--

CREATE TABLE `[[dbprefix]]task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `last_upd` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `last_upd_by` int(11) DEFAULT NULL,
  `par_project_id` int(11) NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `description` text,
  `status` int(11) DEFAULT NULL,
  `progress` smallint(5) unsigned DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `eff_start_date` date DEFAULT NULL,
  `eff_end_date` date DEFAULT NULL,
  `priority` smallint(6) DEFAULT NULL,
  `type` smallint(6) DEFAULT NULL,
  `private_flg` tinyint(1) NOT NULL DEFAULT '0',
  `chargeable_flg` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]task_ibfk_3` (`parent_id`),
  KEY `[[dbprefix]]task_ibfk_2` (`created_by`),
  KEY `[[dbprefix]]task_ibfk_1` (`par_project_id`),
  KEY `[[dbprefix]]title` (`title`,`par_project_id`),
  KEY `[[dbprefix]]status_task` (`status`),
  KEY `[[dbprefix]]type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task_status`
--

CREATE TABLE `[[dbprefix]]task_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `group_id` int(11) unsigned NOT NULL,
  `order_by` int(11) unsigned NOT NULL,
  `default_flg` tinyint(1) DEFAULT NULL,
  `active_flg` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]task_status`
--

INSERT INTO `[[dbprefix]]task_status` VALUES
(1, 'Open', 0, 0, 1, 1),
(2, 'Working On', 0, 1, 0, 1),
(3, 'Suspended', 2, 2, 0, 1),
(4, 'Closed', 1, 3, 0, 1),
(5, 'Cancelled', 1, 4, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task_type`
--

CREATE TABLE `[[dbprefix]]task_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `order_by` int(11) unsigned NOT NULL,
  `default_flg` tinyint(1) DEFAULT NULL,
  `active_flg` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]task_type`
--

INSERT INTO `[[dbprefix]]task_type` VALUES
(1, 'Bug', 0, 0, 1),
(2, 'Enhancement', 1, 0, 1),
(3, 'Task', 2, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user`
--

CREATE TABLE `[[dbprefix]]user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `last_upd` datetime NOT NULL,
  `last_upd_by` int(11) NOT NULL DEFAULT '1',
  `username` varchar(255) NOT NULL,
  `password` varchar(64) NOT NULL,
  `email` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `name` varchar(63) DEFAULT NULL,
  `surname` varchar(63) DEFAULT NULL,
  `gender` char(1) NOT NULL,
  `level` varchar(63) DEFAULT NULL,
  `phone` varchar(63) DEFAULT NULL,
  `mobile` varchar(63) DEFAULT NULL,
  `load_cost` float(7,3) DEFAULT NULL,
  `bill_code` smallint(6) DEFAULT NULL,
  `seat_charge` float(7,3) DEFAULT NULL,
  `daily_hours` float(3,1) DEFAULT NULL,
  `profile_id` int(11) DEFAULT NULL,
  `note` text,
  `confirm_key` varchar(40) DEFAULT NULL,
  `avatar` text,
  `page_size` tinyint(4) DEFAULT NULL,
  `notifications` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `[[dbprefix]]profile` (`profile_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]user`
--

INSERT INTO `[[dbprefix]]user` VALUES
(1, '[[regtime]]', 1, '[[regtime]]', 1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', 1, 'Admin', 'Admin', 'M', NULL, NULL, NULL, NULL, NULL, NULL, 8.0, NULL, NULL, NULL, NULL, NULL, 'N;');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_project`
--

CREATE TABLE `[[dbprefix]]user_project` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `last_upd` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` int(11) NOT NULL,
  `project_id` int(11) NOT NULL,
  `rollon_date` date DEFAULT NULL,
  `rolloff_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`project_id`),
  KEY `[[dbprefix]]user_project_ibfk_2` (`project_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]user_project`
--

INSERT INTO `[[dbprefix]]user_project` VALUES
(1, '[[regtime]]', '[[regtime]]', 1, 1, '[[date]]', NULL),
(2, '[[regtime]]', '[[regtime]]', 1, 2, '[[date]]', NULL),
(3, '[[regtime]]', '[[regtime]]', 1, 3, '[[date]]', NULL),
(4, '[[regtime]]', '[[regtime]]', 1, 4, '[[date]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_task`
--

CREATE TABLE `[[dbprefix]]user_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `last_upd` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` int(11) NOT NULL,
  `task_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`task_id`),
  KEY `[[dbprefix]]user_task_ibfk_2` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
