#!/opt/imh-python/bin/python3
"""Move cpanel backups to and from /home"""
from pathlib import Path
import argparse
import shlex
import sys

sys.path.insert(0, '/opt/support/lib')
from arg_types import cpmove_file_type, path_in_home


def parse_args() -> tuple[Path, Path]:
    """Validate and return source and destination paths"""
    parser = argparse.ArgumentParser(description=__doc__)
    parser.add_argument(
        'src',
        metavar='SOURCE',
        type=cpmove_file_type,
        help='cPanel backup file',
    )
    parser.add_argument(
        'dst',
        metavar='DESTINATION',
        type=path_in_home,
        help='destination folder',
    )
    args = parser.parse_args()
    return args.src, args.dst


def main():
    """Validate input, then move a cpanel backup in or out of /home"""
    source, dest_dir = parse_args()
    dest = dest_dir.joinpath(source.name)
    # perform the move
    try:
        print(shlex.quote(str(source)), '->', shlex.quote(str(dest)))
        source.rename(dest)
    except OSError as exc:
        sys.exit(exc)


if __name__ == '__main__':
    main()
