
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_mt5213`
--

-- --------------------------------------------------------

--
-- Table structure for table `mt_asset`
--

CREATE TABLE `mt_asset` (
  `asset_id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_blog_id` int(11) NOT NULL,
  `asset_class` varchar(255) DEFAULT 'file',
  `asset_created_by` int(11) DEFAULT NULL,
  `asset_created_on` datetime DEFAULT NULL,
  `asset_description` mediumtext,
  `asset_file_ext` varchar(20) DEFAULT NULL,
  `asset_file_name` varchar(255) DEFAULT NULL,
  `asset_file_path` varchar(255) DEFAULT NULL,
  `asset_label` varchar(255) DEFAULT NULL,
  `asset_mime_type` varchar(255) DEFAULT NULL,
  `asset_modified_by` int(11) DEFAULT NULL,
  `asset_modified_on` datetime DEFAULT NULL,
  `asset_parent` int(11) DEFAULT NULL,
  `asset_url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`asset_id`),
  KEY `mt_asset_blog_class_date` (`asset_blog_id`,`asset_class`,`asset_created_on`),
  KEY `mt_asset_parent` (`asset_parent`),
  KEY `mt_asset_file_ext` (`asset_file_ext`),
  KEY `mt_asset_created_on` (`asset_created_on`),
  KEY `mt_asset_class` (`asset_class`),
  KEY `mt_asset_label` (`asset_label`),
  KEY `mt_asset_created_by` (`asset_created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_asset_meta`
--

CREATE TABLE `mt_asset_meta` (
  `asset_meta_asset_id` int(11) NOT NULL,
  `asset_meta_type` varchar(75) NOT NULL,
  `asset_meta_vchar` varchar(255) DEFAULT NULL,
  `asset_meta_vchar_idx` varchar(255) DEFAULT NULL,
  `asset_meta_vdatetime` datetime DEFAULT NULL,
  `asset_meta_vdatetime_idx` datetime DEFAULT NULL,
  `asset_meta_vinteger` int(11) DEFAULT NULL,
  `asset_meta_vinteger_idx` int(11) DEFAULT NULL,
  `asset_meta_vfloat` float DEFAULT NULL,
  `asset_meta_vfloat_idx` float DEFAULT NULL,
  `asset_meta_vblob` mediumblob,
  `asset_meta_vclob` mediumtext,
  PRIMARY KEY (`asset_meta_asset_id`,`asset_meta_type`),
  KEY `mt_asset_meta_type_vint` (`asset_meta_type`,`asset_meta_vinteger_idx`),
  KEY `mt_asset_meta_type_vflt` (`asset_meta_type`,`asset_meta_vfloat_idx`),
  KEY `mt_asset_meta_type_vdt` (`asset_meta_type`,`asset_meta_vdatetime_idx`),
  KEY `mt_asset_meta_type_vchar` (`asset_meta_type`,`asset_meta_vchar_idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `mt_association`
--

CREATE TABLE `mt_association` (
  `association_id` int(11) NOT NULL AUTO_INCREMENT,
  `association_author_id` int(11) DEFAULT '0',
  `association_blog_id` int(11) DEFAULT '0',
  `association_created_by` int(11) DEFAULT NULL,
  `association_created_on` datetime DEFAULT NULL,
  `association_group_id` int(11) DEFAULT '0',
  `association_modified_by` int(11) DEFAULT NULL,
  `association_modified_on` datetime DEFAULT NULL,
  `association_role_id` int(11) DEFAULT '0',
  `association_type` int(11) NOT NULL,
  PRIMARY KEY (`association_id`),
  KEY `mt_association_author_id` (`association_author_id`),
  KEY `mt_association_group_id` (`association_group_id`),
  KEY `mt_association_created_on` (`association_created_on`),
  KEY `mt_association_type` (`association_type`),
  KEY `mt_association_blog_id` (`association_blog_id`),
  KEY `mt_association_role_id` (`association_role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `mt_association`
--

INSERT INTO `mt_association` VALUES
(1, 1, 1, 1, '[[regtime]]', 0, NULL, '[[regtime]]', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `mt_author`
--

CREATE TABLE `mt_author` (
  `author_id` int(11) NOT NULL AUTO_INCREMENT,
  `author_api_password` varchar(60) DEFAULT NULL,
  `author_auth_type` varchar(50) DEFAULT NULL,
  `author_basename` varchar(255) DEFAULT NULL,
  `author_can_create_blog` tinyint(4) DEFAULT NULL,
  `author_can_view_log` tinyint(4) DEFAULT NULL,
  `author_created_by` int(11) DEFAULT NULL,
  `author_created_on` datetime DEFAULT NULL,
  `author_date_format` varchar(30) DEFAULT 'relative',
  `author_email` varchar(127) DEFAULT NULL,
  `author_entry_prefs` varchar(255) DEFAULT NULL,
  `author_external_id` varchar(255) DEFAULT NULL,
  `author_hint` varchar(75) DEFAULT NULL,
  `author_is_superuser` tinyint(4) DEFAULT NULL,
  `author_locked_out_time` int(11) NOT NULL DEFAULT '0',
  `author_modified_by` int(11) DEFAULT NULL,
  `author_modified_on` datetime DEFAULT NULL,
  `author_name` varchar(255) NOT NULL,
  `author_nickname` varchar(255) DEFAULT NULL,
  `author_password` varchar(124) NOT NULL,
  `author_preferred_language` varchar(50) DEFAULT NULL,
  `author_public_key` mediumtext,
  `author_remote_auth_token` varchar(50) DEFAULT NULL,
  `author_remote_auth_username` varchar(50) DEFAULT NULL,
  `author_status` int(11) DEFAULT '1',
  `author_text_format` varchar(30) DEFAULT NULL,
  `author_type` smallint(6) NOT NULL DEFAULT '1',
  `author_url` varchar(255) DEFAULT NULL,
  `author_userpic_asset_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`author_id`),
  KEY `mt_author_auth_type_name` (`author_auth_type`,`author_name`,`author_type`),
  KEY `mt_author_locked_out_time` (`author_locked_out_time`),
  KEY `mt_author_status` (`author_status`),
  KEY `mt_author_name` (`author_name`),
  KEY `mt_author_basename` (`author_basename`),
  KEY `mt_author_email` (`author_email`),
  KEY `mt_author_external_id` (`author_external_id`),
  KEY `mt_author_created_on` (`author_created_on`),
  KEY `mt_author_type` (`author_type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `mt_author`
--

INSERT INTO `mt_author` VALUES
(1, '[[author_api_password]]', 'MT', '[[admin_basename]]', NULL, NULL, 1, '[[regtime]]', 'relative', '[[admin_email]]', NULL, '', NULL, NULL, 0, NULL, '[[regtime]]', '[[admin_username]]', '[[admin_fname]][[admin_lname]]', '[[admin_pass]]', 'en-us', NULL, NULL, NULL, 1, NULL, 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mt_author_meta`
--

CREATE TABLE `mt_author_meta` (
  `author_meta_author_id` int(11) NOT NULL,
  `author_meta_type` varchar(75) NOT NULL,
  `author_meta_vchar` varchar(255) DEFAULT NULL,
  `author_meta_vchar_idx` varchar(255) DEFAULT NULL,
  `author_meta_vdatetime` datetime DEFAULT NULL,
  `author_meta_vdatetime_idx` datetime DEFAULT NULL,
  `author_meta_vinteger` int(11) DEFAULT NULL,
  `author_meta_vinteger_idx` int(11) DEFAULT NULL,
  `author_meta_vfloat` float DEFAULT NULL,
  `author_meta_vfloat_idx` float DEFAULT NULL,
  `author_meta_vblob` mediumblob,
  `author_meta_vclob` mediumtext,
  PRIMARY KEY (`author_meta_author_id`,`author_meta_type`),
  KEY `mt_author_meta_type_vint` (`author_meta_type`,`author_meta_vinteger_idx`),
  KEY `mt_author_meta_type_vflt` (`author_meta_type`,`author_meta_vfloat_idx`),
  KEY `mt_author_meta_type_vdt` (`author_meta_type`,`author_meta_vdatetime_idx`),
  KEY `mt_author_meta_type_vchar` (`author_meta_type`,`author_meta_vchar_idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `mt_author_meta`
--

INSERT INTO `mt_author_meta` VALUES
(1, 'favorite_websites', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'BIN:SERG\0\0\0\0\0\0\0A\0\0\0-\0\0\01', NULL),
(1, 'widgets', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'BIN:SERG\0\0\0\0\0\0\0H\0\0\0\0\0\0dashboard:user:1H\0\0\0\0\0\0\rthis_is_you-1H\0\0\0\0\0\0order-\0\0\01\0\0\0set-\0\0\0main\0\0\0favorite_blogsH\0\0\0\0\0\0order-\0\0\02\0\0\0paramH\0\0\0\0\0\0tab-\0\0\0website\0\0\0set-\0\0\0main\0\0\0mt_newsH\0\0\0\0\0\0order-\0\0\03\0\0\0set-\0\0\0sidebar', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mt_author_summary`
--

CREATE TABLE `mt_author_summary` (
  `author_summary_author_id` int(11) NOT NULL,
  `author_summary_type` varchar(75) NOT NULL,
  `author_summary_class` varchar(75) NOT NULL,
  `author_summary_vchar_idx` varchar(255) DEFAULT NULL,
  `author_summary_vinteger_idx` int(11) DEFAULT NULL,
  `author_summary_vblob` mediumblob,
  `author_summary_vclob` mediumtext,
  `author_summary_expired` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`author_summary_author_id`,`author_summary_type`),
  KEY `mt_author_summary_class_vint` (`author_summary_class`,`author_summary_vinteger_idx`),
  KEY `mt_author_summary_id_class` (`author_summary_author_id`,`author_summary_class`),
  KEY `mt_author_summary_class_vchar` (`author_summary_class`,`author_summary_vchar_idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `mt_blog`
--

CREATE TABLE `mt_blog` (
  `blog_id` int(11) NOT NULL AUTO_INCREMENT,
  `blog_allow_anon_comments` tinyint(4) DEFAULT NULL,
  `blog_allow_comment_html` tinyint(4) DEFAULT NULL,
  `blog_allow_commenter_regist` tinyint(4) DEFAULT NULL,
  `blog_allow_comments_default` tinyint(4) DEFAULT NULL,
  `blog_allow_pings` tinyint(4) DEFAULT NULL,
  `blog_allow_pings_default` tinyint(4) DEFAULT NULL,
  `blog_allow_reg_comments` tinyint(4) DEFAULT NULL,
  `blog_allow_unreg_comments` tinyint(4) DEFAULT NULL,
  `blog_archive_path` varchar(255) DEFAULT NULL,
  `blog_archive_tmpl_category` varchar(255) DEFAULT NULL,
  `blog_archive_tmpl_daily` varchar(255) DEFAULT NULL,
  `blog_archive_tmpl_individual` varchar(255) DEFAULT NULL,
  `blog_archive_tmpl_monthly` varchar(255) DEFAULT NULL,
  `blog_archive_tmpl_weekly` varchar(255) DEFAULT NULL,
  `blog_archive_type` varchar(255) DEFAULT NULL,
  `blog_archive_type_preferred` varchar(25) DEFAULT NULL,
  `blog_archive_url` varchar(255) DEFAULT NULL,
  `blog_autodiscover_links` tinyint(4) DEFAULT NULL,
  `blog_autolink_urls` tinyint(4) DEFAULT NULL,
  `blog_basename_limit` smallint(6) DEFAULT NULL,
  `blog_cc_license` varchar(255) DEFAULT NULL,
  `blog_children_modified_on` datetime DEFAULT NULL,
  `blog_class` varchar(255) DEFAULT 'blog',
  `blog_content_css` varchar(255) DEFAULT NULL,
  `blog_convert_paras` varchar(30) DEFAULT NULL,
  `blog_convert_paras_comments` varchar(30) DEFAULT NULL,
  `blog_created_by` int(11) DEFAULT NULL,
  `blog_created_on` datetime DEFAULT NULL,
  `blog_custom_dynamic_templates` varchar(25) DEFAULT 'none',
  `blog_date_language` varchar(5) DEFAULT NULL,
  `blog_days_on_index` int(11) DEFAULT NULL,
  `blog_description` mediumtext,
  `blog_email_new_comments` tinyint(4) DEFAULT NULL,
  `blog_email_new_pings` tinyint(4) DEFAULT NULL,
  `blog_entries_on_index` int(11) DEFAULT NULL,
  `blog_file_extension` varchar(10) DEFAULT NULL,
  `blog_google_api_key` varchar(32) DEFAULT NULL,
  `blog_internal_autodiscovery` tinyint(4) DEFAULT NULL,
  `blog_is_dynamic` tinyint(4) DEFAULT NULL,
  `blog_junk_folder_expiry` int(11) DEFAULT NULL,
  `blog_junk_score_threshold` float DEFAULT NULL,
  `blog_language` varchar(5) DEFAULT NULL,
  `blog_manual_approve_commenters` tinyint(4) DEFAULT NULL,
  `blog_moderate_pings` tinyint(4) DEFAULT NULL,
  `blog_moderate_unreg_comments` tinyint(4) DEFAULT NULL,
  `blog_modified_by` int(11) DEFAULT NULL,
  `blog_modified_on` datetime DEFAULT NULL,
  `blog_mt_update_key` varchar(30) DEFAULT NULL,
  `blog_name` varchar(255) NOT NULL,
  `blog_old_style_archive_links` tinyint(4) DEFAULT NULL,
  `blog_parent_id` int(11) DEFAULT NULL,
  `blog_ping_blogs` tinyint(4) DEFAULT NULL,
  `blog_ping_google` tinyint(4) DEFAULT NULL,
  `blog_ping_others` mediumtext,
  `blog_ping_technorati` tinyint(4) DEFAULT NULL,
  `blog_ping_weblogs` tinyint(4) DEFAULT NULL,
  `blog_remote_auth_token` varchar(50) DEFAULT NULL,
  `blog_require_comment_emails` tinyint(4) DEFAULT NULL,
  `blog_sanitize_spec` varchar(255) DEFAULT NULL,
  `blog_server_offset` float DEFAULT NULL,
  `blog_site_path` varchar(255) DEFAULT NULL,
  `blog_site_url` varchar(255) DEFAULT NULL,
  `blog_sort_order_comments` varchar(8) DEFAULT NULL,
  `blog_sort_order_posts` varchar(8) DEFAULT NULL,
  `blog_status_default` smallint(6) DEFAULT NULL,
  `blog_theme_id` varchar(255) DEFAULT NULL,
  `blog_use_comment_confirmation` tinyint(4) DEFAULT NULL,
  `blog_use_revision` tinyint(4) DEFAULT NULL,
  `blog_welcome_msg` mediumtext,
  `blog_words_in_excerpt` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`blog_id`),
  KEY `mt_blog_name` (`blog_name`),
  KEY `mt_blog_class` (`blog_class`),
  KEY `mt_blog_parent_id` (`blog_parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `mt_blog`
--

INSERT INTO `mt_blog` VALUES
(1, NULL, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'Page', '', NULL, NULL, 1, 100, NULL, '[[regtime]]', 'website', NULL, 'richtext', '1', 1, '[[regtime]]', 'none', 'en-us', 0, '[[site_desc]]', 1, 1, 10, 'html', NULL, 0, NULL, 14, 0, 'en-us', NULL, 1, 2, NULL, '[[regtime]]', NULL, '[[site_name]]', NULL, NULL, 0, 0, NULL, 0, 0, NULL, 0, '0', 0, '[[wwwdir]]', '[[wwwurl]]/', 'ascend', 'descend', 2, 'classic_website', 1, 1, NULL, 40);

-- --------------------------------------------------------

--
-- Table structure for table `mt_blog_meta`
--

CREATE TABLE `mt_blog_meta` (
  `blog_meta_blog_id` int(11) NOT NULL,
  `blog_meta_type` varchar(75) NOT NULL,
  `blog_meta_vchar` varchar(255) DEFAULT NULL,
  `blog_meta_vchar_idx` varchar(255) DEFAULT NULL,
  `blog_meta_vdatetime` datetime DEFAULT NULL,
  `blog_meta_vdatetime_idx` datetime DEFAULT NULL,
  `blog_meta_vinteger` int(11) DEFAULT NULL,
  `blog_meta_vinteger_idx` int(11) DEFAULT NULL,
  `blog_meta_vfloat` float DEFAULT NULL,
  `blog_meta_vfloat_idx` float DEFAULT NULL,
  `blog_meta_vblob` mediumblob,
  `blog_meta_vclob` mediumtext,
  PRIMARY KEY (`blog_meta_blog_id`,`blog_meta_type`),
  KEY `mt_blog_meta_type_vint` (`blog_meta_type`,`blog_meta_vinteger_idx`),
  KEY `mt_blog_meta_type_vflt` (`blog_meta_type`,`blog_meta_vfloat_idx`),
  KEY `mt_blog_meta_type_vdt` (`blog_meta_type`,`blog_meta_vdatetime_idx`),
  KEY `mt_blog_meta_type_vchar` (`blog_meta_type`,`blog_meta_vchar_idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `mt_blog_meta`
--

INSERT INTO `mt_blog_meta` VALUES
(1, 'commenter_authenticators', 'MovableType,LiveJournal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(1, 'follow_auth_links', NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL),
(1, 'nofollow_urls', NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL),
(1, 'page_layout', 'layout-wtt', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mt_category`
--

CREATE TABLE `mt_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_allow_pings` tinyint(4) DEFAULT '0',
  `category_author_id` int(11) DEFAULT NULL,
  `category_basename` varchar(255) DEFAULT NULL,
  `category_blog_id` int(11) NOT NULL,
  `category_class` varchar(255) DEFAULT 'category',
  `category_created_by` int(11) DEFAULT NULL,
  `category_created_on` datetime DEFAULT NULL,
  `category_description` mediumtext,
  `category_label` varchar(100) NOT NULL,
  `category_modified_by` int(11) DEFAULT NULL,
  `category_modified_on` datetime DEFAULT NULL,
  `category_parent` int(11) DEFAULT '0',
  `category_ping_urls` mediumtext,
  PRIMARY KEY (`category_id`),
  KEY `mt_category_blog_basename` (`category_blog_id`,`category_basename`),
  KEY `mt_category_parent` (`category_parent`),
  KEY `mt_category_class` (`category_class`),
  KEY `mt_category_blog_class` (`category_blog_id`,`category_class`),
  KEY `mt_category_label` (`category_label`),
  KEY `mt_category_blog_id` (`category_blog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_category_meta`
--

CREATE TABLE `mt_category_meta` (
  `category_meta_category_id` int(11) NOT NULL,
  `category_meta_type` varchar(75) NOT NULL,
  `category_meta_vchar` varchar(255) DEFAULT NULL,
  `category_meta_vchar_idx` varchar(255) DEFAULT NULL,
  `category_meta_vdatetime` datetime DEFAULT NULL,
  `category_meta_vdatetime_idx` datetime DEFAULT NULL,
  `category_meta_vinteger` int(11) DEFAULT NULL,
  `category_meta_vinteger_idx` int(11) DEFAULT NULL,
  `category_meta_vfloat` float DEFAULT NULL,
  `category_meta_vfloat_idx` float DEFAULT NULL,
  `category_meta_vblob` mediumblob,
  `category_meta_vclob` mediumtext,
  PRIMARY KEY (`category_meta_category_id`,`category_meta_type`),
  KEY `mt_category_meta_type_vint` (`category_meta_type`,`category_meta_vinteger_idx`),
  KEY `mt_category_meta_type_vflt` (`category_meta_type`,`category_meta_vfloat_idx`),
  KEY `mt_category_meta_type_vdt` (`category_meta_type`,`category_meta_vdatetime_idx`),
  KEY `mt_category_meta_type_vchar` (`category_meta_type`,`category_meta_vchar_idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `mt_comment`
--

CREATE TABLE `mt_comment` (
  `comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `comment_author` varchar(100) DEFAULT NULL,
  `comment_blog_id` int(11) NOT NULL,
  `comment_commenter_id` int(11) DEFAULT NULL,
  `comment_created_by` int(11) DEFAULT NULL,
  `comment_created_on` datetime DEFAULT NULL,
  `comment_email` varchar(127) DEFAULT NULL,
  `comment_entry_id` int(11) NOT NULL,
  `comment_ip` varchar(50) DEFAULT NULL,
  `comment_junk_log` mediumtext,
  `comment_junk_score` float DEFAULT NULL,
  `comment_junk_status` smallint(6) DEFAULT '1',
  `comment_last_moved_on` datetime NOT NULL DEFAULT '2000-01-01 00:00:00',
  `comment_modified_by` int(11) DEFAULT NULL,
  `comment_modified_on` datetime DEFAULT NULL,
  `comment_parent_id` int(11) DEFAULT NULL,
  `comment_text` mediumtext,
  `comment_url` varchar(255) DEFAULT NULL,
  `comment_visible` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `mt_comment_blog_stat` (`comment_blog_id`,`comment_junk_status`,`comment_created_on`),
  KEY `mt_comment_commenter_id` (`comment_commenter_id`),
  KEY `mt_comment_dd_coment_vis_mod` (`comment_visible`,`comment_modified_on`),
  KEY `mt_comment_visible_date` (`comment_visible`,`comment_created_on`),
  KEY `mt_comment_author` (`comment_author`),
  KEY `mt_comment_entry_visible` (`comment_entry_id`,`comment_visible`,`comment_created_on`),
  KEY `mt_comment_email` (`comment_email`),
  KEY `mt_comment_blog_junk_stat` (`comment_blog_id`,`comment_junk_status`,`comment_last_moved_on`),
  KEY `mt_comment_blog_visible` (`comment_blog_id`,`comment_visible`,`comment_created_on`,`comment_id`),
  KEY `mt_comment_last_moved_on` (`comment_last_moved_on`),
  KEY `mt_comment_blog_ip_date` (`comment_blog_id`,`comment_ip`,`comment_created_on`),
  KEY `mt_comment_blog_visible_entry` (`comment_blog_id`,`comment_visible`,`comment_entry_id`),
  KEY `mt_comment_blog_url` (`comment_blog_id`,`comment_visible`,`comment_url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_comment_meta`
--

CREATE TABLE `mt_comment_meta` (
  `comment_meta_comment_id` int(11) NOT NULL,
  `comment_meta_type` varchar(75) NOT NULL,
  `comment_meta_vchar` varchar(255) DEFAULT NULL,
  `comment_meta_vchar_idx` varchar(255) DEFAULT NULL,
  `comment_meta_vdatetime` datetime DEFAULT NULL,
  `comment_meta_vdatetime_idx` datetime DEFAULT NULL,
  `comment_meta_vinteger` int(11) DEFAULT NULL,
  `comment_meta_vinteger_idx` int(11) DEFAULT NULL,
  `comment_meta_vfloat` float DEFAULT NULL,
  `comment_meta_vfloat_idx` float DEFAULT NULL,
  `comment_meta_vblob` mediumblob,
  `comment_meta_vclob` mediumtext,
  PRIMARY KEY (`comment_meta_comment_id`,`comment_meta_type`),
  KEY `mt_comment_meta_type_vint` (`comment_meta_type`,`comment_meta_vinteger_idx`),
  KEY `mt_comment_meta_type_vflt` (`comment_meta_type`,`comment_meta_vfloat_idx`),
  KEY `mt_comment_meta_type_vdt` (`comment_meta_type`,`comment_meta_vdatetime_idx`),
  KEY `mt_comment_meta_type_vchar` (`comment_meta_type`,`comment_meta_vchar_idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `mt_config`
--

CREATE TABLE `mt_config` (
  `config_id` int(11) NOT NULL AUTO_INCREMENT,
  `config_data` mediumtext,
  PRIMARY KEY (`config_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `mt_config`
--

INSERT INTO `mt_config` VALUES
(1, 'MTReleaseNumber 13\nMTVersion 5.2\nPluginSchemaVersion stylecatcher=1.0\nPluginSchemaVersion multiblog=2.3\nPluginSchemaVersion WidgetManager=1.1\nPluginSchemaVersion formattedtext=1.00\nSchemaVersion 5.0036\n');

-- --------------------------------------------------------

--
-- Table structure for table `mt_entry`
--

CREATE TABLE `mt_entry` (
  `entry_id` int(11) NOT NULL AUTO_INCREMENT,
  `entry_allow_comments` tinyint(4) DEFAULT NULL,
  `entry_allow_pings` tinyint(4) DEFAULT NULL,
  `entry_atom_id` varchar(255) DEFAULT NULL,
  `entry_author_id` int(11) NOT NULL,
  `entry_authored_on` datetime DEFAULT NULL,
  `entry_basename` varchar(255) DEFAULT NULL,
  `entry_blog_id` int(11) NOT NULL,
  `entry_category_id` int(11) DEFAULT NULL,
  `entry_class` varchar(255) DEFAULT 'entry',
  `entry_comment_count` int(11) DEFAULT '0',
  `entry_convert_breaks` varchar(60) DEFAULT NULL,
  `entry_created_by` int(11) DEFAULT NULL,
  `entry_created_on` datetime DEFAULT NULL,
  `entry_excerpt` mediumtext,
  `entry_keywords` mediumtext,
  `entry_modified_by` int(11) DEFAULT NULL,
  `entry_modified_on` datetime DEFAULT NULL,
  `entry_ping_count` int(11) DEFAULT '0',
  `entry_pinged_urls` mediumtext,
  `entry_status` smallint(6) NOT NULL,
  `entry_tangent_cache` mediumtext,
  `entry_template_id` int(11) DEFAULT NULL,
  `entry_text` mediumtext,
  `entry_text_more` mediumtext,
  `entry_title` varchar(255) DEFAULT NULL,
  `entry_to_ping_urls` mediumtext,
  `entry_week_number` int(11) DEFAULT NULL,
  `entry_current_revision` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`entry_id`),
  KEY `mt_entry_author_id` (`entry_author_id`),
  KEY `mt_entry_tag_count` (`entry_status`,`entry_class`,`entry_blog_id`,`entry_id`),
  KEY `mt_entry_status` (`entry_status`),
  KEY `mt_entry_blog_stat_date` (`entry_blog_id`,`entry_class`,`entry_status`,`entry_authored_on`,`entry_id`),
  KEY `mt_entry_blog_author` (`entry_blog_id`,`entry_class`,`entry_author_id`,`entry_authored_on`),
  KEY `mt_entry_blog_basename` (`entry_blog_id`,`entry_basename`),
  KEY `mt_entry_comment_count` (`entry_comment_count`),
  KEY `mt_entry_created_on` (`entry_created_on`),
  KEY `mt_entry_dd_entry_tag_count` (`entry_blog_id`,`entry_status`,`entry_class`,`entry_id`),
  KEY `mt_entry_auth_stat_class` (`entry_author_id`,`entry_status`,`entry_class`),
  KEY `mt_entry_blog_authored` (`entry_blog_id`,`entry_class`,`entry_authored_on`),
  KEY `mt_entry_blog_week` (`entry_blog_id`,`entry_class`,`entry_status`,`entry_week_number`),
  KEY `mt_entry_modified_on` (`entry_modified_on`),
  KEY `mt_entry_title` (`entry_title`),
  KEY `mt_entry_class` (`entry_class`),
  KEY `mt_entry_class_authored` (`entry_class`,`entry_authored_on`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `mt_entry`
--

INSERT INTO `mt_entry` VALUES
(1, 1, 1, 'tag:[[domhost]],[[date_]]:[[wrelativeurl]]//1.1', 1, '[[regtime]]', 'home', 1, NULL, 'page', 0, 'richtext', 1, '[[regtime]]', '', '', NULL, '[[regtime]]', 0, NULL, 2, NULL, NULL, '', '', 'home', '', 201516, 1);

-- --------------------------------------------------------

--
-- Table structure for table `mt_entry_meta`
--

CREATE TABLE `mt_entry_meta` (
  `entry_meta_entry_id` int(11) NOT NULL,
  `entry_meta_type` varchar(75) NOT NULL,
  `entry_meta_vchar` varchar(255) DEFAULT NULL,
  `entry_meta_vchar_idx` varchar(255) DEFAULT NULL,
  `entry_meta_vdatetime` datetime DEFAULT NULL,
  `entry_meta_vdatetime_idx` datetime DEFAULT NULL,
  `entry_meta_vinteger` int(11) DEFAULT NULL,
  `entry_meta_vinteger_idx` int(11) DEFAULT NULL,
  `entry_meta_vfloat` float DEFAULT NULL,
  `entry_meta_vfloat_idx` float DEFAULT NULL,
  `entry_meta_vblob` mediumblob,
  `entry_meta_vclob` mediumtext,
  PRIMARY KEY (`entry_meta_entry_id`,`entry_meta_type`),
  KEY `mt_entry_meta_type_vint` (`entry_meta_type`,`entry_meta_vinteger_idx`),
  KEY `mt_entry_meta_type_vflt` (`entry_meta_type`,`entry_meta_vfloat_idx`),
  KEY `mt_entry_meta_type_vdt` (`entry_meta_type`,`entry_meta_vdatetime_idx`),
  KEY `mt_entry_meta_type_vchar` (`entry_meta_type`,`entry_meta_vchar_idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `mt_entry_meta`
--

INSERT INTO `mt_entry_meta` VALUES
(1, 'revision', NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mt_entry_rev`
--

CREATE TABLE `mt_entry_rev` (
  `entry_rev_id` int(11) NOT NULL AUTO_INCREMENT,
  `entry_rev_changed` varchar(255) NOT NULL,
  `entry_rev_created_by` int(11) DEFAULT NULL,
  `entry_rev_created_on` datetime DEFAULT NULL,
  `entry_rev_description` varchar(255) DEFAULT NULL,
  `entry_rev_entry` mediumblob NOT NULL,
  `entry_rev_entry_id` int(11) NOT NULL,
  `entry_rev_label` varchar(255) DEFAULT NULL,
  `entry_rev_modified_by` int(11) DEFAULT NULL,
  `entry_rev_modified_on` datetime DEFAULT NULL,
  `entry_rev_rev_number` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`entry_rev_id`),
  KEY `mt_entry_rev_entry_id` (`entry_rev_entry_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `mt_entry_rev`
--

INSERT INTO `mt_entry_rev` VALUES
(1, 'author_id,status,convert_breaks,allow_pings,authored_on,allow_comments,basename,title', 1, '[[regtime]]', '', 'SERG\0\0\0\0\0\0\0H\0\0\0\Z\0\0\0	author_id-\0\0\01\0\0\0excerpt-\0\0\0\0\0\0\0\nping_count-\0\0\00\0\0\0atom_id-\0\0\0*tag:[[domhost]],[[date_]]:[[wrelativeurl]]//1.1\0\0\0status-\0\0\02\0\0\0keywords-\0\0\0\0\0\0\0convert_breaks-\0\0\0richtext\0\0\0\rcomment_count-\0\0\00\0\0\0current_revision-\0\0\00\0\0\0\ncreated_on-\0\0\0[[regtime_]]\0\0\0text-\0\0\0\0\0\0\0	text_more-\0\0\0\0\0\0\0authored_on-\0\0\0[[regtime_]]\0\0\0allow_pings-\0\0\01\0\0\0id-\0\0\01\0\0\0blog_id-\0\0\01\0\0\0\n__rev_tagsA\0\0\0\0\0\0\0to_ping_urls-\0\0\0\0\0\0\0allow_comments-\0\0\01\0\0\0\n__rev_catsA\0\0\0\0\0\0\0basename-\0\0\0home\0\0\0modified_on-\0\0\0[[regtime_]]\0\0\0title-\0\0\0home\0\0\0class-\0\0\0page\0\0\0week_number-\0\0\0201516\0\0\0\ncreated_by-\0\0\01', 1, NULL, NULL, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `mt_entry_summary`
--

CREATE TABLE `mt_entry_summary` (
  `entry_summary_entry_id` int(11) NOT NULL,
  `entry_summary_type` varchar(75) NOT NULL,
  `entry_summary_class` varchar(75) NOT NULL,
  `entry_summary_vchar_idx` varchar(255) DEFAULT NULL,
  `entry_summary_vinteger_idx` int(11) DEFAULT NULL,
  `entry_summary_vblob` mediumblob,
  `entry_summary_vclob` mediumtext,
  `entry_summary_expired` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`entry_summary_entry_id`,`entry_summary_type`),
  KEY `mt_entry_summary_class_vint` (`entry_summary_class`,`entry_summary_vinteger_idx`),
  KEY `mt_entry_summary_id_class` (`entry_summary_entry_id`,`entry_summary_class`),
  KEY `mt_entry_summary_class_vchar` (`entry_summary_class`,`entry_summary_vchar_idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `mt_failedlogin`
--

CREATE TABLE `mt_failedlogin` (
  `failedlogin_id` int(11) NOT NULL AUTO_INCREMENT,
  `failedlogin_author_id` int(11) DEFAULT NULL,
  `failedlogin_ip_locked` tinyint(4) DEFAULT '0',
  `failedlogin_remote_ip` varchar(60) DEFAULT NULL,
  `failedlogin_start` int(11) NOT NULL,
  PRIMARY KEY (`failedlogin_id`),
  KEY `mt_failedlogin_author_id` (`failedlogin_author_id`),
  KEY `mt_failedlogin_remote_ip` (`failedlogin_remote_ip`),
  KEY `mt_failedlogin_ip_start` (`failedlogin_remote_ip`,`failedlogin_start`),
  KEY `mt_failedlogin_ip_locked` (`failedlogin_ip_locked`),
  KEY `mt_failedlogin_author_start` (`failedlogin_author_id`,`failedlogin_start`),
  KEY `mt_failedlogin_start` (`failedlogin_start`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_fileinfo`
--

CREATE TABLE `mt_fileinfo` (
  `fileinfo_id` int(11) NOT NULL AUTO_INCREMENT,
  `fileinfo_archive_type` varchar(255) DEFAULT NULL,
  `fileinfo_author_id` int(11) DEFAULT NULL,
  `fileinfo_blog_id` int(11) NOT NULL,
  `fileinfo_category_id` int(11) DEFAULT NULL,
  `fileinfo_entry_id` int(11) DEFAULT NULL,
  `fileinfo_file_path` mediumtext,
  `fileinfo_startdate` varchar(80) DEFAULT NULL,
  `fileinfo_template_id` int(11) DEFAULT NULL,
  `fileinfo_templatemap_id` int(11) DEFAULT NULL,
  `fileinfo_url` varchar(255) DEFAULT NULL,
  `fileinfo_virtual` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`fileinfo_id`),
  KEY `mt_fileinfo_author_id` (`fileinfo_author_id`),
  KEY `mt_fileinfo_archive_type` (`fileinfo_archive_type`),
  KEY `mt_fileinfo_template_id` (`fileinfo_template_id`),
  KEY `mt_fileinfo_startdate` (`fileinfo_startdate`),
  KEY `mt_fileinfo_entry_id` (`fileinfo_entry_id`),
  KEY `mt_fileinfo_category_id` (`fileinfo_category_id`),
  KEY `mt_fileinfo_url` (`fileinfo_url`),
  KEY `mt_fileinfo_blog_id` (`fileinfo_blog_id`),
  KEY `mt_fileinfo_templatemap_id` (`fileinfo_templatemap_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `mt_fileinfo`
--

INSERT INTO `mt_fileinfo` VALUES
(1, 'Page', NULL, 1, NULL, 1, '[[wwwdir]]/home.html', NULL, 17, 1, '[[wrelativeurl]]/home.html', NULL),
(2, 'index', NULL, 1, NULL, NULL, '[[wwwdir]]/rsd.xml', NULL, 6, NULL, '[[wrelativeurl]]/rsd.xml', NULL),
(3, 'index', NULL, 1, NULL, NULL, '[[wwwdir]]/styles.css', NULL, 7, NULL, '[[wrelativeurl]]/styles.css', NULL),
(4, 'index', NULL, 1, NULL, NULL, '[[wwwdir]]/atom.xml', NULL, 8, NULL, '[[wrelativeurl]]/atom.xml', NULL),
(5, 'index', NULL, 1, NULL, NULL, '[[wwwdir]]/mt.js', NULL, 28, NULL, '[[wrelativeurl]]/mt.js', NULL),
(6, 'index', NULL, 1, NULL, NULL, '[[wwwdir]]/index.html', NULL, 34, NULL, '[[wrelativeurl]]/index.html', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mt_filter`
--

CREATE TABLE `mt_filter` (
  `filter_id` int(11) NOT NULL AUTO_INCREMENT,
  `filter_author_id` int(11) NOT NULL,
  `filter_blog_id` int(11) NOT NULL,
  `filter_created_by` int(11) DEFAULT NULL,
  `filter_created_on` datetime DEFAULT NULL,
  `filter_items` mediumblob,
  `filter_label` varchar(255) DEFAULT NULL,
  `filter_modified_by` int(11) DEFAULT NULL,
  `filter_modified_on` datetime DEFAULT NULL,
  `filter_object_ds` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `mt_filter_author_id` (`filter_author_id`),
  KEY `mt_filter_modified_on` (`filter_modified_on`),
  KEY `mt_filter_created_on` (`filter_created_on`),
  KEY `mt_filter_author_ds` (`filter_author_id`,`filter_object_ds`),
  KEY `mt_filter_label` (`filter_label`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_formatted_text`
--

CREATE TABLE `mt_formatted_text` (
  `formatted_text_id` int(11) NOT NULL AUTO_INCREMENT,
  `formatted_text_blog_id` int(11) NOT NULL,
  `formatted_text_created_by` int(11) DEFAULT NULL,
  `formatted_text_created_on` datetime DEFAULT NULL,
  `formatted_text_description` varchar(255) DEFAULT NULL,
  `formatted_text_label` varchar(255) DEFAULT NULL,
  `formatted_text_modified_by` int(11) DEFAULT NULL,
  `formatted_text_modified_on` datetime DEFAULT NULL,
  `formatted_text_text` mediumtext,
  PRIMARY KEY (`formatted_text_id`),
  KEY `mt_formatted_text_blog_c_by` (`formatted_text_blog_id`,`formatted_text_created_by`),
  KEY `mt_formatted_text_modified_on` (`formatted_text_modified_on`),
  KEY `mt_formatted_text_created_on` (`formatted_text_created_on`),
  KEY `mt_formatted_text_label` (`formatted_text_label`),
  KEY `mt_formatted_text_blog_id` (`formatted_text_blog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_ipbanlist`
--

CREATE TABLE `mt_ipbanlist` (
  `ipbanlist_id` int(11) NOT NULL AUTO_INCREMENT,
  `ipbanlist_blog_id` int(11) NOT NULL,
  `ipbanlist_created_by` int(11) DEFAULT NULL,
  `ipbanlist_created_on` datetime DEFAULT NULL,
  `ipbanlist_ip` varchar(50) NOT NULL,
  `ipbanlist_modified_by` int(11) DEFAULT NULL,
  `ipbanlist_modified_on` datetime DEFAULT NULL,
  PRIMARY KEY (`ipbanlist_id`),
  KEY `mt_ipbanlist_ip` (`ipbanlist_ip`),
  KEY `mt_ipbanlist_blog_id` (`ipbanlist_blog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_log`
--

CREATE TABLE `mt_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `log_author_id` int(11) DEFAULT '0',
  `log_blog_id` int(11) DEFAULT '0',
  `log_category` varchar(255) DEFAULT NULL,
  `log_class` varchar(255) DEFAULT 'system',
  `log_created_by` int(11) DEFAULT NULL,
  `log_created_on` datetime DEFAULT NULL,
  `log_ip` varchar(50) DEFAULT NULL,
  `log_level` int(11) DEFAULT '1',
  `log_message` mediumtext,
  `log_metadata` mediumtext,
  `log_modified_by` int(11) DEFAULT NULL,
  `log_modified_on` datetime DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `mt_log_level` (`log_level`),
  KEY `mt_log_created_on` (`log_created_on`),
  KEY `mt_log_blog_id` (`log_blog_id`),
  KEY `mt_log_class` (`log_class`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `mt_log`
--


-- --------------------------------------------------------

--
-- Table structure for table `mt_notification`
--

CREATE TABLE `mt_notification` (
  `notification_id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_blog_id` int(11) NOT NULL,
  `notification_created_by` int(11) DEFAULT NULL,
  `notification_created_on` datetime DEFAULT NULL,
  `notification_email` varchar(75) DEFAULT NULL,
  `notification_modified_by` int(11) DEFAULT NULL,
  `notification_modified_on` datetime DEFAULT NULL,
  `notification_name` varchar(50) DEFAULT NULL,
  `notification_url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`notification_id`),
  KEY `mt_notification_email` (`notification_email`),
  KEY `mt_notification_blog_id` (`notification_blog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_objectasset`
--

CREATE TABLE `mt_objectasset` (
  `objectasset_id` int(11) NOT NULL AUTO_INCREMENT,
  `objectasset_asset_id` int(11) NOT NULL,
  `objectasset_blog_id` int(11) DEFAULT NULL,
  `objectasset_embedded` tinyint(4) DEFAULT '0',
  `objectasset_object_ds` varchar(50) NOT NULL,
  `objectasset_object_id` int(11) NOT NULL,
  PRIMARY KEY (`objectasset_id`),
  KEY `mt_objectasset_blog_obj` (`objectasset_blog_id`,`objectasset_object_ds`,`objectasset_object_id`),
  KEY `mt_objectasset_asset_id` (`objectasset_asset_id`),
  KEY `mt_objectasset_id_ds` (`objectasset_object_id`,`objectasset_object_ds`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_objectscore`
--

CREATE TABLE `mt_objectscore` (
  `objectscore_id` int(11) NOT NULL AUTO_INCREMENT,
  `objectscore_author_id` int(11) DEFAULT '0',
  `objectscore_created_by` int(11) DEFAULT NULL,
  `objectscore_created_on` datetime DEFAULT NULL,
  `objectscore_ip` varchar(50) DEFAULT NULL,
  `objectscore_modified_by` int(11) DEFAULT NULL,
  `objectscore_modified_on` datetime DEFAULT NULL,
  `objectscore_namespace` varchar(100) NOT NULL,
  `objectscore_object_ds` varchar(50) NOT NULL,
  `objectscore_object_id` int(11) DEFAULT '0',
  `objectscore_score` float DEFAULT NULL,
  PRIMARY KEY (`objectscore_id`),
  KEY `mt_objectscore_ns_ip_ds_obj` (`objectscore_namespace`,`objectscore_ip`,`objectscore_object_ds`,`objectscore_object_id`),
  KEY `mt_objectscore_ds_obj` (`objectscore_object_ds`,`objectscore_object_id`),
  KEY `mt_objectscore_ns_user_ds_obj` (`objectscore_namespace`,`objectscore_author_id`,`objectscore_object_ds`,`objectscore_object_id`),
  KEY `mt_objectscore_user_ns` (`objectscore_author_id`,`objectscore_namespace`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_objecttag`
--

CREATE TABLE `mt_objecttag` (
  `objecttag_id` int(11) NOT NULL AUTO_INCREMENT,
  `objecttag_blog_id` int(11) DEFAULT NULL,
  `objecttag_object_datasource` varchar(50) NOT NULL,
  `objecttag_object_id` int(11) NOT NULL,
  `objecttag_tag_id` int(11) NOT NULL,
  PRIMARY KEY (`objecttag_id`),
  KEY `mt_objecttag_blog_ds_tag` (`objecttag_blog_id`,`objecttag_object_datasource`,`objecttag_tag_id`),
  KEY `mt_objecttag_object_id` (`objecttag_object_id`),
  KEY `mt_objecttag_tag_id` (`objecttag_tag_id`),
  KEY `mt_objecttag_blog_ds_obj_tag` (`objecttag_blog_id`,`objecttag_object_datasource`,`objecttag_object_id`,`objecttag_tag_id`),
  KEY `mt_objecttag_object_datasource` (`objecttag_object_datasource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_permission`
--

CREATE TABLE `mt_permission` (
  `permission_id` int(11) NOT NULL AUTO_INCREMENT,
  `permission_author_id` int(11) NOT NULL DEFAULT '0',
  `permission_blog_id` int(11) NOT NULL DEFAULT '0',
  `permission_blog_prefs` varchar(255) DEFAULT NULL,
  `permission_created_by` int(11) DEFAULT NULL,
  `permission_created_on` datetime DEFAULT NULL,
  `permission_entry_prefs` mediumtext,
  `permission_modified_by` int(11) DEFAULT NULL,
  `permission_modified_on` datetime DEFAULT NULL,
  `permission_page_prefs` mediumtext,
  `permission_permissions` mediumtext,
  `permission_restrictions` mediumtext,
  `permission_role_mask` int(11) DEFAULT '0',
  `permission_template_prefs` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`permission_id`),
  KEY `mt_permission_author_id` (`permission_author_id`),
  KEY `mt_permission_role_mask` (`permission_role_mask`),
  KEY `mt_permission_blog_id` (`permission_blog_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `mt_permission`
--

INSERT INTO `mt_permission` VALUES
(1, 1, 0, NULL, NULL, '[[regtime]]', NULL, NULL, '[[regtime]]', NULL, '''administer'',''create_blog'',''create_website'',''edit_templates'',''manage_plugins'',''view_log''', NULL, 0, NULL),
(2, 1, 1, NULL, 1, '[[regtime]]', 'Default|Bottom', NULL, '[[regtime]]', NULL, '''edit_categories'',''save_image_defaults'',''view_blog_log'',''manage_pages'',''set_publish_paths'',''edit_tags'',''manage_member_blogs'',''manage_themes'',''manage_feedback'',''publish_post'',''edit_all_posts'',''edit_assets'',''edit_config'',''administer_blog'',''send_notifications'',''create_post'',''rebuild'',''edit_notifications'',''comment'',''administer_website'',''edit_templates'',''manage_users'',''upload'',''administer'',''create_blog'',''create_website'',''manage_plugins'',''view_log''', NULL, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mt_placement`
--

CREATE TABLE `mt_placement` (
  `placement_id` int(11) NOT NULL AUTO_INCREMENT,
  `placement_blog_id` int(11) NOT NULL,
  `placement_category_id` int(11) NOT NULL,
  `placement_entry_id` int(11) NOT NULL,
  `placement_is_primary` tinyint(4) NOT NULL,
  PRIMARY KEY (`placement_id`),
  KEY `mt_placement_category_id` (`placement_category_id`),
  KEY `mt_placement_blog_cat` (`placement_blog_id`,`placement_category_id`),
  KEY `mt_placement_blog_id` (`placement_blog_id`),
  KEY `mt_placement_is_primary` (`placement_is_primary`),
  KEY `mt_placement_entry_id` (`placement_entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_plugindata`
--

CREATE TABLE `mt_plugindata` (
  `plugindata_id` int(11) NOT NULL AUTO_INCREMENT,
  `plugindata_data` mediumblob,
  `plugindata_key` varchar(255) NOT NULL,
  `plugindata_plugin` varchar(50) NOT NULL,
  PRIMARY KEY (`plugindata_id`),
  KEY `mt_plugindata_plugin` (`plugindata_plugin`),
  KEY `mt_plugindata_key` (`plugindata_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_role`
--

CREATE TABLE `mt_role` (
  `role_id` int(11) NOT NULL AUTO_INCREMENT,
  `role_created_by` int(11) DEFAULT NULL,
  `role_created_on` datetime DEFAULT NULL,
  `role_description` mediumtext,
  `role_is_system` tinyint(4) DEFAULT '0',
  `role_modified_by` int(11) DEFAULT NULL,
  `role_modified_on` datetime DEFAULT NULL,
  `role_name` varchar(255) NOT NULL,
  `role_permissions` mediumtext,
  `role_role_mask` int(11) DEFAULT NULL,
  `role_role_mask2` int(11) DEFAULT NULL,
  `role_role_mask3` int(11) DEFAULT NULL,
  `role_role_mask4` int(11) DEFAULT NULL,
  PRIMARY KEY (`role_id`),
  KEY `mt_role_created_on` (`role_created_on`),
  KEY `mt_role_is_system` (`role_is_system`),
  KEY `mt_role_name` (`role_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `mt_role`
--

INSERT INTO `mt_role` VALUES
(1, 1, '[[regtime]]', 'Can administer the website.', 0, NULL, '[[regtime]]', 'Website Administrator', '''administer_website'',''manage_member_blogs''', NULL, NULL, NULL, NULL),
(2, 1, '[[regtime]]', 'Can administer the blog.', 0, NULL, '[[regtime]]', 'Blog Administrator', '''administer_blog''', 4096, NULL, NULL, NULL),
(3, 1, '[[regtime]]', 'Can upload files, edit all entries(categories), pages(folders), tags and publish the site.', 0, NULL, '[[regtime]]', 'Editor', '''comment'',''create_post'',''publish_post'',''edit_all_posts'',''edit_categories'',''edit_tags'',''manage_pages'',''rebuild'',''upload'',''send_notifications'',''manage_feedback'',''edit_assets''', NULL, NULL, NULL, NULL),
(4, 1, '[[regtime]]', 'Can create entries, edit their own entries, upload files and publish.', 0, NULL, '[[regtime]]', 'Author', '''comment'',''create_post'',''publish_post'',''upload'',''send_notifications''', NULL, NULL, NULL, NULL),
(5, 1, '[[regtime]]', 'Can edit, manage, and publish blog templates and themes.', 0, NULL, '[[regtime]]', 'Designer', '''manage_themes'',''edit_templates'',''rebuild''', 144, NULL, NULL, NULL),
(6, 1, '[[regtime]]', 'Can manage pages, upload files and publish blog templates.', 0, NULL, '[[regtime]]', 'Webmaster', '''manage_pages'',''rebuild'',''upload''', NULL, NULL, NULL, NULL),
(7, 1, '[[regtime]]', 'Can create entries, edit their own entries, and comment.', 0, NULL, '[[regtime]]', 'Contributor', '''comment'',''create_post''', NULL, NULL, NULL, NULL),
(8, 1, '[[regtime]]', 'Can comment and manage feedback.', 0, NULL, '[[regtime]]', 'Moderator', '''comment'',''manage_feedback''', NULL, NULL, NULL, NULL),
(9, 1, '[[regtime]]', 'Can comment.', 0, NULL, '[[regtime]]', 'Commenter', '''comment''', 1, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mt_session`
--

CREATE TABLE `mt_session` (
  `session_id` varchar(80) NOT NULL,
  `session_data` mediumblob,
  `session_duration` int(11) DEFAULT NULL,
  `session_email` varchar(255) DEFAULT NULL,
  `session_kind` varchar(2) DEFAULT NULL,
  `session_name` varchar(255) DEFAULT NULL,
  `session_start` int(11) NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `mt_session_kind` (`session_kind`),
  KEY `mt_session_name` (`session_name`),
  KEY `mt_session_duration` (`session_duration`),
  KEY `mt_session_start` (`session_start`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `mt_session`
--


-- --------------------------------------------------------

--
-- Table structure for table `mt_tag`
--

CREATE TABLE `mt_tag` (
  `tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_is_private` tinyint(4) DEFAULT '0',
  `tag_n8d_id` int(11) DEFAULT '0',
  `tag_name` varchar(255) NOT NULL,
  PRIMARY KEY (`tag_id`),
  KEY `mt_tag_n8d_id` (`tag_n8d_id`),
  KEY `mt_tag_name_id` (`tag_name`,`tag_id`),
  KEY `mt_tag_name` (`tag_name`),
  KEY `mt_tag_private_id_name` (`tag_is_private`,`tag_id`,`tag_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_tbping`
--

CREATE TABLE `mt_tbping` (
  `tbping_id` int(11) NOT NULL AUTO_INCREMENT,
  `tbping_blog_id` int(11) NOT NULL,
  `tbping_blog_name` varchar(255) DEFAULT NULL,
  `tbping_created_by` int(11) DEFAULT NULL,
  `tbping_created_on` datetime DEFAULT NULL,
  `tbping_excerpt` mediumtext,
  `tbping_ip` varchar(50) NOT NULL,
  `tbping_junk_log` mediumtext,
  `tbping_junk_score` float DEFAULT NULL,
  `tbping_junk_status` smallint(6) NOT NULL DEFAULT '1',
  `tbping_last_moved_on` datetime NOT NULL DEFAULT '2000-01-01 00:00:00',
  `tbping_modified_by` int(11) DEFAULT NULL,
  `tbping_modified_on` datetime DEFAULT NULL,
  `tbping_source_url` varchar(255) DEFAULT NULL,
  `tbping_tb_id` int(11) NOT NULL,
  `tbping_title` varchar(255) DEFAULT NULL,
  `tbping_visible` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`tbping_id`),
  KEY `mt_tbping_blog_stat` (`tbping_blog_id`,`tbping_junk_status`,`tbping_created_on`),
  KEY `mt_tbping_ip` (`tbping_ip`),
  KEY `mt_tbping_visible_date` (`tbping_visible`,`tbping_created_on`),
  KEY `mt_tbping_blog_junk_stat` (`tbping_blog_id`,`tbping_junk_status`,`tbping_last_moved_on`),
  KEY `mt_tbping_last_moved_on` (`tbping_last_moved_on`),
  KEY `mt_tbping_blog_visible` (`tbping_blog_id`,`tbping_visible`,`tbping_created_on`,`tbping_id`),
  KEY `mt_tbping_tb_visible` (`tbping_tb_id`,`tbping_visible`,`tbping_created_on`),
  KEY `mt_tbping_created_on` (`tbping_created_on`),
  KEY `mt_tbping_junk_date` (`tbping_junk_status`,`tbping_created_on`),
  KEY `mt_tbping_blog_url` (`tbping_blog_id`,`tbping_visible`,`tbping_source_url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_tbping_meta`
--

CREATE TABLE `mt_tbping_meta` (
  `tbping_meta_tbping_id` int(11) NOT NULL,
  `tbping_meta_type` varchar(75) NOT NULL,
  `tbping_meta_vchar` varchar(255) DEFAULT NULL,
  `tbping_meta_vchar_idx` varchar(255) DEFAULT NULL,
  `tbping_meta_vdatetime` datetime DEFAULT NULL,
  `tbping_meta_vdatetime_idx` datetime DEFAULT NULL,
  `tbping_meta_vinteger` int(11) DEFAULT NULL,
  `tbping_meta_vinteger_idx` int(11) DEFAULT NULL,
  `tbping_meta_vfloat` float DEFAULT NULL,
  `tbping_meta_vfloat_idx` float DEFAULT NULL,
  `tbping_meta_vblob` mediumblob,
  `tbping_meta_vclob` mediumtext,
  PRIMARY KEY (`tbping_meta_tbping_id`,`tbping_meta_type`),
  KEY `mt_tbping_meta_type_vint` (`tbping_meta_type`,`tbping_meta_vinteger_idx`),
  KEY `mt_tbping_meta_type_vflt` (`tbping_meta_type`,`tbping_meta_vfloat_idx`),
  KEY `mt_tbping_meta_type_vdt` (`tbping_meta_type`,`tbping_meta_vdatetime_idx`),
  KEY `mt_tbping_meta_type_vchar` (`tbping_meta_type`,`tbping_meta_vchar_idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `mt_template`
--

CREATE TABLE `mt_template` (
  `template_id` int(11) NOT NULL AUTO_INCREMENT,
  `template_blog_id` int(11) NOT NULL,
  `template_build_dynamic` tinyint(4) DEFAULT NULL,
  `template_build_interval` int(11) DEFAULT NULL,
  `template_build_type` smallint(6) DEFAULT NULL,
  `template_created_by` int(11) DEFAULT NULL,
  `template_created_on` datetime DEFAULT NULL,
  `template_identifier` varchar(50) DEFAULT NULL,
  `template_linked_file` varchar(255) DEFAULT NULL,
  `template_linked_file_mtime` varchar(10) DEFAULT NULL,
  `template_linked_file_size` int(11) DEFAULT NULL,
  `template_modified_by` int(11) DEFAULT NULL,
  `template_modified_on` datetime DEFAULT NULL,
  `template_name` varchar(255) NOT NULL,
  `template_outfile` varchar(255) DEFAULT NULL,
  `template_rebuild_me` tinyint(4) DEFAULT NULL,
  `template_text` mediumtext,
  `template_type` varchar(25) NOT NULL,
  `template_current_revision` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`template_id`),
  KEY `mt_template_identifier` (`template_identifier`),
  KEY `mt_template_outfile` (`template_outfile`),
  KEY `mt_template_name` (`template_name`),
  KEY `mt_template_type` (`template_type`),
  KEY `mt_template_blog_id` (`template_blog_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=49 ;

--
-- Dumping data for table `mt_template`
--

INSERT INTO `mt_template` VALUES
(1, 1, 0, 0, 1, 1, '[[regtime]]', 'trackbacks', NULL, NULL, NULL, NULL, '[[regtime]]', 'Trackbacks', NULL, 1, '<mt:Ignore><!-- Display TrackBacks for the entry/page or TrackBack details if TrackBacks are being accepted --></mt:Ignore>\n<mt:IfPingsActive>\n<div id="trackbacks" class="trackbacks">\n    <h2 class="trackbacks-header"><$mt:EntryTrackbackCount singular="1 TrackBack" plural="# TrackBacks" none="No TrackBacks"$></h2>\n\n    <mt:Ignore><!-- Display TrackBack details if TrackBacks are being accepted --></mt:Ignore>\n    <mt:IfPingsAccepted>\n    <div class="trackbacks-info">\n        <p>TrackBack URL: <$mt:EntryTrackbackLink$></p>\n    </div>\n    </mt:IfPingsAccepted>\n\n\n    <mt:Ignore><!-- Display TrackBacks --></mt:Ignore>\n    <mt:Pings>\n        <mt:PingsHeader>\n    <div class="trackbacks-content">\n        </mt:PingsHeader>\n        <div class="trackback" id="ping-<$mt:PingID$>">\n            <div class="inner">\n                <div class="trackback-header">\n                    <div class="asset-meta">\n                        <a href="<$mt:PingURL$>"><$mt:PingTitle$></a> from <$mt:PingBlogName$> on <a href="#ping-<$mt:PingID$>"><$mt:PingDate$></a>\n                    </div>\n                </div>\n                <div class="trackback-content">\n                    <p>\n                        <$mt:PingExcerpt$> <a href="<$mt:PingURL$>">Read More</a>\n                    </p>\n                </div>\n            </div>\n        </div>\n        <mt:PingsFooter>\n    </div>\n        </mt:PingsFooter>\n    </mt:Pings>\n</div>\n</mt:IfPingsActive>\n', 'custom', 0),
(2, 1, 0, 0, 1, 1, '[[regtime]]', 'entry_summary', NULL, NULL, NULL, NULL, '[[regtime]]', 'Entry Summary', NULL, 1, '<$mt:EntryTrackbackData$>\n<div id="entry-<$mt:EntryID$>" class="entry-asset asset hentry">\n    <div class="asset-header">\n        <h2 class="asset-name entry-title"><a href="<$mt:EntryPermalink$>" rel="bookmark"><$mt:EntryTitle$></a><mt:If name="display_blog_name"> - <a href="<$mt:EntryBlogURL$>"><$mt:EntryBlogName$></a></mt:If></h2>\n        <div class="asset-meta">\n            <span class="byline">\n    <mt:If tag="EntryAuthorDisplayName">\n                By <span class="vcard author"><$mt:EntryAuthorLink show_hcard="1"$></span> on <abbr class="published" title="<$mt:EntryDate format_name="iso8601"$>"><$mt:EntryDate format="%x %X"$></abbr>\n    <mt:Else>\n                <abbr class="published" title="<$mt:EntryDate format_name="iso8601"$>"><$mt:EntryDate format="%x %X"$></abbr>\n    </mt:If>\n            </span>\n<mt:Unless name="hide_counts" eq="1">\n            <mt:IfCommentsActive><span class="separator">|</span> <a href="<$mt:EntryPermalink$>#comments"><$mt:EntryCommentCount singular="1 Comment" plural="# Comments" none="No Comments"$></a></mt:IfCommentsActive>\n            <mt:IfPingsActive><span class="separator">|</span> <a href="<$mt:EntryPermalink$>#trackbacks"><$mt:EntryTrackbackCount singular="1 TrackBack" plural="# TrackBacks" none="No TrackBacks"$></a></mt:IfPingsActive>\n</mt:Unless>\n        </div>\n    </div>\n    <div class="asset-content entry-content">\n<mt:If tag="EntryBody">\n        <div class="asset-body">\n            <$mt:EntryBody$>\n        </div>\n</mt:If>\n<mt:If name="entry_archive">\n    <mt:EntryIfTagged>\n        <div class="entry-tags">\n            <h4>Tags<span class="delimiter">:</span></h4>\n            <ul>\n                <li><mt:EntryTags glue=''<span class="delimiter">,</span></li> <li>''><a href="javascript:void(0)" onclick="location.href=''<$mt:TagSearchLink encode_js="1"$>'';return false;" rel="tag"><$mt:TagName$></a></mt:EntryTags></li>\n            </ul>\n        </div>\n    </mt:EntryIfTagged>\n</mt:If>\n<mt:If tag="EntryMore" convert_breaks="0">\n        <div class="asset-more-link">\n            Continue reading <a href="<$mt:EntryPermalink$>#more" rel="bookmark"><$mt:EntryTitle$></a>.\n        </div>\n</mt:If>\n    </div>\n    <div class="asset-footer"></div>\n</div>\n', 'custom', 0),
(3, 1, 0, 0, 1, 1, '[[regtime]]', 'comment_preview', NULL, NULL, NULL, NULL, '[[regtime]]', 'Comment Preview', NULL, 1, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"\n    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" id="sixapart-standard">\n<head>\n    <script type="text/javascript">\n    /* <![CDATA[ */\n    var user = <$mt:UserSessionState$>;\n    var is_preview = true;\n    /* ]]> */\n    </script>\n    <$mt:Include module="HTML Head"$>\n    <title><$mt:BlogName encode_html="1"$>: Previewing your Comment</title>\n</head>\n<body id="<$mt:WebsiteThemeID$>" class="mt-comment-preview <$mt:Var name="page_layout"$>" onload="mtEntryOnLoad()" onunload="mtEntryOnUnload()">\n    <div id="container">\n        <div id="container-inner">\n\n\n            <$mt:Include module="Banner Header"$>\n\n\n            <div id="content">\n                <div id="content-inner">\n\n\n                    <div id="alpha">\n                        <div id="alpha-inner">\n\n\n                            <h1 id="page-title"><$mt:Var name="page_title"$></h1>\n\n\n<mt:Ignore><!-- Comment Preview --></mt:Ignore>\n                            <div class="comment" id="comment-<$mt:CommentID$>">\n                                <div class="inner">\n                                    <div class="comment-header">\n                                        <div class="asset-meta">\n                                            <span class="byline">\n                                                <$mt:CommentAuthorIdentity$>\n    <mt:IfCommentParent>\n                                                <span class="vcard author"><$mt:CommentAuthorLink$></span> replied to <a href="<mt:CommentParent><$mt:CommentLink$></mt:CommentParent>">comment from <mt:CommentParent><$mt:CommentAuthor$></mt:CommentParent></a>\n    <mt:Else>\n                                                <span class="vcard author"><$mt:CommentAuthorLink$></span>\n    </mt:IfCommentParent>\n                                                | <a href="<$mt:CommentLink$>"><abbr class="published" title="<$mt:CommentDate format_name="iso8601"$>"><$mt:CommentDate$></abbr></a>\n                                            </span>\n                                        </div>\n                                    </div>\n                                    <div class="comment-content">\n                                        <$mt:CommentBody$>\n                                    </div>\n                                </div>\n                            </div>\n\n\n<mt:Ignore><!-- Comment Form --></mt:Ignore>\n                            <div class="comments-open" id="comments-open">\n                                <h2 class="comments-open-header">Leave a comment</h2>\n                                <div class="comments-open-content">\n                                    <div id="comment-greeting"></div>\n                                    <form method="post" action="<$mt:CGIPath$><$mt:CommentScript$>" name="comments_form" id="comments-form" onsubmit="return mtCommentOnSubmit(this)">\n                                        <input type="hidden" name="static" value="1" />\n                                        <input type="hidden" name="armor" value="1" />\n                                        <input type="hidden" name="preview" value="" />\n                                        <input type="hidden" name="entry_id" value="<$mt:EntryID$>" />\n                                        <input type="hidden" name="__lang" value="<$mt:BlogLanguage$>" />\n                                        <input type="hidden" name="sid" value="" />\n<mt:IfCommentParent>\n                                            <input type="hidden" name="parent_id" value="<$mt:CommentParentID escape="html"$>" id="comment-parent-id">\n</mt:IfCommentParent>\n                                        <div id="comments-open-data">\n                                            <div id="comment-form-name">\n                                                <label for="comment-author">Name</label>\n                                                <input id="comment-author" name="author" size="30" value="<$mt:CommentAuthor encode_html="1"$>" onfocus="mtShowCaptcha()" />\n                                            </div>\n                                            <div id="comment-form-email">\n                                                <label for="comment-email">Email Address</label>\n                                                <input id="comment-email" name="email" size="30" value="<$mt:CommentEmail encode_html="1"$>" onfocus="mtShowCaptcha()" />\n                                            </div>\n                                            <div id="comment-form-url">\n                                                <label for="comment-url">URL</label>\n                                                <input id="comment-url" name="url" size="30" value="<$mt:CommentURL encode_html="1"$>" onfocus="mtShowCaptcha()" />\n                                            </div>\n                                        </div>\n<mt:IfCommentParent>\n                                        <div id="comment-form-reply">\n                                            <input type="checkbox" id="comment-reply" name="comment_reply" value="<$mt:CommentParentID escape="html"$>" checked="checked" onclick="mtSetCommentParentID()" />\n                                            <label for="comment-reply" id="comment-reply-label">Replying to comment from <mt:CommentParent><$mt:CommentAuthor$></mt:CommentParent></label>\n                                        </div>\n</mt:IfCommentParent>\n                                        <div id="comments-open-text">\n                                            <label for="comment-text">Comments <mt:IfAllowCommentHTML>(You may use HTML tags for style)</mt:IfAllowCommentHTML></label>\n                                            <textarea id="comment-text" name="text" rows="15" cols="50" onfocus="mtShowCaptcha()"><$mt:CommentBody autolink="0" sanitize="0" convert_breaks="0" encode_html="1"$></textarea>\n                                        </div>\n                                        <div id="comments-open-captcha"></div>\n                                        <div id="comments-open-footer">\n                                            <input type="submit" accesskey="v" name="preview_button" id="comment-preview" value="Preview" onclick="this.form.preview.value=''1'';" />\n                                            <input type="submit" accesskey="s" name="post" id="comment-submit" value="Submit" />\n                                            <input type="button" name="cancel" id="comment-cancel" value="Cancel" onclick="window.location=''<$mt:EntryPermalink$>''" />\n                                        </div>\n                                    </form>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n\n\n                    <$mt:Include module="Sidebar"$>\n\n\n                </div>\n            </div>\n\n\n            <$mt:Include module="Banner Footer"$>\n\n\n        </div>\n    </div>\n</body>\n</html>\n', 'comment_preview', 0),
(4, 1, 0, 0, 1, 1, '[[regtime]]', 'search_results', NULL, NULL, NULL, NULL, '[[regtime]]', 'Search Results', NULL, 1, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"\n    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" id="sixapart-standard">\n<head>\n    <script type="text/javascript">\n    /* <![CDATA[ */\n    var user = <$mt:UserSessionState$>;\n    /* ]]> */\n    </script>\n    <$mt:Include module="HTML Head"$>\n    <title><$mt:BlogName encode_html="1"$>: Search Results</title>\n    <mt:Ignore>Below Javascript adds ajax search capability</mt:Ignore>\n    <script type="text/javascript">\n    /* <![CDATA[ */\n    <mt:IfMoreResults>\n    function getResults(page) {\n        page = parseInt(page);\n        if (timer) window.clearTimeout(timer);\n        var xh = mtGetXmlHttp();\n        if (!xh) return false;\n        var res = results[page];\n        if (!res) return;\n        var url = res[''next_url''];\n        if (!url) return;\n\n        xh.open(''GET'', url + ''&format=js'', true);\n        xh.onreadystatechange = function() {\n            if ( xh.readyState == 4 ) {\n                if ( xh.status && ( xh.status != 200 ) ) {\n                    // error - ignore\n                } else {\n                    try {\n                        var page_results = eval("(" + xh.responseText + ")");\n                        if ( page_results[''error''] == null )\n                            results[page + 1] = page_results[''result''];\n                    } catch (e) {\n                    }\n                }\n            }\n        };\n        xh.send(null);\n    }\n\n    function swapContent(direction) {\n        if ( direction == undefined ) direction = 1;\n        var page_span = document.getElementById(''current-page'');\n        if (!page_span) return true;\n        var next_page = direction + parseInt(page_span.innerHTML);\n        var res = results[next_page];\n        if (!res) return true;\n        var content = res[''content''];\n        if (!content) return true;\n        var div = document.getElementById(''search-results'');\n        if (!div) return true;\n        div.innerHTML = content;\n        timer = window.setTimeout("getResults(" + next_page + ")", 1*1000);\n        window.scroll(0, 0);\n        return false;\n    }\n    <mt:Else><mt:IfPreviousResults>\n    function swapContent(direction) {\n        return true;\n    }</mt:IfPreviousResults>\n    </mt:IfMoreResults>\n    /* ]]> */\n    </script>\n</head>\n<body id="<$mt:WebsiteThemeID$>" class="mt-search-results <$mt:Var name="page_layout"$>">\n    <div id="container">\n        <div id="container-inner">\n\n\n            <$mt:Include module="Banner Header"$>\n\n\n            <div id="content">\n                <div id="content-inner">\n\n\n                    <div id="alpha">\n                        <div id="alpha-inner">\n\n<mt:Ignore><!--\n    Below is the block to show search results.\n    This makes an independent block to support\n    Ajax-based background retrieval of the next search results.\n--></mt:Ignore>\n<mt:SetVarTemplate id="search_results" name="search_results">  \n<mt:SearchResults>\n    <mt:SearchResultsHeader>\n                            <div id="search-results">\n                                <span id="current-page" class="hidden"><$mt:CurrentPage$></span>\n                                <h1 id="page-title" class="search-results-header">\n        <mt:IfStraightSearch>\n                                    Results matching &ldquo;<$mt:SearchString$>&rdquo;\n        </mt:IfStraightSearch>\n        <mt:IfTagSearch>\n                                    Results tagged &ldquo;<$mt:SearchString$>&rdquo;\n        </mt:IfTagSearch>\n                                </h1>\n                                <div class="search-results-container autopagerize_page_element">\n    </mt:SearchResultsHeader>\n                                    <$mt:Include module="Entry Summary" hide_counts="1" display_blog_name="1" local="1"$>\n    <mt:SearchResultsFooter>\n                                </div><div class="autopagerize_insert_before"></div>\n\n    <mt:Ignore><!-- Used with the ajax search capability of the new search class --></mt:Ignore>\n                                <div class="content-nav">\n                                    <mt:IfPreviousResults><a href="<$mt:PreviousLink$>" rel="prev" onclick="return swapContent(-1);">&lt; Previous</a>&nbsp;&nbsp;</mt:IfPreviousResults><mt:PagerBlock><mt:IfCurrentPage><$mt:Var name="__value__"$><mt:Else><a href="<$mt:PagerLink$>"><$mt:Var name="__value__"$></a></mt:IfCurrentPage><mt:Unless name="__last__">&nbsp;</mt:Unless></mt:PagerBlock><mt:IfMoreResults>&nbsp;&nbsp;<a href="<$mt:NextLink$>" rel="next" onclick="return swapContent();">Next &gt;</a></mt:IfMoreResults>\n                                </div>\n                            </div>\n    </mt:SearchResultsFooter>\n</mt:SearchResults>\n</mt:SetVarTemplate>\n<mt:Ignore><!-- Display search results constructed in the block above --></mt:Ignore>\n<$mt:Var name="search_results"$>\n\n\n<mt:Ignore><!-- Display no results message --></mt:Ignore>\n<mt:NoSearchResults>\n                            <h1 id="page-title" class="search-results-header">\n    <mt:IfStraightSearch>\n                                Results matching &ldquo;<$mt:SearchString$>&rdquo;\n    </mt:IfStraightSearch>\n    <mt:IfTagSearch>\n                                Results tagged &ldquo;<$mt:SearchString$>&rdquo;\n    </mt:IfTagSearch>\n                            </h1>\n                            <p>No results found for &ldquo;<$mt:SearchString$>&rdquo;.</p>\n</mt:NoSearchResults>\n\n\n<mt:Ignore><!-- Display instructions for searching if search script was accessed without a query --></mt:Ignore>\n<mt:NoSearch>\n                            <h1 id="page-title" class="search-results-header">Instructions</h1>\n                            <p>By default, this search engine looks for all of the specified words in any order. To search for an exact phrase, enclose the phrase in quotes:</p>\n                            <blockquote>\n                                <p><code>"movable type"</code></p>\n                            </blockquote>\n                            <p>The search engine also supports the AND, OR, and NOT boolean operators:</p>\n                            <blockquote>\n                                <p><code>personal OR publishing</code></p>\n                                <p><code>publishing NOT personal</code></p>\n                            </blockquote>\n</mt:NoSearch>\n\n<mt:Ignore><!-- Used with the ajax search capability of the new search class --></mt:Ignore>\n<mt:IfMoreResults>\n<script type="text/javascript">\n<!--\nvar div = document.getElementById(''search-results'');\nvar results = {\n    ''<$mt:CurrentPage$>'': {\n        ''content'': div.innerHTML,\n        ''next_url'': ''<$mt:NextLink$>''\n    }\n};\nvar timer = window.setTimeout("getResults(" + <$mt:CurrentPage$> + ")", 1*1000);\n//-->\n</script>\n</mt:IfMoreResults>\n\n\n                        </div>\n                    </div>\n\n                    <$mt:Include module="Sidebar"$>\n\n\n                </div>\n            </div>\n\n\n            <$mt:Include module="Banner Footer"$>\n\n\n        </div>\n    </div>\n</body>\n</html>\n', 'search_results', 0),
(5, 1, 0, 0, 1, 1, '[[regtime]]', 'recent_assets', NULL, NULL, NULL, NULL, '[[regtime]]', 'Recent Assets', NULL, 1, '<mt:If tag="AssetCount" include_blogs="children" include_with_website="1">\n    <mt:Assets type="image" lastn="10" include_blogs="children" include_with_website="1">\n        <mt:AssetsHeader>\n<div class="widget-recent-assets widget">\n    <h3 class="widget-header">Recent Assets</h3>\n    <div class="widget-content">\n        <ul>\n        </mt:AssetsHeader>\n        <li class="item"><a class="asset-image" href="<$mt:AssetURL$>"><img src="<$mt:AssetThumbnailURL height="70"$>" class="asset-img-thumb" alt="<$mt:AssetLabel$>" title="<$mt:AssetLabel$>" /></a></li>\n        <mt:AssetsFooter>\n        </ul>\n    </div>\n</div>\n        </mt:AssetsFooter>\n    </mt:Assets>\n</mt:If>\n', 'widget', 0),
(6, 1, 0, 0, 1, 1, '[[regtime]]', 'rsd', NULL, NULL, NULL, NULL, '[[regtime]]', 'RSD', 'rsd.xml', 1, '<$mt:HTTPContentType type="application/rsd+xml"$><?xml version="1.0"?>\n<rsd version="1.0" xmlns="http://archipelago.phrasewise.com/rsd">\n<service>\n<engineName><$mt:ProductName version="1"$></engineName>\n<engineLink>http://www.sixapart.com/movabletype/</engineLink>\n<homePageLink><$mt:BlogURL$></homePageLink>\n<apis>\n<api name="MetaWeblog" preferred="true" apiLink="<$mt:CGIPath$><$mt:XMLRPCScript$>" blogID="<$mt:BlogID$>" />\n<api name="MovableType" preferred="false" apiLink="<$mt:CGIPath$><$mt:XMLRPCScript$>" blogID="<$mt:BlogID$>" />\n<api name="Blogger" preferred="false" apiLink="<$mt:CGIPath$><$mt:XMLRPCScript$>" blogID="<$mt:BlogID$>" />\n<api name="Atom" preferred="false" apiLink="<$mt:CGIPath$><$mt:AtomScript$>/weblog" blogID="<$mt:BlogID$>" />\n</apis>\n</service>\n</rsd>\n', 'index', 0),
(7, 1, 0, 0, 1, 1, '[[regtime]]', 'styles', NULL, NULL, NULL, NULL, '[[regtime]]', 'Stylesheet', 'styles.css', 1, '@import url(<$mt:StaticWebPath$>themes-base/blog.css);\n@import url(<$mt:StaticWebPath$>themes/minimalist-red/screen.css);\n', 'index', 0),
(8, 1, 0, 0, 1, 1, '[[regtime]]', 'feed_recent', NULL, NULL, NULL, NULL, '[[regtime]]', 'Feed - Recent Entries', 'atom.xml', 1, '<$mt:HTTPContentType type="application/atom+xml"$><?xml version="1.0" encoding="<$mt:PublishCharset$>"?>\n<feed xmlns="http://www.w3.org/2005/Atom">\n    <title><$mt:BlogName remove_html="1" encode_xml="1"$></title>\n    <link rel="alternate" type="text/html" href="<$mt:BlogURL encode_xml="1"$>" />\n    <link rel="self" type="application/atom+xml" href="<$mt:Link template="feed_recent"$>" />\n    <id>tag:<$mt:BlogHost exclude_port="1" encode_xml="1"$>,<$mt:TemplateCreatedOn format="%Y-%m-%d"$>:<$mt:BlogRelativeURL encode_xml="1"$>/<$mt:BlogID$></id>\n    <updated><mt:Entries blog_ids="children" lastn="1"><$mt:EntryModifiedDate utc="1" format="%Y-%m-%dT%H:%M:%SZ"$></mt:Entries></updated>\n    <mt:If tag="BlogDescription"><subtitle><$mt:BlogDescription remove_html="1" encode_xml="1"$></subtitle></mt:If>\n    <generator uri="http://www.sixapart.com/movabletype/"><$mt:ProductName version="1"$></generator>\n<mt:Entries blog_ids="children" lastn="15">\n<entry>\n    <title><$mt:EntryTitle remove_html="1" encode_xml="1"$> - <$mt:EntryBlogName$></title>\n    <link rel="alternate" type="text/html" href="<$mt:EntryPermalink encode_xml="1"$>" />\n    <id><$mt:EntryAtomID$></id>\n\n    <published><$mt:EntryDate utc="1" format="%Y-%m-%dT%H:%M:%SZ"$></published>\n    <updated><$mt:EntryModifiedDate utc="1" format="%Y-%m-%dT%H:%M:%SZ"$></updated>\n\n    <summary><$mt:EntryExcerpt remove_html="1" encode_xml="1"$></summary>\n    <author>\n        <name><$mt:EntryAuthorDisplayName encode_xml="1"$></name>\n        <mt:If tag="EntryAuthorURL"><uri><$mt:EntryAuthorURL encode_xml="1"$></uri></mt:If>\n    </author>\n    <mt:EntryCategories>\n        <category term="<$mt:CategoryLabel encode_xml="1"$>" scheme="http://www.sixapart.com/ns/types#category" />\n    </mt:EntryCategories>\n    <mt:EntryIfTagged><mt:EntryTags><category term="<$mt:TagName normalize="1" encode_xml="1"$>" label="<$mt:TagName encode_xml="1"$>" scheme="http://www.sixapart.com/ns/types#tag" />\n    </mt:EntryTags></mt:EntryIfTagged>\n    <content type="html" xml:lang="<$mt:BlogLanguage ietf="1"$>" xml:base="<$mt:BlogURL encode_xml="1"$>">\n        <$mt:EntryBody encode_xml="1"$>\n        <$mt:EntryMore encode_xml="1"$>\n    </content>\n</entry>\n</mt:Entries>\n</feed>\n', 'index', 0),
(9, 1, 0, 0, 1, 1, '[[regtime]]', 'popup_image', NULL, NULL, NULL, NULL, '[[regtime]]', 'Popup Image', NULL, 1, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" id="sixapart-standard">\n<head><title><$mt:ImageURL$></title></head>\n<body id="uploaded-image-popup" class="popup" style="margin: 0;padding: 0;">\n    <img src="<$mt:ImageURL$>" width="<$mt:ImageWidth$>" height="<$mt:ImageHeight$>" alt="<$mt:ImageURL$>" style="margin: 0;padding: 0;border: 0;" />\n</body>\n</html>\n', 'popup_image', 0),
(10, 1, 0, 0, 1, 1, '[[regtime]]', 'tag_cloud', NULL, NULL, NULL, NULL, '[[regtime]]', 'Tag Cloud', NULL, 1, '<mt:Tags top="20" include_blogs="children" include_with_website="1">\n<mt:If name="__first__">\n<div class="widget-tag-cloud widget">\n    <h3 class="widget-header">Tag Cloud</h3>\n    <div class="widget-content">\n        <ul>\n</mt:If>\n            <li class="rank-<$mt:TagRank max="10"$>"><a href="javascript:void(0)" onclick="location.href=''<$mt:TagSearchLink encode_js="1"$>'';return false;" rel="tag"><$mt:TagName$></a></li>\n<mt:If name="__last__">\n        </ul>\n    </div>\n</div>\n</mt:If>\n</mt:Tags>\n', 'widget', 0),
(11, 1, 0, 0, 1, 1, '[[regtime]]', 'banner_header', NULL, NULL, NULL, NULL, '[[regtime]]', 'Banner Header', NULL, 1, '<div id="header">\n    <div id="header-inner">\n        <div id="header-content">\n<mt:Ignore><!-- Use h1 and h2 html tags on the main index of the blog as the title, use divs on all other pages where there are page titles. --></mt:Ignore>\n<mt:If name="main_index">\n            <h1 id="header-name"><a href="<$mt:BlogURL$>" accesskey="1"><$mt:BlogName encode_html="1"$></a></h1>\n            <h2 id="header-description"><$mt:BlogDescription$></h2>\n<mt:Else>\n            <div id="header-name"><a href="<$mt:BlogURL$>" accesskey="1"><$mt:BlogName encode_html="1"$></a></div>\n            <div id="header-description"><$mt:BlogDescription$></div>\n</mt:If>\n        </div>\n    </div>\n</div>\n', 'custom', 0),
(12, 1, 0, 0, 1, 1, '[[regtime]]', 'technorati_search', NULL, NULL, NULL, NULL, '[[regtime]]', 'Technorati Search', NULL, 1, '<div class="widget-technorati widget">\n    <h3 class="widget-header">Technorati</h3>\n    <div class="widget-content">\n        <div id="technorati">\n            <form id="ts_s" method="post" action="http://technorati.com/search.php">\n                <fieldset>\n                    <legend><a href=''http://www.technorati.com/''>Technorati</a> search</legend>\n                    <input type="hidden" name="sub" value="searchlet" />\n                    <input type="text" id="ts_search" name="s" size="12" maxlength="255" value="" /><br />\n                    <input type="radio" checked="checked" name="from" id="ts_yb" value="<$mt:BlogURL$>" />\n                    <label for="ts_yb" title="<$mt:BlogName$>">this blog</label>\n                    <input type="radio" name="from" id="ts_www" value="" /> <label for="ts_www">all blogs</label>\n                    <input type="submit" class="btn" value="Search" />\n                </fieldset>\n            </form>\n            <p id="ts_l" class="ts_l"><a href="http://technorati.com/search/<$mt:BlogURL$>" id="ts_lh">&#187; Blogs that link here</a></p>\n        </div>\n    </div>\n</div>\n', 'widget', 0),
(13, 1, 0, 0, 1, 1, '[[regtime]]', 'recent_entries', NULL, NULL, NULL, NULL, '[[regtime]]', 'Recent Entries', NULL, 1, '<mt:If tag="BlogEntryCount" include_blogs="children">\n    <mt:Entries lastn="10" include_blogs="children">\n        <mt:EntriesHeader>\n<div class="widget-recent-entries widget-archives widget">\n    <h3 class="widget-header">Recent Entries</h3>\n    <div class="widget-content">\n        <ul>\n        </mt:EntriesHeader>\n            <li><a href="<$mt:EntryPermalink$>"><$mt:EntryTitle$></a> - <a href="<$mt:EntryBlogURL$>"><$mt:EntryBlogName$></a></li>\n        <mt:EntriesFooter>\n        </ul>\n    </div>\n</div>\n        </mt:EntriesFooter>\n    </mt:Entries>\n</mt:If>\n', 'widget', 0),
(14, 1, 0, 0, 1, 1, '[[regtime]]', 'powered_by', NULL, NULL, NULL, NULL, '[[regtime]]', 'Powered By', NULL, 1, '<div class="widget-powered widget">\n    <div class="widget-content">\n        <a href="http://www.movabletype.com/"><img src="<$mt:StaticWebPath$>images/bug-pbmt-white.png" alt="Powered by Movable Type <$mt:Version$>" width="120" height="75" /></a>\n    </div>\n</div>\n', 'widget', 0),
(15, 1, 0, 0, 1, 1, '[[regtime]]', 'pages_list', NULL, NULL, NULL, NULL, '[[regtime]]', 'Page Listing', NULL, 1, '<mt:IfArchiveTypeEnabled archive_type="Page">\n<div class="widget-pages widget">\n    <h3 class="widget-header">Pages</h3>\n    <div class="widget-content">\n        <ul>\n    <mt:Pages no_folder="1" sort_by="title" sort_order="ascend">\n            <li class="page page-<$mt:PageID$>"><a href="<$mt:PagePermalink$>"><$mt:PageTitle$></a></li>\n    </mt:Pages>\n    <mt:TopLevelFolders>\n            <li class="folder folder-<$mt:FolderID$>"><strong><$mt:FolderLabel$></strong>\n        <mt:Pages sort_by="title" sort_order="ascend">\n            <mt:PagesHeader>\n                <ul>\n            </mt:PagesHeader>\n                    <li class="page page-<$mt:PageID$>"><a href="<$mt:PagePermalink$>"><$mt:PageTitle$></a></li>\n            <mt:PagesFooter>\n                </ul>\n            </mt:PagesFooter>\n        </mt:Pages>\n            </li>\n        <$mt:SubFolderRecurse$>\n    </mt:TopLevelFolders>\n        </ul>\n    </div>\n</div>\n</mt:IfArchiveTypeEnabled>\n', 'widget', 0),
(16, 1, 0, 0, 1, 1, '[[regtime]]', 'comments', NULL, NULL, NULL, NULL, '[[regtime]]', 'Comments', NULL, 1, '<mt:Ignore>\n<!-- Display comments for the entry/page or commenting form if entry/page is accepting comments -->\n</mt:Ignore>\n<mt:IfCommentsActive>\n\n<div id="comments" class="comments">\n\n\n    <mt:Ignore>\n    <!-- Display comments -->\n    </mt:Ignore>\n    <mt:Comments lastn="$comments_per_page">\n        <mt:CommentsHeader>\n    <h2 class="comments-header"><$mt:EntryCommentCount singular="1 Comment" plural="# Comments" none="No Comments"$></h2>\n            <mt:If tag="EntryCommentCount" gt="$comments_per_page">\n    <ul id="top-comment-nav">\n        <li id="top-prev-comments">\n            <a href="javascript://" id="top-prev-comments-link" title="Previous">&lt;&lt;&nbsp;Previous</a>\n        </li>\n        <li id="top-num-comments">\n            <span id="top-current-comments"></span>\n        </li>\n        <li id="top-next-comments">\n            <a href="javascript://" id="top-next-comments-link" title="Next">Next&nbsp;&gt;&gt;</a>\n        </li>\n    </ul>\n            </mt:If>\n    <div id="comments-content" class="comments-content">\n        </mt:CommentsHeader>\n        <$mt:Include module="Comment Detail"$>\n        <mt:CommentsFooter>\n    </div>\n            <mt:If tag="EntryCommentCount" gt="$comments_per_page">\n                <mt:Ignore>The data is modified by the paginate script</mt:Ignore>\n    <ul id="comment-nav">\n        <li id="prev-comments">\n            <a href="javascript://" id="prev-comments-link" title="Previous">&lt;&lt;&nbsp;Previous</a>\n        </li>\n        <li id="num-comments">\n            <span id="current-comments"></span>\n        </li>\n        <li id="next-comments">\n            <a href="javascript://" id="next-comments-link" title="Next">Next&nbsp;&gt;&gt;</a>\n        </li>\n    </ul>\n            </mt:If>\n        </mt:CommentsFooter>\n    </mt:Comments>\n    <mt:Ignore>\n    <!-- Display commenting form if entry/page is accepting comments -->\n    </mt:Ignore>\n    <mt:IfCommentsAccepted>\n    <div class="comments-open" id="comments-open">\n        <h2 class="comments-open-header">Leave a comment</h2>\n        <div class="comments-open-content">\n\n        <mt:Ignore>\n        <!-- Display greeting for users if blog allows users to register locally -->\n        </mt:Ignore>\n            <div id="comment-greeting"></div>\n\n            <form method="post" action="<$mt:CGIPath$><$mt:CommentScript$>" name="comments_form" id="comments-form" onsubmit="return mtCommentOnSubmit(this)">\n                <input type="hidden" name="static" value="1" />\n                <input type="hidden" name="entry_id" value="<$mt:EntryID$>" />\n                <input type="hidden" name="__lang" value="<$mt:BlogLanguage$>" />\n                <input type="hidden" name="parent_id" value="<$mt:CommentParentID escape="html"$>" id="comment-parent-id" />\n                <input type="hidden" name="armor" value="1" />\n                <input type="hidden" name="preview" value="" />\n                <input type="hidden" name="sid" value="" />\n                <div id="comments-open-data">\n                    <div id="comment-form-name">\n                        <label for="comment-author">Name</label>\n                        <input id="comment-author" name="author" size="30" value="" onfocus="mtCommentFormOnFocus()" />\n                    </div>\n                    <div id="comment-form-email">\n                        <label for="comment-email">Email Address</label>\n                        <input id="comment-email" name="email" size="30" value="" onfocus="mtCommentFormOnFocus()" />\n                    </div>\n                    <div id="comment-form-url">\n                        <label for="comment-url">URL</label>\n                        <input id="comment-url" name="url" size="30" value="" onfocus="mtCommentFormOnFocus()" />\n                    </div>\n                    <div id="comment-form-remember-me">\n                        <input type="checkbox" id="comment-bake-cookie" name="bakecookie" onclick="mtRememberMeOnClick(this)" value="1" accesskey="r" />\n                        <label for="comment-bake-cookie">Remember personal info?</label>\n                    </div>\n                </div>\n                <div id="comment-form-reply" style="display:none">\n                    <input type="checkbox" id="comment-reply" name="comment_reply" value="" onclick="mtSetCommentParentID()" />\n                    <label for="comment-reply" id="comment-reply-label"></label>\n                </div>\n                <div id="comments-open-text">\n                    <label for="comment-text">Comments\n                    <mt:IfAllowCommentHTML>(You may use HTML tags for style)</mt:IfAllowCommentHTML></label>\n                    <textarea id="comment-text" name="text" rows="15" cols="50" onfocus="mtCommentFormOnFocus()"></textarea>\n                </div>\n                <div id="comments-open-captcha"></div>\n                <div id="comments-open-footer">\n                    <input type="submit" accesskey="v" name="preview_button" id="comment-preview" value="Preview" onclick="this.form.preview.value=''1'';" />\n                    <input type="submit" accesskey="s" name="post" id="comment-submit" value="Submit" />\n                </div>\n            </form>\n\n\n        </div>\n    </div>\n    <script type="text/javascript">\n    <!--\n    mtAttachEvent("load", mtEntryOnLoad);\n    mtAttachEvent("unload", mtEntryOnUnload);\n    //-->\n    </script>\n    </mt:IfCommentsAccepted>\n\n\n</div>\n</mt:IfCommentsActive>\n', 'custom', 0),
(17, 1, 0, 0, 1, 1, '[[regtime]]', 'page', NULL, NULL, NULL, NULL, '[[regtime]]', 'Page', NULL, 1, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"\n    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" id="sixapart-standard">\n<head>\n    <$mt:Include module="HTML Head"$>\n    <$mt:EntryTrackbackData$>\n    <$mt:Var name="comments_per_page" value="50"$>\n    <mt:If tag="EntryCommentCount" gt="$comments_per_page">\n	    <script type="text/javascript">\n         MT.entryID = <$mt:PageID$>;\n         MT.commentsPerPage = <$mt:Var name="comments_per_page"$>;\n         MT.entryCommentCount = <$mt:EntryCommentCount$>;\n         MT.commentIds = [<mt:Comments sort_order="ascend" glue=","><mt:CommentID></mt:Comments>];\n	    </script>\n    </mt:If>\n    <title><$mt:PageTitle encode_html="1"$> - <$mt:BlogName encode_html="1"$></title>\n</head>\n<body id="<$mt:WebsiteThemeID$>" class="mt-page-archive <$mt:Var name="page_layout"$>">\n    <div id="container">\n        <div id="container-inner">\n\n\n            <$mt:Include module="Banner Header"$>\n\n\n            <div id="content">\n                <div id="content-inner">\n\n\n                    <div id="alpha">\n                        <div id="alpha-inner">\n\n\n                            <div id="page-<$mt:PageID$>" class="page-asset asset">\n                                <div class="asset-header">\n                                    <h1 id="page-title" class="asset-name"><$mt:PageTitle$></h1>\n                                </div>\n                                <div class="asset-content">\n<mt:If tag="PageBody">\n                                    <div class="asset-body">\n                                        <$mt:PageBody$>\n                                    </div>\n</mt:If>\n<mt:If tag="PageMore">\n                                    <div id="more" class="asset-more">\n                                        <$mt:PageMore$>\n                                    </div>\n</mt:If>\n                                </div>\n                                <div class="asset-footer"></div>\n                            </div>\n\n\n                    <$mt:Include module="Trackbacks"$>\n                    <$mt:Include module="Comments"$>\n\n\n                        </div>\n                    </div>\n\n\n                    <$mt:Include module="Sidebar"$>\n\n\n                </div>\n            </div>\n\n\n            <$mt:Include module="Banner Footer"$>\n\n\n        </div>\n    </div>\n</body>\n</html>\n', 'page', 0),
(18, 1, 0, 0, 1, 1, '[[regtime]]', 'sidebar', NULL, NULL, NULL, NULL, '[[regtime]]', 'Sidebar', NULL, 1, '<mt:Ignore><!-- \n#\n#  The sidebar is made up of one or two columns.\n#  For 2-column designs, just beta.\n#  For 3-column designs, beta and gamma.\n#\n--></mt:Ignore>\n\n\n<div id="beta">\n    <div id="beta-inner">\n\n<mt:If name="page_columns" eq="2">\n    <mt:Ignore><!-- Use the 2-column layout Sidebar if page layout is layout-wt or layout-tw. --></mt:Ignore>\n    <$mt:WidgetSet name="2-column layout - Sidebar"$>\n<mt:Else name="page_columns" eq="3">\n    <mt:Ignore><!-- Use the 3-column layout Primary Sidebar if page layout is layout-wtt or layout-twt. --></mt:Ignore>\n    <$mt:WidgetSet name="3-column layout - Primary Sidebar"$>\n</mt:If>\n\n    </div>\n</div>\n\n\n<mt:If name="page_columns" eq="3">\n    <mt:Ignore><!-- Use the 3-column layout Secondary Sidebar if page layout is layout-wtt or layout-twt. --></mt:Ignore>\n<div id="gamma">\n    <div id="gamma-inner">\n    <$mt:WidgetSet name="3-column layout - Secondary Sidebar"$>\n    </div>\n</div>\n</mt:If>\n', 'custom', 0),
(19, 1, 0, 0, 1, 1, '[[regtime]]', 'comment_detail', NULL, NULL, NULL, NULL, '[[regtime]]', 'Comment Detail', NULL, 1, '<div id="comment-<$mt:CommentID$>" class="comment<mt:IfCommentParent> comment-reply</mt:IfCommentParent><mt:IfCommenterIsEntryAuthor> entry-author-comment</mt:IfCommenterIsEntryAuthor>">\n    <div class="inner">\n        <div class="comment-header">\n            <div class="asset-meta">\n                <span class="byline">\n                    <$mt:CommentAuthorIdentity$>\n<mt:IfCommentParent>\n                    <span class="vcard author"><$mt:CommentAuthorLink$></span> replied to <a href="<mt:CommentParent><$mt:CommentLink$></mt:CommentParent>">comment from <mt:CommentParent><$mt:CommentAuthor$></mt:CommentParent></a>\n<mt:Else>\n                    <span class="vcard author"><$mt:CommentAuthorLink$></span>\n</mt:IfCommentParent>\n                    | <a href="<$mt:CommentLink$>"><abbr class="published" title="<$mt:CommentDate format_name="iso8601"$>"><$mt:CommentDate$></abbr></a>\n<mt:IfCommentsAccepted>\n                    | <$mt:CommentReplyToLink$>\n</mt:IfCommentsAccepted>\n                </span>\n            </div>\n        </div>\n        <div class="comment-content">\n            <$mt:CommentBody$>\n        </div>\n    </div>\n</div>', 'custom', 0),
(20, 1, 0, 0, 1, 1, '[[regtime]]', 'signin', NULL, NULL, NULL, NULL, '[[regtime]]', 'Sign In', NULL, 1, '<mt:IfRegistrationAllowed>\n<div class="widget-sign-in widget">\n    <h3 class="widget-header">Sign In</h3>\n    <div id="signin-widget-content" class="widget-content"></div>\n</div>\n<script type="text/javascript">\n/* <![CDATA[ */\nfunction mtUpdateSignInWidget(u) {\n    var el = document.getElementById(''signin-widget-content'');\n    var content = '''';\n    if (!el) return;\n    if (u) {\n        if (u && u.is_authenticated) {\n            user = u;\n            mtSaveUser();\n        } else {\n            // user really isn''t logged in; so let''s do this!\n            return mtSignIn();\n        }\n    } else {\n        u = mtGetUser();\n    }\n    if (u && u.name) {\n        var url;\n        if (u.is_authenticated) {\n            if (u.is_author) {\n                url = ''<$mt:CGIPath$><$mt:CommentScript$>?__mode=edit_profile'';\n                url += ''&return_url='' + encodeURIComponent( location.href );\n            } else {\n                url = u.url;\n            }\n        } else if (u.url) {\n            url = u.url;\n        } else {\n            url = null;\n        }\n        var content = ''You are signed in as '';\n        if (url)\n            content += ''<a href="'' + url + ''">'' + u.name + ''</a>'';\n        else\n            content += u.name;\n        content += ''.  (<a href="javascript:void(0)" onclick="return mtSignOutOnClick()">sign out</a>)'';\n    } else if (u && u.is_banned) {\n        content = ''You do not have permission to sign in to this blog.'';\n    } else {\n        content = ''<a href="javascript:void(0)" onclick="return mtSignInOnClick(\\''signin-widget-content\\'')">Sign In</a>'';\n    }\n    el.innerHTML = content;\n}\nmtAttachEvent(''usersignin'', mtUpdateSignInWidget);\nmtUpdateSignInWidget();\n/* ]]> */\n</script>\n</mt:IfRegistrationAllowed>\n', 'widget', 0),
(21, 1, 0, 0, 1, 1, '[[regtime]]', 'openid', NULL, NULL, NULL, NULL, '[[regtime]]', 'OpenID Accepted', NULL, 1, '<mt:IfRegistrationAllowed type="OpenID">\n<div class="widget-openid widget">\n    <div class="widget-content">\n        <em><strong>OpenID</strong> accepted here</em>\n        <a href="http://www.sixapart.com/labs/openid/">Learn more about OpenID</a>\n    </div>\n</div>\n</mt:IfRegistrationAllowed>\n', 'widget', 0),
(22, 1, 0, 0, 1, 1, '[[regtime]]', 'creative_commons', NULL, NULL, NULL, NULL, '[[regtime]]', 'Creative Commons', NULL, 1, '<mt:BlogIfCCLicense>\n<div class="widget-creative-commons widget">\n   <div class="widget-content">\n      <a href="<$mt:BlogCCLicenseURL$>"><img alt="Creative Commons License" src="<$mt:BlogCCLicenseImage$>" /></a><br />\n      This blog is licensed under a <a href="<$mt:BlogCCLicenseURL$>">Creative Commons License</a>.\n   </div>\n</div>\n</mt:BlogIfCCLicense>\n', 'widget', 0),
(23, 1, 0, 0, 1, 1, '[[regtime]]', 'blogs', NULL, NULL, NULL, NULL, '[[regtime]]', 'Blogs', NULL, 1, '<mt:Blogs include_blogs="children">\n    <mt:If name="__first__">\n<div class="widget-blogs widget-archives widget">\n    <h3 class="widget-header">Blogs</h3>\n    <div class="widget-content">\n        <ul>\n        </mt:If>\n            <li><a href="<$mt:BlogURL$>"><$mt:BlogName$></a></li>\n        <mt:If name="__last__">\n        </ul>\n    </div>\n</div>\n        </mt:If>\n</mt:Blogs>\n', 'widget', 0),
(24, 1, 0, 0, 1, 1, '[[regtime]]', 'banner_footer', NULL, NULL, NULL, NULL, '[[regtime]]', 'Banner Footer', NULL, 1, '<div id="footer">\n    <div id="footer-inner">\n        <div id="footer-content">\n            <div class="widget-powered widget">\n                <div class="widget-content">\n                    Powered by <a href="http://www.movabletype.org/"><$MTProductName$></a>\n                </div>\n            </div>\n<mt:BlogIfCCLicense>\n            <div class="widget-creative-commons widget">\n                <div class="widget-content">\n                    This blog is licensed under a <a href="<$mt:BlogCCLicenseURL$>">Creative Commons License</a>.\n                </div>\n            </div>\n</mt:BlogIfCCLicense>\n        </div>\n    </div>\n</div>\n', 'custom', 0),
(25, 1, 0, 0, 1, 1, '[[regtime]]', 'comment_response', NULL, NULL, NULL, NULL, '[[regtime]]', 'Comment Response', NULL, 1, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"\n    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" id="sixapart-standard">\n<head>\n\n\n<mt:If name="comment_confirmation">\n    <mt:Ignore><!-- Success message when comment has been submitted --></mt:Ignore>\n    <$mt:Var name="page_title" value="Confirmation..."$>\n    <$mt:Var name="message" value="<p>Your comment has been submitted!</p>"$>\n<mt:Else name="comment_pending">\n    <mt:Ignore><!-- Pending message when comment is being held for review --></mt:Ignore>\n    <$mt:Var name="page_title" value="Thank you for commenting."$>\n    <$mt:Var name="message" value="<p>Your comment has been received and held for review by a blog administrator.</p>"$>\n<mt:Else name="comment_error">\n    <mt:Ignore><!-- Error message when comment submission fails --></mt:Ignore>\n    <$mt:Var name="page_title" value="Comment Submission Error"$>\n    <mt:SetVarBlock name="message"><p>Your comment submission failed for the following reasons: <$mt:ErrorMessage encode_html="1"$></p></mt:SetVarBlock>\n</mt:If>\n\n\n    <$mt:Include module="HTML Head"$>\n    <title><$mt:BlogName encode_html="1"$>: <$mt:Var name="page_title"$></title>\n</head>\n<body id="<$mt:WebsiteThemeID$>" class="<$mt:Var name="body_class"$> <$mt:Var name="page_layout"$>">\n    <div id="container">\n        <div id="container-inner">\n\n\n            <$mt:Include module="Banner Header"$>\n\n\n            <div id="content">\n                <div id="content-inner">\n\n\n                    <div id="alpha">\n                        <div id="alpha-inner">\n                            <h1 id="page-title"><$mt:Var name="page_title"$></h1>\n                            <$mt:Var name="message"$>\n                            <p>\n                            <mt:If name="comment_error">\n                                <a href="javascript:history.back()">Back</a>\n                            <mt:Else>\n                                Return to the <a href="<$mt:EntryLink$>">original entry</a>.\n                            </mt:If>\n                            </p>\n                        </div>\n                    </div>\n\n\n                    <$mt:Include module="Sidebar"$>\n\n\n                </div>\n            </div>\n\n\n            <$mt:Include module="Banner Footer"$>\n\n\n        </div>\n    </div>\n</body>\n</html>\n', 'comment_response', 0),
(26, 1, 0, 0, 1, 1, '[[regtime]]', 'syndication', NULL, NULL, NULL, NULL, '[[regtime]]', 'Syndication', NULL, 1, '<div class="widget-syndication widget">\n    <div class="widget-content">\n        <ul>\n            <li><img src="<$mt:StaticWebPath$>images/status_icons/feed.gif" alt="Subscribe to feed" width="9" height="9" /> <a href="<$mt:Link template="feed_recent"$>">Subscribe to this website''s feed</a></li>\n<mt:If name="search_results">\n    <mt:If tag="SearchString">\n            <li class="search-results-feed"><img src="<$mt:StaticWebPath$>images/status_icons/feed.gif" alt="Subscribe to feed" width="9" height="9" /> <a href="<$mt:CGIPath$><$mt:SearchScript$>?<mt:IfTagSearch>tag<mt:else>search</mt:IfTagSearch>=<$mt:SearchString encode_url="1"$>&amp;Template=feed&amp;IncludeBlogs=<$mt:SearchIncludeBlogs$>&amp;limit=<$mt:SearchMaxResults$>" title="<mt:IfTagSearch>Subscribe to a feed of all future entries tagged &ldquo;<$mt:SearchString$>&ldquo;<mt:Else>Subscribe to a feed of all future entries matching &ldquo;<$mt:SearchString$>&ldquo;</mt:IfTagSearch>"><mt:IfTagSearch>Feed of results tagged &ldquo;<$mt:SearchString$>&ldquo;<mt:Else>Feed of results matching &ldquo;<$mt:SearchString$>&ldquo;</mt:IfTagSearch></a></li>\n    </mt:If>\n</mt:If>\n        </ul>\n    </div>\n</div>\n', 'widget', 0),
(27, 1, 0, 0, 1, 1, '[[regtime]]', 'dynamic_error', NULL, NULL, NULL, NULL, '[[regtime]]', 'Dynamic Error', NULL, 1, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"\n    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" id="sixapart-standard">\n<head>\n    <$mt:Include module="HTML Head"$>\n    <title><$mt:BlogName encode_html="1"$>: Page Not Found</title>\n</head>\n<body id="<$mt:WebsiteThemeID$>" class="mt-dynamic-error <$mt:Var name="page_layout"$>">\n    <div id="container">\n        <div id="container-inner">\n\n\n            <$mt:Include module="Banner Header"$>\n\n\n            <div id="content">\n                <div id="content-inner">\n\n\n                    <div id="alpha">\n                        <div id="alpha-inner">\n                            <h1 id="page-title">Page Not Found</h1>\n                            <blockquote>\n                                <strong><$mt:ErrorMessage$></strong>\n                            </blockquote>\n                        </div>\n                    </div>\n\n\n                    <$mt:Include module="Sidebar"$>\n\n\n                </div>\n            </div>\n\n\n            <$mt:Include module="Banner Footer"$>\n\n\n        </div>\n    </div>\n</body>\n</html>\n', 'dynamic_error', 0);
INSERT INTO `mt_template` VALUES
(28, 1, 0, 0, 1, 1, '[[regtime]]', 'javascript', NULL, NULL, NULL, NULL, '[[regtime]]', 'JavaScript', 'mt.js', 1, '<mt:Ignore>\n/*  The following functions and variables are here to support legacy MT templates.\n    If you have refreshed your JavaScript template but still use older MT comment\n    templates, you may need to uncomment this block in order for those templates \n    to work properly. To use, simply remove the ''mt:Ignore'' tags wrapping this\n    block of code.\n*/\n    function hideDocumentElement(id) { return mtHide(id) }\n    function showDocumentElement(id) { return mtShow(id) }\n    function individualArchivesOnLoad() { return mtEntryOnLoad() }\n    function writeCommenterGreeting() { return mtShowGreeting() }\n    function rememberMe(f) { return mtRememberMe(f) }\n    function forgetMe(f) { return mtForgetMe(f) }\n    var commenter_name;\n    var commenter_id;\n    var commenter_url;\n    var commenter_blog_ids;\n    var mtcmtmail;\n    var mtcmtauth;\n    var mtcmthome;\n    var captcha_timer;\n</mt:Ignore>\n\n// The cookie name to use for storing the blog-side comment session cookie.\nvar mtCookieName = "<$mt:UserSessionCookieName$>";\nvar mtCookieDomain = "<$mt:UserSessionCookieDomain$>";\nvar mtCookiePath = "<$mt:UserSessionCookiePath$>";\nvar mtCookieTimeout = <$mt:UserSessionCookieTimeout$>;\n\n<mt:Ignore>\n/***\n * Simple routine for showing a DOM element (applying a CSS display\n * attribute of ''none'').\n */\n</mt:Ignore>\nfunction mtHide(id) {\n    var el = (typeof id == "string") ? document.getElementById(id) : id;\n    if (el) el.style.display = ''none'';\n}\n\n<mt:Ignore>\n/***\n * Simple routine for showing a DOM element (applying a CSS display\n * attribute of ''block'').\n */\n</mt:Ignore>\nfunction mtShow(id) {\n    var el = (typeof id == "string") ? document.getElementById(id) : id;\n    if (el) el.style.display = ''block'';\n}\n\n<mt:Ignore>\n/***\n * A utility function for assigning/adding handlers to window events.\n */\n</mt:Ignore>\nfunction mtAttachEvent(eventName,func) {\n    var onEventName = ''on'' + eventName;\n    var old = window[onEventName];\n    if( typeof old != ''function'' )\n        window[onEventName] = func;\n    else {\n        window[onEventName] = function( evt ) {\n            old( evt );\n            return func( evt );\n        };\n    }\n}\n\n<mt:Ignore>\n/***\n * Calls the event named, if there are handlers for it.\n */\n</mt:Ignore>\nfunction mtFireEvent(eventName,param) {\n    var fn = window[''on'' + eventName];\n    if (typeof fn == ''function'') return fn(param);\n    return;\n}\n\nif(!this.JSON){JSON={};}(function(){function f(n){return n<10?''0''+n:n;}if(typeof Date.prototype.toJSON!==''function''){Date.prototype.toJSON=function(key){return this.getUTCFullYear()+''-''+f(this.getUTCMonth()+1)+''-''+f(this.getUTCDate())+''T''+f(this.getUTCHours())+'':''+f(this.getUTCMinutes())+'':''+f(this.getUTCSeconds())+''Z'';};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf();};}var cx=/[\\u0000\\u00ad\\u0600-\\u0604\\u070f\\u17b4\\u17b5\\u200c-\\u200f\\u2028-\\u202f\\u2060-\\u206f\\ufeff\\ufff0-\\uffff]/g,escapable=/[\\\\\\"\\x00-\\x1f\\x7f-\\x9f\\u00ad\\u0600-\\u0604\\u070f\\u17b4\\u17b5\\u200c-\\u200f\\u2028-\\u202f\\u2060-\\u206f\\ufeff\\ufff0-\\uffff]/g,gap,indent,meta={''\\b'':''\\\\b'',''\\t'':''\\\\t'',''\\n'':''\\\\n'',''\\f'':''\\\\f'',''\\r'':''\\\\r'',''"'':''\\\\"'',''\\\\'':''\\\\\\\\''},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?''"''+string.replace(escapable,function(a){var c=meta[a];return typeof c===''string''?c:''\\\\u''+(''0000''+a.charCodeAt(0).toString(16)).slice(-4);})+''"'':''"''+string+''"'';}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value===''object''&&typeof value.toJSON===''function''){value=value.toJSON(key);}if(typeof rep===''function''){value=rep.call(holder,key,value);}switch(typeof value){case''string'':return quote(value);case''number'':return isFinite(value)?String(value):''null'';case''boolean'':case''null'':return String(value);case''object'':if(!value){return''null'';}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)===''[object Array]''){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||''null'';}v=partial.length===0?''[]'':gap?''[\\n''+gap+partial.join('',\\n''+gap)+''\\n''+mind+'']'':''[''+partial.join('','')+'']'';gap=mind;return v;}if(rep&&typeof rep===''object''){length=rep.length;for(i=0;i<length;i+=1){k=rep[i];if(typeof k===''string''){v=str(k,value);if(v){partial.push(quote(k)+(gap?'': '':'':'')+v);}}}}else{for(k in value){if(Object.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?'': '':'':'')+v);}}}}v=partial.length===0?''{}'':gap?''{\\n''+gap+partial.join('',\\n''+gap)+''\\n''+mind+''}'':''{''+partial.join('','')+''}'';gap=mind;return v;}}if(typeof JSON.stringify!==''function''){JSON.stringify=function(value,replacer,space){var i;gap='''';indent='''';if(typeof space===''number''){for(i=0;i<space;i+=1){indent+='' '';}}else if(typeof space===''string''){indent=space;}rep=replacer;if(replacer&&typeof replacer!==''function''&&(typeof replacer!==''object''||typeof replacer.length!==''number'')){throw new Error(''JSON.stringify'');}return str('''',{'''':value});};}if(typeof JSON.parse!==''function''){JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value===''object''){for(k in value){if(Object.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v;}else{delete value[k];}}}}return reviver.call(holder,key,value);}cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return''\\\\u''+(''0000''+a.charCodeAt(0).toString(16)).slice(-4);});}if(/^[\\],:{}\\s]*$/.test(text.replace(/\\\\(?:["\\\\\\/bfnrt]|u[0-9a-fA-F]{4})/g,''@'').replace(/"[^"\\\\\\n\\r]*"|true|false|null|-?\\d+(?:\\.\\d*)?(?:[eE][+\\-]?\\d+)?/g,'']'').replace(/(?:^|:|,)(?:\\s*\\[)+/g,''''))){j=eval(''(''+text+'')'');return typeof reviver===''function''?walk({'''':j},''''):j;}throw new SyntaxError(''JSON.parse'');};}}());\n\nvar MT = window.MT || {};\n\nMT.cons = function () {\n  return {\n    LOG : ''log'',\n    WARN : ''warn'',\n    DEBUG : ''debug'',\n    INFO : ''info'',\n    ERR : ''error'',\n    JSON : ''json''\n  };\n}();\n\n<mt:Ignore>\n/**\n * Used for base functionality related to MT\n * \n * @package MT\n * @class core\n * @global\n * @param {Object} o optional configuration object\n * Options:\n */\n</mt:Ignore>\nMT.core = function (o) {\n  var _debug = false;\n  \n  return {\n    <mt:Ignore>\n    /**\n     * Makes remote call and handles response\n     * \n     * @param {String} url The URL endpoint\n     * @param {String} respType The type of response expected\n     * @param {Function} respHandler The function to handle the response\n     * @return void\n     */\n    </mt:Ignore>\n    connect : function (url,respType,respHandler) {\n      var xh = mtGetXmlHttp();\n      if (!xh) return false;\n      \n      xh.onreadystatechange = function() {\n        if ( xh.readyState == 4 ) {\n          if ( xh.status && ( xh.status != 200 ) ) {\n            // error - ignore\n          } else {\n            switch (respType) {\n              case ''json'':\n                respHandler(JSON.parse(xh.responseText));\n                break;\n                \n              case ''xml'':\n                break;\n                \n              case ''text'':\n                break;\n            }\n          }\n        }\n      };\n      \n      xh.open(''GET'',url);\n      xh.send(null);\n    },\n    \n    getEl : function (el) {\n      return MT.util.checkNodeType(el)===''element'' ? id : (document.getElementById(el) || false);\n    },\n    \n    addEvent : function (el,type,func,obj) {\n      if(!obj && document.addEventListener) {\n        el.addEventListener(type,func,false);\n      } else if(obj && document.addEventListener) {\n        el.addEventListener(type,function () {\n          func.call(obj,event);\n        },false);\n      } else {\n        if(obj) {\n          el.attachEvent(''on'' + type,function () {\n            func.call(obj,event);\n          });\n        } else {\n          el.attachEvent(''on'' + type,function () {          \n            func.call(el,event);\n          });\n        }\n      }\n    },\n    \n    <mt:Ignore>\n    /**\n     * Basic logging function\n     * \n     * @param {String} level The log level (WARN|DEBUG|INFO|ERROR|LOG)\n     * Specified by one of the MT constants\n     * @param {String} msg The log message\n     * @return void\n     */\n    </mt:Ignore>\n    log : function (level,msg) {\n      if(_debug && window.console) {\n        switch(level) {\n          case ''warn'':\n          case ''debug'':\n          case ''info'':\n          case ''error'':\n          case ''log'':\n            console[level](msg);\n            break;\n            \n          default:\n            return false; \n        }\n      } else {\n        return false;\n      }\n    }\n  }\n}();\n\n<mt:Ignore>\n/**\n * Utilities class\n * \n * @package MT\n * @class util\n * @global\n * Options:\n */\n</mt:Ignore>\nMT.util = function () {\n  return {\n    toggleVisibility : {\n      show : function () {\n        var i = arguments.length;\n        \n        while(i--) {\n          if(MT.util.checkNodeType(arguments[i])===''element'') {\n            arguments[i].style.visibility = ''visible'';\n          } else {\n            MT.core.getEl(arguments[i]).style.visibility = ''visible'';\n          }\n        }\n      },\n      \n      hide : function () {\n        var i = arguments.length;\n        while(i--) {\n          if(MT.util.checkNodeType(arguments[i])===''element'') {\n            arguments[i].style.visibility = ''hidden'';\n          } else {\n            MT.core.getEl(arguments[i]).style.visibility = ''hidden'';\n          }\n        }\n      }\n    },\n    \n    toggleDisplay : {\n      show : function () {\n        var i = arguments.length;\n        while(i--) {\n          if(MT.util.checkNodeType(arguments[i])===''element'') {\n            arguments[i].style.display = '''';\n          } else {\n            MT.core.getEl(arguments[i]).style.display = '''';\n          }\n        }\n      },\n      \n      hide : function () {\n        var i = arguments.length;\n        while(i--) {\n          if(MT.util.checkNodeType(arguments[i])===''element'') {\n            arguments[i].style.display = ''none'';\n          } else {\n            MT.core.getEl(arguments[i]).style.display = ''none'';\n          }\n        }\n      }\n    },\n    \n    <mt:Ignore>\n    /**\n     * Finds the nearest defining (i.e. with an id) parent to the given element\n     * \n     * @param {HTMLElement} origin the node from which to start the search\n     * @return {HTMLElement|Boolean} The parent node with an id attribute or false\n     */\n    </mt:Ignore>\n    findDefiningParent : function (origin) {\n      if(MT.util.checkNodeType(origin)===''element'') {\n        for(var node=origin.parentNode;node.parentNode;node=node.parentNode) {\n          if((node.hasAttribute && node.hasAttribute(''id'')) || node.getAttribute(''id'')) {\n            return node;\n          }\n        }\n      }\n      return false;\n    },\n    \n    <mt:Ignore>\n    /**\n     * Tests objects to verify if they are DOM nodes\n     * \n     * @param {Object} obj The object to be tested\n     * @return {String} the values ''element''|''textnode''|''whitespace''\n     */\n    </mt:Ignore>\n    checkNodeType : function (obj) {\n      if (obj && obj.nodeName){\n        switch (obj.nodeType) {\n          case 1: return ''element'';\n          case 3: return (/\\S/).test(obj.nodeValue) ? ''textnode'' : ''whitespace'';\n        }\n      }\n    }\n  }\n}();\n\n<mt:Ignore>\n/**\n * mtPaginateComments takes the currently generated static page and either:\n *  - Attempts to find an individual comment link in the query string\n *  - If no link is found, the static page loads\n * In either case, the pagination event is set\n */\n</mt:Ignore>\n(function () {\n  var M = MT.core,\n      c = MT.cons,\n      u = MT.util,\n      cache,\n      isLoading,\n      direction,\n      currentComments,\n      commentAnchor,\n      commentArrId,\n      commentsPerPage,\n      commentsTotalPages,\n      loadingIcon,\n      pageNum,\n      commentsOffset,\n      totalComments,\n      entryID,\n      commentContentDiv,\n      topNav,\n      nav,\n      currentCommentsSpan,\n      topCurrentCommentsSpan;\n            \n  M.addEvent(window,''load'',_init);\n  \n  /**\n   * Initializes the class\n   * \n   * @return void\n   */\n  function _init () {\n    if(!MT.entryCommentCount) {\n      return;\n    }\n    \n    _initializeVariables();\n    _setCommentOffset(false);\n    _checkForAnchor();\n		_setCurrentComments();\n    _toggleNavLinks();\n    _initializeEvents();\n  }\n  \n  <mt:Ignore>\n  /**\n   * Initializes variables to their initial values\n   * \n   * @return void\n   */\n  </mt:Ignore>\n  function _initializeVariables() {\n    cache = {};\n    isLoading = false;\n    commentAnchor = '''';\n    commentArrId = '''';\n    commentsPerPage = MT.commentsPerPage || 50;\n    currentComments = '''';\n    direction = ''ascend'';\n    entryID = MT.entryID;\n    totalComments = MT.entryCommentCount;\n    commentsTotalPages = Math.ceil(totalComments / commentsPerPage);\n    pageNum = 1;\n    \n    loadingIcon = "<img title=''Loading...'' src=''<$MTStaticWebPath$>images/indicator.white.gif'' alt=''Loading'' />";\n    \n    commentContentDiv = M.getEl("comments-content");\n    topNav = M.getEl("top-comment-nav");\n    nav = M.getEl("comment-nav");\n    \n    currentCommentsSpan = M.getEl("current-comments");\n    topCurrentCommentsSpan = M.getEl("top-current-comments");\n  }\n  \n  function _initializeEvents() {\n    if (commentsPerPage < totalComments) {\n      M.addEvent(nav,''click'',_handleEvents);\n      M.addEvent(topNav,''click'',_handleEvents);\n    }\n  }\n  \n  <mt:Ignore>\n  /**\n   * Checks for an existing anchor tag in the query string\n   * If found, it looks for it on the current page\n   * If that fails, it tries to find it in comment list and loads\n   * the desired page\n   * \n   * @return void\n   */\n  </mt:Ignore>\n  function _checkForAnchor() {\n    var found = String(window.location.hash).match( /comment-(\\d{1,6})/ );\n		\n		if (found) {\n		  M.log(c.DEBUG,found);\n			if (!Object.prototype.hasOwnProperty.call(M.getEl(found[0]), ''className'')) {\n				if (_findIdMatch(found[1])) {\n    			pageNum = Math.floor(commentArrId / commentsPerPage) + 1;\n    			M.log(c.DEBUG,''Comment Array Id: '' + commentArrId);\n    			M.log(c.DEBUG,''Comments Per Page: '' + commentsPerPage);\n    			M.log(c.DEBUG,''Page Number: '' + pageNum);\n    			M.log(c.DEBUG,''Comment Offset: '' + _getCommentOffset());\n    			_updateComments();\n    		}\n			}\n		}\n  }\n  \n  <mt:Ignore>\n  /**\n   * Sets commentsOffset (i.e. the offset number to the remote list)\n   * \n   * @return void\n   */\n  </mt:Ignore>\n  function _setCommentOffset() {\n    commentsOffset = commentsPerPage * (pageNum-1);\n  }\n  \n  <mt:Ignore>\n  /**\n   * Gets the commentsOffset (i.e. the offset number to the remote list)\n   * \n   * @return void\n   */\n  </mt:Ignore>\n  function _getCommentOffset() {\n    return commentsOffset;\n  }\n  \n  <mt:Ignore>\n  /**\n   * General event handler\n   * \n   * @param {Event} e The event object\n   * @return void\n   */\n  </mt:Ignore>\n  function _handleEvents (e) {\n    var origin = e.target || e.srcElement,\n        parentId;\n        \n    // stupid IE\n    origin = origin.id && M.getEl(origin.id) || false;\n\n    if(origin) {\n      parentId = u.checkNodeType(origin.parentNode)===''element'' && origin.parentNode.getAttribute(''id'') && origin.parentNode.id;\n    } else {\n      return false;\n    }\n    \n    switch(origin.nodeName) {\n      case ''A'':\n        switch (parentId) {\n          case ''prev-comments'':\n          case ''top-prev-comments'':\n            if(e.preventDefault) {\n              e.preventDefault();\n            } else {\n              e.returnValue =	false;\n            }\n            if(!isLoading) {\n              _previousPage();\n            }\n            break;\n          case ''next-comments'':\n          case ''top-next-comments'':\n            if(e.preventDefault) {\n              e.preventDefault();\n            } else {\n              e.returnValue =	false;\n            }\n            if(!isLoading) {\n              _nextPage();\n            }\n            break;\n        }\n        break;\n    }\n  }\n  \n  <mt:Ignore>\n  /**\n   * Toggles the visibility of the navigation links\n   * \n   * @return void\n   */\n  </mt:Ignore>\n  function _toggleNavLinks () {\n    M.log(c.DEBUG,M.getEl(''top-prev-comments''));\n    if(pageNum <= commentsTotalPages && pageNum !== 1) {\n      u.toggleVisibility.show(''prev-comments'');\n      u.toggleVisibility.show(''top-prev-comments'');\n    }\n    \n    if(pageNum >= 1 && pageNum !== commentsTotalPages) {\n      u.toggleVisibility.show(''next-comments'');\n      u.toggleVisibility.show(''top-next-comments'');\n    }\n    \n    if(pageNum===1 || nav.style.visibility===''hidden'') {\n      u.toggleVisibility.hide(''prev-comments'');\n      u.toggleVisibility.hide(''top-prev-comments'');\n    }\n    \n    if(pageNum===commentsTotalPages || nav.style.visibility===''hidden'') {\n      u.toggleVisibility.hide(''next-comments'');\n      u.toggleVisibility.hide(''top-next-comments'');\n    }\n  }\n  \n  <mt:Ignore>\n  /**\n   * Determines appropriate action based on the id of the parent\n   * clicked link. Decrements pageNum based on id.\n   * \n   * @param {String} id the id of the parent of the clicked link\n   * @return void\n   */\n  </mt:Ignore>\n  function _nextPage () {\n    if(pageNum < commentsTotalPages) {\n      pageNum++;\n      _updateComments();\n    }\n  }\n  \n  <mt:Ignore>\n  /**\n   * Determines appropriate action based on the id of the parent\n   * clicked link. Increments/decrements pageNum based on id.\n   * \n   * @param {String} id the id of the parent of the clicked link\n   * @return void\n   */\n  </mt:Ignore>\n  function _previousPage() {\n    if(pageNum > 1) {\n      pageNum--;\n      _updateComments();\n    }\n  }\n  \n  <mt:Ignore>\n  /**\n   * Searches for a particular comment in the list of ids\n   * \n   * @param {String} id The id for which to search\n   * @return {Boolean} true, if found, false otherwise\n   */\n  </mt:Ignore>\n  function _findIdMatch (id) {\n    var len = MT.commentIds.length;\n    \n  	while (len--) {\n  		if (MT.commentIds[len] == id) {\n  			commentAnchor = "comment-" + id;\n  			commentArrId = len;\n  			return true;\n  		}\n  	}\n  	\n  	return false;\n  }\n  \n  <mt:Ignore>\n  /**\n   * Sets the current comment counts on the page\n   *\n   * @return void\n   */\n  </mt:Ignore>\n  function _setCurrentComments() {\n    var commentsOnPage = pageNum != commentsTotalPages ? commentsOffset + commentsPerPage : totalComments;\n    \n    _setCurrentCommentsContent([commentsOffset+1," - ",commentsOnPage].join(''''));\n  }\n  \n  <mt:Ignore>\n  /**\n   * Sets the "current-comments" element with the HTML value\n   * \n   * @param {String|Element} currentCommentsHTML The content to be set\n   * @return void\n   */\n  </mt:Ignore>\n  function _setCurrentCommentsContent(currentCommentsHTML) {\n    currentCommentsSpan.innerHTML = currentCommentsHTML;\n    topCurrentCommentsSpan.innerHTML = currentCommentsHTML;\n  }\n  \n  <mt:Ignore>\n  /**\n   * Sets the content of the comment list\n   * \n   * @param {String|Element} commentHTML The content to be set \n   * @return void\n   */\n  </mt:Ignore>\n  function _setCommentContent(commentHTML) {\n    commentContentDiv.innerHTML = commentHTML;\n  }\n  \n  <mt:Ignore>\n  /**\n   * Builds the appropriate URL to make a remote call to get the\n   * next set of comments\n   * \n   * @return void\n   */\n  </mt:Ignore>\n  function _updateComments() {\n    var comments, jsonUrl, cacheKey, offset;\n    isLoading = true;\n    _setCurrentCommentsContent(loadingIcon);\n    _setCommentOffset();\n\n    offset   = _getCommentOffset();\n    cacheKey = [direction, entryID, commentsPerPage, offset]\n        .join(''-'')\n        .replace(/[^a-zA-Z0-9-]/g, '''');\n    jsonUrl  = [\n        "<$mt:CGIPath$><$mt:CommentScript$>?__mode=comment_listing&direction=",\n        direction,\n        "&entry_id=",\n        entryID,\n        "&limit=",\n        commentsPerPage,\n        "&offset=",\n        offset,\n        "&cacheKey=",\n        cacheKey,\n        "&jsonp=mtUpdateCommentsCallback",\n        "&ts=",\n        new Date().getTime()\n      ].join('''');\n  	\n  	if (!commentAnchor) {\n      commentAnchor = "comments-content";\n    }\n\n    if(cache.hasOwnProperty(cacheKey)) {\n      _refreshComments(cache[cacheKey]);\n      isLoading = false;\n    } else {\n      var script = document.createElement(''script'');\n      script.src = jsonUrl;\n      (document.getElementsByTagName(''head''))[0].appendChild(script);\n    }\n  }\n\n  window[''mtUpdateCommentsCallback''] = function(json) {\n    cache[json.cacheKey] = json.comments;\n    _refreshComments(json.comments);\n    isLoading = false;\n  }\n  \n  <mt:Ignore>\n  /**\n   * Refreshes the comment data with the current\n   * \n   * @param {String} commentData The data used to replace current comments\n   * @return void\n   */\n  </mt:Ignore>\n  function _refreshComments(commentData) {\n    _setCommentContent(commentData);\n    _setCurrentComments();\n    window.location.hash = ''reset'';\n    window.location.hash = commentAnchor;\n    _toggleNavLinks();\n  }\n})();\n\n<mt:Ignore>\n/***\n * Displays a relative date.\n * ''ts'' is a Date object, ''fds'' is a string of the date which\n * will be displayed if the given date is older than 1 week.\n */\n</mt:Ignore>\nfunction mtRelativeDate(ts, fds) {\n    var now = new Date();\n    var ref = ts;\n    var delta = Math.floor((now.getTime() - ref.getTime()) / 1000);\n\n    var str;\n    if (delta < 60) {\n        str = ''moments ago'';\n    } else if (delta <= 86400) {\n        // less than 1 day\n        var hours = Math.floor(delta / 3600);\n        var min = Math.floor((delta % 3600) / 60);\n        if (hours == 1)\n            str = ''1 hour ago'';\n        else if (hours > 1)\n            str = ''2 hours ago''.replace(/2/, hours);\n        else if (min == 1)\n            str = ''1 minute ago'';\n        else\n            str = ''2 minutes ago''.replace(/2/, min);\n    } else if (delta <= 604800) {\n        // less than 1 week\n        var days = Math.floor(delta / 86400);\n        var hours = Math.floor((delta % 86400) / 3600);\n        if (days == 1)\n            str = ''1 day ago'';\n        else if (days > 1)\n            str = ''2 days ago''.replace(/2/, days);\n        else if (hours == 1)\n            str = ''1 hour ago'';\n        else\n            str = ''2 hours ago''.replace(/2/, hours);\n    }\n    return str ? str : fds;\n}\n\n<mt:Ignore>\n/***\n * Used to display an edit link for the given entry.\n */\n</mt:Ignore>\nfunction mtEditLink(entry_id, author_id) {\n    <mt:Ignore>\n    // This function has been inactivated by default because of the security issue.\n    // You can activate this function if "AdminScript" is already known by visitor.\n    </mt:Ignore>\n    <mt:Ignore>\n\n    var u = mtGetUser();\n    if (! u) return;\n    if (! entry_id) return;\n    if (! author_id) return;\n    if (u.id != author_id) return;\n    var link = ''<a href="<$mt:AdminScript$>?__mode=view&amp;_type=entry&amp;id='' + entry_id + ''">Edit</a>'';\n    document.write(link);\n\n    </mt:Ignore>\n}\n\n<mt:Ignore>\n/***\n * Called when an input field on the comment form receives focus.\n */\n</mt:Ignore>\nfunction mtCommentFormOnFocus() {\n    // if CAPTCHA is enabled, this causes the captcha image to be\n    // displayed if it hasn''t been already.\n    mtShowCaptcha();\n}\n\n<mt:Ignore>\n/***\n * Displays a captcha field for anonymous commenters.\n */\n</mt:Ignore>\nvar mtCaptchaVisible = false;\nfunction mtShowCaptcha() {\n    var u = mtGetUser();\n    if ( u && u.is_authenticated ) return;\n    if (mtCaptchaVisible) return;\n    var div = document.getElementById(''comments-open-captcha'');\n    if (div) {\n        div.innerHTML = ''<$mt:CaptchaFields$>'';\n        mtCaptchaVisible = true;\n    }\n}\n\n<mt:Ignore>\n/* user object\n    -- saved in user cookie --\n    u.name (display name)\n    u.url (link to home page)\n    u.email (for anonymous only)\n    u.userpic (url for commenter/author)\n    u.profile (link to profile)\n    u.is_trusted (boolean)\n    u.is_author (user has posting rights)\n    u.is_banned (banned status; neither post/comment perms)\n    u.can_post (has permission to post)\n    u.can_comment (has permission to comment)\n\n    -- status fields --\n    u.is_authenticated (boolean)\n    u.is_anonymous (user is anonymous)\n*/\n</mt:Ignore>\n\nvar is_preview;\nvar user;\n<mt:Ignore>\n/***\n * Assigns a user object as the actively logged in user; also saves the\n * user information in a browser cookie.\n */\n</mt:Ignore>\nfunction mtSetUser(u) {\n    if (u) {\n        // persist this\n        user = u;\n        mtSaveUser();\n        // sync up user greeting\n        mtFireEvent(''usersignin'');\n    }\n}\n\n<mt:Ignore>\n/***\n * Simple function that escapes single quote characters for storing\n * in a cookie.\n */\n</mt:Ignore>\nfunction mtEscapeJS(s) {\n    s = s.replace(/''/g, "&apos;");\n    return s;\n}\n\n<mt:Ignore>\n/***\n * Simple function that unescapes single quote characters that were\n * stored in a cookie.\n */\n</mt:Ignore>\nfunction mtUnescapeJS(s) {\n    s = s.replace(/&apos;/g, "''");\n    return s;\n}\n\n<mt:Ignore>\n/***\n * Serializes a user object into a string, suitable for storing as a cookie.\n */\n</mt:Ignore>\nfunction mtBakeUserCookie(u) {\n    var str = "";\n    if (u.name) str += "name:''" + mtEscapeJS(u.name) + "'';";\n    if (u.url) str += "url:''" + mtEscapeJS(u.url) + "'';";\n    if (u.email) str += "email:''" + mtEscapeJS(u.email) + "'';";\n    if (u.is_authenticated) str += "is_authenticated:''1'';";\n    if (u.profile) str += "profile:''" + mtEscapeJS(u.profile) + "'';";\n    if (u.userpic) str += "userpic:''" + mtEscapeJS(u.userpic) + "'';";\n    if (u.sid) str += "sid:''" + mtEscapeJS(u.sid) + "'';";\n    str += "is_trusted:''" + (u.is_trusted ? "1" : "0") + "'';";\n    str += "is_author:''" + (u.is_author ? "1" : "0") + "'';";\n    str += "is_banned:''" + (u.is_banned ? "1" : "0") + "'';";\n    str += "can_post:''" + (u.can_post ? "1" : "0") + "'';";\n    str += "can_comment:''" + (u.can_comment ? "1" : "0") + "'';";\n    str = str.replace(/;$/, '''');\n    return str;\n}\n\n<mt:Ignore>\n/***\n * Unserializes a user cookie and returns a user object with the restored\n * state.\n */\n</mt:Ignore>\nfunction mtUnbakeUserCookie(s) {\n    if (!s) return;\n\n    var u = {};\n    var m;\n    while (m = s.match(/^((name|url|email|is_authenticated|profile|userpic|sid|is_trusted|is_author|is_banned|can_post|can_comment):''([^'']+?)'';?)/)) {\n        s = s.substring(m[1].length);\n        if (m[2].match(/^(is|can)_/)) // boolean fields\n            u[m[2]] = m[3] == ''1'' ? true : false;\n        else\n            u[m[2]] = mtUnescapeJS(m[3]);\n    }\n    if (u.is_authenticated) {\n        u.is_anonymous = false;\n    } else {\n        u.is_anonymous = true;\n        u.can_post = false;\n        u.is_author = false;\n        u.is_banned = false;\n        u.is_trusted = false;\n    }\n    return u;\n}\n\n<mt:Ignore>\n/***\n * Retrieves an object of the currently logged in user''s state.\n * If no user is logged in or cookied, this will return null.\n */\n</mt:Ignore>\nfunction mtGetUser() {\n    if (!user) {\n        var cookie = mtGetCookie(mtCookieName);\n        if (!cookie) return;\n        user = mtUnbakeUserCookie(cookie);\n        if (! user) {\n            user = {};\n            user.is_anonymous = true;\n            user.can_post = false;\n            user.is_author = false;\n            user.is_banned = false;\n            user.is_trusted = false;\n        }\n    }\n    return user;\n}\n\n<mt:Ignore>\n/***\n * Issues a request to the MT comment script to retrieve the currently\n * logged-in user (if any).\n */\n</mt:Ignore>\nvar mtFetchedUser = false;\n<mt:IfWebsite>\nfunction mtFetchUser(cb) {\n    if (!cb) cb = ''mtSetUser'';\n    if ( ( cb == ''mtSetUser'' ) && mtGetUser() ) {\n        var url = document.URL;\n        url = url.replace(/#.+$/, '''');\n        url += ''#comments-open'';\n        location.href = url;\n    } else {\n        // we aren''t using AJAX for this, since we may have to request\n        // from a different domain. JSONP to the rescue.\n        mtFetchedUser = true;\n        var u = mtGetUser();\n        var script = document.createElement(''script'');\n        var ts = new Date().getTime();\n        script.src = ''<$mt:CGIPath$><$mt:CommentScript$>?__mode=userinfo&blog_id=<$mt:BlogID$>&jsonp='' + cb + ''&ts='' + ts + ''&sid='' + u.sid;\n        (document.getElementsByTagName(''head''))[0].appendChild(script);\n    }\n}\n\nfunction mtVerifySession(cb) {\n    if (!cb) return;\n    var script = document.createElement(''script'');\n    var ts = new Date().getTime();\n    var u = mtGetUser();\n    script.src = ''<$mt:CGIPath$><$mt:CommentScript$>?__mode=verify_session&blog_id=<$mt:BlogID$>&jsonp='' + cb + ''&ts='' + ts + ''&sid='' + u.sid;\n    (document.getElementsByTagName(''head''))[0].appendChild(script);\n}\n</mt:IfWebsite>\n\n<mt:Ignore>\n/***\n * Called when the ''Remember me'' checkbox is changed. If the checkbox\n * is cleared, the cached user cookie is immediately cleared.\n */\n</mt:Ignore>\nfunction mtRememberMeOnClick(b) {\n    if (!b.checked)\n        mtClearUser(b.form);\n    return true;\n}\n\n<mt:Ignore>\n/***\n * Called when comment form is sent.\n * Required parameter: Form DOM object of comment form.\n * If form has a ''bakecookie'' member, it will be used to signal\n * storing the anonymous commenter information to a cookie.\n * If form has a ''armor'' member, it will be used to store\n * a token that is checked by the comment script.\n */\n</mt:Ignore>\n<mt:IfWebsite>\nvar mtRequestSubmitted = false;\nfunction mtCommentOnSubmit(f) {\n    if (!mtRequestSubmitted) {\n        mtRequestSubmitted = true;\n\n        if (f.armor)\n            f.armor.value = ''<$mt:BlogSitePath encode_sha1="1"$>'';\n        if (f.bakecookie && f.bakecookie.checked)\n            mtSaveUser(f);\n\n        // disable submit buttons\n        if (f.preview_button) f.preview_button.disabled = true;\n        if (f.post) f.post.disabled = true;\n\n        var u = mtGetUser();\n        if ( !is_preview && ( u && u.is_authenticated ) ) {\n            // validate session; then submit\n            mtVerifySession(''mtCommentSessionVerify'');\n            return false;\n        }\n\n        return true;\n    }\n    return false;\n}\n\nfunction mtCommentSessionVerify(app_user) {\n    var f = document[''comments_form''];\n    if ( app_user && app_user.verified ) {\n        f.submit();\n    } else {\n        alert(''Your session has expired. Please sign in again to comment.'');\n        mtClearUser();\n        mtFireEvent(''usersignin'');\n<mt:IfRegistrationRequired>\n        mtShow(''comments-form'');\n        mtHide(''comments-open-footer'');\n</mt:IfRegistrationRequired>\n    }\n}\n\nfunction mtUserOnLoad() {\n    var u = mtGetUser();\n\n    // if the user is authenticated, hide the ''anonymous'' fields\n    // and any captcha input if already shown\n    if ( document.getElementById(''comments-form'')) {\n        if ( u && u.is_authenticated ) {\n            mtShow(''comments-form'');\n            mtHide(''comments-open-data'');\n            if (mtCaptchaVisible)\n                mtHide(''comments-open-captcha'');\n        } else {\n<mt:IfRegistrationRequired>\n            mtHide(''comments-form'');\n</mt:IfRegistrationRequired>\n        }\n        if ( u && u.is_banned )\n            mtHide(''comments-form'');\n\n        // if we''re previewing a comment, make sure the captcha\n        // field is visible\n        if (is_preview)\n            mtShowCaptcha();\n        else\n            mtShowGreeting();\n\n        // populate anonymous comment fields if user is cookied as anonymous\n        var cf = document[''comments_form''];\n        if (cf) {\n            if (u && u.is_anonymous) {\n                if (u.email) cf.email.value = u.email;\n                if (u.name) cf.author.value = u.name;\n                if (u.url) cf.url.value = u.url;\n                if (cf.bakecookie)\n                    cf.bakecookie.checked = u.name || u.email;\n            } else {\n                if (u && u.sid && cf.sid)\n                    cf.sid.value = u.sid;\n            }\n            if (cf.post && cf.post.disabled)\n                cf.post.disabled = false;\n            if (cf.preview_button && cf.preview_button.disabled)\n                cf.preview_button.disabled = false;\n            mtRequestSubmitted = false;\n        }\n    }\n}\n</mt:IfWebsite>\n\n<mt:Ignore>\n/***\n * Called when an entry archive page is loaded.\n * This routine controls which elements of the comment form are shown\n * or hidden, depending on commenter type and blog configuration.\n */\n</mt:Ignore>\n<mt:IfWebsite>\nfunction mtEntryOnLoad() {\n    var cf = document[''comments_form''];\n    if (cf && cf.preview) cf.preview.value = '''';\n    <mt:Unless tag="IfPingsAccepted">mtHide(''trackbacks-info'');</mt:Unless>\n    <mt:Unless tag="IfCommentsAccepted">mtHide(''comments-open'');</mt:Unless>\n    mtFireEvent(''usersignin'');\n}\n\nfunction mtEntryOnUnload() {\n    if (mtRequestSubmitted) {\n        var cf = document[''comments_form''];\n        if (cf) {\n            if (cf.post && cf.post.disabled)\n                cf.post.disabled = false;\n            if (cf.preview_button && cf.preview_button.disabled)\n                cf.preview_button.disabled = false;\n        }\n        mtRequestSubmitted = false;\n    }\n    return true;\n}\n\nmtAttachEvent(''usersignin'', mtUserOnLoad);\n</mt:IfWebsite>\n\n<mt:Ignore>\n/***\n * Handles the action of the "Sign in" link. First clears any existing\n * user cookie, then directs to the MT comment script to sign the user in.\n */\n</mt:Ignore>\nfunction mtSignIn() {\n    var doc_url = document.URL;\n    doc_url = doc_url.replace(/#.+/, '''');\n    var url = ''<$mt:SignInLink$>'';\n    if (is_preview) {\n        if ( document[''comments_form''] ) {\n            var entry_id = document[''comments_form''].entry_id.value;\n            url += ''&entry_id='' + entry_id;\n        } else {\n            url += ''&return_url=<$mt:BlogURL encode_url="1"$>'';\n        }\n    } else {\n        url += ''&return_url='' + encodeURIComponent(doc_url);\n    }\n    mtClearUser();\n    location.href = url;\n}\n\nfunction mtSignInOnClick(sign_in_element) {\n    var el;\n    if (sign_in_element) {\n        // display throbber\n        el = document.getElementById(sign_in_element);\n        if (!el)  // legacy MT 4.x element id\n            el = document.getElementById(''comment-form-external-auth'');\n    }\n    if (el)\n        el.innerHTML = ''Signing in... <span class="status-indicator">&nbsp;</span>'';\n\n    mtClearUser(); // clear any ''anonymous'' user cookie to allow sign in\n    mtSignIn();\n    return false;\n}\n\nfunction mtSetUserOrLogin(u) {\n    if (u && u.is_authenticated) {\n        mtSetUser(u);\n    } else {\n        // user really isn''t logged in; so let''s do this!\n        mtSignIn();\n    }\n}\n\n<mt:Ignore>\n/***\n * Handles sign out from the web site.\n * First clears any existing user cookie, then direts to the MT comment\n * script to sign the user out.\n */\n</mt:Ignore>\nfunction mtSignOut(entry_id) {\n    mtClearUser();\n    var doc_url = document.URL;\n    doc_url = doc_url.replace(/#.+/, '''');\n    var url = ''<$mt:SignOutLink$>'';\n    if (is_preview) {\n        if ( document[''comments_form''] ) {\n            var entry_id = document[''comments_form''].entry_id.value;\n            url += ''&entry_id='' + entry_id;\n        } else {\n            url += ''&return_url=<$mt:BlogURL encode_url="1"$>'';\n        }\n    } else {\n        url += ''&return_url='' + encodeURIComponent(doc_url);\n    }\n    location.href = url;\n}\n\n<mt:Ignore>\n/***\n * Handles the action of the "Sign out" link.\n */\n</mt:Ignore>\nfunction mtSignOutOnClick() {\n    mtSignOut();\n    return false;\n}\n\n<mt:Ignore>\n/***\n * Handles the display of the greeting message, depending on what kind of\n * user is logged in and blog comment policy.\n */\n</mt:Ignore>\n<mt:IfWebsite>\nfunction mtShowGreeting() {\n<mt:IfRegistrationAllowed>\n    var reg_reqd = <mt:IfRegistrationRequired>true<mt:Else>false</mt:IfRegistrationRequired>;\n\n    var cf = document[''comments_form''];\n    if (!cf) return;\n\n    var el = document.getElementById(''comment-greeting'');\n    if (!el)  // legacy MT 4.x element id\n        el = document.getElementById(''comment-form-external-auth'');\n    if (!el) return;\n\n    var eid = cf.entry_id;\n    var entry_id;\n    if (eid) entry_id = eid.value;\n\n    var phrase;\n    var u = mtGetUser();\n\n    if ( u && u.is_authenticated ) {\n        if ( u.is_banned ) {\n            phrase = ''You do not have permission to comment on this blog. (\\<a href=\\"javas\\cript:void(0);\\" onclick=\\"return mtSignOutOnClick();\\"\\>sign out\\<\\/a\\>)'';\n        } else {\n            var user_link;\n            if ( u.is_author ) {\n                user_link = ''<a href="<$mt:CGIPath$><$mt:CommentScript$>?__mode=edit_profile&blog_id=<mt:BlogID>&return_url='' + encodeURIComponent( location.href );\n                user_link += ''">'' + u.name + ''</a>'';\n            } else {\n                // registered user, but not a user with posting rights\n                if (u.url)\n                    user_link = ''<a href="'' + u.url + ''">'' + u.name + ''</a>'';\n                else\n                    user_link = u.name;\n            }\n            // TBD: supplement phrase with userpic if one is available.\n            phrase = ''Thanks for signing in, __NAME__. (\\<a href=\\"javas\\cript:void(0)\\" onclick=\\"return mtSignOutOnClick();\\"\\>sign out\\<\\/a\\>)'';\n            phrase = phrase.replace(/__NAME__/, user_link);\n        }\n    } else {\n        if (reg_reqd) {\n            phrase = ''\\<a href=\\"javas\\cript:void(0)\\" onclick=\\"return mtSignInOnClick(\\''comment-greeting\\'')\\"\\>Sign in\\<\\/a\\> to comment.'';\n        } else {\n            phrase = ''\\<a href=\\"javas\\cript:void(0)\\" onclick=\\"return mtSignInOnClick(\\''comment-greeting\\'')\\"\\>Sign in\\<\\/a\\> to comment, or comment anonymously.'';\n        }\n    }\n    el.innerHTML = phrase;\n<mt:Else>\n    mtShowCaptcha();\n</mt:IfRegistrationAllowed>\n}\n</mt:IfWebsite>\n\n<mt:Ignore>\n/***\n * Handles the action of the ''Reply'' links.\n */\n</mt:Ignore>\nfunction mtReplyCommentOnClick(parent_id, author) {\n    mtShow(''comment-form-reply'');\n\n    var checkbox = document.getElementById(''comment-reply'');\n    var label = document.getElementById(''comment-reply-label'');\n    var text = document.getElementById(''comment-text'');\n\n    // Populate label with new values\n    var reply_text = ''Replying to \\<a href=\\"#comment-__PARENT__\\" onclick=\\"location.href=this.href; return false\\"\\>comment from __AUTHOR__\\<\\/a\\>'';\n    reply_text = reply_text.replace(/__PARENT__/, parent_id);\n    reply_text = reply_text.replace(/__AUTHOR__/, author);\n    label.innerHTML = reply_text;\n\n    checkbox.value = parent_id; \n    checkbox.checked = true;\n    try {\n        // text field may be hidden\n        text.focus();\n    } catch(e) {\n    }\n\n    mtSetCommentParentID();\n}\n\n<mt:Ignore>\n/***\n * Sets the parent comment ID when replying to a comment.\n */\n</mt:Ignore>\nfunction mtSetCommentParentID() {\n    var checkbox = document.getElementById(''comment-reply'');\n    var parent_id_field = document.getElementById(''comment-parent-id'');\n    if (!checkbox || !parent_id_field) return;\n\n    var pid = 0;\n    if (checkbox.checked == true)\n        pid = checkbox.value;\n    parent_id_field.value = pid;\n}\n\n<mt:Ignore>\n/***\n * Persists a copy of the current user cookie into the browser cookie stash.\n */\n</mt:Ignore>\nfunction mtSaveUser(f) {\n    // We can''t reliably store the user cookie during a preview.\n    if (is_preview) return;\n\n    var u = mtGetUser();\n\n    if (f && (!u || u.is_anonymous)) {\n        if ( !u ) {\n            u = {};\n            u.is_authenticated = false;\n            u.can_comment = true;\n            u.is_author = false;\n            u.is_banned = false;\n            u.is_anonymous = true;\n            u.is_trusted = false;\n        }\n        if (f.author != undefined) u.name = f.author.value;\n        if (f.email != undefined) u.email = f.email.value;\n        if (f.url != undefined) u.url = f.url.value;\n    }\n\n    if (!u) return;\n\n    var cache_period = mtCookieTimeout * 1000;\n\n    // cache anonymous user info for a long period if the\n    // user has requested to be remembered\n    if (u.is_anonymous && f && f.bakecookie && f.bakecookie.checked)\n        cache_period = 365 * 24 * 60 * 60 * 1000;\n\n    var now = new Date();\n    mtFixDate(now);\n    now.setTime(now.getTime() + cache_period);\n\n    var cmtcookie = mtBakeUserCookie(u);\n    mtSetCookie(mtCookieName, cmtcookie, now, mtCookiePath, mtCookieDomain,\n        location.protocol == ''https:'');\n}\n\n<mt:Ignore>\n/***\n * Clears the blog-side user cookie.\n */\n</mt:Ignore>\nfunction mtClearUser() {\n    user = null;\n    mtDeleteCookie(mtCookieName, mtCookiePath, mtCookieDomain,\n        location.protocol == ''https:'');\n}\n\n<mt:Ignore>\n/***\n * Sets a browser cookie.\n */\n</mt:Ignore>\nfunction mtSetCookie(name, value, expires, path, domain, secure) {\n    if (domain && ( domain.match(/^\\.?localhost$/) || domain.match(/^[0-9\\.]+$/) ))\n        domain = null;\n    var curCookie = name + "=" + encodeURIComponent(value) +\n        (expires ? "; expires=" + expires.toGMTString() : "") +\n        (path ? "; path=" + path : "") +\n        (domain ? "; domain=" + domain : "") +\n        (secure ? "; secure" : "");\n    document.cookie = curCookie;\n}\n\n<mt:Ignore>\n/***\n * Retrieves a browser cookie.\n */\n</mt:Ignore>\nfunction mtGetCookie(name) {\n    var prefix = name + ''='';\n    var c = document.cookie;\n    var cookieStartIndex = c.indexOf(prefix);\n    if (cookieStartIndex == -1)\n        return '''';\n    var cookieEndIndex = c.indexOf(";", cookieStartIndex + prefix.length);\n    if (cookieEndIndex == -1)\n        cookieEndIndex = c.length;\n    var this_cookie = c.substring(cookieStartIndex + prefix.length, cookieEndIndex);\n    if ( this_cookie.match(/\\%u/i) ) {\n        return '''';\n    }\n    return decodeURIComponent( this_cookie );\n}\n\n<mt:Ignore>\n/***\n * Deletes a browser cookie.\n */\n</mt:Ignore>\nfunction mtDeleteCookie(name, path, domain, secure) {\n    if (mtGetCookie(name)) {\n        if (domain && domain.match(/^\\.?localhost$/))\n            domain = null;\n        document.cookie = name + "=" +\n            (path ? "; path=" + path : "") +\n            (domain ? "; domain=" + domain : "") +\n            (secure ? "; secure" : "") +\n            "; expires=Thu, 01-Jan-70 00:00:01 GMT";\n    }\n}\n\nfunction mtFixDate(date) {\n    var skew = (new Date(0)).getTime();\n    if (skew > 0)\n        date.setTime(date.getTime() - skew);\n}\n\n<mt:Ignore>\n/***\n * Returns a XMLHttpRequest object (for Ajax operations).\n */\n</mt:Ignore>\nfunction mtGetXmlHttp() {\n    if ( !window.XMLHttpRequest ) {\n        window.XMLHttpRequest = function() {\n            var types = [\n                "Microsoft.XMLHTTP",\n                "MSXML2.XMLHTTP.5.0",\n                "MSXML2.XMLHTTP.4.0",\n                "MSXML2.XMLHTTP.3.0",\n                "MSXML2.XMLHTTP"\n            ];\n\n            for ( var i = 0; i < types.length; i++ ) {\n                try {\n                    return new ActiveXObject( types[ i ] );\n                } catch( e ) {}\n            }\n\n            return undefined;\n        };\n    }\n    if ( window.XMLHttpRequest )\n        return new XMLHttpRequest();\n}\n\n// BEGIN: fast browser onload init\n// Modifications by David Davis, DWD\n// Dean Edwards/Matthias Miller/John Resig\n// http://dean.edwards.name/weblog/2006/06/again/?full#comment5338\n\nfunction mtInit() {\n    // quit if this function has already been called\n    if (arguments.callee.done) return;\n\n    // flag this function so we don''t do the same thing twice\n    arguments.callee.done = true;\n\n    // kill the timer\n    // DWD - check against window\n    if ( window._timer ) clearInterval(window._timer);\n\n    // DWD - fire the window onload now, and replace it\n    if ( window.onload && ( window.onload !== window.mtInit ) ) {\n        window.onload();\n        window.onload = function() {};\n    }\n<mt:IfWebsite>\n<mt:IfRegistrationAllowed>\n    mtInitCommenter();\n</mt:IfRegistrationAllowed>\n</mt:IfWebsite>\n}\n\n/* for Mozilla/Opera9 */\nif (document.addEventListener) {\n    document.addEventListener("DOMContentLoaded", mtInit, false);\n}\n\n/* for Internet Explorer */\n/*@cc_on @*/\n/*@if (@_win32)\nif (!document.addEventListener){\n  document.write("<script id=__ie_onload defer src=//:><\\/script>");\n  var script = document.getElementById("__ie_onload");\n  script.onreadystatechange = function() {\n      if (this.readyState == "complete") {\n          mtInit(); // call the onload handler\n      }\n  };\n}\n/*@end @*/\n\n/* for Safari */\nif (/WebKit/i.test(navigator.userAgent)) { // sniff\n    _timer = setInterval(function() {\n        if (/loaded|complete/.test(document.readyState)) {\n            mtInit(); // call the onload handler\n        }\n    }, 10);\n}\n\n/* for other browsers */\nwindow.onload = mtInit;\n\n// END: fast browser onload init\n\n<mt:IfWebsite>\n<mt:IfRegistrationAllowed>\n\nfunction mtLoggedIn(ott) {\n    var script = document.createElement(''script'');\n    var ts = new Date().getTime();\n    script.src = ''<$mt:CGIPath$><$mt:CommentScript$>?__mode=userinfo&jsonp=mtSaveUserInfo&ott='' + ott;\n    (document.getElementsByTagName(''head''))[0].appendChild(script);\n}\n\nfunction mtRefreshUserInfo(sid) {\n    var script = document.createElement(''script'');\n    var ts = new Date().getTime();\n    script.src = ''<$mt:CGIPath$><$mt:CommentScript$>?__mode=userinfo&jsonp=mtSaveUserInfo&sid='' + sid;\n    (document.getElementsByTagName(''head''))[0].appendChild(script);\n}\n\nfunction mtSaveUserInfo (u) {\n    if ( u.error ) {\n        if ( !user ) {\n            alert(''The sign-in attempt was not successful; Please try again.'');\n        }\n        return;\n    }\n    user = null;\n    var cmtcookie = mtBakeUserCookie(u);\n    var now = new Date();\n    var cache_period = mtCookieTimeout * 1000;\n\n    // cache anonymous user info for a long period if the\n    // user has requested to be remembered\n    mtFixDate(now);\n    now.setTime(now.getTime() + cache_period);\n    mtSetCookie(mtCookieName, cmtcookie, now, mtCookiePath, mtCookieDomain,\n        location.protocol == ''https:'');\n    mtFireEvent(''usersignin'');\n}\n\nfunction mtInitCommenter () {\n    /***\n     * If request contains a ''#_login'' or ''#_logout'' hash, use this to\n     * also delete the blog-side user cookie, since we''re coming back from\n     * a login, logout or edit profile operation.\n     */\n\n    var hash = ( window.location.hash );\n    hash.match( /^#_(.*)$/ );\n    var command = RegExp.$1 || '''';\n    if ( command === ''refresh'' ) {\n        // Back from profile edit screen.\n        // Reload userinfo with current session ID.\n        var u = mtGetUser();\n        user  = null;\n        mtRefreshUserInfo(u.sid);\n    }\n    else if ( command === ''logout'' ) {\n        // clear any logged in state\n        mtClearUser();\n        mtFireEvent(''usersignin'');\n    }\n    else if ( command.match( /^login_(.*)$/ ) ) {\n        var sid = RegExp.$1;\n        mtLoggedIn(sid);\n    }\n    else {\n        mtFireEvent(''usersignin'');\n    }\n}\n</mt:IfRegistrationAllowed>\n</mt:IfWebsite>\n', 'index', 0),
(29, 1, 0, 0, 1, 1, '[[regtime]]', 'comment_listing', NULL, NULL, NULL, NULL, '[[regtime]]', 'Comment Listing', NULL, 1, '{\n    "direction": "<mt:Var name="commentDirection">",\n    "comments": "<mt:Comments sort_order="$commentDirection"><$mt:Include module="Comment Detail" replace="\\","\\\\" replace=''"'',''\\"'' regex_replace="/\\t/g","\\\\t" strip_linefeeds="1"$></mt:Comments>",\n    "cacheKey": "<mt:Var name="cacheKey">"\n}\n', 'comment_listing', 0),
(30, 1, 0, 0, 1, 1, '[[regtime]]', 'main_index_widgets_group', NULL, NULL, NULL, NULL, '[[regtime]]', 'Home Page Widgets Group', NULL, 1, '<mt:Ignore>\n    This is a custom set of widgets that only appear on the homepage (or "main_index"). More info: http://www.movabletype.org/documentation/designer/widget-sets.html\n</mt:Ignore>\n<mt:If name="main_index">\n    <$mt:Include widget="Recent Comments"$>\n    <$mt:Include widget="Recent Entries"$>\n    <$mt:Include widget="Recent Assets"$>\n    <$mt:Include widget="Tag Cloud"$>\n</mt:If>\n', 'widget', 0);
INSERT INTO `mt_template` VALUES
(31, 1, 0, 0, 1, 1, '[[regtime]]', 'search', NULL, NULL, NULL, NULL, '[[regtime]]', 'Search', NULL, 1, '<div class="widget-search widget">\n    <h3 class="widget-header">Search</h3>\n    <div class="widget-content">\n        <form method="get" action="<$mt:CGIPath$><$mt:SearchScript$>">\n            <input type="text" id="search" class="ti" name="search" value="<$mt:SearchString$>" />\n<mt:If name="search_results">\n            <input type="hidden" name="IncludeBlogs" value="<$mt:SearchIncludeBlogs$>" />\n            <mt:Ignore>\n            <!-- use these options only with MT::App::Search::Legacy -->\n            <ul class="search-options">\n                <li><input type="checkbox" name="CaseSearch" /> Case sensitive</li>\n                <li><input type="checkbox" name="RegexSearch" /> Regex search</li>\n            </ul>\n            </mt:Ignore>\n<mt:Else>\n            <input type="hidden" name="IncludeBlogs" value="<$mt:WebsiteID$><mt:WebsiteHasBlog><mt:Blogs include_blogs="children">,<mt:BlogID></mt:Blogs></mt:WebsiteHasBlog>" />\n</mt:If>\n            <input type="hidden" name="limit" value="<$mt:SearchMaxResults$>" />\n            <input type="submit" accesskey="4" value="Search" />\n        </form>\n    </div>\n</div>\n<mt:If name="search_results">\n    <mt:IfTagSearch>\n<div class="widget-tags widget">\n    <h3 class="widget-header">Tags</h3>\n    <div class="widget-content">\n        <ul>\n        <mt:Tags>\n            <li><a href="javascript:void(0)" onclick="location.href=''<$mt:TagSearchLink encode_js="1"$>'';return false;"><$mt:TagName$> (<$mt:TagCount$>)</a></li>\n        </mt:Tags>\n        </ul>\n    </div>\n</div>\n    </mt:IfTagSearch>\n</mt:If>\n', 'widget', 0),
(32, 1, 0, 0, 1, 1, '[[regtime]]', 'html_head', NULL, NULL, NULL, NULL, '[[regtime]]', 'HTML Head', NULL, 1, '<meta http-equiv="Content-Type" content="text/html; charset=<$mt:PublishCharset$>" />\n<meta name="generator" content="<$mt:ProductName version="1"$>" />\n<link rel="stylesheet" href="<$mt:Link template="styles"$>" type="text/css" />\n<link rel="start" href="<$mt:BlogURL$>" title="Home" />\n<link rel="alternate" type="application/atom+xml" title="Recent Entries" href="<$mt:Link template="feed_recent"$>" />\n<script type="text/javascript" src="<$mt:Link template="javascript"$>"></script>\n<$mt:CCLicenseRDF$>\n<$mt:CanonicalLink$>\n', 'custom', 0),
(33, 1, 0, 0, 1, 1, '[[regtime]]', 'recent_comments', NULL, NULL, NULL, NULL, '[[regtime]]', 'Recent Comments', NULL, 1, '<mt:If tag="BlogCommentCount" include_blogs="children" include_with_website="1">\n    <mt:Comments lastn="10" sort_order="descend" include_blogs="children" include_with_website="1">\n        <mt:CommentsHeader>\n<div class="widget-recent-comments widget">\n    <h3 class="widget-header">Recent Comments</h3>\n    <div class="widget-content">\n        <ul>\n        </mt:CommentsHeader>\n            <li><strong><$mt:CommentAuthor$>:</strong> <$mt:CommentBody remove_html="1" words="10"$> <a href="<$mt:CommentLink$>" title="full comment on: <mt:CommentEntry><$mt:EntryTitle$></mt:CommentEntry>">read more</a></li>\n        <mt:CommentsFooter>\n        </ul>\n    </div>\n</div>\n        </mt:CommentsFooter>\n    </mt:Comments>\n</mt:If>\n', 'widget', 0),
(34, 1, 0, 0, 1, 1, '[[regtime]]', 'main_index', NULL, NULL, NULL, NULL, '[[regtime]]', 'Main Index', 'index.html', 1, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"\n    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" id="sixapart-standard">\n<head>\n    <$mt:Include module="HTML Head"$>\n    <link rel="EditURI" type="application/rsd+xml" title="RSD" href="<$mt:Link template="rsd"$>" />\n    <title><$mt:BlogName encode_html="1"$></title>\n</head>\n<body id="<$mt:WebsiteThemeID$>" class="mt-main-index <$mt:Var name="page_layout"$>">\n    <div id="container">\n        <div id="container-inner">\n\n\n            <$mt:Include module="Banner Header"$>\n\n\n            <div id="content">\n                <div id="content-inner">\n\n\n                    <div id="alpha">\n                        <div id="alpha-inner">\n<mt:Entries include_blogs="children">\n                            <mt:Ignore><!-- Use the Entry Summary module for each entry published on this page --></mt:Ignore>\n                            <$mt:Include module="Entry Summary" display_blog_name="1"$>\n</mt:Entries>\n\n                        </div>\n                    </div>\n\n\n                    <$mt:Include module="Sidebar"$>\n\n\n                </div>\n            </div>\n\n\n            <$mt:Include module="Banner Footer"$>\n\n\n        </div>\n    </div>\n</body>\n</html>\n', 'index', 0),
(35, 1, 0, 0, 1, 1, '[[regtime]]', '3column_layout_secondary_sidebar', NULL, NULL, NULL, NULL, '[[regtime]]', '3-column layout - Secondary Sidebar', NULL, 1, '<mt:include widget="Search"><mt:include widget="Home Page Widgets Group">', 'widgetset', 0),
(36, 1, 0, 0, 1, 1, '[[regtime]]', '3column_layout_primary_sidebar', NULL, NULL, NULL, NULL, '[[regtime]]', '3-column layout - Primary Sidebar', NULL, 1, '<mt:include widget="Blogs"><mt:include widget="Page Listing"><mt:include widget="Syndication"><mt:include widget="OpenID Accepted"><mt:include widget="Powered By">', 'widgetset', 0),
(37, 1, 0, 0, 1, 1, '[[regtime]]', '2column_layout_sidebar', NULL, NULL, NULL, NULL, '[[regtime]]', '2-column layout - Sidebar', NULL, 1, '<mt:include widget="Search"><mt:include widget="Blogs"><mt:include widget="Home Page Widgets Group"><mt:include widget="Page Listing"><mt:include widget="Syndication"><mt:include widget="OpenID Accepted"><mt:include widget="Powered By">', 'widgetset', 0),
(38, 0, 0, 0, 1, NULL, '[[regtime]]', 'notify-entry', NULL, NULL, NULL, NULL, '[[regtime]]', 'Entry Notify', NULL, 1, 'A new <$mt:entryclasslabel$> entitled ''<$mt:EntryTitle$>'' has been published to <$mt:BlogName$>.\n\n<mt:If name="object_type" eq="entry">View entry:<mt:Else>View page:</mt:If> <<mt:SetVarBlock name="entry_status"><$mt:EntryStatus$></mt:SetVarBlock><mt:If name="entry_status" eq="Publish"><$mt:EntryPermalink$><mt:Else><$mt:Var name="entry_editurl"$></mt:If>>\n\n------------------------------------------------------------------------\n<$mt:EntryClassLabel lower_case="1"$> Title: <$mt:EntryTitle$>\nPublish Date: <$mt:EntryDate mail="1"$>\n<mt:If name="send_excerpt">\n\n<$mt:EntryExcerpt wrap_text="72"$>\n</mt:If>\n------------------------------------------------------------------------\n\n<mt:If name="message">Message from Sender:\n<$mt:Var name="message"$></mt:If>\n<mt:If name="send_body">\n------------------------------------------------------------------------\n\n<$mt:EntryBody remove_html="1" wrap_text="72"$>\n\n------------------------------------------------------------------------</mt:If>\n\nYou are receiving this email either because you have elected to receive notifications about new content on <$mt:BlogName$>, or the author of the post thought you would be interested. If you no longer wish to receive these emails, please contact the following person:\n\n<mt:if name="author"><$mt:AuthorDisplayName$> <<$mt:AuthorEmail$>><mt:else><$mt:var name="from_address"$></mt:if>\n', 'email', 0),
(39, 0, 0, 0, 1, NULL, '[[regtime]]', 'recover-password', NULL, NULL, NULL, NULL, '[[regtime]]', 'Password Recovery', NULL, 1, 'A request was made to change your Movable Type password. To complete this process click on the link below to select a new password.\n\n<mt:var name="link_to_login">\n\nIf you did not request this change, you can safely ignore this email.\n\n<mt:include module="Mail Footer">\n', 'email', 0),
(40, 0, 0, 0, 1, NULL, '[[regtime]]', 'verify-subscribe', NULL, NULL, NULL, NULL, '[[regtime]]', 'Subscribe Verify', NULL, 1, 'Thank you for subscribing to notifications about updates to <$mt:BlogName$>. Follow the link below to confirm your subscription:\n\n<$mt:Var name="script_path"$>?__mode=confirm;email=<$mt:Var name="email" escape="url"$>;magic=<$mt:Var name="magic" escape="url"$>;blog_id=<$mt:BlogID$><mt:If name="redirect_url">;redirect=<$mt:Var name="redirect_url" escape="url"$><mt:Else><mt:If name="entry">;entry_id=<$mt:EntryID$></mt:If></mt:If>\n\nIf the link is not clickable, just copy and paste it into your browser.\n\n<$mt:Include module="Mail Footer"$>\n', 'email', 0),
(41, 0, 0, 0, 1, NULL, '[[regtime]]', 'lockout-ip', NULL, NULL, NULL, NULL, '[[regtime]]', 'IP Address Lockout', NULL, 1, 'This email is to notify you that an IP address has been locked out.\n\nIP Address: <mt:var name="ip_address"> \nRecovery: <mt:Date ts="$recovery_time">\n\n<mt:include module="Mail Footer">\n', 'email', 0),
(42, 0, 0, 0, 1, NULL, '[[regtime]]', 'commenter_confirm', NULL, NULL, NULL, NULL, '[[regtime]]', 'Commenter Confirm', NULL, 1, 'Thank you registering for an account to comment on <$mt:BlogName$>. \n\nFor your security and to prevent fraud, we ask you to confirm your account and email address before continuing. Once your account is confirmed, you will immediately be allowed to comment on <$mt:BlogName$>.\n\nTo confirm your account, please click on the following URL, or cut and paste this URL into a web browser:\n\n<$mt:Var name="confirm_url"$>\n\nIf you did not make this request, or you don''t want to register for an account to comment on <$mt:BlogName$>, then no further action is required.\n\nSincerely,\n<mt:If tag="AuthorDisplayName"><$mt:AuthorDisplayName encode_html="1"$><mt:Else>Movable Type</mt:If>\n\n<$mt:Include module="Mail Footer"$>\n', 'email', 0),
(43, 0, 0, 0, 1, NULL, '[[regtime]]', 'new-ping', NULL, NULL, NULL, NULL, '[[regtime]]', 'New Ping', NULL, 1, '<mt:If name="unapproved" trim="1">\n  <mt:IfBlog>\n    <mt:If name="entry_id">\n      <mt:If tag="EntryClass" eq="entry">\n        An unapproved TrackBack has been posted on your blog ''<$mt:BlogName$>'', on entry #<$mt:EntryID$> (<$mt:EntryTitle$>). You need to approve this TrackBack before it will appear on your site.\n      <mt:Else>\n        An unapproved TrackBack has been posted on your blog ''<$mt:BlogName$>'', on page #<$mt:PageID$> (<$mt:PageTitle$>). You need to approve this TrackBack before it will appear on your site.\n      </mt:If>\n    <mt:ElseIf name="category_id">\n      An unapproved TrackBack has been posted on your blog ''<$mt:BlogName$>'', on category #<$mt:CategoryID$>, (<$mt:CategoryLabel$>). You need to approve this TrackBack before it will appear on your site.\n    </mt:If>\n  <mt:Else>\n    An unapproved TrackBack has been posted on your website ''<$mt:WebsiteName$>'', on page #<$mt:PageID$> (<$mt:PageTitle$>). You need to approve this TrackBack before it will appear on your site.\n  </mt:IfBlog>\n<mt:Else>\n  <mt:IfBlog>\n    <mt:If name="entry_id">\n      <mt:If tag="EntryClass" eq="entry">\n        A new TrackBack has been posted on your blog ''<$mt:BlogName$>'', on entry #<$mt:EntryID$> (<$mt:EntryTitle$>).\n      <mt:Else>\n        A new TrackBack has been posted on your blog ''<$mt:BlogName$>'', on page #<$mt:PageID$> (<$mt:PageTitle$>).\n      </mt:If>\n    <mt:ElseIf name="category_id">\n      A new TrackBack has been posted on your blog ''<$mt:BlogName$>'', on category #<$mt:CategoryID$> (<$mt:CategoryLabel$>).\n    </mt:If>\n  <mt:Else>\n    A new TrackBack has been posted on your website ''<$mt:WebsiteName$>'', on page #<$mt:PageID$> (<$mt:PageTitle$>).\n  </mt:IfBlog>\n</mt:If>\n\nExcerpt: \n<$mt:PingExcerpt wrap_text="72"$>\n\nURL: <$mt:PingURL$>\nTitle: <$mt:PingTitle$>\nBlog: <$mt:PingBlogName$>\nIP address: <$mt:PingIP$>\n\n<mt:If name="state_editable"><mt:If name="unapproved">Approve TrackBack: \n  <<$mt:Var name="approve_url"$>>\n</mt:If></mt:If>\n<mt:If name="entry_id"><mt:If tag="EntryPermalink">View TrackBack: \n  <<$mt:EntryPermalink$>>\n</mt:If></mt:If>\n<mt:If name="state_editable">Report TrackBack as spam: \n  <<$mt:Var name="spam_url"$>>\n</mt:If>\nEdit TrackBack: \n  <<$mt:Var name="edit_url"$>>\n\n<$mt:Include module="Mail Footer"$>\n', 'email', 0),
(44, 0, 0, 0, 1, NULL, '[[regtime]]', 'lockout-user', NULL, NULL, NULL, NULL, '[[regtime]]', 'User Lockout', NULL, 1, 'This email is to notify you that a Movable Type user account has been locked out.\n\nUsername: <mt:AuthorName> \nDisplay Name: <mt:AuthorDisplayName>\nEmail: <mt:AuthorEmail>\n\nIf you want to permit this user to participate again, click the link below.\n\n<mt:var name="recover_lockout_link">\n\n<mt:include module="Mail Footer">\n', 'email', 0),
(45, 0, 0, 0, 1, NULL, '[[regtime]]', 'new-comment', NULL, NULL, NULL, NULL, '[[regtime]]', 'New Comment', NULL, 1, '<mt:If name="unapproved"><mt:IfBlog><mt:if tag="EntryClass" eq="entry">An unapproved comment has been posted on your blog ''<$mt:BlogName$>'', for entry #<$mt:EntryID$> (<$mt:EntryTitle$>). You need to approve this comment before it will appear on your site.<mt:Else>An unapproved comment has been posted on your blog ''<$mt:BlogName$>'', on page #<$mt:PageID$> (<$mt:PageTitle$>). You need to approve this comment before it will appear on your site.</mt:If><mt:Else>An unapproved comment has been posted on your website ''<$mt:WebsiteName$>'', on page #<$mt:PageID$> (<$mt:PageTitle$>). You need to approve this comment before it will appear on your site.</mt:IfBlog></mt:If><mt:Unless name="unapproved"><mt:IfBlog><mt:if tag="EntryClass" eq="entry">A new comment has been posted on your blog ''<$mt:BlogName$>'', on entry #<$mt:EntryID$> (<$mt:EntryTitle$>).<mt:Else>A new comment has been posted on your blog ''<$mt:BlogName$>'', on page #<$mt:PageID$> (<$mt:PageTitle$>).</mt:If><mt:Else>A new comment has been posted on your website ''<$mt:WebsiteName$>'', on page #<$mt:PageID$> (<$mt:PageTitle$>).</mt:IfBlog></mt:Unless>\n\n<$mt:CommentBody remove_html="1" wrap_text="72"$>\n\nCommenter name: <$mt:CommentAuthor$> \nCommenter email address: <$mt:CommentEmail$>\nCommenter URL: <$mt:CommentURL$>\nCommenter IP address: <$mt:CommentIP$>\n\n<mt:If name="unapproved"><mt:If name="state_editable">Approve comment:\n  <<$mt:Var name="approve_url"$>></mt:If></mt:If>\n<mt:If name="view_url">View comment:\n  <<$mt:Var name="view_url" escape="html"$>></mt:If>\nEdit comment:\n  <<$mt:Var name="edit_url"$>>\n<mt:If name="state_editable">Report the comment as spam:\n  <<$mt:Var name="spam_url"$>></mt:If>\n\n<$mt:Include module="Mail Footer"$>\n', 'email', 0),
(46, 0, 0, 0, 1, NULL, '[[regtime]]', 'footer-email', NULL, NULL, NULL, NULL, '[[regtime]]', 'Mail Footer', NULL, 1, '\n-- \nPowered by Movable Type <$mt:Version$>\n<$mt:Var name="portal_url"$>\n', 'custom', 0),
(47, 0, 0, 0, 1, NULL, '[[regtime]]', 'commenter_notify', NULL, NULL, NULL, NULL, '[[regtime]]', 'Commenter Notify', NULL, 1, 'This email is to notify you that a new user has successfully registered on the blog ''<$mt:BlogName$>''. Here is some information about this new user.\n\nNew User Information:\nUsername: <$mt:CommenterUsername$> \nFull Name: <$mt:CommenterName$>\nEmail: <$mt:CommenterEmail$>\n\nTo view or edit this user, please click on or cut and paste the following URL into a web browser:\n<$mt:Var name="profile_url"$>\n\n<$mt:Include module="Mail Footer"$>\n', 'email', 0),
(48, 0, 0, 0, 1, NULL, '[[regtime]]', 'comment_throttle', NULL, NULL, NULL, NULL, '[[regtime]]', 'Comment throttle', NULL, 1, '<mt:SetVarBlock name="message">If this was an error, you can unblock the IP address and allow the visitor to add it again by logging in to your Movable Type installation, choosing Blog Config - IP Banning, and deleting the IP address <$mt:Var name="throttled_ip"$> from the list of banned addresses.</mt:SetVarBlock>\nA visitor to your blog <$mt:BlogName$> has automatically been banned by adding more than the allowed number of comments in the last <$mt:Var name="throttle_seconds"$> seconds.\n\nThis was done to prevent a malicious script from overwhelming your weblog with comments. The banned IP address is\n\n<$mt:Var name="throttled_ip"$>\n\n<$mt:Var name="message"$>\n', 'email', 0);

-- --------------------------------------------------------

--
-- Table structure for table `mt_templatemap`
--

CREATE TABLE `mt_templatemap` (
  `templatemap_id` int(11) NOT NULL AUTO_INCREMENT,
  `templatemap_archive_type` varchar(25) NOT NULL,
  `templatemap_blog_id` int(11) NOT NULL,
  `templatemap_build_interval` int(11) DEFAULT NULL,
  `templatemap_build_type` smallint(6) DEFAULT '1',
  `templatemap_file_template` varchar(255) DEFAULT NULL,
  `templatemap_is_preferred` tinyint(4) DEFAULT NULL,
  `templatemap_template_id` int(11) NOT NULL,
  PRIMARY KEY (`templatemap_id`),
  KEY `mt_templatemap_is_preferred` (`templatemap_is_preferred`),
  KEY `mt_templatemap_archive_type` (`templatemap_archive_type`),
  KEY `mt_templatemap_template_id` (`templatemap_template_id`),
  KEY `mt_templatemap_blog_id` (`templatemap_blog_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `mt_templatemap`
--

INSERT INTO `mt_templatemap` VALUES
(1, 'Page', 1, NULL, 1, NULL, 1, 17);

-- --------------------------------------------------------

--
-- Table structure for table `mt_template_meta`
--

CREATE TABLE `mt_template_meta` (
  `template_meta_template_id` int(11) NOT NULL,
  `template_meta_type` varchar(75) NOT NULL,
  `template_meta_vchar` varchar(255) DEFAULT NULL,
  `template_meta_vchar_idx` varchar(255) DEFAULT NULL,
  `template_meta_vdatetime` datetime DEFAULT NULL,
  `template_meta_vdatetime_idx` datetime DEFAULT NULL,
  `template_meta_vinteger` int(11) DEFAULT NULL,
  `template_meta_vinteger_idx` int(11) DEFAULT NULL,
  `template_meta_vfloat` float DEFAULT NULL,
  `template_meta_vfloat_idx` float DEFAULT NULL,
  `template_meta_vblob` mediumblob,
  `template_meta_vclob` mediumtext,
  PRIMARY KEY (`template_meta_template_id`,`template_meta_type`),
  KEY `mt_template_meta_type_vint` (`template_meta_type`,`template_meta_vinteger_idx`),
  KEY `mt_template_meta_type_vflt` (`template_meta_type`,`template_meta_vfloat_idx`),
  KEY `mt_template_meta_type_vdt` (`template_meta_type`,`template_meta_vdatetime_idx`),
  KEY `mt_template_meta_type_vchar` (`template_meta_type`,`template_meta_vchar_idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `mt_template_meta`
--

INSERT INTO `mt_template_meta` VALUES
(35, 'modulesets', '31,30', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(36, 'modulesets', '23,15,26,21,14', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(37, 'modulesets', '31,23,30,15,26,21,14', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mt_template_rev`
--

CREATE TABLE `mt_template_rev` (
  `template_rev_id` int(11) NOT NULL AUTO_INCREMENT,
  `template_rev_changed` varchar(255) NOT NULL,
  `template_rev_created_by` int(11) DEFAULT NULL,
  `template_rev_created_on` datetime DEFAULT NULL,
  `template_rev_description` varchar(255) DEFAULT NULL,
  `template_rev_label` varchar(255) DEFAULT NULL,
  `template_rev_modified_by` int(11) DEFAULT NULL,
  `template_rev_modified_on` datetime DEFAULT NULL,
  `template_rev_rev_number` int(11) NOT NULL DEFAULT '0',
  `template_rev_template` mediumblob NOT NULL,
  `template_rev_template_id` int(11) NOT NULL,
  PRIMARY KEY (`template_rev_id`),
  KEY `mt_template_rev_template_id` (`template_rev_template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_touch`
--

CREATE TABLE `mt_touch` (
  `touch_id` int(11) NOT NULL AUTO_INCREMENT,
  `touch_blog_id` int(11) DEFAULT NULL,
  `touch_modified_on` datetime DEFAULT NULL,
  `touch_object_type` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`touch_id`),
  KEY `mt_touch_blog_type` (`touch_blog_id`,`touch_object_type`,`touch_modified_on`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `mt_touch`
--

INSERT INTO `mt_touch` VALUES
(1, 0, '[[regtime]]', 'author'),
(3, 1, '[[regtime]]', 'page'),
(2, 1, '[[regtime]]', 'template');

-- --------------------------------------------------------

--
-- Table structure for table `mt_trackback`
--

CREATE TABLE `mt_trackback` (
  `trackback_id` int(11) NOT NULL AUTO_INCREMENT,
  `trackback_blog_id` int(11) NOT NULL,
  `trackback_category_id` int(11) NOT NULL DEFAULT '0',
  `trackback_created_by` int(11) DEFAULT NULL,
  `trackback_created_on` datetime DEFAULT NULL,
  `trackback_description` mediumtext,
  `trackback_entry_id` int(11) NOT NULL DEFAULT '0',
  `trackback_is_disabled` tinyint(4) DEFAULT '0',
  `trackback_modified_by` int(11) DEFAULT NULL,
  `trackback_modified_on` datetime DEFAULT NULL,
  `trackback_passphrase` varchar(30) DEFAULT NULL,
  `trackback_rss_file` varchar(255) DEFAULT NULL,
  `trackback_title` varchar(255) DEFAULT NULL,
  `trackback_url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`trackback_id`),
  KEY `mt_trackback_category_id` (`trackback_category_id`),
  KEY `mt_trackback_created_on` (`trackback_created_on`),
  KEY `mt_trackback_blog_id` (`trackback_blog_id`),
  KEY `mt_trackback_entry_id` (`trackback_entry_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `mt_trackback`
--

INSERT INTO `mt_trackback` VALUES
(1, 1, 0, 1, '[[regtime]]', '...', 1, 0, NULL, '[[regtime]]', NULL, NULL, 'home', '[[wwwurl]]/home.html');

-- --------------------------------------------------------

--
-- Table structure for table `mt_ts_error`
--

CREATE TABLE `mt_ts_error` (
  `ts_error_error_time` int(11) NOT NULL,
  `ts_error_funcid` int(11) NOT NULL DEFAULT '0',
  `ts_error_jobid` int(11) NOT NULL,
  `ts_error_message` varchar(255) NOT NULL,
  PRIMARY KEY (`ts_error_jobid`,`ts_error_funcid`),
  KEY `mt_ts_error_funcid_time` (`ts_error_funcid`,`ts_error_error_time`),
  KEY `mt_ts_error_error_time` (`ts_error_error_time`),
  KEY `mt_ts_error_jobid` (`ts_error_jobid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `mt_ts_exitstatus`
--

CREATE TABLE `mt_ts_exitstatus` (
  `ts_exitstatus_jobid` int(11) NOT NULL,
  `ts_exitstatus_completion_time` int(11) DEFAULT NULL,
  `ts_exitstatus_delete_after` int(11) DEFAULT NULL,
  `ts_exitstatus_funcid` int(11) NOT NULL,
  `ts_exitstatus_status` int(11) DEFAULT NULL,
  PRIMARY KEY (`ts_exitstatus_jobid`),
  KEY `mt_ts_exitstatus_funcid` (`ts_exitstatus_funcid`),
  KEY `mt_ts_exitstatus_delete_after` (`ts_exitstatus_delete_after`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `mt_ts_funcmap`
--

CREATE TABLE `mt_ts_funcmap` (
  `ts_funcmap_funcid` int(11) NOT NULL AUTO_INCREMENT,
  `ts_funcmap_funcname` varchar(255) NOT NULL,
  PRIMARY KEY (`ts_funcmap_funcid`),
  UNIQUE KEY `mt_ts_funcmap_funcname` (`ts_funcmap_funcname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mt_ts_job`
--

CREATE TABLE `mt_ts_job` (
  `ts_job_jobid` int(11) NOT NULL AUTO_INCREMENT,
  `ts_job_arg` mediumblob,
  `ts_job_coalesce` varchar(255) DEFAULT NULL,
  `ts_job_funcid` int(11) NOT NULL,
  `ts_job_grabbed_until` int(11) NOT NULL,
  `ts_job_insert_time` int(11) DEFAULT NULL,
  `ts_job_priority` int(11) DEFAULT NULL,
  `ts_job_run_after` int(11) NOT NULL,
  `ts_job_uniqkey` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ts_job_jobid`),
  UNIQUE KEY `mt_ts_job_uniqfunc` (`ts_job_funcid`,`ts_job_uniqkey`),
  KEY `mt_ts_job_funcpri` (`ts_job_funcid`,`ts_job_priority`),
  KEY `mt_ts_job_funccoal` (`ts_job_funcid`,`ts_job_coalesce`),
  KEY `mt_ts_job_funcrun` (`ts_job_funcid`,`ts_job_run_after`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
