<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'lo', version '4.3'.
 *
 * @package     auth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'ປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງທີ່ມີໃຫ້';
$string['allowaccountssameemail'] = 'ອະນຸຍາດບັນຊີທີ່ມີອີເມລດຽວກັນ';
$string['allowaccountssameemail_desc'] = 'ຖ້າເປີດນຳໃຊ້, ຫຼາຍກວ່າໜຶ່ງບັນຊີຜູ້ໃຊ້ສາມາດໃຊ້ທີ່ຢູ່ອີເມລອັນດຽວກັນໄດ້. ສິ່ງນີ້ອາດຈະສົ່ງຜົນໃຫ້ເກີດບັນຫາຄວາມປອດໄພ ຫຼື ຄວາມເປັນສ່ວນຕົວ, ຕົວຢ່າງ: ມີອີເມລການຢືນຢັນການປ່ຽນລະຫັດຜ່ານ.';
$string['alternatelogin'] = 'ຖ້າທ່ານໃສ່ URL ທີ່ນີ້, ມັນຈະຖືກໃຊ້ເປັນໜ້າເຂົ້າສູ່ລະບົບຂອງເວັບໄຊທ໌ນີ້. ໜ້າຄວນປະກອບດ້ວຍແບບຟອມທີ່ມີການຕັ້ງຄ່າຄຸນສົມບັດການດໍາເນີນເປັນ <strong>\'{$a}\'</strong> ແລະ ຕອບກັບຊ່ອງຂໍ້ມູນ <strong>ຊື່ຜູ້ໃຊ້</strong> ແລະ <strong>ລະຫັດຜ່ານ</strong>.<br / >ຈົ່ງລະມັດລະວັງຢ່າໃສ່ URL ທີ່ບໍ່ຖືກຕ້ອງເພາະວ່າທ່ານອາດຈະລັອກຕົວທ່ານເອງອອກຈາກເວັບໄຊທ໌ນີ້. <br />ປ່ອຍໃຫ້ການຕັ້ງຄ່ານີ້ຫວ່າງເປົ່າເພື່ອໃຊ້ໜ້າເຂົ້າສູ່ລະບົບເລີ່ມຕົ້ນ.';
$string['alternateloginurl'] = 'URL ເຂົ້າສູ່ລະບົບສຳຮອງ';
$string['auth_changepasswordhelp'] = 'ຊ່ວຍປ່ຽນລະຫັດຜ່ານ';
$string['auth_changepasswordhelp_expl'] = 'ສະແດງການຊ່ວຍເຫຼືອລະຫັດຜ່ານທີ່ເສຍຫານໄປ ໃຫ້ກັບຜູ້ໃຊ້ທີ່ສູນເສຍລະຫັດຜ່ານ {$a} ຂອງເຂົາເຈົ້າ. ອັນນີ້ຈະຖືກສະແດງທັງເປັນ ຫຼື ແທນທີ່ <strong>ປ່ຽນລະຫັດຜ່ານ URL</strong> ຫຼື ການປ່ຽນລະຫັດຜ່ານ Moodle ພາຍໃນ.';
$string['auth_changepasswordurl'] = 'ປ່ຽນ URL ລະຫັດຜ່ານ';
$string['auth_changepasswordurl_expl'] = 'ລະບຸ url ເພື່ອສົ່ງຜູ້ໃຊ້ທີ່ສູນເສຍລະຫັດຜ່ານ {$a} ຂອງເຂົາເຈົ້າ. ຕັ້ງ <strong>ໃຊ້ໜ້າປ່ຽນລະຫັດຜ່ານມາດຕະຖານ</strong> ເປັນ <strong>ບໍ່</strong>.';
$string['auth_changingemailaddress'] = 'ທ່ານໄດ້ຮ້ອງຂໍໃຫ້ມີການປ່ຽນທີ່ຢູ່ອີເມວ, ຈາກ {$a->oldemail} ເປັນ {$a->newemail}. ດ້ວຍເຫດຜົນດ້ານຄວາມປອດໄພ, ພວກເຮົາສົ່ງອີເມວຫາທ່ານຢູ່ທີ່ຢູ່ໃໝ່ ເພື່ອຢືນຢັນວ່າມັນເປັນຂອງທ່ານ. ທີ່ຢູ່ອີເມວຂອງທ່ານຈະຖືກປັບປຸງທັນທີທີ່ທ່ານເປີດ URL ທີ່ສົ່ງຫາທ່ານໃນຂໍ້ຄວາມນັ້ນ.';
$string['auth_common_settings'] = 'ການຕັ້ງຄ່າທົ່ວໄປ';
$string['auth_data_mapping'] = 'ການສ້າງແຜນທີ່ຂໍ້ມູນ';
$string['auth_fieldlock'] = 'ມູນຄ່າລັອກ';
$string['auth_fieldlock_expl'] = '<p><b>ຄ່າລັອກ:</b>ຖ້າເປີດນຳໃຊ້, ຈະປ້ອງກັນບໍ່ໃຫ້ຜູ້ໃຊ້ Moodle ແລະ ຜູ້ເບິ່ງແຍງລະບົບແກ້ໄຂຊ່ອງຂໍ້ມູນໂດຍກົງ. ໃຊ້ຕົວເລືອກນີ້ຖ້າທ່ານກໍາລັງຮັກສາຂໍ້ມູນນີ້ຢູ່ໃນລະບົບການຮັບຮອງພາຍນອກ. </p>';
$string['auth_fieldlockfield'] = 'ມູນຄ່າລັອກ ({$a})';
$string['auth_fieldlocks'] = 'ລັອກຊ່ອງຂໍ້ມູນຜູ້ໃຊ້';
$string['auth_fieldlocks_help'] = '<p>ທ່ານສາມາດລັອກຊ່ອງຂໍ້ມູນຜູ້ໃຊ້. ສິ່ງນີ້ເປັນປະໂຫຍດສໍາລັບເວັບໄຊທ໌ບ່ອນທີ່ຂໍ້ມູນຜູ້ໃຊ້ຖືກຮັກສາໄວ້ໂດຍຜູ້ບໍລິຫານດ້ວຍຕົນເອງໂດຍການແກ້ໄຂບັນທຶກຜູ້ໃຊ້ ຫຼື ອັບໂຫຼດໂດຍການນໍາໃຊ້ເຄື່ອງມື \'ອັບໂຫຼດຜູ້ໃຊ້\'. ຖ້າທ່ານກໍາລັງລັອກຊ່ອງຂໍ້ມູນທີ່ Moodle ຕ້ອງການ, ກວດໃຫ້ແນ່ໃຈວ່າທ່ານໃຫ້ຂໍ້ມູນນັ້ນເມື່ອສ້າງບັນຊີຜູ້ໃຊ້ ຫຼື ບັນຊີຈະໃຊ້ບໍ່ໄດ້.</p><p>ພິຈາລະນາຕັ້ງຄ່າໂໝດລັອກເປັນ \'ປົດລັອກຖ້າຫວ່າງເປົ່າ\' ເພື່ອຫຼີກເວັ້ນບັນຫານີ້.</p>';
$string['auth_fieldmapping'] = 'ການສ້າງແຜນທີ່ຂໍ້ມູນ ({$a})';
$string['auth_invalidnewemailkey'] = 'ຜິດພາດ: ຖ້າທ່ານກໍາລັງພະຍາຍາມຢືນຢັນການປ່ຽນທີ່ຢູ່ອີເມວ, ທ່ານອາດຈະເຮັດຜິດໃນການອັດສໍາເນົາ URL ທີ່ພວກເຮົາສົ່ງໃຫ້ທ່ານທາງອີເມລ. ກະລຸນາສຳເນົາທີ່ຢູ່ແລ້ວລອງໃໝ່.';
$string['auth_multiplehosts'] = 'ເຈົ້າພາບຫຼາຍອັນ ຫຼື ທີ່ຢູ່ສາມາດລະບຸໄດ້ (ຕົວຢ່າງ: host1.com;host2.com;host3.com) or (eg xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_notconfigured'] = 'ວິທີການພິສູດຢືນຢັນ {$a} ບໍ່ໄດ້ຖືກຕັ້ງຄ່າ.';
$string['auth_outofnewemailupdateattempts'] = 'ທ່ານໝົດການອະນຸຍາດໃຫ້ພະຍາຍາມປັບປຸງທີ່ຢູ່ອີເມວຂອງທ່ານແລ້ວ. ຄຳຮ້ອງຂໍປັບປຸງຂອງທ່ານໄດ້ຖືກຍົກເລີກແລ້ວ.';
$string['auth_passwordisexpired'] = 'ລະຫັດຜ່ານຂອງທ່ານໝົດອາຍຸແລ້ວ. ກະລຸນາປ່ຽນມັນດຽວນີ້.';
$string['auth_passwordwillexpire'] = 'ລະຫັດຜ່ານຂອງທ່ານຈະໝົດອາຍຸໃນ {$a} ມື້. ທ່ານຕ້ອງການປ່ຽນລະຫັດຜ່ານຂອງທ່ານດຽວນີ້ບໍ?';
$string['auth_remove_delete'] = 'ລຶບພາຍໃນຢ່າງເຕັມທີ່';
$string['auth_remove_keep'] = 'ຮັກສາພາຍໃນ';
$string['auth_remove_suspend'] = 'ລະງັບພາຍໃນ';
$string['auth_remove_user'] = 'ລະບຸວ່າຈະເຮັດແນວໃດກັບບັນຊີຜູ້ໃຊ້ພາຍໃນລະຫວ່າງການປະສານງານມວນຊົນເມື່ອຜູ້ໃຊ້ຖືກເອົາອອກຈາກແຫຼ່ງຂໍ້ມູນພາຍນອກ. ສະເພາະຜູ້ໃຊ້ທີ່ຖືກລະງັບໄວ້ຈະຖືກກູ້ຄືນໂດຍອັດຕະໂນມັດ ຖ້າພວກມັນປະກົດຂຶ້ນມາໃໝ່ໃນແຫຼ່ງຂໍ້ມູນພາຍນອກ.';
$string['auth_remove_user_key'] = 'ລຶບຜູ້ໃຊ້ພາຍນອກແລ້ວ';
$string['auth_sync_script'] = 'ການປະສານບັນຊີຜູ້ໃຊ້';
$string['auth_sync_suspended'] = 'ຖ້າເປີດນຳໃຊ້, ຄຸນສົມບັດທີ່ຖືກລະງັບຈະຖືກໃຊ້ເພື່ອອັບເດດສະຖານະການລະງັບບັນຊີຜູ້ໃຊ້ໃນທ້ອງຖິ່ນ.';
$string['auth_sync_suspended_key'] = 'ຊິ້ງຂໍ້ມູນສະຖານະການລະງັບຜູ້ໃຊ້ໃນທ້ອງຖິ່ນ';
$string['auth_updatelocal'] = 'ປັບປຸງທ້ອງຖີ່ນ';
$string['auth_updatelocal_expl'] = '<p><b>ປັບປຸງທ້ອງຖິ່ນ:</b> ຖ້າເປີດໃຊ້ງານ, ຊ່ອງຂໍ້ມູນຈະຖືກປັບປຸງ (ຈາກການຮັບຮອງຈາກພາຍນອກ) ທຸກຄັ້ງທີ່ຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບ ຫຼື ມີການຊິ້ງຂໍ້ມູນຜູ້ໃຊ້. ຊ່ອງຂໍ້ມູນທີ່ຕັ້ງໃຫ້ປັບປຸງຢູ່ໃນທ້ອງຖິ່ນຄວນຖືກລັອກໄວ້. </p>';
$string['auth_updatelocalfield'] = 'ປັບປຸງທ້ອງຖິ່ນ ({$a})';
$string['auth_updateremote'] = 'ປັບປຸງພາຍນອກ';
$string['auth_updateremote_expl'] = '<p><b>ປັບປຸງພາຍນອກ:</b> ຖ້າເປີດໃຊ້ງານແລ້ວ, ການຮັບຮອງພາຍນອກຈະຖືກປັບປຸງເມື່ອບັນທຶກຜູ້ໃຊ້ຖືກອັບເດດ. ຊ່ອງຂໍ້ມູນຄວນຖືກປົດລັອກເພື່ອອະນຸຍາດການແກ້ໄຂ.</p>';
$string['auth_updateremote_ldap'] = '<p><b>ໝາຍເຫດ:</b> ການປັບປຸງຂໍ້ມູນ LDAP ພາຍນອກຮຽກຮ້ອງໃຫ້ທ່ານຕັ້ງ binddn ແລະ bindpw ເປັນ bind-user ທີ່ມີສິດການແກ້ໄຂບັນທຶກຜູ້ໃຊ້ທັງໝົດ. ປະຈຸບັນມັນບໍ່ໄດ້ຮັກສາຄຸນສົມບັດທີ່ມີຄຸນຄ່າຫຼາຍອັນໄວ້, ແລະຈະເອົາຄ່າພິເສດອອກໄປເມື່ອອັບເດດ. </p>';
$string['auth_updateremotefield'] = 'ປັບປຸງພາຍນອກ ({$a})';
$string['auth_user_create'] = 'ເປີດໃຊ້ການສ້າງຜູ້ໃຊ້';
$string['auth_user_creation'] = 'ຜູ້ໃຊ້ໃໝ່ (ບໍ່ລະບຸຊື່) ສາມາດສ້າງບັນຊີຜູ້ໃຊ້ຢູ່ໃນແຫຼ່ງກວດສອບຄວາມຖືກຕ້ອງພາຍນອກ ແລະ ຢືນຢັນຜ່ານອີເມລ. ຖ້າທ່ານເປີດໃຊ້ສິ່ງນີ້, ຢ່າລືມຕັ້ງຄ່າຕົວເລືອກສະເພາະຊຸດສໍາລັບການສ້າງຜູ້ໃຊ້.';
$string['auth_usernameexists'] = 'ຊື່ຜູ້ໃຊ້ທີ່ເລືອກນັ້ນມີຢູ່ແລ້ວ. ກະລຸນາເລືອກອັນໃໝ່.';
$string['auth_usernotexist'] = 'ບໍ່ສາມາດປັບປຸງຜູ້ໃຊ້ທີ່ບໍ່ມີຢູ່ແລ້ວ: {$a}';
$string['authenticationoptions'] = 'ທາງເລືອກການກວດສອບຄວາມຖືກຕ້ອງ';
$string['authinstructions'] = 'ປະຫວ່າງເປົ່າສໍາລັບຄໍາແນະນໍາການເຂົ້າສູ່ລະບົບເລີ່ມຕົ້ນທີ່ຈະສະແດງຢູ່ໃນໜ້າເຂົ້າສູ່ລະບົບ. ຖ້າທ່ານຕ້ອງການໃຫ້ຄໍາແນະນໍາການເຂົ້າສູ່ລະບົບແບບກໍານົດເອງ, ໃສ່ພວກມັນຢູ່ທີ່ນີ້.';
$string['authloginviaemail'] = 'ອະນຸຍາດໃຫ້ເຂົ້າສູ່ລະບົບຜ່ານທາງອີເມລ';
$string['authloginviaemail_desc'] = 'ອະນຸຍາດໃຫ້ຜູ້ໃຊ້ໃຊ້ທັງຊື່ຜູ້ໃຊ້ ແລະ ທີ່ຢູ່ອີເມລ (ຖ້າບໍ່ຊໍ້າກັນ) ສໍາລັບການເຂົ້າສູ່ລະບົບເວັບໄຊທ໌.';
$string['auto_add_remote_users'] = 'ເພີ່ມຜູ້ໃຊ້ທາງໄກໂດຍອັດຕະໂນມັດ';
$string['cannotmapfield'] = 'ຊ່ອງຂໍ້ມູນ "{$a->fieldname}" ບໍ່ສາມາດເຮັດແຜນທີ່ໄດ້ເພາະວ່າຊື່ສັ້ນຂອງມັນ "{$a->shortname}" ຍາວເກີນໄປ. ເພື່ອອະນຸຍາດໃຫ້ມັນຖືກສ້າງແຜນທີ່, ທ່ານຈໍາເປັນຕ້ອງຫຼຸດຊື່ສັ້ນລົງເປັນ {$a->charlimit} ຕົວອັກສອນ. <a href="{$a->link}">ແກ້ໄຂຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌ຜູ້ໃຊ້</a>';
$string['changepassword'] = 'ປ່ຽນ URL ລະຫັດຜ່ານ';
$string['changepasswordhelp'] = 'URL ຂອງໜ້າການກູ້ລະຫັດຜ່ານທີ່ເສຍ, ເຊິ່ງຈະຖືກສົ່ງຫາຜູ້ໃຊ້ໃນອີເມລ. ກະລຸນາຮັບຊາບວ່າ ການຕັ້ງຄ່ານີ້ຈະບໍ່ມີຜົນຖ້າມີການຕັ້ງລະຫັດຜ່ານ URL ທີ່ລືມຢູ່ໃນການຕັ້ງຄ່າທົ່ວໄປຂອງການກວດສອບຄວາມຖືກຕ້ອງ.';
$string['chooseauthmethod'] = 'ເລືອກວິທີການກວດສອບຄວາມຖືກຕ້ອງ';
$string['chooseauthmethod_help'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດວິທີການກວດສອບຄວາມຖືກຕ້ອງທີ່ໃຊ້ເມື່ອຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບ. ຄວນເລືອກພຽງແຕ່ປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງເທົ່ານັ້ນ, ຖ້າບໍ່ດັ່ງນັ້ນຜູ້ໃຊ້ຈະບໍ່ສາມາດເຂົ້າສູ່ລະບົບໄດ້ອີກ. ເພື່ອປິດກັ້ນຜູ້ໃຊ້ບໍ່ໃຫ້ເຂົ້າສູ່ລະບົບ, ເລືອກ "ບໍ່ເຂົ້າສູ່ລະບົບ".';
$string['createpassword'] = 'ສ້າງລະຫັດຜ່ານ ແລະ ແຈ້ງໃຫ້ຜູ້ໃຊ້';
$string['createpasswordifneeded'] = 'ສ້າງລະຫັດຜ່ານຖ້າຈໍາເປັນ ແລະ ສົ່ງຜ່ານອີເມລ';
$string['emailchangecancel'] = 'ຍົກເລີກການປ່ຽນແປງອີເມວ';
$string['emailchangepending'] = 'ລໍຖ້າການປ່ຽນແປງ. ເປີດລິ້ງທີ່ສົ່ງຫາທ່ານທີ່ {$a->preference_newemail}.';
$string['emailnowexists'] = 'ທີ່ຢູ່ອີເມວທີ່ທ່ານພະຍາຍາມແຕ່ງຕັ້ງໃຫ້ກັບໂປຼໄຟລ໌ຂອງທ່ານໄດ້ຖືກແຕ່ງຕັ້ງໃຫ້ຜູ້ອື່ນຕັ້ງແຕ່ການຮ້ອງຂໍເບື້ອງຕົ້ນຂອງທ່ານ. ຄຳຂໍຂອງທ່ານສຳລັບການປ່ຽນທີ່ຢູ່ອີເມລໄດ້ຖືກຍົກເລີກໃນທີ່ນີ້, ແຕ່ທ່ານອາດຈະລອງໃໝ່ດ້ວຍທີ່ຢູ່ອື່ນ.';
$string['emailupdate'] = 'ອັບເດດທີ່ຢູ່ອີເມລ';
$string['emailupdatemessage'] = 'ສະບາຍດີ {$a->fullname},

ທ່ານໄດ້ຮ້ອງຂໍໃຫ້ມີການປ່ຽນທີ່ຢູ່ອີເມລຂອງທ່ານສໍາລັບບັນຊີຂອງທ່ານຢູ່ໃນ {$a->site}. ເພື່ອຢືນຢັນການປ່ຽນແປງນີ້, ກະລຸນາໄປທີ່ທີ່ຢູ່ເວັບຕໍ່ໄປນີ້:

{$a->url}

{$a->supportemail}';
$string['emailupdatesuccess'] = 'ທີ່ຢູ່ອີເມລຂອງຜູ້ໃຊ້ <em>{$a->fullname}</em> ຖືກປັບປຸງຢ່າງສຳເລັດເປັນ <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'ການຢືນຢັນການອັບເດດອີເມວຢູ່ທີ່ {$a->site}';
$string['errormaxconsecutiveidentchars'] = 'ລະຫັດຜ່ານຕ້ອງມີຕົວອັກສອນປະຈຳຕົວຕິດຕໍ່ກັນຫຼາຍສຸດ {$a}.';
$string['errorminpassworddigits'] = 'ລະຫັດຜ່ານຕ້ອງມີຢ່າງໜ້ອຍ {$a} ຕົວເລກ.';
$string['errorminpasswordlength'] = 'ລະຫັດຜ່ານຕ້ອງມີຄວາມຍາວຢ່າງໜ້ອຍ {$a} ຕົວອັກສອນ.';
$string['errorminpasswordlower'] = 'ລະຫັດຜ່ານຕ້ອງມີຕົວພິມນ້ອຍຢ່າງໜ້ອຍ {$a} ຕົວ.';
$string['errorminpasswordnonalphanum'] = 'ລະຫັດຜ່ານຕ້ອງມີຕົວມີຢ່າງໜ້ອຍ {$a} ອັກສອນພິເສດເຊັ່ນ: ຕົວເຊັ່ນ: *, -, ຫຼື #.';
$string['errorminpasswordupper'] = 'ລະຫັດຜ່ານຕ້ອງມີຕົວພິມໃຫຍ່ຢ່າງໜ້ອຍ {$a} ຕົວ.';
$string['errorpasswordreused'] = 'ລະຫັດຜ່ານນີ້ໄດ້ຖືກໃຊ້ມາກ່ອນ, ແລະ ບໍ່ອະນຸຍາດໃຫ້ນຳກັບມາໃຊ້ຄືນໃໝ່ໄດ້';
$string['errorpasswordupdate'] = 'ເກີດຄວາມຜິດພາດໃນການປັບປຸງລະຫັດຜ່ານ, ລະຫັດຜ່ານບໍ່ໄດ້ປ່ຽນ';
$string['eventuserloggedin'] = 'ຜູ້ໃຊ້ໄດ້ເຂົ້າສູ່ລະບົບແລ້ວ';
$string['eventuserloggedinas'] = 'ຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບເປັນຜູ້ໃຊ້ອື່ນ';
$string['eventuserloginfailed'] = 'ເຂົ້າສູ່ລະບົບຜູ້ໃຊ້ບໍ່ສໍາເລັດ';
$string['forcechangepassword'] = 'ບັງຄັບປ່ຽນລະຫັດຜ່ານ';
$string['forcechangepassword_help'] = 'ບັງຄັບໃຫ້ຜູ້ໃຊ້ປ່ຽນລະຫັດຜ່ານໃນການເຂົ້າສູ່ລະບົບຄັ້ງຕໍ່ໄປຂອງເຂົາເຈົ້າກັບ Moodle.';
$string['forcechangepasswordfirst_help'] = 'ບັງຄັບໃຫ້ຜູ້ໃຊ້ປ່ຽນລະຫັດຜ່ານໃນການເຂົ້າສູ່ລະບົບຄັ້ງທໍາອິດຂອງເຂົາເຈົ້າກັບ Moodle.';
$string['forgottenpassword'] = 'ຖ້າທ່ານໃສ່ URL ທີ່ນີ້, ມັນຈະຖືກໃຊ້ເປັນໜ້າການກູ້ລະຫັດຜ່ານທີ່ສູນເສຍສໍາລັບເວັບໄຊທ໌ນີ້. ສິ່ງນີ້ມີຈຸດປະສົງສໍາລັບເວັບໄຊທ໌ທີ່ລະຫັດຜ່ານຖືກຈັດການທັງໝົດຢູ່ນອກ Moodle. ປ່ອຍໃຫ້ຊ່ອງນີ້ຫວ່າງເພື່ອໃຊ້ການກູ້ລະຫັດຜ່ານເລີ່ມຕົ້ນ.';
$string['forgottenpasswordurl'] = 'ລືມລະຫັດຜ່ານ URL';
$string['getrecaptchaapi'] = 'ເພື່ອໃຊ້ reCAPTCHA ທ່ານຕ້ອງໄດ້ຮັບກະແຈ API ຈາກ <a href=\'https://www.google.com/recaptcha/admin\'>https://www.google.com/recaptcha/admin</a>';
$string['guestloginbutton'] = 'ປຸ່ມເຂົ້າສູ່ລະບົບຂອງແຂກ';
$string['incorrectpleasetryagain'] = 'ບໍ່ຖືກຕ້ອງ. ກະລຸນາລອງໃໝ່.';
$string['infilefield'] = 'ຕ້ອງລະບຸຂໍ້ມູນໃນໄຟລ໌';
$string['informminpassworddigits'] = 'ຢ່າງໜ້ອຍ {$a} ຕົວເລກ';
$string['informminpasswordlength'] = 'ຢ່າງໜ້ອຍ {$a} ຕົວອັກສອນ';
$string['informminpasswordlower'] = 'ຢ່າງຫນ້ອຍ {$a} ຕົວອັກສອນນ້ອຍ';
$string['informminpasswordnonalphanum'] = 'ຢ່າງໜ້ອຍ {$a} ຕົວອັກສອນພິເສດເຊັ່ນ: *, -, ຫຼື #';
$string['informminpasswordreuselimit'] = 'ລະຫັດຜ່ານສາມາດນໍາກັບມາໃຊ້ຄືນໃໝ່ໄດ້ຫຼັງຈາກ {$a} ປ່ຽນແປງ';
$string['informminpasswordupper'] = 'ຢ່າງຫນ້ອຍ {$a} ຕົວອັກສອນໃຫຍ່';
$string['informpasswordpolicy'] = 'ລະຫັດຜ່ານຕ້ອງມີ {$a} ຕົວ';
$string['instructions'] = 'ການແນະນຳ';
$string['internal'] = 'ພາຍໃນ';
$string['limitconcurrentlogins'] = 'ຈຳກັດການເຂົ້າສູ່ລະບົບພ້ອມກັນ';
$string['limitconcurrentlogins_desc'] = 'ຖ້າເປີດໃຊ້ງານຈໍານວນການລົງຊື່ເຂົ້າໃຊ້ຂອງບຣາວເຊີພ້ອມກັນສໍາລັບຜູ້ໃຊ້ແຕ່ລະຄົນແມ່ນຖືກຈໍາກັດ. ຊ່ວງເວລາເກົ່າສຸດແມ່ນສິ້ນສຸດລົງຫຼັງຈາກຮອດຂີດຈໍາກັດ, ກະລຸນາຮັບຊາບວ່າ ຜູ້ໃຊ້ອາດຈະເສຍວຽກທັງໝົດທີ່ບໍ່ໄດ້ບັນທຶກໄວ້. ການຕັ້ງຄ່ານີ້ບໍ່ເຂົ້າກັນໄດ້ກັບປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງຕົວເຂົ້າສູ່ລະບົບອັນດຽວ (SSO).';
$string['locked'] = 'ລັອກແລ້ວ';
$string['md5'] = 'MD5 hash';
$string['nopasswordchange'] = 'ບໍ່ສາມາດປ່ຽນລະຫັດຜ່ານໄດ້';
$string['nopasswordchangeforced'] = 'ເຈົ້າບໍ່ສາມາດດໍາເນີນການຕໍ່ໄປໄດ້ໂດຍບໍ່ປ່ຽນລະຫັດຜ່ານຂອງທ່ານ, ຢ່າງໃດກໍ່ຕາມ, ບໍ່ມີໜ້າທີ່ສາມາດປ່ຽນມັນໄດ້. ກະລຸນາຕິດຕໍ່ຫາຜູ້ເບິ່ງແຍງລະບົບ Moodle ຂອງທ່ານ.';
$string['noprofileedit'] = 'ບໍ່ສາມາດແກ້ໄຂໂປຼໄຟລ໌ໄດ້';
$string['ntlmsso_attempting'] = 'ກຳລັງພະຍາຍາມເຂົ້າສູ່ລະບົບຄັ້ງດຽວຜ່ານ NTLM...';
$string['ntlmsso_failed'] = 'ເຂົ້າສູ່ລະບົບອັດຕະໂນມັດບໍ່ສຳເລັດ, ລອງໜ້າເຂົ້າສູ່ລະບົບປົກກະຕິ...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO ຖືກປິດການນຳໃຊ້.';
$string['passwordhandling'] = 'ການຈັດການຊ່ອງຂໍ້ມູນລະຫັດຜ່ານ';
$string['plaintext'] = 'ຂໍ້ຄວາມທຳມະດາ';
$string['pluginnotenabled'] = 'ປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງ \'{$a}\' ບໍ່ໄດ້ຖືກເປີດໃຊ້.';
$string['pluginnotinstalled'] = 'ປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງ \'{$a}\' ບໍ່ໄດ້ຖືກຕິດຕັ້ງ.';
$string['potentialidps'] = 'ເຂົ້າສູ່ລະບົບດ້ວຍບັນຊີຂອງທ່ານຢູ່ທີ່:';
$string['privacy:metadata:userpref:createpassword'] = 'ສະແດງວ່າຄວນສ້າງລະຫັດຜ່ານໃຫ້ກັບຜູ້ໃຊ້';
$string['privacy:metadata:userpref:forcepasswordchange'] = 'ຊີ້ບອກວ່າຜູ້ໃຊ້ຄວນປ່ຽນລະຫັດຜ່ານຂອງເຂົາທ່ານບໍເມື່ອເຂົ້າສູ່ລະບົບ';
$string['privacy:metadata:userpref:loginfailedcount'] = 'ຈໍານວນຄັ້ງທີ່ຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບບໍ່ສໍາເລັດ';
$string['privacy:metadata:userpref:loginfailedcountsincesuccess'] = 'ຈໍານວນຄັ້ງທີ່ຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບບໍ່ສໍາເລັດຕັ້ງແຕ່ການເຂົ້າສູ່ລະບົບຄັ້ງລ້າສຸດຂອງເຂົາເຈົ້າ';
$string['privacy:metadata:userpref:loginfailedlast'] = 'ວັນທີທີ່ບັນທຶກຄວາມພະຍາຍາມເຂົ້າສູ່ລະບົບຄັ້ງສຸດທ້າຍທີ່ລົ້ມເຫຼວ';
$string['privacy:metadata:userpref:loginlockout'] = 'ບໍ່ວ່າບັນຊີຂອງຜູ້ໃຊ້ຖືກລັອກເນື່ອງຈາກການພະຍາຍາມເຂົ້າສູ່ລະບົບບໍ່ສໍາເລັດ ແລະ ວັນທີທີ່ບັນຊີຖືກລັອກ';
$string['privacy:metadata:userpref:loginlockoutignored'] = 'ຊີ້ໃຫ້ເຫັນວ່າບັນຊີຂອງຜູ້ໃຊ້ບໍ່ຄວນຖືກລັອກ';
$string['privacy:metadata:userpref:loginlockoutsecret'] = 'ເມື່ອຖືກລັອກ, ຄວາມລັບທີ່ຜູ້ໃຊ້ຕ້ອງໃຊ້ເພື່ອປົດລັອກບັນຊີຂອງເຂົາເຈົ້າ';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = 'CAPTCHA ແມ່ນເພື່ອປ້ອງກັນການລ່ວງລະເມີດຈາກໂປຼແກຼມອັດຕະໂນມັດ. ເຮັດຕາມຄຳແນະນຳ ເພື່ອຢັ້ງຢືນວ່າທ່ານແມ່ນບຸກຄົນໃດໜຶ່ງ. ສິ່ງນີ້ອາດຈະເປັນກ່ອງເພື່ອກວດກາ, ຕົວອັກສອນທີ່ນໍາສະເໜີຢູ່ໃນຮູບພາບທີ່ທ່ານຕ້ອງໃສ່ ຫຼື ຊຸດຮູບພາບເພື່ອເລືອກຈາກ.

ຖ້າທ່ານບໍ່ແນ່ໃຈວ່າຮູບພາບແມ່ນຫຍັງ, ເຈົ້າສາມາດລອງເອົາ CAPTCHA ອື່ນ ຫຼື CAPTCHA ສຽງ.';
$string['recaptcha_link'] = 'auth/email';
$string['security_question'] = 'ຄໍາຖາມຄວາມປອດໄພ';
$string['selfregistration'] = 'ການລົງທະບຽນດ້ວຍຕົນເອງ';
$string['selfregistration_help'] = 'ຖ້າປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງ, ເຊັ່ນ: ການລົງທະບຽນດ້ວຍຕົນເອງທີ່ອີງໃສ່ອີເມລ, ຫຼັງຈາກນັ້ນມັນຈະຊ່ວຍໃຫ້ຜູ້ໃຊ້ທີ່ເປັນໄປໄດ້ສາມາດລົງທະບຽນດ້ວຍຕົນເອງ ແລະ ສ້າງບັນຊີໄດ້. ສິ່ງນີ້ສົ່ງຜົນໃຫ້ມີຄວາມເປັນໄປໄດ້ຂອງຜູ້ສົ່ງສະແປມຈະສ້າງບັນຊີເພື່ອໃຊ້ໂພສໃນເວທີສົນທະນາ, ລາຍການບລັອກແລະອື່ນ. ສໍາລັບສະແປມ. ເພື່ອຫຼີກເວັ້ນຄວາມສ່ຽງນີ້, ການລົງທະບຽນດ້ວຍຕົນເອງຄວນຖືກປິດໃຊ້ງານ ຫຼື ຈໍາກັດໂດຍການຕັ້ງ <em>ໂດເມນອີເມລທີ່ອະນຸຍາດ</em>.';
$string['settingmigrationmismatch'] = 'ກວດພົບຄ່າບໍ່ກົງກັນໃນຂະນະທີ່ແກ້ໄຂຊື່ການຕັ້ງຄ່າປລັກອິນ! ປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງ \'{$a->plugin}\' ມີການຕັ້ງຄ່າ \'{$a->setting}\' ຕັ້ງຄ່າເປັນ \'{$a->legacy}\' ພາຍໃຕ້ຊື່ເດີມ ແລະ ເປັນ \'{$a->current}\' ພາຍໃຕ້ຊື່ປະຈຸບັນ. ຄ່າສຸດທ້າຍໄດ້ຖືກຕັ້ງເປັນອັນທີ່ຖືກຕ້ອງແຕ່ທ່ານຄວນກວດເບິ່ງ ແລະ ຢືນຢັນວ່າມັນຖືກຄາດໄວ້.';
$string['sha1'] = 'SHA-1 hash';
$string['showguestlogin'] = 'ທ່ານສາມາດເຊື່ອງ ຫຼື ສະແດງປຸ່ມເຂົ້າສູ່ລະບົບຂອງແຂກຢູ່ໃນ ໜ້າເຂົ້າສູ່ລະບົບ.';
$string['stdchangepassword'] = 'ໃຊ້ໜ້າມາດຕະຖານສໍາລັບການປ່ຽນລະຫັດຜ່ານ';
$string['stdchangepassword_expl'] = 'ຖ້າລະບົບການກວດສອບພາຍນອກອະນຸຍາດໃຫ້ປ່ຽນລະຫັດຜ່ານທາງ Moodle, ສະຫຼັບສິ່ງນີ້ໄປຫາ ແມ່ນ. ການຕັ້ງຄ່ານີ້ລົບລ້າງ \'ປ່ຽນລະຫັດຜ່ານ URL\'.';
$string['stdchangepassword_explldap'] = 'ໝາຍເຫດ: ຂໍແນະນໍາໃຫ້ທ່ານໃຊ້ LDAP ຜ່ານອຸໂມງ SSL ທີ່ໃສ່ລະຫັດ SSL (ldaps://) ຖ້າເຊີບເວີ LDAP ຢູ່ທາງໄກ.';
$string['suspended'] = 'ບັນຊືຖືກລະງັບ';
$string['suspended_help'] = 'ບັນຊີຜູ້ໃຊ້ທີ່ຖືກລະງັບໄວ້ບໍ່ສາມາດເຂົ້າສູ່ລະບົບ ຫຼື ໃຊ້ການບໍລິການເວັບໄດ້, ແລະ ຂໍ້ຄວາມຂາອອກໃດໜຶ່ງຖືກຍົກເລີກ.';
$string['testsettings'] = 'ການຕັ້ງຄ່າການທົດສອບ';
$string['testsettingsheading'] = 'ທົດສອບການຕັ້ງຄ່າການກວດສອບຄວາມຖືກຕ້ອງ - {$a}';
$string['unlocked'] = 'ປົດລັອກ';
$string['unlockedifempty'] = 'ປົດລັອກຖ້າຫວ່າງເປົ່າ';
$string['update_never'] = 'ບໍ່ເຄີຍ';
$string['update_oncreate'] = 'ກ່ຽວກັບການສ້າງ';
$string['update_onlogin'] = 'ກ່ຽວກັບທຸກໆການເຂົ້າສູ່ລະບົບ';
$string['update_onupdate'] = 'ກ່ຽວກັບການປັບປຸງ';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() ບໍ່ຮອງຮັບປະເພດເພດທີ່ເລືອກ: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() ບໍ່ຮອງຮັບ usertype ທີ່ເລືອກ (..ຍັງເທື່ອ)';
$string['username'] = 'ຊື່ຜູ້ໃຊ້';
$string['username_help'] = 'ກະລຸນາຮັບຊາບວ່າ ປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງບາງອັນຈະບໍ່ອະນຸຍາດໃຫ້ທ່ານປ່ຽນຊື່ຜູ້ໃຊ້.';
