<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certificate', language 'fr', version '4.3'.
 *
 * @package     tool_certificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcertpage'] = 'Ajouter une page';
$string['addelement'] = 'Ajouter un élément';
$string['addelementwithname'] = 'Ajouter « {$a} » éléments';
$string['after'] = 'Après';
$string['aissueswerecreated'] = '{$a} certificats ont été délivrés';
$string['aligncentre'] = 'Centre';
$string['alignleft'] = 'Gauche';
$string['alignment'] = 'Alignement du texte';
$string['alignment_help'] = 'L’alignement à droite du texte signifiera que les coordonnées de l’élément (Position X et Position Y) feront référence au coin supérieur droit de la zone de texte. Dans l’alignement central, elles se réfèreront en haut au milieu et en  alignement à gauche elles feront référence au coin supérieur gauche.';
$string['alignright'] = 'Droite';
$string['availableincourses'] = 'Disponible dans les sous-catégories et les cours';
$string['availableincourses_help'] = 'En activant cette option, les utilisateurs (dont les capacités l’autorisent) pourront utiliser ce modèle dans chaque cours de la catégorie sélectionnée, ainsi que dans les cours des sous-catégories. Si cette option est désactivée, ce modèle sera disponible exclusivement pour les utilisateurs ayant des capacités l’autorisant dans la catégorie sélectionnée.';
$string['certificate'] = 'Certificat';
$string['certificate:image'] = 'Gérer les images des certificats';
$string['certificate:issue'] = 'Délivrer un certificat pour les utilisateurs';
$string['certificate:manage'] = 'Gérer les certificats';
$string['certificate:verify'] = 'Vérifier les certificats';
$string['certificate:viewallcertificates'] = 'Visualiser tous les modèles de certificats et les certificats délivrés';
$string['certificate_customfield'] = 'Champs personnalisés du certificat';
$string['certificatecopy'] = '{$a} (copie)';
$string['certificateimages'] = 'Images de certificat';
$string['certificates'] = 'Certificats';
$string['certificatesettings'] = 'Paramètres des certificats';
$string['certificatesissues'] = 'Émissions de certificats';
$string['certificatetemplate'] = 'Modèle de certificat';
$string['certificatetemplatename'] = 'Nom du modèle de certificat';
$string['certificatetemplates'] = 'Modèles de certificat';
$string['changeelementsequence'] = 'Avancer ou reculer';
$string['code'] = 'Code';
$string['codewithlink'] = 'Code avec un lien';
$string['coursecategorywithlink'] = 'Catégorie de cours avec un lien';
$string['createtemplate'] = 'Nouveau modèle de certificat';
$string['customfield_previewvalue'] = 'Valeur de l’aperçu';
$string['customfield_previewvalue_help'] = 'Valeur affichée lors de la prévisualisation du modèle de certificat';
$string['customfield_visible'] = 'Visible';
$string['customfield_visible_help'] = 'Autoriser à sélectionner ce champ sur le modèle de certificat';
$string['customfieldsettings'] = 'Paramètres des champs personnalisés de certificat courant';
$string['deleteelement'] = 'Supprimer l’élément';
$string['deleteelementconfirm'] = 'Voulez-vous vraiment supprimer l’élément « {$a} » ?';
$string['deletepage'] = 'Supprimer la page';
$string['deletepageconfirm'] = 'Voulez-vous vraiment supprimer cette page du certificat ?';
$string['deletetemplateconfirm'] = 'Voulez-vous vraiment supprimer le modèle « {$a} » a toutes les données qui lui sont associées ? Cette action ne peut pas être annulée.';
$string['demotmpl'] = 'Démo de modèle de certificat';
$string['demotmplawardedon'] = 'Attribué le';
$string['demotmplawardedto'] = 'Ce certificat est attribué à';
$string['demotmplbackground'] = 'Image de fond';
$string['demotmplcoursefullname'] = 'Nom complet du cours';
$string['demotmpldirector'] = 'Directeur de l’École';
$string['demotmplforcompleting'] = 'Pour avoir terminé le cours';
$string['demotmplissueddate'] = 'Date d’émission';
$string['demotmplqrcode'] = 'Code QR';
$string['demotmplsignature'] = 'Signature';
$string['demotmplusername'] = 'Nom de l’utilisateur';
$string['duplicate'] = 'Dupliquer';
$string['duplicatetemplateconfirm'] = 'Voulez-vous vraiment dupliquer le modèle « {$a} » ?';
$string['editcertificate'] = 'Modifier le modèle de certificat « {$a} »';
$string['editelement'] = 'Modifier « {$a} »';
$string['editelementname'] = 'Modifier le nom de l’élément';
$string['editpage'] = 'Modifier la page {$a}';
$string['edittemplatename'] = 'Modifier le nom du modèle';
$string['elementname'] = 'Nom de l’élément';
$string['elementname_help'] = 'Ce sera le nom utilisé pour identifier cet élément lors de la modification d’un certificat. Notez que cela ne sera pas affiché sur le PDF.';
$string['elementwidth'] = 'Largeur, mm';
$string['elementwidth_help'] = 'Spécifiez la largeur de l’élément. Zéro (0) signifie qu’il n’y a pas de contrainte de largeur.';
$string['entitycertificate'] = 'Certificat';
$string['entitycertificateissue'] = 'Émission du certificat';
$string['eventcertificateissued'] = 'Certificat délivré';
$string['eventcertificaterevoked'] = 'Certificat révoqué';
$string['eventcertificateverified'] = 'Certificat vérifié';
$string['eventtemplatecreated'] = 'Modèle créé';
$string['eventtemplatedeleted'] = 'Modèle supprimé';
$string['eventtemplateupdated'] = 'Modèle mis à jour';
$string['expired'] = 'Échu';
$string['expiredcertificate'] = 'Ce certificat est arrivé à échéance';
$string['expirydate'] = 'Date d’échéance';
$string['expirydatetype'] = 'Type de date d’échéance';
$string['font'] = 'Police';
$string['font_help'] = 'La police utilisée lors de la génération de cet élément.';
$string['fontcolour'] = 'Couleur';
$string['fontcolour_help'] = 'La couleur de la police.';
$string['fontsize'] = 'Taille, pt';
$string['fontsize_help'] = 'La taille de la police en points.';
$string['hideshow'] = 'Cacher / montrer';
$string['invalidcolour'] = 'Couleur invalide choisie. Veuillez entrer un nom de couleur HTML valide ou une couleur hexadécimale à six ou trois chiffres.';
$string['invalidelementwidth'] = 'Veuillez saisir un nombre positif.';
$string['invalidheight'] = 'La hauteur doit être un nombre valide supérieur à 0.';
$string['invalidmargin'] = 'La marge doit être un nombre valide supérieur à 0.';
$string['invalidposition'] = 'Veuillez sélectionner un nombre positif pour la position {$a}.';
$string['invalidwidth'] = 'La largeur doit être un nombre valide supérieur à 0.';
$string['issuecertificates'] = 'Délivrer des certificats';
$string['issueddate'] = 'Date d’émission';
$string['issuelang'] = 'Délivrer les certificats dans la langue de l’utilisateur';
$string['issuelangdesc'] = 'Sur les sites multilingues, si la langue de l’utilisateur est différente de celle du site les certificats seront générés dans la langue de l’utilisateur, sinon tous les certificats seront générés dans la langue par défaut du site.';
$string['issuenewcertificate'] = 'Délivrer des certificats à partir de ce modèle';
$string['issuenotallowed'] = 'Vous n’êtes pas autorisé à délivrer des certificats à partir de ce modèle.';
$string['issueormangenotallowed'] = 'Vous n’êtes pas autorisé à délivrer des certificats ni à gérer ce modèle.';
$string['leftmargin'] = 'Marge gauche, mm';
$string['leftmargin_help'] = 'Ceci est la marge gauche du certificat PDF en mm.';
$string['linkedinorganizationid'] = 'Identifiant de l’organisation LinkedIn';
$string['linkedinorganizationid_desc'] = 'L’identifiant de l’organisation LinkedIn délivrant les certificats.

Où puis-je trouver l’identifiant de mon organisation LinkedIn ?

1. Connectez-vous à LinkedIn en tant qu’administrateur de page de votre organisation.
2. Vérifiez l’URL utilisée quand vous êtes connecté en tant qu’administrateur. (L’URL doit ressembler à « https://linkedin.com/company/xxxxxxx/admin »)
3. Votre identifiant d’organisation LinkedIn sera la numéro à sept chiffres dans l’URL (affichée comme « xxxxxxx » dans l’étape précédente)';
$string['manageelementplugins'] = 'Gérer les plugins d’élément de certificat';
$string['managetemplates'] = 'Gérer les modèles de certificat';
$string['messageprovider:certificateissued'] = 'Certificat reçu';
$string['milimeter'] = 'mm';
$string['mycertificates'] = 'Mes certificats';
$string['mycertificatesdescription'] = 'Il s’agit des certificats qui vous ont été délivrés soit par courrier électronique, soit par téléchargement manuel.';
$string['name'] = 'Nom';
$string['nametoolong'] = 'Vous avez dépassé la longueur maximale autorisée pour le nom.';
$string['never'] = 'Jamais';
$string['noimage'] = 'Pas d’image';
$string['noissueswerecreated'] = 'Aucun certificat n’a été délivré';
$string['nopermissionform'] = 'Vous n’êtes pas autorisé à accéder à ce formulaire.';
$string['notificationmsgcertificateissued'] = 'Bonjour {$a->fullname},<br /><br />Votre certificat est disponible ! Vous le trouverez ici :
<a href="{$a->url}">Mes certificats</a>';
$string['notificationsubjectcertificateissued'] = 'Votre certificat est disponible !';
$string['notverified'] = 'Non vérifié';
$string['numberofpages'] = 'Nombre de pages';
$string['oneissuewascreated'] = 'Un numéro a été créé';
$string['page'] = 'Page {$a}';
$string['pageheight'] = 'Hauteur de page, mm';
$string['pageheight_help'] = 'Ceci est la hauteur du certificat PDF en mm. Pour référence, un morceau de papier A4 mesure 297 mm de haut et une lettre mesure 279 mm de haut.';
$string['pagewidth'] = 'Largeur de page, mm';
$string['pagewidth_help'] = 'Ceci est la largeur du certificat PDF en mm. Pour référence, un morceau de papier A4 mesure 210 mm de large et une lettre, 216 mm de large.';
$string['pluginname'] = 'Gestionnaire de certificats';
$string['posx'] = 'Position X, mm';
$string['posx_help'] = 'Ceci est la position en mm du coin supérieur gauche que vous souhaitez voir positionner le point de référence de l’élément dans la direction x.';
$string['posy'] = 'Position Y, mm';
$string['posy_help'] = 'Ceci est la position en mm du coin supérieur gauche que vous souhaitez voir positionner le point de référence de l’élément dans la direction y.';
$string['privacy:metadata:tool_certificate:issues'] = 'La liste des certificats délivrés';
$string['privacy:metadata:tool_certificate_issues:code'] = 'Le code qui appartient au certificat';
$string['privacy:metadata:tool_certificate_issues:expires'] = 'L’horodatage de l’échéance du certificat. 0 si n’arrive pas à échéance.';
$string['privacy:metadata:tool_certificate_issues:templateid'] = 'L’identifiant du certificat';
$string['privacy:metadata:tool_certificate_issues:timecreated'] = 'L’heure où le certificat a été délivré';
$string['privacy:metadata:tool_certificate_issues:userid'] = 'L’identifiant de l’utilisateur qui a été délivré le certificat';
$string['reg_wpcertificates'] = 'Nombre de certificats ({$a})';
$string['reg_wpcertificatesissues'] = 'Nombre de certificats émis ({$a})';
$string['regenerate'] = 'Regénérer';
$string['regeneratefileconfirm'] = 'Voulez-vous vraiment regénérer le certificat émis pour cet utilisateur ?';
$string['regenerateissuefile'] = 'Regénéré le fichier émis';
$string['revoke'] = 'Révoquer';
$string['revokecertificateconfirm'] = 'Voulez-vous vraiment révoquer ce numéro de certificat de cet utilisateur ?';
$string['rightmargin'] = 'Marge droite, mm';
$string['rightmargin_help'] = 'Ceci est la marge droite du certificat PDF en mm.';
$string['selectdate'] = 'Sélectionner la date';
$string['selectuserstoissuecertificatefor'] = 'Sélectionner les utilisateurs auxquels décerner le certificat';
$string['shared'] = 'Partagé';
$string['shareonlinkedin'] = 'Partager sur LinkedIn';
$string['show_shareonlinkedin'] = 'Afficher le partage sur LinkedIn';
$string['show_shareonlinkedin_desc'] = 'Si le bouton « Partager sur LinkedIn » doit apparaître sur la page mes certificats';
$string['subplugintype_certificateelement_plural'] = 'Plugins de l’élément';
$string['timecreated'] = 'Moment créé';
$string['uploadimage'] = 'Charger une image';
$string['valid'] = 'Valide';
$string['validcertificate'] = 'Ce certificat est valide';
$string['verified'] = 'Vérifié';
$string['verify'] = 'Vérifier';
$string['verifycertificates'] = 'Vérifier les certificats';
$string['verifynotallowed'] = 'Vous n’êtes pas autorisé à vérifier les certificats.';
$string['viewcertificate'] = 'Visualiser le certificat';
