<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_capexplorer', language 'no', version '4.3'.
 *
 * @package     tool_capexplorer
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assigned'] = 'Tildelt';
$string['autoassign'] = 'Automatisk tildelt';
$string['autoassignment'] = 'Automatisk tildeling';
$string['autoassignment_help'] = 'Noen roller kan automatisk tildeles til brukere i systemkonteksten. Rollene kan angis via Portalen > Brukere > Tillatelser > Brukerprofiler';
$string['capability'] = 'Rettighet';
$string['capability_help'] = '<p>Velg en rettighet som skal sjekkes.</p><p>Dette feltet fylles automatisk ut, så begynn å skrive navnet på rettigheten og velg så fra listen med muligheter som dukker opp.</p>';
$string['capabilityplaceholder'] = 'Skriv inn en rettighet';
$string['capdenied'] = 'Falsk (Nektet)';
$string['capexplorer:view'] = 'Vis rettighetsutforsker';
$string['capexplorerresult'] = 'Samlet resultat';
$string['capexplorersummary'] = '<p>Rettighetsutforskeren er et verktøy for å hjelpe med å forklare hvordan rettighetssystemet i KS Læring virker. Fyll ut skjemaet nedenfor for å få en forklaring på hvordan rettighetssjekken beregnes.</p>';
$string['capgranted'] = 'Sann (Innvilget)';
$string['change'] = 'Endre';
$string['combineusingcontextaggregation'] = '<p>Kombiner de individuelle tillatelsene ved å bruke aggregeringsreglene for sammenhenger {$a} for å få et samlet sett for rollen.</p>';
$string['context'] = 'Kontekst';
$string['context_help'] = '<p>Du må oppgi en <em>kontekst forekomst</em> å sjekke rettigheten mot. Treet viser hierarkiet av alle kontekst forekomster i ditt nettsted.</p><p>Utvid noder ved å klikke på pilen for å se mer spesifikke underliggende kontekster. Velg en forekomst ved å klikke på navnet.</p><p>Ikonene representerer <em>kontekstnivået</em> til hver forekomst:</p><p><div class="capexplorer-tree-label capexplorer-tree-system">Systemkontekst (Portal)</div><div class="capexplorer-tree-label capexplorer-tree-user">Brukerkontekst</div><div class="capexplorer-tree-label capexplorer-tree-category">Kategorikontekst</div><div class="capexplorer-tree-label capexplorer-tree-course">Kurskontekst</div><div class="capexplorer-tree-label capexplorer-tree-module">Modulekontekst</div> <div class="capexplorer-tree-label capexplorer-tree-block">Blokkontekst</div> </p>';
$string['contextaggrrules'] = 'Aggregeringsregler for konteksten';
$string['contextaggrrules_help'] = 'Hvis du vil bestemme totalrettighetene for en bestemt rolle, samler du tillatelsene i hver kontekst ved hjelp av reglene nedenfor:</p> <ol> <li>Hvis "Forby" vises i en hvilken som helst sammenheng, er totalrettighetene "Forby".</li> <li>Hvis alle sammenhenger har tillatelsen "Ikke angitt", er totalrettighetene "Ikke angitt".</li> <li>Ellers er totalrettighetene det samme som den mest spesifikke tillatelsen som er angitt (dvs. tillatelsen eller forbudet som er nærmest konteksten der evnen blir kontrollert).</li> </ol>';
$string['contextinfo'] = '{$a->contextstring} ({$a->contextlevel} context)';
$string['contextlevel'] = 'Kontekstnivå';
$string['error:invalidcapability'] = 'Det er ingen rettighet som heter "{$a}"';
$string['error:invalidcontext'] = 'Du må velge en kontekst';
$string['error:invalidusername'] = 'Det er ingen bruker med brukernavn "{$a}"';
$string['error:missingcapability'] = 'Du må skrive inn en rettighet';
$string['error:missingusername'] = 'Du må skrive inn et brukernavn';
$string['exploreanother'] = '&laquo; Utforsk en annen rettighet';
$string['finalresultsummary'] = '<p>Til slutt, kombiner totalrettighetene ved å bruke roleaggregeringsreglene{$a} for å få det samlede resultatet.</p>';
$string['guestaccessblocked'] = '<p>Merk: Som en ekstra sikkerhetsforanstaltning forhindrer Moodle at ikke-priviligerte brukere blir gitt "risikable" rettigheter. "{$a->capability}" anses risikabel fordi den kan brukes til å redigere eller fjerne data, endre nettstedskonfigurasjon, eller legge til potensielt skadelige skript på nettsider. Resultatene nedenfor viser hvordan tilgangen ble beregnet hvis muligheten ikke ble vurdert risikabelt. </p>';
$string['instancename'] = 'Navn på forekomst';
$string['manualassign'] = 'Manuelt tildelt';
$string['manualassignment'] = 'Manuell tildeling';
$string['manualassignment_help'] = 'Roller tildelt direkte til en bestemt bruker, for eksempel via \'Tildel systemroller\', eller via kurspåmeldinger.';
$string['none'] = 'Ingen';
$string['nopermtoassign'] = 'Ikke tillatelse';
$string['nopermtoassign_help'] = '<p>Ikke alle brukere har tillatelse til å tildele roller til andre brukere. Rettigheten til å tildele roller avhenger av dine egne roller, og kan kontrolleres her:</p><p><em>Portalen &gt; Brukere &gt; Tillatelser &gt; Definer roller &gt; Tillat rolletildelinger</em></p><p>I tillegg må brukeren ha rettigheten "moodle/role:assign" i konteksten der rolletildelingen finner sted.</p><p>Portaladministratorer kan tildele alle roller.</p>';
$string['nopermtoautoassign'] = 'Ikke tillatelse';
$string['nopermtoautoassign_help'] = 'Ikke alle brukere har tillatelse til å endre automatisk tildelte roller. Rettigheten til å endre / angi disse brukerprofilene kontrolleres av rettigheten "moodle/site:config" i systemkonteksten (portal).';
$string['nopermtodefinerole'] = 'Ikke tillatelse';
$string['nopermtodefinerole_help'] = 'Rettigheten til å definere rolletillatelser krever rettigheten "moodle/role:manage" i systemkonteksten. Brukere med tillatelse kan kontrollere definisjonene her:</p><p><em>Portalen &gt; Brukere &gt; Tillatelser &gt; Definer roller</p><p>Gjeldende bruker har ikke denne tillatelsen, og kan dermed ikke endre rolledefinisjoner.</p>';
$string['nopermtooverride'] = 'Ikke tillatelse';
$string['nopermtooverride_help'] = 'Ikke alle brukere har tillatelse til å overstyre roller. Rettigheten til å overstyre roller avhenger av dine egne roller og kan kontrolleres her:</p><p><em>Portalen &gt; Brukere &gt; Tillatelser &gt; Definer roller &gt; Tillatt overstyring av roller</em></p><p>I tillegg må brukeren ha rettigheten "moodle/role:override" eller "moodle/role:safeoverride" i konteksten der overstyring finner sted.</p><p>Portaladministratorer kan overstyre alle roller.</p>';
$string['notassignable'] = 'Kan ikke tildeles';
$string['notassignable_help'] = '<p>Hver rolle definerer kontekstnivåene der rollen kan tildeles.</p><p>Dette kan tilpasses ved å endre "Konteksttyper der denne rollen kan tildeles"-innstillingen i rolledefinisjonen:</p><p><em>Portalen &gt; Brukere &gt; Tillatelser &gt; Definer roller &gt; [Rollenavn] &gt; Endre</em>.</p>';
$string['notassigned'] = 'Ikke tildelt';
$string['notoverridable'] = 'Ikke tillatt å overstyre';
$string['notoverridable_help'] = '<p>Hver rettighet definerer et kontekstnivå som er det laveste nivået hvor konteksten vil sjekkes. Nedenfor dette nivået er det ikke anledning til å overstyre rettigheten siden overstyring ikke vil ha noen effekt.</p><p>Dette forhindrer rettigheter som opplagt ikke kan angis på mer spesifikke kontekster fra å fylle opp overstyringssiden.</p><p>I dette tilfellet har rettigheten som sjekkes angitt et høyere kontekstnivå, så det er ikke mulig å overstyre rettigheten på dette nivået.</p>';
$string['overallresult'] = 'Samlet resultat';
$string['parentcontexts'] = 'Overordnede kontekster';
$string['parentcontexts_help'] = '<p>På grunn av den hierarkiske naturen til rettighetssystemet kan oppgaver i en hvilken som helst overordnet kontekst påvirke en rettighetskontroll i en underkontekst. Derfor er det første trinnet å bestemme alle sammenhenger mellom systemnivå og konteksten som kontrolleres.';
$string['parentcontextssummary'] = '<p>Bestem alle kontekstnivåer mellom systemnivå og konteksten som blir kontrollert.</p>';
$string['permission'] = 'Rettighet';
$string['permissionallow'] = 'Tillat';
$string['permissioninherit'] = 'Arve';
$string['permissionnotset'] = 'Ikke angitt';
$string['permissionprevent'] = 'Forhindre';
$string['permissionprohibit'] = 'Forby';
$string['permissionunknown'] = 'Ukjent';
$string['pluginname'] = 'Rettighetsutforsker';
$string['result'] = 'Resultat';
$string['resultdiffersfromaccesslib'] = '<p>Resultatet kalkulert av dette verktøyet stemmer ikke med resultatet fra kjernekoden!</p><p>Du kan prøve <a href="{$a->cacheurl}">å slette mellomlageret ditt</a> men hvis ikke det hjelper der det antakelig en feil i Capability Explorer / Rettighetsutforsker. Vennligst <a href="{$a->bugurl}">gi oss beskjed</a> og det er fint om du kan inkludere et skjermbilde av denne siden for å hjelpe oss å spore opp problemet.</p>';
$string['role'] = 'Rolle';
$string['roleaggrrules'] = 'Rolleaggregeringsregler';
$string['roleaggrrules_help'] = '<p>For å bestemme det samlede resultatet, aggreger tillatelsene fra alle totale rollerettigheter ved å bruke reglene nedenfor:</p> <ol> <li>Hvis "Forby" dukker opp i en rolleoppsummering, så er det samlede resultat "Nektet".</li> <li>Ellers, hvis en rolleoppsummering er "Tillat", så er det samlede resultat "Innvilget".</li> <li>Hvis ingen av rolleoppsummeringene er "Tillat", så er det samlede resultat "Nektet".</li> </ol>';
$string['roleassignmentsforuserx'] = '<p>Nedenfor er alle roller som har tildelinger for "{$a}" i kontekstene listet nedenfor:</p>';
$string['roleassignmentsummary'] = '<p>Bestem hvilke roller som tildeles brukeren i noen av de overordnede kontekstene. Bare roller tildelt i en av de overordnede kontekstene bidrar til det endelige resultatet.</p>';
$string['rolepermissionsandoverridesforcapx'] = '<p>Alle rolletillatelser og overstyringer for rettighet "{$a}"</p>';
$string['rolepermissionsummary'] = '<p>For hver tildelte rolle, vis tillatelsen fra rolledefinisjonen for systemkonteksten. Vis også enhver rolleoverstyring i enhver overordnet kontekst.</p>';
$string['roletotal'] = 'Rollen samlet';
$string['roletotals'] = 'Rollene samlet';
$string['step1'] = 'Steg 1: Overordnede kontekster';
$string['step2'] = 'Steg 2: Rolletildelinger';
$string['step3'] = 'Steg 3: Rolletillatelser og -overstyringer';
$string['step4'] = 'Steg 4: Aggreger over kontekster';
$string['step5'] = 'Steg 5: Aggreger over roller';
$string['systemcontext'] = 'Systemkontekst (Portalen)';
$string['user'] = 'Bruker';
$string['usercontext'] = 'Brukerkontekst';
$string['userisadmin'] = '<p>Merknad: "{$a->user}" er en <a href="{$a->url}">portaladministrator</a>, og disse er automatisk tildelt alle rettigheter. Resultatene nedenfor viser hvordan tilgangen deres ville vært beregnet uten administratortilgang.</p>';
$string['username'] = 'Brukernavn';
$string['username_help'] = '<p>Velg en bruker som skal sjekkes.</p><p>Dette feltet fylles ut automatisk, så begynn å skrive et brukernavn, e-postadresse eller navnet til en bruker og velg fra mulighetene som vises.</p>';
$string['usernameplaceholder'] = 'Skriv navn, brukernavn eller e-post';
$string['xfrontpage'] = '{$a} (Forsiden)';
