<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'da', version '4.3'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'Lukker for vurdering:';
$string['activitydate:assessmentsclosed'] = 'Lukkede for vurdering:';
$string['activitydate:assessmentsopen'] = 'Åben for vurdering:';
$string['activitydate:assessmentsopened'] = 'Åbnede for vurdering:';
$string['activitydate:submissionsclose'] = 'Lukker for aflevering:';
$string['activitydate:submissionsclosed'] = 'Lukkede for aflevering:';
$string['activitydate:submissionsopen'] = 'Åben for aflevering:';
$string['activitydate:submissionsopened'] = 'Åbnede for aflevering:';
$string['aggregategrades'] = 'Genberegn karakterer';
$string['aggregation'] = 'Karaktersammentælling';
$string['allocate'] = 'Tildel afleverede opgaver';
$string['allocatedetails'] = 'forventet: {$a->expected}<br />afleveret: {$a->submitted}<br />til fordeling: {$a->allocate}';
$string['allocation'] = 'Fordeling af afleverede opgaver';
$string['allocationconfigured'] = 'Tildeling konfigureret';
$string['allocationdone'] = 'Fordeling klar';
$string['allocationerror'] = 'Fordelingsfejl';
$string['allowedfiletypesforoverallfeedback'] = 'Tilladte filtyper som bilag til feedback';
$string['allowedfiletypesforoverallfeedback_help'] = 'Filtyper på bilag til feedback kan begrænses af en liste med tilladte filtyper. Lades feltet stå tomt, tillades alle filtyper.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'Tilladte filtyper som bilag til opgaveafleveringer';
$string['allowedfiletypesforsubmission_help'] = 'Filtyper på bilag til afleveringer kan begrænses af en liste med tilladte filtyper. Lades feltet stå tomt, tillades alle filtyper.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'Alle afleveringer({$a})';
$string['alreadygraded'] = 'Allerede vurderet';
$string['areaconclusion'] = 'Konklusion';
$string['areainstructauthors'] = 'Instruktioner for aflevering';
$string['areainstructreviewers'] = 'Instruktioner for vurdering';
$string['areaoverallfeedbackattachment'] = 'Samlede feedbackbilag';
$string['areaoverallfeedbackcontent'] = 'Samlede feedbacktekster';
$string['areasubmissionattachment'] = 'Opgavebilag';
$string['areasubmissioncontent'] = 'Opgavetekster';
$string['assess'] = 'Vurder';
$string['assessedexample'] = 'Vurderet opgaveeksempel';
$string['assessedsubmission'] = 'Bedømt aflevering';
$string['assessingexample'] = 'Vurderer opgaveeksempel';
$string['assessingsubmission'] = 'Vurderer opgave';
$string['assessment'] = 'Vurdering';
$string['assessmentby'] = 'af <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Vurdering af {$a}';
$string['assessmentbyyourself'] = 'Din vurdering';
$string['assessmentdeleted'] = 'Tildelte vurderinger annulleret';
$string['assessmentend'] = 'Deadline for vurdering';
$string['assessmentendbeforestart'] = 'Deadline for vurdering kan ikke specificeres før åbningsdagen';
$string['assessmentenddatetime'] = 'Vurderingsfrist: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} vurderingsdeadline';
$string['assessmentform'] = 'Vurderingsformular';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">Vurdering</a> af <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'Referencevurdering';
$string['assessmentreferenceconflict'] = 'Det er ikke muligt at tilgå et eksempel på opgavebesvarelse for hvilken du gav en referencevurdering.';
$string['assessmentreferenceneeded'] = 'Du må vurdere dette opgaveeksempel for at etablere en referencevurdering. Klik på "Fortsæt" for at vurdere denne opgave.';
$string['assessments'] = 'Vurderinger';
$string['assessmentsettings'] = 'Vurderingsindstillinger';
$string['assessmentstart'] = 'Åben for vurdering fra';
$string['assessmentstartdatetime'] = 'Åben for vurdering fra {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} åbner for vurdering';
$string['assessmentweight'] = 'Vurderingsvægtning';
$string['assignedassessments'] = 'Tildelte opgaver at vurdere';
$string['assignedassessmentsnone'] = 'Du har ingen tildelt aflevering at vurdere';
$string['backtoeditform'] = 'Tilbage til redigeringsformularen';
$string['byfullname'] = 'af <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'af {$a}';
$string['calculategradinggrades'] = 'Beregn vurderingskarakterer';
$string['calculategradinggradesdetails'] = 'forventet: {$a->expected}<br />beregnet: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Beregn opgavekarakterer';
$string['calculatesubmissiongradesdetails'] = 'forventet: {$a->expected}<br />beregnet: {$a->calculated}';
$string['chooseuser'] = 'Vælg bruger...';
$string['clearaggregatedgrades'] = 'Slet sammentalte karakterer';
$string['clearaggregatedgrades_help'] = 'De sammenlagte karakterer for opgave og vurdering vil blive nulstillet. Du kan genberegne karaktererne forfra i vurderingsfasen.';
$string['clearaggregatedgradesconfirm'] = 'Er du sikker på at du vil slette alle beregnede karakterer for opgaver og vurderingskarakterer?';
$string['clearassessments'] = 'Slet vurderinger';
$string['clearassessments_help'] = 'Beregnede karakterer for opgaver og vurderingskarakterer vil blive nulstillet. Oplysninger om hvordan vurderingsformularen er udfyldt bevares, men deltagere der skal vurdere, skal genåbne vurderingssiden og gemme igen for at karaktererne kan blive genberegnet.';
$string['clearassessmentsconfirm'] = 'Er du sikker på at du vil slette alle vurderingskarakterer?  Du vil ikke selv kunne hente informationerne frem igen og alle opgaverne må vurderes på ny.';
$string['conclusion'] = 'Konklusion';
$string['conclusion_help'] = 'Konklusionen vises til deltagerne til slut i aktiviteten.';
$string['configexamplesmode'] = 'Standardtilstand for eksempler på vurdering i workshop';
$string['configgrade'] = 'Standard maksimumskarakter for opgaver i workshops';
$string['configgradedecimals'] = 'Standard antal decimaler til visning af karakterer.';
$string['configgradinggrade'] = 'Standard maksimumskarakter for vurderinger i workshops';
$string['configmaxbytes'] = 'Standard maksimumsstørrelse på vedhæftede filer i opgaver i alle workshops på sitet (afhænger også af kursus- og andre lokale indstillinger).';
$string['configstrategy'] = 'Standard karaktergivningsstrategi for workshops';
$string['createsubmission'] = 'Tilføj en aflevering';
$string['crontask'] = 'Baggrundsbehandling af workshop-modulet';
$string['daysago'] = '{$a} dage siden';
$string['daysleft'] = '{$a} dage tilbage';
$string['daystoday'] = 'i dag';
$string['daystomorrow'] = 'i morgen';
$string['daysyesterday'] = 'i går';
$string['deadlinesignored'] = 'Tidsbegrænsninger gælder ikke dig';
$string['deletesubmission'] = 'Slet afleveringen';
$string['editassessmentform'] = 'Rediger vurderingsformular';
$string['editassessmentformstrategy'] = 'Rediger vurderingsformular ({$a})';
$string['editingassessmentform'] = 'Redigerer vurderingsformular';
$string['editingsubmission'] = 'Redigerer aflevering';
$string['editsubmission'] = 'Rediger opgavebesvarelse';
$string['err_multiplesubmissions'] = 'Mens du har redigeret denne formular, er en anden version af opgaven afleveret.  Flere opgaver pr. deltager er ikke tilladt.';
$string['err_removegrademappings'] = 'Kan ikke fjerne ubrugte karaktertilknytninger';
$string['evaluategradeswait'] = 'Vent indtil vurderinger er evalueret og karakterer beregnet';
$string['evaluation'] = 'Bedømmelsesevaluering';
$string['evaluationmethod'] = 'Metode til evaluering af bedømmelse';
$string['evaluationmethod_help'] = 'Bedømmelsesevalueringsmetoden styrer hvordan karakteren for en vurdering beregnes. Du kan lade den genberegne karakterer gentagne gange med forskellige indstillinger med mindre du er tilfreds med resultatet.';
$string['evaluationsettings'] = 'Indstillinger for bedømmelsesevaluering';
$string['eventassessableuploaded'] = 'En opgavebesvarelse er blevet uploadet.';
$string['eventassessmentevaluated'] = 'Vurdering evalueret';
$string['eventassessmentevaluationsreset'] = 'Vurderingsevalueringer nulstillet';
$string['eventassessmentreevaluated'] = 'Vurdering genevalueret';
$string['eventphaseswitched'] = 'Fase skiftet';
$string['eventsubmissionassessed'] = 'Opgave vurderet';
$string['eventsubmissionassessmentsreset'] = 'Opgavevurderinger ryddet';
$string['eventsubmissioncreated'] = 'Opgavebesvarelse oprettet';
$string['eventsubmissiondeleted'] = 'Aflevering slettet';
$string['eventsubmissionreassessed'] = 'Opgavebesvarelse revurderet';
$string['eventsubmissionupdated'] = 'Opgavebesvarelse opdateret';
$string['eventsubmissionviewed'] = 'Opgavebesvarelse set';
$string['example'] = 'Opgaveeksempel';
$string['exampleadd'] = 'Tilføj eksempel på en opgave';
$string['exampleassess'] = 'Vurder opgaveeksempel';
$string['exampleassessments'] = 'Opgaveeksempler til vurdering';
$string['exampleassesstask'] = 'Vurder eksempler';
$string['exampleassesstaskdetails'] = 'forventet: {$a->expected}<br />vurderet: {$a->assessed}';
$string['examplecomparing'] = 'Sammenligner vurderinger af opgaveeksempler';
$string['exampledelete'] = 'Slet eksempel';
$string['exampledeleteconfirm'] = 'Er du sikker på at du vil slette følgende opgaveeksempel? Klik på "Fortsæt"-knappen for at slette opgaven.';
$string['exampleedit'] = 'Rediger eksempel';
$string['exampleediting'] = 'Redigerer eksempel';
$string['exampleneedassessed'] = 'Du må vurdere alle opgaveeksemplerne først.';
$string['exampleneedsubmission'] = 'Du skal først aflevere dit arbejde og vurdere alle opgaveeksempler.';
$string['examplesbeforeassessment'] = 'Eksempler er tilgængelige efter at du selv har afleveret din egen opgave og du kan vurdere andres opgaver når du har vurderet opgaveeksemplerne.';
$string['examplesbeforesubmission'] = 'Eksempler må vurderes før du kan aflevere selv';
$string['examplesmode'] = 'Tilstand af eksempelvurderinger';
$string['examplesubmissions'] = 'Eksempel på afleveringer';
$string['examplesvoluntary'] = 'Vurdering af opgaveeksempel er frivillig';
$string['exportsubmission'] = 'Eksporter denne side';
$string['feedbackauthor'] = 'Feedback til besvarelsen';
$string['feedbackauthorattachment'] = 'Bilag';
$string['feedbackby'] = 'Feedback af {$a}';
$string['feedbackreviewer'] = 'Tilbagemelding fra den der vurderer';
$string['feedbacksettings'] = 'Feedback';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Karaktertildelinger';
$string['grade_grading_name'] = 'Vurdering';
$string['grade_submission_name'] = 'Aflevering';
$string['gradecalculated'] = 'Beregnet karakter for opgave';
$string['gradedecimals'] = 'Decimaler i karakterer';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Karakter: {$a->received} af {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (vurdering)';
$string['gradeitemsubmission'] = '{$a->workshopname} (opgavebesvarelse)';
$string['gradeover'] = 'Tilsidesæt karakter for opgave';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Karakterrapport for workshop';
$string['gradetopassgrading'] = 'Vurderingskarakter for bestået';
$string['gradetopasssubmission'] = 'Opgavekarakter for bestået';
$string['gradinggrade'] = 'Karakter for vurdering';
$string['gradinggrade_help'] = 'Denne indstilling angiver den maksimale karakter, der kan opnås i vurdering af en opgave.';
$string['gradinggradecalculated'] = 'Beregnet karakter for vurdering';
$string['gradinggradeof'] = 'Karakter for vurdering (af {$a})';
$string['gradinggradeover'] = 'Tilsidesæt karakter for vurdering';
$string['gradingsettings'] = 'Karakterindstillinger';
$string['groupnoallowed'] = 'Du har ikke tilladelse til at tilgå grupper i denne workshop';
$string['iamsure'] = 'Ja, jeg er sikker';
$string['indicator:cognitivedepth'] = 'Læringsworkshop';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Social Workshop';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Info';
$string['instructauthors'] = 'Instruktioner til opgave';
$string['instructreviewers'] = 'Instruktioner til vurdering';
$string['introduction'] = 'Beskrivelse';
$string['latesubmissions'] = 'For sene afleveringer';
$string['latesubmissions_desc'] = 'Tillad for sene afleveringer';
$string['latesubmissions_help'] = 'Hvis indstillingen er aktiveret, kan en opgave afleveres efter overskridelse af afleveringsfristen eller i løbet af vurderingsfasen. For sene afleveringer kan dog ikke ændres.';
$string['latesubmissionsallowed'] = 'For sene afleveringer accepteres';
$string['maxbytes'] = 'Maksimal filstørrelse på bilag';
$string['modulename'] = 'Workshop';
$string['modulename_help'] = 'Workshopmodulet muliggør indsamling, gennemgang og sidemandsevaluering af studerendes arbejde.

Studerende kan aflevere digitalt indhold (filer), såsom tekstbehandlingsdokumenter eller regneark, eller kan skrive tekst direkte i et felt ved hjælp af tekst-editoren.

Indlæg vurderes ved hjælp af et vurderingsskema med flere kriterier defineret af læreren. Processen med sidemandsevaluering og forståelse af evalueringsformularen kan praktiseres på forhånd f.eks. med opgavebesvarelser leveret af læreren, sammen med et eksempel på en vurdering. De studerende får mulighed for at vurdere en eller flere af de andres besvarelser. De studerende kan eventuelt være anonyme.

De studerende får to karakterer i en workshop - en karakter for deres opgavebesvarelse og en karakter for deres vurdering af deres medstuderendes opgaver. Begge karakterer registreres i karakterbogen.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'Workshopper';
$string['myassessments'] = 'Mine vurderinger';
$string['mysubmission'] = 'Min opgave';
$string['nattachments'] = 'Maksimum antal opgavebilag';
$string['noexamples'] = 'Ingen eksempler i denne workshop endnu';
$string['noexamplesformready'] = 'Du skal oprette evalueringsskemaet, før du kan give opgaveeksempler.';
$string['nogradeyet'] = 'Ingen vurderinger endnu';
$string['nosubmissionfound'] = 'Ingen afleveringer fundet fra denne bruger';
$string['nosubmissions'] = 'Der er endnu ingen afleveringer i denne workshop';
$string['nosubmissiontype'] = 'Der skal være mindst en afleveringstype tilgængelig';
$string['notassessed'] = 'Endnu ikke vurderet';
$string['nothingfound'] = 'Intet at vise';
$string['nothingtoreview'] = 'Ingenting at vise';
$string['notoverridden'] = 'Ikke tilsidesat';
$string['noworkshops'] = 'Det er ingen workshops på dette kursus';
$string['noyoursubmission'] = 'Du har ikke afleveret din opgave endnu';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Samlet feedback';
$string['overallfeedbackfiles'] = 'Højeste antal bilag til samlet feedback';
$string['overallfeedbackmaxbytes'] = 'Maksimal filstørrelse på bilag til samlet feedback';
$string['overallfeedbackmode'] = 'Samlet feedback-tilstand';
$string['overallfeedbackmode_0'] = 'Deaktiveret';
$string['overallfeedbackmode_1'] = 'Aktiveret og valgfri';
$string['overallfeedbackmode_2'] = 'Aktiveret og obligatorisk';
$string['overallfeedbackmode_help'] = 'Er indstillingen aktiveret, vises et tekstfelt i bunden af vurderingsformularen. Dem der vurderer, kan skrive deres generelle vurdering her eller give ekstra forklaring på deres vurdering.';
$string['page-mod-workshop-x'] = 'Enhver workshopside';
$string['participant'] = 'Deltager';
$string['participantrevierof'] = 'Deltageren vurderer';
$string['participantreviewedby'] = 'Deltageren vurderes af';
$string['phaseassessment'] = 'Vurderingsfase';
$string['phaseclosed'] = 'Lukket';
$string['phaseevaluation'] = 'Karakterevalueringsfase';
$string['phasesetup'] = 'Opsætningsfase';
$string['phasesoverlap'] = 'Besvarelsesfasen og vurderingsfasen kan ikke overlappe';
$string['phasesubmission'] = 'Besvarelsesfase';
$string['pluginadministration'] = 'Workshopadministration';
$string['pluginname'] = 'Workshop';
$string['prepareexamples'] = 'Forbered opgaveeksempler';
$string['previewassessmentform'] = 'Forhåndsvisning';
$string['privacy:metadata:assessmentid'] = 'Opgavens ID';
$string['privacy:metadata:submissioncontent'] = 'Indholdet af opgaven';
$string['privacy:metadata:submissioncontentformat'] = 'Tekstformat på indholdet af besvarelsen';
$string['privacy:metadata:submissiontitle'] = 'Opgavens titel';
$string['privacy:metadata:workshopgrades'] = 'Viser information om hvordan opgaveformularer blev udfyldt med karakterer og kommentarer';
$string['privacy:metadata:workshopid'] = 'Aktivitetens ID';
$string['privacy:metadata:workshopsubmissions'] = 'Viser information om modulets afleveringer';
$string['privacy:request:delete:content'] = 'Indholdet er slettet (efter anmodning fra brugeren eller det er er udløbet).';
$string['privacy:request:delete:title'] = '[Slettet]';
$string['publishedsubmissions'] = 'Publicerede opgaver';
$string['publishsubmission'] = 'Publicer opgave';
$string['publishsubmission_help'] = 'Publicerede opgaver er tilgængelige for andre efter workshoppen er lukket.';
$string['reassess'] = 'Revurder';
$string['receivedgrades'] = 'Karakterer modtaget';
$string['recentassessments'] = 'Workshop-vurderinger:';
$string['recentsubmissions'] = 'Workshop-opgaver:';
$string['resetassessments'] = 'Slet alle vurderinger';
$string['resetassessments_help'] = 'Du kan vælge at slette netop tildelte vurderinger uden at påvirke opgavebesvarelser. Slettes opgavebesvarelser vil deres vurderinger også slettes og denne mulighed ignoreres. Bemærk at dette også omfatter vurderinger af eksempelafleveringer.';
$string['resetphase'] = 'Skift til opsætningsfase';
$string['resetphase_help'] = 'Er indstillingen aktiveret, vil alle workshopper sættes til den indledende opsætningsfase.';
$string['resetsubmissions'] = 'Slet alle opgavebesvarelser';
$string['resetsubmissions_help'] = 'Alle opgavebesvarelser og deres vurderinger vil blive slettet. Dette påvirker ikke eksempelafleveringer.';
$string['saveandclose'] = 'Gem og luk';
$string['saveandcontinue'] = 'Gem og fortsæt redigering';
$string['saveandpreview'] = 'Gem og forhåndsvis';
$string['saveandshownext'] = 'Gem og vis den næste';
$string['search:activity'] = 'Workshop - aktivitetsinformation';
$string['selfassessmentdisabled'] = 'Selvvurdering deaktiveret';
$string['showingperpage'] = 'Viser {$a} enheder per side';
$string['showingperpagechange'] = 'Skift...';
$string['someuserswosubmission'] = 'Der er mindst en deltager som ikke har har afleveret sin opgave endnu';
$string['sortasc'] = 'Stigende orden';
$string['sortdesc'] = 'Faldende orden';
$string['strategy'] = 'Karaktergivningsstrategi';
$string['strategy_help'] = 'Karaktergivningsstrategien styrer den anvendte vurderingsformular og metoden til karaktergivninig af opgavebesvarelser. Der er 4 muligheder:

* Akkumulerede karakterer - Kommentarer og en karakterer gives ud fra visse aspekter
* Kommentarer - Kommentarer gives på visse aspekter, men der gives ingen karakter
* Antal fejl - Kommentarer og en ja/nej vurdering gives vedrørende bestemte udsagn
* Rubrik - En niveaubaseret vurdering gives ud fra bestemte kriterier';
$string['strategyhaschanged'] = 'Workshoppens karaktergivningsstrategi er ændret efter formularen blev åbnet for redigering.';
$string['submission'] = 'Aflevering';
$string['submissionattachment'] = 'Bilag';
$string['submissionby'] = 'Opgave af {$a}';
$string['submissioncontent'] = 'Opgaveindhold';
$string['submissiondeleteconfirm'] = 'Er du sikker på at du vil slette den følgende opgavebesvarelse?';
$string['submissiondeleteconfirmassess'] = 'Er du sikker på at du vil slette den følgende opgavebesvarelse? Bemærk at det også vil slette {$a->count} vurderinger af denne besvarelse og kan dermed påvirke karakterer til den der har vurderet opgaven.';
$string['submissionend'] = 'Afleveringsfrist';
$string['submissionendbeforestart'] = 'Afleveringsfristen kan ikke lægges før åbning for afleveringer';
$string['submissionenddatetime'] = 'Afleveringsfrist: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} afleveringsfrist';
$string['submissionendswitch'] = 'Skift til den næste fase efter afleveringsfristen er udløbet';
$string['submissionendswitch_help'] = 'Hvis en afleveringsfrist er specificeret og denne boks afkrydset, vil workshoppen automatisk skifte til vurderingsfase efter afleveringsfristen.

Aktiverer du denne funktion, anbefales det også at opsætte planlagt tildelingsmetode. Hvis afleveringer ikke tildeles, vil ingen vurdering kunne ske selv hvis workshoppen er i vurderingsfasen.';
$string['submissiongrade'] = 'Opgavekarakter';
$string['submissiongrade_help'] = 'Denne indstilling angiver den højeste karakter der kan opnås for opgaven.';
$string['submissiongradeof'] = 'Karakter for opgave (af {$a})';
$string['submissionlastmodified'] = 'Senest ændret';
$string['submissionrequiredcontent'] = 'Du skal skrive noget tekst eller tilføje en fil.';
$string['submissionrequiredfile'] = 'Du skal tilføje en fil eller skrive noget tekst.';
$string['submissionsettings'] = 'Indstillinger for opgaveaflevering';
$string['submissionsreport'] = 'Rapport over opgavebesvarelser';
$string['submissionstart'] = 'Åben for afleveringer fra';
$string['submissionstartdatetime'] = 'Åben for afleveringer fra {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} åbner for afleveringer';
$string['submissiontitle'] = 'Titel';
$string['submissiontypedisabled'] = 'Denne opgavetype er deaktiveret';
$string['submissiontypefileavailable'] = 'Bilag<span class="accesshide"> tilgængelig</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">Filvedhæftning </span>Påkrævet';
$string['submissiontypes'] = 'Opgavetyper';
$string['submissiontypetextavailable'] = 'Online tekst<span class="accesshide"> available</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">Online tekst </span>Påkrævet';
$string['submittednotsubmitted'] = 'Afleveret ({$a->submitted}) / ikke afleveret ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Metode til tildeling af opgavebesvarelser';
$string['subplugintype_workshopallocation_plural'] = 'Metoder til tildeling af opgavebesvarelser';
$string['subplugintype_workshopeval'] = 'Metode til evaluering af bedømmelse';
$string['subplugintype_workshopeval_plural'] = 'Metoder til evaluering af bedømmelser';
$string['subplugintype_workshopform'] = 'Karaktergivningsstrategi';
$string['subplugintype_workshopform_plural'] = 'Bedømmelsesstrategier';
$string['switchingphase'] = 'Skifter fase';
$string['switchphase'] = 'Skift fase';
$string['switchphase10'] = 'Skift til opsætningsfasen';
$string['switchphase10info'] = 'Du er ved at skifte til <strong>Opsætningsfasen</strong>. I denne fase kan brugere ikke ændre deres opgavebesvarelser eller deres vurderinger. Lærere kan bruge denne fase til at ændre workshopindstillingerne, ændre karaktergivningsstrategi eller ændre vurderingsformularer.';
$string['switchphase20'] = 'Skift til besvarelsesfasen';
$string['switchphase20info'] = 'Du er ved at ændre fase til <strong>Besvarelsesfasen</strong>. I denne fase kan studenterende aflevere opgaver (evt. indenfor fastsatte datoer). Lærere kan fordele opgaver mellem medstuderende til vurdering.';
$string['switchphase30'] = 'Skift til vurderingsfasen';
$string['switchphase30auto'] = 'Workshoppen vil automatisk skifte til vurderingsfasen efter {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'Du er ved at ændre fase til <strong>Vurderingsfasen</strong>. I denne fase kan medstuderende vurdere tildelte opgaver (indenfor evt. fastsatte datoer).';
$string['switchphase40'] = 'Skift til evalueringsfasen';
$string['switchphase40info'] = 'Du er ved at ændre fase til <strong>Karakterevaluerings-fasen</strong>. I denne fase kan opgaver eller vurderinger ikke ændres. Lærere kan bruge karakterevaluerings-værktøjerne til at beregne den endelige karakter og give tilbagemelding til den, der har vurderet opgaverne.';
$string['switchphase50'] = 'Luk workshoppen';
$string['switchphase50info'] = 'Du er ved at lukke workshoppen. Dermed vil beregnede karakterer overføres til karakterbogen. Studerende kan se egne opgaver og de karakterer, de har fået.';
$string['switchphaseauto'] = 'Faseskift er planlagt';
$string['switchphasenext'] = 'Skift til næste fase';
$string['taskassesspeers'] = 'Vurder medstuderende';
$string['taskassesspeersdetails'] = 'totalt: {$a->total}<br />afventende: {$a->todo}';
$string['taskassessself'] = 'Vurder dig selv';
$string['taskconclusion'] = 'Giv en konklusion på aktiviteten';
$string['taskdone'] = 'Opgave færdig';
$string['taskfail'] = 'Opgave ikke færdig';
$string['taskinfo'] = 'Opgaveinfo';
$string['taskinstructauthors'] = 'Angiv instruktion for opgavebesvarelse';
$string['taskinstructreviewers'] = 'Angiv instruktion for vurdering';
$string['taskintro'] = 'Opret workshop-beskrivelsen';
$string['tasksubmit'] = 'Aflever din opgave';
$string['tasktodo'] = 'Opgave til behandling';
$string['toolbox'] = 'Workshop-værktøjskasse';
$string['undersetup'] = 'Workshoppen er ved at blive sat op. Vent til den er skiftet til næste fase.';
$string['useexamples'] = 'Brug eksempler';
$string['useexamples_desc'] = 'Opgaveeksemplerne er til øvelse i vurdering af opgaver';
$string['useexamples_help'] = 'Hvis indstillingen er aktiveret, kan deltagerne prøve at vurdere en eller flere opgaveeksempler og sammenligne vurderingen med en referencevurdering. Karakteren tæller ikke med i den egentlige vurderingskarakter.';
$string['usepeerassessment'] = 'Brug vurdering medstuderende imellem';
$string['usepeerassessment_desc'] = 'Studerende kan vurdere hinandens opgaver';
$string['usepeerassessment_help'] = 'Hvis indstillingen er aktiveret, kan de studerende få tildelt hinandens opgaver til vurdering og vil modtage en karakter for vurderingen oveni karakteren for egen opgave.';
$string['userdatecreated'] = 'afleveret <span>{$a}</span>';
$string['userdatemodified'] = 'ændret <span>{$a}</span>';
$string['userplan'] = 'Workshopplanlægger';
$string['userplan_help'] = 'Workshopplanlæggeren viser alle faser af aktiviteten og en liste over opgaver i hver fase. Den nuværende fase er fremhævet og afsluttede opgaver markeret.';
$string['userplanaccessibilityskip'] = 'Spring til aktuelle opgaver';
$string['userplanaccessibilitytitle'] = 'Workshop-tidsplan med {$a} faser';
$string['userplancurrentphase'] = 'Aktuelle fase';
$string['useselfassessment'] = 'Brug selvvurdering';
$string['useselfassessment_desc'] = 'Studerende kan vurdere egne opgaver';
$string['useselfassessment_help'] = 'Hvis indstillingen er aktiveret kan studerende få tildelt egen opgave til vurdering og vil modtage en karakter for vurderingen oveni karakteren for egen opgave.';
$string['viewworkshopsummary'] = 'Vis workshop-beskrivelse';
$string['weightinfo'] = 'Vægtning: {$a}';
$string['withoutsubmission'] = 'Medstuderende uden egen opgaveaflevering';
$string['workshop:addinstance'] = 'Tilføj en ny workshop';
$string['workshop:allocate'] = 'Fordel opgaver til vurdering';
$string['workshop:deletesubmissions'] = 'Slet opgavebesvarelser';
$string['workshop:editdimensions'] = 'Rediger vurderingsformular';
$string['workshop:exportsubmissions'] = 'Eksporter besvarelser';
$string['workshop:ignoredeadlines'] = 'Ignorer tidsbegrænsninger';
$string['workshop:manageexamples'] = 'Administrer opgaveeksempler';
$string['workshop:overridegrades'] = 'Tilsidesæt beregnede karakterer';
$string['workshop:peerassess'] = 'Medstuderendes indbyrdes vurdering';
$string['workshop:publishsubmissions'] = 'Publicer opgaver';
$string['workshop:submit'] = 'Aflever';
$string['workshop:switchphase'] = 'Skift fase';
$string['workshop:view'] = 'Vis workshop';
$string['workshop:viewallassessments'] = 'Vis alle vurderinger';
$string['workshop:viewallsubmissions'] = 'Vis alle afleveringer';
$string['workshop:viewauthornames'] = 'Vis forfatternavn';
$string['workshop:viewauthorpublished'] = 'Vis forfattere af publicerede opgaver';
$string['workshop:viewpublishedsubmissions'] = 'Vis publicerede opgaver';
$string['workshop:viewreviewernames'] = 'Vis navne på de vurderende';
$string['workshopname'] = 'Workshop-navn';
$string['yourassessmentfor'] = 'Din vurdering for {$a}';
$string['yourgrades'] = 'Dine karakterer';
$string['yoursubmission'] = 'Din aflevering';
$string['yoursubmissionwithassessments'] = 'Din aflevering med vurderinger';
