<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_db', language 'da', version '4.3'.
 *
 * @package     auth_db
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_dbcannotconnect'] = 'Kan ikke forbinde til den eksterne database.';
$string['auth_dbcannotreadtable'] = 'Kan ikke læse den eksterne tabel.';
$string['auth_dbcantconnect'] = 'Der blev ikke oprettet forbinelse til den angivne godkendelsesdatabase...';
$string['auth_dbchangepasswordurl_key'] = 'URL til ændring af adgangskode';
$string['auth_dbcolumnlist'] = 'Den eksterne tabel indeholder følgende kolonner:<br />{$a}';
$string['auth_dbdebugauthdb'] = 'Debug ADOdb';
$string['auth_dbdebugauthdbhelp'] = 'Debug ADOdb-forbindelse til ekstern database - bruges når en tom side vises ved login. Ikke egnet til en Moodle i drift.';
$string['auth_dbdeleteuser'] = 'Slettet bruger {$a->name} id {$a->id}';
$string['auth_dbdeleteusererror'] = 'Der opstod en fejl ved sletning af brugeren {$a}';
$string['auth_dbdescription'] = 'Denne metode bruger en ekstern database til kontrol af om brugernavn og adgangskode er gyldig. Hvis kontoen er ny, kan oplysninger fra andre felter også kopieres ind i Moodle.';
$string['auth_dbextencoding'] = 'Ekstern db-kodning';
$string['auth_dbextencodinghelp'] = 'Den eksterne databases tekstkodning';
$string['auth_dbextrafields'] = 'Disse felter er valgfri. Du kan vælge at udfylde nogle af de felter Moodle bruger på forhånd fra <b>den eksterne database</b>, som du har specificeret her.<p> Hvis ikke du skriver noget her, vil standardværdierne blive brugt.</p><p> I alle tilfælde vil brugeren være i stand til at skrive i alle felterne når de er logget ind.';
$string['auth_dbfieldpass'] = 'Navn på feltet med adgangskode';
$string['auth_dbfieldpass_key'] = 'Felt til adgangskode';
$string['auth_dbfielduser'] = 'Navnet på feltet der indeholder brugernavne. Feltet skal være af typen "varchar".';
$string['auth_dbfielduser_key'] = 'Felt til brugernavn';
$string['auth_dbhost'] = 'Computeren der hoster databaseserveren. Brug en system-DSN-adgang hvis du bruger ODBC. Brug en PDO DSN-adgang hvis du bruger PDO.';
$string['auth_dbhost_key'] = 'Vært';
$string['auth_dbinsertuser'] = 'Brugeren {$a->name} id {$a->id} er sat ind';
$string['auth_dbinsertuserduplicate'] = 'Fejl ved indsætning af brugeren {$a->username} - en bruger med det brugernavn er allerede oprettet gennem plugin\'et "{$a->auth}".';
$string['auth_dbinsertusererror'] = 'Fejl ved indsættelse af brugeren {$a}';
$string['auth_dbname'] = 'Navnet på selve databasen. Lad feltet stå tomt hvis du bruger en ODBC DSN. Lad det også stå tomt hvis din PDO DSN allerede indeholder databasenavnet.';
$string['auth_dbname_key'] = 'DB-navn';
$string['auth_dbnoexttable'] = 'Den eksterne tabel ikke specificeret.';
$string['auth_dbnouserfield'] = 'Det eksterne brugerfelt er ikke specificeret.';
$string['auth_dbpass'] = 'Adgangskode der matcher ovennævnte brugernavn';
$string['auth_dbpass_key'] = 'Adgangskode';
$string['auth_dbpasstype'] = '<p>Angiv hvilket format adgangskodefeltet anvender. </p> <p>Brug "intern" hvis den eksterne database skal administrere brugernavne & e-mailadresser, og Moodle administrere adgangskoder. Vælger du "intern", <i>skal</i> du opgive et (populated) e-mailadressefelt i den eksterne database, og du skal akivere \\auth_db\\task\\sync_users scheduled task. Moodle vil sende en e-mail til nye brugere med en midlertidigt adgangskode.</p>';
$string['auth_dbpasstype_key'] = 'Kodeformat';
$string['auth_dbreviveduser'] = 'Brugeren {$a->name} id {$a->id} genaktiveret';
$string['auth_dbrevivedusererror'] = 'Fejl ved genaktivering af brugeren {$a}';
$string['auth_dbsetupsql'] = 'SQL setup-kommando';
$string['auth_dbsetupsqlhelp'] = 'SQL-kommando til speciel databaseopsætning, bruges ofte til opsætning af kommunikationskodning - f.eks. til MySQL og PostgreSQL: <em>SET NAMES \'utf8\'</em>';
$string['auth_dbsuspenduser'] = 'Suspenderede brugeren {$a->name} id {$a->id}';
$string['auth_dbsuspendusererror'] = 'Fejl ved suspendering af brugeren {$a}';
$string['auth_dbsybasequoting'] = 'Brug sybase-anførselstegn';
$string['auth_dbsyncuserstask'] = 'Synkroniser brugers opgave';
$string['auth_dbtable'] = 'Navnet på tabellen i databasen';
$string['auth_dbtable_key'] = 'Tabel';
$string['auth_dbtableempty'] = 'Den eksterne tabel er tom.';
$string['auth_dbtype'] = 'Databasetypen (Se evt. <a href="http://adodb.org/dokuwiki/doku.php" target="_blank">ADOdb - Database Abstraction Layer for PHP</a>)';
$string['auth_dbtype_key'] = 'Database';
$string['auth_dbupdateerror'] = 'Fejl under opdatering af ekstern database.';
$string['auth_dbupdateusers'] = 'Opdater brugere';
$string['auth_dbupdateusers_description'] = 'Opdater eksisterende brugere såvel som indsæt nye.';
$string['auth_dbupdatinguser'] = 'Opdaterer brugeren {$a->name} id {$a->id}';
$string['auth_dbuser'] = 'Brugernavn med læserrettigheder til databasen';
$string['auth_dbuser_key'] = 'DB-bruger';
$string['auth_dbuserstoadd'] = 'Brugerposter der skal tilføjes: {$a}';
$string['auth_dbuserstoremove'] = 'Brugerposter der skal fjernes: {$a}';
$string['pluginname'] = 'Ekstern database';
$string['privacy:metadata'] = 'Godkendelsesplugin\'et Ekstern database gemmer ingen personlige data.';
