<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'pt', version '4.3'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Todas as competências filho estão concluídas';
$string['competencies'] = 'Competências';
$string['competenciesarenotenabled'] = 'As competências não estão ativadas.';
$string['competenciessettings'] = 'Configurações das competências';
$string['completeplanstask'] = 'Conclusão de planos de aprendizagem com data limite ultrapassada';
$string['coursecompetencyoutcome_complete'] = 'Concluir a competência';
$string['coursecompetencyoutcome_evidence'] = 'Anexar comprovativo de aprendizagem';
$string['coursecompetencyoutcome_none'] = 'Sem ações';
$string['coursecompetencyoutcome_recommend'] = 'Enviar para revisão';
$string['coursemodulecompetencyoutcome_complete'] = 'Concluir a competência';
$string['coursemodulecompetencyoutcome_evidence'] = 'Anexar comprovativo de aprendizagem';
$string['coursemodulecompetencyoutcome_none'] = 'Sem ações';
$string['coursemodulecompetencyoutcome_recommend'] = 'Enviar para revisão';
$string['deletecompetencyratings'] = 'Apagar avaliações da competência';
$string['duplicateditemname'] = '{$a} (cópia)';
$string['enablecompetencies'] = 'Ativar competências';
$string['enablecompetencies_desc'] = 'As competências permitem que os utilizadores possam ser avaliados de acordo com planos de aprendizagem.';
$string['errorcannotchangeapastduedate'] = 'A data limite já foi ultrapassada; não pode ser alterada.';
$string['errorcannotsetduedateinthepast'] = 'A data limite não pode ser definida para uma data no passado.';
$string['errorcannotsetduedatetoosoon'] = 'A data limite está muito próxima.';
$string['errorcompetencyrule'] = 'Regra \'{$a}\' da competência da disciplina desconhecida';
$string['errorcoursecompetencyrule'] = 'Regra \'{$a}\' da competência da disciplina desconhecida';
$string['errorinvalidcourse'] = 'Disciplina inválida.';
$string['errornocompetency'] = 'A competência {$a} não foi encontrada';
$string['errorplanstatus'] = 'Estado desconhecido do plano de aprendizagem \'{$a}\'';
$string['errorscalealreadyused'] = 'A escala não pode ser alterada uma vez que já está em uso.';
$string['errorscaleconfiguration'] = 'Tem de selecionar os itens predefinido e proficiência para configurar a escala.';
$string['errorusercomptencystatus'] = 'Estado desconhecido da competência \'{$a}\' do utilizador';
$string['eventcompetencycreated'] = 'Competência criada.';
$string['eventcompetencydeleted'] = 'Competência eliminada.';
$string['eventcompetencyframeworkcreated'] = 'Quadro de competências criado.';
$string['eventcompetencyframeworkdeleted'] = 'Quadro de competências eliminado.';
$string['eventcompetencyframeworkupdated'] = 'Quadro de competências atualizado.';
$string['eventcompetencyframeworkviewed'] = 'Quadro de competências visualizado.';
$string['eventcompetencyupdated'] = 'Competência atualizada.';
$string['eventcompetencyviewed'] = 'Competência visualizada.';
$string['eventevidencecreated'] = 'Comprovativo criado.';
$string['eventplanapproved'] = 'Plano de aprendizagem aprovado.';
$string['eventplancompleted'] = 'Plano de aprendizagem concluído.';
$string['eventplancreated'] = 'Plano de aprendizagem criado.';
$string['eventplandeleted'] = 'Plano de aprendizagem eliminado.';
$string['eventplanreopened'] = 'Plano de aprendizagem reaberto.';
$string['eventplanreviewrequestcancelled'] = 'Pedido de revisão do plano de aprendizagem cancelado.';
$string['eventplanreviewrequested'] = 'Revisão do plano de aprendizagem solicitada.';
$string['eventplanreviewstarted'] = 'Revisão do plano de aprendizagem iniciada.';
$string['eventplanreviewstopped'] = 'Revisão do plano de aprendizagem terminada.';
$string['eventplanunapproved'] = 'Plano de aprendizagem não aprovado.';
$string['eventplanunlinked'] = 'Plano de aprendizagem desassociado.';
$string['eventplanupdated'] = 'Plano de aprendizagem atualizado.';
$string['eventplanviewed'] = 'Plano de aprendizagem visualizado.';
$string['eventtemplatecreated'] = 'Modelo do plano de aprendizagem criado.';
$string['eventtemplatedeleted'] = 'Modelo do plano de aprendizagem eliminado.';
$string['eventtemplateupdated'] = 'Modelo do plano de aprendizagem atualizado.';
$string['eventtemplateviewed'] = 'Modelo do plano de aprendizagem visualizado.';
$string['eventusercompetencyplanviewed'] = 'Plano de competência do utilizador visualizado.';
$string['eventusercompetencyrated'] = 'Competência do utilizador avaliada.';
$string['eventusercompetencyratedincourse'] = 'Competência do utilizador avaliada na disciplina.';
$string['eventusercompetencyratedinplan'] = 'Competência do utilizador avaliada num plano de aprendizagem.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Pedido de revisão da competência do utilizador cancelado.';
$string['eventusercompetencyreviewrequested'] = 'Pedido de revisão da competência do utilizador.';
$string['eventusercompetencyreviewstarted'] = 'Revisão da competência do utilizador iniciada.';
$string['eventusercompetencyreviewstopped'] = 'Revisão da competência do utilizador terminada.';
$string['eventusercompetencyviewed'] = 'Competência do utilizador visualizada.';
$string['eventusercompetencyviewedincourse'] = 'Competência do utilizador visualizada numa disciplina.';
$string['eventusercompetencyviewedinplan'] = 'Competência do utilizador visualizada num plano de aprendizagem.';
$string['eventuserevidencecreated'] = 'Comprovativo de aprendizagem anterior criado.';
$string['eventuserevidencedeleted'] = 'Comprovativo de aprendizagem anterior eliminado.';
$string['eventuserevidenceupdated'] = 'Comprovativo de aprendizagem anterior atualizado.';
$string['evidence_competencyrule'] = 'A regra da competência foi cumprida.';
$string['evidence_coursecompleted'] = 'A disciplina \'{$a}\' está concluída.';
$string['evidence_coursemodulecompleted'] = 'A atividade \'{$a}\' está concluída.';
$string['evidence_courserestored'] = 'A avaliação foi restaurada em conjunto com a disciplina \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'O comprovativo de aprendizagem anterior \'{$a}\' foi associado à competência.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'O comprovativo de aprendizagem anterior \'{$a}\' foi desassociado da competência.';
$string['evidence_manualoverride'] = 'A avaliação da competência foi configurada manualmente.';
$string['evidence_manualoverrideincourse'] = 'A avaliação da competência foi configurada manualmente na disciplina \'{$a}\'.';
$string['evidence_manualoverrideinplan'] = 'A avaliação da competência foi configurada manualmente no plano de aprendizagem \'{$a}\'.';
$string['invalidevidencedesc'] = 'Descrição inválida do comprovativo';
$string['invalidgrade'] = 'Avaliação inválida';
$string['invalidpersistenterror'] = 'Erro: {$a}';
$string['invalidplan'] = 'Plano de aprendizagem inválido';
$string['invalidtaxonomy'] = 'Taxonomia inválida: {$a}';
$string['invalidurl'] = 'O endereço URL não é válido. Certifique-se que este começa com o prefixo \'http://\' ou \'https://\'.';
$string['nouserplanswithcompetency'] = 'Nenhum plano de aprendizagem contém esta competência.';
$string['planstatusactive'] = 'Ativo';
$string['planstatuscomplete'] = 'Concluído';
$string['planstatusdraft'] = 'Rascunho';
$string['planstatusinreview'] = 'Em revisão';
$string['planstatuswaitingforreview'] = 'À espera de revisão';
$string['pointsrequiredaremet'] = 'Foram cumpridos os pontos necessários';
$string['privacy:evidence:action:complete'] = 'Completar competência se não avaliada';
$string['privacy:evidence:action:log'] = 'Registo de ação';
$string['privacy:evidence:action:override'] = 'Redefinir avaliação da competência';
$string['privacy:metadata:competency'] = 'O registo das competências';
$string['privacy:metadata:competency_coursecomp'] = 'O registo de competências ligadas a uma disciplina';
$string['privacy:metadata:competency_coursecompsetting'] = 'O registo das configurações de competências numa disciplina';
$string['privacy:metadata:competency_evidence'] = 'O registo do comprovativo a afetar o estado da competancia';
$string['privacy:metadata:competency_framework'] = 'O registo de quadros de competência';
$string['privacy:metadata:competency_modulecomp'] = 'O registo de competência ligadas a um módulo';
$string['privacy:metadata:competency_plan'] = 'O registo de planos de aprendizagem';
$string['privacy:metadata:competency_plancomp'] = 'O resisto de competências num plano de aprendizagem';
$string['privacy:metadata:competency_relatedcomp'] = 'Registo da relação entre competências';
$string['privacy:metadata:competency_template'] = 'Registo de modelos de planos de aprendizagem';
$string['privacy:metadata:competency_templatecohort'] = 'O registo de grupos associados ao modelo de plano de aprendizagem';
$string['privacy:metadata:competency_templatecomp'] = 'O registo de competências num modelo de plano de aprendizagem';
$string['privacy:metadata:competency_usercomp'] = 'O registo do estado da competência de um utilizador';
$string['privacy:metadata:competency_usercompcourse'] = 'O registo do estado da competência de um utilizador numa disicplina';
$string['privacy:metadata:competency_usercompplan'] = 'O registo do estado da competência num plano de aprendizagem';
$string['privacy:metadata:competency_userevidence'] = 'O registo do comprovativo de aprendizagem anterior';
$string['privacy:metadata:competency_userevidencecomp'] = 'O registo de competências associadas ao comprovativo de aprendizagem anterior';
$string['privacy:metadata:core_comments'] = 'Comentários feitos nos planos de aprendizagem e competências';
$string['privacy:metadata:evidence:action'] = 'O tipo de ação realizada com o comprovativo';
$string['privacy:metadata:evidence:actionuserid'] = 'O utilizador a executar a ação';
$string['privacy:metadata:evidence:desca'] = 'Os parâmetros opcionais da descrição do comprovativo conversível';
$string['privacy:metadata:evidence:desccomponent'] = 'O componente da descrição do comprovativo conversível';
$string['privacy:metadata:evidence:descidentifier'] = 'O identificador da descrição do comprovativo conversível';
$string['privacy:metadata:evidence:grade'] = 'A nota associada ao comprovativo';
$string['privacy:metadata:evidence:note'] = 'A notificação anexada ao comprovativo não foi localizada';
$string['privacy:metadata:evidence:url'] = 'O URL associado ao comprovativo';
$string['privacy:metadata:plan:description'] = 'A descrição do plano de aprendizadem';
$string['privacy:metadata:plan:duedate'] = 'A data limite do plano de aprendizagem';
$string['privacy:metadata:plan:name'] = 'O nome do plano de aprendizagem';
$string['privacy:metadata:plan:reviewerid'] = 'O ID do avaliador plano de aprendizagem';
$string['privacy:metadata:plan:status'] = 'Estado do plano de aprendizagem';
$string['privacy:metadata:plan:userid'] = 'O ID do utilizador a quem pertence o plano de aprendizagem';
$string['privacy:metadata:timecreated'] = 'Data e hora em que o registo foi criado';
$string['privacy:metadata:timemodified'] = 'A data e hora em que o registo foi editado';
$string['privacy:metadata:usercomp:grade'] = 'A avaliação atribuída pela competência';
$string['privacy:metadata:usercomp:proficiency'] = 'Se a proficiência é atingida';
$string['privacy:metadata:usercomp:reviewerid'] = 'Id do avaliador';
$string['privacy:metadata:usercomp:status'] = 'Estado da competência';
$string['privacy:metadata:usercomp:userid'] = 'O ID do utilizador a quem pertence a competência';
$string['privacy:metadata:userevidence:description'] = 'A descrição do comprovativo de aprendizagem anterior';
$string['privacy:metadata:userevidence:name'] = 'O nome do comprovativo de aprendizagem anterior';
$string['privacy:metadata:userevidence:url'] = 'O URL associado ao comprovativo de aprendizagem anterior';
$string['privacy:metadata:usermodified'] = 'O utilizador que criou ou modificou o regsito';
$string['privacy:path:plans'] = 'Planos de apendizagem';
$string['privacy:path:relatedtome'] = 'Relacionada comigo';
$string['privacy:path:userevidence'] = 'Comprovativo de aprendizagem anterior';
$string['pushcourseratingstouserplans'] = 'Utilizar avaliações da disciplina nos planos individuais de aprendizagem';
$string['pushcourseratingstouserplans_desc'] = 'Valor predefinido para a configuração da disciplina, para atualizar planos de aprendizagem individuais, sempre que as competências da disciplina são avaliadas.';
$string['syncplanscohorts'] = 'Sincronização de planos a partir dos modelos de planos de aprendizagem dos Grupos globais';
$string['taxonomy_behaviour'] = 'Comportamento';
$string['taxonomy_competency'] = 'Competência';
$string['taxonomy_concept'] = 'Conceito';
$string['taxonomy_domain'] = 'Domínio';
$string['taxonomy_indicator'] = 'Indicador';
$string['taxonomy_level'] = 'Nível';
$string['taxonomy_outcome'] = 'Resultado da aprendizagem';
$string['taxonomy_practice'] = 'Prática';
$string['taxonomy_proficiency'] = 'Proficiência';
$string['taxonomy_skill'] = 'Habilidade';
$string['taxonomy_value'] = 'Valor';
$string['usercommentedonacompetency'] = '{$a->fullname} comentou na competência "{$a->competency}":

{$a->comment}

Ver: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} comentou na competência "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>Ver: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} comentou na competência "{$a->competency}".';
$string['usercommentedonacompetencysubject'] = '{$a} comentou numa competência.';
$string['usercommentedonaplan'] = '{$a->fullname} comentou no plano de aprendizagem "{$a->plan}":

{$a->comment}

Ver: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} comentou no plano de aprendizagem "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Ver: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} comentou no plano de aprendizagem "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} comentou num plano de aprendizagem.';
$string['usercompetencystatus_idle'] = 'Parado';
$string['usercompetencystatus_inreview'] = 'Em revisão';
$string['usercompetencystatus_waitingforreview'] = 'À espera de revisão';
$string['userplans'] = 'Planos de aprendizagem';
