<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'eu', version '4.3'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Ulertu dut eta ados nago datu-prozesatze onespenarekin';
$string['activityoverview'] = 'Laster BigBlueButton saioak izango dituzu';
$string['bbbduetimeoverstartingtime'] = 'Jarduera honen itxiera-data irekitze-data baino beranduagokoa izan behar du.';
$string['bbbdurationwarning'] = 'Saio honen gehieneko iraupena %duration% minutu da.';
$string['bbbrecordallfromstartwarning'] = 'Saio hau hasieratik grabatuko da.';
$string['bbbrecordwarning'] = 'Saio hau grabatu ahalko da.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Gehitu BigBlueButton bilera-gela berri bat';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Sortu zuzeneko bileretarako instantzia';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Sortu instantzia grabazioekin';
$string['bigbluebuttonbn:deleterecordings'] = 'Ezabatu grabazioak';
$string['bigbluebuttonbn:importrecordings'] = 'Inportatu grabazioak';
$string['bigbluebuttonbn:join'] = 'Sartu BigBlueButton bilera-gela batera';
$string['bigbluebuttonbn:managerecordings'] = 'Kudeatu grabazioak';
$string['bigbluebuttonbn:protectrecordings'] = 'Babestu grabazioak';
$string['bigbluebuttonbn:publishrecordings'] = 'Argitaratu grabazioak';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Kendu babesa grabazioei';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Ezkutatu grabazioak';
$string['bigbluebuttonbn:view'] = 'Ikusi BigBlueButton bilera-gela';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Ikusi grabazio-formatu guztiak';
$string['bigbluebuttondisablednotification'] = 'BigBlueButton jarduera-modulua desgaituta dago eta aurretiko BigBlueButton ikastaro-jarduerak ez daude eskuragarri une honetan. Plugin hau berriz gaitu aurretik, ziurtatu ezazu Blindside Networks Inc.-ren <a href="{$a}" target="_blank">datu-prozesatzen onespena</a> irakurri eta onartzen duzula.';
$string['bigbluebuttondisablednotification_subject'] = 'BigBlueButton jarduera-modulua desgaituta dago.';
$string['cachedef_currentfetch'] = 'Orain dela gutxi jasotako edozein grabazio zerrendatzeko datuak.';
$string['cachedef_recordings'] = 'Grabazioen metadatuak';
$string['cachedef_serverinfo'] = 'Urruneko zerbitzariaren informazioa';
$string['cachedef_subplugins'] = 'Pluginen aurkitze-prozesua behar denean azkartzeko azpi-pluginen errutinak erabilitako cachea.';
$string['cachedef_validatedurls'] = 'Balioztatutako URL egiaztapenen cachea';
$string['calendarstarts'] = '{$a} programatuta dago hurrengo datan:';
$string['cannotperformaction'] = 'Ezin da {$a} ekintza grabazio honetan exekutatu';
$string['completionattendance'] = 'Behartu bertaratzea (minutuak)';
$string['completionattendance_desc'] = 'Bilera-gelan sartu eta bertan gutxienez {$a} minutuz egotea.';
$string['completionattendance_event_desc'] = 'Ikaslea bilera-gelan sartu eta bertan gutxienez {$a} minutuz egon da';
$string['completionattendancegroup'] = 'Behartu bertaratzea (minutuak)';
$string['completionattendancegroup_help'] = 'Jarduera osatzeko beharrezkoa da bileran (n) minutuz egotea';
$string['completionengagement_desc'] = 'Bileran zeharreko jardueretan parte hartzea.';
$string['completionengagementchats'] = 'Txatak';
$string['completionengagementchats_desc'] = '{$a} txatetan parte hartzea.';
$string['completionengagementchats_event_desc'] = '{$a} txat sortu ditu';
$string['completionengagementemojis'] = 'Emojiak';
$string['completionengagementemojis_desc'] = 'Bere emojia(k) {$a} aldiz aldatzea.';
$string['completionengagementemojis_event_desc'] = 'Bere emojia(k) {$a} aldiz aldatu d(it)u';
$string['completionengagementgroup'] = 'Behartu parte-hartzea';
$string['completionengagementgroup_help'] = 'Saioan zeharreko parte-hartzea behar da jarduera osatzeko.';
$string['completionengagementpollvotes'] = 'Inkesten botoak';
$string['completionengagementpollvotes_desc'] = 'Inkestetan {$a} aldiz botoa ematea.';
$string['completionengagementpollvotes_event_desc'] = 'Inkestetan {$a} boto eman ditu';
$string['completionengagementraisehand'] = 'Behartu eskua altxatzea';
$string['completionengagementraisehand_desc'] = 'Eskua {$a} aldiz altxatzea.';
$string['completionengagementraisehand_event_desc'] = 'Eskua {$a} aldiz altxatu du';
$string['completionengagementtalks'] = 'Hitz egitea';
$string['completionengagementtalks_desc'] = '{$a} aldiz hitz egitea';
$string['completionengagementtalks_event_desc'] = '{$a} aldiz hitz egin du';
$string['completionupdatestate'] = 'Osaketaren eguneratzearen egoera';
$string['completionvalidatestate'] = 'Balioztatu osaketa';
$string['completionvalidatestatetriggered'] = 'Balioztatu osaketa abiarazi da.';
$string['completionview'] = 'Behartu ikustea';
$string['completionview_desc'] = 'Bilera-gela ikustea';
$string['completionview_event_desc'] = 'Bilera-gela ikusi du.';
$string['config_checksum_algorithm'] = 'BigBlueButton zerbitzariaren checksum algoritmoa';
$string['config_checksum_algorithm_description'] = 'SHA1 protokoloak zerbitzarien bertsio zaharragoekin bateragarritasuna bermatzen du. SHA256 eta SHA512 protokoloak seguruagoak dira. SHA512 protokoloak FIPS 140-2 betetzen du.';
$string['config_default_messages'] = 'Lehenetsitako mezuak';
$string['config_default_messages_description'] = 'Zehaztu jardueretarako lehenetsitako mezuak';
$string['config_disablecam_default'] = 'Desgaitu web-kamera gaituta modu lehenetsian';
$string['config_disablecam_default_description'] = 'Gaituz gero web-kamerak desgaituta egongo dira.';
$string['config_disablecam_editable'] = 'Desgaitu web-kamera editatu daiteke';
$string['config_disablecam_editable_description'] = 'Desgaitu web-kameraren balio lehenetsia instantzia bat gehitu edo editatzean editatu daitekeen.';
$string['config_disablemic_default'] = 'Desgaitu mikrofonoa gaituta modu lehenetsian';
$string['config_disablemic_default_description'] = 'Gaituz gero mikrofonoak desgaituta egongo dira.';
$string['config_disablemic_editable'] = 'Desgaitu mikrofonoa editatu daiteke';
$string['config_disablemic_editable_description'] = 'Desgaitu mikrofonoaren balio lehenetsia instantzia bat gehitu edo editatzean editatu daitekeen.';
$string['config_disablenote_default'] = 'Desgaitu ohar partekatuak gaituta modu lehenetsian';
$string['config_disablenote_default_description'] = 'Gaituz gero ohar partekatuak desgaituta egongo dira.';
$string['config_disablenote_editable'] = 'Desgaitu ohar partekatuak editatu daiteke';
$string['config_disablenote_editable_description'] = 'Desgaitu ohar partekatuen balio lehenetsia instantzia bat gehitu edo editatzean editatu daitekeen.';
$string['config_disableprivatechat_default'] = 'Desgaitu txat pribatua gaituta modu lehenetsian';
$string['config_disableprivatechat_default_description'] = 'Gaituz gero txat pribatua desgaituta egongo da.';
$string['config_disableprivatechat_editable'] = 'Desgaitu txat pribatua editatu daiteke';
$string['config_disableprivatechat_editable_description'] = 'Desgaitu txat pribatuaren balio lehenetsia instantzia bat gehitu edo editatzean editatu daitekeen.';
$string['config_disablepublicchat_default'] = 'Desgaitu txat publikoa gaituta modu lehenetsian';
$string['config_disablepublicchat_default_description'] = 'Gaituz gero txat publikoa desgaituta egongo da.';
$string['config_disablepublicchat_editable'] = 'Desgaitu txat publikoa editatu daiteke';
$string['config_disablepublicchat_editable_description'] = 'Desgaitu txat publikoaren balio lehenetsia instantzia bat gehitu edo editatzean editatu daitekeen.';
$string['config_dpa_note'] = 'Oharra: Datu-babeserako betebeharrak betetzeko, plugin honentzako zerbitzu-hornitzaile bat erabiltzen hasi aurretik zerbitzu hornitzailearen datu-prozesatzerako onespena irakurri eta onartzen duzula ziurtatu behar duzu. Lehenetsitako doako BigBlueButton zerbitzurako hau da <a href="{$a}" target="_blank">Blindside Networks-eko datu-prozesatze onespena</a>. Gomendioetarako harremanetan jarri zaitez zure pribatutasun adituekin.';
$string['config_experimental_features'] = 'Funtzio esperimentalak';
$string['config_experimental_features_description'] = 'Funtzio esperimentaletarako ezarpenak.';
$string['config_extended_capabilities'] = 'Gaitasun hedatuak';
$string['config_extended_capabilities_description'] = 'Gaitasun hedatuen konfigurazioa, BigBlueButton zerbitzariak eskaintzen baditu.';
$string['config_general'] = 'Ezarpen orokorrak';
$string['config_general_description'] = 'Ezarpen hauek beti erabiltzen dira.';
$string['config_guestaccess_enabled'] = 'Kanpoko gonbidatuentzako sarbidea';
$string['config_guestaccess_enabled_description'] = 'Baimendu zure gunean kontua ez duten kanpoko pertsonak bilera-gelara sartzea.';
$string['config_hideuserlist_default'] = 'Ezkutatu erabiltzaile-zerrenda gaituta modu lehenetsian';
$string['config_hideuserlist_default_description'] = 'Gaituz gero saioko erabiltzaile-zerrenda ezkutatuko da.';
$string['config_hideuserlist_editable'] = 'Ezkutatu erabiltzaile-zerrenda editatu daiteke';
$string['config_hideuserlist_editable_description'] = 'Ezkutatu erabiltzaile-zerrendaren balio lehenetsia instantzia bat gehitu edo editatzean editatu daitekeen.';
$string['config_importrecordings'] = 'Inportatu grabazioak';
$string['config_importrecordings_description'] = 'Ezarpen hauek funtzionalitate zehatzenak dira.';
$string['config_importrecordings_enabled'] = 'Grabazioen inportazioa gaituta dago';
$string['config_importrecordings_enabled_description'] = 'Funtzionalitate hau eta grabazioena gaituta badaude, beste ikastaroetako grabazioak jarduera batean inportatzeko aukera egongo da.';
$string['config_importrecordings_from_deleted_enabled'] = 'Ezabatutako jardueren grabazioen inportazioa gaituta dago';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Funtzionalitate hau eta grabazioena gaituta badaude, dagoeneko ikastaroan ez dauden jardueren grabazioak inportatzeko aukera egongo da.';
$string['config_locksettings'] = 'Blokeatze-ezarpenen konfigurazioa';
$string['config_locksettings_description'] = 'Ezarpen hauek erabiltzaile-interfazean blokeatze-ezarpenen aukerak gaitu edo desgaitzen dituzte, baita aukera horietarako lehenetsitako balioak zehaztu ere.';
$string['config_meetingevents_enabled'] = 'Egin zuzeneko saioen erregistroa';
$string['config_meetingevents_enabled_description'] = 'Gaituz gero, zuzeneko saioak amaitzerakoan prozesatuko dira. Funtzio hau jarduera osaketaren jarraipenerako beharrezkoa da eta soilik funtzionatuko du BigBlueButton zerbitzariak post_events script-ak prozesatzeko gai bada.';
$string['config_muteonstart'] = 'Isilarazi hasieran';
$string['config_muteonstart_default'] = '"Isilarazi hasieran" gaituta dago modu lehenetsian';
$string['config_muteonstart_default_description'] = 'Gaituz gero hasieran saioa isilaraziko da.';
$string['config_muteonstart_description'] = 'Ezarpen hauen bidez interfaze grafikoaren hainbat aukera gaitu edo desgaitu eta hauen lehenetsitako balioak zehazten dira.';
$string['config_muteonstart_editable'] = '"Isilarazi hasieran" ezarpena editatu daiteke';
$string['config_muteonstart_editable_description'] = '"Isilarazi hasieran" ezarpena saioa gehitu edo eguneratzen denean editatu daiteke modu lehenetsian.';
$string['config_participant'] = 'Parte-hartzaileak';
$string['config_participant_description'] = 'Ezarpen hauek bileraren parte hartzaileen rol lehenetsia zehazten dute.';
$string['config_participant_moderator_default'] = 'Moderatzailea';
$string['config_participant_moderator_default_description'] = 'Arau hau bilera-gela berri bat sortzen denean erabiltzen da modu lehenetsian.';
$string['config_poll_interval'] = 'Inkesten tartea (segundotan) gelaren egoera freskatzeko';
$string['config_poll_interval_description'] = 'Inkesten tartea gutxienez 2 segundokoa izan behar da. Behar izanez gero urruneko zerbitzariaren karga gutxitzeko tartea handitu dezakezu.';
$string['config_presentation_default'] = 'Lehenetsitako aurkezpen-fitxategia';
$string['config_presentation_default_description'] = 'Hemen bilera-gela guztietan erabiliko den fitxategi bat zehaztu daiteke.';
$string['config_preuploadpresentation'] = 'Aldez aurretik kargatutako aurkezpena';
$string['config_preuploadpresentation_description'] = 'Ezarpen hauen bidez interfaze grafikoaren hainbat aukera gaitu edo desgaitu eta hauen lehenetsitako balioak zehazten dira. Funtzionalitate honek soilik BigBlueButtonek Moodleren zerbitzaria erabili badezake funtzionatzen du.';
$string['config_preuploadpresentation_editable'] = 'Aldez aurretik kargatutako aurkezpena editagarria';
$string['config_preuploadpresentation_editable_description'] = 'Aldez aurretik kargatutako aurkezpena erabiltzaile-interfazean editagarria da bilera-gela edo konferentzia gehitu edo eguneratzean.';
$string['config_profile_picture_enabled'] = 'Erakutsi profileko irudiak';
$string['config_profile_picture_enabled_description'] = 'Partaideen profileko irudiak BigBlueButton saioetan erakutsi beharko lirateke?';
$string['config_recording'] = 'Grabazioa';
$string['config_recording_all_from_start_default'] = 'Hasi grabazioa hasieratik';
$string['config_recording_all_from_start_default_description'] = '\'Hasi grabazioa hasieratik\' ezarpena modu lehenetsian gaituta egon beharko luke BigBlueButton bilera-gela berri bat gehitzerakoan?';
$string['config_recording_all_from_start_editable'] = 'Hasi grabazioa hasieratik editatu daiteke';
$string['config_recording_all_from_start_editable_description'] = '\'Hasi grabazioa hasieratik\' ezarpena editatu ahalko da BigBlueButton jardueraren ezarpenetan?';
$string['config_recording_default'] = 'Grabazioa gaituta dago modu lehenetsian';
$string['config_recording_default_description'] = '\'Saioa grabatu daiteke\' ezarpena modu lehenetsian gaituta egon beharko luke BigBlueButton bilera-gela berri bat gehitzerakoan?';
$string['config_recording_description'] = 'Ezarpen hauek funtzionalitate zehatzenak dira';
$string['config_recording_editable'] = 'Saioa grabatu daiteke ezarpena editatu daiteke';
$string['config_recording_editable_description'] = '\'Saioa grabatu daiteke\' ezarpena editatu ahalko da BigBlueButton jardueraren ezarpenetan?';
$string['config_recording_hide_button_default'] = 'Ezkutatu grabatzeko botoia';
$string['config_recording_hide_button_default_description'] = 'Markatuz gero grabatzeko botoia ezkutatuko da';
$string['config_recording_hide_button_editable'] = 'Ezkutatu grabatzeko botoia editatu daiteke';
$string['config_recording_hide_button_editable_description'] = '\'Ezkutatu grabatzeko botoia\' ezarpena editatu ahalko da BigBlueButton jardueraren ezarpenetan?';
$string['config_recording_protect_editable'] = 'Babestutako grabazioen egoera editatu daiteke';
$string['config_recording_protect_editable_description'] = 'Markatuz gero interfazean grabazioak babestu edo babesa kentzeko aukera bat agertuko da.';
$string['config_recording_refresh_period'] = 'Grabazioen freskatze-maiztasuna (segundotan)';
$string['config_recording_refresh_period_description'] = 'Zein maiztasunekin eskatuko zaio BigBlueButton zerbitzariari grabazioen informazioa eguneratzeko?';
$string['config_recording_safe_formats'] = 'Edonork ikusi ahal dituen grabazio-formatuak';
$string['config_recording_safe_formats_description'] = 'Aukeratu edonork ikusi ahal dituen grabazio-formatuak. Beste formatu
guztiak irakasleentzako eta mod/bigbluebuttonbn:viewallrecordingformats
zein mod/bigbluebuttonbn:managerecordings baimenak dituzten
beste erabiltzaileentzat soilik egongo dira ikusgai.';
$string['config_recordingready_enabled'] = 'Bidali grabazio prest dagoenaren jakinarazpena';
$string['config_recordingready_enabled_description'] = 'Gaituz gero, grabazio bat prest dagoenean jakinarazpen bat bidaliko da. Funtzionalitate honek BigBlueButton zerbitzarian post_publish_recording_ready_callback script-a gaituta egotea behar du.';
$string['config_recordings'] = 'Erakutsi grabazioak';
$string['config_recordings_asc_sort'] = 'Ordenatu grabazioak kronologikoki';
$string['config_recordings_asc_sort_description'] = 'Grabazioak dataren arabera ordenatzen dira, kronologikoki edo alderantziz (grabazio berrienak lehenengo).';
$string['config_recordings_deleted_default'] = 'Ezabatutako jardueren grabazioak aukera gaituta modu lehenetsian';
$string['config_recordings_deleted_default_description'] = 'Gaituz gero grabazioen taulan ondoren ezabatu diren jardueren grabazioak agertuko dira.';
$string['config_recordings_deleted_editable'] = '"Ezabatutako jardueren grabazioak" funtzionalitatea editatu daiteke';
$string['config_recordings_deleted_editable_description'] = 'Ezabatutako jardueren grabazioak aukeran saio bat gehitu edo eguneratzen denean editatu daiteke modu lehenetsian.';
$string['config_recordings_description'] = 'Ezarpen hauek funtzionalitate zehatzenak dira';
$string['config_recordings_general'] = 'Erakutsi grabazioen ezarpenak';
$string['config_recordings_general_description'] = 'Ezarpen hauek soilik grabazioak bistaratzen direnean erabiltzen dira';
$string['config_recordings_imported_default'] = '"Erakutsi soilik inportatutako estekak" funtzionalitatea gaituta dago modu lehenetsian';
$string['config_recordings_imported_default_description'] = 'Gaituz gero grabazioen taulan soilik grabazioen inportatutako estekak egongo dira.';
$string['config_recordings_imported_editable'] = 'Erakutsi soilik inportatutako estekak funtzionalitatea editatu daiteke';
$string['config_recordings_imported_editable_description'] = '"Erakutsi soilik inportatutako estekak" funtzionalitatea saio bat gehitu edo eguneratzen denean editatu daiteke modu lehenetsian.';
$string['config_recordings_preview_default'] = 'Aurrebista gaituta dago modu lehentsian';
$string['config_recordings_preview_default_description'] = 'Gaituz gero taulan aurkezpenen aurrebistak egongo dira.';
$string['config_recordings_preview_editable'] = 'Aurrebisten funtzionalitatea editatu daiteke.';
$string['config_recordings_preview_editable_description'] = '"Aurrebista" funtzionalitatea saio bat gehitu edo eguneratzen denean editatu daiteke.';
$string['config_scheduled'] = 'Programatutako saioak';
$string['config_scheduled_description'] = 'Ezarpen hauetan programatutako saioen lehenetsitako jokaera definitzen da.';
$string['config_scheduled_pre_opening'] = 'Hasiera aurretiko sarbidea';
$string['config_scheduled_pre_opening_description'] = 'Programatutako saioa hasi baino zenbat minutu lehenago sar daitekeen bilera-gelan.';
$string['config_server_url'] = 'BigBlueButton zerbitzariaren URLa';
$string['config_server_url_description'] = 'Lehenetsitako kredentzialak Blindside Networks-ek eskainitako <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">Moodlerako doako BigBlueButton zerbitzurako (leiho berrian zabaltzen da)</a> dira, eta hurrengo mugak ditu:
<ol>
<li>Saio bakoitzaren iraupena gehienez 60 minutukoa izan daiteke</li>
<li>Saio bakoitzeko parte-hartzaileak gehienez 25 izan daitezke</li>
<li>Grabazioak zazpi (7) egunen buruan iraungitzen dira eta ezin dira deskargatu</li>
<li>Ikasleen web-kamerak moderatzaileak baino ez ditu ikusiko.</li>
</ol>';
$string['config_shared_secret'] = 'BigBlueButton sekretu partekatua';
$string['config_shared_secret_description'] = 'Zure BigBlueButton zerbitzariaren segurtasun-sekretua. Lehenetsitako sekretua Blindside Networks enpresak hornitzen duen doako BigBlueButton zerbitzurako baliagarria da.';
$string['config_uidelegation_enabled'] = 'Interfaze grafikoaren ordezkaritza gaituta dago';
$string['config_uidelegation_enabled_description'] = 'Ezarpen hauen bidez BigBlueButton zerbitzariaren interfaze grafikoaren ordezkaritza gaitu edo desgaitu daiteke .';
$string['config_userlimit'] = 'Erabiltzaile-muga';
$string['config_userlimit_default'] = 'Erabiltzaile-muga gaituta dago modu lehenetsian';
$string['config_userlimit_default_description'] = 'Bilera-gela bat sortzen den unean modu lehenetsian onartzen duen erabiltzaile kopurua. 0 ezarriz gero ez da erabiltzaile kopuruaren mugarik egongo.';
$string['config_userlimit_description'] = 'Ezarpen hauen bidez interfaze grafikoaren aukerak gaitu edo desgaitu eta hauen lehenetsitako balioak zehazten dira.';
$string['config_userlimit_editable'] = '"Erabiltzaile-muga" funtzionalitatea editatu daiteke';
$string['config_userlimit_editable_description'] = 'Erabiltzaile-mugaren balio lehenetsia bilera-gela bat gehitu edo eguneratzen denean editatu daiteke.';
$string['config_voicebridge'] = 'Ahots-zubia';
$string['config_voicebridge_description'] = 'Ezarpen hauen bidez interfaze grafikoaren aukerak gaitu edo desgaitu eta hauen lehenetsitako balioak zehazten dira.';
$string['config_voicebridge_editable'] = 'Bileraren ahots-zubia editatu daiteke';
$string['config_voicebridge_editable_description'] = 'Bileraren ahots-zubiaren zenbakia bilera-gela bati behin betiko ezarri dakioke. Ezartzen denean, zenbaki hori ezingo da beste bilera-gela batean erabili.';
$string['config_waitformoderator'] = 'Itxaron moderatzaileari';
$string['config_waitformoderator_cache_ttl'] = 'Itxaron moderatzaileari funtzioaren TTL cachea (segundoetan)';
$string['config_waitformoderator_cache_ttl_description'] = 'Bezero asko parte hartu ahal izateko plugin honek cachea erabiltzen du. Parametro honek definitzen du zenbat denboraz mantentzen den cachea BigBlueButton zerbitzarira hurrengo eskaria bidali arte.';
$string['config_waitformoderator_default'] = 'Itxaron moderatzaileari funtzioa gaituta dago modu lehenetsian';
$string['config_waitformoderator_default_description'] = '\'Itxaron moderatzaileari\' ezarpena modu lehenetsian gaituta egon beharko luke BigBlueButton bilera-gela berri bat gehitzerakoan?';
$string['config_waitformoderator_description'] = 'Ezarpen hauek funtzionalitate zehatzenak dira';
$string['config_waitformoderator_editable'] = 'Itxaron moderatzaileari editatu daiteke';
$string['config_waitformoderator_editable_description'] = '\'Itxaron moderatzaileari\' ezarpena editatu ahalko da BigBlueButton jardueraren ezarpenetan?';
$string['config_waitformoderator_ping_interval'] = 'Itxaron moderatzaileari funtzioaren ping-a (segundoetan)';
$string['config_waitformoderator_ping_interval_description'] = 'Zein maiztasunarekin egiaztatuko da zerbitzarian moderatzailea bilera-gelan sartu den?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonek config.php-ko aldagai global zaharkitu bat erabiltzen du. Fitxategia moldatu ezazu hurrengo bertsioetan erabilera hori ez delako onartuko.';
$string['config_warning_curl_not_installed'] = 'Funtzionalitate honek php-ren CURL hedapena instalatuta eta gaituta egotea behar du. Ezarpenetarako sarbidea soilik baldintza hau betetzean emango da.';
$string['config_welcome_default'] = 'Ongi-etorri mezu lehenetsia';
$string['config_welcome_default_description'] = 'Ongi-etorri mezua parte-hartzaile bat bilera-gelan sartzean erakusten da. Eremua hutsik utziz gero BigBlueButton zerbitzarian zehaztutako mezua erakutsiko da.';
$string['config_welcome_editable'] = 'Irakasleek lehenetsitako ongi-etorri mezua editatu dezakete';
$string['config_welcome_editable_description'] = 'Instantzia gehitu ala eguneratzean ongi-etorri mezua editatu daiteke';
$string['dpainfonotsigned'] = 'Plugin hau gaitu aurretik, <a href="{$a}">Blindside Networks Inc.-eko datu-prozesatzen onespena</a> irakurri eta onartu duzula baieztatu behar duzu.';
$string['enablingbigbluebutton'] = 'BigBlueButton jarduera gaitzen';
$string['enablingbigbluebuttondpainfo'] = 'Datu-babeserako betebeharrak betetzeko, plugin hau gaitu aurretik <a href="{$a}" target="_blank">Blindside Networks Inc.-eko datu-prozesatzen onespena</a> irakurri eta onartu duzula ziurtatu behar duzu. Gomendioetarako harremanetan jarri zaitez zure pribatutasun adituekin.';
$string['end_session_confirm'] = 'Ziur zaude saioa amaitu nahi duzula?';
$string['end_session_confirm_title'] = 'Ziur zaude saioa amaitu nahi duzula?';
$string['end_session_notification'] = 'Saioa amaitu egin da.';
$string['ends_at'] = 'Amaiera-data:';
$string['event_activity_created'] = 'Jarduera sortu da';
$string['event_activity_deleted'] = 'Jarduera ezabatu da';
$string['event_activity_updated'] = 'Jarduera eguneratu da';
$string['event_live_session'] = 'Zuzeneko saioa';
$string['event_meeting_created'] = 'Bilera-saioa sortu da';
$string['event_meeting_ended'] = 'Bilera amaitu dute';
$string['event_meeting_joined'] = 'Bileran sartu da';
$string['event_meeting_left'] = 'Bilera utzi du';
$string['event_recording_deleted'] = 'Grabazioa ezabatu da';
$string['event_recording_edited'] = 'Grabazioa editatu da';
$string['event_recording_imported'] = 'Grabazioa inportatu da';
$string['event_recording_protected'] = 'Grabazioa babestu da';
$string['event_recording_published'] = 'Grabazioa publikatu da';
$string['event_recording_unprotected'] = 'Grabazioari babesa kendu zaio';
$string['event_recording_unpublished'] = 'Grabazio publikatu gabea';
$string['event_recording_viewed'] = 'Grabazioa bistaratu da';
$string['event_unknown'] = 'Ekitaldi ezezaguna';
$string['general_error_cannot_create_meeting'] = 'Ezin izan da saioa sortu.';
$string['general_error_cannot_get_recordings'] = 'Ezin izan dira grabazioak eskuratu.';
$string['general_error_no_answer'] = 'Erantzuna hutsik dago. Egiaztatu ezazu mesedez BigBlueButton zerbitzariaren URLa ETA egiaztatu ezazu BigBlueButton zerbitzaria martxan dagoela.';
$string['general_error_not_allowed_to_create_instances'] = 'Erabiltzaileak ezin du inolako instantziarik sortu';
$string['general_error_not_found'] = 'Ezin izan da aurkitu {$a} IDa duen BigBlueButton jarduera.';
$string['general_error_unable_connect'] = 'Ezin da konexioa ezarri. Mesedez egiaztatu ezazu BigBlueButton zerbitzariaren URLa ondo dagoela eta BigBlueButton zerbitzaria martxan dagoela.
Xehetasunak: {$a}';
$string['guest_invitation_full_message'] = 'Kaixo,
<p>"{$a->name}" BigblueButton saiora gonbidatua izan zara "{$a->course_fullname}" ikastarotik.</p>
<p>Esteka: {$a->guestjoinurl}<br/>
<p>Pasahitza: {$a->guestpassword}</p>
<p>Laguntza behar izanez gero, mesedez {$a->sender} erabiltzailearekin harremanetan jarri zaitez.</p>';
$string['guest_invitation_small_message'] = 'Kaixo,

"{$a->name}" BigblueButton saiora gonbidatua izan zara "{$a->course_fullname}" ikastarotik.

Esteka: {$a->guestjoinurl}
Pasahitza: {$a->guestpassword}

Laguntza behar izanez gero, mesedez {$a->sender} erabiltzailearekin harremanetan jarri zaitez.';
$string['guest_invitation_subject'] = 'Gonbidapena: {$a->name} saioa "{$a->course_fullname}" ikastaroan';
$string['guestaccess_activitynotfound'] = 'Ez da jarduera aurkitu.';
$string['guestaccess_add'] = 'Gehitu gonbidatuak';
$string['guestaccess_add_no_id'] = 'Ez da eman BigBlueButton instantziaren IDrik.';
$string['guestaccess_copy_link'] = 'Kopiatu esteka';
$string['guestaccess_copy_password'] = 'Kopiatu pasahitza';
$string['guestaccess_emails'] = 'Gonbidatuen helbide elektronikoak';
$string['guestaccess_emails_help'] = 'Helbide elektronikoen zerrenda bat, komaz banatuta.';
$string['guestaccess_emails_invalidemail'] = 'Helbide elektroniko baliogabea: {$a}';
$string['guestaccess_feature_disabled'] = 'Gonbidatuen sarbidea desgaituta dago.';
$string['guestaccess_invite_failure'] = '{$a->errors} errorea gertatu da {$a->emails} pertsona gonbidatzerakoan, jarri harremanetan mesedez zure laguntza-zerbitzuarekin.';
$string['guestaccess_invite_success'] = 'Gonbidapena posta elektronikoz bidali zaie {$a->emails} gonbidatuei.';
$string['guestaccess_join_meeting'] = 'Sartu bileran';
$string['guestaccess_meeting_invalid_password'] = 'Pasahitza ez da zuzena.';
$string['guestaccess_meeting_link'] = 'Bileraren esteka';
$string['guestaccess_meeting_not_started'] = 'Sentitzen dugu, baina bilera ez da oraindik hasi. Saiatu zaitez beranduago, mesedez.';
$string['guestaccess_meeting_password'] = 'Bileraren pasahitza';
$string['guestaccess_password'] = 'Pasahitza';
$string['guestaccess_title'] = 'Gehitu gonbidatuak bilera honetara';
$string['guestaccess_username'] = 'Gonbidatuaren erabiltzaile-izena';
$string['index_confirm_end'] = 'Saioa amaitu nahi duzu?';
$string['index_disabled'] = 'desgaituta';
$string['index_enabled'] = 'gaituta';
$string['index_ending'] = 'Saioa amaitzen... itxaron mesedez';
$string['index_error_bbtn'] = 'BigBlueButton {$a} IDa ez da zuzena';
$string['index_error_checksum'] = 'Kontrolerako batura-errorea. Mesedez egiaztatu sekretua ondo zehaztu duzula.';
$string['index_error_forciblyended'] = 'Ezin izan da saioan sartu eskuz amaitua izan delako.';
$string['index_error_noinstances'] = 'Ez dago BigBlueButton bilera-gelen instantziarik';
$string['index_error_unable_display'] = 'Ezin izan dira saioak erakutsi. Mesedez egiaztatu BigBlueButton zerbitzariaren URLa ondo dagoela eta BigBlueButton zerbitzaria martxan dagoela.';
$string['index_heading'] = 'BigBlueButton bilera-gelak';
$string['index_heading_actions'] = 'Ekintzak';
$string['index_heading_group'] = 'Taldea';
$string['index_heading_moderator'] = 'Moderatzaileak';
$string['index_heading_name'] = 'Bilera-gela';
$string['index_heading_recording'] = 'Grabaketa';
$string['index_heading_users'] = 'Erabiltzaileak';
$string['index_heading_viewer'] = 'Ikusleak';
$string['indicator:cognitivedepth'] = 'BigBlueButton kognitiboa';
$string['indicator:cognitivedepth_help'] = 'Indikatzaile hau ikasleak BigBlueButton jardueran batean lortutako sakontasun kognitiboan oinarritzen da.';
$string['indicator:socialbreadth'] = 'BigBlueButton soziala';
$string['indicator:socialbreadth_help'] = 'Indikatzaile hau ikasleak BigBlueButton jardueran batean lortutako hedadura sozialean oinarritzen da.';
$string['instance_type_default'] = 'Bilera-gela grabazioarekin';
$string['instance_type_recording_only'] = 'Soilik grabazioa';
$string['instance_type_room_only'] = 'Bilera-gela soilik';
$string['instanceprofilewithoutrecordings'] = 'Instantzia-profil honek ezin ditu grabazioak erakutsi';
$string['managebbbextplugins'] = 'Kudeatu BigBlueButton hedapen-pluginak';
$string['messageprovider:instance_updated'] = 'BigBlueButton saioa eguneratu da';
$string['messageprovider:recording_ready'] = 'BigBlueButton grabazioa eskuragarri';
$string['minute'] = 'minutu';
$string['minutes'] = 'minutu';
$string['mod_form_block_general'] = 'Orokorra';
$string['mod_form_block_guestaccess'] = 'Gonbidatuen sarbidea';
$string['mod_form_block_participants'] = 'Zuzeneko saioan zehar esleitutako rola';
$string['mod_form_block_presentation'] = 'Aurkezpenaren edukia';
$string['mod_form_block_presentation_default'] = 'Aurkezpenaren eduki lehenetsia';
$string['mod_form_block_record'] = 'Grabazioen ezarpenak';
$string['mod_form_block_recordings'] = 'Grabazioen ikuspegia';
$string['mod_form_block_room'] = 'Bilera-gelaren ezarpenak';
$string['mod_form_block_schedule'] = 'Saioaren eskuragarritasuna';
$string['mod_form_field_closingtime'] = 'Itxiera-data';
$string['mod_form_field_conference_name'] = 'Saioaren izena';
$string['mod_form_field_disablecam'] = 'Desgaitu web-kamerak';
$string['mod_form_field_disablemic'] = 'Desgaitu mikrofonoak';
$string['mod_form_field_disablenote'] = 'Desgaitu ohar partekatuak';
$string['mod_form_field_disableprivatechat'] = 'Desgaitu txat pribatua';
$string['mod_form_field_disablepublicchat'] = 'Desgaitu txat publikoa';
$string['mod_form_field_duration'] = 'Iraupena';
$string['mod_form_field_duration_help'] = 'Bilera-gela baten iraupena ezartzeak, grabaketa amaitu baino lehen bilera-gela aktibo mantenduko den denbora-tarte maximoa adierazteko balio du';
$string['mod_form_field_guestallowed'] = 'Baimendu gonbidatuen sarbidea bileran';
$string['mod_form_field_hideuserlist'] = 'Ezkutatu erabiltzaile-zerrenda';
$string['mod_form_field_instanceprofiles'] = 'Instantzia mota';
$string['mod_form_field_instanceprofiles_help'] = 'Saioa grabatuko bada, aukeratu \'Bilera-gela grabazioekin\', eta bestela \'Bilera-gela soilik\'. Saioa grabatua izan ondoren ez bada saio gehiago egongo \'Grabazioak soilik\' aukeratu ezazu.';
$string['mod_form_field_intro'] = 'Deskribapena';
$string['mod_form_field_intro_help'] = 'Bilera-gelaren deskribapen laburra.';
$string['mod_form_field_mustapproveuser'] = 'Moderatzaileek erabiltzailea onartu behar dute';
$string['mod_form_field_muteonstart'] = 'Isilarazi hasieran';
$string['mod_form_field_name'] = 'Bilera-gelaren izena';
$string['mod_form_field_nosettings'] = 'Ez dago editatu daitekeen ezarpenik';
$string['mod_form_field_openingtime'] = 'Irekitze-data';
$string['mod_form_field_participant_add'] = 'Gehitu esleipena';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderatzailea';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Ikuslea';
$string['mod_form_field_participant_list'] = 'Esleipena';
$string['mod_form_field_participant_list_action_add'] = 'Gehitu';
$string['mod_form_field_participant_list_action_remove'] = 'Ezabatu';
$string['mod_form_field_participant_list_text_as'] = 'saioan honela sartu da:';
$string['mod_form_field_participant_list_type_all'] = 'Matrikulatutako erabiltzaile guztiak';
$string['mod_form_field_participant_list_type_owner'] = 'Jabea';
$string['mod_form_field_participant_list_type_role'] = 'Rola';
$string['mod_form_field_participant_list_type_user'] = 'Erabiltzailea';
$string['mod_form_field_record'] = 'Saioa grabatu daiteke.';
$string['mod_form_field_recordallfromstart'] = 'Grabatu dena hasieratik';
$string['mod_form_field_recordhidebutton'] = 'Ezkutatu grabatzeko botoia';
$string['mod_form_field_recordings_deleted'] = 'Ezabatutako jardueren grabazioak barne ditu';
$string['mod_form_field_recordings_html'] = 'Erakutsi taula formaturik gabeko HTML-an';
$string['mod_form_field_recordings_imported'] = 'Erakutsi soilik inportatutako estekak';
$string['mod_form_field_recordings_preview'] = 'Erakutsi grabazioaren aurrebista';
$string['mod_form_field_room_name'] = 'Bilera-gelaren izena';
$string['mod_form_field_userlimit'] = 'Erabiltzaile-muga';
$string['mod_form_field_userlimit_help'] = 'Saio batean onartutako gehieneko erabiltzaile kopurua. Ezarritako muga 0 bada ez da erabiltzaile mugarik egongo.';
$string['mod_form_field_voicebridge'] = 'Ahots-zubia [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Formatuaren errorea. 1 eta 9999 arteko zenbaki bat sartu behar duzu.';
$string['mod_form_field_voicebridge_help'] = 'Partaideek ahots konferentziara sartzeko erabiltzen duten 1 eta 9999 arteko zenbakia. Balioa 0 bada ahots-zubi estatikoari ezikusia egingo zaio eta BigBlueButtonek ausazko zenbaki bat sortuko du. Idatzitako 4 zenbakien aurretik 7 bat gehituko da.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Balioa ez da bakarra. Zenbaki hori beste bilera-gela batean erabiltzen ari da.';
$string['mod_form_field_wait'] = 'Itxaron moderatzaileari';
$string['mod_form_field_wait_help'] = 'Ikusleek moderatzailea bilera-gelan sartu arte itxaron beharko dute bertan sartu ahal izateko?';
$string['mod_form_field_welcome'] = 'Ongi-etorri mezua';
$string['mod_form_field_welcome_default'] = 'Ongietorri %%CONFNAME%%(e)ra.';
$string['mod_form_field_welcome_help'] = 'Ongi-etorri mezua parte-hartzaileak bilera-gelan sartzen direnean erakusten da. Eremua hutsik utziz gero, guneko kudeatzaileak zehaztutako mezu lehenetsia erakutsiko da.';
$string['mod_form_locksettings'] = 'Blokeatze-ezarpenak';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton online irakaskuntzarako diseinatutako kode irekiko web-konferentzietarako sistema bat da, eta denbora errealeko audioa, bideoa, txata, pantaila partekatzea, arbela partekatua, banaketa gelak, inkestak eta emojiak erabiltzea ahalbidetzen du.

BigBlueButton erabiliz online klaseak, telelana edo urruneko ikasleen taldekako kolaboraziorako saioak egiteko bilera-gela bat sortu dezakezu. Saioa grabatua izan daiteke beranduago ikusi ahal dadin.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBluButton jarduera';
$string['nosuchinstance'] = 'Ez dago {$a->entity} instantziarik {$a->id} IDarekin';
$string['notification_instance_created_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton bilera-gela sortu egin da.';
$string['notification_instance_created_small'] = '{$a->name} izeneko BigBlueButton bilera-gela berria sortu da';
$string['notification_instance_created_subject'] = 'BigBlueButton bilera-gela berria sortu da';
$string['notification_instance_description'] = 'Deskribapena';
$string['notification_instance_end_date'] = 'Amaiera-data';
$string['notification_instance_name'] = 'Izenburua';
$string['notification_instance_start_date'] = 'Hasiera-data';
$string['notification_instance_updated_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton bilera-gela eguneratua izan da.';
$string['notification_instance_updated_small'] = '{$a->name} BigBlueButton saioa eguneratu da';
$string['notification_instance_updated_subject'] = 'Zure BigBlueButton bilera-gela eguneratu da';
$string['notification_recording_ready_html'] = 'BigBlueButton-eko <b><a href="{$a->link}">{$a->name}</a></b> bilera-gelako saio baten grabazioa eskuragarri dago orain.';
$string['notification_recording_ready_plain'] = 'BigBlueButton-eko {$a->name} bilera-gelako saio baten grabazioa eskuragarri dago orain. Egin klik {$a->link} grabazioa ikusteko.';
$string['notification_recording_ready_small'] = 'BigBlueButton-eko {$a->name} bilera-gelaren grabazio bat dago eskuragarri.';
$string['notification_recording_ready_subject'] = 'Grabazioa eskuragarri';
$string['pluginadministration'] = 'BigBlueButton-en kudeaketa';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'BigBlueButton saioak sortzeko eta bertan sartzeko, zerbitzariarekin erabiltzaile-datuak trukatu behar dira.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'BigBlueButton zerbitzarian sartzen den erabiltzailearen izen osoa.';
$string['privacy:metadata:bigbluebutton:userid'] = 'BigBlueButton zerbitzarian sartzen den erabiltzailearen IDa.';
$string['privacy:metadata:bigbluebuttonbn'] = 'BigBlueButton saioaren konfigurazioa';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'BigBlueButton saioan parte hartzen duten erabiltzaileen rolen gida-lerroak. Erabiltzaile IDa gordeko da zeren baimena esleitu dakioke rolari edo erabiltzaileari.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Plugin erabiltzean aktibatzen diren gertaerak gordetzen ditu';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Erabiltzaileak sortutako gertaera mota.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Erabiltzailea sartu den saioaren IDa.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Saioaren edo haren grabazioaren inguruko informazio gehigarria.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Erregistroa sortu den ordua.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Saioa sortu duen erabiltzailearen IDa.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Grabazioen inguruko metadatuak gordetzen ditu.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'Grabazioa azkenengoz aldatu zueneko erabiltzailearen IDa.';
$string['progress_createbigbluebuttonbn'] = 'BigBlueButton jarduera ({$a}) sortzen';
$string['recordings_from_deleted_activities'] = 'Ezabatutako jardueren grabazioak';
$string['recordingurlnotfound'] = 'Grabazioaren URLa baliogabea da.';
$string['removedevents'] = 'Ezabatutako ekitaldiak';
$string['removedlogs'] = 'Ezabatutako erregistro pertsonalak';
$string['removedrecordings'] = 'Ezabatutako grabazioak';
$string['removedtags'] = 'Ezabatutako etiketak';
$string['report_join_info'] = '{$a} bilera';
$string['report_play_recording_info'] = '{$a} grabazio erreproduzitu dira';
$string['report_room_view'] = 'ikusita';
$string['resetevents'] = 'Ezabatu gertaerak';
$string['resetlogs'] = 'Ezabatu erregistro pertsonalizatuak';
$string['resetlogs_help'] = 'Erregistroak ezabatuz gero grabazioen erreferentziak galduko dira.';
$string['resetrecordings'] = 'Ezabatu grabazioak';
$string['resetrecordings_help'] = 'Grabazioak ezabatuz gero ezingo dira inon erabili. Ekintza honek ez du atzera bueltarik!';
$string['resettags'] = 'Ezabatu etiketak';
$string['search:activity'] = 'BigBlueButton - aktibitatearen informazioa';
$string['search:tags'] = 'BigBlueButton - etiketen informazioa';
$string['sendnotification'] = 'Bidali jakinarazpena';
$string['settings'] = 'BigBlueButton ezarpenak';
$string['started_at'] = 'Hasita';
$string['starts_at'] = 'Hasiera-data';
$string['subplugintype_bbbext'] = 'BigBlueButton jarduera hedapena';
$string['subplugintype_bbbext_plural'] = 'BigBlueButton jarduera hedapenak';
$string['taskname:check_dismissed_recordings'] = 'Bilatu oraindik aurkitu gabeko grabazioak';
$string['taskname:check_pending_recordings'] = 'Eskuratu zai dauden grabazioak';
$string['userlimitreached'] = 'Saioa baimendutako gehieneko erabiltzaile kopurura iritsi da.';
$string['view_conference_action_end'] = 'Amaitu saioa';
$string['view_conference_action_join'] = 'Sartu saioan';
$string['view_error_action_not_completed'] = 'Ekintza ezin da osatu';
$string['view_error_bigbluebutton'] = 'BigBlueButton-ek erroreekin erantzuten du. {$a}';
$string['view_error_create'] = 'BigBlueButton zerbitzariak errore mezuarekin erantzun du. Bilera-gela ezin izan da sortu.';
$string['view_error_current_state_not_found'] = 'Uneko egoera ezezaguna. Grabazioa ezabatu da edo BigBlueButton zerbitzaria ez da bateragarria gauzatutako ekintzarekin.';
$string['view_error_import_no_courses'] = 'Ez dago grabaketak bilatzeko ikastarorik.';
$string['view_error_import_no_recordings'] = 'Ikastaro honetan ez dago grabaziorik inportatzeko';
$string['view_error_invalid_session'] = 'Saioa amaitu da. Bueltatu jardueraren orrira.';
$string['view_error_max_concurrent'] = 'Aldi berean gauzatu daitezkeen saioen baimendutako gehienekora iritsi da.';
$string['view_error_meeting_not_running'] = 'Zerbaitek huts egin du; saioa ez dago martxan.';
$string['view_error_no_group'] = 'Oraindik ez dago talderik. Taldeak sortu behar dituzu saiora sartzen saiatu baino lehen.';
$string['view_error_no_group_student'] = 'Ez zaude inongo taldetan sartuta. Mesedez jarri harremanetan zure irakaslearekin.';
$string['view_error_no_group_teacher'] = 'Oraindik ez dago talderik. Taldeak sortu behar dituzu.';
$string['view_error_unable_join'] = 'Ezin izan da bilera-gelara sartu. Mesedez egiaztatu BigBlueButton zerbitzariaren URLa eta ziurtatu BigBlueButton zerbitzaria martxan dagoela.';
$string['view_error_unable_join_student'] = 'Ezin izan da BigBlueButton zerbitzariarekin konektatu.';
$string['view_error_unable_join_teacher'] = 'Ezin izan da BigBlueButton zerbitzariarekin konektatu. Mesedez kudeatzailearekin harremanetan jarri zaitez.';
$string['view_error_url_missing_parameters'] = 'URL honetan parametroak falta dira';
$string['view_error_userlimit_reached'] = 'Saio batean baimendutako gehieneko erabiltzaile kopurura iritsi da.';
$string['view_groups_nogroups_warning'] = 'Bilera-gela taldeak erabiltzeko konfiguratu da baina ikastaro honetan ez dago talderik sortuta.';
$string['view_groups_notenrolled_warning'] = 'Bilera-gela taldeak erabiltzeko konfiguratu da baina zu ez zara inongo taldeko kidea.';
$string['view_groups_selection'] = 'Aukera ezazu ze talderen partaide izan nahi duzun eta ekintza baieztatu ezazu';
$string['view_groups_selection_join'] = 'Sartu';
$string['view_groups_selection_warning'] = 'Talde bakoitzak bere bilera-gela du eta zu batera baino gehiagotako sarbidea duzu. Ziurtatu ezazu zuzena hautatzen duzula.';
$string['view_login_moderator'] = 'Saioan moderatzaile gisa sartzen...';
$string['view_login_viewer'] = 'Saioan ikusle gisa sartzen...';
$string['view_message_and'] = 'eta';
$string['view_message_conference_has_ended'] = 'Saioa bukatu da.';
$string['view_message_conference_in_progress'] = 'Saioa martxan dago.';
$string['view_message_conference_not_started'] = 'Saioa ez da hasi oraindik.';
$string['view_message_conference_room_ready'] = 'Bilera-gela hau prest dago. Orain saioan sartu zaitezke.';
$string['view_message_conference_user_limit_reached'] = 'Saio batean baimendutako gehieneko erabiltzaile kopurura iritsi da.';
$string['view_message_conference_wait_for_moderator'] = 'Moderatzailearen zain sartu ahal izateko.';
$string['view_message_cron_disabled'] = 'Baliteke grabazioen zerrenda eguneratu gabe egotea. Harremanetan jarri zaitez zure guneko kudeatzailearekin hurrengo informazioa helarazteko: {$a}';
$string['view_message_finished'] = 'Jarduera hau amaitu da.';
$string['view_message_has_joined'] = 'sartu da';
$string['view_message_have_joined'] = 'sartu dira';
$string['view_message_hour'] = 'ordu';
$string['view_message_hours'] = 'ordu';
$string['view_message_importrecordings_disabled'] = 'Grabazio-estekak inportatzea desgaituta dago zerbitzari honetan.';
$string['view_message_minute'] = 'minutu';
$string['view_message_minutes'] = 'minutu';
$string['view_message_moderator'] = 'Moderatzailea';
$string['view_message_moderators'] = 'Moderatzaileak';
$string['view_message_norecordings'] = 'Ez dago grabaziorik eskuragarri.';
$string['view_message_notavailableyet'] = 'Saio hau oraindik ez dago erabilgarri.';
$string['view_message_recordings_disabled'] = 'Grabazioak desgaituta daude zerbitzarian. \'Grabazioak soilik\' motako BigBlueButton jarduerak ezin dira erabili.';
$string['view_message_room_closed'] = 'Bilera-gela itxita dago.';
$string['view_message_room_open'] = 'Bilera-gela irekita dago.';
$string['view_message_room_ready'] = 'Bilera-gela prest dago.';
$string['view_message_session_for'] = 'saio honetarako';
$string['view_message_session_has_user'] = 'Bada';
$string['view_message_session_has_users'] = 'Badira';
$string['view_message_session_no_users'] = 'Saio honetan ez dago erabiltzailerik';
$string['view_message_session_running_for'] = 'Saio hau martxan egon da tarte honetan:';
$string['view_message_session_started_at'] = 'Saioaren hasiera-data:';
$string['view_message_tab_close'] = 'Fitxa/leiho hau eskuz itxi behar da';
$string['view_message_times'] = 'aldiz';
$string['view_message_user'] = 'Erabiltzailea';
$string['view_message_users'] = 'Erabiltzaileak';
$string['view_message_viewer'] = 'Ikuslea';
$string['view_message_viewers'] = 'Ikusleak';
$string['view_mobile_message_groups_not_supported'] = 'Instantzia hau taldeekin erabiltzeko konfiguratu da baina mobile aplikazioak oraindik ez du horrelakorik onartzen. Mesedez erabili web bertsioa.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Orri honetan 45 segundotik gora egon zara. Freskatu mesedez orria saioan sartu ahal izateko.';
$string['view_noguests'] = 'BigBlueButton bilera-gela ez dago irekita gonbidatuentzat.';
$string['view_nojoin'] = 'Ez duzu saio honetan sartzeko baimena duen rol bat.';
$string['view_recording'] = 'grabatzen';
$string['view_recording_actionbar'] = 'Tresna-barra';
$string['view_recording_activity'] = 'Jarduera';
$string['view_recording_button_import'] = 'Inportatu grabazioen estekak';
$string['view_recording_button_return'] = 'Egin atzera';
$string['view_recording_course'] = 'Ikastaroa';
$string['view_recording_date'] = 'Data';
$string['view_recording_delete_confirmation'] = 'Ziur zaude {$a} ezabatu nahi duzula?';
$string['view_recording_delete_confirmation_warning_p'] = 'Grabazio honek {$a} esteka ditu ikastaro edo jarduera desberdinetatik inportatuta. Grabazioa ezabatzen bada esteka hauek ere ezabatuko dira.';
$string['view_recording_delete_confirmation_warning_s'] = 'Grabazio honek {$a} esteka du ikastaro edo jarduera desberdin batetik inportatuta. Grabazioa ezabatzen bada esteka hau ere ezabatuko da.';
$string['view_recording_description'] = 'Deskribapena';
$string['view_recording_description_edithint'] = 'Grabazioa aurkitzeko lagungarria izango den deskribapen bat gehitu daiteke.';
$string['view_recording_description_editlabel'] = 'Editatu deskribapena';
$string['view_recording_duration'] = 'Iraupena';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'Grabazio formatu horren URL ezin da lortu.';
$string['view_recording_format_notes'] = 'Oharrak';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Aurkezpena';
$string['view_recording_format_screenshare'] = 'Pantaila-partekatzea';
$string['view_recording_format_statistics'] = 'Estatistikak';
$string['view_recording_format_video'] = 'Bideoa';
$string['view_recording_import_confirmation'] = 'Ziur zaude grabazio hau inportatu nahi duzula?';
$string['view_recording_length'] = 'Luzera';
$string['view_recording_link'] = 'inportatutako esteka';
$string['view_recording_link_warning'] = 'Esteka hau beste ikastaro edo jarduera batean sortutako grabaziora lotuta dago';
$string['view_recording_list_action_delete'] = 'Ezabatzen';
$string['view_recording_list_action_edit'] = 'Eguneratzen';
$string['view_recording_list_action_play'] = 'Erreproduzitu';
$string['view_recording_list_action_process'] = 'Prozesatzen';
$string['view_recording_list_action_protect'] = 'Babesten';
$string['view_recording_list_action_publish'] = 'Publikatzen';
$string['view_recording_list_action_unprotect'] = 'Babesa kentzen';
$string['view_recording_list_action_unpublish'] = 'Des-publikatzen';
$string['view_recording_list_action_update'] = 'Eguneratzen';
$string['view_recording_list_actionbar'] = 'Tresna-bara';
$string['view_recording_list_actionbar_delete'] = 'Ezabatu';
$string['view_recording_list_actionbar_edit'] = 'Editatu';
$string['view_recording_list_actionbar_hide'] = 'Ezkutatu';
$string['view_recording_list_actionbar_import'] = 'Inportatu';
$string['view_recording_list_actionbar_protect'] = 'Pribatua egin';
$string['view_recording_list_actionbar_publish'] = 'Publikatu';
$string['view_recording_list_actionbar_show'] = 'Erakutsi';
$string['view_recording_list_actionbar_unprotect'] = 'Publikoa egin';
$string['view_recording_list_actionbar_unpublish'] = 'Des-publikatu';
$string['view_recording_list_activity'] = 'Jarduera';
$string['view_recording_list_course'] = 'Ikastaroa';
$string['view_recording_list_date'] = 'Data';
$string['view_recording_list_description'] = 'Deskribapena';
$string['view_recording_list_duration'] = 'Iraupena';
$string['view_recording_list_recording'] = 'Grabaketa';
$string['view_recording_meeting'] = 'Bilera';
$string['view_recording_modal_button'] = 'Aplikatu';
$string['view_recording_modal_title'] = 'Ezarri grabaziorako balioak';
$string['view_recording_name'] = 'Izena';
$string['view_recording_name_edithint'] = 'Grabazioa aurkitzeko lagungarria izango den izen bat gehitu daiteke.';
$string['view_recording_name_editlabel'] = 'Editatu izena';
$string['view_recording_playback'] = 'Erreproduzitu';
$string['view_recording_preview'] = 'Aurrebista';
$string['view_recording_preview_help'] = 'Jarri kurtsorea irudi baten gainean tamaina osoan ikusteko';
$string['view_recording_protect_confirmation'] = 'Ziur zaude {$a} hau babestu nahi duzula?';
$string['view_recording_protect_confirmation_warning_p'] = 'Grabazio honek inportatutako ikastaro ala jarduera ezberdinekin lotutako {$a} esteka ditu. Grabazioa babestuta badago inportatutako estekei ere eragingo die.';
$string['view_recording_protect_confirmation_warning_s'] = 'Grabazio honek inportatutako ikastaro ala jarduera batekin lotutako esteka {$a} du. Grabazioa babestuta badago inportatutako estekei ere eragingo die.';
$string['view_recording_publish_confirmation'] = 'Ziur zaude {$a} hau argitaratu nahi duzula?';
$string['view_recording_publish_confirmation_warning_p'] = 'Grabazio honek inportatutako ikastaro ala jarduera ezberdinekin lotutako {$a} esteka ditu. Grabazioa argitaratzen bada esteka horiek ere argitaratuko dira.';
$string['view_recording_publish_confirmation_warning_s'] = 'Grabazio honek inportatutako ikastaro ala jarduera batekin lotutako esteka {$a} du. Grabazioa argitaratzen bada esteka hori ere argitaratuko da.';
$string['view_recording_publish_link_deleted'] = 'Esteka hau ezin da berriz publikatu jatorrizko grabazioa ez dagoelako BigBlueButton zerbitzarian. Esteka kendu beharko litzateke.';
$string['view_recording_publish_link_not_published'] = 'Esteka hau ezin da berriz publikatu jatorrizko grabazioa ez dagoelako publiko.';
$string['view_recording_recording'] = 'Grabatzen';
$string['view_recording_select_course'] = 'Aurretik ikastaro bat aukeratu ezazu zabaltzen den menuan';
$string['view_recording_tags'] = 'Etiketak';
$string['view_recording_unprotect_confirmation'] = 'Ziur zaude {$a} honi babesa kendu nahi diozula?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Grabazio honek inportatutako ikastaro ala jarduera ezberdinekin lotutako {$a} esteka ditu. Grabazioari babesa kentzen bazaio inportatutako estekei ere eragingo die.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Grabazio honek inportatutako ikastaro ala jarduera batekin lotutako esteka {$a} du. Grabazioari babesa kentzen bazaio inportatutako estekari ere eragingo dio.';
$string['view_recording_unprotect_link_deleted'] = 'Esteka honi ezin zaio babesa kendu jatorrizko grabazioa ez dagoelako BigBlueButton zerbitzarian. Esteka kendu beharko litzateke.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Esteka honi ezin zaio babesa kendu jatorrizko grabazioa babestuta dagoelako';
$string['view_recording_unpublish_confirmation'] = 'Ziur zaude {$a} hau des-publikatu nahi duzula?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Grabazioak {$a} esteka ditu ikastaro edo jarduera desberdinetatik inportatuta. Grabazioa des-publikatzen bada esteka hauek ere des-publikatuko dira.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Grabazioak {$a} esteka ditu ikastaro edo jarduera desberdin batetik inportatuta. Grabazioa des-publikatzen bada esteka hauek ere des-publikatuko dira.';
$string['view_recording_yui_first'] = 'Lehenengoa';
$string['view_recording_yui_go'] = 'Joan';
$string['view_recording_yui_last'] = 'Azkena';
$string['view_recording_yui_next'] = 'Hurrengoa';
$string['view_recording_yui_page'] = 'Orria';
$string['view_recording_yui_prev'] = 'Aurrekoa';
$string['view_recording_yui_rows'] = 'Errenkadak';
$string['view_recording_yui_show_all'] = 'Erakutsi dena';
$string['view_room'] = 'Ikusi bilera-gela';
$string['view_section_title_presentation'] = 'Aurkezpenaren fitxategia';
$string['view_section_title_recordings'] = 'Grabazioak';
$string['view_warning_default_server'] = 'Gune honek Blindside Networks-ek eskainitako <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">Moodlerako doako BigBlueButton zerbitzurako (leiho berrian zabaltzen da)</a>, eta hurrengo mugak ditu:
<ol>
<li>Saio bakoitzaren iraupena gehienez 60 minutukoa izan daiteke</li>
<li>Saio bakoitzeko parte-hartzaileak gehienez 25 izan daitezke</li>
<li>Grabazioak zazpi (7) egunen buruan iraungitzen dira eta ezin dira deskargatu</li>
<li>Ikasleen web-kamerak moderatzaileak baino ez ditu ikusiko.</li>
</ol>';
$string['waitformoderator'] = 'Moderatzailearen zain bileran sartzeko.';
