<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_ldap', language 'sk', version '4.3'.
 *
 * @package     enrol_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assignrole'] = 'Priraďuje sa rola \'{$a->role_shortname}\' používateľovi \'{$a->user_username}\' do kurzu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['assignrolefailed'] = 'Nepodarilo sa priradiť rolu \'{$a->role_shortname}\' používateľovi \'{$a->user_username}\' do kurzu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['autocreate'] = '<p>Kurzy môžu byť vytvárané automaticky, ak existujú zápisy do kurzov, ktoré ešte neexistujú v Moodle.</p><p>Ak využívate automatické vytvorenie kurzu, doporučuje sa, aby ste odstránili nasledovné schopnosti zo zodpovedajúcich rol, aby sa zabránilo zmenám v štyroch poliach kurzu (ID kurzu, krátke meno, plné meno a sumár): moodle/course:changeidnumber, moodle/course:changeshortname, moodle/course:changefullname a moodle/course:changesummary.</p>';
$string['autocreate_key'] = 'Automaticky vytvoriť';
$string['autocreation_settings'] = 'Nastavenia automatického vytvárania kurzov';
$string['autoupdate_settings'] = 'Nastavenia automatickej aktualizácie kurzu';
$string['autoupdate_settings_desc'] = '<p>Zvoľte polia na aktualizáciu, keď je spustený skript synchronizácie „Synchronizovať zápisy LDAP“.</p><p>Keď je vybrané aspoň jedno pole, nastane aktualizácia.</p>';
$string['bind_dn'] = 'Ak chcete použiť spoluužívateľa na vyhľadávanie používateľov, definujte to tu. Niečo ako: \'cn=ldapuser,ou=public,o=org\'';
$string['bind_dn_key'] = 'DN pre používateľa pre pripojenie';
$string['bind_pw'] = 'Heslo pre používateľa pre pripojenie.';
$string['bind_pw_key'] = 'Heslo';
$string['bind_settings'] = 'Nastavenia pripojenia';
$string['cannotcreatecourse'] = 'Nie je možné vytvoriť kurz: chýbajú požadované údaje v LDAP zázname!';
$string['cannotupdatecourse'] = 'Kurz sa nedá aktualizovať: chýbajú povinné dáta z LDAP záznamu! ID číslo kurzu: "{$a->idnumber}"';
$string['cannotupdatecourse_duplicateshortname'] = 'Kurz sa nedá aktualizovať: Duplicitný skrátený názov. Vynecháva sa kurz s ID číslom "{$a->idnumber}"...';
$string['category'] = 'Kategória pre automaticky vytvorené kurzy.';
$string['category_key'] = 'Kategória';
$string['contexts'] = 'Kontexty LDAP';
$string['couldnotfinduser'] = 'Nemožno nájsť užívateľa \'{$a}\', preskakujem';
$string['course_fullname'] = 'Nepovinné: LDAP pole, z ktorého sa má vybrať celé meno používateľa.';
$string['course_fullname_key'] = 'Celé meno používateľa';
$string['course_fullname_updateonsync'] = 'Aktualizovať plný názov počas skriptu synchronizácie';
$string['course_fullname_updateonsync_key'] = 'Aktualizovať plný názov';
$string['course_idnumber'] = 'Mapovanie jednoznačného identifikátora v LDAP, obyčajne  \'cn\' alebo \'uid\'.';
$string['course_idnumber_key'] = 'Identifikátor kurzu';
$string['course_search_sub'] = 'Vyhľadať príslušenstvo v skupinách v nižších kontextoch';
$string['course_search_sub_key'] = 'Hľadať v nižších kontextoch';
$string['course_settings'] = 'Nastavenia zápisov do kurzov';
$string['course_shortname'] = 'Nepovinné: LDAP pole, z ktorého sa má vybrať skrátené menou používateľa.';
$string['course_shortname_key'] = 'Krátke meno';
$string['course_shortname_updateonsync'] = 'Aktualizovať skrátený názov počas skriptu synchronizácie';
$string['course_shortname_updateonsync_key'] = 'Aktualizovať skrátený názov';
$string['course_summary'] = 'Nepovinné: LDAP pole, z ktorého sa má vybrať súhrn.';
$string['course_summary_key'] = 'Súhrn';
$string['course_summary_updateonsync'] = 'Aktualizovať zhrnutie počas skriptu synchronizácie';
$string['course_summary_updateonsync_key'] = 'Aktualizovať zhrnutie';
$string['coursenotexistskip'] = 'Kurz \'{$a}\' neexistuje a automatické vytváranie nie je povolené, preskakujem';
$string['courseupdated'] = 'Kurz s ID číslom \'{$a->idnumber}\' bol úspešne aktualizovaný.';
$string['courseupdateskipped'] = 'Kurz s ID číslom \'{$a->idnumber}\' si nevyžaduje aktualizáciu. Vynecháva sa ...';
$string['createcourseextid'] = 'Vytvorený používateľ bol zapísaný do neexistujúceho kurzu \'{$a->courseextid}\'';
$string['createnotcourseextid'] = 'Používateľ bol zapísaný do neexistujúceho kurzu \'{$a->courseextid}\'';
$string['creatingcourse'] = 'Vytvára sa kurz \'{$a}\' ...';
$string['duplicateshortname'] = 'Vytvorenie kurzu sa nepodarilo. Duplicitný skrátený názov. Vynecháva sa kurz s ID číslom \'{$a->idnumber}\'...';
$string['editlock'] = 'Uzamknúť hodnotu';
$string['emptyenrolment'] = 'Prázdny zápis pre rolu \'{$a->role_shortname}\' v kurze \'{$a->course_shortname}\'';
$string['enrolname'] = 'LDAP (Lightweight Directory Access Protocol)';
$string['enroluser'] = 'Zapísať používateľa \'{$a->user_username}\' do kurzu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['enroluserenable'] = 'Povolený zápis používateľa \'{$a->user_username}\' do kurzu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['explodegroupusertypenotsupported'] = 'funkcia ldap_explode_group() nepodporuje vybraný typ používateľa: {$a}';
$string['extcourseidinvalid'] = 'Externý identifikátor kurzu je neplatný!';
$string['extremovedsuspend'] = 'Zablokovaný zápis používateľa \'{$a->user_username}\' do kurzu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedsuspendnoroles'] = 'Zablokovaný zápis a odstránené roly pre používateľa \'{$a->user_username}\' v kurze \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedunenrol'] = 'Odhlásiť používateľa \'{$a->user_username}\' z kurzu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['failed'] = 'Operácia sa nepodarila!';
$string['general_options'] = 'Všeobecné nastavenia';
$string['group_memberofattribute'] = 'Názov atribútu, ktorý určuje, do ktorých skupín patrí zadaný používateľ alebo skupina (napr. memberOf, groupMembership a podobne) ';
$string['group_memberofattribute_key'] = 'Atribút \'Member of\'';
$string['host_url'] = 'Špecifikujte hosťovský LDAP v URL forme, napr:  \'ldap://ldap.myorg.com/\'
alebo \'ldaps://ldap.myorg.com/\'';
$string['host_url_key'] = 'Hostiteľské URL';
$string['idnumber_attribute'] = 'Ak príslušenstvo k skupine obsahuje DN (distunguished names), určte rovnaký atribút, ako ste použili pre používateľské mapovanie \'ID Number\' v LDAP nastaveniach autentifikácie';
$string['idnumber_attribute_key'] = 'Atribút ID číslo';
$string['ldap:manage'] = 'Spravovať inštancie LDAP zápisu do kurzov';
$string['ldap_encoding'] = 'Určte kódovanie používané LDAP serverom. S najväčšou pravdepodobnosťou utf-8, MS AD v2 používa predvolené kódovanie platformy, ako je CP1252, cp1250, atď.';
$string['ldap_encoding_key'] = 'LDAP kódovanie';
$string['memberattribute'] = 'Atribút členstva (member) v LDAP';
$string['memberattribute_isdn'] = 'Ak členstvo v skupine obsahuje distinguised meno, musíte ho zadať sem. Ak áno, musíte tiež nakonfigurovať zostávajúce nastavenia tejto sekcie';
$string['memberattribute_isdn_key'] = 'Členský atribút používa dn';
$string['nested_groups'] = 'Chcete použiť vnorené skupiny (skupiny v skupinách), pre zápis do kurzov?';
$string['nested_groups_key'] = 'Vnorené skupiny';
$string['nested_groups_settings'] = 'Nastavenia vnorených skupín';
$string['nosuchrole'] = 'Rola \'{$a}\' neexistuje';
$string['objectclass'] = 'Na vyhľadávanie kurzov sa používa objectClass. Obyčajne \'group\' alebo \'posixGroup\'.';
$string['objectclass_key'] = 'Trieda objektov';
$string['ok'] = 'OK!';
$string['opt_deref'] = 'Ak členstvo v skupine obsahuje distinguished meno, určte, ako sú aliasy spracované v priebehu hľadania. Vyberte jednu z nasledujúcich hodnôt: \'Nie\' (LDAP_DEREF_NEVER) alebo \'Áno\' (LDAP_DEREF_ALWAYS)';
$string['opt_deref_key'] = 'Dereferencovať aliasy';
$string['phpldap_noextension'] = 'PHP LDAP modul sa nezdá byť prítomný. Prosím, uistite sa, že je nainštalovaný a povolený, ak chcete používať tento zápisný zásuvný modul.';
$string['pluginname'] = 'LDAP zápisy';
$string['pluginname_desc'] = '<p>Na kontrolu Vašich zápisov, môžete použiť LDAP server. Predpokladom je, že Váš LDAP strom obsahuje skupiny, ktoré mapujú kurzy a každá z týchto skupín/kurzov obsahuje záznamy o používateľoch, ktoré mapujú študentov.</p>
<p>Predpokladá sa, že kurzy sú definované ako skupiny v LDAP a každá skupina má viacero používateľských polí (<em>member</em> alebo <em>memberUid</em>), ktoré zabezpečujú jednoznačnú identifikáciu používateľa.</p>
<p>Aby ste mohli použiť LDAP zapisovanie, Vaši používatelia  <strong>musia</strong> mať platné pole idnumber. LDAP skupiny musia mať idnumber v poliach pre používateľa, aby sa mohli zapisovať do kurzov. Toto bude pravdepodobne fungovať bez problémov, ak už používate LDAP Autentifikáciu.</p>
<p>Zápisy sa budú aktualizovať, keď sa používateľ prihlási. Na synchronizáciu uchovávania zápisov, môžete použiť aj skript. Pozrite sa do  <em>enrol/ldap/enrol_ldap_sync.php</em>.</p>
<p>Tento plugin môže byť nastavený na automatické vytváranie nových kurzov, ak sa objavia nové skupiny v LDAP.</p>';
$string['pluginnotenabled'] = 'Zásuvný modul nie je povolený!';
$string['privacy:metadata'] = '';
$string['role_mapping'] = '<p>Pre každú rolu, ktorú chcete priradiť z LDAP musíte zadať zoznam kontextov, kde sa nachádzajú roly kurzových skupín. Jednotlivé kontexty oddeľujte bodkočiarkou.</p><p>Tiež potrebujete zadať atribút, ktorý váš LDAP server používa pre členov skupiny. Obyčajne sa jedná o \'member\' alebo \'memberUid\'</p>';
$string['role_mapping_attribute'] = 'LDAP členský atribút pre {$a}';
$string['role_mapping_context'] = 'LDAP kontexty pre {$a}';
$string['role_mapping_key'] = 'Mapovať roly z LDAP';
$string['roles'] = 'Mapovanie rol';
$string['server_settings'] = 'Nastavenia LDAP servera';
$string['synccourserole'] = '== Synchronizuje sa kurz \'{$a->idnumber}\' s rolou \'{$a->role_shortname}\'';
$string['syncenrolmentstask'] = 'Úloha synchronizácie zápisov LDAP';
$string['template'] = 'Nepovinné: Pri automaticky vytváraných kurzoch sa môžu ich nastavenia kopírovať zo šablóny kurzu.';
$string['template_key'] = 'Šablóna kurzov';
$string['unassignrole'] = 'Odoberám rolu \'{$a->role_shortname}\' používateľovi \'{$a->user_username}\' z kurzu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignrolefailed'] = 'Nepodarilo sa odobrať rolu \'{$a->role_shortname}\' používateľovi \'{$a->user_username}\' z kurzu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignroleid'] = 'Odoberám ID roly \'{$a->role_id}\' ID používateľa \'{$a->user_id}\'';
$string['updatelocal'] = 'Aktualizovať miestne údaje';
$string['user_attribute'] = 'Ak členstvo v skupine obsahuje distinguised names, určte atribút použitý pre meno/vyhľadávanie používateľov. Ak používate LDAP autentifikáciu, tento atribút by mal byť zhodný s mapovaním \'ID Number\' v LDAP autentifikačnom zásuvnom module.';
$string['user_attribute_key'] = 'Atribút ID číslo';
$string['user_contexts'] = 'Ak príslušenstvo k skupinám obsahuje distinguished names, musíte zadať zoznam LDAP kontextov, kde sa nachádzajú používatelia. Jednotlivé kontexty oddeľujte bodkočiarkou. Napríklad: \'ou=users,o=org; ou=others,o=org\'';
$string['user_contexts_key'] = 'Kontexty';
$string['user_search_sub'] = 'Ak príslušenstvo k skupinám obsahuje distinguished names, určte, či vyhľadávanie používateľov má byť vykonané aj v subkontextoch.';
$string['user_search_sub_key'] = 'Vyhľadávať v subkontextoch';
$string['user_settings'] = 'Nastavenia vyhľadávania používateľov';
$string['user_type'] = 'Ak príslušenstvo k skupinám obsahuje distinguished mená, určte ako sú v LDAP uložení používatelia';
$string['user_type_key'] = 'Typ používateľa';
$string['version'] = 'Verzia LDAP protokolu, ktorú používa Váš server.';
$string['version_key'] = 'Verzia';
